/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.debugcomponent.ClassDebugInfo;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class DebugComponent
extends Component {
    private int package_index;
    private JcPackage jc_package;
    ClassDebugInfo[] classes;
    Vector utf8_strings;

    public DebugComponent(JcPackage jc_package) {
        super(12, "debug");
        this.jc_package = jc_package;
        this.build();
    }

    private void build() {
        this.utf8_strings = new Vector(20, 10);
        this.package_index = this.addString(this.jc_package.getPackageName());
        JcClass[] jc_classes = this.jc_package.getClasses();
        this.classes = new ClassDebugInfo[jc_classes.length];
        int i = 0;
        while (i < jc_classes.length) {
            this.classes[i] = new ClassDebugInfo(jc_classes[i], this);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        int tab_level = 0;
        sb.append("String_count " + this.utf8_strings.size() + "\n");
        int i = 0;
        while (i < this.utf8_strings.size()) {
            sb.append("\tutf8_info { \n");
            String utf8_string = (String)this.utf8_strings.elementAt(i);
            try {
                byte[] utf8_bytes = utf8_string.getBytes("UTF8");
                sb.append("\t\tutf8_string " + utf8_string + "\n");
                sb.append("\t\tutf8_bytes_length " + utf8_bytes.length + "\n");
                sb.append("\t\tutf8_bytes: \n");
                sb.append("\t\t\t");
                int j = 0;
                while (j < utf8_bytes.length) {
                    sb.append(utf8_bytes[j]);
                    if (j != utf8_bytes.length - 1) {
                        sb.append(":");
                    }
                    if ((j + 1) % 10 == 0) {
                        sb.append("\n\t\t\t");
                    }
                    ++j;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            sb.append("\n\t}\n");
            ++i;
        }
        sb.append("\tpackage_name_index " + this.package_index + "\t\t//" + this.jc_package.getPackageName() + "\n");
        sb.append("\tclass_count " + this.classes.length + "\n");
        int i2 = 0;
        while (i2 < this.classes.length) {
            sb.append(this.classes[i2].toString(tab_level + 1) + "\n");
            ++i2;
        }
        sb.append("}\n");
        return sb.toString();
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeShort(this.utf8_strings.size());
            int i = 0;
            while (i < this.utf8_strings.size()) {
                String utf8_string = (String)this.utf8_strings.elementAt(i);
                byte[] utf8Bytes = utf8_string.getBytes("UTF8");
                dos.writeShort(utf8Bytes.length);
                dos.write(utf8Bytes, 0, utf8Bytes.length);
                ++i;
            }
            dos.writeShort(this.package_index);
            dos.writeShort(this.classes.length);
            int i2 = 0;
            while (i2 < this.classes.length) {
                this.classes[i2].toBinary(dos);
                ++i2;
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public int addString(String a_string) {
        int i = 0;
        while (i < this.utf8_strings.size()) {
            String this_string = (String)this.utf8_strings.elementAt(i);
            if (this_string.equals(a_string)) {
                return i;
            }
            ++i;
        }
        this.utf8_strings.addElement(a_string);
        return this.utf8_strings.size() - 1;
    }

    public int dataSize() {
        int size = 0;
        int i = 0;
        while (i < this.classes.length) {
            size += this.classes[i].getSize();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.utf8_strings.size()) {
            String utf8_string = (String)this.utf8_strings.elementAt(i2);
            try {
                byte[] utf8_bytes = utf8_string.getBytes("UTF8");
                size = size + 2 + utf8_bytes.length;
            }
            catch (UnsupportedEncodingException w) {
                throw new ConverterInternalError(w.getMessage());
            }
            ++i2;
        }
        return size + 6;
    }
}

