/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

public class Apdu {
    public static final int CLA = 0;
    public static final int INS = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;
    public static final int P3 = 4;
    public static final int CASE_1 = 1;
    public static final int CASE_2S = 2;
    public static final int CASE_3S = 3;
    public static final int CASE_4S = 4;
    public static final int CASE_2E = 5;
    public static final int CASE_3E = 6;
    public static final int CASE_4E = 7;
    static final int CMD_HDR_BYTES = 4;
    public byte[] command = new byte[5];
    public int Lc = 0;
    public byte[] dataIn = null;
    public int Le = 0;
    public byte[] dataOut = null;
    public byte[] sw1sw2 = new byte[2];

    private static String byteHexString(int data) {
        StringBuffer sb = new StringBuffer();
        if ((data & 0xFF) < 16) {
            sb.append("0");
        }
        sb.append(Integer.toHexString(data & 0xFF));
        return sb.toString();
    }

    public int getCase() {
        if (this.Lc == 0 && this.Le >= 0 && this.Le < 256) {
            return 2;
        }
        if (this.Lc == 0 && this.Le > 256) {
            return 5;
        }
        if (this.Lc > 256 && this.Le == 0) {
            return 6;
        }
        if (this.Lc > 0 && this.Lc <= 255 && this.Le >= 0 && this.Le < 256) {
            return 4;
        }
        return 7;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public byte[] getCommandApduBytes() {
        byte[] newApdu = new byte[5 + this.Lc + 1];
        System.arraycopy(this.command, 0, newApdu, 0, 4);
        newApdu[4] = (byte)this.Lc;
        if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, newApdu, 5, this.Lc);
        }
        newApdu[5 + this.Lc] = (byte)this.Le;
        return newApdu;
    }

    public byte[] getDataIn() {
        return this.dataIn;
    }

    public byte[] getDataOut() {
        return this.dataOut;
    }

    public int getLc() {
        return this.Lc;
    }

    public int getLe() {
        return this.Le;
    }

    public byte[] getResponseApduBytes() {
        byte[] newApdu = new byte[5 + this.Lc + 1 + this.Le + 2];
        System.arraycopy(this.command, 0, newApdu, 0, 4);
        newApdu[this.command.length] = (byte)this.Lc;
        if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, newApdu, 5, this.Lc);
        }
        newApdu[this.command.length + 1 + this.Lc] = (byte)this.Le;
        if (this.dataOut.length != 0) {
            System.arraycopy(this.dataOut, 0, newApdu, 5 + this.Lc + 1, this.Le);
        }
        System.arraycopy(this.sw1sw2, 0, newApdu, newApdu.length - 2, 2);
        return newApdu;
    }

    public int getStatus() {
        return (this.sw1sw2[0] << 8 | this.sw1sw2[1]) & 0xFFFF;
    }

    public byte[] getSw1Sw2() {
        return this.sw1sw2;
    }

    public void setDataIn(byte[] dataIn) {
        this.dataIn = dataIn;
        this.Lc = dataIn == null ? 0 : dataIn.length;
    }

    public void setDataIn(byte[] dataIn, int length) {
        this.dataIn = dataIn;
        this.Lc = length;
    }

    public void setDataOut(byte[] dataOut) {
        this.dataOut = dataOut;
        this.Le = dataOut == null ? 0 : dataOut.length;
    }

    public void setDataOut(byte[] dataOut, int length) {
        this.dataOut = dataOut;
        if (dataOut == null && length > 0) {
            throw new IllegalArgumentException();
        }
        if (dataOut.length < length) {
            throw new IllegalArgumentException();
        }
        this.Le = length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CLA: " + Apdu.byteHexString(this.command[0]) + ", ");
        sb.append("INS: " + Apdu.byteHexString(this.command[1]) + ", ");
        sb.append("P1: " + Apdu.byteHexString(this.command[2]) + ", ");
        sb.append("P2: " + Apdu.byteHexString(this.command[3]) + ", ");
        sb.append("Lc: " + Apdu.byteHexString(this.Lc));
        int i = 0;
        while (i < this.Lc) {
            sb.append(", " + Apdu.byteHexString(this.dataIn[i]));
            ++i;
        }
        sb.append(", Le: " + Apdu.byteHexString(this.Le));
        if (this.dataOut != null) {
            int i2 = 0;
            while (i2 < this.Le) {
                if (i2 >= this.dataOut.length) break;
                sb.append(", " + Apdu.byteHexString(this.dataOut[i2]));
                ++i2;
            }
        }
        sb.append(", SW1: " + Apdu.byteHexString(this.sw1sw2[0]));
        sb.append(", SW2: " + Apdu.byteHexString(this.sw1sw2[1]));
        return sb.toString();
    }
}

