/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class TypeDescriptorInfo {
    protected int token;
    protected TypeDescriptorEntry[] constantPoolTypes;
    protected Vector<TypeDescriptorEntry> descVector;
    protected int descOffset;
    private int descBase;

    TypeDescriptorInfo(JCPackage pkg) {
        ConstantPool constantPool = pkg.getConstantPool();
        this.constantPoolTypes = new TypeDescriptorEntry[constantPool.getCount()];
        this.descVector = new Vector(constantPool.getCount());
        this.descBase = this.descOffset = 2 + constantPool.getCount() * 2;
        for (int i = 0; i < this.constantPoolTypes.length; ++i) {
            Info info = constantPool.getConstantPoolEntry(i);
            if (info.getType() == 1) continue;
            TypeDescriptorEntry desc = new TypeDescriptorEntry(pkg, info, this.descOffset);
            int index = this.descVector.indexOf(desc);
            if (index != -1) {
                desc = this.descVector.elementAt(index);
            } else {
                this.descVector.addElement(desc);
                this.descOffset += desc.size();
            }
            this.constantPoolTypes[i] = desc;
        }
        Enumeration<JCClass> e = pkg.classElements();
        while (e.hasMoreElements()) {
            int index;
            TypeDescriptorEntry desc;
            JCClass c = e.nextElement();
            Enumeration<JCMethod> g = c.methodElements();
            while (g.hasMoreElements()) {
                JCMethod m = g.nextElement();
                desc = new TypeDescriptorEntry(m, this.descOffset);
                index = this.descVector.indexOf(desc);
                if (index != -1) continue;
                this.descVector.addElement(desc);
                this.descOffset += desc.size();
            }
            Enumeration<Field> h = c.fieldElements();
            while (h.hasMoreElements()) {
                Field f = h.nextElement();
                if (f.getDescriptor().isPrimitive() || (index = this.descVector.indexOf(desc = new TypeDescriptorEntry(f, this.descOffset))) != -1) continue;
                this.descVector.addElement(desc);
                this.descOffset += desc.size();
            }
        }
    }

    int getOffset(JCMethod m) {
        TypeDescriptorEntry desc = new TypeDescriptorEntry(m, this.descOffset);
        int index = this.descVector.indexOf(desc);
        if (index == -1) {
            this.descVector.addElement(desc);
            this.descOffset += desc.size();
        } else {
            desc = this.descVector.elementAt(index);
        }
        return desc.getOffset();
    }

    int getOffset(Field f) {
        TypeDescriptorEntry desc = new TypeDescriptorEntry(f, this.descOffset);
        int index = this.descVector.indexOf(desc);
        if (index == -1) {
            this.descVector.addElement(desc);
            this.descOffset += desc.size();
        } else {
            desc = this.descVector.elementAt(index);
        }
        return desc.getOffset();
    }

    int size() {
        int size = 2 + this.constantPoolTypes.length * 2;
        for (TypeDescriptorEntry desc : this.descVector) {
            size += desc.size();
        }
        return size;
    }

    byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort(this.constantPoolTypes.length);
            for (TypeDescriptorEntry element : this.constantPoolTypes) {
                if (element == null) {
                    dos.writeShort(65535);
                    continue;
                }
                dos.writeShort(element.getOffset());
            }
            for (TypeDescriptorEntry desc : this.descVector) {
                byte[] array = desc.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("constant_pool_count: " + this.constantPoolTypes.length + Msg.eol);
        for (i = 0; i < this.constantPoolTypes.length; ++i) {
            if (i % 10 == 0) {
                sb.append("[" + i + "] ");
            }
            if (this.constantPoolTypes[i] == null) {
                sb.append(" " + Msg.toHexString((short)-1));
            } else {
                sb.append(" " + Msg.toHexString((short)this.constantPoolTypes[i].getOffset()));
            }
            if (i % 10 != 9) continue;
            sb.append(Msg.eol);
        }
        if (i % 10 != 0) {
            sb.append(Msg.eol);
        }
        sb.append("type_desc[]: " + Msg.eol);
        int offset = this.descBase;
        for (TypeDescriptorEntry desc : this.descVector) {
            sb.append("[" + Msg.toHexString((short)offset) + "] " + desc + Msg.eol);
            offset += desc.size();
        }
        return sb.toString();
    }
}

