/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.scriptgen;

import com.sun.javacard.scriptgen.Download;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CAP {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int PKG_MINOR_NUM = 10;
    public static final int PKG_MAJOR_NUM = 11;
    public static final int PKG_AID_LEN = 12;
    public static int NumberOfComponents = 0;
    private static ResourceBundle msg;
    private String pkgName;
    private ZipFile zipFile;
    private ZipEntry[] components;
    private boolean[] seenList;
    private int numberOfCustomComponents;
    private PrintWriter scriptWriter = new PrintWriter(System.out, true);
    private PrintWriter logWriter = new PrintWriter(System.err, true);
    private boolean capVerified;
    private byte f_flags;
    private boolean noBeginEnd;

    public CAP(String capPath, PrintWriter log, ResourceBundle msg, String pkgName) throws Exception {
        this.logWriter = log;
        this.capVerified = false;
        CAP.msg = msg;
        this.pkgName = pkgName;
        try {
            this.zipFile = new ZipFile(capPath);
            NumberOfComponents = this.zipFile.size();
            this.components = new ZipEntry[NumberOfComponents + 10];
            this.seenList = new boolean[NumberOfComponents + 10];
        }
        catch (Exception e) {
            Object[] msgArgs = new Object[]{e.toString()};
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.constructor"), msgArgs));
            throw new Exception();
        }
    }

    public int genScript(PrintWriter out) {
        this.scriptWriter = out;
        return this.genScript();
    }

    public int genScript(PrintWriter out, boolean noBE) {
        this.scriptWriter = out;
        this.noBeginEnd = noBE;
        return this.genScript();
    }

    public int genScript() {
        if (this.zipFile == null) {
            return 1;
        }
        if (!this.capVerified && this.verifyCAP() != 0) {
            return 1;
        }
        this.genBeginCAP("");
        for (int i = 1; i < Download.DOWNLOAD_ORDER.length; ++i) {
            if (i == Download.DOWNLOAD_ORDER[11]) continue;
            if (this.components[i] == null) {
                if (i == Download.DOWNLOAD_ORDER[3] && (this.f_flags & 4) != 4 || i == Download.DOWNLOAD_ORDER[10] && (this.f_flags & 2) != 2) continue;
                Object[] msgArgs = new Object[]{new Integer(Download.ORDER_TO_TAG[i])};
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.missingComp"), msgArgs));
                return 1;
            }
            if (this.genComponent(this.zipFile, this.components[i], Download.ORDER_TO_TAG[i]) == 0) continue;
            return 1;
        }
        this.genEOF();
        return 0;
    }

    public int verifyCAP() {
        if (this.capVerified) {
            return 0;
        }
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (this.sortComponent(ze, this.components) == 0) continue;
            return 1;
        }
        if (this.verifyHeader(this.zipFile, this.components[Download.DOWNLOAD_ORDER[1]]) != 0) {
            return 1;
        }
        this.capVerified = true;
        return 0;
    }

    public int verifyHeader(ZipFile jf, ZipEntry header) {
        int status = 0;
        byte aidLength = 0;
        Object[] msgArgs = new Object[]{header.getName()};
        try {
            short len;
            InputStream in = jf.getInputStream(header);
            byte[] line = new byte[286];
            int size = in.read(line);
            if (size <= 0) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.read1"), msgArgs));
                status = 1;
                in.close();
                return status;
            }
            if (line[0] != 1) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.tag1"), msgArgs));
                status = 1;
            }
            if ((len = (short)((line[1] << 8) + (line[2] & 0xFF))) != size - 3) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.size1"), msgArgs));
                status = 1;
            }
            if (line[3] != -34 || line[4] != -54 || line[5] != -1 || line[6] != -19) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.magic"), msgArgs));
                status = 1;
            }
            if (line[7] > 2) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.minor"), msgArgs));
                status = 1;
            }
            if (line[8] > 2) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.major"), msgArgs));
                status = 1;
            }
            this.f_flags = line[9];
            if ((this.f_flags & 1) == 1) {
                // empty if block
            }
            if ((this.f_flags & 2) == 2 && !this.isComponentPresent(Download.DOWNLOAD_ORDER[10])) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.expMissing"), msgArgs));
                status = 1;
            }
            if ((this.f_flags & 4) == 4 && !this.isComponentPresent(Download.DOWNLOAD_ORDER[3])) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.appMissing"), msgArgs));
                status = 1;
            }
            if ((aidLength = line[12]) > 16 || aidLength < 5) {
                this.logWriter.println(MessageFormat.format(msg.getString("CAP.aidLength"), msgArgs));
                status = 1;
            }
            in.close();
        }
        catch (Exception e) {
            Object[] expArg = new Object[]{e.toString()};
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.verifyHeader"), expArg));
            status = 1;
        }
        return status;
    }

    private int sortComponent(ZipEntry je, ZipEntry[] list) {
        int slashindex;
        String name = je.getName();
        int order = 0;
        boolean pkgOK = false;
        if (this.pkgName == null) {
            pkgOK = true;
        }
        if ((slashindex = name.lastIndexOf(47)) >= 0 && slashindex < name.length()) {
            String dir = name.substring(0, slashindex);
            name = name.substring(slashindex + 1).toLowerCase();
            if (this.pkgName != null && dir.replace('/', '.').equals(this.pkgName + ".javacard")) {
                pkgOK = true;
            }
        }
        Object[] msgArgs = new Object[]{name};
        order = pkgOK && name.equals("header.cap") ? Download.DOWNLOAD_ORDER[1] : (pkgOK && name.equals("directory.cap") ? Download.DOWNLOAD_ORDER[2] : (pkgOK && name.equals("applet.cap") ? Download.DOWNLOAD_ORDER[3] : (pkgOK && name.equals("import.cap") ? Download.DOWNLOAD_ORDER[4] : (pkgOK && name.equals("constantpool.cap") ? Download.DOWNLOAD_ORDER[5] : (pkgOK && name.equals("class.cap") ? Download.DOWNLOAD_ORDER[6] : (pkgOK && name.equals("method.cap") ? Download.DOWNLOAD_ORDER[7] : (pkgOK && name.equals("staticfield.cap") ? Download.DOWNLOAD_ORDER[8] : (pkgOK && name.equals("export.cap") ? Download.DOWNLOAD_ORDER[10] : (pkgOK && name.equals("reflocation.cap") ? Download.DOWNLOAD_ORDER[9] : (pkgOK && name.equals("descriptor.cap") ? Download.DOWNLOAD_ORDER[11] : ++this.numberOfCustomComponents + 11))))))))));
        if (this.seenList[order]) {
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.dup"), msgArgs));
            return 1;
        }
        this.seenList[order] = true;
        list[order] = je;
        return 0;
    }

    public int genComponent(ZipFile jf, ZipEntry je, int tag) {
        int status = 0;
        try {
            int size;
            InputStream in = jf.getInputStream(je);
            byte[] line = new byte[32];
            this.scriptWriter.println();
            this.scriptWriter.println("// " + je.getName());
            this.genCOMP(tag);
            while ((size = in.read(line, 0, line.length)) != -1 && (status = this.genData(tag, line, size)) == 0) {
            }
            in.close();
            this.genEOC(tag);
        }
        catch (Exception e) {
            Object[] msgArgs = new Object[]{e.toString()};
            this.logWriter.println(MessageFormat.format(msg.getString("CAP.genEx: "), msgArgs));
            status = 1;
        }
        return status;
    }

    protected int genData(int cmdCode, byte[] data, int size) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < size; ++j) {
            sb.append(" ");
            sb.append(this.toHex(data[j]));
        }
        return this.genAPDU(-76, cmdCode, sb.toString(), size);
    }

    protected int genAPDU(int cmdCode, int tag, String data, int size) {
        String apdu = "";
        block0 : switch (cmdCode) {
            case -76: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        apdu = this.toHex((byte)-128) + " " + this.toHex((byte)-76) + " " + this.toHex(Download.COMPONENT_TAGS[tag]) + " 0x00 " + this.toHex((byte)size) + data + " 0x7F;";
                        break block0;
                    }
                }
                return 0;
            }
            case -70: {
                apdu = System.getProperty("line.separator", "\n");
            }
            case -80: {
                if (this.noBeginEnd) break;
            }
            case -78: 
            case -68: {
                apdu = apdu + this.toHex((byte)-128) + " " + this.toHex((byte)cmdCode) + (tag >= 0 ? " " + this.toHex((byte)tag) : " 0x00") + " 0x00 " + (size > 0 ? " " + this.toHex((byte)size) : "0x00") + (data == null || data.length() <= 0 ? "" : " " + data) + " 0x7F;";
                break;
            }
            default: {
                return 0;
            }
        }
        this.scriptWriter.println(apdu);
        return 0;
    }

    public int genBeginCAP(String data) {
        return this.genAPDU(-80, 0, data, data.length());
    }

    public int genEOF() {
        return this.genAPDU(-70, 0, null, 0);
    }

    public int genCOMP(int tag) {
        return this.genAPDU(-78, tag, null, 0);
    }

    public int genEOC(int tag) {
        return this.genAPDU(-68, tag, null, 0);
    }

    private String toHex(byte b) {
        String h = "";
        String n = Integer.toHexString(b & 0xFF).toUpperCase();
        h = n.length() == 1 ? "0x0" + n : "0x" + n;
        return h;
    }

    public boolean isComponentPresent(byte tag) {
        boolean status = true;
        try {
            if (this.components[tag] == null) {
                status = false;
            }
        }
        catch (Exception e) {
            status = false;
        }
        return status;
    }
}

