/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import com.sun.javacard.impl.CommandLineOptions;
import com.sun.javacard.impl.NativeMethods;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class Logger {
    private static final int NONE = 0;
    private static final int FATAL = 1;
    private static final int ERROR = 2;
    private static final int WARN = 3;
    private static final int INFO = 4;
    private static final int VERBOSE = 5;
    private static final int DEBUG = 6;
    private static final int ALL = 7;
    private static final boolean EXACT = CommandLineOptions.isLoggerExact();
    private static final int LEVEL = CommandLineOptions.getLoggerLevel();
    private static final String[] PREFIXES = new String[]{"   [none] ", "  [fatal] ", "  [error] ", "   [warn] ", "   [info] ", "[verbose] ", "  [debug] ", "    [all] "};

    public static void fatal(Object ... args) {
        Logger.checkAndPrint(1, args);
    }

    public static void error(Object ... args) {
        Logger.checkAndPrint(2, args);
    }

    public static void warn(Object ... args) {
        Logger.checkAndPrint(3, args);
    }

    public static void info(Object ... args) {
        Logger.checkAndPrint(4, args);
    }

    public static void verbose(Object ... args) {
        Logger.checkAndPrint(5, args);
    }

    public static void debug(Object ... args) {
        Logger.checkAndPrint(6, args);
    }

    private static void checkAndPrint(int type, Object ... args) {
        if (LEVEL != 7) {
            if (EXACT && LEVEL != type) {
                return;
            }
            if (!EXACT && LEVEL < type) {
                return;
            }
        }
        Logger.printMessage(PREFIXES[type], args);
    }

    private static void printMessage(String prefix, Object ... args) {
        System.out.print(prefix);
        System.out.print(": ");
        for (Object arg : args) {
            if (arg instanceof Class) {
                System.out.print(((Class)arg).getName());
                System.out.print(" -> ");
                continue;
            }
            if (arg instanceof Throwable) {
                System.out.print('\n');
                ((Throwable)arg).printStackTrace();
                continue;
            }
            System.out.print(arg);
        }
        System.out.println();
    }

    static {
        NativeMethods.setGloballyAccessible(PREFIXES);
    }
}

