/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.file;

import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FSHelper {
    FSHelper() {
    }

    boolean canDelete(boolean isJCRECaller, FileConnection fc, String actualPath, boolean deletingAll) throws IOException {
        String subDirStr;
        String jcreString = new String(actualPath);
        String string = subDirStr = jcreString.endsWith("/") ? jcreString : jcreString + "/";
        if (!isJCRECaller) {
            Enumeration<String> list = FileConnection.openConnections.keys();
            while (list.hasMoreElements()) {
                Vector<FileConnection> cons;
                String node = new String(list.nextElement());
                if (node.equals(actualPath)) {
                    cons = FileConnection.openConnections.get(node);
                    for (FileConnection openFC : cons) {
                        if (openFC.equals(fc)) continue;
                        return false;
                    }
                    continue;
                }
                if (!deletingAll && node.startsWith(subDirStr)) {
                    return false;
                }
                if (!node.startsWith(subDirStr)) continue;
                if (!deletingAll) {
                    return false;
                }
                cons = FileConnection.openConnections.get(node);
                if (cons == null && cons.size() <= 0) continue;
                return false;
            }
            FileConnection fcParent = fc.getParentFile();
            if (fcParent != null && !fcParent.isWriteable()) {
                fcParent.close();
                return false;
            }
        }
        return !this.areStreamsOpen(fc, jcreString, FileConnection.outputStreams, false) && !this.areStreamsOpen(fc, jcreString, FileConnection.inputStreams, true);
    }

    boolean areStreamsOpen(FileConnection fc, String actualPath, Hashtable<String, Vector<FileConnection>> connections, boolean isInput) {
        String subDirPath = actualPath.endsWith("/") ? actualPath : actualPath + "/";
        Enumeration<String> list = connections.keys();
        while (list.hasMoreElements()) {
            String node = new String(list.nextElement());
            if (!node.equals(actualPath) && !node.startsWith(subDirPath)) continue;
            Vector<FileConnection> FCs = connections.get(node);
            for (FileConnection aFC : FCs) {
                if (aFC.equals(fc)) continue;
                return true;
            }
        }
        return false;
    }

    void closeStreamsForDeletedFilesOrDirs(String actualPath) {
        String jcreString = new String(actualPath);
        this.closeStreamsHelper(jcreString, FileConnection.outputStreams, false);
        this.closeStreamsHelper(jcreString, FileConnection.inputStreams, true);
    }

    void closeStreamsHelper(String actualPath, Hashtable<String, Vector<FileConnection>> connections, boolean isInput) {
        String subDirPath = actualPath.endsWith("/") ? actualPath : actualPath + "/";
        Enumeration<String> list = connections.keys();
        while (list.hasMoreElements()) {
            String node = new String(list.nextElement());
            if (!node.equals(actualPath) && !node.startsWith(subDirPath)) continue;
            Vector<FileConnection> FCs = connections.get(node);
            for (FileConnection aFC : FCs) {
                try {
                    if (isInput) {
                        aFC.is.close();
                        continue;
                    }
                    aFC.os.close();
                }
                catch (Exception e) {}
            }
            connections.remove(node);
        }
    }

    void addToOpenConnections(FileConnection fc, String actualPath) {
        Vector<Object> connections = null;
        if (FileConnection.openConnections.containsKey(actualPath)) {
            connections = FileConnection.openConnections.get(actualPath);
        } else {
            connections = new Vector();
            FileConnection.openConnections.put(actualPath, connections);
        }
        connections.addElement(fc);
    }

    void removeFromOpenConnections(FileConnection fc, String actualPath) {
        Vector<FileConnection> oc = FileConnection.openConnections.get(actualPath);
        if (oc != null && oc.size() > 0) {
            oc.removeElement(fc);
            if (oc.size() == 0) {
                FileConnection.openConnections.remove(actualPath);
            }
        }
        NativeMethods.removeConnection(fc);
    }
}

