/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import com.sun.javacard.security.AuthConstants;
import javacard.framework.Shareable;
import javacardx.biometry.BioBuilder;
import javacardx.biometry.BioException;
import javacardx.biometry.BioTemplate;
import javacardx.biometry.OwnerBioTemplate;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.SharedBioTemplateAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class BioGlobalAuthenticatorFactory
implements ServiceFactory {
    private final OwnerBioTemplate ownerBioTemplate;
    private final GlobalBioTemplateAuth auth;
    private BioTemplate currentMatchSession = null;

    public BioGlobalAuthenticatorFactory(byte[] bioTemplate, int tryLimit) {
        this(31, tryLimit);
        this.ownerBioTemplate.init(bioTemplate, (short)0, (byte)bioTemplate.length);
        this.ownerBioTemplate.doFinal();
    }

    public BioGlobalAuthenticatorFactory(byte bioType, byte[] bioTemplate, int tryLimit) {
        this(bioType, tryLimit);
        this.ownerBioTemplate.init(bioTemplate, (short)0, (byte)bioTemplate.length);
        this.ownerBioTemplate.doFinal();
    }

    public BioGlobalAuthenticatorFactory(byte bioType, int tryLimit) {
        this.ownerBioTemplate = BioBuilder.buildBioTemplate(bioType, (byte)tryLimit);
        this.auth = new GlobalBioTemplateAuth();
    }

    @Override
    public Shareable create(String serviceURI, Object parameter) throws SecurityException {
        if (serviceURI.startsWith("sio:///standard/auth/holder/global/") && (serviceURI.endsWith("/" + AuthConstants.BIO_ALGO_NAMES[this.ownerBioTemplate.getBioType()]) || this.ownerBioTemplate.getBioType() == 31 && serviceURI.endsWith("/bio-password"))) {
            return this.auth;
        }
        return null;
    }

    public OwnerBioTemplate getOwnerBioTemplate() {
        return this.ownerBioTemplate;
    }

    @TransactionType(value=TransactionTypeValue.SUPPORTS)
    private class GlobalBioTemplateAuth
    implements SharedBioTemplateAuth {
        private GlobalBioTemplateAuth() {
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized short initMatch(byte[] candidate, short offset, short length) throws BioException {
            BioGlobalAuthenticatorFactory.this.currentMatchSession = this;
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.initMatch(candidate, offset, length);
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized short match(byte[] candidate, short offset, short length) throws BioException {
            if (BioGlobalAuthenticatorFactory.this.currentMatchSession == this) {
                return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.match(candidate, offset, length);
            }
            throw new BioException(5);
        }

        @Override
        public synchronized byte getTriesRemaining() {
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.getTriesRemaining();
        }

        @Override
        public synchronized boolean isValidated() {
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.isValidated();
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized void reset() {
            BioGlobalAuthenticatorFactory.this.ownerBioTemplate.reset();
        }

        @Override
        public synchronized boolean isInitialized() {
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.isInitialized();
        }

        @Override
        public synchronized byte getBioType() {
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.getBioType();
        }

        @Override
        public synchronized short getVersion(byte[] dest, short offset) {
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.getVersion(dest, offset);
        }

        @Override
        public synchronized short getPublicTemplateData(short publicOffset, byte[] dest, short destOffset, short length) throws BioException {
            return BioGlobalAuthenticatorFactory.this.ownerBioTemplate.getPublicTemplateData(publicOffset, dest, destOffset, length);
        }
    }
}

