/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Locale;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.io.BufferCache;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.EmptyLists;
import org.mortbay.util.IO;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Response
implements HttpServletResponse {
    public static final int DISABLED = -1;
    public static final int NONE = 0;
    public static final int STREAM = 1;
    public static final int WRITER = 2;
    private static PrintWriter NULL_PRINTWRITER;
    private static ServletOutputStream NULL_SERVLET_OUTPUTSTREAM;
    private HttpConnection connection;
    private int status = 200;
    private String reason;
    private Locale locale;
    private String mimeType;
    private BufferCache.CachedBuffer cachedMimeType;
    private String characterEncoding;
    private boolean explicitEncoding;
    private String contentType;
    private int outputState;
    private PrintWriter writer;

    Response(HttpConnection connection) {
        this.connection = connection;
    }

    void recycle() {
        this.status = 200;
        this.reason = null;
        this.locale = null;
        this.mimeType = null;
        this.cachedMimeType = null;
        this.characterEncoding = null;
        this.explicitEncoding = false;
        this.contentType = null;
        this.outputState = 0;
        this.writer = null;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.connection.getResponseFields().addSetCookie(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.connection.getResponseFields().containsKey(name);
    }

    @Override
    public String encodeURL(String url) {
        Request request = this.connection.getRequest();
        if (url == null || request == null || request.isRequestedSessionIdFromCookie()) {
            return url;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return url;
        }
        String id = session.getId();
        if (id == null) {
            return url;
        }
        SessionManager sessionManager = request.getSessionManager();
        String sessionURLPrefix = sessionManager.getSessionURLPrefix();
        int prefix = url.indexOf(sessionURLPrefix);
        if (prefix != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + sessionURLPrefix + id;
        }
        return url.substring(0, suffix) + sessionURLPrefix + id + url.substring(suffix);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    public void sendError(int code, String message) throws IOException {
        if (this.connection.isIncluding()) {
            return;
        }
        if (this.isCommitted()) {
            Logger.debug("Committed before " + code + " " + message);
        }
        this.reset();
        this.setStatus(code, message);
        if (message == null) {
            message = HttpGenerator.getReason(code);
        }
        if (code != 204 && code != 304 && code != 206 && code >= 200) {
            Request request = this.connection.getRequest();
            request.setMethod("GET");
            ErrorHandler error_handler = null;
            ContextHandler.Context context = request.getContext();
            if (context != null) {
                error_handler = context.getContextHandler().getErrorHandler();
            }
            if (error_handler != null) {
                request.setAttribute("javax.servlet.error.status_code", new Integer(code));
                request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
                error_handler.handle(null, this.connection.getRequest(), this, 8);
            } else {
                this.setContentType("text/html; charset=ISO-8859-1");
                ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
                HttpConnection connection = HttpConnection.getCurrentConnection();
                ErrorHandler.writeErrorPage(request, writer, connection.getResponse().getStatus(), connection.getResponse().getReason(), true);
                writer.flush();
                this.setContentLength(writer.size());
                writer.writeTo(this.getOutputStream());
                writer.destroy();
            }
        } else if (code != 206) {
            this.connection.getRequestFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
            this.connection.getRequestFields().remove(HttpHeaders.CONTENT_LENGTH_BUFFER);
            this.characterEncoding = null;
            this.mimeType = null;
            this.cachedMimeType = null;
        }
        this.complete();
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, 302);
    }

    public void sendRedirect(String location, int statusCode) throws IOException {
        if (this.connection.isIncluding()) {
            return;
        }
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme(location)) {
            StringBuffer buf = this.connection.getRequest().getRootURL();
            if (location.startsWith("/")) {
                buf.append(URIUtil.canonicalPath(location));
            } else {
                String path = this.connection.getRequest().getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath(path);
                location = URIUtil.canonicalPath(URIUtil.addPaths(parent, location));
                if (!location.startsWith("/")) {
                    buf.append('/');
                }
                buf.append(location);
            }
            location = buf.toString();
        }
        this.resetBuffer();
        this.setHeader("Location", location);
        this.setStatus(statusCode);
        this.complete();
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (!this.connection.isIncluding()) {
            this.connection.getResponseFields().putDateField(name, date);
        }
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (!this.connection.isIncluding()) {
            this.connection.getResponseFields().addDateField(name, date);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (!this.connection.isIncluding()) {
            this.connection.getResponseFields().put(name, value);
        }
    }

    public String getHeader(String name) {
        return this.connection.getResponseFields().getStringField(name);
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration<String> e = this.connection.getResponseFields().getValues(name);
        if (e == null) {
            return EmptyLists.EMPTY_ENUMERATION;
        }
        return e;
    }

    @Override
    public void addHeader(String name, String value) {
        if (!this.connection.isIncluding()) {
            this.connection.getResponseFields().add(name, value);
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (!this.connection.isIncluding()) {
            this.connection.getResponseFields().putLongField(name, value);
        }
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (!this.connection.isIncluding()) {
            this.connection.getResponseFields().addLongField(name, (long)value);
        }
    }

    @Override
    public void setStatus(int sc) {
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String sm) {
        if (!this.connection.isIncluding()) {
            this.status = sc;
            this.reason = sm;
        }
    }

    @Override
    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = StringUtil.ISO_8859_1;
        }
        return this.characterEncoding;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public ServletOutputStream getOutputStream() {
        if (this.outputState == -1) {
            return NULL_SERVLET_OUTPUTSTREAM;
        }
        if (this.outputState != 0 && this.outputState != 1) {
            throw new IllegalStateException("WRITER");
        }
        this.outputState = 1;
        return this.connection.getOutputStream();
    }

    public boolean isWriting() {
        return this.outputState == 2;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.outputState == -1) {
            return NULL_PRINTWRITER;
        }
        if (this.outputState != 0 && this.outputState != 2) {
            throw new IllegalStateException("STREAM");
        }
        if (this.writer == null) {
            String encoding = this.characterEncoding;
            if (encoding == null) {
                if (this.mimeType != null) {
                    encoding = null;
                }
                if (encoding == null) {
                    encoding = StringUtil.ISO_8859_1;
                }
                this.setCharacterEncoding(encoding);
            }
            this.writer = this.connection.getPrintWriter(encoding);
        }
        this.outputState = 2;
        return this.writer;
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        if (this.connection.isIncluding()) {
            return;
        }
        if (this.outputState == 0 && !this.isCommitted()) {
            this.explicitEncoding = true;
            if (encoding == null) {
                if (this.characterEncoding != null) {
                    this.characterEncoding = null;
                    if (this.cachedMimeType != null) {
                        this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.cachedMimeType);
                    } else {
                        this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.mimeType);
                    }
                }
            } else {
                this.characterEncoding = encoding;
                if (this.contentType != null) {
                    int i0 = this.contentType.indexOf(59);
                    if (i0 < 0) {
                        BufferCache.CachedBuffer content_type;
                        this.contentType = null;
                        if (this.cachedMimeType != null && (content_type = this.cachedMimeType.getAssociate(this.characterEncoding)) != null) {
                            this.contentType = content_type.toString();
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, content_type);
                        }
                        if (this.contentType == null) {
                            this.contentType = this.mimeType + "; charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ");
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                        }
                    } else {
                        int i8;
                        int i2;
                        int i1 = this.contentType.indexOf("charset=", i0);
                        this.contentType = i1 < 0 ? this.contentType + " charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ") : ((i2 = this.contentType.indexOf(" ", i8 = i1 + 8)) < 0 ? this.contentType.substring(0, i8) + QuotedStringTokenizer.quote(this.characterEncoding, ";= ") : this.contentType.substring(0, i8) + QuotedStringTokenizer.quote(this.characterEncoding, ";= ") + this.contentType.substring(i2));
                        this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                    }
                }
            }
        }
    }

    @Override
    public void setContentLength(int len) {
        if (this.isCommitted() || this.connection.isIncluding()) {
            return;
        }
        this.connection.getResponseFields().putLongField("Content-Length", len);
    }

    public void setLongContentLength(long len) {
        if (this.isCommitted() || this.connection.isIncluding()) {
            return;
        }
        this.connection.getResponseFields().putLongField("Content-Length", len);
    }

    @Override
    public void setContentType(String contentType) {
        if (this.isCommitted() || this.connection.isIncluding()) {
            return;
        }
        if (contentType == null) {
            if (this.locale == null) {
                this.characterEncoding = null;
            }
            this.mimeType = null;
            this.cachedMimeType = null;
            this.contentType = null;
            this.connection.getResponseFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
        } else {
            int i0 = contentType.indexOf(59);
            if (i0 > 0) {
                this.mimeType = contentType.substring(0, i0).trim();
                this.cachedMimeType = MimeTypes.CACHE.get(this.mimeType);
                int i1 = contentType.indexOf("charset=", i0 + 1);
                if (i1 >= 0) {
                    this.explicitEncoding = true;
                    int i8 = i1 + 8;
                    int i2 = contentType.indexOf(32, i8);
                    if (this.outputState == 2) {
                        if (i1 == i0 + 1 && i2 < 0 || i1 == i0 + 2 && i2 < 0 && contentType.charAt(i0 + 1) == ' ') {
                            if (this.cachedMimeType != null) {
                                BufferCache.CachedBuffer content_type = this.cachedMimeType.getAssociate(this.characterEncoding);
                                if (content_type != null) {
                                    this.contentType = content_type.toString();
                                    this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, content_type);
                                } else {
                                    this.contentType = this.mimeType + "; charset=" + this.characterEncoding;
                                    this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                                }
                            } else {
                                this.contentType = this.mimeType + "; charset=" + this.characterEncoding;
                                this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                            }
                        } else if (i2 < 0) {
                            this.contentType = contentType.substring(0, i1) + " charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ");
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                        } else {
                            this.contentType = contentType.substring(0, i1) + contentType.substring(i2) + " charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ");
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                        }
                    } else if (i1 == i0 + 1 && i2 < 0 || i1 == i0 + 2 && i2 < 0 && contentType.charAt(i0 + 1) == ' ') {
                        this.cachedMimeType = MimeTypes.CACHE.get(this.mimeType);
                        this.characterEncoding = QuotedStringTokenizer.unquote(contentType.substring(i8));
                        if (this.cachedMimeType != null) {
                            BufferCache.CachedBuffer content_type = this.cachedMimeType.getAssociate(this.characterEncoding);
                            if (content_type != null) {
                                this.contentType = content_type.toString();
                                this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, content_type);
                            } else {
                                this.contentType = contentType;
                                this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                            }
                        } else {
                            this.contentType = contentType;
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                        }
                    } else if (i2 > 0) {
                        this.characterEncoding = QuotedStringTokenizer.unquote(contentType.substring(i8, i2));
                        this.contentType = contentType;
                        this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                    } else {
                        this.characterEncoding = QuotedStringTokenizer.unquote(contentType.substring(i8));
                        this.contentType = contentType;
                        this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                    }
                } else {
                    this.cachedMimeType = null;
                    this.contentType = this.characterEncoding == null ? contentType : contentType + " charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ");
                    this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                }
            } else {
                this.mimeType = contentType;
                this.cachedMimeType = MimeTypes.CACHE.get(this.mimeType);
                if (this.characterEncoding != null) {
                    if (this.cachedMimeType != null) {
                        BufferCache.CachedBuffer content_type = this.cachedMimeType.getAssociate(this.characterEncoding);
                        if (content_type != null) {
                            this.contentType = content_type.toString();
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, content_type);
                        } else {
                            this.contentType = this.mimeType + "; charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ");
                            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                        }
                    } else {
                        this.contentType = contentType + "; charset=" + QuotedStringTokenizer.quote(this.characterEncoding, ";= ");
                        this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                    }
                } else if (this.cachedMimeType != null) {
                    this.contentType = this.cachedMimeType.toString();
                    this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.cachedMimeType);
                } else {
                    this.contentType = contentType;
                    this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this.contentType);
                }
            }
        }
    }

    @Override
    public void setBufferSize(int size) {
        this.connection.getGenerator().increaseContentBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this.connection.getGenerator().getContentBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.connection.flushResponse();
    }

    @Override
    public void reset() {
        this.resetBuffer();
        this.status = 200;
        this.reason = null;
        this.mimeType = null;
        this.cachedMimeType = null;
        this.contentType = null;
        this.characterEncoding = null;
        this.explicitEncoding = false;
        this.locale = null;
        this.outputState = 0;
        this.writer = null;
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.connection.resetHttpGeneratorBuffer();
    }

    @Override
    public boolean isCommitted() {
        return this.connection.isResponseCommitted();
    }

    @Override
    public void setLocale(Locale locale) {
        String charset;
        if (locale == null || this.isCommitted() || this.connection.isIncluding()) {
            return;
        }
        this.locale = locale;
        this.connection.getResponseFields().put(HttpHeaders.CONTENT_LANGUAGE_BUFFER, locale.toString().replace('_', '-'));
        if (this.outputState != 0) {
            return;
        }
        String type = this.getContentType();
        if (type == null) {
            type = "application/octet-stream";
        }
        if ((charset = this.connection.getRequest().getContext().getContextHandler().getLocaleEncoding(locale)) != null && charset.length() > 0) {
            int semi = type.indexOf(59);
            if (semi < 0) {
                type = type + "; charset=" + charset;
            } else if (!this.explicitEncoding) {
                type = type.substring(0, semi) + "; charset=" + charset;
            }
            this.connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, type);
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public void complete() throws IOException {
        this.connection.completeResponse();
    }

    public long getContentCount() {
        if (this.connection == null || this.connection.getGenerator() == null) {
            return -1L;
        }
        return this.connection.getGenerator().getContentWritten();
    }

    public String toString() {
        return "HTTP/1.1 " + this.status + " " + this.reason + "\n" + this.connection.getResponseFields().toString();
    }

    static {
        Logger.debug("org.mortbay.jetty.Response.STATIC() -> ");
        try {
            NULL_PRINTWRITER = new PrintWriter(IO.getNullWriter());
            NULL_SERVLET_OUTPUTSTREAM = new NullOutput();
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    static class NullOutput
    extends ServletOutputStream {
        NullOutput() {
        }

        @Override
        public void write(int b) {
        }
    }
}

