/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import java.util.Arrays;

public class Contour {
    public int[] substack;
    public static Contour empty = new Contour();

    public Contour(int[] stack) {
        this.substack = stack;
    }

    public Contour() {
        this.substack = new int[0];
    }

    public Contour(int pc, Contour c) {
        this.substack = new int[1 + c.substack.length];
        this.substack[0] = pc;
        System.arraycopy(c.substack, 0, this.substack, 1, c.substack.length);
    }

    public boolean contains(int pc) {
        for (int element : this.substack) {
            if (element != pc) continue;
            return true;
        }
        return false;
    }

    public Contour popUpto(int retaddr) {
        int i;
        for (i = 0; i < this.substack.length && this.substack[i] != retaddr; ++i) {
        }
        if (i == this.substack.length) {
            return null;
        }
        if (i == this.substack.length - 1) {
            return empty;
        }
        int[] newstack = new int[this.substack.length - i - 1];
        System.arraycopy(this.substack, i + 1, newstack, 0, newstack.length);
        return new Contour(newstack);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Contour)) {
            return false;
        }
        Contour c = (Contour)obj;
        return Arrays.equals(this.substack, c.substack);
    }

    public int hashCode() {
        int h = 0;
        for (int element : this.substack) {
            h = h * 13 + element;
        }
        return h;
    }

    public String toString() {
        if (this.substack.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(10);
        sb.append('{');
        for (int i = 0; i < this.substack.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.substack[i]);
        }
        sb.append('}');
        return sb.toString();
    }
}

