/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageEntry;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.TransactionException;

public class PackageMgr {
    public static final byte PKG_COMPONENT_COUNT = 4;
    public static final byte PKG_COMPONENT_CLASS = 0;
    public static final byte PKG_COMPONENT_METHOD = 1;
    public static final byte PKG_COMPONENT_STATICFIELD = 2;
    public static final byte PKG_COMPONENT_EXPORT = 3;
    public static final byte ILLEGAL_ADDRESS = 0;
    public static final byte ILLEGAL_ID = -1;
    public static final short ON_CARD_PKG_MAX = 33;
    static final short COMP_HEADER_SIZE = 3;
    static final byte MASK_PKG_HAS_APPLET = 4;
    public static final byte CLASS_COMPONENT_INDEX = 0;
    public static final byte METHOD_COMPONENT_INDEX = 1;
    public static final byte STATIC_FIELD_COMPONENT_INDEX = 2;
    public static final byte EXPORT_COMPONENT_INDEX = 3;
    public static final byte COMPONENT_COUNT = 4;
    public static final byte DELETE_PACKAGE = -64;
    public static final byte DELETE_PACKAGE_AND_APPLETS = -62;
    public static final byte INSTALL_METHOD_ADDRESS = 1;
    public static final byte PACKAGE_ID = 2;
    public static final byte FAILURE = 0;
    public static final byte SUCCESS = 1;
    public static final byte NO_DEPENDENCIES = 2;
    public static final byte DEPENDENCIES_PRESENT = 3;
    public static final byte APPLETS_PRESENT = 4;
    public static final byte DEPENDENCIES_ON_APPLETS = 5;
    public static byte g_packageInProcess = (byte)-1;
    public static int g_tempMemoryAddress = 0;
    public static short g_tempMemorySize = 0;
    public static PackageEntry[] f_pkgTable;
    public static byte f_firstEEPkgID;
    public static byte g_newPackageIdentifier;
    public static PackageEntry g_newPackage;
    public static final byte ON_CARD_APPLET_PKG_MAX = 16;
    public static byte appletPkgCount;
    public static byte[] packageContextTable;

    public static void init() {
        g_packageInProcess = (byte)-1;
        f_firstEEPkgID = NativeMethods.getMaxPackageIdentifier();
        int i2 = 0;
        while (i2 < 16) {
            if (packageContextTable[i2] == -1) break;
            appletPkgCount = (byte)(appletPkgCount + 1);
            i2 = (byte)(i2 + 1);
        }
    }

    public static void reset() {
        PackageMgr.restore();
        g_newPackage = null;
        g_newPackageIdentifier = (byte)-1;
        byte i2 = f_firstEEPkgID;
        while (i2 < 33) {
            if (f_pkgTable[i2] == null) {
                g_newPackageIdentifier = i2;
                break;
            }
            i2 = (byte)(i2 + 1);
        }
        g_packageInProcess = g_newPackageIdentifier;
        g_tempMemoryAddress = 0;
        g_tempMemorySize = 0;
    }

    public static void restore() {
        if (g_packageInProcess == -1) {
            return;
        }
        try {
            NativeMethods.removePackage(g_packageInProcess, (byte)1);
            JCSystem.beginTransaction();
            if (f_pkgTable[g_packageInProcess] == null) {
                PackageMgr.f_pkgTable[PackageMgr.g_packageInProcess] = g_newPackage;
                g_newPackage = null;
            }
            GarbageCollector.cleanupTables(g_packageInProcess);
            if (g_tempMemoryAddress != 0) {
                PackageMgr.freeTempMemory();
            }
            g_packageInProcess = (byte)-1;
            JCSystem.commitTransaction();
        }
        catch (TransactionException te) {
            JCSystem.abortTransaction();
            ISOException.throwIt((short)25683);
        }
    }

    public static void freeTempMemory() throws TransactionException {
        boolean doCommit = false;
        if (JCSystem.getTransactionDepth() == 0) {
            JCSystem.beginTransaction();
            doCommit = true;
        }
        NativeMethods.freeHeap(g_tempMemoryAddress, g_tempMemorySize);
        g_tempMemoryAddress = 0;
        g_tempMemorySize = 0;
        if (doCommit) {
            JCSystem.commitTransaction();
        }
    }

    public static void commit() {
        if (g_newPackage != null) {
            PackageMgr.f_pkgTable[PackageMgr.g_newPackageIdentifier] = g_newPackage;
            g_packageInProcess = (byte)-1;
            g_newPackage = null;
        }
    }

    public static void addAppletPackage(byte pkgId) {
        int i2 = 0;
        while (i2 < 16) {
            if (packageContextTable[i2] == -1) {
                PackageMgr.packageContextTable[i2] = g_newPackageIdentifier;
                appletPkgCount = (byte)(appletPkgCount + 1);
                break;
            }
            i2 = (byte)(i2 + 1);
        }
    }

    public static void handlePackageDeletion(APDU apdu) {
        byte pkgId = 0;
        byte AIDLength = 0;
        byte[] buffer = apdu.getBuffer();
        byte command = buffer[1];
        byte appCount = 0;
        try {
            apdu.setIncomingAndReceive();
            if (buffer[4] < 6 || buffer[4] > 17) {
                ISOException.throwIt((short)26368);
            }
            if ((pkgId = PackageMgr.findPkgID(buffer, (short)6, AIDLength = buffer[5])) < 0) {
                ISOException.throwIt((short)25675);
            } else if (pkgId < f_firstEEPkgID) {
                ISOException.throwIt((short)25678);
            }
            if (command == -62) {
                appCount = AppletMgr.getAppletsForPackage(buffer, (byte)0, pkgId);
                AppletMgr.callUninstallMethods(buffer, appCount);
            }
            JCSystem.beginTransaction();
            g_packageInProcess = pkgId;
            if (command == -64) {
                byte requestStatus = PackageMgr.removePackage(pkgId);
            } else {
                byte requestStatus = PackageMgr.removePackageAndApplets(pkgId, buffer, appCount);
            }
            g_packageInProcess = (byte)-1;
            JCSystem.commitTransaction();
        }
        catch (ISOException e2) {
            if (JCSystem.getTransactionDepth() != 0) {
                JCSystem.abortTransaction();
            }
            ISOException.throwIt(e2.getReason());
        }
    }

    public static byte getPkgID(byte[] aid, short offset, byte length, byte major, byte minor) {
        byte pkgID = 0;
        while (pkgID < 33) {
            if (f_pkgTable[pkgID] != null && PackageMgr.f_pkgTable[pkgID].pkgAID.equals(aid, offset, length) && major == PackageMgr.f_pkgTable[pkgID].pkgMajor && (minor & 0xFF) <= (PackageMgr.f_pkgTable[pkgID].pkgMinor & 0xFF)) {
                return pkgID;
            }
            pkgID = (byte)(pkgID + 1);
        }
        return -1;
    }

    public static byte findPkgID(byte[] aid, short offset, byte length) {
        byte pkgID = 0;
        while (pkgID < 33) {
            if (f_pkgTable[pkgID] != null && PackageMgr.f_pkgTable[pkgID].pkgAID.equals(aid, offset, length)) {
                return pkgID;
            }
            pkgID = (byte)(pkgID + 1);
        }
        return -1;
    }

    public static int getExportAddress(byte pkgID) {
        return NativeMethods.getPackageExportComponent(pkgID);
    }

    static byte getPkgIDForAddress(int address) {
        return NativeMethods.getPkgIDForAddress(address);
    }

    static byte getPkgNameForClass(int classAddress, byte[] buffer, byte offset) {
        byte requiredId = NativeMethods.getPkgIDForAddress(classAddress);
        if (requiredId != -1) {
            byte by = offset;
            offset = (byte)(offset + 1);
            buffer[by] = PackageMgr.f_pkgTable[requiredId].pkgNamelength;
            f_pkgTable[requiredId].getPackageName(buffer, offset);
            return (byte)(PackageMgr.f_pkgTable[requiredId].pkgNamelength + offset);
        }
        return -1;
    }

    public static byte checkDependencies(byte index) {
        byte i2 = f_firstEEPkgID;
        while (i2 < 33) {
            if (i2 != index && f_pkgTable[i2] != null) {
                byte j2 = 0;
                while (j2 < PackageMgr.f_pkgTable[i2].importCount) {
                    if (PackageMgr.f_pkgTable[i2].importedPackages[j2] == index) {
                        return 3;
                    }
                    j2 = (byte)(j2 + 1);
                }
            }
            i2 = (byte)(i2 + 1);
        }
        return 2;
    }

    public static byte removePackage(byte index) throws ISOException {
        if (PackageMgr.checkDependencies(index) == 2) {
            if (AppletMgr.getAppletsForPackage(null, (byte)0, index) == 0) {
                GarbageCollector.deletePackage(index);
                return 1;
            }
            ISOException.throwIt((short)25677);
        } else {
            ISOException.throwIt((short)25676);
        }
        return 1;
    }

    public static byte removePackageAndApplets(byte index, byte[] buffer, byte appCount) throws ISOException {
        byte result = 0;
        if (PackageMgr.checkDependencies(index) != 2) {
            ISOException.throwIt((short)25676);
        }
        result = GarbageCollector.deletePackageAndApplets(index, buffer, appCount);
        return result;
    }

    public static byte getPkgContext(byte pkgId) {
        byte i2 = 0;
        while (i2 < 16) {
            if (packageContextTable[i2] == pkgId) {
                return i2;
            }
            i2 = (byte)(i2 + 1);
        }
        return -1;
    }

    public static byte getPkgIdForContext(byte pkgContext) {
        return packageContextTable[pkgContext];
    }

    public static short getAppletInfo(byte[] bArray, short offset, byte length, byte requiredInfoType) {
        short appletInfo = -1;
        int pkgID = 0;
        if (g_packageInProcess > 0 && g_newPackage != null) {
            pkgID = g_packageInProcess;
            appletInfo = g_newPackage.getAppletInstallMethodAddress(bArray, offset, length);
        }
        if (appletInfo == -1) {
            int i2 = 0;
            while (i2 < 33) {
                if (f_pkgTable == null) break;
                if (f_pkgTable[i2] != null) {
                    appletInfo = f_pkgTable[i2].getAppletInstallMethodAddress(bArray, offset, length);
                }
                if (appletInfo != -1) {
                    pkgID = i2;
                    break;
                }
                i2 = (byte)(i2 + 1);
            }
        }
        if (appletInfo != -1) {
            if (requiredInfoType == 2) {
                return (short)pkgID;
            }
            return appletInfo;
        }
        return -1;
    }

    static {
        appletPkgCount = 0;
    }
}

