/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.javacard.jcdebugproxy.IDEClassPath;
import com.oracle.javacard.jcdebugproxy.events.ClassEvent;
import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandlerImpl;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ClassUpdateRequestHandler
extends EventHandlerImpl {
    private static final int ACTION_PACKAGE_ADDED = 0;
    private static final int ACTION_PACKAGE_DELETED = 1;
    private static final int ACTION_VM_STATE_CHANGED = 128;
    private final LinkedHashMap<Integer, EventFilter> classChangeRequests = new LinkedHashMap();
    private final IDEClassPath idePath;

    public ClassUpdateRequestHandler(IDEClassPath path) {
        this.idePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVM) throws Exception {
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.classChangeRequests;
        synchronized (linkedHashMap) {
            this.classChangeRequests.remove(id);
        }
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVM) throws Exception {
        Log.LOG(4, "BP:SET-CUR(0x" + Integer.toHexString(filter.getID()) + "):" + filter);
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.classChangeRequests;
        synchronized (linkedHashMap) {
            this.classChangeRequests.put(filter.getID(), filter);
        }
        return super.handleSetEventRequest(filter, state, toVM);
    }

    @Override
    public void handleEventFromCard(OnCardEvent event) throws Exception {
        if ((event.package_action & 0xFF) == 128) {
            this.handleEventsQueue();
            return;
        }
        String aid = Utils.canonize(event.package_aid);
        String ownerAid = Utils.canonize(event.package_owner_aid);
        Log.LOG(3, "handleEventFromCard " + event.package_action + " id: " + event.package_index + " aid: " + aid + " owner: " + ownerAid);
        this.addToEventQueue(event);
        if (event.package_action == 0) {
            boolean isDebuggable = this.isDebuggablePackage(aid, ownerAid);
            if (isDebuggable) {
                this.proxy.sendPackageInfo(new byte[]{event.package_index}, new byte[0]);
            } else {
                this.proxy.sendPackageInfo(new byte[0], new byte[]{event.package_index});
            }
        } else {
            this.proxy.state().classes().markPackageExistsInVM(event.package_index, false);
        }
    }

    private boolean isDebuggablePackage(String aid, String ownerAid) {
        ClassFileTokens pack = this.idePath.getByAID(aid);
        boolean isOwnerDebuggedTA = ownerAid != null && ownerAid.equals(this.idePath.getTrustletInstallAID());
        boolean hasDebugInfo = pack != null && pack.hasDebugInfo();
        Log.LOG(3, "isDebuggablePackage: " + (hasDebugInfo && isOwnerDebuggedTA));
        return hasDebugInfo && isOwnerDebuggedTA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToEventQueue(OnCardEvent event) {
        LinkedList<OnCardEvent> eventQueue;
        LinkedList<OnCardEvent> linkedList = eventQueue = this.proxy.state().eventQueue();
        synchronized (linkedList) {
            eventQueue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OnCardEvent removeFromQueue() {
        LinkedList<OnCardEvent> eventQueue;
        LinkedList<OnCardEvent> linkedList = eventQueue = this.proxy.state().eventQueue();
        synchronized (linkedList) {
            return eventQueue.isEmpty() ? null : eventQueue.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEventsQueue() throws Exception {
        boolean doResume = true;
        try {
            OnCardEvent event;
            while (doResume && (event = this.removeFromQueue()) != null) {
                String aid = Utils.canonize(event.package_aid);
                String ownerAid = Utils.canonize(event.package_owner_aid);
                Log.LOG(3, "handleEventsQueue " + event.package_action + " id: " + event.package_index + " aid: " + aid + " owner: " + ownerAid);
                if (event.package_action == 0) {
                    boolean isDebuggable = this.isDebuggablePackage(aid, ownerAid);
                    if (isDebuggable) {
                        ClassFileTokens pack = this.idePath.getByAID(aid);
                        this.proxy.state().classes().addLoadedPackage(event.package_index, pack);
                        this.proxy.state().classes().resolveDirectSuperClasses();
                        doResume = this.classesAreLoaded(Arrays.asList(pack.getClasses()));
                        this.proxy.sendPackageInfo(new byte[]{event.package_index}, new byte[0]);
                        continue;
                    }
                    this.proxy.sendPackageInfo(new byte[0], new byte[]{event.package_index});
                    continue;
                }
                doResume = this.classesAreUnloaded(this.proxy.state().classes().removePackage(event.package_index));
            }
        }
        finally {
            if (doResume) {
                this.proxy.requestVMStateChange(VmState.State.RUNNING);
            }
        }
    }

    private boolean classesAreLoaded(List<ClassDebugInfo> list) throws Exception {
        ArrayList<ClassEvent> events = new ArrayList<ClassEvent>();
        this.filter(events, Kind.ClassLoaded, list);
        this.filter(events, Kind.ClassPrepared, list);
        int suspendPolicy = 0;
        for (ClassEvent e : events) {
            Log.LOG(4, "CE:HIT-CUR:" + e);
            suspendPolicy = Math.max(suspendPolicy, e.suspendPolicy);
        }
        Log.LOG(3, "ClassUpdateRequestHandler.classesAreLoaded");
        for (ClassEvent elem : events) {
            Log.LOG(3, ((Object)elem).toString());
        }
        this.proxy.sendEventsToIDE((byte)suspendPolicy, events);
        return suspendPolicy == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClassEvent> filter(List<ClassEvent> out, Kind kind, List<ClassDebugInfo> classes) {
        OnCardEvent template = new OnCardEvent();
        template.threadID = -31;
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.classChangeRequests;
        synchronized (linkedHashMap) {
            for (EventFilter filter : this.classChangeRequests.values()) {
                Iterator<ClassDebugInfo> i$ = classes.iterator();
                while (i$.hasNext()) {
                    ClassDebugInfo cl;
                    template.clInfo = cl = i$.next();
                    if (filter.getKind() != kind || !filter.filter(template)) continue;
                    ClassEvent clEvent = new ClassEvent(filter.getSuspendPolicy(), filter.getKind(), filter.getID(), cl);
                    Log.LOG(3, "filter add: " + kind.name() + " for " + cl.getClassName());
                    out.add(clEvent);
                }
            }
        }
        return out;
    }

    public boolean classesAreUnloaded(List<ClassDebugInfo> list) {
        ArrayList<ClassEvent> events = new ArrayList<ClassEvent>();
        this.filter(events, Kind.ClassUnloaded, list);
        int suspendPolicy = 0;
        for (ClassEvent e : events) {
            suspendPolicy = Math.max(suspendPolicy, e.suspendPolicy);
        }
        this.proxy.sendEventsToIDE((byte)suspendPolicy, events);
        Log.LOG(3, "BP:HIT-CUR:END:" + (suspendPolicy == 0));
        return suspendPolicy == 0;
    }

    @Override
    public synchronized void clear() throws Exception {
        super.clear();
        this.classChangeRequests.clear();
    }
}

