/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classparser;

import com.oracle.javacard.jcdebugproxy.ArrayDebugInfoImpl;
import com.oracle.javacard.jcdebugproxy.ClassDebugUtils;
import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.javacard.jcdebugproxy.DebugProxyMain;
import com.oracle.javacard.jcdebugproxy.ExportFileParser;
import com.oracle.javacard.jcdebugproxy.events.PackageEventListener;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.FieldDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import com.sun.javacard.debugproxy.types.Location;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class VMClassPool {
    private ArrayList<PackageEventListener> listeners = new ArrayList();
    private final Map<Integer, ClassDebugInfo> classMap = new HashMap<Integer, ClassDebugInfo>(128, 0.75f);
    private ArrayList<PackageInfo> packages = new ArrayList(64);
    private final Map<String, ClassDebugInfo> classSignatureToID = new HashMap<String, ClassDebugInfo>(128, 0.75f);
    private final ArrayList<ClassFileTokens> unresolved = new ArrayList();
    private ClassDebugInfo systemClass;
    private static final Properties romPackagesIds = new Properties();
    private static int extPackagesCounter;
    private boolean isInitialized = false;

    public MethodDebugInfo findMethodInfoByIndex(int methodID) {
        ClassDebugInfo info = this.getClassByID(methodID >>> 8);
        if (info == null) {
            return null;
        }
        return info.getMethodInfoByIndex(methodID);
    }

    public FieldDebugInfo findFieldInfoByIndex(long fieldID) {
        ClassDebugInfo info = this.getClassByID((int)(fieldID >>> 32));
        if (info == null) {
            return null;
        }
        return info.getFieldInfoByIndex(fieldID);
    }

    public Location initLocation(Location loc) {
        if (!this.doesClassExist(loc.classId)) {
            loc.cl = null;
            loc.meth = null;
            return loc;
        }
        if (loc.cl == null) {
            loc.cl = this.getClassByID(loc.classId);
        }
        if (loc.meth == null) {
            loc.meth = loc.cl.getMethodInfoByIndex(loc.methodId);
        }
        return loc;
    }

    public ClassDebugInfo createStubOnVMData(short packageID, int location) {
        return this.systemClass;
    }

    public void store(OutputStream out) throws IOException {
        Log.LOG(3, "*VMClassPool.store");
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(this.classMap);
            oos.writeObject(this.packages);
        }
    }

    public void dumpHumanReadableLog(File logFile) {
        try (PrintStream ps = new PrintStream(logFile, "US-ASCII");){
            int numOfPackages = this.packages.size();
            ps.println("Total number of packages: " + numOfPackages);
            ps.println("Total number of classes: " + this.classMap.size());
            ps.flush();
            Collection classes = this.classMap.values();
            HashMap packages2ClassesMap = new HashMap(this.packages.size());
            int exception = 0;
            for (ClassDebugInfo cdi : classes) {
                if (cdi != this.getSystemClass() && !(cdi instanceof ArrayDebugInfoImpl)) {
                    PackageInfo pInfo = this.packages.get(cdi.getPackageID());
                    if (!packages2ClassesMap.containsKey(pInfo.id)) {
                        packages2ClassesMap.put(pInfo.id, new ArrayList(10));
                    }
                    ((ArrayList)packages2ClassesMap.get(pInfo.id)).add(cdi);
                    continue;
                }
                ++exception;
            }
            ps.println("(exceptions (JC_SystemClass; Arrays): " + exception);
            ps.println("-----------------------");
            ps.flush();
            ArrayList<ClassDebugInfo> nonPublicClasses = new ArrayList<ClassDebugInfo>();
            int classCount = 0;
            for (int i = 0; i < packages2ClassesMap.size(); ++i) {
                classes = (Collection)packages2ClassesMap.get(i);
                ps.println();
                ps.println("Package: " + this.packages.get(i).toString());
                ps.println("********************************");
                for (ClassDebugInfo cdi : classes) {
                    List<FieldDebugInfo> fields;
                    if (cdi instanceof ArrayDebugInfoImpl) continue;
                    ++classCount;
                    String name = cdi.getClassName();
                    short packageId = cdi.getPackageID();
                    int accessFlags = cdi.getRawAccessFlags() & 0x7FF;
                    String modifiers = Modifier.toString(accessFlags);
                    if (!modifiers.equals("")) {
                        modifiers = modifiers + " ";
                    }
                    if (!Modifier.isPublic(accessFlags)) {
                        nonPublicClasses.add(cdi);
                    }
                    ps.println();
                    ps.println(modifiers + "class " + name);
                    ps.println("\textends " + cdi.getSuperClass());
                    List<String> interfaces = cdi.getAllInterfaces();
                    if (interfaces != null && !interfaces.isEmpty()) {
                        ps.print("\t\timplements ");
                        for (String intrfc : interfaces) {
                            ps.print(intrfc + ", ");
                        }
                        ps.println();
                    }
                    ps.println("\tpackageId: " + packageId + ", location: " + cdi.getLocation());
                    List<MethodDebugInfo> methods = cdi.getAllMethodInfo();
                    if (!methods.isEmpty()) {
                        ps.println("\tMethods:");
                        for (MethodDebugInfo mdi : methods) {
                            ps.println("\t\tid:" + mdi.getID() + " @" + mdi.getMethodOffset() + " " + Modifier.toString(mdi.getAccessFlags()) + " " + mdi.getName());
                        }
                    }
                    if ((fields = cdi.getAllFieldInfo()).isEmpty()) continue;
                    ps.println("\tFields:");
                    for (FieldDebugInfo fdi : fields) {
                        ps.println("\t\t@" + fdi.getContents() + " " + Modifier.toString(fdi.getAccessFlags()) + " " + fdi.getName());
                    }
                }
            }
            ps.println();
            ps.println("-----------------------");
            ps.println("non-public classes:");
            for (ClassDebugInfo cdi : nonPublicClasses) {
                ps.println("\t" + cdi.getClassName());
            }
            ps.println();
            ps.println("-----------------------");
            ps.println("Total class info count (incl. dummy JC_SystemClass): " + classCount);
            ps.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void markPackageExistsInVM(int packageIndex, boolean existOnVM) {
        if (packageIndex >= this.packages.size()) {
            Log.LOG(3, "Ignore set package.existOnVM from VMClassPool(" + packageIndex + ">=" + this.packages.size() + ")");
            return;
        }
        PackageInfo info = this.packages.get(packageIndex);
        if (info != null) {
            info.existOnVM = existOnVM;
        }
    }

    public void printClassPoolInfo() {
        int numOfPackages = this.packages.size();
        Log.LOG(3, "VMClassPool.printInfo: packages: " + numOfPackages + " classes: " + this.classMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(InputStream in) throws IOException, ClassNotFoundException {
        Log.LOG(3, "*VMClassPool.restore");
        try (ObjectInputStream ois = new ObjectInputStream(in);){
            HashMap restoredClassMap = (HashMap)ois.readObject();
            Map<Integer, ClassDebugInfo> map = this.classMap;
            synchronized (map) {
                this.classMap.clear();
                this.classMap.putAll(restoredClassMap);
            }
            this.packages = (ArrayList)ois.readObject();
        }
        Log.LOG(3, "going to set signatures...");
        for (ClassDebugInfo cl : this.classMap.values()) {
            Log.LOG(3, "adding cl:" + cl);
            this.classSignatureToID.put(cl.getClassSignature(), cl);
        }
        ClassFileTokens.ClassDebugInfoImpl objectCdi = (ClassFileTokens.ClassDebugInfoImpl)this.getClassBySignature("Ljava/lang/Object;");
        ClassDebugUtils.ensureHas_toString(objectCdi);
    }

    public VMClassPool() {
        this.registerClass(new ArrayDebugInfoImpl(0x1000001, "byte[]"));
        this.registerClass(new ArrayDebugInfoImpl(0x1000002, "boolean[]"));
        this.registerClass(new ArrayDebugInfoImpl(0x1000003, "short[]"));
        this.registerClass(new ArrayDebugInfoImpl(0x1000004, "int[]"));
        this.systemClass = ExportFileParser.createDummyClass();
        this.registerClass(this.systemClass);
    }

    public synchronized void addPackageEventListener(PackageEventListener listener) {
        ArrayList<PackageEventListener> copy = new ArrayList<PackageEventListener>();
        copy.addAll(this.listeners);
        copy.add(listener);
        this.listeners = copy;
    }

    public static String getJNISignature(String type) {
        int index;
        int preindex = index = type.length();
        Log.LOGN(6, "getJNISignature()  type == " + type);
        StringBuilder buf = new StringBuilder();
        while ((index = type.lastIndexOf("[]", index)) != -1) {
            buf.append("[");
            preindex = index--;
        }
        String ret = buf.toString();
        String str = type.substring(0, preindex);
        ret = "int".equalsIgnoreCase(str) ? ret + "I" : ("boolean".equalsIgnoreCase(str) ? ret + "Z" : ("short".equalsIgnoreCase(str) ? ret + "S" : ("byte".equalsIgnoreCase(str) ? ret + "B" : ("char".equalsIgnoreCase(str) ? ret + "C" : ("long".equalsIgnoreCase(str) ? ret + "J" : ("float".equalsIgnoreCase(str) ? ret + "F" : ("double".equalsIgnoreCase(str) ? ret + "D" : ret + "L" + str.replace('.', '/') + ";")))))));
        return ret;
    }

    public Collection<ClassDebugInfo> getClasses() {
        return this.classMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerClass(ClassDebugInfo cl) {
        Map<Integer, ClassDebugInfo> map = this.classMap;
        synchronized (map) {
            ClassDebugInfo old = this.classMap.put(cl.getClassID(), cl);
            if (old != null) {
                this.classSignatureToID.remove(old.getClassSignature());
            }
            if ((old = this.classSignatureToID.put(cl.getClassSignature(), cl)) != null && cl.getClassID() != old.getClassID()) {
                this.classMap.remove(cl.getClassID());
            }
        }
    }

    public boolean doesPackageExist(String prefix, int id, byte[] aid) {
        if (id >= this.packages.size()) {
            Log.LOG(3, prefix + " > package aid: " + Arrays.toString(aid) + " has id: " + id + " too big for VMClassPool(" + id + ">=" + this.packages.size() + ")");
            return false;
        }
        PackageInfo pi = this.packages.get(id);
        if (pi == null) {
            Log.LOG(3, prefix + " > package " + id + ", " + Arrays.toString(aid) + " does not exist in VMClassPool");
            return false;
        }
        if (aid != null && !Arrays.equals(aid, pi.aid)) {
            Log.LOG(3, prefix + " > package " + id + ", " + Arrays.toString(aid) + " has different AID in VMClassPool (" + Arrays.toString(pi.aid) + ")");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesClassExist(int id) {
        Map<Integer, ClassDebugInfo> map = this.classMap;
        synchronized (map) {
            ClassDebugInfo cl = this.classMap.get(id);
            if (cl == null) {
                return false;
            }
            PackageInfo info = this.packages.get(cl.getPackageID());
            if (info == null) {
                Log.LOG(3, "BP:" + cl + ":null");
            } else {
                Log.LOG(3, "BP:" + cl + ":" + Utils.canonize(info.aid) + " existOnVM=" + info.existOnVM);
            }
            return info != null && info.existOnVM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDebugInfo getClassByID(int id) {
        Map<Integer, ClassDebugInfo> map = this.classMap;
        synchronized (map) {
            return this.classMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDebugInfo getClassBySignature(String name) {
        ClassDebugInfo cl;
        Map<Integer, ClassDebugInfo> map = this.classMap;
        synchronized (map) {
            cl = this.classSignatureToID.get(name);
        }
        if (cl == null) {
            Log.LOG(3, "ERROR: there is no class object for '" + name + "'");
            Log.LOG(3, "ERROR: map size is " + this.classSignatureToID.size());
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDebugInfo getClassByVMData(short packageID, int location) {
        Map<Integer, ClassDebugInfo> map = this.classMap;
        synchronized (map) {
            for (ClassDebugInfo classFile : this.classMap.values()) {
                if (classFile.getJDWPTypeTag() == 3 || classFile.getPackageID() != packageID || classFile.getLocation() != location) continue;
                return classFile;
            }
        }
        return null;
    }

    public void init() {
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public synchronized void removeClass(int key) {
        ClassDebugInfo cl = this.classMap.remove(key);
        if (cl != null) {
            this.classSignatureToID.remove(cl.getClassSignature());
        }
    }

    public void write(OutputStream out) throws IOException {
        Log.LOG(3, this.getClass() + " write -------");
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(this.classMap);
        }
    }

    private MethodDebugInfo findMethodInfoByOffset(byte packageId, short offset) {
        for (ClassDebugInfo current : this.getClasses()) {
            if (current.getPackageID() != packageId) continue;
            for (MethodDebugInfo meth : current.getAllMethodInfo()) {
                int mOffset = offset - meth.getCodeOffset();
                if (mOffset < 0 || (long)mOffset >= meth.getCodeAttributeLength()) continue;
                return meth;
            }
        }
        return null;
    }

    public Location getLocation(byte packageId, short offset) {
        if ((packageId & 0xFF) == 255 && (offset & 0xFFFF) == 65535) {
            return null;
        }
        MethodDebugInfo meth = this.findMethodInfoByOffset(packageId, offset);
        if (meth != null) {
            return this.getLocation(meth, offset);
        }
        return this.getLocation(this.systemClass.getAllMethodInfo().get(0), offset);
    }

    private Location getLocation(MethodDebugInfo meth, short offset) {
        Location retVal = new Location();
        retVal.typeTag = 1;
        retVal.cl = meth.getParent();
        retVal.classId = meth.getParent().getClassID();
        retVal.meth = meth;
        retVal.methodId = meth.getID();
        retVal.offset = (0xFFFF & offset) - meth.getCodeOffset();
        return retVal;
    }

    public boolean addIDEPathPackage(ClassFileTokens pack) {
        Log.LOG(3, "-injecting IDEClassPath package: " + pack.getPackageName());
        return this.addPackageImpl(pack);
    }

    public boolean addSCDPackage(ClassFileTokens pack) {
        Log.LOG(3, "-injecting SCD IDEClassPath package: " + pack.getPackageName());
        return this.addPackageImpl(pack);
    }

    private boolean addPackageImpl(ClassFileTokens pack) {
        if (DebugProxyMain.isInSystemClassesDebuggingMode()) {
            int id = this.getPackageIdByRomOrder(pack.getPackageName());
            if (id == -1) {
                Log.LOG(3, "SCD Warning: should not happen! VMClassPool.addPackageImpl " + pack.getPackageName() + " ROM package id:" + id);
                return false;
            }
            Log.LOG(3, "[SCD mode] VMClassPool.addPackageImpl " + pack.getPackageName() + " ROM package id:" + id);
            return this.addPackageImpl(id, pack);
        }
        int id = this.packages.size();
        Log.LOG(3, "call VMClassPool.addPackageImpl " + pack.getPackageName() + " ID:" + id + " AID:" + Utils.canonize(pack.getPackageAID()));
        return this.addPackageImpl(id, pack);
    }

    private int getPackageIdByRomOrder(String s) {
        Object val = romPackagesIds.get(s = s.replace('/', '.'));
        if (val != null) {
            String packageId = (String)val;
            int i = Integer.parseInt(packageId);
            return i;
        }
        Log.LOG(3, "SCD Warning: getPackageIdByRomOrder return next available index: " + extPackagesCounter + " for package: " + s);
        return extPackagesCounter++;
    }

    public static void parseRomPackagesIdFile(String filePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            romPackagesIds.load(fis);
            romPackagesIds.list(System.out);
            extPackagesCounter = romPackagesIds.size();
        }
    }

    public boolean addIDEClassPathPackage(int id, ClassFileTokens pack) {
        return this.addPackageImpl(id, pack);
    }

    public boolean addLoadedPackage(int id, ClassFileTokens pack) {
        return this.addPackageImpl(id, pack);
    }

    private synchronized boolean addPackageImpl(int id, ClassFileTokens pack) {
        if (pack == null) {
            return false;
        }
        while (this.packages.size() <= id) {
            this.packages.add(null);
        }
        this.packages.set(id, new PackageInfo(id, pack.getPackageAID(), pack.hasDebugInfo(), pack.getPackageName()));
        for (ClassDebugInfo cl : pack.getClasses()) {
            cl.setPackageID((short)id);
            this.registerClass(cl);
        }
        this.unresolved.add(pack);
        List<ClassDebugInfo> list = Arrays.asList(pack.getClasses());
        for (PackageEventListener listener : this.listeners) {
            try {
                listener.classesAreLoaded(list);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public void sendDebugInfo(ClassicProxyProtocol proxy) throws Exception {
        ByteArrayOutputStream debuggable = new ByteArrayOutputStream();
        ByteArrayOutputStream nonDebuggable = new ByteArrayOutputStream();
        for (PackageInfo pack : this.packages) {
            if (pack == null) continue;
            if (pack.hasDebugInfo) {
                Log.LOG(3, "debuggable package: " + pack.id + ", " + pack.name);
                debuggable.write(pack.id);
                continue;
            }
            nonDebuggable.write(pack.id);
        }
        proxy.sendPackageInfo(debuggable.toByteArray(), nonDebuggable.toByteArray());
    }

    public static void writeClass(DataOutputStream toIde, ClassDebugInfo classFile) throws IOException {
        toIde.writeByte(classFile.getJDWPTypeTag());
        toIde.writeInt(classFile.getClassID());
        EncodingUtils.writeString(toIde, classFile.getClassSignature());
        toIde.writeInt(classFile.getClassStatus());
    }

    public synchronized List<ClassDebugInfo> removePackage(byte id) {
        ArrayList<ClassDebugInfo> retVal = new ArrayList<ClassDebugInfo>();
        if (this.doesPackageExist("removePackage", id, null)) {
            for (ClassDebugInfo cl : this.getClasses()) {
                if (cl.getPackageID() != id) continue;
                retVal.add(cl);
            }
            for (ClassDebugInfo cl : retVal) {
                this.removeClass(cl.getClassID());
            }
            this.packages.set(id, null);
            for (PackageEventListener listener : this.listeners) {
                try {
                    listener.classesAreUnloaded(retVal);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return retVal;
    }

    public void resolveDirectSuperClasses() {
        for (ClassFileTokens pack : this.unresolved) {
            for (ClassDebugInfo info : pack.getClasses()) {
                if (!(info instanceof ClassFileTokens.ClassDebugInfoImpl)) continue;
                ((ClassFileTokens.ClassDebugInfoImpl)info).assignSuperClass(this);
            }
        }
        this.unresolved.clear();
    }

    public ClassDebugInfo getSystemClass() {
        return this.systemClass;
    }

    public boolean isSystem(ClassDebugInfo cl) {
        return cl == this.systemClass;
    }

    private static class PackageInfo
    implements Serializable {
        private static final long serialVersionUID = 42L;
        int id;
        boolean hasDebugInfo;
        byte[] aid;
        String name;
        boolean existOnVM = true;

        public PackageInfo(int id, byte[] aid, boolean hasDebugInfo, String name) {
            this.id = id;
            this.aid = aid;
            this.hasDebugInfo = hasDebugInfo;
            this.name = name;
        }

        public String toString() {
            return "id: " + this.id + " aid: " + Utils.canonize(this.aid) + " name: " + this.name;
        }
    }
}

