/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.CustomComponent;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.BitSet;

class DirectoryComponent
extends Safeptr {
    private short componentCount = (short)12;

    DirectoryComponent(byte[] data) {
        super(data, "Directory");
    }

    int componentSize(int n) {
        return this.u2((n - 1) * 2);
    }

    int imageSize() {
        return this.u2(this.componentCount * 2);
    }

    int arrayInitCount() {
        return this.u2(this.componentCount * 2 + 2);
    }

    int arrayInitSize() {
        return this.u2(this.componentCount * 2 + 4);
    }

    int importCount() {
        return this.u1(this.componentCount * 2 + 6);
    }

    int appletCount() {
        return this.u1(this.componentCount * 2 + 7);
    }

    int customCount() {
        return this.u1(this.componentCount * 2 + 8);
    }

    CustomComponent customComps() {
        return new CustomComponent(this.offset(this.componentCount * 2 + 9));
    }

    void verify() {
        int appcount;
        if (Verifier.verbose >= 2) {
            Messages.println("DirectoryComponent.100");
        }
        Safeptr[] comps = new Safeptr[]{null, Cap.Header, Cap.Directory, Cap.Applet, Cap.Import, Cap.ConstantPool, Cap.Class, Cap.Method, Cap.StaticField, Cap.ReferenceLocation, Cap.Export, Cap.Descriptor, Cap.Debug};
        String[] names = new String[]{null, "Header", "Directory", "Applet", "Import", "ConstantPool", "Class", "Method", "StaticField", "ReferenceLocation", "Export", "Descriptor", "Debug"};
        if (Cap.capMinorVersion < 2) {
            this.componentCount = (short)11;
        }
        for (int i = 1; i <= this.componentCount; ++i) {
            int size;
            Safeptr c = comps[i];
            int n = size = c == null ? 0 : c.size();
            if (size == this.componentSize(i)) continue;
            throw new VerifierError("DirectoryComponent.1", (Object)names[i], this.componentSize(i), size);
        }
        if (this.imageSize() != Cap.StaticField.imageSize()) {
            throw new VerifierError("DirectoryComponent.2", Cap.StaticField.imageSize(), this.imageSize());
        }
        if (this.arrayInitCount() != Cap.StaticField.arrayInitCount()) {
            throw new VerifierError("DirectoryComponent.3", Cap.StaticField.arrayInitCount(), this.arrayInitCount());
        }
        int iaSize = 0;
        InitializedArray ia = Cap.StaticField.arrayInit();
        for (int i = Cap.StaticField.arrayInitCount(); i > 0; --i) {
            iaSize += ia.count();
            ia.next();
        }
        if (this.arrayInitSize() != iaSize) {
            throw new VerifierError("DirectoryComponent.4", iaSize, this.arrayInitSize());
        }
        if (this.importCount() != Cap.Import.count()) {
            throw new VerifierError("DirectoryComponent.5", Cap.Import.count(), this.importCount());
        }
        int n = appcount = Cap.Applet == null ? 0 : Cap.Applet.count();
        if (this.appletCount() != appcount) {
            throw new VerifierError("DirectoryComponent.6", appcount, this.appletCount());
        }
        BitSet ccompTags = new BitSet(256);
        CustomComponent p = this.customComps();
        for (int i = this.customCount(); i > 0; --i) {
            int tag = p.componentTag();
            if (tag < 128 || tag > 255) {
                throw new VerifierError("DirectoryComponent.8", tag);
            }
            if (ccompTags.get(tag)) {
                throw new VerifierError("DirectoryComponent.9", tag);
            }
            ccompTags.set(tag);
            if (!AID.isValid(p)) {
                throw new VerifierError("DirectoryComponent.12", p.AID_length(), tag);
            }
            Safeptr cc = Cap.customComponent(tag);
            if (cc == null) {
                throw new VerifierError("DirectoryComponent.10", tag);
            }
            if (p.componentSize() != cc.size()) {
                throw new VerifierError("DirectoryComponent.11", tag, cc.size(), p.componentSize());
            }
            p.next();
        }
        if (!p.atComponentEnd()) {
            throw new VerifierError("DirectoryComponent.14");
        }
    }
}

