/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppTable;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageEntry;

public class PackageMgr {
    static final short STATE_READY = 0;
    static final short STATE_MARKED = 1;
    static final short STATE_NO_ROLLBACK = 2;
    static final short ILLEGAL_ADDRESS = 0;
    static final byte ILLEGAL_ID = -1;
    static final short ON_CARD_PKG_MAX = 16;
    static final short COMP_HEADER_SIZE = 3;
    static final byte MASK_PKG_HAS_APPLET = 4;
    static PackageEntry[] f_pkgTable;
    static byte f_pkgEntryCount;
    static byte f_pkgID;
    public static byte f_firstEEPkgID;
    static short f_currentState;
    public static short g_excTableEntry;
    public static byte g_newPackageIdentifier;
    public static PackageEntry g_newPackage;
    public static boolean g_hasGlobalStaticReference;
    public static boolean g_hasPackageStaticReference;

    public static void cleanup() {
        AppTable.cleanup();
        PackageMgr.restore();
    }

    public static void commit() {
        if (g_newPackage != null) {
            if (PackageMgr.g_newPackage.pkgStaticReferenceCount != 0 && (PackageMgr.g_newPackage.pkgFlags & 4) == 0) {
                g_hasGlobalStaticReference = true;
            }
            f_pkgID = (byte)(f_pkgID + 1);
            byte by = f_pkgEntryCount;
            f_pkgEntryCount = (byte)(by + 1);
            PackageMgr.f_pkgTable[by] = g_newPackage;
            g_newPackage = null;
        }
        if (f_currentState == 1) {
            NativeMethods.commit();
            f_currentState = 0;
        }
    }

    public static byte findPkgID(byte[] aid, short offset, byte length) {
        byte pkgID = -1;
        pkgID = NativeMethods.findPackageIdentifier(aid, offset, length);
        if (pkgID != -1) {
            return pkgID;
        }
        short i = f_firstEEPkgID;
        while (i < (short)f_pkgEntryCount) {
            if (PackageMgr.f_pkgTable[i].pkgAID.equals(aid, offset, length)) {
                pkgID = PackageMgr.f_pkgTable[i].pkgID;
                break;
            }
            i = (short)(i + 1);
        }
        return pkgID;
    }

    public static short getExportAddress(byte pkgID) {
        short exportAddr = 0;
        if (pkgID < f_firstEEPkgID) {
            exportAddr = NativeMethods.getPackageExportComponent(pkgID);
            if (exportAddr == 0) {
                return exportAddr;
            }
            exportAddr = (short)(exportAddr + 3);
        } else {
            exportAddr = PackageMgr.f_pkgTable[pkgID].exportAddr;
        }
        return exportAddr;
    }

    public static byte getPkgID(byte[] aid, short offset, byte length, byte major, byte minor) {
        byte pkgID = -1;
        pkgID = NativeMethods.getPackageIdentifier(aid, offset, length, major, minor);
        if (pkgID != -1) {
            return pkgID;
        }
        short i = f_firstEEPkgID;
        while (i < (short)f_pkgEntryCount) {
            if (PackageMgr.f_pkgTable[i].pkgAID.equals(aid, offset, length) && major == PackageMgr.f_pkgTable[i].pkgMajor && minor <= PackageMgr.f_pkgTable[i].pkgMinor) {
                pkgID = PackageMgr.f_pkgTable[i].pkgID;
                break;
            }
            i = (short)(i + 1);
        }
        return pkgID;
    }

    public static short getStaticReferenceCount(byte pkgID) {
        return PackageMgr.f_pkgTable[pkgID].pkgStaticReferenceCount;
    }

    public static void init() {
        f_firstEEPkgID = f_pkgID = NativeMethods.getMaxPackageIdentifier();
        f_pkgEntryCount = f_firstEEPkgID = (byte)(f_firstEEPkgID + 1);
        f_pkgTable = new PackageEntry[16];
        f_currentState = 0;
    }

    public static void markHeap() {
        if (f_currentState == 0) {
            NativeMethods.markHeap();
            f_currentState = 1;
        }
    }

    public static void reset() {
        g_newPackage = null;
        g_newPackageIdentifier = (byte)(f_pkgID + 1);
        g_excTableEntry = 0;
        g_hasPackageStaticReference = false;
    }

    public static void resetState() {
        f_currentState = 0;
    }

    public static void restore() {
        if (f_currentState == 1) {
            NativeMethods.restore((short)0);
            f_currentState = 0;
        }
    }
}

