/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyExp {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyExp() {
    }

    public static void main(String[] stringArray) {
        String string;
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) == '-') {
            string = stringArray[n];
            if (string.equals("-verbose")) {
                ++verbose;
            } else if (string.equals("-nobanner")) {
                bl = false;
            } else if (string.equals("-nowarn")) {
                VerifierError.noWarn = true;
            } else if (string.equals("-help")) {
                VerifyExp.printUsageAndExit();
            } else if (string.equals("-version")) {
                Messages.println("MainExp.3", new Object[]{ToolsVersion.getProductName(), ToolsVersion.getVersion(2)});
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
            } else {
                VerifyExp.printUsageAndExit();
            }
            ++n;
        }
        if (n + 1 != stringArray.length) {
            VerifyExp.printUsageAndExit();
        }
        if (verbose >= 1 && bl) {
            Messages.println("MainExp.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        string = stringArray[n];
        if (!string.endsWith(".exp")) {
            VerifyExp.printUsageAndExit();
        }
        File file = new File(string);
        if (verbose >= 1) {
            Messages.println("MainExp.4", string);
        }
        try {
            ExportFile exportFile = ExportFile.readFromFile(file);
            exportFile.verify();
        }
        catch (VerifierError verifierError) {
            Messages.printTo(System.err);
            Messages.println("MainExp.2", Messages.numWarning, (Object)verifierError.getMessage(), (Object)Messages.format("MainExp.6"));
            System.exit(2);
        }
        Messages.println("MainExp.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("MainExp.1");
        System.exit(2);
    }
}

