/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.CryptoInit;
import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.APDU;
import javacard.framework.APDUException;
import javacard.framework.Applet;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.PINException;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.UserException;
import javacard.framework.service.CardRemoteObject;
import javacard.framework.service.ServiceException;
import javacard.security.CryptoException;
import javacardx.apdu.ExtendedLength;
import javacardx.biometry.BioException;
import javacardx.framework.tlv.TLVException;
import javacardx.framework.util.UtilException;

class Dispatcher {
    private static final byte INS_SELECT = -92;
    private static final byte INS_MANAGECHANNEL = 112;
    private static final byte P1_SELECT_DFBYNAME = 4;
    private static final byte P2_SELECT_OPTIONS = -29;
    private static final byte P2_SELECT_OPTIONS_ONLY = 0;
    private static final byte P1_OPEN_CHANNEL = 0;
    private static final byte P1_CLOSE_CHANNEL = -128;
    private static final byte P2_AUTOSELECT_CHANNEL = 0;
    private static final byte ERR_NO_CHANNEL_AVAILABLE = -1;
    private static final byte BASIC_CHANNEL = 0;
    private static ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException;
    private static NegativeArraySizeException negativeArraySizeException;
    private static NullPointerException nullPointerException;
    private static ClassCastException classCastException;
    private static ArithmeticException arithmeticException;
    static SecurityException securityException;
    private static ArrayStoreException arrayStoreException;
    private static SystemException systemException;
    private static TransactionException transactionException;
    private static ServiceException serviceException;
    private static UtilException utilException;
    private static final byte OP_CHANNEL_CLOSE = 0;
    private static final byte OP_CHANNEL_OPEN = 1;
    private static final byte OP_CHANNEL_OPEN_AUTOSELECT = 2;
    private static final byte CHANNEL_CLOSED = 0;
    private static final byte CHANNEL_DISABLED = 1;
    private static final byte CHANNEL_OPEN = 2;
    private static final byte CHANNEL_OPEN_MS = 3;
    private static final byte CHANNEL_MS_MASK = 1;
    private static final byte CHANNEL_OPEN_MASK = 2;
    private static APDU theAPDU;
    private static byte[] theAPDUBuffer;
    private static PrivAccess thePrivAccess;
    static Dispatcher theDispatcher;

    static void main() {
        if (!NativeMethods.isCardInitialized()) {
            Dispatcher.cardInit();
        }
        Dispatcher.cardReset();
        int sw = 0;
        while (true) {
            PrivAccess.resetSelectingAppletFlag();
            PrivAccess.resetProcessMethodFlag();
            theAPDU.complete((short)sw);
            byte activeInterface = NativeMethods.getActiveInterface();
            try {
                theAPDU.verifyLe();
                if (Dispatcher.processAndForward()) {
                    byte commandChannel = NativeMethods.getCurrentlySelectedChannel();
                    if (PrivAccess.getSelectedAppID(commandChannel, activeInterface) == -1) {
                        ISOException.throwIt((short)27033);
                    }
                    PrivAccess.setProcessMethodFlag();
                    Applet selectedApplet = PrivAccess.getSelectedApplet(commandChannel, activeInterface);
                    if (selectedApplet instanceof ExtendedLength) {
                        theAPDU.markExtendedSupport(true);
                    } else {
                        theAPDU.markExtendedSupport(false);
                    }
                    selectedApplet.process(theAPDU);
                    if (JCSystem.getTransactionDepth() != 0) {
                        TransactionException.throwIt((short)1);
                    }
                }
                sw = -28672;
            }
            catch (ISOException ex) {
                sw = ex.getReason();
            }
            catch (Throwable e2) {
                sw = 28416;
            }
            if (JCSystem.getTransactionDepth() != 0) {
                JCSystem.abortTransaction();
            }
            if (!thePrivAccess.isGarbageCollectionRequested()) continue;
            GarbageCollector.startGC();
        }
    }

    private static void setAPDUChannel() throws SystemException {
        byte theAPDUChannel = APDU.getCLAChannel();
        if (theAPDUChannel >= 20) {
            ISOException.throwIt((short)26753);
        }
        NativeMethods.setCurrentlySelectedChannel(theAPDUChannel, NativeMethods.getActiveInterface());
    }

    private static boolean processAndForward() throws ISOException {
        if (theAPDU.isISOInterindustryCLA()) {
            Dispatcher.setAPDUChannel();
            switch (theAPDUBuffer[1]) {
                case -92: {
                    if (theAPDU.isSecureMessagingCLA()) break;
                    theDispatcher.selectAPDU(theAPDU);
                    return true;
                }
                case 112: {
                    if (theAPDU.isSecureMessagingCLA()) {
                        ISOException.throwIt((short)26754);
                    }
                    theDispatcher.manageChannelAPDU(theAPDU);
                    return false;
                }
            }
        }
        Dispatcher.setAPDUChannel();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void manageChannelAPDU(APDU theAPDU) throws ISOException {
        newChannel = -1;
        cmdChannel = NativeMethods.getCurrentlySelectedChannel();
        maxChannels = NativeMethods.getMaxChannels();
        activeInterface = NativeMethods.getActiveInterface();
        if (maxChannels == 1) {
            ISOException.throwIt((short)26753);
        }
        if (NativeMethods.getChannelStatus(cmdChannel, activeInterface) == 0) {
            ISOException.throwIt((short)26753);
        }
        opType = Dispatcher.theAPDUBuffer[2];
        managedChannel = Dispatcher.theAPDUBuffer[3];
        if (managedChannel > 19 || managedChannel < 0) {
            ISOException.throwIt((short)27265);
        }
        channelStatus = NativeMethods.getChannelStatus(managedChannel, activeInterface);
        switch (opType) {
            case -128: {
                if (managedChannel == 0) {
                    ISOException.throwIt((short)27265);
                }
                if ((channelStatus & 2) == 2) {
                    PrivAccess.deselectOnly(managedChannel, activeInterface);
                    NativeMethods.channelManage(managedChannel, activeInterface, (byte)0);
                    break;
                }
                ISOException.throwIt((short)25088);
                break;
            }
            case 0: {
                if (managedChannel == 0) {
                    le = theAPDU.setOutgoing();
                    if (le != 1) {
                        ISOException.throwIt((short)27649);
                    }
                    if ((newChannel = (byte)NativeMethods.channelManage((byte)-1, activeInterface, (byte)2)) == -1) {
                        ISOException.throwIt((short)27265);
                    }
                } else if (NativeMethods.channelManage(managedChannel, activeInterface, (byte)1) != -1) {
                    newChannel = managedChannel;
                } else {
                    ISOException.throwIt((short)27270);
                }
                try {
                    if (cmdChannel == 0) {
                        PrivAccess.selectDefaultApplet(newChannel, activeInterface);
                    } else {
                        selAppletID = PrivAccess.getSelectedAppID(cmdChannel, activeInterface);
                        if (selAppletID != -1) {
                            PrivAccess.selectOnly(newChannel, activeInterface, selAppletID);
                        }
                    }
                }
                catch (ISOException isoEx) {
                    NativeMethods.channelManage(newChannel, activeInterface, (byte)0);
                    ISOException.throwIt(isoEx.getReason());
                }
                catch (SystemException se) {
                    NativeMethods.channelManage(newChannel, activeInterface, (byte)0);
                    if (se.getReason() != 5) ** GOTO lbl58
                    if (managedChannel == 0) {
                        ISOException.throwIt((short)27265);
                    }
                    ISOException.throwIt((short)27270);
                }
lbl58:
                // 6 sources

                if (managedChannel != 0) break;
                theAPDU.setOutgoingLength((short)1);
                Dispatcher.theAPDUBuffer[0] = newChannel;
                theAPDU.sendBytes((short)0, (short)1);
                break;
            }
            default: {
                ISOException.throwIt((short)27265);
            }
        }
    }

    void selectAPDU(APDU theAPDU) throws ISOException {
        byte openOK;
        byte selectInterface;
        byte selectChannel = NativeMethods.getCurrentlySelectedChannel();
        if (NativeMethods.getChannelStatus(selectChannel, selectInterface = NativeMethods.getActiveInterface()) == 0 && (openOK = NativeMethods.channelManage(selectChannel, selectInterface, (byte)1)) == -1) {
            ISOException.throwIt((short)26753);
        }
        try {
            if (theAPDUBuffer[2] == 4) {
                byte i2;
                if ((theAPDUBuffer[3] & 0xFFFFFFE3) != 0) {
                    return;
                }
                byte len = (byte)theAPDU.setIncomingAndReceive();
                if (len == theAPDUBuffer[4] && (i2 = AppletMgr.findApplet(theAPDUBuffer, (short)5, len)) != -1) {
                    if (PrivAccess.getAppState(thePrivAccess.getAID(i2)) >= 2) {
                        if (!PrivAccess.isMultiSelectionOK(selectChannel, selectInterface, i2)) {
                            ISOException.throwIt((short)27013);
                        }
                        PrivAccess.selectApplet(selectChannel, selectInterface, i2);
                    } else {
                        PrivAccess.deselectOnly(selectChannel, selectInterface);
                        NativeMethods.setChannelContext(selectChannel, selectInterface, (byte)0, false);
                    }
                }
                this.undoReceive();
            }
        }
        catch (SystemException se) {
            if (selectChannel != 0) {
                NativeMethods.channelManage(selectChannel, selectInterface, (byte)0);
            }
            if (se.getReason() == 5) {
                ISOException.throwIt((short)26753);
            }
            SystemException.throwIt(se.getReason());
        }
    }

    void undoReceive() {
        theAPDU.undoIncomingAndReceive();
    }

    static void cardReset() {
        PrivAccess.selectDefaultApplet((byte)0, (byte)0);
        if (GarbageCollector.sweepStarted) {
            GarbageCollector.startGC();
        }
        PackageMgr.restore();
    }

    static void cardInit() {
        Dispatcher.initSystemExceptions();
        if (theDispatcher == null) {
            theDispatcher = new Dispatcher();
        }
        Exception ex = new CardException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new APDUException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new ISOException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new PINException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new UserException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new CryptoException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new BioException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new TLVException(0);
        NativeMethods.setJCREentry(ex, true);
        theAPDU = new APDU();
        NativeMethods.setJCREentry(theAPDU, true);
        thePrivAccess = JCSystem.thePrivAccess = new PrivAccess();
        NativeMethods.setJCREentry(thePrivAccess, false);
        GarbageCollector.GCRequested = PrivAccess.getPackedBoolean().allocate();
        theAPDUBuffer = theAPDU.getBuffer();
        NativeMethods.setJCREentry(theAPDUBuffer, true);
        CryptoInit.initCryptoStorage();
        PrivAccess.initialize(theAPDU);
        CardRemoteObject.export(null);
        NativeMethods.setCardInitialized();
    }

    private static void initSystemExceptions() {
        arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
        NativeMethods.setJCREentry(arrayIndexOutOfBoundsException, true);
        negativeArraySizeException = new NegativeArraySizeException();
        NativeMethods.setJCREentry(negativeArraySizeException, true);
        nullPointerException = new NullPointerException();
        NativeMethods.setJCREentry(nullPointerException, true);
        classCastException = new ClassCastException();
        NativeMethods.setJCREentry(classCastException, true);
        arithmeticException = new ArithmeticException();
        NativeMethods.setJCREentry(arithmeticException, true);
        securityException = new SecurityException();
        NativeMethods.setJCREentry(securityException, true);
        arrayStoreException = new ArrayStoreException();
        NativeMethods.setJCREentry(arrayStoreException, true);
        CardRuntimeException ex = new CardRuntimeException(0);
        NativeMethods.setJCREentry(ex, true);
        systemException = new SystemException(0);
        NativeMethods.setJCREentry(systemException, true);
        transactionException = new TransactionException(0);
        NativeMethods.setJCREentry(transactionException, true);
        serviceException = new ServiceException(0);
        NativeMethods.setJCREentry(serviceException, true);
        utilException = new UtilException(0);
        NativeMethods.setJCREentry(utilException, true);
    }

    Dispatcher() {
    }
}

