/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import java.util.HashSet;

public class EfNames {
    private static HashSet<String> reservedIdentifiers;

    public static boolean validClassName(String s) {
        int slash;
        while ((slash = s.indexOf(47)) >= 0) {
            if (!EfNames.validIdentifier(s.substring(0, slash))) {
                return false;
            }
            s = s.substring(slash + 1);
        }
        return EfNames.validIdentifier(s);
    }

    public static boolean validSrcFileName(String s) {
        int dot;
        while ((dot = s.indexOf(46)) >= 0) {
            if (!EfNames.validIdentifier(s.substring(0, dot))) {
                return false;
            }
            s = s.substring(dot + 1);
        }
        return EfNames.validIdentifier(s);
    }

    public static boolean validPackageName(String s) {
        return s.length() == 0 || EfNames.validClassName(s);
    }

    public static boolean isFieldReferenceType(String s) {
        switch (s.charAt(0)) {
            case 'B': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return false;
            }
            case 'L': 
            case '[': {
                return true;
            }
        }
        throw new RuntimeException("Invalid Descriptor " + s);
    }

    public static boolean validFieldName(String s) {
        return EfNames.validIdentifier(s);
    }

    public static boolean validMethodName(String s) {
        return s.equals("<init>") || EfNames.validIdentifier(s);
    }

    private static boolean validIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return !reservedIdentifiers.contains(s);
    }

    public static boolean validFieldDescriptor(String s) {
        return EfNames.checkDescriptor(s, 0) == s.length();
    }

    public static boolean validMethodDescriptor(String s) {
        int i;
        int len;
        block5: {
            len = s.length();
            if (len == 0) {
                return false;
            }
            if (s.charAt(0) != '(') {
                return false;
            }
            i = 1;
            do {
                if (i >= len) {
                    return false;
                }
                if (s.charAt(i) == ')') break block5;
            } while ((i = EfNames.checkDescriptor(s, i)) >= 0);
            return false;
        }
        if (++i == len - 1 && s.charAt(i) == 'V') {
            return true;
        }
        return EfNames.checkDescriptor(s, i) == len;
    }

    private static int checkDescriptor(String s, int pos) {
        if (pos >= s.length()) {
            return -1;
        }
        switch (s.charAt(pos)) {
            case 'B': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return pos + 1;
            }
            case 'L': {
                int semicolon = s.indexOf(59, pos + 1);
                if (semicolon >= 0 && EfNames.validClassName(s.substring(pos + 1, semicolon))) {
                    return semicolon + 1;
                }
                return -1;
            }
            case '[': {
                return EfNames.checkDescriptor(s, pos + 1);
            }
        }
        return -1;
    }

    static String prettyClass(String name) {
        return name.replace('/', '.');
    }

    static String prettyField(String name, String descr) {
        StringBuffer sb = new StringBuffer();
        EfNames.prettyDescriptor(descr, 0, sb);
        sb.append(' ');
        sb.append(name);
        return sb.toString();
    }

    public static String prettyMethod(String name, String descr) {
        StringBuffer sb = new StringBuffer();
        EfNames.prettyDescriptor(descr, descr.indexOf(41) + 1, sb);
        sb.append(' ');
        sb.append(name);
        sb.append('(');
        int pos = 1;
        if (descr.charAt(pos) != ')') {
            while (descr.charAt(pos = EfNames.prettyDescriptor(descr, pos, sb)) != ')') {
                sb.append(",");
            }
        }
        sb.append(')');
        return sb.toString();
    }

    private static int prettyDescriptor(String descr, int pos, StringBuffer sb) {
        switch (descr.charAt(pos)) {
            case 'B': {
                sb.append("byte");
                return pos + 1;
            }
            case 'I': {
                sb.append("int");
                return pos + 1;
            }
            case 'S': {
                sb.append("short");
                return pos + 1;
            }
            case 'Z': {
                sb.append("boolean");
                return pos + 1;
            }
            case 'V': {
                sb.append("void");
                return pos + 1;
            }
            case 'L': {
                int semicolon = descr.indexOf(59, pos + 1);
                sb.append(EfNames.prettyClass(descr.substring(pos + 1, semicolon)));
                return semicolon + 1;
            }
            case '[': {
                pos = EfNames.prettyDescriptor(descr, pos + 1, sb);
                sb.append("[]");
                return pos;
            }
        }
        return -1;
    }

    static {
        String[] reserved = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "this", "throw", "throws", "try", "void", "while", "true", "false", "null"};
        reservedIdentifiers = new HashSet();
        for (String element : reserved) {
            reservedIdentifiers.add(element);
        }
    }
}

