/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcbytecodeprofiler;

import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticMethodRefInfo;
import com.sun.javacard.jcbytecodeprofiler.CryptoAlgorithmInfo;
import com.sun.javacard.jcbytecodeprofiler.CryptoAlgorithmList;
import com.sun.javacard.jcbytecodeprofiler.InputPackageInfo;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.CryptoCallAnalyzer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCByteCodeProfiler {
    public static final String UNABLE_TO_DETERMINE_CRYPTO_ALGOS = "* Unable to determine all crypto algorithms used";
    Hashtable<Integer, Boolean> allInstructions;
    Vector<Integer> usedByteCodes = new Vector();
    Vector<Integer> unusedByteCodes = new Vector();
    Vector<String> usedCryptoAlgorithms = new Vector();
    Hashtable<String, Vector<String>> usedNativeMethods = new Hashtable();
    private static final int LOOK_BACK_FOR_KEY_BUILDER_ALGORITHM = 4;
    private static final int LOOK_BACK_FOR_KEY_BUILDER_MEM = 3;
    private static final int LOOK_BACK_FOR_KEY_BUILDER_LENGTH = 2;
    private static final int LOOK_BACK_FOR_SIGNATURE_MD_ALGO = 4;
    private static final int LOOK_BACK_FOR_SIGNATURE_CIPHER_ALGO = 3;
    private static final int LOOK_BACK_FOR_SIGNATURE_PAD_ALGO = 2;
    private static final int LOOK_BACK_FOR_CIPHER_GET_INSTNACE_CIPHER = 3;
    private static final int LOOK_BACK_FOR_CIPHER_GET_INSTNACE_PAD = 2;

    public JCByteCodeProfiler() {
        this.allInstructions = new Hashtable();
        for (int i = 0; i < 184; ++i) {
            this.allInstructions.put(i, false);
        }
    }

    void callSimulator(JCMethod callingMethod, JCClass callingClass) {
        CryptoCallAnalyzer.simulate(callingClass, callingMethod);
        for (String algoName : CryptoCallAnalyzer.cryptoAlgoNames) {
            if (this.usedCryptoAlgorithms.contains(algoName)) continue;
            this.usedCryptoAlgorithms.add(0, algoName);
        }
        if (!CryptoCallAnalyzer.allCryptoAlgosFound && !this.usedCryptoAlgorithms.contains(UNABLE_TO_DETERMINE_CRYPTO_ALGOS)) {
            this.usedCryptoAlgorithms.add(0, UNABLE_TO_DETERMINE_CRYPTO_ALGOS);
        }
    }

    boolean isValidIntermediateInstruction(Instruction anInstr) {
        switch (anInstr.getOpcode()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    boolean areIntermediateInstructionsValid(Vector<Statement> methodStatements, int index, int lookback) {
        if (lookback < 0) {
            lookback = lookback == -1 ? 4 : (lookback == -2 ? 4 : 3);
        }
        for (int i = 1; i <= lookback; ++i) {
            Statement st = methodStatements.elementAt(index - i);
            if (this.isValidIntermediateInstruction(st.getInstruction())) continue;
            return false;
        }
        return true;
    }

    Instruction getInstr(int index, int lookback, Vector<Statement> methodStatements) {
        int i = 1;
        Statement st = null;
        int count = 0;
        while (count < lookback) {
            st = methodStatements.elementAt(index - i);
            if (st != null) {
                if (!this.isValidIntermediateInstruction(st.getInstruction())) {
                    return null;
                }
                if (++count == lookback) break;
            }
            ++i;
        }
        if (st == null) {
            return null;
        }
        return st.getInstruction();
    }

    int getConstantValue(Instruction anInstr) {
        if (anInstr == null) {
            return -1;
        }
        switch (anInstr.getOpcode()) {
            case 16: {
                return anInstr.getOperand(0).getValue();
            }
            case 17: {
                return anInstr.getOperand(0).getValue();
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return -1;
    }

    String getConstantFieldName(Instruction anInstr, String className, int type) {
        if (anInstr == null) {
            return null;
        }
        int value = this.getConstantValue(anInstr);
        if (value == -1) {
            return null;
        }
        return CryptoAlgorithmList.getAlgoName(value, className, type);
    }

    void listFlexibleCryptoAlgorithmsUsed(int index, Vector<Statement> methodStatements, JCMethod m, JCMethod callingMethod, JCClass callingClass, int id) {
        boolean success = false;
        success = id == -1 ? this.listFlexKeyBuilderAlgorithms(index, methodStatements) : (id == -2 ? this.listFlexSignatureAlgorithms(index, methodStatements) : this.listFlexCipherAlgorithms(index, methodStatements));
        if (!success) {
            this.callSimulator(callingMethod, callingClass);
        }
    }

    boolean listFlexKeyBuilderAlgorithms(int index, Vector<Statement> instrs) {
        Instruction instrForAlgo = this.getInstr(index, 4, instrs);
        Instruction instrForMem = this.getInstr(index, 3, instrs);
        Instruction instrForLength = this.getInstr(index, 2, instrs);
        if (instrForAlgo == null || instrForMem == null || instrForLength == null) {
            return false;
        }
        String algoName = this.getConstantFieldName(instrForAlgo, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String memType = this.getConstantFieldName(instrForMem, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_MEM);
        String length = this.getConstantFieldName(instrForLength, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_KEY_LENGTH);
        if (algoName == null || memType == null || length == null) {
            return false;
        }
        String fullName = algoName + ", " + memType + "," + length;
        if (!this.usedCryptoAlgorithms.contains(fullName)) {
            this.usedCryptoAlgorithms.add(fullName);
        }
        return true;
    }

    boolean listFlexSignatureAlgorithms(int index, Vector<Statement> instrs) {
        Instruction instrForMDAlgo = this.getInstr(index, 4, instrs);
        Instruction instrForCipherAlgo = this.getInstr(index, 3, instrs);
        Instruction instrForPadAlgo = this.getInstr(index, 2, instrs);
        if (instrForMDAlgo == null || instrForCipherAlgo == null || instrForPadAlgo == null) {
            return false;
        }
        String MDAlgoName = this.getConstantFieldName(instrForMDAlgo, "javacard.security.MessageDigest", CryptoAlgorithmInfo.TYPE_NON_FLEX);
        String cipherAlgoName = this.getConstantFieldName(instrForCipherAlgo, "javacard.security.Signature", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String padAlgoName = this.getConstantFieldName(instrForPadAlgo, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (padAlgoName == null || cipherAlgoName == null || MDAlgoName == null) {
            return false;
        }
        String fullName = MDAlgoName + ", " + cipherAlgoName + "," + padAlgoName;
        if (!this.usedCryptoAlgorithms.contains(fullName)) {
            this.usedCryptoAlgorithms.add(fullName);
        }
        return true;
    }

    boolean listFlexCipherAlgorithms(int index, Vector<Statement> instrs) {
        Instruction instrForCipher = this.getInstr(index, 3, instrs);
        Instruction instrForPadding = this.getInstr(index, 2, instrs);
        if (instrForCipher == null || instrForPadding == null) {
            return false;
        }
        String cipherAlgoName = this.getConstantFieldName(instrForCipher, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String paddingAlgoName = this.getConstantFieldName(instrForPadding, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (cipherAlgoName == null || paddingAlgoName == null) {
            return false;
        }
        String fullName = cipherAlgoName + ", " + paddingAlgoName;
        if (!this.usedCryptoAlgorithms.contains(fullName)) {
            this.usedCryptoAlgorithms.add(fullName);
        }
        return true;
    }

    void listCryptoAlgorithmUsed(Instruction anInstr, JCMethod m, JCMethod callingMethod, JCClass callingClass) {
        int lastDot;
        if (anInstr == null) {
            this.callSimulator(callingMethod, callingClass);
            return;
        }
        int value = -1;
        switch (anInstr.getOpcode()) {
            case 16: {
                Operand op = anInstr.getOperands().elementAt(0);
                value = op.getValue();
                break;
            }
            case 3: {
                value = 0;
                break;
            }
            case 4: {
                value = 1;
                break;
            }
            case 5: {
                value = 2;
                break;
            }
            case 6: {
                value = 3;
                break;
            }
            case 7: {
                value = 4;
                break;
            }
            case 8: {
                value = 5;
                break;
            }
            default: {
                return;
            }
        }
        if (value == -1) {
            this.callSimulator(callingMethod, callingClass);
            return;
        }
        String fullCryptoClassName = m.getParentClass().getName().replace('/', '.');
        String algoName = fullCryptoClassName.substring((lastDot = fullCryptoClassName.lastIndexOf(".")) + 1) + "." + CryptoAlgorithmList.getAlgoName(value, fullCryptoClassName);
        if (!this.usedCryptoAlgorithms.contains(algoName)) {
            this.usedCryptoAlgorithms.add(algoName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void generateReport(InputPackageInfo inputPkgs, File folder) {
        block53: {
            IOException ex222222;
            FileOutputStream fos_usedCryptoAlgos;
            FileOutputStream fos_usednative;
            FileOutputStream fos_unused;
            FileOutputStream fos_used;
            block47: {
                Vector<JCPackage> pkgs = inputPkgs.getPackages();
                for (JCPackage p : pkgs) {
                    Enumeration<JCClass> pkgClasses = p.classElements();
                    while (pkgClasses.hasMoreElements()) {
                        JCClass c = pkgClasses.nextElement();
                        Vector<String> methods = new Vector<String>();
                        Enumeration<JCMethod> classMethods = c.methodElements();
                        while (classMethods.hasMoreElements()) {
                            JCMethod m = classMethods.nextElement();
                            if (Modifier.isNative(m.getAttributes())) {
                                methods.addElement(m.getFormattedMethod());
                            }
                            Vector<Statement> methodStatements = m.getStatements();
                            for (int i = 0; i < methodStatements.size(); ++i) {
                                Operand op;
                                StaticMethodRefInfo calledMethodInfo;
                                Integer lookback;
                                Statement stmt = methodStatements.elementAt(i);
                                int opCode = stmt.getInstruction().getOpcode();
                                if (opCode == 141 && (lookback = CryptoAlgorithmList.getBCLookBack((calledMethodInfo = (StaticMethodRefInfo)(op = stmt.getInstruction().getOperands().elementAt(0)).resolve()).getName())) != null) {
                                    if (!this.areIntermediateInstructionsValid(methodStatements, i, lookback)) {
                                        this.callSimulator(m, c);
                                        continue;
                                    }
                                    if (lookback < 0) {
                                        this.listFlexibleCryptoAlgorithmsUsed(i, methodStatements, (JCMethod)calledMethodInfo.resolve(), m, c, lookback);
                                    } else {
                                        this.listCryptoAlgorithmUsed(methodStatements.elementAt(i - lookback).getInstruction(), (JCMethod)calledMethodInfo.resolve(), m, c);
                                    }
                                }
                                this.allInstructions.put(opCode, true);
                            }
                        }
                        if (methods.size() <= 0) continue;
                        this.usedNativeMethods.put(c.getName(), methods);
                    }
                }
                for (int i = 0; i < 184; ++i) {
                    boolean used = this.allInstructions.get(i);
                    if (used) {
                        this.usedByteCodes.add(i);
                        continue;
                    }
                    this.unusedByteCodes.add(i);
                }
                fos_used = null;
                fos_unused = null;
                fos_usednative = null;
                fos_usedCryptoAlgos = null;
                File f1 = new File(folder, "usedbytecodes.list").getAbsoluteFile().getCanonicalFile();
                File f2 = new File(folder, "unusedbytecodes.list").getAbsoluteFile().getCanonicalFile();
                File f3 = new File(folder, "usednativemethods.list").getAbsoluteFile().getCanonicalFile();
                File f4 = new File(folder, "cryptoalgorithms.list").getAbsoluteFile().getCanonicalFile();
                fos_used = new FileOutputStream(f1);
                fos_unused = new FileOutputStream(f2);
                fos_usednative = new FileOutputStream(f3);
                fos_usedCryptoAlgos = new FileOutputStream(f4);
                for (int i : this.usedByteCodes) {
                    fos_used.write(Instruction.getMnemonic(i).getBytes());
                    fos_used.write("\n".getBytes());
                }
                for (int i : this.unusedByteCodes) {
                    fos_unused.write(Instruction.getMnemonic(i).getBytes());
                    fos_unused.write("\n".getBytes());
                }
                Enumeration<String> keys = this.usedNativeMethods.keys();
                ArrayList<String> sortedKeys = Collections.list(keys);
                Collections.sort(sortedKeys);
                keys = Collections.enumeration(sortedKeys);
                while (keys.hasMoreElements()) {
                    String className = keys.nextElement();
                    fos_usednative.write(className.replace("/", ".").getBytes());
                    fos_usednative.write("\n".getBytes());
                    Enumeration<String> methods = this.usedNativeMethods.get(className).elements();
                    while (methods.hasMoreElements()) {
                        String method = methods.nextElement();
                        fos_usednative.write(("      " + method).getBytes());
                        fos_usednative.write("\n".getBytes());
                    }
                }
                for (String name : this.usedCryptoAlgorithms) {
                    fos_usedCryptoAlgos.write(name.getBytes());
                    fos_usedCryptoAlgos.write("\n".getBytes());
                }
                Object var19_28 = null;
                if (fos_used == null) break block47;
                try {
                    fos_used.close();
                }
                catch (IOException ex222222) {
                    ex222222.printStackTrace();
                }
            }
            if (fos_unused != null) {
                try {
                    fos_unused.close();
                }
                catch (IOException ex222222) {
                    ex222222.printStackTrace();
                }
            }
            if (fos_usednative != null) {
                try {
                    fos_usednative.close();
                }
                catch (IOException ex222222) {
                    ex222222.printStackTrace();
                }
            }
            if (fos_usedCryptoAlgos != null) {
                try {
                    fos_usedCryptoAlgos.close();
                }
                catch (IOException ex222222) {
                    ex222222.printStackTrace();
                }
            }
            break block53;
            {
                catch (Exception ex3) {
                    IOException ex222222;
                    System.exit(10);
                    Object var19_29 = null;
                    if (fos_used != null) {
                        try {
                            fos_used.close();
                        }
                        catch (IOException ex222222) {
                            ex222222.printStackTrace();
                        }
                    }
                    if (fos_unused != null) {
                        try {
                            fos_unused.close();
                        }
                        catch (IOException ex222222) {
                            ex222222.printStackTrace();
                        }
                    }
                    if (fos_usednative != null) {
                        try {
                            fos_usednative.close();
                        }
                        catch (IOException ex222222) {
                            ex222222.printStackTrace();
                        }
                    }
                    if (fos_usedCryptoAlgos != null) {
                        try {
                            fos_usedCryptoAlgos.close();
                        }
                        catch (IOException ex222222) {
                            ex222222.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex222222;
                Object var19_30 = null;
                if (fos_used != null) {
                    try {
                        fos_used.close();
                    }
                    catch (IOException ex222222) {
                        ex222222.printStackTrace();
                    }
                }
                if (fos_unused != null) {
                    try {
                        fos_unused.close();
                    }
                    catch (IOException ex222222) {
                        ex222222.printStackTrace();
                    }
                }
                if (fos_usednative != null) {
                    try {
                        fos_usednative.close();
                    }
                    catch (IOException ex222222) {
                        ex222222.printStackTrace();
                    }
                }
                if (fos_usedCryptoAlgos != null) {
                    try {
                        fos_usedCryptoAlgos.close();
                    }
                    catch (IOException ex222222) {
                        ex222222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }
}

