/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tee.tools.util;

import com.oracle.tee.tools.util.ZipFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class CapFile
extends ZipFileSystem {
    public static final String COMPONENT_HEADER = "Header.cap";
    public static final String COMPONENT_DIRECTORY = "Directory.cap";
    public static final String COMPONENT_IMPORT = "Import.cap";
    public static final String COMPONENT_APPLET = "Applet.cap";
    public static final String COMPONENT_CLASS = "Class.cap";
    public static final String COMPONENT_METHOD = "Method.cap";
    public static final String COMPONENT_STATIC_FIELD = "StaticField.cap";
    public static final String COMPONENT_EXPORT = "Export.cap";
    public static final String COMPONENT_CONSTANT_POOL = "ConstantPool.cap";
    public static final String COMPONENT_REFERENCE_LOCATION = "RefLocation.cap";
    public static final String COMPONENT_DESCRIPTOR = "Descriptor.cap";
    public static final String COMPONENT_DEBUG = "Debug.cap";
    private final HashMap<String, String> map = new HashMap();

    public CapFile(File cap) throws IOException {
        super(cap, cap);
        for (String path : this.listAllFiles()) {
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (this.map.containsKey(name)) {
                throw new DuplicateComponentException(name);
            }
            this.map.put(name, path);
        }
    }

    public InputStream getComponent(String name) throws IOException {
        String path = this.map.get(name);
        return path == null ? null : this.openToRead(path);
    }

    public static class DuplicateComponentException
    extends IllegalArgumentException {
        DuplicateComponentException(String message) {
            super(message);
        }
    }
}

