/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Msg;
import java.io.DataOutputStream;
import java.io.IOException;

class MemoryMap {
    static final int MAX_MEM_SIZE = 65536;
    static final short MAX_CONTENTS = 32;
    static final int DEFAULT_ROM_SIZE = 32768;
    int memSize;
    int ROMSize;
    int EEPROMSize;
    short CORSize;
    short CODSize;
    short TBSize;
    short stackSize;
    short EENextAddress;
    short CORNextAddress;
    byte[] CODNextAddress = new byte[32];

    public MemoryMap(int t_romSize) {
        this.setMemDefaults();
        if (t_romSize != 0) {
            this.ROMSize = t_romSize;
            if (this.ROMSize + this.EEPROMSize + this.CODSize + this.CORSize + this.TBSize + this.stackSize > 65536) {
                Msg.warn("jref.6", null);
                this.ROMSize = 32768;
            }
        } else {
            this.ROMSize = 32768;
        }
    }

    private void setMemDefaults() {
        this.EEPROMSize = 24576;
        this.CORSize = (short)512;
        this.CODSize = (short)256;
        this.stackSize = (short)256;
        this.TBSize = (short)256;
    }

    public int getROMSize() {
        return this.ROMSize;
    }

    public int getE2Size() {
        return this.EEPROMSize;
    }

    public void setNextE2Address(short addr) {
        this.EENextAddress = addr;
    }

    void write(DataOutputStream os) throws IOException {
        os.writeShort(this.ROMSize);
        os.writeShort(this.EEPROMSize);
        os.writeShort(this.CORSize);
        os.writeShort(this.CODSize);
        os.writeShort(this.EENextAddress);
        os.writeShort(0);
        os.write(this.CODNextAddress);
    }
}

