#!/bin/sh -e
TARGETS="
	iso7816_cardem
	osmo-gtm900
"
PUBLISH_EXT="
	elf
	uf2
"

rm -rf build
mkdir build
cd build
cmake ..

for i in $TARGETS; do
	echo
	echo "=== make $i ==="
	echo

	make -j$(nproc) "$i"
done

if [ "$PUBLISH" = 1 ]; then
	echo
	echo "=== publishing binaries ==="
	echo

	SSH_COMMAND="ssh -o UserKnownHostsFile=/osmo-ci/contrib/known_hosts -p 48"

	VERSION="$(git describe HEAD)"
	if [ -z "$VERSION" ]; then
		echo "ERROR: failed to get version from 'git describe HEAD'"
		exit 1
	fi

	for target in $TARGETS; do
		UPLOAD_PATH="binaries@ftp.osmocom.org:web-files/osmo-rp2040-firmware/$target"

		for dir in all latest; do
			$SSH_COMMAND binaries@ftp.osmocom.org -- \
				mkdir -p "web-files/osmo-rp2040-firmware/$target/$dir"
		done

		EXISTING_BINARIES="$(rsync \
					--rsh "$SSH_COMMAND" \
					"$UPLOAD_PATH"/all/)"

		for ext in $PUBLISH_EXT; do
			BIN_PATH="$(find -name "$target.$ext")"
			if [ -z "$BIN_PATH" ]; then
				echo "ERROR: failed to find $target.$ext"
				exit 1
			fi

			BIN_LATEST="$target-$VERSION.$ext"
			if echo "$EXISTING_BINARIES" | grep -q "$BIN_LATEST"; then
				echo "$BIN_LATEST: exists on server, skipping"
				continue
			fi

			echo "$BIN_LATEST: uploading $BIN_PATH"

			rsync \
				--rsh "$SSH_COMMAND" \
				-a \
				"$BIN_PATH" \
				"$UPLOAD_PATH"/latest/"$target.$ext"

			rsync \
				--rsh "$SSH_COMMAND" \
				-a \
				"$BIN_PATH" \
				"$UPLOAD_PATH"/all/"$BIN_LATEST"
		done
	done
fi

echo
echo "=== success ==="
echo
