/*! \file crc8gen.h
 * Osmocom generic CRC routines (for max 8 bits poly) header. */
/*
 * Copyright (C) 2011  Sylvain Munaut <tnt@246tNt.com>
 *
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#pragma once

/*! \addtogroup crc
 *  @{
 * \file crc8gen.h.tpl */

#include <stdint.h>
#include <osmocom/core/bits.h>


/*! structure describing a given CRC code of max 8 bits */
struct osmo_crc8gen_code {
	int bits;           /*!< Actual number of bits of the CRC */
	uint8_t poly;      /*!< Polynom (normal representation, MSB omitted */
	uint8_t init;      /*!< Initialization value of the CRC state */
	uint8_t remainder; /*!< Remainder of the CRC (final XOR) */
};

uint8_t osmo_crc8gen_compute_bits(const struct osmo_crc8gen_code *code,
                                    const ubit_t *in, int len);
int osmo_crc8gen_check_bits(const struct osmo_crc8gen_code *code,
                             const ubit_t *in, int len, const ubit_t *crc_bits);
void osmo_crc8gen_set_bits(const struct osmo_crc8gen_code *code,
                            const ubit_t *in, int len, ubit_t *crc_bits);


/*! @} */

/* vim: set syntax=c: */
