//#include "HttpPort.hh"
//#include "http_layer_factory.hh"
//#include "http_layer.hh"
//#include "http_codec_emtel.hh"
#include "loggers.hh"

//#include "LibHttp_TypesAndValues.hh"
#include "NasEmu_Common4G5G.hh"

namespace NasEmu__Common4G5G {

  NASEMU5G__CO__ORD__PORT::NASEMU5G__CO__ORD__PORT(const char *par_port_name): NASEMU5G__CO__ORD__PORT_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(nullptr), _time_key("NASEMU5G__CO__ORD__PORT::contructor") {
    // Nothing to do
  } // End of constructor

  NASEMU5G__CO__ORD__PORT::~NASEMU5G__CO__ORD__PORT() {
    loggers::get_instance().log(">>> NASEMU5G__CO__ORD__PORT::~NASEMU5G__CO__ORD__PORT");

    if (_layer != nullptr) {
      delete _layer;
    }
  } // End of destructor

  void NASEMU5G__CO__ORD__PORT::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("NASEMU5G__CO__ORD__PORT::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void HttpPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void NASEMU5G__CO__ORD__PORT::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void NASEMU5G__CO__ORD__PORT::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void NASEMU5G__CO__ORD__PORT::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void HttpPort::Handle_Timeout(double time_since_last_call) {}*/

  void NASEMU5G__CO__ORD__PORT::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> NASEMU5G__CO__ORD__PORT::user_map: %s", system_port);
    // Build layer stack
    params::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("NASEMU5G__CO__ORD__PORT::user_map: %s", it->second.c_str());
      // Setup parameters
      params::convert(_layer_params, it->second); // TODO This _layer_params seems to be useless
      // Create layer
      //_layer = layer_stack_builder::get_instance()->create_layer_stack(it->second.c_str());
      /*if (static_cast<http_layer*>(_layer) == nullptr) {
        loggers::get_instance().error("NASEMU5G__CO__ORD__PORT::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      if (!static_cast<http_layer*>(_layer)->set_codec(new http_codec_emtel())) {
        loggers::get_instance().error("NASEMU5G__CO__ORD__PORT::user_map: Null codec");
      }
      static_cast<http_layer *>(_layer)->add_upper_port(this);*/
    } else {
      loggers::get_instance().error("NASEMU5G__CO__ORD__PORT::user_map: No layers defined in configuration file");
    }
  } // End of user_map method

  void NASEMU5G__CO__ORD__PORT::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> NASEMU5G__CO__ORD__PORT:user_unmap: %s", system_port);

    // Reset layers
    //if (_layer != nullptr) {
    //  delete _layer;
    //  _layer = nullptr;
    //}
  } // End of user_unmap method

  void NASEMU5G__CO__ORD__PORT::user_start()
  {
    loggers::get_instance().log(">>> NASEMU5G__CO__ORD__PORT::user_start");

  } // End of user_start method

  void NASEMU5G__CO__ORD__PORT::user_stop()
  {
    loggers::get_instance().log(">>> NASEMU5G__CO__ORD__PORT::user_stop");

  } // End of user_stop method

  void NASEMU5G__CO__ORD__PORT::outgoing_send(const  NasEmu__Common4G5G::NASEmu__CoOrd__CNF& send_par)
  {
    loggers::get_instance().log_msg(">>> NASEMU5G__CO__ORD__PORT::outgoing_send: payload=", send_par);
    
    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    //static_cast<http_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }

  void NASEMU5G__CO__ORD__PORT::receiveMsg (const  NasEmu__Common4G5G::NASEmu__CoOrd__REQ& p_ind, const params& p_params) {
    loggers::get_instance().log_msg(">>> NASEMU5G__CO__ORD__PORT::receive_msg: ", p_ind);
    // Sanity check
    if (!p_ind.is_bound()) {
      return;
    }

    incoming_message(p_ind);
  }
  
} // End of namespace NasEmu__Common4G5G 

