/*!
 * \file      ng_nas_dl_codec.hh
 * \brief     Header file for NG_NAS protocol codec.
 * \author    ETSI TTF041
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "codec_gen.hh"
#include "params.hh"

class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace NG__NAS__MsgContainers {
  class NG__NAS__DL__Message__Type;
}

class ng_nas_dl_codec: public codec_gen <NG__NAS__MsgContainers::NG__NAS__DL__Message__Type, NG__NAS__MsgContainers::NG__NAS__DL__Message__Type>
{
  int encode_(int level,const Base_Type &type, const TTCN_Typedescriptor_t &field_descriptor, TTCN_Buffer &encoding_buffer);

public:
  explicit ng_nas_dl_codec() : codec_gen<NG__NAS__MsgContainers::NG__NAS__DL__Message__Type, NG__NAS__MsgContainers::NG__NAS__DL__Message__Type>() { };
  virtual ~ng_nas_dl_codec() { };

  virtual int encode (const NG__NAS__MsgContainers::NG__NAS__DL__Message__Type& body, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& p_data, NG__NAS__MsgContainers::NG__NAS__DL__Message__Type& body, params* p_params = NULL);

}; // End of class ng_nas_dl_codec
