// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "RANAP_IEs.hh"

namespace RANAP__IEs {

/* Member functions of C++ classes */

SAI::SAI()
{
}

SAI::SAI(const OCTETSTRING& par_pLMNidentity,
    const OCTETSTRING& par_lAC,
    const OCTETSTRING& par_sAC,
    const OPTIONAL< _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 >& par_iE__Extensions)
  :   field_pLMNidentity(par_pLMNidentity),
  field_lAC(par_lAC),
  field_sAC(par_sAC),
  field_iE__Extensions(par_iE__Extensions)
{
}

SAI::SAI(const SAI& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.SAI.");
if (other_value.pLMNidentity().is_bound()) field_pLMNidentity = other_value.pLMNidentity();
else field_pLMNidentity.clean_up();
if (other_value.lAC().is_bound()) field_lAC = other_value.lAC();
else field_lAC.clean_up();
if (other_value.sAC().is_bound()) field_sAC = other_value.sAC();
else field_sAC.clean_up();
if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
else field_iE__Extensions.clean_up();
}

void SAI::clean_up()
{
field_pLMNidentity.clean_up();
field_lAC.clean_up();
field_sAC.clean_up();
field_iE__Extensions.clean_up();
}

const TTCN_Typedescriptor_t* SAI::get_descriptor() const { return &SAI_descr_; }
SAI& SAI::operator=(const SAI& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-IEs.SAI.");
  if (other_value.pLMNidentity().is_bound()) field_pLMNidentity = other_value.pLMNidentity();
  else field_pLMNidentity.clean_up();
  if (other_value.lAC().is_bound()) field_lAC = other_value.lAC();
  else field_lAC.clean_up();
  if (other_value.sAC().is_bound()) field_sAC = other_value.sAC();
  else field_sAC.clean_up();
  if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
  else field_iE__Extensions.clean_up();
}
return *this;
}

boolean SAI::operator==(const SAI& other_value) const
{
return field_pLMNidentity==other_value.field_pLMNidentity
  && field_lAC==other_value.field_lAC
  && field_sAC==other_value.field_sAC
  && field_iE__Extensions==other_value.field_iE__Extensions;
}

boolean SAI::is_bound() const
{
return (field_pLMNidentity.is_bound())
  || (field_lAC.is_bound())
  || (field_sAC.is_bound())
  || (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_bound());
}
boolean SAI::is_value() const
{
return field_pLMNidentity.is_value()
  && field_lAC.is_value()
  && field_sAC.is_value()
  && (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_value());
}
int SAI::size_of() const
{
  int ret_val = 3;
  if (field_iE__Extensions.ispresent()) ret_val++;
  return ret_val;
}

void SAI::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ pLMNidentity := ");
field_pLMNidentity.log();
TTCN_Logger::log_event_str(", lAC := ");
field_lAC.log();
TTCN_Logger::log_event_str(", sAC := ");
field_sAC.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
field_iE__Extensions.log();
TTCN_Logger::log_event_str(" }");
}

void SAI::set_implicit_omit()
{
if (pLMNidentity().is_bound()) pLMNidentity().set_implicit_omit();
if (lAC().is_bound()) lAC().set_implicit_omit();
if (sAC().is_bound()) sAC().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
}

void SAI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RANAP-IEs.SAI has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pLMNidentity().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lAC().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sAC().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pLMNidentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pLMNidentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lAC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lAC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sAC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sAC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.SAI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-IEs.SAI");
  }
}

void SAI::encode_text(Text_Buf& text_buf) const
{
field_pLMNidentity.encode_text(text_buf);
field_lAC.encode_text(text_buf);
field_sAC.encode_text(text_buf);
field_iE__Extensions.encode_text(text_buf);
}

void SAI::decode_text(Text_Buf& text_buf)
{
field_pLMNidentity.decode_text(text_buf);
field_lAC.decode_text(text_buf);
field_sAC.decode_text(text_buf);
field_iE__Extensions.decode_text(text_buf);
}

void SAI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SAI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* SAI::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("pLMNidentity': ");
  new_tlv->add_TLV(field_pLMNidentity.BER_encode_TLV(SAI_pLMNidentity_descr_, p_coding));
  ec_1.set_msg("lAC': ");
  new_tlv->add_TLV(field_lAC.BER_encode_TLV(SAI_lAC_descr_, p_coding));
  ec_1.set_msg("sAC': ");
  new_tlv->add_TLV(field_sAC.BER_encode_TLV(SAI_sAC_descr_, p_coding));
  ec_1.set_msg("iE_Extensions': ");
  new_tlv->add_TLV(field_iE__Extensions.BER_encode_TLV(SAI_iE__Extensions_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean SAI::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-IEs.SAI' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("pLMNidentity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_pLMNidentity.BER_decode_TLV(SAI_pLMNidentity_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("lAC': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_lAC.BER_decode_TLV(SAI_lAC_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("sAC': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_sAC.BER_decode_TLV(SAI_sAC_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("iE_Extensions': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_iE__Extensions=OMIT_VALUE;
    else {
      field_iE__Extensions.BER_decode_TLV(SAI_iE__Extensions_descr_, tmp_tlv, L_form);
      if(field_iE__Extensions.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int SAI::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.SAI.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pLMNidentity");
    enc_len += field_pLMNidentity.JSON_encode(SAI_pLMNidentity_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "lAC");
    enc_len += field_lAC.JSON_encode(SAI_lAC_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sAC");
    enc_len += field_sAC.JSON_encode(SAI_sAC_descr_, p_tok, FALSE);
  }

  if (field_iE__Extensions.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "iE_Extensions");
    enc_len += field_iE__Extensions.JSON_encode(SAI_iE__Extensions_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int SAI::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const SAI*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean pLMNidentity_found = FALSE;
  boolean lAC_found = FALSE;
  boolean sAC_found = FALSE;
  boolean iE__Extensions_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (12 == name_len && 0 == strncmp(fld_name, "pLMNidentity", name_len)) {
        pLMNidentity_found = TRUE;
         int ret_val = field_pLMNidentity.JSON_decode(SAI_pLMNidentity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "pLMNidentity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (3 == name_len && 0 == strncmp(fld_name, "lAC", name_len)) {
        lAC_found = TRUE;
         int ret_val = field_lAC.JSON_decode(SAI_lAC_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 3, "lAC");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (3 == name_len && 0 == strncmp(fld_name, "sAC", name_len)) {
        sAC_found = TRUE;
         int ret_val = field_sAC.JSON_decode(SAI_sAC_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 3, "sAC");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "iE_Extensions", name_len)) {
        iE__Extensions_found = TRUE;
         int ret_val = field_iE__Extensions.JSON_decode(SAI_iE__Extensions_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "iE_Extensions");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!pLMNidentity_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "pLMNidentity");
    return JSON_ERROR_FATAL;
  }
  if (!lAC_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "lAC");
    return JSON_ERROR_FATAL;
  }
  if (!sAC_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "sAC");
    return JSON_ERROR_FATAL;
  }
  if (!iE__Extensions_found) {
    field_iE__Extensions = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int SAI::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_iE__Extensions.is_present()) {
    c |= 128;
  }
  p_buf.put_c(c);
  field_pLMNidentity.OER_encode(SAI_pLMNidentity_descr_, p_buf);
  field_lAC.OER_encode(SAI_lAC_descr_, p_buf);
  field_sAC.OER_encode(SAI_sAC_descr_, p_buf);
  if (field_iE__Extensions.is_present())
    field_iE__Extensions.OER_encode(SAI_iE__Extensions_descr_, p_buf);
  return 0;
}

int SAI::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  field_pLMNidentity.OER_decode(SAI_pLMNidentity_descr_, p_buf, p_oer);
  field_lAC.OER_decode(SAI_lAC_descr_, p_buf, p_oer);
  field_sAC.OER_decode(SAI_sAC_descr_, p_buf, p_oer);
  if (uc[0] & 128)
    field_iE__Extensions.OER_decode(SAI_iE__Extensions_descr_, p_buf, p_oer);
 else
    field_iE__Extensions = OMIT_VALUE;
  return 0;
}

void SAI::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_iE__Extensions_present = field_iE__Extensions.is_present();
p_buf.PER_put_bit(field_iE__Extensions_present);
field_pLMNidentity.PER_encode(SAI_pLMNidentity_descr_, p_buf, p_options);
field_lAC.PER_encode(SAI_lAC_descr_, p_buf, p_options);
field_sAC.PER_encode(SAI_sAC_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_encode(SAI_iE__Extensions_descr_, p_buf, p_options);
}

void SAI::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_iE__Extensions_present = p_buf.PER_get_bit();
field_pLMNidentity.PER_decode(SAI_pLMNidentity_descr_, p_buf, p_options);
field_lAC.PER_decode(SAI_lAC_descr_, p_buf, p_options);
field_sAC.PER_decode(SAI_sAC_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_decode(SAI_iE__Extensions_descr_, p_buf, p_options);
else field_iE__Extensions = OMIT_VALUE;
}

struct SAI_template::single_value_struct {
OCTETSTRING_template field_pLMNidentity;
OCTETSTRING_template field_lAC;
OCTETSTRING_template field_sAC;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template field_iE__Extensions;
};

void SAI_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_pLMNidentity = ANY_VALUE;
single_value->field_lAC = ANY_VALUE;
single_value->field_sAC = ANY_VALUE;
single_value->field_iE__Extensions = ANY_OR_OMIT;
}
}
}

void SAI_template::copy_value(const SAI& other_value)
{
single_value = new single_value_struct;
if (other_value.pLMNidentity().is_bound()) {
  single_value->field_pLMNidentity = other_value.pLMNidentity();
} else {
  single_value->field_pLMNidentity.clean_up();
}
if (other_value.lAC().is_bound()) {
  single_value->field_lAC = other_value.lAC();
} else {
  single_value->field_lAC.clean_up();
}
if (other_value.sAC().is_bound()) {
  single_value->field_sAC = other_value.sAC();
} else {
  single_value->field_sAC.clean_up();
}
if (other_value.iE__Extensions().is_bound()) {
  if (other_value.iE__Extensions().ispresent()) single_value->field_iE__Extensions = other_value.iE__Extensions()();
  else single_value->field_iE__Extensions = OMIT_VALUE;
} else {
  single_value->field_iE__Extensions.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SAI_template::copy_template(const SAI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.pLMNidentity().get_selection()) {
single_value->field_pLMNidentity = other_value.pLMNidentity();
} else {
single_value->field_pLMNidentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lAC().get_selection()) {
single_value->field_lAC = other_value.lAC();
} else {
single_value->field_lAC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sAC().get_selection()) {
single_value->field_sAC = other_value.sAC();
} else {
single_value->field_sAC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iE__Extensions().get_selection()) {
single_value->field_iE__Extensions = other_value.iE__Extensions();
} else {
single_value->field_iE__Extensions.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SAI_template(*other_value.implication_.precondition);
implication_.implied_template = new SAI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.SAI.");
break;
}
set_selection(other_value);
}

SAI_template::SAI_template()
{
}

SAI_template::SAI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SAI_template::SAI_template(const SAI& other_value)
{
copy_value(other_value);
}

SAI_template::SAI_template(const OPTIONAL<SAI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.SAI from an unbound optional field.");
}
}

SAI_template::SAI_template(SAI_template* p_precondition, SAI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SAI_template::SAI_template(Dynamic_Match_Interface<SAI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SAI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SAI_template::SAI_template(const SAI_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SAI_template::~SAI_template()
{
clean_up();
}

SAI_template& SAI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SAI_template& SAI_template::operator=(const SAI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SAI_template& SAI_template::operator=(const OPTIONAL<SAI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.SAI.");
}
return *this;
}

SAI_template& SAI_template::operator=(const SAI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SAI_template::match(const SAI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.pLMNidentity().is_bound()) return FALSE;
if(!single_value->field_pLMNidentity.match(other_value.pLMNidentity(), legacy))return FALSE;
if(!other_value.lAC().is_bound()) return FALSE;
if(!single_value->field_lAC.match(other_value.lAC(), legacy))return FALSE;
if(!other_value.sAC().is_bound()) return FALSE;
if(!single_value->field_sAC.match(other_value.sAC(), legacy))return FALSE;
if(!other_value.iE__Extensions().is_bound()) return FALSE;
if((other_value.iE__Extensions().ispresent() ? !single_value->field_iE__Extensions.match((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19&)other_value.iE__Extensions(), legacy) : !single_value->field_iE__Extensions.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-IEs.SAI.");
}
return FALSE;
}

boolean SAI_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_pLMNidentity.is_bound()
 || single_value->field_lAC.is_bound()
 || single_value->field_sAC.is_bound()
 || (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_bound());
}

boolean SAI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_pLMNidentity.is_value()
 && single_value->field_lAC.is_value()
 && single_value->field_sAC.is_value()
 && (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_value());
}

void SAI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SAI SAI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.SAI.");
SAI ret_val;
if (single_value->field_pLMNidentity.is_bound()) {
ret_val.pLMNidentity() = single_value->field_pLMNidentity.valueof();
}
if (single_value->field_lAC.is_bound()) {
ret_val.lAC() = single_value->field_lAC.valueof();
}
if (single_value->field_sAC.is_bound()) {
ret_val.sAC() = single_value->field_sAC.valueof();
}
if (single_value->field_iE__Extensions.is_omit()) ret_val.iE__Extensions() = OMIT_VALUE;
else if (single_value->field_iE__Extensions.is_bound()) {
ret_val.iE__Extensions() = single_value->field_iE__Extensions.valueof();
}
return ret_val;
}

void SAI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-IEs.SAI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SAI_template[list_length];
}

SAI_template& SAI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-IEs.SAI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-IEs.SAI.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& SAI_template::pLMNidentity()
{
set_specific();
return single_value->field_pLMNidentity;
}

const OCTETSTRING_template& SAI_template::pLMNidentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pLMNidentity of a non-specific template of type @RANAP-IEs.SAI.");
return single_value->field_pLMNidentity;
}

OCTETSTRING_template& SAI_template::lAC()
{
set_specific();
return single_value->field_lAC;
}

const OCTETSTRING_template& SAI_template::lAC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lAC of a non-specific template of type @RANAP-IEs.SAI.");
return single_value->field_lAC;
}

OCTETSTRING_template& SAI_template::sAC()
{
set_specific();
return single_value->field_sAC;
}

const OCTETSTRING_template& SAI_template::sAC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sAC of a non-specific template of type @RANAP-IEs.SAI.");
return single_value->field_sAC;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& SAI_template::iE__Extensions()
{
set_specific();
return single_value->field_iE__Extensions;
}

const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& SAI_template::iE__Extensions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iE_Extensions of a non-specific template of type @RANAP-IEs.SAI.");
return single_value->field_iE__Extensions;
}

int SAI_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_iE__Extensions.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.SAI containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-IEs.SAI.");
  }
  return 0;
}

void SAI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ pLMNidentity := ");
single_value->field_pLMNidentity.log();
TTCN_Logger::log_event_str(", lAC := ");
single_value->field_lAC.log();
TTCN_Logger::log_event_str(", sAC := ");
single_value->field_sAC.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SAI_template::log_match(const SAI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_pLMNidentity.match(match_value.pLMNidentity(), legacy)){
TTCN_Logger::log_logmatch_info(".pLMNidentity");
single_value->field_pLMNidentity.log_match(match_value.pLMNidentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lAC.match(match_value.lAC(), legacy)){
TTCN_Logger::log_logmatch_info(".lAC");
single_value->field_lAC.log_match(match_value.lAC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sAC.match(match_value.sAC(), legacy)){
TTCN_Logger::log_logmatch_info(".sAC");
single_value->field_sAC.log_match(match_value.sAC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.iE__Extensions().ispresent()){
if(!single_value->field_iE__Extensions.match(match_value.iE__Extensions(), legacy)){
TTCN_Logger::log_logmatch_info(".iE_Extensions");
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_iE__Extensions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".iE_Extensions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ pLMNidentity := ");
single_value->field_pLMNidentity.log_match(match_value.pLMNidentity(), legacy);
TTCN_Logger::log_event_str(", lAC := ");
single_value->field_lAC.log_match(match_value.lAC(), legacy);
TTCN_Logger::log_event_str(", sAC := ");
single_value->field_sAC.log_match(match_value.sAC(), legacy);
TTCN_Logger::log_event_str(", iE_Extensions := ");
if (match_value.iE__Extensions().ispresent()) {
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_iE__Extensions.log();
if (single_value->field_iE__Extensions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SAI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (pLMNidentity().is_bound()) pLMNidentity().set_implicit_omit();
if (lAC().is_bound()) lAC().set_implicit_omit();
if (sAC().is_bound()) sAC().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
}

void SAI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_pLMNidentity.encode_text(text_buf);
single_value->field_lAC.encode_text(text_buf);
single_value->field_sAC.encode_text(text_buf);
single_value->field_iE__Extensions.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.SAI.");
}
}

void SAI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_pLMNidentity.decode_text(text_buf);
single_value->field_lAC.decode_text(text_buf);
single_value->field_sAC.decode_text(text_buf);
single_value->field_iE__Extensions.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-IEs.SAI.");
}
}

void SAI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SAI_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RANAP-IEs.SAI has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pLMNidentity().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lAC().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sAC().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pLMNidentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pLMNidentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lAC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lAC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sAC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sAC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.SAI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SAI_template* precondition = new SAI_template;
    precondition->set_param(*param.get_elem(0));
    SAI_template* implied_template = new SAI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SAI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-IEs.SAI");
  }
  is_ifpresent = param.get_ifpresent();
}

void SAI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_pLMNidentity.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.SAI");
single_value->field_lAC.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.SAI");
single_value->field_sAC.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.SAI");
single_value->field_iE__Extensions.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.SAI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.SAI");
}

boolean SAI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SAI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::UNBOUND_ELEM;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19()
{
val_ptr = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return val_ptr->n_elements == 0 ;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator==(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19;
}
return *val_ptr->value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return (*this)[(int)index_value];
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::operator+(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return val_ptr->n_elements;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    new_tlv=ASN_BER_TLV_t::construct(NULL);
    TTCN_EncDec_ErrorContext ec;
    for(int elem_i=0; elem_i<val_ptr->n_elements; elem_i++) {
      ec.set_msg("Component #%d: ", elem_i);
      new_tlv->add_TLV((*this)[elem_i].BER_encode_TLV(*p_td.oftype_descr, p_coding));
    }
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '%s' type: ", p_td.name);
  stripped_tlv.chk_constructed_flag(TRUE);
  clean_up();
  val_ptr = new recordof_setof_struct;
  val_ptr->ref_count = 1;
  val_ptr->n_elements = 0;
  val_ptr->value_elements = NULL;
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  TTCN_EncDec_ErrorContext ec_1("Component #");
  TTCN_EncDec_ErrorContext ec_2("0: ");
  while(BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv)) {
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->n_elements++;
    val_ptr->value_elements[val_ptr->n_elements - 1] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19;
    val_ptr->value_elements[val_ptr->n_elements - 1]->BER_decode_TLV(*p_td.oftype_descr, tmp_tlv, L_form);
    ec_2.set_msg("%d: ", val_ptr->n_elements);
  }
  return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_START : JSON_TOKEN_ARRAY_START, NULL);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    if (p_td.json->metainfo_unbound && !(*this)[i].is_bound()) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "metainfo []");
      enc_len += p_tok.put_next_token(JSON_TOKEN_STRING, "\"unbound\"");
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
    }
    else {
      int ret_val = (*this)[i].JSON_encode(*p_td.oftype_descr, p_tok, p_td.json->as_map);
      if (0 > ret_val) break;
      enc_len += ret_val;
    }
  }
  enc_len += p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_END : JSON_TOKEN_ARRAY_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    set_size(0);
    return strlen(p_td.json->default_value.str);
  }
  json_token_t token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&token, NULL, NULL);
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_START != token) ||
           (p_td.json->as_map && JSON_TOKEN_OBJECT_START != token)) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  set_size(0);
  for (int nof_elements = 0; TRUE; ++nof_elements) {
    size_t buf_pos = p_tok.get_buf_pos();
    size_t ret_val;
    if (p_td.json->metainfo_unbound) {
      ret_val = p_tok.get_next_token(&token, NULL, NULL);
      if (JSON_TOKEN_OBJECT_START == token) {
        char* value = NULL;
        size_t value_len = 0;
        ret_val += p_tok.get_next_token(&token, &value, &value_len);
        if (JSON_TOKEN_NAME == token && 11 == value_len &&
            0 == strncmp(value, "metainfo []", 11)) {
          ret_val += p_tok.get_next_token(&token, &value, &value_len);
          if (JSON_TOKEN_STRING == token && 9 == value_len &&
              0 == strncmp(value, "\"unbound\"", 9)) {
            ret_val = p_tok.get_next_token(&token, NULL, NULL);
            if (JSON_TOKEN_OBJECT_END == token) {
              dec_len += ret_val;
              continue;
            }
          }
        }
      }
      p_tok.set_buf_pos(buf_pos);
    }
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19* val = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19;
    int ret_val2 = val->JSON_decode(*p_td.oftype_descr, p_tok, p_silent, p_td.json->as_map);
    if (JSON_ERROR_INVALID_TOKEN == ret_val2) {
      p_tok.set_buf_pos(buf_pos);
      delete val;
      break;
    }
    else if (JSON_ERROR_FATAL == ret_val2) {
      delete val;
      if (p_silent) {
        clean_up();
      }
      return JSON_ERROR_FATAL;
    }
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19**)reallocate_pointers(
      (void**)val_ptr->value_elements, val_ptr->n_elements, nof_elements + 1);
    val_ptr->value_elements[nof_elements] = val;
    val_ptr->n_elements = nof_elements + 1;
    dec_len += (size_t)ret_val2;
  }

  dec_len += p_tok.get_next_token(&token, NULL, NULL);
  if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_END != token) ||
      (p_td.json->as_map && JSON_TOKEN_OBJECT_END != token)) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_REC_OF_END_TOKEN_ERROR, "");
    if (p_silent) {
      clean_up();
    }
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::OER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
    return -1;
  }

  encode_oer_length(val_ptr->n_elements, p_buf, TRUE);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    (*this)[i].OER_encode(*p_td.oftype_descr, p_buf);
  }
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::OER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t nof_elem = decode_oer_length(p_buf, TRUE);
  set_size(nof_elem);
  for (size_t i = 0; i < nof_elem; i++) {
    (*this)[i].OER_decode(*p_td.oftype_descr, p_buf, p_oer);
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
"Encoding an unbound SEQUENCE OF value.");
return;
}
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
INTEGER length(val_ptr->n_elements);
boolean extendable = cons->has_extension_marker();
boolean within_ext_root = cons->is_within_extension_root(length);
if (!within_ext_root && !extendable) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT,
"Encoding an invalid SEQUENCE OF value (does not match PER-visible constraints).");
return;
}
boolean ext_bit = extendable && !within_ext_root;
if (extendable) p_buf.PER_put_bit(ext_bit);
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
if (range == 1 && length == 0) return;
int mul_16k;
int pos = 0;
do {
mul_16k = (range == 1) ? 0 : length.PER_encode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
int elements_encoded = (mul_16k == 0) ? (int)length : mul_16k * PER_16K;
for (int i = 0; i < elements_encoded; ++i) {
(*this)[i + pos].PER_encode(*p_td.oftype_descr, p_buf, p_options);
}
if (mul_16k > 0) {
pos += elements_encoded;
length = length - elements_encoded;
range = 0;
}
}
while (mul_16k > 0);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
clean_up();
boolean extendable = cons->has_extension_marker();
boolean ext_bit = extendable ? p_buf.PER_get_bit() : FALSE;
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
int mul_16k;
INTEGER length;
int current_size = 0;
do {
mul_16k = length.PER_decode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
if (mul_16k != 0) range = 0;
int new_size = current_size + (int)length;
set_size(new_size);
for (int i = current_size; i < new_size; ++i) {
(*this)[i].PER_decode(*p_td.oftype_descr, p_buf, p_options);
}
current_size = new_size;
}
while (mul_16k > 0);
if (!ext_bit && !cons->is_within_extension_root(val_ptr->n_elements)) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT, "Decoded SEQUENCE OF value does not match PER-visible constraints.");
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
break;
}
set_selection(other_value);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19*)value_ptr)[value_index], legacy);
else return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template()
{
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
    break;
}
return *single_value.value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return (*this)[(int)index_value];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19 containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
}
set_selection(template_type);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
return value_list.list_value[list_index];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::log_match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template* precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst19");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst19_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value)
{
switch (other_value.union_selection) {
default:
TTCN_error("Assignment of an unbound union value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
union_selection = other_value.union_selection;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type()
{
union_selection = UNBOUND_VALUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value)
: Base_Type(){
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
default:
return FALSE;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
return union_selection == checked_selection;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
default: TTCN_error("Invalid selection in union is_bound");}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::clean_up()
{
switch (union_selection) {
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::log() const
{
switch (union_selection) {
default:
TTCN_Logger::log_event_unbound();
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.", last_name);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::set_implicit_omit()
{
switch (union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type' type: ");
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tlv_opentype)) {
    tlv_opentype.Tlen = 0;
    return FALSE;
  }
  clean_up();
  union_selection = UNBOUND_VALUE;
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean) const
{
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
    "Cannot encode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type, because it has zero alternatives.");
  return -1;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, 
    "Cannot decode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type, because it has zero alternatives.");
  return JSON_ERROR_FATAL;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
    return -1;
  }

  return 0;
}
int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t pos = decode_oer_length(p_buf, FALSE);
  size_t prev_pos = p_buf.get_pos();
  p_buf.increase_pos(pos);
  p_oer.opentype_poses.push_back(prev_pos);
  return 0;
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
default:
TTCN_error("Initializing a template with an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& other_value)
: Base_Template(){
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::union_selection_type value_selection = other_value.get_selection();
if (value_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type ret_val;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
return value_list.list_value[list_index];
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template[list_length];
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::ischosen(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::union_selection_type checked_selection) const
{
if (checked_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
switch (single_value.union_selection) {
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::UNBOUND_VALUE;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::union_selection_type new_selection = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type'");
    }
    param.error("Field `%s' not found in union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template;
    precondition->set_param(*m_p->get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.extensionValue.type");
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(const INTEGER& par_id,
    const RANAP__CommonDataTypes::Criticality& par_criticality,
    const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type& par_extensionValue)
  :   field_id(par_id),
  field_criticality(par_criticality),
  field_extensionValue(par_extensionValue)
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
if (other_value.id().is_bound()) field_id = other_value.id();
else field_id.clean_up();
if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
else field_criticality.clean_up();
if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
else field_extensionValue.clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::clean_up()
{
field_id.clean_up();
field_criticality.clean_up();
field_extensionValue.clean_up();
}

const TTCN_Typedescriptor_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::get_descriptor() const { return &_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_descr_; }
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
  if (other_value.id().is_bound()) field_id = other_value.id();
  else field_id.clean_up();
  if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
  else field_criticality.clean_up();
  if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
  else field_extensionValue.clean_up();
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value) const
{
return field_id==other_value.field_id
  && field_criticality==other_value.field_criticality
  && field_extensionValue==other_value.field_extensionValue;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::is_bound() const
{
return (field_id.is_bound())
  || (field_criticality.is_bound())
  || (field_extensionValue.is_bound());
}
boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::is_value() const
{
return field_id.is_value()
  && field_criticality.is_value()
  && field_extensionValue.is_value();
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ id := ");
field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::set_implicit_omit()
{
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19");
  }
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::encode_text(Text_Buf& text_buf) const
{
field_id.encode_text(text_buf);
field_criticality.encode_text(text_buf);
field_extensionValue.encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::decode_text(Text_Buf& text_buf)
{
field_id.decode_text(text_buf);
field_criticality.decode_text(text_buf);
field_extensionValue.decode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  new_tlv->add_TLV(field_id.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_coding));
  ec_1.set_msg("criticality': ");
  new_tlv->add_TLV(field_criticality.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_coding));
  ec_1.set_msg("extensionValue': ");
  new_tlv->add_TLV(field_extensionValue.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("id': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_id.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("criticality': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_criticality.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionValue': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_extensionValue.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");
  TTCN_Type_list p_typelist;
  BER_decode_opentypes(p_typelist, L_form);
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("criticality': ");
  field_criticality.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.BER_decode_opentypes(p_typelist, L_form);
  p_typelist.pop();
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "id");
    enc_len += field_id.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "criticality");
    enc_len += field_criticality.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionValue");
    enc_len += field_extensionValue.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean id_found = FALSE;
  boolean criticality_found = FALSE;
  boolean extensionValue_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (2 == name_len && 0 == strncmp(fld_name, "id", name_len)) {
        id_found = TRUE;
         int ret_val = field_id.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "id");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "criticality", name_len)) {
        criticality_found = TRUE;
         int ret_val = field_criticality.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "criticality");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "extensionValue", name_len)) {
        extensionValue_found = TRUE;
         int ret_val = field_extensionValue.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "extensionValue");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!id_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "id");
    return JSON_ERROR_FATAL;
  }
  if (!criticality_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "criticality");
    return JSON_ERROR_FATAL;
  }
  if (!extensionValue_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "extensionValue");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  field_id.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_buf);
  field_criticality.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_buf);
  field_extensionValue.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_buf);
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  field_id.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_buf, p_oer);
  field_criticality.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_buf, p_oer);
  field_extensionValue.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_buf, p_oer);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");  TTCN_Type_list p_typelist;
  OER_decode_opentypes(p_typelist, p_buf, p_oer);
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("criticality': ");
  field_criticality.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  p_typelist.pop();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
field_id.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_buf, p_options);
field_criticality.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_buf, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
field_id.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_id_descr_, p_buf, p_options);
field_criticality.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_descr_, p_buf, p_options);
TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");TTCN_Type_list p_typelist;
PER_decode_opentypes(p_typelist, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19::PER_decode_opentypes(TTCN_Type_list& p_typelist, int p_options)
{
p_typelist.push(this);
TTCN_EncDec_ErrorContext ec_0("Component '");
TTCN_EncDec_ErrorContext ec_1;
ec_1.set_msg("id': ");
field_id.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("criticality': ");
field_criticality.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("extensionValue': ");
field_extensionValue.PER_decode_opentypes(p_typelist, p_options);
p_typelist.pop();
}

struct _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::single_value_struct {
INTEGER_template field_id;
RANAP__CommonDataTypes::Criticality_template field_criticality;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template field_extensionValue;
};

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_id = ANY_VALUE;
single_value->field_criticality = ANY_VALUE;
single_value->field_extensionValue = ANY_VALUE;
}
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value)
{
single_value = new single_value_struct;
if (other_value.id().is_bound()) {
  single_value->field_id = other_value.id();
} else {
  single_value->field_id.clean_up();
}
if (other_value.criticality().is_bound()) {
  single_value->field_criticality = other_value.criticality();
} else {
  single_value->field_criticality.clean_up();
}
if (other_value.extensionValue().is_bound()) {
  single_value->field_extensionValue = other_value.extensionValue();
} else {
  single_value->field_extensionValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.id().get_selection()) {
single_value->field_id = other_value.id();
} else {
single_value->field_id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.criticality().get_selection()) {
single_value->field_criticality = other_value.criticality();
} else {
single_value->field_criticality.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionValue().get_selection()) {
single_value->field_extensionValue = other_value.extensionValue();
} else {
single_value->field_extensionValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
break;
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.id().is_bound()) return FALSE;
if(!single_value->field_id.match(other_value.id(), legacy))return FALSE;
if(!other_value.criticality().is_bound()) return FALSE;
if(!single_value->field_criticality.match(other_value.criticality(), legacy))return FALSE;
if(!other_value.extensionValue().is_bound()) return FALSE;
if(!single_value->field_extensionValue.match(other_value.extensionValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_id.is_bound()
 || single_value->field_criticality.is_bound()
 || single_value->field_extensionValue.is_bound();
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_id.is_value()
 && single_value->field_criticality.is_value()
 && single_value->field_extensionValue.is_value();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19 _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19 ret_val;
if (single_value->field_id.is_bound()) {
ret_val.id() = single_value->field_id.valueof();
}
if (single_value->field_criticality.is_bound()) {
ret_val.criticality() = single_value->field_criticality.valueof();
}
if (single_value->field_extensionValue.is_bound()) {
ret_val.extensionValue() = single_value->field_extensionValue.valueof();
}
return ret_val;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template[list_length];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
return value_list.list_value[list_index];
}

INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::id()
{
set_specific();
return single_value->field_id;
}

const INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
return single_value->field_id;
}

RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::criticality()
{
set_specific();
return single_value->field_criticality;
}

const RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::criticality() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field criticality of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
return single_value->field_criticality;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::extensionValue()
{
set_specific();
return single_value->field_extensionValue;
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::extensionValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionValue of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
return single_value->field_extensionValue;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_id.match(match_value.id(), legacy)){
TTCN_Logger::log_logmatch_info(".id");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_criticality.match(match_value.criticality(), legacy)){
TTCN_Logger::log_logmatch_info(".criticality");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_extensionValue.match(match_value.extensionValue(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionValue");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_id.encode_text(text_buf);
single_value->field_criticality.encode_text(text_buf);
single_value->field_extensionValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_id.decode_text(text_buf);
single_value->field_criticality.decode_text(text_buf);
single_value->field_extensionValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_id.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19");
single_value->field_criticality.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19");
single_value->field_extensionValue.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst19");
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst19_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void GeographicalArea::copy_value(const GeographicalArea& other_value)
{
switch (other_value.union_selection) {
case ALT_point:
field_point = new GA__Point(*other_value.field_point);
break;
case ALT_pointWithUnCertainty:
field_pointWithUnCertainty = new GA__PointWithUnCertainty(*other_value.field_pointWithUnCertainty);
break;
case ALT_polygon:
field_polygon = new GA__Polygon(*other_value.field_polygon);
break;
case ALT_pointWithUncertaintyEllipse:
field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse(*other_value.field_pointWithUncertaintyEllipse);
break;
case ALT_pointWithAltitude:
field_pointWithAltitude = new GA__PointWithAltitude(*other_value.field_pointWithAltitude);
break;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid(*other_value.field_pointWithAltitudeAndUncertaintyEllipsoid);
break;
case ALT_ellipsoidArc:
field_ellipsoidArc = new GA__EllipsoidArc(*other_value.field_ellipsoidArc);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RANAP-IEs.GeographicalArea.");
}
union_selection = other_value.union_selection;
}

GeographicalArea::GeographicalArea()
{
union_selection = UNBOUND_VALUE;
}

GeographicalArea::GeographicalArea(const GeographicalArea& other_value)
: Base_Type(){
copy_value(other_value);
}

GeographicalArea::~GeographicalArea()
{
clean_up();
}

GeographicalArea& GeographicalArea::operator=(const GeographicalArea& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean GeographicalArea::operator==(const GeographicalArea& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RANAP-IEs.GeographicalArea.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RANAP-IEs.GeographicalArea.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_point:
return *field_point == *other_value.field_point;
case ALT_pointWithUnCertainty:
return *field_pointWithUnCertainty == *other_value.field_pointWithUnCertainty;
case ALT_polygon:
return *field_polygon == *other_value.field_polygon;
case ALT_pointWithUncertaintyEllipse:
return *field_pointWithUncertaintyEllipse == *other_value.field_pointWithUncertaintyEllipse;
case ALT_pointWithAltitude:
return *field_pointWithAltitude == *other_value.field_pointWithAltitude;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
return *field_pointWithAltitudeAndUncertaintyEllipsoid == *other_value.field_pointWithAltitudeAndUncertaintyEllipsoid;
case ALT_ellipsoidArc:
return *field_ellipsoidArc == *other_value.field_ellipsoidArc;
default:
return FALSE;
}
}

GA__Point& GeographicalArea::point()
{
if (union_selection != ALT_point) {
clean_up();
field_point = new GA__Point;
union_selection = ALT_point;
}
return *field_point;
}

const GA__Point& GeographicalArea::point() const
{
if (union_selection != ALT_point) TTCN_error("Using non-selected field point in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_point;
}

GA__PointWithUnCertainty& GeographicalArea::pointWithUnCertainty()
{
if (union_selection != ALT_pointWithUnCertainty) {
clean_up();
field_pointWithUnCertainty = new GA__PointWithUnCertainty;
union_selection = ALT_pointWithUnCertainty;
}
return *field_pointWithUnCertainty;
}

const GA__PointWithUnCertainty& GeographicalArea::pointWithUnCertainty() const
{
if (union_selection != ALT_pointWithUnCertainty) TTCN_error("Using non-selected field pointWithUnCertainty in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_pointWithUnCertainty;
}

GA__Polygon& GeographicalArea::polygon()
{
if (union_selection != ALT_polygon) {
clean_up();
field_polygon = new GA__Polygon;
union_selection = ALT_polygon;
}
return *field_polygon;
}

const GA__Polygon& GeographicalArea::polygon() const
{
if (union_selection != ALT_polygon) TTCN_error("Using non-selected field polygon in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_polygon;
}

GA__PointWithUnCertaintyEllipse& GeographicalArea::pointWithUncertaintyEllipse()
{
if (union_selection != ALT_pointWithUncertaintyEllipse) {
clean_up();
field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse;
union_selection = ALT_pointWithUncertaintyEllipse;
}
return *field_pointWithUncertaintyEllipse;
}

const GA__PointWithUnCertaintyEllipse& GeographicalArea::pointWithUncertaintyEllipse() const
{
if (union_selection != ALT_pointWithUncertaintyEllipse) TTCN_error("Using non-selected field pointWithUncertaintyEllipse in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_pointWithUncertaintyEllipse;
}

GA__PointWithAltitude& GeographicalArea::pointWithAltitude()
{
if (union_selection != ALT_pointWithAltitude) {
clean_up();
field_pointWithAltitude = new GA__PointWithAltitude;
union_selection = ALT_pointWithAltitude;
}
return *field_pointWithAltitude;
}

const GA__PointWithAltitude& GeographicalArea::pointWithAltitude() const
{
if (union_selection != ALT_pointWithAltitude) TTCN_error("Using non-selected field pointWithAltitude in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_pointWithAltitude;
}

GA__PointWithAltitudeAndUncertaintyEllipsoid& GeographicalArea::pointWithAltitudeAndUncertaintyEllipsoid()
{
if (union_selection != ALT_pointWithAltitudeAndUncertaintyEllipsoid) {
clean_up();
field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid;
union_selection = ALT_pointWithAltitudeAndUncertaintyEllipsoid;
}
return *field_pointWithAltitudeAndUncertaintyEllipsoid;
}

const GA__PointWithAltitudeAndUncertaintyEllipsoid& GeographicalArea::pointWithAltitudeAndUncertaintyEllipsoid() const
{
if (union_selection != ALT_pointWithAltitudeAndUncertaintyEllipsoid) TTCN_error("Using non-selected field pointWithAltitudeAndUncertaintyEllipsoid in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_pointWithAltitudeAndUncertaintyEllipsoid;
}

GA__EllipsoidArc& GeographicalArea::ellipsoidArc()
{
if (union_selection != ALT_ellipsoidArc) {
clean_up();
field_ellipsoidArc = new GA__EllipsoidArc;
union_selection = ALT_ellipsoidArc;
}
return *field_ellipsoidArc;
}

const GA__EllipsoidArc& GeographicalArea::ellipsoidArc() const
{
if (union_selection != ALT_ellipsoidArc) TTCN_error("Using non-selected field ellipsoidArc in a value of union type @RANAP-IEs.GeographicalArea.");
return *field_ellipsoidArc;
}

boolean GeographicalArea::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-IEs.GeographicalArea.");
return union_selection == checked_selection;
}

boolean GeographicalArea::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean GeographicalArea::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_point: return field_point->is_value();
case ALT_pointWithUnCertainty: return field_pointWithUnCertainty->is_value();
case ALT_polygon: return field_polygon->is_value();
case ALT_pointWithUncertaintyEllipse: return field_pointWithUncertaintyEllipse->is_value();
case ALT_pointWithAltitude: return field_pointWithAltitude->is_value();
case ALT_pointWithAltitudeAndUncertaintyEllipsoid: return field_pointWithAltitudeAndUncertaintyEllipsoid->is_value();
case ALT_ellipsoidArc: return field_ellipsoidArc->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void GeographicalArea::clean_up()
{
switch (union_selection) {
case ALT_point:
  delete field_point;
  break;
case ALT_pointWithUnCertainty:
  delete field_pointWithUnCertainty;
  break;
case ALT_polygon:
  delete field_polygon;
  break;
case ALT_pointWithUncertaintyEllipse:
  delete field_pointWithUncertaintyEllipse;
  break;
case ALT_pointWithAltitude:
  delete field_pointWithAltitude;
  break;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
  delete field_pointWithAltitudeAndUncertaintyEllipsoid;
  break;
case ALT_ellipsoidArc:
  delete field_ellipsoidArc;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void GeographicalArea::log() const
{
switch (union_selection) {
case ALT_point:
TTCN_Logger::log_event_str("{ point := ");
field_point->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_pointWithUnCertainty:
TTCN_Logger::log_event_str("{ pointWithUnCertainty := ");
field_pointWithUnCertainty->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_polygon:
TTCN_Logger::log_event_str("{ polygon := ");
field_polygon->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_pointWithUncertaintyEllipse:
TTCN_Logger::log_event_str("{ pointWithUncertaintyEllipse := ");
field_pointWithUncertaintyEllipse->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_pointWithAltitude:
TTCN_Logger::log_event_str("{ pointWithAltitude := ");
field_pointWithAltitude->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
TTCN_Logger::log_event_str("{ pointWithAltitudeAndUncertaintyEllipsoid := ");
field_pointWithAltitudeAndUncertaintyEllipsoid->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ellipsoidArc:
TTCN_Logger::log_event_str("{ ellipsoidArc := ");
field_ellipsoidArc->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void GeographicalArea::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "point")) {
    point().set_param(*mp_last);
    if (!point().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "pointWithUnCertainty")) {
    pointWithUnCertainty().set_param(*mp_last);
    if (!pointWithUnCertainty().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "polygon")) {
    polygon().set_param(*mp_last);
    if (!polygon().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "pointWithUncertaintyEllipse")) {
    pointWithUncertaintyEllipse().set_param(*mp_last);
    if (!pointWithUncertaintyEllipse().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "pointWithAltitude")) {
    pointWithAltitude().set_param(*mp_last);
    if (!pointWithAltitude().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "pointWithAltitudeAndUncertaintyEllipsoid")) {
    pointWithAltitudeAndUncertaintyEllipsoid().set_param(*mp_last);
    if (!pointWithAltitudeAndUncertaintyEllipsoid().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ellipsoidArc")) {
    ellipsoidArc().set_param(*mp_last);
    if (!ellipsoidArc().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RANAP-IEs.GeographicalArea.", last_name);
}

void GeographicalArea::set_implicit_omit()
{
switch (union_selection) {
case ALT_point:
field_point->set_implicit_omit(); break;
case ALT_pointWithUnCertainty:
field_pointWithUnCertainty->set_implicit_omit(); break;
case ALT_polygon:
field_polygon->set_implicit_omit(); break;
case ALT_pointWithUncertaintyEllipse:
field_pointWithUncertaintyEllipse->set_implicit_omit(); break;
case ALT_pointWithAltitude:
field_pointWithAltitude->set_implicit_omit(); break;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
field_pointWithAltitudeAndUncertaintyEllipsoid->set_implicit_omit(); break;
case ALT_ellipsoidArc:
field_ellipsoidArc->set_implicit_omit(); break;
default: break;
}
}

void GeographicalArea::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_point:
field_point->encode_text(text_buf);
break;
case ALT_pointWithUnCertainty:
field_pointWithUnCertainty->encode_text(text_buf);
break;
case ALT_polygon:
field_polygon->encode_text(text_buf);
break;
case ALT_pointWithUncertaintyEllipse:
field_pointWithUncertaintyEllipse->encode_text(text_buf);
break;
case ALT_pointWithAltitude:
field_pointWithAltitude->encode_text(text_buf);
break;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
field_pointWithAltitudeAndUncertaintyEllipsoid->encode_text(text_buf);
break;
case ALT_ellipsoidArc:
field_ellipsoidArc->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RANAP-IEs.GeographicalArea.");
}
}

void GeographicalArea::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_point:
point().decode_text(text_buf);
break;
case ALT_pointWithUnCertainty:
pointWithUnCertainty().decode_text(text_buf);
break;
case ALT_polygon:
polygon().decode_text(text_buf);
break;
case ALT_pointWithUncertaintyEllipse:
pointWithUncertaintyEllipse().decode_text(text_buf);
break;
case ALT_pointWithAltitude:
pointWithAltitude().decode_text(text_buf);
break;
case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
pointWithAltitudeAndUncertaintyEllipsoid().decode_text(text_buf);
break;
case ALT_ellipsoidArc:
ellipsoidArc().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RANAP-IEs.GeographicalArea.");
}
}

void GeographicalArea::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GeographicalArea::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *GeographicalArea::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_point:
    ec_1.set_msg("point': ");
    new_tlv = field_point->BER_encode_TLV(GeographicalArea_point_descr_, p_coding);
    break;
  case ALT_pointWithUnCertainty:
    ec_1.set_msg("pointWithUnCertainty': ");
    new_tlv = field_pointWithUnCertainty->BER_encode_TLV(GeographicalArea_pointWithUnCertainty_descr_, p_coding);
    break;
  case ALT_polygon:
    ec_1.set_msg("polygon': ");
    new_tlv = field_polygon->BER_encode_TLV(GeographicalArea_polygon_descr_, p_coding);
    break;
  case ALT_pointWithUncertaintyEllipse:
    ec_1.set_msg("pointWithUncertaintyEllipse': ");
    new_tlv = field_pointWithUncertaintyEllipse->BER_encode_TLV(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_coding);
    break;
  case ALT_pointWithAltitude:
    ec_1.set_msg("pointWithAltitude': ");
    new_tlv = field_pointWithAltitude->BER_encode_TLV(GeographicalArea_pointWithAltitude_descr_, p_coding);
    break;
  case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
    ec_1.set_msg("pointWithAltitudeAndUncertaintyEllipsoid': ");
    new_tlv = field_pointWithAltitudeAndUncertaintyEllipsoid->BER_encode_TLV(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_coding);
    break;
  case ALT_ellipsoidArc:
    ec_1.set_msg("ellipsoidArc': ");
    new_tlv = field_ellipsoidArc->BER_encode_TLV(GeographicalArea_ellipsoidArc_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean GeographicalArea::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_point = new GA__Point;
  union_selection = ALT_point;
  if (field_point->BER_decode_isMyMsg(GeographicalArea_point_descr_, p_tlv)) return TRUE;
  delete field_point;
  field_pointWithUnCertainty = new GA__PointWithUnCertainty;
  union_selection = ALT_pointWithUnCertainty;
  if (field_pointWithUnCertainty->BER_decode_isMyMsg(GeographicalArea_pointWithUnCertainty_descr_, p_tlv)) return TRUE;
  delete field_pointWithUnCertainty;
  field_polygon = new GA__Polygon;
  union_selection = ALT_polygon;
  if (field_polygon->BER_decode_isMyMsg(GeographicalArea_polygon_descr_, p_tlv)) return TRUE;
  delete field_polygon;
  field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse;
  union_selection = ALT_pointWithUncertaintyEllipse;
  if (field_pointWithUncertaintyEllipse->BER_decode_isMyMsg(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_tlv)) return TRUE;
  delete field_pointWithUncertaintyEllipse;
  field_pointWithAltitude = new GA__PointWithAltitude;
  union_selection = ALT_pointWithAltitude;
  if (field_pointWithAltitude->BER_decode_isMyMsg(GeographicalArea_pointWithAltitude_descr_, p_tlv)) return TRUE;
  delete field_pointWithAltitude;
  field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid;
  union_selection = ALT_pointWithAltitudeAndUncertaintyEllipsoid;
  if (field_pointWithAltitudeAndUncertaintyEllipsoid->BER_decode_isMyMsg(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_tlv)) return TRUE;
  delete field_pointWithAltitudeAndUncertaintyEllipsoid;
  field_ellipsoidArc = new GA__EllipsoidArc;
  union_selection = ALT_ellipsoidArc;
  if (field_ellipsoidArc->BER_decode_isMyMsg(GeographicalArea_ellipsoidArc_descr_, p_tlv)) return TRUE;
  delete field_ellipsoidArc;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean GeographicalArea::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    GeographicalArea tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean GeographicalArea::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-IEs.GeographicalArea' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_point:
    ec_2.set_msg("point': ");
    field_point->BER_decode_TLV(GeographicalArea_point_descr_, tmp_tlv, L_form);
    break;
  case ALT_pointWithUnCertainty:
    ec_2.set_msg("pointWithUnCertainty': ");
    field_pointWithUnCertainty->BER_decode_TLV(GeographicalArea_pointWithUnCertainty_descr_, tmp_tlv, L_form);
    break;
  case ALT_polygon:
    ec_2.set_msg("polygon': ");
    field_polygon->BER_decode_TLV(GeographicalArea_polygon_descr_, tmp_tlv, L_form);
    break;
  case ALT_pointWithUncertaintyEllipse:
    ec_2.set_msg("pointWithUncertaintyEllipse': ");
    field_pointWithUncertaintyEllipse->BER_decode_TLV(GeographicalArea_pointWithUncertaintyEllipse_descr_, tmp_tlv, L_form);
    break;
  case ALT_pointWithAltitude:
    ec_2.set_msg("pointWithAltitude': ");
    field_pointWithAltitude->BER_decode_TLV(GeographicalArea_pointWithAltitude_descr_, tmp_tlv, L_form);
    break;
  case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
    ec_2.set_msg("pointWithAltitudeAndUncertaintyEllipsoid': ");
    field_pointWithAltitudeAndUncertaintyEllipsoid->BER_decode_TLV(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, tmp_tlv, L_form);
    break;
  case ALT_ellipsoidArc:
    ec_2.set_msg("ellipsoidArc': ");
    field_ellipsoidArc->BER_decode_TLV(GeographicalArea_ellipsoidArc_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int GeographicalArea::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  boolean as_value = p_td.json->as_value;
  int enc_len = as_value ? 0 : p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
  switch(union_selection) {
  case ALT_point:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "point");
    }
    enc_len += field_point->JSON_encode(GeographicalArea_point_descr_, p_tok, FALSE);
    break;
  case ALT_pointWithUnCertainty:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pointWithUnCertainty");
    }
    enc_len += field_pointWithUnCertainty->JSON_encode(GeographicalArea_pointWithUnCertainty_descr_, p_tok, FALSE);
    break;
  case ALT_polygon:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "polygon");
    }
    enc_len += field_polygon->JSON_encode(GeographicalArea_polygon_descr_, p_tok, FALSE);
    break;
  case ALT_pointWithUncertaintyEllipse:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pointWithUncertaintyEllipse");
    }
    enc_len += field_pointWithUncertaintyEllipse->JSON_encode(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_tok, FALSE);
    break;
  case ALT_pointWithAltitude:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pointWithAltitude");
    }
    enc_len += field_pointWithAltitude->JSON_encode(GeographicalArea_pointWithAltitude_descr_, p_tok, FALSE);
    break;
  case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pointWithAltitudeAndUncertaintyEllipsoid");
    }
    enc_len += field_pointWithAltitudeAndUncertaintyEllipsoid->JSON_encode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_tok, FALSE);
    break;
  case ALT_ellipsoidArc:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ellipsoidArc");
    }
    enc_len += field_ellipsoidArc->JSON_encode(GeographicalArea_ellipsoidArc_descr_, p_tok, FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @RANAP-IEs.GeographicalArea.");
    return -1;
  }

  if (!as_value) {
    enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  }
  return enc_len;
}

int GeographicalArea::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  if (0 <= p_chosen_field && 7 > p_chosen_field) {
    switch (p_chosen_field) {
    case 0:
      return point().JSON_decode(GeographicalArea_point_descr_, p_tok, TRUE, FALSE);
    case 1:
      return pointWithUnCertainty().JSON_decode(GeographicalArea_pointWithUnCertainty_descr_, p_tok, TRUE, FALSE);
    case 2:
      return polygon().JSON_decode(GeographicalArea_polygon_descr_, p_tok, TRUE, FALSE);
    case 3:
      return pointWithUncertaintyEllipse().JSON_decode(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_tok, TRUE, FALSE);
    case 4:
      return pointWithAltitude().JSON_decode(GeographicalArea_pointWithAltitude_descr_, p_tok, TRUE, FALSE);
    case 5:
      return pointWithAltitudeAndUncertaintyEllipsoid().JSON_decode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_tok, TRUE, FALSE);
    case 6:
      return ellipsoidArc().JSON_decode(GeographicalArea_ellipsoidArc_descr_, p_tok, TRUE, FALSE);
    }
  }
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const GeographicalArea*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
 if (p_td.json->as_value) {
  size_t buf_pos = p_tok.get_buf_pos();
  p_tok.get_next_token(&j_token, NULL, NULL);
  int ret_val = 0;
  switch(j_token) {
  case JSON_TOKEN_NUMBER: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "number '@RANAP-IEs.GeographicalArea'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_STRING: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "string '@RANAP-IEs.GeographicalArea'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_TRUE:
  case JSON_TOKEN_LITERAL_FALSE: {
    char* literal_str = mprintf("literal (%s)",
      (JSON_TOKEN_LITERAL_TRUE == j_token) ? "true" : "false");
    try {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, literal_str);
    }
    catch (const TC_Error&) {
      Free(literal_str);
      throw;
    }
    Free(literal_str);
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_ARRAY_START: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = polygon().JSON_decode(GeographicalArea_polygon_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "array '@RANAP-IEs.GeographicalArea'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_OBJECT_START: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = point().JSON_decode(GeographicalArea_point_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = pointWithUnCertainty().JSON_decode(GeographicalArea_pointWithUnCertainty_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = polygon().JSON_decode(GeographicalArea_polygon_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = pointWithUncertaintyEllipse().JSON_decode(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = pointWithAltitude().JSON_decode(GeographicalArea_pointWithAltitude_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = pointWithAltitudeAndUncertaintyEllipsoid().JSON_decode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = ellipsoidArc().JSON_decode(GeographicalArea_ellipsoidArc_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "object '@RANAP-IEs.GeographicalArea'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_NULL: {
    clean_up();
    return JSON_ERROR_INVALID_TOKEN;
  }
  case JSON_TOKEN_ERROR:
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  default:
    return JSON_ERROR_INVALID_TOKEN;
  }
  return ret_val;
 }
 else {
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  char* fld_name = 0;
  size_t name_len = 0;
  dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
  if (JSON_TOKEN_NAME != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
    return JSON_ERROR_FATAL;
  } else {
if (5 == name_len && 0 == strncmp(fld_name, "point", name_len)) {
      int ret_val = point().JSON_decode(GeographicalArea_point_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 5, "point");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (20 == name_len && 0 == strncmp(fld_name, "pointWithUnCertainty", name_len)) {
      int ret_val = pointWithUnCertainty().JSON_decode(GeographicalArea_pointWithUnCertainty_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 20, "pointWithUnCertainty");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (7 == name_len && 0 == strncmp(fld_name, "polygon", name_len)) {
      int ret_val = polygon().JSON_decode(GeographicalArea_polygon_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 7, "polygon");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (27 == name_len && 0 == strncmp(fld_name, "pointWithUncertaintyEllipse", name_len)) {
      int ret_val = pointWithUncertaintyEllipse().JSON_decode(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "pointWithUncertaintyEllipse");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (17 == name_len && 0 == strncmp(fld_name, "pointWithAltitude", name_len)) {
      int ret_val = pointWithAltitude().JSON_decode(GeographicalArea_pointWithAltitude_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "pointWithAltitude");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (40 == name_len && 0 == strncmp(fld_name, "pointWithAltitudeAndUncertaintyEllipsoid", name_len)) {
      int ret_val = pointWithAltitudeAndUncertaintyEllipsoid().JSON_decode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 40, "pointWithAltitudeAndUncertaintyEllipsoid");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (12 == name_len && 0 == strncmp(fld_name, "ellipsoidArc", name_len)) {
      int ret_val = ellipsoidArc().JSON_decode(GeographicalArea_ellipsoidArc_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "ellipsoidArc");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
      return JSON_ERROR_FATAL;
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
 }
}

int GeographicalArea::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_point:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_point_descr_.ber, p_buf);
    field_point->OER_encode(GeographicalArea_point_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_pointWithUnCertainty:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_pointWithUnCertainty_descr_.ber, p_buf);
    field_pointWithUnCertainty->OER_encode(GeographicalArea_pointWithUnCertainty_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_polygon:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_polygon_descr_.ber, p_buf);
    field_polygon->OER_encode(GeographicalArea_polygon_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_pointWithUncertaintyEllipse:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_pointWithUncertaintyEllipse_descr_.ber, p_buf);
    field_pointWithUncertaintyEllipse->OER_encode(GeographicalArea_pointWithUncertaintyEllipse_descr_, buf);
    encode_oer_length(buf.get_len(), p_buf, FALSE);
    p_buf.put_buf(buf);
    break;
}  case ALT_pointWithAltitude:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_pointWithAltitude_descr_.ber, p_buf);
    field_pointWithAltitude->OER_encode(GeographicalArea_pointWithAltitude_descr_, buf);
    encode_oer_length(buf.get_len(), p_buf, FALSE);
    p_buf.put_buf(buf);
    break;
}  case ALT_pointWithAltitudeAndUncertaintyEllipsoid:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_.ber, p_buf);
    field_pointWithAltitudeAndUncertaintyEllipsoid->OER_encode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, buf);
    encode_oer_length(buf.get_len(), p_buf, FALSE);
    p_buf.put_buf(buf);
    break;
}  case ALT_ellipsoidArc:
    {TTCN_Buffer buf;
    encode_oer_tag(*GeographicalArea_ellipsoidArc_descr_.ber, p_buf);
    field_ellipsoidArc->OER_encode(GeographicalArea_ellipsoidArc_descr_, buf);
    encode_oer_length(buf.get_len(), p_buf, FALSE);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @RANAP-IEs.GeographicalArea.");
    return -1;
  }

  return 0;
}
int GeographicalArea::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (GeographicalArea_point_descr_.ber->tags[GeographicalArea_point_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_point_descr_.ber->tags[GeographicalArea_point_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    point().OER_decode(GeographicalArea_point_descr_, p_buf, p_oer);
  } else 
  if (GeographicalArea_pointWithUnCertainty_descr_.ber->tags[GeographicalArea_pointWithUnCertainty_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_pointWithUnCertainty_descr_.ber->tags[GeographicalArea_pointWithUnCertainty_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    pointWithUnCertainty().OER_decode(GeographicalArea_pointWithUnCertainty_descr_, p_buf, p_oer);
  } else 
  if (GeographicalArea_polygon_descr_.ber->tags[GeographicalArea_polygon_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_polygon_descr_.ber->tags[GeographicalArea_polygon_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    polygon().OER_decode(GeographicalArea_polygon_descr_, p_buf, p_oer);
  } else 
  if (GeographicalArea_pointWithUncertaintyEllipse_descr_.ber->tags[GeographicalArea_pointWithUncertaintyEllipse_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_pointWithUncertaintyEllipse_descr_.ber->tags[GeographicalArea_pointWithUncertaintyEllipse_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
      decode_oer_length(p_buf, FALSE);
    pointWithUncertaintyEllipse().OER_decode(GeographicalArea_pointWithUncertaintyEllipse_descr_, p_buf, p_oer);
  } else 
  if (GeographicalArea_pointWithAltitude_descr_.ber->tags[GeographicalArea_pointWithAltitude_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_pointWithAltitude_descr_.ber->tags[GeographicalArea_pointWithAltitude_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
      decode_oer_length(p_buf, FALSE);
    pointWithAltitude().OER_decode(GeographicalArea_pointWithAltitude_descr_, p_buf, p_oer);
  } else 
  if (GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_.ber->tags[GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_.ber->tags[GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
      decode_oer_length(p_buf, FALSE);
    pointWithAltitudeAndUncertaintyEllipsoid().OER_decode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, p_buf, p_oer);
  } else 
  if (GeographicalArea_ellipsoidArc_descr_.ber->tags[GeographicalArea_ellipsoidArc_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      GeographicalArea_ellipsoidArc_descr_.ber->tags[GeographicalArea_ellipsoidArc_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
      decode_oer_length(p_buf, FALSE);
    ellipsoidArc().OER_decode(GeographicalArea_ellipsoidArc_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type GeographicalArea");
}
  return 0;
}
void GeographicalArea::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
boolean ext_bit = union_selection > 3;
p_buf.PER_put_bit(ext_bit);
if (ext_bit) {
INTEGER sel_code;
TTCN_Buffer ext_add_buf;
switch (union_selection) {
case ALT_pointWithUncertaintyEllipse: {
sel_code = 0;
field_pointWithUncertaintyEllipse->PER_encode(GeographicalArea_pointWithUncertaintyEllipse_descr_, ext_add_buf, p_options);
break; }
case ALT_pointWithAltitude: {
sel_code = 1;
field_pointWithAltitude->PER_encode(GeographicalArea_pointWithAltitude_descr_, ext_add_buf, p_options);
break; }
case ALT_pointWithAltitudeAndUncertaintyEllipsoid: {
sel_code = 2;
field_pointWithAltitudeAndUncertaintyEllipsoid->PER_encode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, ext_add_buf, p_options);
break; }
case ALT_ellipsoidArc: {
sel_code = 3;
field_ellipsoidArc->PER_encode(GeographicalArea_ellipsoidArc_descr_, ext_add_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension addition field.");
return;
}
sel_code.PER_encode_normally_small(p_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
else switch (union_selection) {
case ALT_point: {
INTEGER::PER_encode_int(p_buf, 0, 2);
field_point->PER_encode(GeographicalArea_point_descr_, p_buf, p_options);
break; }
case ALT_pointWithUnCertainty: {
INTEGER::PER_encode_int(p_buf, 1, 2);
field_pointWithUnCertainty->PER_encode(GeographicalArea_pointWithUnCertainty_descr_, p_buf, p_options);
break; }
case ALT_polygon: {
INTEGER::PER_encode_int(p_buf, 2, 2);
field_polygon->PER_encode(GeographicalArea_polygon_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void GeographicalArea::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
if (ext_bit) {
INTEGER sel_code;
sel_code.PER_decode_normally_small(p_buf, p_options);
int sel_int = sel_code;
switch (sel_int) {
case 0: {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
pointWithUncertaintyEllipse().PER_decode(GeographicalArea_pointWithUncertaintyEllipse_descr_, ext_add_buf, p_options);
break; }
case 1: {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
pointWithAltitude().PER_decode(GeographicalArea_pointWithAltitude_descr_, ext_add_buf, p_options);
break; }
case 2: {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
pointWithAltitudeAndUncertaintyEllipsoid().PER_decode(GeographicalArea_pointWithAltitudeAndUncertaintyEllipsoid_descr_, ext_add_buf, p_options);
break; }
case 3: {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
ellipsoidArc().PER_decode(GeographicalArea_ellipsoidArc_descr_, ext_add_buf, p_options);
break; }
default:
PER_skip_opentype(p_buf, p_options);
break;
}
} else {
int sel_int;
INTEGER::PER_decode_int(p_buf, 2, FALSE, sel_int);
switch (sel_int) {
case 0:
point().PER_decode(GeographicalArea_point_descr_, p_buf, p_options);
break;
case 1:
pointWithUnCertainty().PER_decode(GeographicalArea_pointWithUnCertainty_descr_, p_buf, p_options);
break;
case 2:
polygon().PER_decode(GeographicalArea_polygon_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}
}

void GeographicalArea_template::copy_value(const GeographicalArea& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
single_value.field_point = new GA__Point_template(other_value.point());
break;
case GeographicalArea::ALT_pointWithUnCertainty:
single_value.field_pointWithUnCertainty = new GA__PointWithUnCertainty_template(other_value.pointWithUnCertainty());
break;
case GeographicalArea::ALT_polygon:
single_value.field_polygon = new GA__Polygon_template(other_value.polygon());
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
single_value.field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse_template(other_value.pointWithUncertaintyEllipse());
break;
case GeographicalArea::ALT_pointWithAltitude:
single_value.field_pointWithAltitude = new GA__PointWithAltitude_template(other_value.pointWithAltitude());
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid_template(other_value.pointWithAltitudeAndUncertaintyEllipsoid());
break;
case GeographicalArea::ALT_ellipsoidArc:
single_value.field_ellipsoidArc = new GA__EllipsoidArc_template(other_value.ellipsoidArc());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RANAP-IEs.GeographicalArea.");
}
set_selection(SPECIFIC_VALUE);
}

void GeographicalArea_template::copy_template(const GeographicalArea_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
single_value.field_point = new GA__Point_template(*other_value.single_value.field_point);
break;
case GeographicalArea::ALT_pointWithUnCertainty:
single_value.field_pointWithUnCertainty = new GA__PointWithUnCertainty_template(*other_value.single_value.field_pointWithUnCertainty);
break;
case GeographicalArea::ALT_polygon:
single_value.field_polygon = new GA__Polygon_template(*other_value.single_value.field_polygon);
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
single_value.field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse_template(*other_value.single_value.field_pointWithUncertaintyEllipse);
break;
case GeographicalArea::ALT_pointWithAltitude:
single_value.field_pointWithAltitude = new GA__PointWithAltitude_template(*other_value.single_value.field_pointWithAltitude);
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid_template(*other_value.single_value.field_pointWithAltitudeAndUncertaintyEllipsoid);
break;
case GeographicalArea::ALT_ellipsoidArc:
single_value.field_ellipsoidArc = new GA__EllipsoidArc_template(*other_value.single_value.field_ellipsoidArc);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RANAP-IEs.GeographicalArea.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GeographicalArea_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GeographicalArea_template(*other_value.implication_.precondition);
implication_.implied_template = new GeographicalArea_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RANAP-IEs.GeographicalArea.");
}
set_selection(other_value);
}

GeographicalArea_template::GeographicalArea_template()
{
}

GeographicalArea_template::GeographicalArea_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GeographicalArea_template::GeographicalArea_template(const GeographicalArea& other_value)
{
copy_value(other_value);
}

GeographicalArea_template::GeographicalArea_template(const OPTIONAL<GeographicalArea>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GeographicalArea&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RANAP-IEs.GeographicalArea from an unbound optional field.");
}
}

GeographicalArea_template::GeographicalArea_template(GeographicalArea_template* p_precondition, GeographicalArea_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GeographicalArea_template::GeographicalArea_template(Dynamic_Match_Interface<GeographicalArea>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GeographicalArea>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GeographicalArea_template::GeographicalArea_template(const GeographicalArea_template& other_value)
: Base_Template(){
copy_template(other_value);
}

GeographicalArea_template::~GeographicalArea_template()
{
clean_up();
}

void GeographicalArea_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
delete single_value.field_point;
break;
case GeographicalArea::ALT_pointWithUnCertainty:
delete single_value.field_pointWithUnCertainty;
break;
case GeographicalArea::ALT_polygon:
delete single_value.field_polygon;
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
delete single_value.field_pointWithUncertaintyEllipse;
break;
case GeographicalArea::ALT_pointWithAltitude:
delete single_value.field_pointWithAltitude;
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
delete single_value.field_pointWithAltitudeAndUncertaintyEllipsoid;
break;
case GeographicalArea::ALT_ellipsoidArc:
delete single_value.field_ellipsoidArc;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GeographicalArea_template& GeographicalArea_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GeographicalArea_template& GeographicalArea_template::operator=(const GeographicalArea& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GeographicalArea_template& GeographicalArea_template::operator=(const OPTIONAL<GeographicalArea>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GeographicalArea&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RANAP-IEs.GeographicalArea.");
}
return *this;
}

GeographicalArea_template& GeographicalArea_template::operator=(const GeographicalArea_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GeographicalArea_template::match(const GeographicalArea& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
GeographicalArea::union_selection_type value_selection = other_value.get_selection();
if (value_selection == GeographicalArea::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case GeographicalArea::ALT_point:
return single_value.field_point->match(other_value.point(), legacy);
case GeographicalArea::ALT_pointWithUnCertainty:
return single_value.field_pointWithUnCertainty->match(other_value.pointWithUnCertainty(), legacy);
case GeographicalArea::ALT_polygon:
return single_value.field_polygon->match(other_value.polygon(), legacy);
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
return single_value.field_pointWithUncertaintyEllipse->match(other_value.pointWithUncertaintyEllipse(), legacy);
case GeographicalArea::ALT_pointWithAltitude:
return single_value.field_pointWithAltitude->match(other_value.pointWithAltitude(), legacy);
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
return single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->match(other_value.pointWithAltitudeAndUncertaintyEllipsoid(), legacy);
case GeographicalArea::ALT_ellipsoidArc:
return single_value.field_ellipsoidArc->match(other_value.ellipsoidArc(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RANAP-IEs.GeographicalArea.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RANAP-IEs.GeographicalArea.");
}
return FALSE;
}

boolean GeographicalArea_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
return single_value.field_point->is_value();
case GeographicalArea::ALT_pointWithUnCertainty:
return single_value.field_pointWithUnCertainty->is_value();
case GeographicalArea::ALT_polygon:
return single_value.field_polygon->is_value();
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
return single_value.field_pointWithUncertaintyEllipse->is_value();
case GeographicalArea::ALT_pointWithAltitude:
return single_value.field_pointWithAltitude->is_value();
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
return single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->is_value();
case GeographicalArea::ALT_ellipsoidArc:
return single_value.field_ellipsoidArc->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RANAP-IEs.GeographicalArea.");
}
}

GeographicalArea GeographicalArea_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RANAP-IEs.GeographicalArea.");
GeographicalArea ret_val;
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
ret_val.point() = single_value.field_point->valueof();
break;
case GeographicalArea::ALT_pointWithUnCertainty:
ret_val.pointWithUnCertainty() = single_value.field_pointWithUnCertainty->valueof();
break;
case GeographicalArea::ALT_polygon:
ret_val.polygon() = single_value.field_polygon->valueof();
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
ret_val.pointWithUncertaintyEllipse() = single_value.field_pointWithUncertaintyEllipse->valueof();
break;
case GeographicalArea::ALT_pointWithAltitude:
ret_val.pointWithAltitude() = single_value.field_pointWithAltitude->valueof();
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
ret_val.pointWithAltitudeAndUncertaintyEllipsoid() = single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->valueof();
break;
case GeographicalArea::ALT_ellipsoidArc:
ret_val.ellipsoidArc() = single_value.field_ellipsoidArc->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RANAP-IEs.GeographicalArea.");
}
return ret_val;
}

GeographicalArea_template& GeographicalArea_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RANAP-IEs.GeographicalArea.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RANAP-IEs.GeographicalArea.");
return value_list.list_value[list_index];
}
void GeographicalArea_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RANAP-IEs.GeographicalArea.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GeographicalArea_template[list_length];
}

GA__Point_template& GeographicalArea_template::point()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_point) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_point = new GA__Point_template(ANY_VALUE);
else single_value.field_point = new GA__Point_template;
single_value.union_selection = GeographicalArea::ALT_point;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_point;
}

const GA__Point_template& GeographicalArea_template::point() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field point in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_point) TTCN_error("Accessing non-selected field point in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_point;
}

GA__PointWithUnCertainty_template& GeographicalArea_template::pointWithUnCertainty()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_pointWithUnCertainty) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pointWithUnCertainty = new GA__PointWithUnCertainty_template(ANY_VALUE);
else single_value.field_pointWithUnCertainty = new GA__PointWithUnCertainty_template;
single_value.union_selection = GeographicalArea::ALT_pointWithUnCertainty;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pointWithUnCertainty;
}

const GA__PointWithUnCertainty_template& GeographicalArea_template::pointWithUnCertainty() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pointWithUnCertainty in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_pointWithUnCertainty) TTCN_error("Accessing non-selected field pointWithUnCertainty in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_pointWithUnCertainty;
}

GA__Polygon_template& GeographicalArea_template::polygon()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_polygon) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_polygon = new GA__Polygon_template(ANY_VALUE);
else single_value.field_polygon = new GA__Polygon_template;
single_value.union_selection = GeographicalArea::ALT_polygon;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_polygon;
}

const GA__Polygon_template& GeographicalArea_template::polygon() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field polygon in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_polygon) TTCN_error("Accessing non-selected field polygon in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_polygon;
}

GA__PointWithUnCertaintyEllipse_template& GeographicalArea_template::pointWithUncertaintyEllipse()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_pointWithUncertaintyEllipse) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse_template(ANY_VALUE);
else single_value.field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse_template;
single_value.union_selection = GeographicalArea::ALT_pointWithUncertaintyEllipse;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pointWithUncertaintyEllipse;
}

const GA__PointWithUnCertaintyEllipse_template& GeographicalArea_template::pointWithUncertaintyEllipse() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pointWithUncertaintyEllipse in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_pointWithUncertaintyEllipse) TTCN_error("Accessing non-selected field pointWithUncertaintyEllipse in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_pointWithUncertaintyEllipse;
}

GA__PointWithAltitude_template& GeographicalArea_template::pointWithAltitude()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_pointWithAltitude) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pointWithAltitude = new GA__PointWithAltitude_template(ANY_VALUE);
else single_value.field_pointWithAltitude = new GA__PointWithAltitude_template;
single_value.union_selection = GeographicalArea::ALT_pointWithAltitude;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pointWithAltitude;
}

const GA__PointWithAltitude_template& GeographicalArea_template::pointWithAltitude() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pointWithAltitude in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_pointWithAltitude) TTCN_error("Accessing non-selected field pointWithAltitude in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_pointWithAltitude;
}

GA__PointWithAltitudeAndUncertaintyEllipsoid_template& GeographicalArea_template::pointWithAltitudeAndUncertaintyEllipsoid()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid_template(ANY_VALUE);
else single_value.field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid_template;
single_value.union_selection = GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pointWithAltitudeAndUncertaintyEllipsoid;
}

const GA__PointWithAltitudeAndUncertaintyEllipsoid_template& GeographicalArea_template::pointWithAltitudeAndUncertaintyEllipsoid() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pointWithAltitudeAndUncertaintyEllipsoid in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid) TTCN_error("Accessing non-selected field pointWithAltitudeAndUncertaintyEllipsoid in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_pointWithAltitudeAndUncertaintyEllipsoid;
}

GA__EllipsoidArc_template& GeographicalArea_template::ellipsoidArc()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != GeographicalArea::ALT_ellipsoidArc) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ellipsoidArc = new GA__EllipsoidArc_template(ANY_VALUE);
else single_value.field_ellipsoidArc = new GA__EllipsoidArc_template;
single_value.union_selection = GeographicalArea::ALT_ellipsoidArc;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ellipsoidArc;
}

const GA__EllipsoidArc_template& GeographicalArea_template::ellipsoidArc() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ellipsoidArc in a non-specific template of union type @RANAP-IEs.GeographicalArea.");
if (single_value.union_selection != GeographicalArea::ALT_ellipsoidArc) TTCN_error("Accessing non-selected field ellipsoidArc in a template of union type @RANAP-IEs.GeographicalArea.");
return *single_value.field_ellipsoidArc;
}

boolean GeographicalArea_template::ischosen(GeographicalArea::union_selection_type checked_selection) const
{
if (checked_selection == GeographicalArea::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-IEs.GeographicalArea.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == GeographicalArea::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RANAP-IEs.GeographicalArea.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RANAP-IEs.GeographicalArea containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void GeographicalArea_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
TTCN_Logger::log_event_str("{ point := ");
single_value.field_point->log();
TTCN_Logger::log_event_str(" }");
break;
case GeographicalArea::ALT_pointWithUnCertainty:
TTCN_Logger::log_event_str("{ pointWithUnCertainty := ");
single_value.field_pointWithUnCertainty->log();
TTCN_Logger::log_event_str(" }");
break;
case GeographicalArea::ALT_polygon:
TTCN_Logger::log_event_str("{ polygon := ");
single_value.field_polygon->log();
TTCN_Logger::log_event_str(" }");
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
TTCN_Logger::log_event_str("{ pointWithUncertaintyEllipse := ");
single_value.field_pointWithUncertaintyEllipse->log();
TTCN_Logger::log_event_str(" }");
break;
case GeographicalArea::ALT_pointWithAltitude:
TTCN_Logger::log_event_str("{ pointWithAltitude := ");
single_value.field_pointWithAltitude->log();
TTCN_Logger::log_event_str(" }");
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
TTCN_Logger::log_event_str("{ pointWithAltitudeAndUncertaintyEllipsoid := ");
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->log();
TTCN_Logger::log_event_str(" }");
break;
case GeographicalArea::ALT_ellipsoidArc:
TTCN_Logger::log_event_str("{ ellipsoidArc := ");
single_value.field_ellipsoidArc->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GeographicalArea_template::log_match(const GeographicalArea& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".point");
single_value.field_point->log_match(match_value.point(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ point := ");
single_value.field_point->log_match(match_value.point(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case GeographicalArea::ALT_pointWithUnCertainty:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pointWithUnCertainty");
single_value.field_pointWithUnCertainty->log_match(match_value.pointWithUnCertainty(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pointWithUnCertainty := ");
single_value.field_pointWithUnCertainty->log_match(match_value.pointWithUnCertainty(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case GeographicalArea::ALT_polygon:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".polygon");
single_value.field_polygon->log_match(match_value.polygon(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ polygon := ");
single_value.field_polygon->log_match(match_value.polygon(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pointWithUncertaintyEllipse");
single_value.field_pointWithUncertaintyEllipse->log_match(match_value.pointWithUncertaintyEllipse(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pointWithUncertaintyEllipse := ");
single_value.field_pointWithUncertaintyEllipse->log_match(match_value.pointWithUncertaintyEllipse(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case GeographicalArea::ALT_pointWithAltitude:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pointWithAltitude");
single_value.field_pointWithAltitude->log_match(match_value.pointWithAltitude(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pointWithAltitude := ");
single_value.field_pointWithAltitude->log_match(match_value.pointWithAltitude(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pointWithAltitudeAndUncertaintyEllipsoid");
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->log_match(match_value.pointWithAltitudeAndUncertaintyEllipsoid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pointWithAltitudeAndUncertaintyEllipsoid := ");
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->log_match(match_value.pointWithAltitudeAndUncertaintyEllipsoid(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case GeographicalArea::ALT_ellipsoidArc:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".ellipsoidArc");
single_value.field_ellipsoidArc->log_match(match_value.ellipsoidArc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ ellipsoidArc := ");
single_value.field_ellipsoidArc->log_match(match_value.ellipsoidArc(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GeographicalArea_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
single_value.field_point->set_implicit_omit(); break;
case GeographicalArea::ALT_pointWithUnCertainty:
single_value.field_pointWithUnCertainty->set_implicit_omit(); break;
case GeographicalArea::ALT_polygon:
single_value.field_polygon->set_implicit_omit(); break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
single_value.field_pointWithUncertaintyEllipse->set_implicit_omit(); break;
case GeographicalArea::ALT_pointWithAltitude:
single_value.field_pointWithAltitude->set_implicit_omit(); break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->set_implicit_omit(); break;
case GeographicalArea::ALT_ellipsoidArc:
single_value.field_ellipsoidArc->set_implicit_omit(); break;
default: break;
}
}

void GeographicalArea_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
single_value.field_point->encode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithUnCertainty:
single_value.field_pointWithUnCertainty->encode_text(text_buf);
break;
case GeographicalArea::ALT_polygon:
single_value.field_polygon->encode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
single_value.field_pointWithUncertaintyEllipse->encode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithAltitude:
single_value.field_pointWithAltitude->encode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->encode_text(text_buf);
break;
case GeographicalArea::ALT_ellipsoidArc:
single_value.field_ellipsoidArc->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RANAP-IEs.GeographicalArea.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RANAP-IEs.GeographicalArea.");
}
}

void GeographicalArea_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = GeographicalArea::UNBOUND_VALUE;
GeographicalArea::union_selection_type new_selection = (GeographicalArea::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case GeographicalArea::ALT_point:
single_value.field_point = new GA__Point_template;
single_value.field_point->decode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithUnCertainty:
single_value.field_pointWithUnCertainty = new GA__PointWithUnCertainty_template;
single_value.field_pointWithUnCertainty->decode_text(text_buf);
break;
case GeographicalArea::ALT_polygon:
single_value.field_polygon = new GA__Polygon_template;
single_value.field_polygon->decode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
single_value.field_pointWithUncertaintyEllipse = new GA__PointWithUnCertaintyEllipse_template;
single_value.field_pointWithUncertaintyEllipse->decode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithAltitude:
single_value.field_pointWithAltitude = new GA__PointWithAltitude_template;
single_value.field_pointWithAltitude->decode_text(text_buf);
break;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid = new GA__PointWithAltitudeAndUncertaintyEllipsoid_template;
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->decode_text(text_buf);
break;
case GeographicalArea::ALT_ellipsoidArc:
single_value.field_ellipsoidArc = new GA__EllipsoidArc_template;
single_value.field_ellipsoidArc->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RANAP-IEs.GeographicalArea.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GeographicalArea_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RANAP-IEs.GeographicalArea.");
}
}

boolean GeographicalArea_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GeographicalArea_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void GeographicalArea_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RANAP-IEs.GeographicalArea'");
    }
    if (strcmp("point", param_field) == 0) {
      point().set_param(param);
      return;
    } else if (strcmp("pointWithUnCertainty", param_field) == 0) {
      pointWithUnCertainty().set_param(param);
      return;
    } else if (strcmp("polygon", param_field) == 0) {
      polygon().set_param(param);
      return;
    } else if (strcmp("pointWithUncertaintyEllipse", param_field) == 0) {
      pointWithUncertaintyEllipse().set_param(param);
      return;
    } else if (strcmp("pointWithAltitude", param_field) == 0) {
      pointWithAltitude().set_param(param);
      return;
    } else if (strcmp("pointWithAltitudeAndUncertaintyEllipsoid", param_field) == 0) {
      pointWithAltitudeAndUncertaintyEllipsoid().set_param(param);
      return;
    } else if (strcmp("ellipsoidArc", param_field) == 0) {
      ellipsoidArc().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RANAP-IEs.GeographicalArea'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GeographicalArea_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RANAP-IEs.GeographicalArea");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "point")) {
      point().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "pointWithUnCertainty")) {
      pointWithUnCertainty().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "polygon")) {
      polygon().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "pointWithUncertaintyEllipse")) {
      pointWithUncertaintyEllipse().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "pointWithAltitude")) {
      pointWithAltitude().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "pointWithAltitudeAndUncertaintyEllipsoid")) {
      pointWithAltitudeAndUncertaintyEllipsoid().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "ellipsoidArc")) {
      ellipsoidArc().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RANAP-IEs.GeographicalArea.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    GeographicalArea_template* precondition = new GeographicalArea_template;
    precondition->set_param(*m_p->get_elem(0));
    GeographicalArea_template* implied_template = new GeographicalArea_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = GeographicalArea_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RANAP-IEs.GeographicalArea");
  }
  is_ifpresent = param.get_ifpresent();
}

void GeographicalArea_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case GeographicalArea::ALT_point:
single_value.field_point->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
case GeographicalArea::ALT_pointWithUnCertainty:
single_value.field_pointWithUnCertainty->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
case GeographicalArea::ALT_polygon:
single_value.field_polygon->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
case GeographicalArea::ALT_pointWithUncertaintyEllipse:
single_value.field_pointWithUncertaintyEllipse->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
case GeographicalArea::ALT_pointWithAltitude:
single_value.field_pointWithAltitude->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
case GeographicalArea::ALT_pointWithAltitudeAndUncertaintyEllipsoid:
single_value.field_pointWithAltitudeAndUncertaintyEllipsoid->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
case GeographicalArea::ALT_ellipsoidArc:
single_value.field_ellipsoidArc->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalArea");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RANAP-IEs.GeographicalArea.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.GeographicalArea");
}

GeographicalCoordinates_latitudeSign::GeographicalCoordinates_latitudeSign()
{
enum_value = UNBOUND_VALUE;
}

GeographicalCoordinates_latitudeSign::GeographicalCoordinates_latitudeSign(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

GeographicalCoordinates_latitudeSign::GeographicalCoordinates_latitudeSign(enum_type other_value)
{
enum_value = other_value;
}

GeographicalCoordinates_latitudeSign::GeographicalCoordinates_latitudeSign(const GeographicalCoordinates_latitudeSign& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
enum_value = other_value.enum_value;
}

GeographicalCoordinates_latitudeSign& GeographicalCoordinates_latitudeSign::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

GeographicalCoordinates_latitudeSign& GeographicalCoordinates_latitudeSign::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

GeographicalCoordinates_latitudeSign& GeographicalCoordinates_latitudeSign::operator=(const GeographicalCoordinates_latitudeSign& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
enum_value = other_value.enum_value;
return *this;
}

boolean GeographicalCoordinates_latitudeSign::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean GeographicalCoordinates_latitudeSign::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value == other_value;
}

boolean GeographicalCoordinates_latitudeSign::operator==(const GeographicalCoordinates_latitudeSign& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value == other_value.enum_value;
}

boolean GeographicalCoordinates_latitudeSign::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean GeographicalCoordinates_latitudeSign::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value < other_value;
}

boolean GeographicalCoordinates_latitudeSign::operator<(const GeographicalCoordinates_latitudeSign& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value < other_value.enum_value;
}

boolean GeographicalCoordinates_latitudeSign::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean GeographicalCoordinates_latitudeSign::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value > other_value;
}

boolean GeographicalCoordinates_latitudeSign::operator>(const GeographicalCoordinates_latitudeSign& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value > other_value.enum_value;
}

const char *GeographicalCoordinates_latitudeSign::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case north: return "north";
case south: return "south";
default:
return "<unknown>";
}
}

GeographicalCoordinates_latitudeSign::enum_type GeographicalCoordinates_latitudeSign::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "north")) return north;
if (!strcmp(str_par, "south")) return south;
}
return UNKNOWN_VALUE;
}

boolean GeographicalCoordinates_latitudeSign::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int GeographicalCoordinates_latitudeSign::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int GeographicalCoordinates_latitudeSign::enum2int(const GeographicalCoordinates_latitudeSign& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void GeographicalCoordinates_latitudeSign::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", int_val);
enum_value = (enum_type)int_val;
}

GeographicalCoordinates_latitudeSign::operator GeographicalCoordinates_latitudeSign::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return enum_value;
}

void GeographicalCoordinates_latitudeSign::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void GeographicalCoordinates_latitudeSign::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RANAP-IEs.GeographicalCoordinates.latitudeSign");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
  }
}

void GeographicalCoordinates_latitudeSign::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
text_buf.push_int(enum_value);
}

void GeographicalCoordinates_latitudeSign::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", enum_value);
}

void GeographicalCoordinates_latitudeSign::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GeographicalCoordinates_latitudeSign::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* GeographicalCoordinates_latitudeSign::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean GeographicalCoordinates_latitudeSign::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @RANAP-IEs.GeographicalCoordinates.latitudeSign: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int GeographicalCoordinates_latitudeSign::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int GeographicalCoordinates_latitudeSign::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const GeographicalCoordinates_latitudeSign*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = north;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int GeographicalCoordinates_latitudeSign::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int GeographicalCoordinates_latitudeSign::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void GeographicalCoordinates_latitudeSign::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
switch (enum_value) {
case north:
enc_val = 0;
break;
case south:
enc_val = 1;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
INTEGER::PER_encode_int(p_buf, enc_val, 1);
}

void GeographicalCoordinates_latitudeSign::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
dec_val.PER_decode_unaligned_constrained(p_buf, 1, FALSE);
int dec_int = dec_val;
switch (dec_int) {
case 0: enum_value = north; break;
case 1: enum_value = south; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", dec_int);
break;
}
}

void GeographicalCoordinates_latitudeSign_template::copy_template(const GeographicalCoordinates_latitudeSign_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GeographicalCoordinates_latitudeSign_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GeographicalCoordinates_latitudeSign_template(*other_value.implication_.precondition);
implication_.implied_template = new GeographicalCoordinates_latitudeSign_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template()
{
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!GeographicalCoordinates_latitudeSign::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign with unknown numeric value %d.", other_value);
single_value = (GeographicalCoordinates_latitudeSign::enum_type)other_value;
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(GeographicalCoordinates_latitudeSign::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(const GeographicalCoordinates_latitudeSign& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == GeographicalCoordinates_latitudeSign::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
single_value = other_value.enum_value;
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(const OPTIONAL<GeographicalCoordinates_latitudeSign>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (GeographicalCoordinates_latitudeSign::enum_type)(const GeographicalCoordinates_latitudeSign&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign from an unbound optional field.");
}
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(GeographicalCoordinates_latitudeSign_template* p_precondition, GeographicalCoordinates_latitudeSign_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(Dynamic_Match_Interface<GeographicalCoordinates_latitudeSign>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GeographicalCoordinates_latitudeSign>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GeographicalCoordinates_latitudeSign_template::GeographicalCoordinates_latitudeSign_template(const GeographicalCoordinates_latitudeSign_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

GeographicalCoordinates_latitudeSign_template::~GeographicalCoordinates_latitudeSign_template()
{
clean_up();
}

boolean GeographicalCoordinates_latitudeSign_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean GeographicalCoordinates_latitudeSign_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != GeographicalCoordinates_latitudeSign::UNBOUND_VALUE;
}

void GeographicalCoordinates_latitudeSign_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::operator=(int other_value)
{
if (!GeographicalCoordinates_latitudeSign::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (GeographicalCoordinates_latitudeSign::enum_type)other_value;
return *this;
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::operator=(GeographicalCoordinates_latitudeSign::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::operator=(const GeographicalCoordinates_latitudeSign& other_value)
{
if (other_value.enum_value == GeographicalCoordinates_latitudeSign::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::operator=(const OPTIONAL<GeographicalCoordinates_latitudeSign>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (GeographicalCoordinates_latitudeSign::enum_type)(const GeographicalCoordinates_latitudeSign&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
return *this;
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::operator=(const GeographicalCoordinates_latitudeSign_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GeographicalCoordinates_latitudeSign_template::match(GeographicalCoordinates_latitudeSign::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
return FALSE;
}

boolean GeographicalCoordinates_latitudeSign_template::match(const GeographicalCoordinates_latitudeSign& other_value, boolean) const
{
if (other_value.enum_value == GeographicalCoordinates_latitudeSign::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign with an unbound value.");
return match(other_value.enum_value);
}

GeographicalCoordinates_latitudeSign::enum_type GeographicalCoordinates_latitudeSign_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return single_value;
}

void GeographicalCoordinates_latitudeSign_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GeographicalCoordinates_latitudeSign_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_latitudeSign_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
return value_list.list_value[list_index];
}

void GeographicalCoordinates_latitudeSign_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(GeographicalCoordinates_latitudeSign::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GeographicalCoordinates_latitudeSign_template::log_match(const GeographicalCoordinates_latitudeSign& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void GeographicalCoordinates_latitudeSign_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
}

void GeographicalCoordinates_latitudeSign_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (GeographicalCoordinates_latitudeSign::enum_type)text_buf.pull_int().get_val();
if (!GeographicalCoordinates_latitudeSign::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GeographicalCoordinates_latitudeSign_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
}
}

boolean GeographicalCoordinates_latitudeSign_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GeographicalCoordinates_latitudeSign_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void GeographicalCoordinates_latitudeSign_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GeographicalCoordinates_latitudeSign_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    GeographicalCoordinates_latitudeSign::enum_type enum_val = GeographicalCoordinates_latitudeSign::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!GeographicalCoordinates_latitudeSign::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RANAP-IEs.GeographicalCoordinates.latitudeSign.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    GeographicalCoordinates_latitudeSign_template* precondition = new GeographicalCoordinates_latitudeSign_template;
    precondition->set_param(*m_p->get_elem(0));
    GeographicalCoordinates_latitudeSign_template* implied_template = new GeographicalCoordinates_latitudeSign_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = GeographicalCoordinates_latitudeSign_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RANAP-IEs.GeographicalCoordinates.latitudeSign");
  }
  is_ifpresent = param.get_ifpresent();
}

void GeographicalCoordinates_latitudeSign_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.GeographicalCoordinates.latitudeSign");
}

GeographicalCoordinates::GeographicalCoordinates()
{
}

GeographicalCoordinates::GeographicalCoordinates(const GeographicalCoordinates_latitudeSign& par_latitudeSign,
    const INTEGER& par_latitude,
    const INTEGER& par_longitude,
    const OPTIONAL< _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 >& par_iE__Extensions)
  :   field_latitudeSign(par_latitudeSign),
  field_latitude(par_latitude),
  field_longitude(par_longitude),
  field_iE__Extensions(par_iE__Extensions)
{
}

GeographicalCoordinates::GeographicalCoordinates(const GeographicalCoordinates& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.GeographicalCoordinates.");
if (other_value.latitudeSign().is_bound()) field_latitudeSign = other_value.latitudeSign();
else field_latitudeSign.clean_up();
if (other_value.latitude().is_bound()) field_latitude = other_value.latitude();
else field_latitude.clean_up();
if (other_value.longitude().is_bound()) field_longitude = other_value.longitude();
else field_longitude.clean_up();
if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
else field_iE__Extensions.clean_up();
}

void GeographicalCoordinates::clean_up()
{
field_latitudeSign.clean_up();
field_latitude.clean_up();
field_longitude.clean_up();
field_iE__Extensions.clean_up();
}

const TTCN_Typedescriptor_t* GeographicalCoordinates::get_descriptor() const { return &GeographicalCoordinates_descr_; }
GeographicalCoordinates& GeographicalCoordinates::operator=(const GeographicalCoordinates& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-IEs.GeographicalCoordinates.");
  if (other_value.latitudeSign().is_bound()) field_latitudeSign = other_value.latitudeSign();
  else field_latitudeSign.clean_up();
  if (other_value.latitude().is_bound()) field_latitude = other_value.latitude();
  else field_latitude.clean_up();
  if (other_value.longitude().is_bound()) field_longitude = other_value.longitude();
  else field_longitude.clean_up();
  if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
  else field_iE__Extensions.clean_up();
}
return *this;
}

boolean GeographicalCoordinates::operator==(const GeographicalCoordinates& other_value) const
{
return field_latitudeSign==other_value.field_latitudeSign
  && field_latitude==other_value.field_latitude
  && field_longitude==other_value.field_longitude
  && field_iE__Extensions==other_value.field_iE__Extensions;
}

boolean GeographicalCoordinates::is_bound() const
{
return (field_latitudeSign.is_bound())
  || (field_latitude.is_bound())
  || (field_longitude.is_bound())
  || (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_bound());
}
boolean GeographicalCoordinates::is_value() const
{
return field_latitudeSign.is_value()
  && field_latitude.is_value()
  && field_longitude.is_value()
  && (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_value());
}
int GeographicalCoordinates::size_of() const
{
  int ret_val = 3;
  if (field_iE__Extensions.ispresent()) ret_val++;
  return ret_val;
}

void GeographicalCoordinates::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ latitudeSign := ");
field_latitudeSign.log();
TTCN_Logger::log_event_str(", latitude := ");
field_latitude.log();
TTCN_Logger::log_event_str(", longitude := ");
field_longitude.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
field_iE__Extensions.log();
TTCN_Logger::log_event_str(" }");
}

void GeographicalCoordinates::set_implicit_omit()
{
if (latitudeSign().is_bound()) latitudeSign().set_implicit_omit();
if (latitude().is_bound()) latitude().set_implicit_omit();
if (longitude().is_bound()) longitude().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
}

void GeographicalCoordinates::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RANAP-IEs.GeographicalCoordinates has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) latitudeSign().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) latitude().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) longitude().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "latitudeSign")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          latitudeSign().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "latitude")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          latitude().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "longitude")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          longitude().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.GeographicalCoordinates: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-IEs.GeographicalCoordinates");
  }
}

void GeographicalCoordinates::encode_text(Text_Buf& text_buf) const
{
field_latitudeSign.encode_text(text_buf);
field_latitude.encode_text(text_buf);
field_longitude.encode_text(text_buf);
field_iE__Extensions.encode_text(text_buf);
}

void GeographicalCoordinates::decode_text(Text_Buf& text_buf)
{
field_latitudeSign.decode_text(text_buf);
field_latitude.decode_text(text_buf);
field_longitude.decode_text(text_buf);
field_iE__Extensions.decode_text(text_buf);
}

void GeographicalCoordinates::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GeographicalCoordinates::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* GeographicalCoordinates::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("latitudeSign': ");
  new_tlv->add_TLV(field_latitudeSign.BER_encode_TLV(GeographicalCoordinates_latitudeSign_descr_, p_coding));
  ec_1.set_msg("latitude': ");
  new_tlv->add_TLV(field_latitude.BER_encode_TLV(GeographicalCoordinates_latitude_descr_, p_coding));
  ec_1.set_msg("longitude': ");
  new_tlv->add_TLV(field_longitude.BER_encode_TLV(GeographicalCoordinates_longitude_descr_, p_coding));
  ec_1.set_msg("iE_Extensions': ");
  new_tlv->add_TLV(field_iE__Extensions.BER_encode_TLV(GeographicalCoordinates_iE__Extensions_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean GeographicalCoordinates::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-IEs.GeographicalCoordinates' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("latitudeSign': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_latitudeSign.BER_decode_TLV(GeographicalCoordinates_latitudeSign_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("latitude': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_latitude.BER_decode_TLV(GeographicalCoordinates_latitude_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("longitude': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_longitude.BER_decode_TLV(GeographicalCoordinates_longitude_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("iE_Extensions': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_iE__Extensions=OMIT_VALUE;
    else {
      field_iE__Extensions.BER_decode_TLV(GeographicalCoordinates_iE__Extensions_descr_, tmp_tlv, L_form);
      if(field_iE__Extensions.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int GeographicalCoordinates::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.GeographicalCoordinates.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "latitudeSign");
    enc_len += field_latitudeSign.JSON_encode(GeographicalCoordinates_latitudeSign_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "latitude");
    enc_len += field_latitude.JSON_encode(GeographicalCoordinates_latitude_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "longitude");
    enc_len += field_longitude.JSON_encode(GeographicalCoordinates_longitude_descr_, p_tok, FALSE);
  }

  if (field_iE__Extensions.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "iE_Extensions");
    enc_len += field_iE__Extensions.JSON_encode(GeographicalCoordinates_iE__Extensions_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int GeographicalCoordinates::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const GeographicalCoordinates*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean latitudeSign_found = FALSE;
  boolean latitude_found = FALSE;
  boolean longitude_found = FALSE;
  boolean iE__Extensions_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (12 == name_len && 0 == strncmp(fld_name, "latitudeSign", name_len)) {
        latitudeSign_found = TRUE;
         int ret_val = field_latitudeSign.JSON_decode(GeographicalCoordinates_latitudeSign_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "latitudeSign");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "latitude", name_len)) {
        latitude_found = TRUE;
         int ret_val = field_latitude.JSON_decode(GeographicalCoordinates_latitude_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "latitude");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (9 == name_len && 0 == strncmp(fld_name, "longitude", name_len)) {
        longitude_found = TRUE;
         int ret_val = field_longitude.JSON_decode(GeographicalCoordinates_longitude_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "longitude");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "iE_Extensions", name_len)) {
        iE__Extensions_found = TRUE;
         int ret_val = field_iE__Extensions.JSON_decode(GeographicalCoordinates_iE__Extensions_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "iE_Extensions");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!latitudeSign_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "latitudeSign");
    return JSON_ERROR_FATAL;
  }
  if (!latitude_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "latitude");
    return JSON_ERROR_FATAL;
  }
  if (!longitude_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "longitude");
    return JSON_ERROR_FATAL;
  }
  if (!iE__Extensions_found) {
    field_iE__Extensions = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int GeographicalCoordinates::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_iE__Extensions.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_latitudeSign.OER_encode(GeographicalCoordinates_latitudeSign_descr_, p_buf);
  field_latitude.OER_encode(GeographicalCoordinates_latitude_descr_, p_buf);
  field_longitude.OER_encode(GeographicalCoordinates_longitude_descr_, p_buf);
  if (field_iE__Extensions.is_present())
    field_iE__Extensions.OER_encode(GeographicalCoordinates_iE__Extensions_descr_, p_buf);
  return 0;
}

int GeographicalCoordinates::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_latitudeSign.OER_decode(GeographicalCoordinates_latitudeSign_descr_, p_buf, p_oer);
  field_latitude.OER_decode(GeographicalCoordinates_latitude_descr_, p_buf, p_oer);
  field_longitude.OER_decode(GeographicalCoordinates_longitude_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_iE__Extensions.OER_decode(GeographicalCoordinates_iE__Extensions_descr_, p_buf, p_oer);
 else
    field_iE__Extensions = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void GeographicalCoordinates::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_iE__Extensions_present = field_iE__Extensions.is_present();
p_buf.PER_put_bit(field_iE__Extensions_present);
field_latitudeSign.PER_encode(GeographicalCoordinates_latitudeSign_descr_, p_buf, p_options);
field_latitude.PER_encode(GeographicalCoordinates_latitude_descr_, p_buf, p_options);
field_longitude.PER_encode(GeographicalCoordinates_longitude_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_encode(GeographicalCoordinates_iE__Extensions_descr_, p_buf, p_options);
}

void GeographicalCoordinates::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_iE__Extensions_present = p_buf.PER_get_bit();
field_latitudeSign.PER_decode(GeographicalCoordinates_latitudeSign_descr_, p_buf, p_options);
field_latitude.PER_decode(GeographicalCoordinates_latitude_descr_, p_buf, p_options);
field_longitude.PER_decode(GeographicalCoordinates_longitude_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_decode(GeographicalCoordinates_iE__Extensions_descr_, p_buf, p_options);
else field_iE__Extensions = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct GeographicalCoordinates_template::single_value_struct {
GeographicalCoordinates_latitudeSign_template field_latitudeSign;
INTEGER_template field_latitude;
INTEGER_template field_longitude;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template field_iE__Extensions;
};

void GeographicalCoordinates_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_latitudeSign = ANY_VALUE;
single_value->field_latitude = ANY_VALUE;
single_value->field_longitude = ANY_VALUE;
single_value->field_iE__Extensions = ANY_OR_OMIT;
}
}
}

void GeographicalCoordinates_template::copy_value(const GeographicalCoordinates& other_value)
{
single_value = new single_value_struct;
if (other_value.latitudeSign().is_bound()) {
  single_value->field_latitudeSign = other_value.latitudeSign();
} else {
  single_value->field_latitudeSign.clean_up();
}
if (other_value.latitude().is_bound()) {
  single_value->field_latitude = other_value.latitude();
} else {
  single_value->field_latitude.clean_up();
}
if (other_value.longitude().is_bound()) {
  single_value->field_longitude = other_value.longitude();
} else {
  single_value->field_longitude.clean_up();
}
if (other_value.iE__Extensions().is_bound()) {
  if (other_value.iE__Extensions().ispresent()) single_value->field_iE__Extensions = other_value.iE__Extensions()();
  else single_value->field_iE__Extensions = OMIT_VALUE;
} else {
  single_value->field_iE__Extensions.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GeographicalCoordinates_template::copy_template(const GeographicalCoordinates_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.latitudeSign().get_selection()) {
single_value->field_latitudeSign = other_value.latitudeSign();
} else {
single_value->field_latitudeSign.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.latitude().get_selection()) {
single_value->field_latitude = other_value.latitude();
} else {
single_value->field_latitude.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.longitude().get_selection()) {
single_value->field_longitude = other_value.longitude();
} else {
single_value->field_longitude.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iE__Extensions().get_selection()) {
single_value->field_iE__Extensions = other_value.iE__Extensions();
} else {
single_value->field_iE__Extensions.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GeographicalCoordinates_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GeographicalCoordinates_template(*other_value.implication_.precondition);
implication_.implied_template = new GeographicalCoordinates_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.GeographicalCoordinates.");
break;
}
set_selection(other_value);
}

GeographicalCoordinates_template::GeographicalCoordinates_template()
{
}

GeographicalCoordinates_template::GeographicalCoordinates_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GeographicalCoordinates_template::GeographicalCoordinates_template(const GeographicalCoordinates& other_value)
{
copy_value(other_value);
}

GeographicalCoordinates_template::GeographicalCoordinates_template(const OPTIONAL<GeographicalCoordinates>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GeographicalCoordinates&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.GeographicalCoordinates from an unbound optional field.");
}
}

GeographicalCoordinates_template::GeographicalCoordinates_template(GeographicalCoordinates_template* p_precondition, GeographicalCoordinates_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GeographicalCoordinates_template::GeographicalCoordinates_template(Dynamic_Match_Interface<GeographicalCoordinates>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GeographicalCoordinates>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GeographicalCoordinates_template::GeographicalCoordinates_template(const GeographicalCoordinates_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GeographicalCoordinates_template::~GeographicalCoordinates_template()
{
clean_up();
}

GeographicalCoordinates_template& GeographicalCoordinates_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GeographicalCoordinates_template& GeographicalCoordinates_template::operator=(const GeographicalCoordinates& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GeographicalCoordinates_template& GeographicalCoordinates_template::operator=(const OPTIONAL<GeographicalCoordinates>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GeographicalCoordinates&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.GeographicalCoordinates.");
}
return *this;
}

GeographicalCoordinates_template& GeographicalCoordinates_template::operator=(const GeographicalCoordinates_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GeographicalCoordinates_template::match(const GeographicalCoordinates& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.latitudeSign().is_bound()) return FALSE;
if(!single_value->field_latitudeSign.match(other_value.latitudeSign(), legacy))return FALSE;
if(!other_value.latitude().is_bound()) return FALSE;
if(!single_value->field_latitude.match(other_value.latitude(), legacy))return FALSE;
if(!other_value.longitude().is_bound()) return FALSE;
if(!single_value->field_longitude.match(other_value.longitude(), legacy))return FALSE;
if(!other_value.iE__Extensions().is_bound()) return FALSE;
if((other_value.iE__Extensions().ispresent() ? !single_value->field_iE__Extensions.match((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20&)other_value.iE__Extensions(), legacy) : !single_value->field_iE__Extensions.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-IEs.GeographicalCoordinates.");
}
return FALSE;
}

boolean GeographicalCoordinates_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_latitudeSign.is_bound()
 || single_value->field_latitude.is_bound()
 || single_value->field_longitude.is_bound()
 || (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_bound());
}

boolean GeographicalCoordinates_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_latitudeSign.is_value()
 && single_value->field_latitude.is_value()
 && single_value->field_longitude.is_value()
 && (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_value());
}

void GeographicalCoordinates_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GeographicalCoordinates GeographicalCoordinates_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.GeographicalCoordinates.");
GeographicalCoordinates ret_val;
if (single_value->field_latitudeSign.is_bound()) {
ret_val.latitudeSign() = single_value->field_latitudeSign.valueof();
}
if (single_value->field_latitude.is_bound()) {
ret_val.latitude() = single_value->field_latitude.valueof();
}
if (single_value->field_longitude.is_bound()) {
ret_val.longitude() = single_value->field_longitude.valueof();
}
if (single_value->field_iE__Extensions.is_omit()) ret_val.iE__Extensions() = OMIT_VALUE;
else if (single_value->field_iE__Extensions.is_bound()) {
ret_val.iE__Extensions() = single_value->field_iE__Extensions.valueof();
}
return ret_val;
}

void GeographicalCoordinates_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-IEs.GeographicalCoordinates.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GeographicalCoordinates_template[list_length];
}

GeographicalCoordinates_template& GeographicalCoordinates_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-IEs.GeographicalCoordinates.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-IEs.GeographicalCoordinates.");
return value_list.list_value[list_index];
}

GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_template::latitudeSign()
{
set_specific();
return single_value->field_latitudeSign;
}

const GeographicalCoordinates_latitudeSign_template& GeographicalCoordinates_template::latitudeSign() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field latitudeSign of a non-specific template of type @RANAP-IEs.GeographicalCoordinates.");
return single_value->field_latitudeSign;
}

INTEGER_template& GeographicalCoordinates_template::latitude()
{
set_specific();
return single_value->field_latitude;
}

const INTEGER_template& GeographicalCoordinates_template::latitude() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field latitude of a non-specific template of type @RANAP-IEs.GeographicalCoordinates.");
return single_value->field_latitude;
}

INTEGER_template& GeographicalCoordinates_template::longitude()
{
set_specific();
return single_value->field_longitude;
}

const INTEGER_template& GeographicalCoordinates_template::longitude() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field longitude of a non-specific template of type @RANAP-IEs.GeographicalCoordinates.");
return single_value->field_longitude;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& GeographicalCoordinates_template::iE__Extensions()
{
set_specific();
return single_value->field_iE__Extensions;
}

const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& GeographicalCoordinates_template::iE__Extensions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iE_Extensions of a non-specific template of type @RANAP-IEs.GeographicalCoordinates.");
return single_value->field_iE__Extensions;
}

int GeographicalCoordinates_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_iE__Extensions.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GeographicalCoordinates containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-IEs.GeographicalCoordinates.");
  }
  return 0;
}

void GeographicalCoordinates_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ latitudeSign := ");
single_value->field_latitudeSign.log();
TTCN_Logger::log_event_str(", latitude := ");
single_value->field_latitude.log();
TTCN_Logger::log_event_str(", longitude := ");
single_value->field_longitude.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GeographicalCoordinates_template::log_match(const GeographicalCoordinates& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_latitudeSign.match(match_value.latitudeSign(), legacy)){
TTCN_Logger::log_logmatch_info(".latitudeSign");
single_value->field_latitudeSign.log_match(match_value.latitudeSign(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_latitude.match(match_value.latitude(), legacy)){
TTCN_Logger::log_logmatch_info(".latitude");
single_value->field_latitude.log_match(match_value.latitude(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_longitude.match(match_value.longitude(), legacy)){
TTCN_Logger::log_logmatch_info(".longitude");
single_value->field_longitude.log_match(match_value.longitude(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.iE__Extensions().ispresent()){
if(!single_value->field_iE__Extensions.match(match_value.iE__Extensions(), legacy)){
TTCN_Logger::log_logmatch_info(".iE_Extensions");
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_iE__Extensions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".iE_Extensions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ latitudeSign := ");
single_value->field_latitudeSign.log_match(match_value.latitudeSign(), legacy);
TTCN_Logger::log_event_str(", latitude := ");
single_value->field_latitude.log_match(match_value.latitude(), legacy);
TTCN_Logger::log_event_str(", longitude := ");
single_value->field_longitude.log_match(match_value.longitude(), legacy);
TTCN_Logger::log_event_str(", iE_Extensions := ");
if (match_value.iE__Extensions().ispresent()) {
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_iE__Extensions.log();
if (single_value->field_iE__Extensions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GeographicalCoordinates_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (latitudeSign().is_bound()) latitudeSign().set_implicit_omit();
if (latitude().is_bound()) latitude().set_implicit_omit();
if (longitude().is_bound()) longitude().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
}

void GeographicalCoordinates_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_latitudeSign.encode_text(text_buf);
single_value->field_latitude.encode_text(text_buf);
single_value->field_longitude.encode_text(text_buf);
single_value->field_iE__Extensions.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.GeographicalCoordinates.");
}
}

void GeographicalCoordinates_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_latitudeSign.decode_text(text_buf);
single_value->field_latitude.decode_text(text_buf);
single_value->field_longitude.decode_text(text_buf);
single_value->field_iE__Extensions.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GeographicalCoordinates_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-IEs.GeographicalCoordinates.");
}
}

void GeographicalCoordinates_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GeographicalCoordinates_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RANAP-IEs.GeographicalCoordinates has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) latitudeSign().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) latitude().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) longitude().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "latitudeSign")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          latitudeSign().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "latitude")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          latitude().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "longitude")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          longitude().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.GeographicalCoordinates: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GeographicalCoordinates_template* precondition = new GeographicalCoordinates_template;
    precondition->set_param(*param.get_elem(0));
    GeographicalCoordinates_template* implied_template = new GeographicalCoordinates_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GeographicalCoordinates_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-IEs.GeographicalCoordinates");
  }
  is_ifpresent = param.get_ifpresent();
}

void GeographicalCoordinates_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_latitudeSign.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalCoordinates");
single_value->field_latitude.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalCoordinates");
single_value->field_longitude.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalCoordinates");
single_value->field_iE__Extensions.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GeographicalCoordinates");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.GeographicalCoordinates");
}

boolean GeographicalCoordinates_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GeographicalCoordinates_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::UNBOUND_ELEM;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20()
{
val_ptr = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return val_ptr->n_elements == 0 ;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator==(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20;
}
return *val_ptr->value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return (*this)[(int)index_value];
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::operator+(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return val_ptr->n_elements;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    new_tlv=ASN_BER_TLV_t::construct(NULL);
    TTCN_EncDec_ErrorContext ec;
    for(int elem_i=0; elem_i<val_ptr->n_elements; elem_i++) {
      ec.set_msg("Component #%d: ", elem_i);
      new_tlv->add_TLV((*this)[elem_i].BER_encode_TLV(*p_td.oftype_descr, p_coding));
    }
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '%s' type: ", p_td.name);
  stripped_tlv.chk_constructed_flag(TRUE);
  clean_up();
  val_ptr = new recordof_setof_struct;
  val_ptr->ref_count = 1;
  val_ptr->n_elements = 0;
  val_ptr->value_elements = NULL;
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  TTCN_EncDec_ErrorContext ec_1("Component #");
  TTCN_EncDec_ErrorContext ec_2("0: ");
  while(BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv)) {
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->n_elements++;
    val_ptr->value_elements[val_ptr->n_elements - 1] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20;
    val_ptr->value_elements[val_ptr->n_elements - 1]->BER_decode_TLV(*p_td.oftype_descr, tmp_tlv, L_form);
    ec_2.set_msg("%d: ", val_ptr->n_elements);
  }
  return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_START : JSON_TOKEN_ARRAY_START, NULL);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    if (p_td.json->metainfo_unbound && !(*this)[i].is_bound()) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "metainfo []");
      enc_len += p_tok.put_next_token(JSON_TOKEN_STRING, "\"unbound\"");
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
    }
    else {
      int ret_val = (*this)[i].JSON_encode(*p_td.oftype_descr, p_tok, p_td.json->as_map);
      if (0 > ret_val) break;
      enc_len += ret_val;
    }
  }
  enc_len += p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_END : JSON_TOKEN_ARRAY_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    set_size(0);
    return strlen(p_td.json->default_value.str);
  }
  json_token_t token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&token, NULL, NULL);
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_START != token) ||
           (p_td.json->as_map && JSON_TOKEN_OBJECT_START != token)) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  set_size(0);
  for (int nof_elements = 0; TRUE; ++nof_elements) {
    size_t buf_pos = p_tok.get_buf_pos();
    size_t ret_val;
    if (p_td.json->metainfo_unbound) {
      ret_val = p_tok.get_next_token(&token, NULL, NULL);
      if (JSON_TOKEN_OBJECT_START == token) {
        char* value = NULL;
        size_t value_len = 0;
        ret_val += p_tok.get_next_token(&token, &value, &value_len);
        if (JSON_TOKEN_NAME == token && 11 == value_len &&
            0 == strncmp(value, "metainfo []", 11)) {
          ret_val += p_tok.get_next_token(&token, &value, &value_len);
          if (JSON_TOKEN_STRING == token && 9 == value_len &&
              0 == strncmp(value, "\"unbound\"", 9)) {
            ret_val = p_tok.get_next_token(&token, NULL, NULL);
            if (JSON_TOKEN_OBJECT_END == token) {
              dec_len += ret_val;
              continue;
            }
          }
        }
      }
      p_tok.set_buf_pos(buf_pos);
    }
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20* val = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20;
    int ret_val2 = val->JSON_decode(*p_td.oftype_descr, p_tok, p_silent, p_td.json->as_map);
    if (JSON_ERROR_INVALID_TOKEN == ret_val2) {
      p_tok.set_buf_pos(buf_pos);
      delete val;
      break;
    }
    else if (JSON_ERROR_FATAL == ret_val2) {
      delete val;
      if (p_silent) {
        clean_up();
      }
      return JSON_ERROR_FATAL;
    }
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20**)reallocate_pointers(
      (void**)val_ptr->value_elements, val_ptr->n_elements, nof_elements + 1);
    val_ptr->value_elements[nof_elements] = val;
    val_ptr->n_elements = nof_elements + 1;
    dec_len += (size_t)ret_val2;
  }

  dec_len += p_tok.get_next_token(&token, NULL, NULL);
  if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_END != token) ||
      (p_td.json->as_map && JSON_TOKEN_OBJECT_END != token)) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_REC_OF_END_TOKEN_ERROR, "");
    if (p_silent) {
      clean_up();
    }
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::OER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
    return -1;
  }

  encode_oer_length(val_ptr->n_elements, p_buf, TRUE);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    (*this)[i].OER_encode(*p_td.oftype_descr, p_buf);
  }
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::OER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t nof_elem = decode_oer_length(p_buf, TRUE);
  set_size(nof_elem);
  for (size_t i = 0; i < nof_elem; i++) {
    (*this)[i].OER_decode(*p_td.oftype_descr, p_buf, p_oer);
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
"Encoding an unbound SEQUENCE OF value.");
return;
}
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
INTEGER length(val_ptr->n_elements);
boolean extendable = cons->has_extension_marker();
boolean within_ext_root = cons->is_within_extension_root(length);
if (!within_ext_root && !extendable) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT,
"Encoding an invalid SEQUENCE OF value (does not match PER-visible constraints).");
return;
}
boolean ext_bit = extendable && !within_ext_root;
if (extendable) p_buf.PER_put_bit(ext_bit);
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
if (range == 1 && length == 0) return;
int mul_16k;
int pos = 0;
do {
mul_16k = (range == 1) ? 0 : length.PER_encode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
int elements_encoded = (mul_16k == 0) ? (int)length : mul_16k * PER_16K;
for (int i = 0; i < elements_encoded; ++i) {
(*this)[i + pos].PER_encode(*p_td.oftype_descr, p_buf, p_options);
}
if (mul_16k > 0) {
pos += elements_encoded;
length = length - elements_encoded;
range = 0;
}
}
while (mul_16k > 0);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
clean_up();
boolean extendable = cons->has_extension_marker();
boolean ext_bit = extendable ? p_buf.PER_get_bit() : FALSE;
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
int mul_16k;
INTEGER length;
int current_size = 0;
do {
mul_16k = length.PER_decode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
if (mul_16k != 0) range = 0;
int new_size = current_size + (int)length;
set_size(new_size);
for (int i = current_size; i < new_size; ++i) {
(*this)[i].PER_decode(*p_td.oftype_descr, p_buf, p_options);
}
current_size = new_size;
}
while (mul_16k > 0);
if (!ext_bit && !cons->is_within_extension_root(val_ptr->n_elements)) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT, "Decoded SEQUENCE OF value does not match PER-visible constraints.");
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
break;
}
set_selection(other_value);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20*)value_ptr)[value_index], legacy);
else return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template()
{
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
    break;
}
return *single_value.value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return (*this)[(int)index_value];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20 containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
}
set_selection(template_type);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
return value_list.list_value[list_index];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::log_match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template* precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst20");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst20_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value)
{
switch (other_value.union_selection) {
default:
TTCN_error("Assignment of an unbound union value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
union_selection = other_value.union_selection;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type()
{
union_selection = UNBOUND_VALUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value)
: Base_Type(){
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
default:
return FALSE;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
return union_selection == checked_selection;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
default: TTCN_error("Invalid selection in union is_bound");}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::clean_up()
{
switch (union_selection) {
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::log() const
{
switch (union_selection) {
default:
TTCN_Logger::log_event_unbound();
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.", last_name);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::set_implicit_omit()
{
switch (union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type' type: ");
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tlv_opentype)) {
    tlv_opentype.Tlen = 0;
    return FALSE;
  }
  clean_up();
  union_selection = UNBOUND_VALUE;
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean) const
{
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
    "Cannot encode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type, because it has zero alternatives.");
  return -1;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, 
    "Cannot decode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type, because it has zero alternatives.");
  return JSON_ERROR_FATAL;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
    return -1;
  }

  return 0;
}
int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t pos = decode_oer_length(p_buf, FALSE);
  size_t prev_pos = p_buf.get_pos();
  p_buf.increase_pos(pos);
  p_oer.opentype_poses.push_back(prev_pos);
  return 0;
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
default:
TTCN_error("Initializing a template with an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& other_value)
: Base_Template(){
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::union_selection_type value_selection = other_value.get_selection();
if (value_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type ret_val;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
return value_list.list_value[list_index];
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template[list_length];
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::ischosen(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::union_selection_type checked_selection) const
{
if (checked_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
switch (single_value.union_selection) {
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::UNBOUND_VALUE;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::union_selection_type new_selection = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type'");
    }
    param.error("Field `%s' not found in union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template;
    precondition->set_param(*m_p->get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.extensionValue.type");
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(const INTEGER& par_id,
    const RANAP__CommonDataTypes::Criticality& par_criticality,
    const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type& par_extensionValue)
  :   field_id(par_id),
  field_criticality(par_criticality),
  field_extensionValue(par_extensionValue)
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
if (other_value.id().is_bound()) field_id = other_value.id();
else field_id.clean_up();
if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
else field_criticality.clean_up();
if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
else field_extensionValue.clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::clean_up()
{
field_id.clean_up();
field_criticality.clean_up();
field_extensionValue.clean_up();
}

const TTCN_Typedescriptor_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::get_descriptor() const { return &_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_descr_; }
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
  if (other_value.id().is_bound()) field_id = other_value.id();
  else field_id.clean_up();
  if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
  else field_criticality.clean_up();
  if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
  else field_extensionValue.clean_up();
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value) const
{
return field_id==other_value.field_id
  && field_criticality==other_value.field_criticality
  && field_extensionValue==other_value.field_extensionValue;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::is_bound() const
{
return (field_id.is_bound())
  || (field_criticality.is_bound())
  || (field_extensionValue.is_bound());
}
boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::is_value() const
{
return field_id.is_value()
  && field_criticality.is_value()
  && field_extensionValue.is_value();
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ id := ");
field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::set_implicit_omit()
{
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20");
  }
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::encode_text(Text_Buf& text_buf) const
{
field_id.encode_text(text_buf);
field_criticality.encode_text(text_buf);
field_extensionValue.encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::decode_text(Text_Buf& text_buf)
{
field_id.decode_text(text_buf);
field_criticality.decode_text(text_buf);
field_extensionValue.decode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  new_tlv->add_TLV(field_id.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_coding));
  ec_1.set_msg("criticality': ");
  new_tlv->add_TLV(field_criticality.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_coding));
  ec_1.set_msg("extensionValue': ");
  new_tlv->add_TLV(field_extensionValue.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("id': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_id.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("criticality': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_criticality.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionValue': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_extensionValue.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");
  TTCN_Type_list p_typelist;
  BER_decode_opentypes(p_typelist, L_form);
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("criticality': ");
  field_criticality.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.BER_decode_opentypes(p_typelist, L_form);
  p_typelist.pop();
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "id");
    enc_len += field_id.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "criticality");
    enc_len += field_criticality.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionValue");
    enc_len += field_extensionValue.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean id_found = FALSE;
  boolean criticality_found = FALSE;
  boolean extensionValue_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (2 == name_len && 0 == strncmp(fld_name, "id", name_len)) {
        id_found = TRUE;
         int ret_val = field_id.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "id");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "criticality", name_len)) {
        criticality_found = TRUE;
         int ret_val = field_criticality.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "criticality");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "extensionValue", name_len)) {
        extensionValue_found = TRUE;
         int ret_val = field_extensionValue.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "extensionValue");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!id_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "id");
    return JSON_ERROR_FATAL;
  }
  if (!criticality_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "criticality");
    return JSON_ERROR_FATAL;
  }
  if (!extensionValue_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "extensionValue");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  field_id.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_buf);
  field_criticality.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_buf);
  field_extensionValue.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_buf);
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  field_id.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_buf, p_oer);
  field_criticality.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_buf, p_oer);
  field_extensionValue.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_buf, p_oer);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");  TTCN_Type_list p_typelist;
  OER_decode_opentypes(p_typelist, p_buf, p_oer);
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("criticality': ");
  field_criticality.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  p_typelist.pop();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
field_id.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_buf, p_options);
field_criticality.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_buf, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
field_id.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_id_descr_, p_buf, p_options);
field_criticality.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_descr_, p_buf, p_options);
TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");TTCN_Type_list p_typelist;
PER_decode_opentypes(p_typelist, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20::PER_decode_opentypes(TTCN_Type_list& p_typelist, int p_options)
{
p_typelist.push(this);
TTCN_EncDec_ErrorContext ec_0("Component '");
TTCN_EncDec_ErrorContext ec_1;
ec_1.set_msg("id': ");
field_id.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("criticality': ");
field_criticality.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("extensionValue': ");
field_extensionValue.PER_decode_opentypes(p_typelist, p_options);
p_typelist.pop();
}

struct _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::single_value_struct {
INTEGER_template field_id;
RANAP__CommonDataTypes::Criticality_template field_criticality;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template field_extensionValue;
};

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_id = ANY_VALUE;
single_value->field_criticality = ANY_VALUE;
single_value->field_extensionValue = ANY_VALUE;
}
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value)
{
single_value = new single_value_struct;
if (other_value.id().is_bound()) {
  single_value->field_id = other_value.id();
} else {
  single_value->field_id.clean_up();
}
if (other_value.criticality().is_bound()) {
  single_value->field_criticality = other_value.criticality();
} else {
  single_value->field_criticality.clean_up();
}
if (other_value.extensionValue().is_bound()) {
  single_value->field_extensionValue = other_value.extensionValue();
} else {
  single_value->field_extensionValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.id().get_selection()) {
single_value->field_id = other_value.id();
} else {
single_value->field_id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.criticality().get_selection()) {
single_value->field_criticality = other_value.criticality();
} else {
single_value->field_criticality.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionValue().get_selection()) {
single_value->field_extensionValue = other_value.extensionValue();
} else {
single_value->field_extensionValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
break;
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.id().is_bound()) return FALSE;
if(!single_value->field_id.match(other_value.id(), legacy))return FALSE;
if(!other_value.criticality().is_bound()) return FALSE;
if(!single_value->field_criticality.match(other_value.criticality(), legacy))return FALSE;
if(!other_value.extensionValue().is_bound()) return FALSE;
if(!single_value->field_extensionValue.match(other_value.extensionValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_id.is_bound()
 || single_value->field_criticality.is_bound()
 || single_value->field_extensionValue.is_bound();
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_id.is_value()
 && single_value->field_criticality.is_value()
 && single_value->field_extensionValue.is_value();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20 _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20 ret_val;
if (single_value->field_id.is_bound()) {
ret_val.id() = single_value->field_id.valueof();
}
if (single_value->field_criticality.is_bound()) {
ret_val.criticality() = single_value->field_criticality.valueof();
}
if (single_value->field_extensionValue.is_bound()) {
ret_val.extensionValue() = single_value->field_extensionValue.valueof();
}
return ret_val;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template[list_length];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
return value_list.list_value[list_index];
}

INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::id()
{
set_specific();
return single_value->field_id;
}

const INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
return single_value->field_id;
}

RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::criticality()
{
set_specific();
return single_value->field_criticality;
}

const RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::criticality() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field criticality of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
return single_value->field_criticality;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::extensionValue()
{
set_specific();
return single_value->field_extensionValue;
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::extensionValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionValue of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
return single_value->field_extensionValue;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_id.match(match_value.id(), legacy)){
TTCN_Logger::log_logmatch_info(".id");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_criticality.match(match_value.criticality(), legacy)){
TTCN_Logger::log_logmatch_info(".criticality");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_extensionValue.match(match_value.extensionValue(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionValue");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_id.encode_text(text_buf);
single_value->field_criticality.encode_text(text_buf);
single_value->field_extensionValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_id.decode_text(text_buf);
single_value->field_criticality.decode_text(text_buf);
single_value->field_extensionValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_id.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20");
single_value->field_criticality.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20");
single_value->field_extensionValue.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst20");
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst20_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

GA__Point::GA__Point()
{
}

GA__Point::GA__Point(const GeographicalCoordinates& par_geographicalCoordinates,
    const OPTIONAL< _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 >& par_iE__Extensions)
  :   field_geographicalCoordinates(par_geographicalCoordinates),
  field_iE__Extensions(par_iE__Extensions)
{
}

GA__Point::GA__Point(const GA__Point& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.GA-Point.");
if (other_value.geographicalCoordinates().is_bound()) field_geographicalCoordinates = other_value.geographicalCoordinates();
else field_geographicalCoordinates.clean_up();
if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
else field_iE__Extensions.clean_up();
}

void GA__Point::clean_up()
{
field_geographicalCoordinates.clean_up();
field_iE__Extensions.clean_up();
}

const TTCN_Typedescriptor_t* GA__Point::get_descriptor() const { return &GA__Point_descr_; }
GA__Point& GA__Point::operator=(const GA__Point& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-IEs.GA-Point.");
  if (other_value.geographicalCoordinates().is_bound()) field_geographicalCoordinates = other_value.geographicalCoordinates();
  else field_geographicalCoordinates.clean_up();
  if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
  else field_iE__Extensions.clean_up();
}
return *this;
}

boolean GA__Point::operator==(const GA__Point& other_value) const
{
return field_geographicalCoordinates==other_value.field_geographicalCoordinates
  && field_iE__Extensions==other_value.field_iE__Extensions;
}

boolean GA__Point::is_bound() const
{
return (field_geographicalCoordinates.is_bound())
  || (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_bound());
}
boolean GA__Point::is_value() const
{
return field_geographicalCoordinates.is_value()
  && (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_value());
}
int GA__Point::size_of() const
{
  int ret_val = 1;
  if (field_iE__Extensions.ispresent()) ret_val++;
  return ret_val;
}

void GA__Point::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ geographicalCoordinates := ");
field_geographicalCoordinates.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
field_iE__Extensions.log();
TTCN_Logger::log_event_str(" }");
}

void GA__Point::set_implicit_omit()
{
if (geographicalCoordinates().is_bound()) geographicalCoordinates().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
}

void GA__Point::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RANAP-IEs.GA-Point has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) geographicalCoordinates().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalCoordinates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalCoordinates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.GA-Point: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-IEs.GA-Point");
  }
}

void GA__Point::encode_text(Text_Buf& text_buf) const
{
field_geographicalCoordinates.encode_text(text_buf);
field_iE__Extensions.encode_text(text_buf);
}

void GA__Point::decode_text(Text_Buf& text_buf)
{
field_geographicalCoordinates.decode_text(text_buf);
field_iE__Extensions.decode_text(text_buf);
}

void GA__Point::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GA__Point::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* GA__Point::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("geographicalCoordinates': ");
  new_tlv->add_TLV(field_geographicalCoordinates.BER_encode_TLV(GA__Point_geographicalCoordinates_descr_, p_coding));
  ec_1.set_msg("iE_Extensions': ");
  new_tlv->add_TLV(field_iE__Extensions.BER_encode_TLV(GA__Point_iE__Extensions_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean GA__Point::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-IEs.GA-Point' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("geographicalCoordinates': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_geographicalCoordinates.BER_decode_TLV(GA__Point_geographicalCoordinates_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("iE_Extensions': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_iE__Extensions=OMIT_VALUE;
    else {
      field_iE__Extensions.BER_decode_TLV(GA__Point_iE__Extensions_descr_, tmp_tlv, L_form);
      if(field_iE__Extensions.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int GA__Point::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.GA-Point.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "geographicalCoordinates");
    enc_len += field_geographicalCoordinates.JSON_encode(GA__Point_geographicalCoordinates_descr_, p_tok, FALSE);
  }

  if (field_iE__Extensions.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "iE_Extensions");
    enc_len += field_iE__Extensions.JSON_encode(GA__Point_iE__Extensions_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int GA__Point::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const GA__Point*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean geographicalCoordinates_found = FALSE;
  boolean iE__Extensions_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (23 == name_len && 0 == strncmp(fld_name, "geographicalCoordinates", name_len)) {
        geographicalCoordinates_found = TRUE;
         int ret_val = field_geographicalCoordinates.JSON_decode(GA__Point_geographicalCoordinates_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "geographicalCoordinates");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "iE_Extensions", name_len)) {
        iE__Extensions_found = TRUE;
         int ret_val = field_iE__Extensions.JSON_decode(GA__Point_iE__Extensions_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "iE_Extensions");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!geographicalCoordinates_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "geographicalCoordinates");
    return JSON_ERROR_FATAL;
  }
  if (!iE__Extensions_found) {
    field_iE__Extensions = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int GA__Point::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_iE__Extensions.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_geographicalCoordinates.OER_encode(GA__Point_geographicalCoordinates_descr_, p_buf);
  if (field_iE__Extensions.is_present())
    field_iE__Extensions.OER_encode(GA__Point_iE__Extensions_descr_, p_buf);
  return 0;
}

int GA__Point::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_geographicalCoordinates.OER_decode(GA__Point_geographicalCoordinates_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_iE__Extensions.OER_decode(GA__Point_iE__Extensions_descr_, p_buf, p_oer);
 else
    field_iE__Extensions = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void GA__Point::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_iE__Extensions_present = field_iE__Extensions.is_present();
p_buf.PER_put_bit(field_iE__Extensions_present);
field_geographicalCoordinates.PER_encode(GA__Point_geographicalCoordinates_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_encode(GA__Point_iE__Extensions_descr_, p_buf, p_options);
}

void GA__Point::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_iE__Extensions_present = p_buf.PER_get_bit();
field_geographicalCoordinates.PER_decode(GA__Point_geographicalCoordinates_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_decode(GA__Point_iE__Extensions_descr_, p_buf, p_options);
else field_iE__Extensions = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct GA__Point_template::single_value_struct {
GeographicalCoordinates_template field_geographicalCoordinates;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template field_iE__Extensions;
};

void GA__Point_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_geographicalCoordinates = ANY_VALUE;
single_value->field_iE__Extensions = ANY_OR_OMIT;
}
}
}

void GA__Point_template::copy_value(const GA__Point& other_value)
{
single_value = new single_value_struct;
if (other_value.geographicalCoordinates().is_bound()) {
  single_value->field_geographicalCoordinates = other_value.geographicalCoordinates();
} else {
  single_value->field_geographicalCoordinates.clean_up();
}
if (other_value.iE__Extensions().is_bound()) {
  if (other_value.iE__Extensions().ispresent()) single_value->field_iE__Extensions = other_value.iE__Extensions()();
  else single_value->field_iE__Extensions = OMIT_VALUE;
} else {
  single_value->field_iE__Extensions.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GA__Point_template::copy_template(const GA__Point_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.geographicalCoordinates().get_selection()) {
single_value->field_geographicalCoordinates = other_value.geographicalCoordinates();
} else {
single_value->field_geographicalCoordinates.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iE__Extensions().get_selection()) {
single_value->field_iE__Extensions = other_value.iE__Extensions();
} else {
single_value->field_iE__Extensions.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GA__Point_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GA__Point_template(*other_value.implication_.precondition);
implication_.implied_template = new GA__Point_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.GA-Point.");
break;
}
set_selection(other_value);
}

GA__Point_template::GA__Point_template()
{
}

GA__Point_template::GA__Point_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GA__Point_template::GA__Point_template(const GA__Point& other_value)
{
copy_value(other_value);
}

GA__Point_template::GA__Point_template(const OPTIONAL<GA__Point>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GA__Point&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.GA-Point from an unbound optional field.");
}
}

GA__Point_template::GA__Point_template(GA__Point_template* p_precondition, GA__Point_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GA__Point_template::GA__Point_template(Dynamic_Match_Interface<GA__Point>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GA__Point>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GA__Point_template::GA__Point_template(const GA__Point_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GA__Point_template::~GA__Point_template()
{
clean_up();
}

GA__Point_template& GA__Point_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GA__Point_template& GA__Point_template::operator=(const GA__Point& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GA__Point_template& GA__Point_template::operator=(const OPTIONAL<GA__Point>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GA__Point&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.GA-Point.");
}
return *this;
}

GA__Point_template& GA__Point_template::operator=(const GA__Point_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GA__Point_template::match(const GA__Point& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.geographicalCoordinates().is_bound()) return FALSE;
if(!single_value->field_geographicalCoordinates.match(other_value.geographicalCoordinates(), legacy))return FALSE;
if(!other_value.iE__Extensions().is_bound()) return FALSE;
if((other_value.iE__Extensions().ispresent() ? !single_value->field_iE__Extensions.match((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21&)other_value.iE__Extensions(), legacy) : !single_value->field_iE__Extensions.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-IEs.GA-Point.");
}
return FALSE;
}

boolean GA__Point_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_geographicalCoordinates.is_bound()
 || (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_bound());
}

boolean GA__Point_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_geographicalCoordinates.is_value()
 && (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_value());
}

void GA__Point_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GA__Point GA__Point_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.GA-Point.");
GA__Point ret_val;
if (single_value->field_geographicalCoordinates.is_bound()) {
ret_val.geographicalCoordinates() = single_value->field_geographicalCoordinates.valueof();
}
if (single_value->field_iE__Extensions.is_omit()) ret_val.iE__Extensions() = OMIT_VALUE;
else if (single_value->field_iE__Extensions.is_bound()) {
ret_val.iE__Extensions() = single_value->field_iE__Extensions.valueof();
}
return ret_val;
}

void GA__Point_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-IEs.GA-Point.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GA__Point_template[list_length];
}

GA__Point_template& GA__Point_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-IEs.GA-Point.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-IEs.GA-Point.");
return value_list.list_value[list_index];
}

GeographicalCoordinates_template& GA__Point_template::geographicalCoordinates()
{
set_specific();
return single_value->field_geographicalCoordinates;
}

const GeographicalCoordinates_template& GA__Point_template::geographicalCoordinates() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field geographicalCoordinates of a non-specific template of type @RANAP-IEs.GA-Point.");
return single_value->field_geographicalCoordinates;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& GA__Point_template::iE__Extensions()
{
set_specific();
return single_value->field_iE__Extensions;
}

const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& GA__Point_template::iE__Extensions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iE_Extensions of a non-specific template of type @RANAP-IEs.GA-Point.");
return single_value->field_iE__Extensions;
}

int GA__Point_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_iE__Extensions.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-Point containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-IEs.GA-Point.");
  }
  return 0;
}

void GA__Point_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ geographicalCoordinates := ");
single_value->field_geographicalCoordinates.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GA__Point_template::log_match(const GA__Point& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_geographicalCoordinates.match(match_value.geographicalCoordinates(), legacy)){
TTCN_Logger::log_logmatch_info(".geographicalCoordinates");
single_value->field_geographicalCoordinates.log_match(match_value.geographicalCoordinates(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.iE__Extensions().ispresent()){
if(!single_value->field_iE__Extensions.match(match_value.iE__Extensions(), legacy)){
TTCN_Logger::log_logmatch_info(".iE_Extensions");
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_iE__Extensions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".iE_Extensions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ geographicalCoordinates := ");
single_value->field_geographicalCoordinates.log_match(match_value.geographicalCoordinates(), legacy);
TTCN_Logger::log_event_str(", iE_Extensions := ");
if (match_value.iE__Extensions().ispresent()) {
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_iE__Extensions.log();
if (single_value->field_iE__Extensions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GA__Point_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (geographicalCoordinates().is_bound()) geographicalCoordinates().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
}

void GA__Point_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_geographicalCoordinates.encode_text(text_buf);
single_value->field_iE__Extensions.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.GA-Point.");
}
}

void GA__Point_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_geographicalCoordinates.decode_text(text_buf);
single_value->field_iE__Extensions.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GA__Point_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-IEs.GA-Point.");
}
}

void GA__Point_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GA__Point_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RANAP-IEs.GA-Point has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) geographicalCoordinates().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalCoordinates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalCoordinates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.GA-Point: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GA__Point_template* precondition = new GA__Point_template;
    precondition->set_param(*param.get_elem(0));
    GA__Point_template* implied_template = new GA__Point_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GA__Point_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-IEs.GA-Point");
  }
  is_ifpresent = param.get_ifpresent();
}

void GA__Point_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_geographicalCoordinates.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GA-Point");
single_value->field_iE__Extensions.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GA-Point");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.GA-Point");
}

boolean GA__Point_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GA__Point_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::UNBOUND_ELEM;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21()
{
val_ptr = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return val_ptr->n_elements == 0 ;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator==(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21;
}
return *val_ptr->value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return (*this)[(int)index_value];
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::operator+(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return val_ptr->n_elements;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    new_tlv=ASN_BER_TLV_t::construct(NULL);
    TTCN_EncDec_ErrorContext ec;
    for(int elem_i=0; elem_i<val_ptr->n_elements; elem_i++) {
      ec.set_msg("Component #%d: ", elem_i);
      new_tlv->add_TLV((*this)[elem_i].BER_encode_TLV(*p_td.oftype_descr, p_coding));
    }
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '%s' type: ", p_td.name);
  stripped_tlv.chk_constructed_flag(TRUE);
  clean_up();
  val_ptr = new recordof_setof_struct;
  val_ptr->ref_count = 1;
  val_ptr->n_elements = 0;
  val_ptr->value_elements = NULL;
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  TTCN_EncDec_ErrorContext ec_1("Component #");
  TTCN_EncDec_ErrorContext ec_2("0: ");
  while(BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv)) {
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->n_elements++;
    val_ptr->value_elements[val_ptr->n_elements - 1] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21;
    val_ptr->value_elements[val_ptr->n_elements - 1]->BER_decode_TLV(*p_td.oftype_descr, tmp_tlv, L_form);
    ec_2.set_msg("%d: ", val_ptr->n_elements);
  }
  return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_START : JSON_TOKEN_ARRAY_START, NULL);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    if (p_td.json->metainfo_unbound && !(*this)[i].is_bound()) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "metainfo []");
      enc_len += p_tok.put_next_token(JSON_TOKEN_STRING, "\"unbound\"");
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
    }
    else {
      int ret_val = (*this)[i].JSON_encode(*p_td.oftype_descr, p_tok, p_td.json->as_map);
      if (0 > ret_val) break;
      enc_len += ret_val;
    }
  }
  enc_len += p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_END : JSON_TOKEN_ARRAY_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    set_size(0);
    return strlen(p_td.json->default_value.str);
  }
  json_token_t token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&token, NULL, NULL);
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_START != token) ||
           (p_td.json->as_map && JSON_TOKEN_OBJECT_START != token)) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  set_size(0);
  for (int nof_elements = 0; TRUE; ++nof_elements) {
    size_t buf_pos = p_tok.get_buf_pos();
    size_t ret_val;
    if (p_td.json->metainfo_unbound) {
      ret_val = p_tok.get_next_token(&token, NULL, NULL);
      if (JSON_TOKEN_OBJECT_START == token) {
        char* value = NULL;
        size_t value_len = 0;
        ret_val += p_tok.get_next_token(&token, &value, &value_len);
        if (JSON_TOKEN_NAME == token && 11 == value_len &&
            0 == strncmp(value, "metainfo []", 11)) {
          ret_val += p_tok.get_next_token(&token, &value, &value_len);
          if (JSON_TOKEN_STRING == token && 9 == value_len &&
              0 == strncmp(value, "\"unbound\"", 9)) {
            ret_val = p_tok.get_next_token(&token, NULL, NULL);
            if (JSON_TOKEN_OBJECT_END == token) {
              dec_len += ret_val;
              continue;
            }
          }
        }
      }
      p_tok.set_buf_pos(buf_pos);
    }
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21* val = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21;
    int ret_val2 = val->JSON_decode(*p_td.oftype_descr, p_tok, p_silent, p_td.json->as_map);
    if (JSON_ERROR_INVALID_TOKEN == ret_val2) {
      p_tok.set_buf_pos(buf_pos);
      delete val;
      break;
    }
    else if (JSON_ERROR_FATAL == ret_val2) {
      delete val;
      if (p_silent) {
        clean_up();
      }
      return JSON_ERROR_FATAL;
    }
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21**)reallocate_pointers(
      (void**)val_ptr->value_elements, val_ptr->n_elements, nof_elements + 1);
    val_ptr->value_elements[nof_elements] = val;
    val_ptr->n_elements = nof_elements + 1;
    dec_len += (size_t)ret_val2;
  }

  dec_len += p_tok.get_next_token(&token, NULL, NULL);
  if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_END != token) ||
      (p_td.json->as_map && JSON_TOKEN_OBJECT_END != token)) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_REC_OF_END_TOKEN_ERROR, "");
    if (p_silent) {
      clean_up();
    }
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::OER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
    return -1;
  }

  encode_oer_length(val_ptr->n_elements, p_buf, TRUE);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    (*this)[i].OER_encode(*p_td.oftype_descr, p_buf);
  }
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::OER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t nof_elem = decode_oer_length(p_buf, TRUE);
  set_size(nof_elem);
  for (size_t i = 0; i < nof_elem; i++) {
    (*this)[i].OER_decode(*p_td.oftype_descr, p_buf, p_oer);
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
"Encoding an unbound SEQUENCE OF value.");
return;
}
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
INTEGER length(val_ptr->n_elements);
boolean extendable = cons->has_extension_marker();
boolean within_ext_root = cons->is_within_extension_root(length);
if (!within_ext_root && !extendable) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT,
"Encoding an invalid SEQUENCE OF value (does not match PER-visible constraints).");
return;
}
boolean ext_bit = extendable && !within_ext_root;
if (extendable) p_buf.PER_put_bit(ext_bit);
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
if (range == 1 && length == 0) return;
int mul_16k;
int pos = 0;
do {
mul_16k = (range == 1) ? 0 : length.PER_encode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
int elements_encoded = (mul_16k == 0) ? (int)length : mul_16k * PER_16K;
for (int i = 0; i < elements_encoded; ++i) {
(*this)[i + pos].PER_encode(*p_td.oftype_descr, p_buf, p_options);
}
if (mul_16k > 0) {
pos += elements_encoded;
length = length - elements_encoded;
range = 0;
}
}
while (mul_16k > 0);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
clean_up();
boolean extendable = cons->has_extension_marker();
boolean ext_bit = extendable ? p_buf.PER_get_bit() : FALSE;
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
int mul_16k;
INTEGER length;
int current_size = 0;
do {
mul_16k = length.PER_decode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
if (mul_16k != 0) range = 0;
int new_size = current_size + (int)length;
set_size(new_size);
for (int i = current_size; i < new_size; ++i) {
(*this)[i].PER_decode(*p_td.oftype_descr, p_buf, p_options);
}
current_size = new_size;
}
while (mul_16k > 0);
if (!ext_bit && !cons->is_within_extension_root(val_ptr->n_elements)) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT, "Decoded SEQUENCE OF value does not match PER-visible constraints.");
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
break;
}
set_selection(other_value);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21*)value_ptr)[value_index], legacy);
else return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template()
{
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
    break;
}
return *single_value.value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return (*this)[(int)index_value];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21 containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
}
set_selection(template_type);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
return value_list.list_value[list_index];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::log_match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template* precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst21");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst21_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value)
{
switch (other_value.union_selection) {
default:
TTCN_error("Assignment of an unbound union value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
union_selection = other_value.union_selection;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type()
{
union_selection = UNBOUND_VALUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value)
: Base_Type(){
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
default:
return FALSE;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
return union_selection == checked_selection;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
default: TTCN_error("Invalid selection in union is_bound");}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::clean_up()
{
switch (union_selection) {
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::log() const
{
switch (union_selection) {
default:
TTCN_Logger::log_event_unbound();
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.", last_name);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::set_implicit_omit()
{
switch (union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type' type: ");
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tlv_opentype)) {
    tlv_opentype.Tlen = 0;
    return FALSE;
  }
  clean_up();
  union_selection = UNBOUND_VALUE;
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean) const
{
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
    "Cannot encode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type, because it has zero alternatives.");
  return -1;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, 
    "Cannot decode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type, because it has zero alternatives.");
  return JSON_ERROR_FATAL;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
    return -1;
  }

  return 0;
}
int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t pos = decode_oer_length(p_buf, FALSE);
  size_t prev_pos = p_buf.get_pos();
  p_buf.increase_pos(pos);
  p_oer.opentype_poses.push_back(prev_pos);
  return 0;
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
default:
TTCN_error("Initializing a template with an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& other_value)
: Base_Template(){
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::union_selection_type value_selection = other_value.get_selection();
if (value_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type ret_val;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
return value_list.list_value[list_index];
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template[list_length];
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::ischosen(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::union_selection_type checked_selection) const
{
if (checked_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
switch (single_value.union_selection) {
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::UNBOUND_VALUE;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::union_selection_type new_selection = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type'");
    }
    param.error("Field `%s' not found in union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template;
    precondition->set_param(*m_p->get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.extensionValue.type");
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(const INTEGER& par_id,
    const RANAP__CommonDataTypes::Criticality& par_criticality,
    const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type& par_extensionValue)
  :   field_id(par_id),
  field_criticality(par_criticality),
  field_extensionValue(par_extensionValue)
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
if (other_value.id().is_bound()) field_id = other_value.id();
else field_id.clean_up();
if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
else field_criticality.clean_up();
if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
else field_extensionValue.clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::clean_up()
{
field_id.clean_up();
field_criticality.clean_up();
field_extensionValue.clean_up();
}

const TTCN_Typedescriptor_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::get_descriptor() const { return &_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_descr_; }
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
  if (other_value.id().is_bound()) field_id = other_value.id();
  else field_id.clean_up();
  if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
  else field_criticality.clean_up();
  if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
  else field_extensionValue.clean_up();
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value) const
{
return field_id==other_value.field_id
  && field_criticality==other_value.field_criticality
  && field_extensionValue==other_value.field_extensionValue;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::is_bound() const
{
return (field_id.is_bound())
  || (field_criticality.is_bound())
  || (field_extensionValue.is_bound());
}
boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::is_value() const
{
return field_id.is_value()
  && field_criticality.is_value()
  && field_extensionValue.is_value();
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ id := ");
field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::set_implicit_omit()
{
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21");
  }
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::encode_text(Text_Buf& text_buf) const
{
field_id.encode_text(text_buf);
field_criticality.encode_text(text_buf);
field_extensionValue.encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::decode_text(Text_Buf& text_buf)
{
field_id.decode_text(text_buf);
field_criticality.decode_text(text_buf);
field_extensionValue.decode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  new_tlv->add_TLV(field_id.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_coding));
  ec_1.set_msg("criticality': ");
  new_tlv->add_TLV(field_criticality.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_coding));
  ec_1.set_msg("extensionValue': ");
  new_tlv->add_TLV(field_extensionValue.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("id': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_id.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("criticality': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_criticality.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionValue': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_extensionValue.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");
  TTCN_Type_list p_typelist;
  BER_decode_opentypes(p_typelist, L_form);
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("criticality': ");
  field_criticality.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.BER_decode_opentypes(p_typelist, L_form);
  p_typelist.pop();
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "id");
    enc_len += field_id.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "criticality");
    enc_len += field_criticality.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionValue");
    enc_len += field_extensionValue.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean id_found = FALSE;
  boolean criticality_found = FALSE;
  boolean extensionValue_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (2 == name_len && 0 == strncmp(fld_name, "id", name_len)) {
        id_found = TRUE;
         int ret_val = field_id.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "id");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "criticality", name_len)) {
        criticality_found = TRUE;
         int ret_val = field_criticality.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "criticality");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "extensionValue", name_len)) {
        extensionValue_found = TRUE;
         int ret_val = field_extensionValue.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "extensionValue");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!id_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "id");
    return JSON_ERROR_FATAL;
  }
  if (!criticality_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "criticality");
    return JSON_ERROR_FATAL;
  }
  if (!extensionValue_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "extensionValue");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  field_id.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_buf);
  field_criticality.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_buf);
  field_extensionValue.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_buf);
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  field_id.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_buf, p_oer);
  field_criticality.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_buf, p_oer);
  field_extensionValue.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_buf, p_oer);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");  TTCN_Type_list p_typelist;
  OER_decode_opentypes(p_typelist, p_buf, p_oer);
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("criticality': ");
  field_criticality.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  p_typelist.pop();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
field_id.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_buf, p_options);
field_criticality.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_buf, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
field_id.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_id_descr_, p_buf, p_options);
field_criticality.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_descr_, p_buf, p_options);
TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");TTCN_Type_list p_typelist;
PER_decode_opentypes(p_typelist, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21::PER_decode_opentypes(TTCN_Type_list& p_typelist, int p_options)
{
p_typelist.push(this);
TTCN_EncDec_ErrorContext ec_0("Component '");
TTCN_EncDec_ErrorContext ec_1;
ec_1.set_msg("id': ");
field_id.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("criticality': ");
field_criticality.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("extensionValue': ");
field_extensionValue.PER_decode_opentypes(p_typelist, p_options);
p_typelist.pop();
}

struct _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::single_value_struct {
INTEGER_template field_id;
RANAP__CommonDataTypes::Criticality_template field_criticality;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template field_extensionValue;
};

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_id = ANY_VALUE;
single_value->field_criticality = ANY_VALUE;
single_value->field_extensionValue = ANY_VALUE;
}
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value)
{
single_value = new single_value_struct;
if (other_value.id().is_bound()) {
  single_value->field_id = other_value.id();
} else {
  single_value->field_id.clean_up();
}
if (other_value.criticality().is_bound()) {
  single_value->field_criticality = other_value.criticality();
} else {
  single_value->field_criticality.clean_up();
}
if (other_value.extensionValue().is_bound()) {
  single_value->field_extensionValue = other_value.extensionValue();
} else {
  single_value->field_extensionValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.id().get_selection()) {
single_value->field_id = other_value.id();
} else {
single_value->field_id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.criticality().get_selection()) {
single_value->field_criticality = other_value.criticality();
} else {
single_value->field_criticality.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionValue().get_selection()) {
single_value->field_extensionValue = other_value.extensionValue();
} else {
single_value->field_extensionValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
break;
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.id().is_bound()) return FALSE;
if(!single_value->field_id.match(other_value.id(), legacy))return FALSE;
if(!other_value.criticality().is_bound()) return FALSE;
if(!single_value->field_criticality.match(other_value.criticality(), legacy))return FALSE;
if(!other_value.extensionValue().is_bound()) return FALSE;
if(!single_value->field_extensionValue.match(other_value.extensionValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_id.is_bound()
 || single_value->field_criticality.is_bound()
 || single_value->field_extensionValue.is_bound();
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_id.is_value()
 && single_value->field_criticality.is_value()
 && single_value->field_extensionValue.is_value();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21 _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21 ret_val;
if (single_value->field_id.is_bound()) {
ret_val.id() = single_value->field_id.valueof();
}
if (single_value->field_criticality.is_bound()) {
ret_val.criticality() = single_value->field_criticality.valueof();
}
if (single_value->field_extensionValue.is_bound()) {
ret_val.extensionValue() = single_value->field_extensionValue.valueof();
}
return ret_val;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template[list_length];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
return value_list.list_value[list_index];
}

INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::id()
{
set_specific();
return single_value->field_id;
}

const INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
return single_value->field_id;
}

RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::criticality()
{
set_specific();
return single_value->field_criticality;
}

const RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::criticality() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field criticality of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
return single_value->field_criticality;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::extensionValue()
{
set_specific();
return single_value->field_extensionValue;
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::extensionValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionValue of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
return single_value->field_extensionValue;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_id.match(match_value.id(), legacy)){
TTCN_Logger::log_logmatch_info(".id");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_criticality.match(match_value.criticality(), legacy)){
TTCN_Logger::log_logmatch_info(".criticality");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_extensionValue.match(match_value.extensionValue(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionValue");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_id.encode_text(text_buf);
single_value->field_criticality.encode_text(text_buf);
single_value->field_extensionValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_id.decode_text(text_buf);
single_value->field_criticality.decode_text(text_buf);
single_value->field_extensionValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_id.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21");
single_value->field_criticality.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21");
single_value->field_extensionValue.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst21");
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst21_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

GA__PointWithUnCertainty::GA__PointWithUnCertainty()
{
}

GA__PointWithUnCertainty::GA__PointWithUnCertainty(const GeographicalCoordinates& par_geographicalCoordinates,
    const OPTIONAL< _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 >& par_iE__Extensions,
    const INTEGER& par_uncertaintyCode)
  :   field_geographicalCoordinates(par_geographicalCoordinates),
  field_iE__Extensions(par_iE__Extensions),
  field_uncertaintyCode(par_uncertaintyCode)
{
}

GA__PointWithUnCertainty::GA__PointWithUnCertainty(const GA__PointWithUnCertainty& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.GA-PointWithUnCertainty.");
if (other_value.geographicalCoordinates().is_bound()) field_geographicalCoordinates = other_value.geographicalCoordinates();
else field_geographicalCoordinates.clean_up();
if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
else field_iE__Extensions.clean_up();
if (other_value.uncertaintyCode().is_bound()) field_uncertaintyCode = other_value.uncertaintyCode();
else field_uncertaintyCode.clean_up();
}

void GA__PointWithUnCertainty::clean_up()
{
field_geographicalCoordinates.clean_up();
field_iE__Extensions.clean_up();
field_uncertaintyCode.clean_up();
}

const TTCN_Typedescriptor_t* GA__PointWithUnCertainty::get_descriptor() const { return &GA__PointWithUnCertainty_descr_; }
GA__PointWithUnCertainty& GA__PointWithUnCertainty::operator=(const GA__PointWithUnCertainty& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-IEs.GA-PointWithUnCertainty.");
  if (other_value.geographicalCoordinates().is_bound()) field_geographicalCoordinates = other_value.geographicalCoordinates();
  else field_geographicalCoordinates.clean_up();
  if (other_value.iE__Extensions().is_bound()) field_iE__Extensions = other_value.iE__Extensions();
  else field_iE__Extensions.clean_up();
  if (other_value.uncertaintyCode().is_bound()) field_uncertaintyCode = other_value.uncertaintyCode();
  else field_uncertaintyCode.clean_up();
}
return *this;
}

boolean GA__PointWithUnCertainty::operator==(const GA__PointWithUnCertainty& other_value) const
{
return field_geographicalCoordinates==other_value.field_geographicalCoordinates
  && field_iE__Extensions==other_value.field_iE__Extensions
  && field_uncertaintyCode==other_value.field_uncertaintyCode;
}

boolean GA__PointWithUnCertainty::is_bound() const
{
return (field_geographicalCoordinates.is_bound())
  || (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_bound())
  || (field_uncertaintyCode.is_bound());
}
boolean GA__PointWithUnCertainty::is_value() const
{
return field_geographicalCoordinates.is_value()
  && (OPTIONAL_OMIT == field_iE__Extensions.get_selection() || field_iE__Extensions.is_value())
  && field_uncertaintyCode.is_value();
}
int GA__PointWithUnCertainty::size_of() const
{
  int ret_val = 2;
  if (field_iE__Extensions.ispresent()) ret_val++;
  return ret_val;
}

void GA__PointWithUnCertainty::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ geographicalCoordinates := ");
field_geographicalCoordinates.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
field_iE__Extensions.log();
TTCN_Logger::log_event_str(", uncertaintyCode := ");
field_uncertaintyCode.log();
TTCN_Logger::log_event_str(" }");
}

void GA__PointWithUnCertainty::set_implicit_omit()
{
if (geographicalCoordinates().is_bound()) geographicalCoordinates().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
if (uncertaintyCode().is_bound()) uncertaintyCode().set_implicit_omit();
}

void GA__PointWithUnCertainty::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RANAP-IEs.GA-PointWithUnCertainty has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) geographicalCoordinates().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) uncertaintyCode().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalCoordinates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalCoordinates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uncertaintyCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uncertaintyCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.GA-PointWithUnCertainty: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-IEs.GA-PointWithUnCertainty");
  }
}

void GA__PointWithUnCertainty::encode_text(Text_Buf& text_buf) const
{
field_geographicalCoordinates.encode_text(text_buf);
field_iE__Extensions.encode_text(text_buf);
field_uncertaintyCode.encode_text(text_buf);
}

void GA__PointWithUnCertainty::decode_text(Text_Buf& text_buf)
{
field_geographicalCoordinates.decode_text(text_buf);
field_iE__Extensions.decode_text(text_buf);
field_uncertaintyCode.decode_text(text_buf);
}

void GA__PointWithUnCertainty::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GA__PointWithUnCertainty::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* GA__PointWithUnCertainty::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("geographicalCoordinates': ");
  new_tlv->add_TLV(field_geographicalCoordinates.BER_encode_TLV(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_coding));
  ec_1.set_msg("iE_Extensions': ");
  new_tlv->add_TLV(field_iE__Extensions.BER_encode_TLV(GA__PointWithUnCertainty_iE__Extensions_descr_, p_coding));
  ec_1.set_msg("uncertaintyCode': ");
  new_tlv->add_TLV(field_uncertaintyCode.BER_encode_TLV(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean GA__PointWithUnCertainty::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-IEs.GA-PointWithUnCertainty' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("geographicalCoordinates': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_geographicalCoordinates.BER_decode_TLV(GA__PointWithUnCertainty_geographicalCoordinates_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("iE_Extensions': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_iE__Extensions=OMIT_VALUE;
    else {
      field_iE__Extensions.BER_decode_TLV(GA__PointWithUnCertainty_iE__Extensions_descr_, tmp_tlv, L_form);
      if(field_iE__Extensions.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("uncertaintyCode': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_uncertaintyCode.BER_decode_TLV(GA__PointWithUnCertainty_uncertaintyCode_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int GA__PointWithUnCertainty::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.GA-PointWithUnCertainty.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "geographicalCoordinates");
    enc_len += field_geographicalCoordinates.JSON_encode(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_tok, FALSE);
  }

  if (field_iE__Extensions.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "iE_Extensions");
    enc_len += field_iE__Extensions.JSON_encode(GA__PointWithUnCertainty_iE__Extensions_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "uncertaintyCode");
    enc_len += field_uncertaintyCode.JSON_encode(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int GA__PointWithUnCertainty::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const GA__PointWithUnCertainty*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean geographicalCoordinates_found = FALSE;
  boolean iE__Extensions_found = FALSE;
  boolean uncertaintyCode_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (23 == name_len && 0 == strncmp(fld_name, "geographicalCoordinates", name_len)) {
        geographicalCoordinates_found = TRUE;
         int ret_val = field_geographicalCoordinates.JSON_decode(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "geographicalCoordinates");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (13 == name_len && 0 == strncmp(fld_name, "iE_Extensions", name_len)) {
        iE__Extensions_found = TRUE;
         int ret_val = field_iE__Extensions.JSON_decode(GA__PointWithUnCertainty_iE__Extensions_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "iE_Extensions");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "uncertaintyCode", name_len)) {
        uncertaintyCode_found = TRUE;
         int ret_val = field_uncertaintyCode.JSON_decode(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "uncertaintyCode");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!geographicalCoordinates_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "geographicalCoordinates");
    return JSON_ERROR_FATAL;
  }
  if (!iE__Extensions_found) {
    field_iE__Extensions = OMIT_VALUE;
  }
  if (!uncertaintyCode_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "uncertaintyCode");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int GA__PointWithUnCertainty::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_iE__Extensions.is_present()) {
    c |= 128;
  }
  p_buf.put_c(c);
  field_geographicalCoordinates.OER_encode(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_buf);
  if (field_iE__Extensions.is_present())
    field_iE__Extensions.OER_encode(GA__PointWithUnCertainty_iE__Extensions_descr_, p_buf);
  field_uncertaintyCode.OER_encode(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_buf);
  return 0;
}

int GA__PointWithUnCertainty::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  field_geographicalCoordinates.OER_decode(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_buf, p_oer);
  if (uc[0] & 128)
    field_iE__Extensions.OER_decode(GA__PointWithUnCertainty_iE__Extensions_descr_, p_buf, p_oer);
 else
    field_iE__Extensions = OMIT_VALUE;
  field_uncertaintyCode.OER_decode(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_buf, p_oer);
  return 0;
}

void GA__PointWithUnCertainty::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_iE__Extensions_present = field_iE__Extensions.is_present();
p_buf.PER_put_bit(field_iE__Extensions_present);
field_geographicalCoordinates.PER_encode(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_encode(GA__PointWithUnCertainty_iE__Extensions_descr_, p_buf, p_options);
field_uncertaintyCode.PER_encode(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_buf, p_options);
}

void GA__PointWithUnCertainty::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_iE__Extensions_present = p_buf.PER_get_bit();
field_geographicalCoordinates.PER_decode(GA__PointWithUnCertainty_geographicalCoordinates_descr_, p_buf, p_options);
if (field_iE__Extensions_present) field_iE__Extensions.PER_decode(GA__PointWithUnCertainty_iE__Extensions_descr_, p_buf, p_options);
else field_iE__Extensions = OMIT_VALUE;
field_uncertaintyCode.PER_decode(GA__PointWithUnCertainty_uncertaintyCode_descr_, p_buf, p_options);
}

struct GA__PointWithUnCertainty_template::single_value_struct {
GeographicalCoordinates_template field_geographicalCoordinates;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template field_iE__Extensions;
INTEGER_template field_uncertaintyCode;
};

void GA__PointWithUnCertainty_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_geographicalCoordinates = ANY_VALUE;
single_value->field_iE__Extensions = ANY_OR_OMIT;
single_value->field_uncertaintyCode = ANY_VALUE;
}
}
}

void GA__PointWithUnCertainty_template::copy_value(const GA__PointWithUnCertainty& other_value)
{
single_value = new single_value_struct;
if (other_value.geographicalCoordinates().is_bound()) {
  single_value->field_geographicalCoordinates = other_value.geographicalCoordinates();
} else {
  single_value->field_geographicalCoordinates.clean_up();
}
if (other_value.iE__Extensions().is_bound()) {
  if (other_value.iE__Extensions().ispresent()) single_value->field_iE__Extensions = other_value.iE__Extensions()();
  else single_value->field_iE__Extensions = OMIT_VALUE;
} else {
  single_value->field_iE__Extensions.clean_up();
}
if (other_value.uncertaintyCode().is_bound()) {
  single_value->field_uncertaintyCode = other_value.uncertaintyCode();
} else {
  single_value->field_uncertaintyCode.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GA__PointWithUnCertainty_template::copy_template(const GA__PointWithUnCertainty_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.geographicalCoordinates().get_selection()) {
single_value->field_geographicalCoordinates = other_value.geographicalCoordinates();
} else {
single_value->field_geographicalCoordinates.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iE__Extensions().get_selection()) {
single_value->field_iE__Extensions = other_value.iE__Extensions();
} else {
single_value->field_iE__Extensions.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.uncertaintyCode().get_selection()) {
single_value->field_uncertaintyCode = other_value.uncertaintyCode();
} else {
single_value->field_uncertaintyCode.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GA__PointWithUnCertainty_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GA__PointWithUnCertainty_template(*other_value.implication_.precondition);
implication_.implied_template = new GA__PointWithUnCertainty_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.GA-PointWithUnCertainty.");
break;
}
set_selection(other_value);
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template()
{
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template(const GA__PointWithUnCertainty& other_value)
{
copy_value(other_value);
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template(const OPTIONAL<GA__PointWithUnCertainty>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GA__PointWithUnCertainty&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.GA-PointWithUnCertainty from an unbound optional field.");
}
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template(GA__PointWithUnCertainty_template* p_precondition, GA__PointWithUnCertainty_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template(Dynamic_Match_Interface<GA__PointWithUnCertainty>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GA__PointWithUnCertainty>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GA__PointWithUnCertainty_template::GA__PointWithUnCertainty_template(const GA__PointWithUnCertainty_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GA__PointWithUnCertainty_template::~GA__PointWithUnCertainty_template()
{
clean_up();
}

GA__PointWithUnCertainty_template& GA__PointWithUnCertainty_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GA__PointWithUnCertainty_template& GA__PointWithUnCertainty_template::operator=(const GA__PointWithUnCertainty& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GA__PointWithUnCertainty_template& GA__PointWithUnCertainty_template::operator=(const OPTIONAL<GA__PointWithUnCertainty>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GA__PointWithUnCertainty&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.GA-PointWithUnCertainty.");
}
return *this;
}

GA__PointWithUnCertainty_template& GA__PointWithUnCertainty_template::operator=(const GA__PointWithUnCertainty_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GA__PointWithUnCertainty_template::match(const GA__PointWithUnCertainty& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.geographicalCoordinates().is_bound()) return FALSE;
if(!single_value->field_geographicalCoordinates.match(other_value.geographicalCoordinates(), legacy))return FALSE;
if(!other_value.iE__Extensions().is_bound()) return FALSE;
if((other_value.iE__Extensions().ispresent() ? !single_value->field_iE__Extensions.match((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22&)other_value.iE__Extensions(), legacy) : !single_value->field_iE__Extensions.match_omit(legacy)))return FALSE;
if(!other_value.uncertaintyCode().is_bound()) return FALSE;
if(!single_value->field_uncertaintyCode.match(other_value.uncertaintyCode(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-IEs.GA-PointWithUnCertainty.");
}
return FALSE;
}

boolean GA__PointWithUnCertainty_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_geographicalCoordinates.is_bound()
 || (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_bound())
 || single_value->field_uncertaintyCode.is_bound();
}

boolean GA__PointWithUnCertainty_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_geographicalCoordinates.is_value()
 && (single_value->field_iE__Extensions.is_omit() || single_value->field_iE__Extensions.is_value())
 && single_value->field_uncertaintyCode.is_value();
}

void GA__PointWithUnCertainty_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GA__PointWithUnCertainty GA__PointWithUnCertainty_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.GA-PointWithUnCertainty.");
GA__PointWithUnCertainty ret_val;
if (single_value->field_geographicalCoordinates.is_bound()) {
ret_val.geographicalCoordinates() = single_value->field_geographicalCoordinates.valueof();
}
if (single_value->field_iE__Extensions.is_omit()) ret_val.iE__Extensions() = OMIT_VALUE;
else if (single_value->field_iE__Extensions.is_bound()) {
ret_val.iE__Extensions() = single_value->field_iE__Extensions.valueof();
}
if (single_value->field_uncertaintyCode.is_bound()) {
ret_val.uncertaintyCode() = single_value->field_uncertaintyCode.valueof();
}
return ret_val;
}

void GA__PointWithUnCertainty_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-IEs.GA-PointWithUnCertainty.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GA__PointWithUnCertainty_template[list_length];
}

GA__PointWithUnCertainty_template& GA__PointWithUnCertainty_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-IEs.GA-PointWithUnCertainty.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-IEs.GA-PointWithUnCertainty.");
return value_list.list_value[list_index];
}

GeographicalCoordinates_template& GA__PointWithUnCertainty_template::geographicalCoordinates()
{
set_specific();
return single_value->field_geographicalCoordinates;
}

const GeographicalCoordinates_template& GA__PointWithUnCertainty_template::geographicalCoordinates() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field geographicalCoordinates of a non-specific template of type @RANAP-IEs.GA-PointWithUnCertainty.");
return single_value->field_geographicalCoordinates;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& GA__PointWithUnCertainty_template::iE__Extensions()
{
set_specific();
return single_value->field_iE__Extensions;
}

const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& GA__PointWithUnCertainty_template::iE__Extensions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iE_Extensions of a non-specific template of type @RANAP-IEs.GA-PointWithUnCertainty.");
return single_value->field_iE__Extensions;
}

INTEGER_template& GA__PointWithUnCertainty_template::uncertaintyCode()
{
set_specific();
return single_value->field_uncertaintyCode;
}

const INTEGER_template& GA__PointWithUnCertainty_template::uncertaintyCode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field uncertaintyCode of a non-specific template of type @RANAP-IEs.GA-PointWithUnCertainty.");
return single_value->field_uncertaintyCode;
}

int GA__PointWithUnCertainty_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_iE__Extensions.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-IEs.GA-PointWithUnCertainty containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-IEs.GA-PointWithUnCertainty.");
  }
  return 0;
}

void GA__PointWithUnCertainty_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ geographicalCoordinates := ");
single_value->field_geographicalCoordinates.log();
TTCN_Logger::log_event_str(", iE_Extensions := ");
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(", uncertaintyCode := ");
single_value->field_uncertaintyCode.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GA__PointWithUnCertainty_template::log_match(const GA__PointWithUnCertainty& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_geographicalCoordinates.match(match_value.geographicalCoordinates(), legacy)){
TTCN_Logger::log_logmatch_info(".geographicalCoordinates");
single_value->field_geographicalCoordinates.log_match(match_value.geographicalCoordinates(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.iE__Extensions().ispresent()){
if(!single_value->field_iE__Extensions.match(match_value.iE__Extensions(), legacy)){
TTCN_Logger::log_logmatch_info(".iE_Extensions");
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_iE__Extensions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".iE_Extensions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_iE__Extensions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_uncertaintyCode.match(match_value.uncertaintyCode(), legacy)){
TTCN_Logger::log_logmatch_info(".uncertaintyCode");
single_value->field_uncertaintyCode.log_match(match_value.uncertaintyCode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ geographicalCoordinates := ");
single_value->field_geographicalCoordinates.log_match(match_value.geographicalCoordinates(), legacy);
TTCN_Logger::log_event_str(", iE_Extensions := ");
if (match_value.iE__Extensions().ispresent()) {
single_value->field_iE__Extensions.log_match(match_value.iE__Extensions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_iE__Extensions.log();
if (single_value->field_iE__Extensions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", uncertaintyCode := ");
single_value->field_uncertaintyCode.log_match(match_value.uncertaintyCode(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GA__PointWithUnCertainty_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (geographicalCoordinates().is_bound()) geographicalCoordinates().set_implicit_omit();
if (!iE__Extensions().is_bound()) iE__Extensions() = OMIT_VALUE;
else iE__Extensions().set_implicit_omit();
if (uncertaintyCode().is_bound()) uncertaintyCode().set_implicit_omit();
}

void GA__PointWithUnCertainty_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_geographicalCoordinates.encode_text(text_buf);
single_value->field_iE__Extensions.encode_text(text_buf);
single_value->field_uncertaintyCode.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.GA-PointWithUnCertainty.");
}
}

void GA__PointWithUnCertainty_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_geographicalCoordinates.decode_text(text_buf);
single_value->field_iE__Extensions.decode_text(text_buf);
single_value->field_uncertaintyCode.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GA__PointWithUnCertainty_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-IEs.GA-PointWithUnCertainty.");
}
}

void GA__PointWithUnCertainty_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GA__PointWithUnCertainty_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RANAP-IEs.GA-PointWithUnCertainty has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) geographicalCoordinates().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) iE__Extensions().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) uncertaintyCode().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "geographicalCoordinates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          geographicalCoordinates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iE_Extensions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iE__Extensions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uncertaintyCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uncertaintyCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-IEs.GA-PointWithUnCertainty: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GA__PointWithUnCertainty_template* precondition = new GA__PointWithUnCertainty_template;
    precondition->set_param(*param.get_elem(0));
    GA__PointWithUnCertainty_template* implied_template = new GA__PointWithUnCertainty_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GA__PointWithUnCertainty_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-IEs.GA-PointWithUnCertainty");
  }
  is_ifpresent = param.get_ifpresent();
}

void GA__PointWithUnCertainty_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_geographicalCoordinates.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GA-PointWithUnCertainty");
single_value->field_iE__Extensions.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GA-PointWithUnCertainty");
single_value->field_uncertaintyCode.check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.GA-PointWithUnCertainty");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.GA-PointWithUnCertainty");
}

boolean GA__PointWithUnCertainty_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GA__PointWithUnCertainty_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::UNBOUND_ELEM;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22()
{
val_ptr = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return val_ptr->n_elements == 0 ;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator==(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22;
}
return *val_ptr->value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return (*this)[(int)index_value];
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::operator+(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22","element");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return val_ptr->n_elements;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    new_tlv=ASN_BER_TLV_t::construct(NULL);
    TTCN_EncDec_ErrorContext ec;
    for(int elem_i=0; elem_i<val_ptr->n_elements; elem_i++) {
      ec.set_msg("Component #%d: ", elem_i);
      new_tlv->add_TLV((*this)[elem_i].BER_encode_TLV(*p_td.oftype_descr, p_coding));
    }
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '%s' type: ", p_td.name);
  stripped_tlv.chk_constructed_flag(TRUE);
  clean_up();
  val_ptr = new recordof_setof_struct;
  val_ptr->ref_count = 1;
  val_ptr->n_elements = 0;
  val_ptr->value_elements = NULL;
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  TTCN_EncDec_ErrorContext ec_1("Component #");
  TTCN_EncDec_ErrorContext ec_2("0: ");
  while(BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv)) {
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, val_ptr->n_elements + 1);
    val_ptr->n_elements++;
    val_ptr->value_elements[val_ptr->n_elements - 1] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22;
    val_ptr->value_elements[val_ptr->n_elements - 1]->BER_decode_TLV(*p_td.oftype_descr, tmp_tlv, L_form);
    ec_2.set_msg("%d: ", val_ptr->n_elements);
  }
  return TRUE;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_START : JSON_TOKEN_ARRAY_START, NULL);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    if (p_td.json->metainfo_unbound && !(*this)[i].is_bound()) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "metainfo []");
      enc_len += p_tok.put_next_token(JSON_TOKEN_STRING, "\"unbound\"");
      enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
    }
    else {
      int ret_val = (*this)[i].JSON_encode(*p_td.oftype_descr, p_tok, p_td.json->as_map);
      if (0 > ret_val) break;
      enc_len += ret_val;
    }
  }
  enc_len += p_tok.put_next_token(p_td.json->as_map ? JSON_TOKEN_OBJECT_END : JSON_TOKEN_ARRAY_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    set_size(0);
    return strlen(p_td.json->default_value.str);
  }
  json_token_t token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&token, NULL, NULL);
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_START != token) ||
           (p_td.json->as_map && JSON_TOKEN_OBJECT_START != token)) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  set_size(0);
  for (int nof_elements = 0; TRUE; ++nof_elements) {
    size_t buf_pos = p_tok.get_buf_pos();
    size_t ret_val;
    if (p_td.json->metainfo_unbound) {
      ret_val = p_tok.get_next_token(&token, NULL, NULL);
      if (JSON_TOKEN_OBJECT_START == token) {
        char* value = NULL;
        size_t value_len = 0;
        ret_val += p_tok.get_next_token(&token, &value, &value_len);
        if (JSON_TOKEN_NAME == token && 11 == value_len &&
            0 == strncmp(value, "metainfo []", 11)) {
          ret_val += p_tok.get_next_token(&token, &value, &value_len);
          if (JSON_TOKEN_STRING == token && 9 == value_len &&
              0 == strncmp(value, "\"unbound\"", 9)) {
            ret_val = p_tok.get_next_token(&token, NULL, NULL);
            if (JSON_TOKEN_OBJECT_END == token) {
              dec_len += ret_val;
              continue;
            }
          }
        }
      }
      p_tok.set_buf_pos(buf_pos);
    }
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22* val = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22;
    int ret_val2 = val->JSON_decode(*p_td.oftype_descr, p_tok, p_silent, p_td.json->as_map);
    if (JSON_ERROR_INVALID_TOKEN == ret_val2) {
      p_tok.set_buf_pos(buf_pos);
      delete val;
      break;
    }
    else if (JSON_ERROR_FATAL == ret_val2) {
      delete val;
      if (p_silent) {
        clean_up();
      }
      return JSON_ERROR_FATAL;
    }
    val_ptr->value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22**)reallocate_pointers(
      (void**)val_ptr->value_elements, val_ptr->n_elements, nof_elements + 1);
    val_ptr->value_elements[nof_elements] = val;
    val_ptr->n_elements = nof_elements + 1;
    dec_len += (size_t)ret_val2;
  }

  dec_len += p_tok.get_next_token(&token, NULL, NULL);
  if ((!p_td.json->as_map && JSON_TOKEN_ARRAY_END != token) ||
      (p_td.json->as_map && JSON_TOKEN_OBJECT_END != token)) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_REC_OF_END_TOKEN_ERROR, "");
    if (p_silent) {
      clean_up();
    }
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::OER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
    return -1;
  }

  encode_oer_length(val_ptr->n_elements, p_buf, TRUE);
  for (int i = 0; i < val_ptr->n_elements; ++i) {
    (*this)[i].OER_encode(*p_td.oftype_descr, p_buf);
  }
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::OER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t nof_elem = decode_oer_length(p_buf, TRUE);
  set_size(nof_elem);
  for (size_t i = 0; i < nof_elem; i++) {
    (*this)[i].OER_decode(*p_td.oftype_descr, p_buf, p_oer);
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
"Encoding an unbound SEQUENCE OF value.");
return;
}
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
INTEGER length(val_ptr->n_elements);
boolean extendable = cons->has_extension_marker();
boolean within_ext_root = cons->is_within_extension_root(length);
if (!within_ext_root && !extendable) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT,
"Encoding an invalid SEQUENCE OF value (does not match PER-visible constraints).");
return;
}
boolean ext_bit = extendable && !within_ext_root;
if (extendable) p_buf.PER_put_bit(ext_bit);
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
if (range == 1 && length == 0) return;
int mul_16k;
int pos = 0;
do {
mul_16k = (range == 1) ? 0 : length.PER_encode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
int elements_encoded = (mul_16k == 0) ? (int)length : mul_16k * PER_16K;
for (int i = 0; i < elements_encoded; ++i) {
(*this)[i + pos].PER_encode(*p_td.oftype_descr, p_buf, p_options);
}
if (mul_16k > 0) {
pos += elements_encoded;
length = length - elements_encoded;
range = 0;
}
}
while (mul_16k > 0);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
const Per_Integer_Constraint* cons = dynamic_cast<const Per_Integer_Constraint*>(p_td.per->c);
if (cons == NULL) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INTERNAL,
"Internal error: Invalid constraint in PER descriptor.");
return;
}
clean_up();
boolean extendable = cons->has_extension_marker();
boolean ext_bit = extendable ? p_buf.PER_get_bit() : FALSE;
INTEGER length_ub = cons->has_upper_bound() ? cons->get_upper_bound() : INTEGER(-1);
if (length_ub >= PER_64K) length_ub = -1;
INTEGER range = (ext_bit || length_ub < 0) ? INTEGER(0) : cons->get_nof_values();
int mul_16k;
INTEGER length;
int current_size = 0;
do {
mul_16k = length.PER_decode_length(p_buf, p_options, range, cons->get_lower_bound(), length_ub);
if (mul_16k != 0) range = 0;
int new_size = current_size + (int)length;
set_size(new_size);
for (int i = current_size; i < new_size; ++i) {
(*this)[i].PER_decode(*p_td.oftype_descr, p_buf, p_options);
}
current_size = new_size;
}
while (mul_16k > 0);
if (!ext_bit && !cons->is_within_extension_root(val_ptr->n_elements)) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_CONSTRAINT, "Decoded SEQUENCE OF value does not match PER-visible constraints.");
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
break;
}
set_selection(other_value);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22*)value_ptr)[value_index], legacy);
else return ((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template()
{
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::~_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator=(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
    break;
}
return *single_value.value_elements[index_value];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return (*this)[(int)index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return (*this)[(int)index_value];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22 containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::replace(int index, int len, const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
}
set_selection(template_type);
}

_root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
return value_list.list_value[list_index];
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::log_match(const _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
single_value.value_elements = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template* precondition = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-IEs.ProtocolExtensionContainer.RANAP-IEs.inst22");
}

boolean _root_RANAP__Containers_ProtocolExtensionContainer_RANAP__IEs_inst22_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value)
{
switch (other_value.union_selection) {
default:
TTCN_error("Assignment of an unbound union value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
union_selection = other_value.union_selection;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type()
{
union_selection = UNBOUND_VALUE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value)
: Base_Type(){
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
default:
return FALSE;
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
return union_selection == checked_selection;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
default: TTCN_error("Invalid selection in union is_bound");}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::clean_up()
{
switch (union_selection) {
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::log() const
{
switch (union_selection) {
default:
TTCN_Logger::log_event_unbound();
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.", last_name);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::set_implicit_omit()
{
switch (union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type' type: ");
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tlv_opentype)) {
    tlv_opentype.Tlen = 0;
    return FALSE;
  }
  clean_up();
  union_selection = UNBOUND_VALUE;
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean) const
{
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
    "Cannot encode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type, because it has zero alternatives.");
  return -1;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, 
    "Cannot decode union of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type, because it has zero alternatives.");
  return JSON_ERROR_FATAL;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
    return -1;
  }

  return 0;
}
int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  size_t pos = decode_oer_length(p_buf, FALSE);
  size_t prev_pos = p_buf.get_pos();
  p_buf.increase_pos(pos);
  p_oer.opentype_poses.push_back(prev_pos);
  return 0;
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  if (union_selection != UNBOUND_VALUE) return;
  TTCN_EncDec_ErrorContext ec_0("While decoding open type '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type': ");
  ec_0.error(TTCN_EncDec::ET_DEC_OPENTYPE, "Cannot decode open type: the constraining object set is empty.");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
default:
TTCN_error("Initializing a template with an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& other_value)
: Base_Template(){
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template()
{
clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::union_selection_type value_selection = other_value.get_selection();
if (value_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type ret_val;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
return ret_val;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
return value_list.list_value[list_index];
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template[list_length];
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::ischosen(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::union_selection_type checked_selection) const
{
if (checked_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
switch (single_value.union_selection) {
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
default: break;
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::UNBOUND_VALUE;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::union_selection_type new_selection = (_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type'");
    }
    param.error("Field `%s' not found in union template type `@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    mp_last->error("Field %s does not exist in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template;
    precondition->set_param(*m_p->get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.extensionValue.type");
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(const INTEGER& par_id,
    const RANAP__CommonDataTypes::Criticality& par_criticality,
    const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type& par_extensionValue)
  :   field_id(par_id),
  field_criticality(par_criticality),
  field_extensionValue(par_extensionValue)
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
if (other_value.id().is_bound()) field_id = other_value.id();
else field_id.clean_up();
if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
else field_criticality.clean_up();
if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
else field_extensionValue.clean_up();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::clean_up()
{
field_id.clean_up();
field_criticality.clean_up();
field_extensionValue.clean_up();
}

const TTCN_Typedescriptor_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::get_descriptor() const { return &_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_descr_; }
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
  if (other_value.id().is_bound()) field_id = other_value.id();
  else field_id.clean_up();
  if (other_value.criticality().is_bound()) field_criticality = other_value.criticality();
  else field_criticality.clean_up();
  if (other_value.extensionValue().is_bound()) field_extensionValue = other_value.extensionValue();
  else field_extensionValue.clean_up();
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::operator==(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value) const
{
return field_id==other_value.field_id
  && field_criticality==other_value.field_criticality
  && field_extensionValue==other_value.field_extensionValue;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::is_bound() const
{
return (field_id.is_bound())
  || (field_criticality.is_bound())
  || (field_extensionValue.is_bound());
}
boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::is_value() const
{
return field_id.is_value()
  && field_criticality.is_value()
  && field_extensionValue.is_value();
}
void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ id := ");
field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::set_implicit_omit()
{
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22");
  }
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::encode_text(Text_Buf& text_buf) const
{
field_id.encode_text(text_buf);
field_criticality.encode_text(text_buf);
field_extensionValue.encode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::decode_text(Text_Buf& text_buf)
{
field_id.decode_text(text_buf);
field_criticality.decode_text(text_buf);
field_extensionValue.decode_text(text_buf);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  new_tlv->add_TLV(field_id.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_coding));
  ec_1.set_msg("criticality': ");
  new_tlv->add_TLV(field_criticality.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_coding));
  ec_1.set_msg("extensionValue': ");
  new_tlv->add_TLV(field_extensionValue.BER_encode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("id': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_id.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("criticality': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_criticality.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionValue': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_extensionValue.BER_decode_TLV(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");
  TTCN_Type_list p_typelist;
  BER_decode_opentypes(p_typelist, L_form);
  return TRUE;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::BER_decode_opentypes(TTCN_Type_list& p_typelist, unsigned L_form)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("criticality': ");
  field_criticality.BER_decode_opentypes(p_typelist, L_form);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.BER_decode_opentypes(p_typelist, L_form);
  p_typelist.pop();
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "id");
    enc_len += field_id.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "criticality");
    enc_len += field_criticality.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionValue");
    enc_len += field_extensionValue.JSON_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean id_found = FALSE;
  boolean criticality_found = FALSE;
  boolean extensionValue_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (2 == name_len && 0 == strncmp(fld_name, "id", name_len)) {
        id_found = TRUE;
         int ret_val = field_id.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "id");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "criticality", name_len)) {
        criticality_found = TRUE;
         int ret_val = field_criticality.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "criticality");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "extensionValue", name_len)) {
        extensionValue_found = TRUE;
         int ret_val = field_extensionValue.JSON_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "extensionValue");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!id_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "id");
    return JSON_ERROR_FATAL;
  }
  if (!criticality_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "criticality");
    return JSON_ERROR_FATAL;
  }
  if (!extensionValue_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "extensionValue");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  field_id.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_buf);
  field_criticality.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_buf);
  field_extensionValue.OER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_buf);
  return 0;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  field_id.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_buf, p_oer);
  field_criticality.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_buf, p_oer);
  field_extensionValue.OER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_buf, p_oer);
  TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");  TTCN_Type_list p_typelist;
  OER_decode_opentypes(p_typelist, p_buf, p_oer);
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::OER_decode_opentypes(TTCN_Type_list& p_typelist, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  p_typelist.push(this);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("id': ");
  field_id.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("criticality': ");
  field_criticality.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  ec_1.set_msg("extensionValue': ");
  field_extensionValue.OER_decode_opentypes(p_typelist, p_buf, p_oer);
  p_typelist.pop();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
field_id.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_buf, p_options);
field_criticality.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_encode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_buf, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
field_id.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_id_descr_, p_buf, p_options);
field_criticality.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_criticality_descr_, p_buf, p_options);
field_extensionValue.PER_decode(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_descr_, p_buf, p_options);
TTCN_EncDec_ErrorContext ec_1("While decoding opentypes: ");TTCN_Type_list p_typelist;
PER_decode_opentypes(p_typelist, p_options);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22::PER_decode_opentypes(TTCN_Type_list& p_typelist, int p_options)
{
p_typelist.push(this);
TTCN_EncDec_ErrorContext ec_0("Component '");
TTCN_EncDec_ErrorContext ec_1;
ec_1.set_msg("id': ");
field_id.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("criticality': ");
field_criticality.PER_decode_opentypes(p_typelist, p_options);
ec_1.set_msg("extensionValue': ");
field_extensionValue.PER_decode_opentypes(p_typelist, p_options);
p_typelist.pop();
}

struct _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::single_value_struct {
INTEGER_template field_id;
RANAP__CommonDataTypes::Criticality_template field_criticality;
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template field_extensionValue;
};

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_id = ANY_VALUE;
single_value->field_criticality = ANY_VALUE;
single_value->field_extensionValue = ANY_VALUE;
}
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::copy_value(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value)
{
single_value = new single_value_struct;
if (other_value.id().is_bound()) {
  single_value->field_id = other_value.id();
} else {
  single_value->field_id.clean_up();
}
if (other_value.criticality().is_bound()) {
  single_value->field_criticality = other_value.criticality();
} else {
  single_value->field_criticality.clean_up();
}
if (other_value.extensionValue().is_bound()) {
  single_value->field_extensionValue = other_value.extensionValue();
} else {
  single_value->field_extensionValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::copy_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.id().get_selection()) {
single_value->field_id = other_value.id();
} else {
single_value->field_id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.criticality().get_selection()) {
single_value->field_criticality = other_value.criticality();
} else {
single_value->field_criticality.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionValue().get_selection()) {
single_value->field_extensionValue = other_value.extensionValue();
} else {
single_value->field_extensionValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(*other_value.implication_.precondition);
implication_.implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
break;
}
set_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template()
{
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value)
{
copy_value(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 from an unbound optional field.");
}
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template* p_precondition, _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(Dynamic_Match_Interface<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::~_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template()
{
clean_up();
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::operator=(const OPTIONAL<_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
}
return *this;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::operator=(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.id().is_bound()) return FALSE;
if(!single_value->field_id.match(other_value.id(), legacy))return FALSE;
if(!other_value.criticality().is_bound()) return FALSE;
if(!single_value->field_criticality.match(other_value.criticality(), legacy))return FALSE;
if(!other_value.extensionValue().is_bound()) return FALSE;
if(!single_value->field_extensionValue.match(other_value.extensionValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
}
return FALSE;
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_id.is_bound()
 || single_value->field_criticality.is_bound()
 || single_value->field_extensionValue.is_bound();
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_id.is_value()
 && single_value->field_criticality.is_value()
 && single_value->field_extensionValue.is_value();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22 _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22 ret_val;
if (single_value->field_id.is_bound()) {
ret_val.id() = single_value->field_id.valueof();
}
if (single_value->field_criticality.is_bound()) {
ret_val.criticality() = single_value->field_criticality.valueof();
}
if (single_value->field_extensionValue.is_bound()) {
ret_val.extensionValue() = single_value->field_extensionValue.valueof();
}
return ret_val;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template[list_length];
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
return value_list.list_value[list_index];
}

INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::id()
{
set_specific();
return single_value->field_id;
}

const INTEGER_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
return single_value->field_id;
}

RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::criticality()
{
set_specific();
return single_value->field_criticality;
}

const RANAP__CommonDataTypes::Criticality_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::criticality() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field criticality of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
return single_value->field_criticality;
}

_root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::extensionValue()
{
set_specific();
return single_value->field_extensionValue;
}

const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_extensionValue_type_template& _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::extensionValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionValue of a non-specific template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
return single_value->field_extensionValue;
}

int _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
  }
  return 0;
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log();
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log();
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::log_match(const _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_id.match(match_value.id(), legacy)){
TTCN_Logger::log_logmatch_info(".id");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_criticality.match(match_value.criticality(), legacy)){
TTCN_Logger::log_logmatch_info(".criticality");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_extensionValue.match(match_value.extensionValue(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionValue");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ id := ");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::log_event_str(", criticality := ");
single_value->field_criticality.log_match(match_value.criticality(), legacy);
TTCN_Logger::log_event_str(", extensionValue := ");
single_value->field_extensionValue.log_match(match_value.extensionValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (id().is_bound()) id().set_implicit_omit();
if (criticality().is_bound()) criticality().set_implicit_omit();
if (extensionValue().is_bound()) extensionValue().set_implicit_omit();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_id.encode_text(text_buf);
single_value->field_criticality.encode_text(text_buf);
single_value->field_extensionValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_id.decode_text(text_buf);
single_value->field_criticality.decode_text(text_buf);
single_value->field_extensionValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22.");
}
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) criticality().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "criticality")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          criticality().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template* precondition = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template;
    precondition->set_param(*param.get_elem(0));
    _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template* implied_template = new _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template;
    implied_template->set_param(*param.get_elem(1));
    *this = _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22");
  }
  is_ifpresent = param.get_ifpresent();
}

void _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_id.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22");
single_value->field_criticality.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22");
single_value->field_extensionValue.check_restriction(t_res, t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RANAP-Containers.ProtocolExtensionField.RANAP-IEs.inst22");
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean _root_RANAP__Containers_ProtocolExtensionField_RANAP__IEs_inst22_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const GA__Polygon_0 GA__Polygon::UNBOUND_ELEM;
GA__Polygon::GA__Polygon()
{
val_ptr = NULL;
}

GA__Polygon::GA__Polygon(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

GA__Polygon::GA__Polygon(const GA__Polygon& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RANAP-IEs.GA-Polygon.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

GA__Polygon::~GA__Polygon()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void GA__Polygon::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

GA__Polygon& GA__Polygon::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

GA__Polygon& GA__Polygon::operator=(const GA__Polygon& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RANAP-IEs.GA-Polygon.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean GA__Polygon::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.GA-Polygon.");
return val_ptr->n_elements == 0 ;
}

boolean GA__Polygon::operator==(const GA__Polygon& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RANAP-IEs.GA-Polygon.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RANAP-IEs.GA-Polygon.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

GA__Polygon_0& GA__Polygon::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.GA-Polygon using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (GA__Polygon_0**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new GA__Polygon_0(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new GA__Polygon_0;
}
return *val_ptr->value_elements[index_value];
}

GA__Polygon_0& GA__Polygon::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.GA-Polygon.");
return (*this)[(int)index_value];
}

const GA__Polygon_0& GA__Polygon::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RANAP-IEs.GA-Polygon.");
if (index_value < 0) TTCN_error("Accessing an element of type @RANAP-IEs.GA-Polygon using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RANAP-IEs.GA-Polygon: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const GA__Polygon_0& GA__Polygon::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RANAP-IEs.GA-Polygon.");
return (*this)[(int)index_value];
}

GA__Polygon GA__Polygon::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

GA__Polygon GA__Polygon::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

GA__Polygon GA__Polygon::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

GA__Polygon GA__Polygon::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RANAP-IEs.GA-Polygon.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
GA__Polygon ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new GA__Polygon_0(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

GA__Polygon GA__Polygon::operator+(const GA__Polygon& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RANAP-IEs.GA-Polygon concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
GA__Polygon ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new GA__Polygon_0(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new GA__Polygon_0(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

GA__Polygon GA__Polygon::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RANAP-IEs.GA-Polygon.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RANAP-IEs.GA-Polygon","element");
GA__Polygon ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new GA__Polygon_0(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

GA__Polygon GA__Polygon::replace(int index, int len, const GA__Polygon& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RANAP-IEs.GA-Polygon.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RANAP-IEs.GA-Polygon.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RANAP-IEs.GA-Polygon","element");
GA__Polygon ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new GA__Polygon_0(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new GA__Polygon_0(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new GA__Polygon_0(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

GA__Polygon GA__Polygon::replace(int index, int len, const GA__Polygon_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void GA__Polygon::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RANAP-IEs.GA-Polygon.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (GA__Polygon_0**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new GA__Polygon_0(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (GA__Polygon_0**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RANAP-IEs.GA-Polygon: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (GA__Polygon_0**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean GA__Polygon::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int GA__Polygon::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RANAP-IEs.GA-Polygon.");
return val_ptr->n_elements;
}

int GA__Polygon::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RANAP-IEs.GA-Polygon.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void GA__Polygon::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void GA__Polygon::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void GA__Polygon::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.GA-Polygon");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RANAP-IEs.GA-Polygon");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void GA__Polygon::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RANAP-IEs.GA-Polygon.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void GA__Polygon::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RANAP-IEs.GA-Polygon.");
val_ptr->value_elements = (GA__Polygon_0**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new GA__Polygon_0;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void GA__Polygon::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GA__Polygon::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!