package org.osmocom.androidApduProxy;

import android.os.Handler;
import android.os.Message;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

//OMAPI callback handler that scans for available card slots (with a UICC or eUICC in it).
//This is a one-off that is meant to be executed once on startup to populate the spinner
//(drop down menue) where the user selects the card slot.
class OmapiCallbackHandlerScan implements OmapiCallback {
    private Handler uiHandler = null;

    OmapiCallbackHandlerScan(Handler uiHandler) {
        this.uiHandler = uiHandler;
    }

    public void omapiConnected(Omapi omapi) {
        Map<String, byte[]> omapiReaders;
        omapiReaders = omapi.scan();
        List<String> categories = new ArrayList<String>();

        if (omapiReaders == null || omapiReaders.isEmpty()) {
            Message ind = uiHandler.obtainMessage(MainActivity.IND_ERROR, "No usable UICC/eUICC card found!");
            ind.sendToTarget();
            return;
        }

        for (int i = 0; i < omapiReaders.keySet().toArray().length; i++)
            categories.add(omapiReaders.keySet().toArray()[i].toString());

        Message ind = uiHandler.obtainMessage(MainActivity.IND_SLOT_SCAN_RESULT, categories);
        ind.sendToTarget();
    }

    @Override
    public void omapiDisconnected() {
        Log.i("PROXY", "Scanning is done, OMAPI layer is shutting down...");
    }

}

