logger_gsmtap
=============

GSMTAP logging handler.

This is a logging handler for Erlang's built-in
[Logger](https://www.erlang.org/doc/apps/kernel/logger.html) module.
It sends log messages via GSMTAP (`udp/4729`), allowing capture of
log messages alongside with other PDUs sent/received by the program.

[GSMTAP](https://osmocom.org/projects/baseband/wiki/GSMTAP) is a
pseudo-header initially designed to encapsulate GSM air interface (Um)
frames within UDP/IP packets.  Over time, its functionality was extended
to enable the transport of logging messages.


Adding to your project
----------------------

In case you're using rebar3, modify `rebar.config` as follows:

```erlang
{deps, [{logger_gsmtap,
         {git, "https://gitea.osmocom.org/erlang/logger_gsmtap.git", {branch, "master"}}}
]}.
```


API and Configuration
---------------------

To add an instance of the GSMTAP handler, you can use either
[`logger:add_handler/3`](https://www.erlang.org/doc/apps/kernel/logger.html#add_handler/3)
or the [configuration file](https://www.erlang.org/docs/25/man/config.html).
The handler configuration argument is a map which can contain general
configuration parameters, as documented in the
[User's Guide](https://www.erlang.org/doc/apps/kernel/logger_chapter.html#handler-configuration),
and handler specific parameters.  The specific data is stored in a sub map
with the key `config`, and can contain the following parameters:

- **`loc_addr :: string() | inet:ip_address()`** -
  This specifies the local (bind) address to originate GSMTAP PDUs from.

  Defaults to `"0.0.0.0"`, letting the OS to select it automatically.

- **`rem_addr :: string() | inet:ip_address()`** -
  This specifies the remote address to send GSMTAP PDUs to.

  Defaults to `"127.0.0.1"` (localhost).

- **`app_name :: string() | atom()`** -
  This specifies the application name to be included in GSMTAP PDUs.

  Defaults to `unknown`.

Modification of these parameters is currently not supported.

### Example of adding a GSMTAP handler using `logger:add_handler/3`

```erlang
logger:add_handler(gsmtap, logger_gsmtap_h,
                   #{config => #{rem_addr => "127.0.0.1",
                                 app_name => "MyApp"}}).
```

### Example of adding a GSMTAP handler via configuration file

```erlang
{kernel, [
  {logger_level, debug},
  {logger, [
    %% standard handler printing to stderr at level INFO
    {handler, default, logger_std_h,
     #{level => info}},
    %% GSMTAP handler sending datagrams to 127.0.0.1 at level DEBUG
    {handler, gsmtap, logger_gsmtap_h,
     #{level => debug,
       config => #{rem_addr => "127.0.0.1",
                   app_name => "MyApp"}}}
  ]}
]}
```
