/* Auto-generated config file hpl_sercom_config.h */
#ifndef HPL_SERCOM_CONFIG_H
#define HPL_SERCOM_CONFIG_H

// <<< Use Configuration Wizard in Context Menu >>>

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_0_USART_ENABLE
#define CONF_SERCOM_0_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_0_USART_RXEN
#define CONF_SERCOM_0_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_0_USART_TXEN
#define CONF_SERCOM_0_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_0_USART_PARITY
#define CONF_SERCOM_0_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_0_USART_CHSIZE
#define CONF_SERCOM_0_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_0_USART_SBMODE
#define CONF_SERCOM_0_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_0_USART_BAUD
#define CONF_SERCOM_0_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_0_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_0_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_0_USART_INACK
#define CONF_SERCOM_0_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_0_USART_DSNACK
#define CONF_SERCOM_0_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_0_USART_MAXITER
#define CONF_SERCOM_0_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_0_USART_GTIME
#define CONF_SERCOM_0_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_0_USART_INVERSE_ENABLED
#define CONF_SERCOM_0_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_0_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_0_USART_RXINV 0x1
#define CONF_SERCOM_0_USART_TXINV 0x1
#else
#define CONF_SERCOM_0_USART_RXINV 0x0
#define CONF_SERCOM_0_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_0_USART_ADVANCED_CONFIG
#define CONF_SERCOM_0_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_0_USART_RUNSTDBY
#define CONF_SERCOM_0_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_0_USART_IBON
#define CONF_SERCOM_0_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_0_USART_SFDE
#define CONF_SERCOM_0_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_0_USART_CLODEN
#define CONF_SERCOM_0_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_0_USART_MODE
#define CONF_SERCOM_0_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_0_USART_DORD
#define CONF_SERCOM_0_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_0_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_0_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_0_USART_SAMPR 0x0
#define CONF_SERCOM_0_USART_SAMPA 0x0
#define CONF_SERCOM_0_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_0_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_0_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_0_USART_CMODE
#define CONF_SERCOM_0_USART_CMODE CONF_SERCOM_0_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PA04 */
#ifndef CONF_SERCOM_0_USART_RXPO
#define CONF_SERCOM_0_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_0_USART_TXPO
#define CONF_SERCOM_0_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_0_USART_PMODE (CONF_SERCOM_0_USART_PARITY - 1)
#define CONF_SERCOM_0_USART_FORM 7

#if CONF_SERCOM_0_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_0_USART_SAMPR == 0
#ifndef CONF_SERCOM_0_USART_BAUD_RATE
#define CONF_SERCOM_0_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_0_USART_BAUD) / CONF_GCLK_SERCOM0_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_0_USART_SAMPR == 1
#ifndef CONF_SERCOM_0_USART_BAUD_RATE
#define CONF_SERCOM_0_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM0_CORE_FREQUENCY) / (CONF_SERCOM_0_USART_BAUD * 16)) - (CONF_SERCOM_0_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_0_USART_SAMPR == 2
#ifndef CONF_SERCOM_0_USART_BAUD_RATE
#define CONF_SERCOM_0_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_0_USART_BAUD) / CONF_GCLK_SERCOM0_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_0_USART_SAMPR == 3
#ifndef CONF_SERCOM_0_USART_BAUD_RATE
#define CONF_SERCOM_0_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM0_CORE_FREQUENCY) / (CONF_SERCOM_0_USART_BAUD * 8)) - (CONF_SERCOM_0_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_0_USART_SAMPR == 4
#ifndef CONF_SERCOM_0_USART_BAUD_RATE
#define CONF_SERCOM_0_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_0_USART_BAUD) / CONF_GCLK_SERCOM0_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_0_USART_CMODE == 1
#ifndef CONF_SERCOM_0_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_0_USART_BAUD_RATE (CONF_GCLK_SERCOM0_CORE_FREQUENCY) / (2 * CONF_SERCOM_0_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_0_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 0 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_1_USART_ENABLE
#define CONF_SERCOM_1_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_1_USART_RXEN
#define CONF_SERCOM_1_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_1_USART_TXEN
#define CONF_SERCOM_1_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_1_USART_PARITY
#define CONF_SERCOM_1_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_1_USART_CHSIZE
#define CONF_SERCOM_1_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_1_USART_SBMODE
#define CONF_SERCOM_1_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_1_USART_BAUD
#define CONF_SERCOM_1_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_1_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_1_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_1_USART_INACK
#define CONF_SERCOM_1_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_1_USART_DSNACK
#define CONF_SERCOM_1_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_1_USART_MAXITER
#define CONF_SERCOM_1_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_1_USART_GTIME
#define CONF_SERCOM_1_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_1_USART_INVERSE_ENABLED
#define CONF_SERCOM_1_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_1_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_1_USART_RXINV 0x1
#define CONF_SERCOM_1_USART_TXINV 0x1
#else
#define CONF_SERCOM_1_USART_RXINV 0x0
#define CONF_SERCOM_1_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_1_USART_ADVANCED_CONFIG
#define CONF_SERCOM_1_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_1_USART_RUNSTDBY
#define CONF_SERCOM_1_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_1_USART_IBON
#define CONF_SERCOM_1_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_1_USART_SFDE
#define CONF_SERCOM_1_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_1_USART_CLODEN
#define CONF_SERCOM_1_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_1_USART_MODE
#define CONF_SERCOM_1_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_1_USART_DORD
#define CONF_SERCOM_1_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_1_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_1_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_1_USART_SAMPR 0x0
#define CONF_SERCOM_1_USART_SAMPA 0x0
#define CONF_SERCOM_1_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_1_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_1_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_1_USART_CMODE
#define CONF_SERCOM_1_USART_CMODE CONF_SERCOM_1_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PA16 */
#ifndef CONF_SERCOM_1_USART_RXPO
#define CONF_SERCOM_1_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_1_USART_TXPO
#define CONF_SERCOM_1_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_1_USART_PMODE (CONF_SERCOM_1_USART_PARITY - 1)
#define CONF_SERCOM_1_USART_FORM 7

#if CONF_SERCOM_1_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_1_USART_SAMPR == 0
#ifndef CONF_SERCOM_1_USART_BAUD_RATE
#define CONF_SERCOM_1_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_1_USART_BAUD) / CONF_GCLK_SERCOM1_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_1_USART_SAMPR == 1
#ifndef CONF_SERCOM_1_USART_BAUD_RATE
#define CONF_SERCOM_1_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM1_CORE_FREQUENCY) / (CONF_SERCOM_1_USART_BAUD * 16)) - (CONF_SERCOM_1_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_1_USART_SAMPR == 2
#ifndef CONF_SERCOM_1_USART_BAUD_RATE
#define CONF_SERCOM_1_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_1_USART_BAUD) / CONF_GCLK_SERCOM1_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_1_USART_SAMPR == 3
#ifndef CONF_SERCOM_1_USART_BAUD_RATE
#define CONF_SERCOM_1_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM1_CORE_FREQUENCY) / (CONF_SERCOM_1_USART_BAUD * 8)) - (CONF_SERCOM_1_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_1_USART_SAMPR == 4
#ifndef CONF_SERCOM_1_USART_BAUD_RATE
#define CONF_SERCOM_1_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_1_USART_BAUD) / CONF_GCLK_SERCOM1_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_1_USART_CMODE == 1
#ifndef CONF_SERCOM_1_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_1_USART_BAUD_RATE (CONF_GCLK_SERCOM1_CORE_FREQUENCY) / (2 * CONF_SERCOM_1_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_1_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 1 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_2_USART_ENABLE
#define CONF_SERCOM_2_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_2_USART_RXEN
#define CONF_SERCOM_2_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_2_USART_TXEN
#define CONF_SERCOM_2_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_2_USART_PARITY
#define CONF_SERCOM_2_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_2_USART_CHSIZE
#define CONF_SERCOM_2_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_2_USART_SBMODE
#define CONF_SERCOM_2_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_2_USART_BAUD
#define CONF_SERCOM_2_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_2_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_2_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_2_USART_INACK
#define CONF_SERCOM_2_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_2_USART_DSNACK
#define CONF_SERCOM_2_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_2_USART_MAXITER
#define CONF_SERCOM_2_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_2_USART_GTIME
#define CONF_SERCOM_2_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_2_USART_INVERSE_ENABLED
#define CONF_SERCOM_2_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_2_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_2_USART_RXINV 0x1
#define CONF_SERCOM_2_USART_TXINV 0x1
#else
#define CONF_SERCOM_2_USART_RXINV 0x0
#define CONF_SERCOM_2_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_2_USART_ADVANCED_CONFIG
#define CONF_SERCOM_2_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_2_USART_RUNSTDBY
#define CONF_SERCOM_2_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_2_USART_IBON
#define CONF_SERCOM_2_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_2_USART_SFDE
#define CONF_SERCOM_2_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_2_USART_CLODEN
#define CONF_SERCOM_2_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_2_USART_MODE
#define CONF_SERCOM_2_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_2_USART_DORD
#define CONF_SERCOM_2_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_2_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_2_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_2_USART_SAMPR 0x0
#define CONF_SERCOM_2_USART_SAMPA 0x0
#define CONF_SERCOM_2_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_2_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_2_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_2_USART_CMODE
#define CONF_SERCOM_2_USART_CMODE CONF_SERCOM_2_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PA09 */
#ifndef CONF_SERCOM_2_USART_RXPO
#define CONF_SERCOM_2_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_2_USART_TXPO
#define CONF_SERCOM_2_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_2_USART_PMODE (CONF_SERCOM_2_USART_PARITY - 1)
#define CONF_SERCOM_2_USART_FORM 7

#if CONF_SERCOM_2_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_2_USART_SAMPR == 0
#ifndef CONF_SERCOM_2_USART_BAUD_RATE
#define CONF_SERCOM_2_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_2_USART_BAUD) / CONF_GCLK_SERCOM2_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_2_USART_SAMPR == 1
#ifndef CONF_SERCOM_2_USART_BAUD_RATE
#define CONF_SERCOM_2_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM2_CORE_FREQUENCY) / (CONF_SERCOM_2_USART_BAUD * 16)) - (CONF_SERCOM_2_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_2_USART_SAMPR == 2
#ifndef CONF_SERCOM_2_USART_BAUD_RATE
#define CONF_SERCOM_2_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_2_USART_BAUD) / CONF_GCLK_SERCOM2_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_2_USART_SAMPR == 3
#ifndef CONF_SERCOM_2_USART_BAUD_RATE
#define CONF_SERCOM_2_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM2_CORE_FREQUENCY) / (CONF_SERCOM_2_USART_BAUD * 8)) - (CONF_SERCOM_2_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_2_USART_SAMPR == 4
#ifndef CONF_SERCOM_2_USART_BAUD_RATE
#define CONF_SERCOM_2_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_2_USART_BAUD) / CONF_GCLK_SERCOM2_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_2_USART_CMODE == 1
#ifndef CONF_SERCOM_2_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_2_USART_BAUD_RATE (CONF_GCLK_SERCOM2_CORE_FREQUENCY) / (2 * CONF_SERCOM_2_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_2_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 2 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_3_USART_ENABLE
#define CONF_SERCOM_3_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_3_USART_RXEN
#define CONF_SERCOM_3_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_3_USART_TXEN
#define CONF_SERCOM_3_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_3_USART_PARITY
#define CONF_SERCOM_3_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_3_USART_CHSIZE
#define CONF_SERCOM_3_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_3_USART_SBMODE
#define CONF_SERCOM_3_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_3_USART_BAUD
#define CONF_SERCOM_3_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_3_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_3_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_3_USART_INACK
#define CONF_SERCOM_3_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_3_USART_DSNACK
#define CONF_SERCOM_3_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_3_USART_MAXITER
#define CONF_SERCOM_3_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_3_USART_GTIME
#define CONF_SERCOM_3_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_3_USART_INVERSE_ENABLED
#define CONF_SERCOM_3_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_3_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_3_USART_RXINV 0x1
#define CONF_SERCOM_3_USART_TXINV 0x1
#else
#define CONF_SERCOM_3_USART_RXINV 0x0
#define CONF_SERCOM_3_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_3_USART_ADVANCED_CONFIG
#define CONF_SERCOM_3_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_3_USART_RUNSTDBY
#define CONF_SERCOM_3_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_3_USART_IBON
#define CONF_SERCOM_3_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_3_USART_SFDE
#define CONF_SERCOM_3_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_3_USART_CLODEN
#define CONF_SERCOM_3_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_3_USART_MODE
#define CONF_SERCOM_3_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_3_USART_DORD
#define CONF_SERCOM_3_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_3_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_3_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_3_USART_SAMPR 0x0
#define CONF_SERCOM_3_USART_SAMPA 0x0
#define CONF_SERCOM_3_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_3_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_3_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_3_USART_CMODE
#define CONF_SERCOM_3_USART_CMODE CONF_SERCOM_3_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PB20 */
#ifndef CONF_SERCOM_3_USART_RXPO
#define CONF_SERCOM_3_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_3_USART_TXPO
#define CONF_SERCOM_3_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_3_USART_PMODE (CONF_SERCOM_3_USART_PARITY - 1)
#define CONF_SERCOM_3_USART_FORM 7

#if CONF_SERCOM_3_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_3_USART_SAMPR == 0
#ifndef CONF_SERCOM_3_USART_BAUD_RATE
#define CONF_SERCOM_3_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_3_USART_BAUD) / CONF_GCLK_SERCOM3_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_3_USART_SAMPR == 1
#ifndef CONF_SERCOM_3_USART_BAUD_RATE
#define CONF_SERCOM_3_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM3_CORE_FREQUENCY) / (CONF_SERCOM_3_USART_BAUD * 16)) - (CONF_SERCOM_3_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_3_USART_SAMPR == 2
#ifndef CONF_SERCOM_3_USART_BAUD_RATE
#define CONF_SERCOM_3_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_3_USART_BAUD) / CONF_GCLK_SERCOM3_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_3_USART_SAMPR == 3
#ifndef CONF_SERCOM_3_USART_BAUD_RATE
#define CONF_SERCOM_3_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM3_CORE_FREQUENCY) / (CONF_SERCOM_3_USART_BAUD * 8)) - (CONF_SERCOM_3_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_3_USART_SAMPR == 4
#ifndef CONF_SERCOM_3_USART_BAUD_RATE
#define CONF_SERCOM_3_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_3_USART_BAUD) / CONF_GCLK_SERCOM3_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_3_USART_CMODE == 1
#ifndef CONF_SERCOM_3_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_3_USART_BAUD_RATE (CONF_GCLK_SERCOM3_CORE_FREQUENCY) / (2 * CONF_SERCOM_3_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_3_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 3 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_4_USART_ENABLE
#define CONF_SERCOM_4_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_4_USART_RXEN
#define CONF_SERCOM_4_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_4_USART_TXEN
#define CONF_SERCOM_4_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_4_USART_PARITY
#define CONF_SERCOM_4_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_4_USART_CHSIZE
#define CONF_SERCOM_4_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_4_USART_SBMODE
#define CONF_SERCOM_4_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_4_USART_BAUD
#define CONF_SERCOM_4_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_4_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_4_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_4_USART_INACK
#define CONF_SERCOM_4_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_4_USART_DSNACK
#define CONF_SERCOM_4_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_4_USART_MAXITER
#define CONF_SERCOM_4_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_4_USART_GTIME
#define CONF_SERCOM_4_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_4_USART_INVERSE_ENABLED
#define CONF_SERCOM_4_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_4_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_4_USART_RXINV 0x1
#define CONF_SERCOM_4_USART_TXINV 0x1
#else
#define CONF_SERCOM_4_USART_RXINV 0x0
#define CONF_SERCOM_4_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_4_USART_ADVANCED_CONFIG
#define CONF_SERCOM_4_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_4_USART_RUNSTDBY
#define CONF_SERCOM_4_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_4_USART_IBON
#define CONF_SERCOM_4_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_4_USART_SFDE
#define CONF_SERCOM_4_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_4_USART_CLODEN
#define CONF_SERCOM_4_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_4_USART_MODE
#define CONF_SERCOM_4_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_4_USART_DORD
#define CONF_SERCOM_4_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_4_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_4_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_4_USART_SAMPR 0x0
#define CONF_SERCOM_4_USART_SAMPA 0x0
#define CONF_SERCOM_4_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_4_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_4_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_4_USART_CMODE
#define CONF_SERCOM_4_USART_CMODE CONF_SERCOM_4_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PB08 */
#ifndef CONF_SERCOM_4_USART_RXPO
#define CONF_SERCOM_4_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_4_USART_TXPO
#define CONF_SERCOM_4_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_4_USART_PMODE (CONF_SERCOM_4_USART_PARITY - 1)
#define CONF_SERCOM_4_USART_FORM 7

#if CONF_SERCOM_4_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_4_USART_SAMPR == 0
#ifndef CONF_SERCOM_4_USART_BAUD_RATE
#define CONF_SERCOM_4_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_4_USART_BAUD) / CONF_GCLK_SERCOM4_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_4_USART_SAMPR == 1
#ifndef CONF_SERCOM_4_USART_BAUD_RATE
#define CONF_SERCOM_4_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM4_CORE_FREQUENCY) / (CONF_SERCOM_4_USART_BAUD * 16)) - (CONF_SERCOM_4_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_4_USART_SAMPR == 2
#ifndef CONF_SERCOM_4_USART_BAUD_RATE
#define CONF_SERCOM_4_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_4_USART_BAUD) / CONF_GCLK_SERCOM4_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_4_USART_SAMPR == 3
#ifndef CONF_SERCOM_4_USART_BAUD_RATE
#define CONF_SERCOM_4_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM4_CORE_FREQUENCY) / (CONF_SERCOM_4_USART_BAUD * 8)) - (CONF_SERCOM_4_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_4_USART_SAMPR == 4
#ifndef CONF_SERCOM_4_USART_BAUD_RATE
#define CONF_SERCOM_4_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_4_USART_BAUD) / CONF_GCLK_SERCOM4_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_4_USART_CMODE == 1
#ifndef CONF_SERCOM_4_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_4_USART_BAUD_RATE (CONF_GCLK_SERCOM4_CORE_FREQUENCY) / (2 * CONF_SERCOM_4_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_4_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 4 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_5_USART_ENABLE
#define CONF_SERCOM_5_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_5_USART_RXEN
#define CONF_SERCOM_5_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_5_USART_TXEN
#define CONF_SERCOM_5_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_5_USART_PARITY
#define CONF_SERCOM_5_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_5_USART_CHSIZE
#define CONF_SERCOM_5_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_5_USART_SBMODE
#define CONF_SERCOM_5_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_5_USART_BAUD
#define CONF_SERCOM_5_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_5_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_5_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_5_USART_INACK
#define CONF_SERCOM_5_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_5_USART_DSNACK
#define CONF_SERCOM_5_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_5_USART_MAXITER
#define CONF_SERCOM_5_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_5_USART_GTIME
#define CONF_SERCOM_5_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_5_USART_INVERSE_ENABLED
#define CONF_SERCOM_5_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_5_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_5_USART_RXINV 0x1
#define CONF_SERCOM_5_USART_TXINV 0x1
#else
#define CONF_SERCOM_5_USART_RXINV 0x0
#define CONF_SERCOM_5_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_5_USART_ADVANCED_CONFIG
#define CONF_SERCOM_5_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_5_USART_RUNSTDBY
#define CONF_SERCOM_5_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_5_USART_IBON
#define CONF_SERCOM_5_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_5_USART_SFDE
#define CONF_SERCOM_5_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_5_USART_CLODEN
#define CONF_SERCOM_5_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_5_USART_MODE
#define CONF_SERCOM_5_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_5_USART_DORD
#define CONF_SERCOM_5_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_5_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_5_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_5_USART_SAMPR 0x0
#define CONF_SERCOM_5_USART_SAMPA 0x0
#define CONF_SERCOM_5_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_5_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_5_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_5_USART_CMODE
#define CONF_SERCOM_5_USART_CMODE CONF_SERCOM_5_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PB16 */
#ifndef CONF_SERCOM_5_USART_RXPO
#define CONF_SERCOM_5_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_5_USART_TXPO
#define CONF_SERCOM_5_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_5_USART_PMODE (CONF_SERCOM_5_USART_PARITY - 1)
#define CONF_SERCOM_5_USART_FORM 7

#if CONF_SERCOM_5_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_5_USART_SAMPR == 0
#ifndef CONF_SERCOM_5_USART_BAUD_RATE
#define CONF_SERCOM_5_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_5_USART_BAUD) / CONF_GCLK_SERCOM5_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_5_USART_SAMPR == 1
#ifndef CONF_SERCOM_5_USART_BAUD_RATE
#define CONF_SERCOM_5_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM5_CORE_FREQUENCY) / (CONF_SERCOM_5_USART_BAUD * 16)) - (CONF_SERCOM_5_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_5_USART_SAMPR == 2
#ifndef CONF_SERCOM_5_USART_BAUD_RATE
#define CONF_SERCOM_5_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_5_USART_BAUD) / CONF_GCLK_SERCOM5_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_5_USART_SAMPR == 3
#ifndef CONF_SERCOM_5_USART_BAUD_RATE
#define CONF_SERCOM_5_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM5_CORE_FREQUENCY) / (CONF_SERCOM_5_USART_BAUD * 8)) - (CONF_SERCOM_5_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_5_USART_SAMPR == 4
#ifndef CONF_SERCOM_5_USART_BAUD_RATE
#define CONF_SERCOM_5_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_5_USART_BAUD) / CONF_GCLK_SERCOM5_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_5_USART_CMODE == 1
#ifndef CONF_SERCOM_5_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_5_USART_BAUD_RATE (CONF_GCLK_SERCOM5_CORE_FREQUENCY) / (2 * CONF_SERCOM_5_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_5_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 5 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_6_USART_ENABLE
#define CONF_SERCOM_6_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_6_USART_RXEN
#define CONF_SERCOM_6_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_6_USART_TXEN
#define CONF_SERCOM_6_USART_TXEN 1
#endif

// <o> Frame parity
// <0x1=>Even parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_6_USART_PARITY
#define CONF_SERCOM_6_USART_PARITY 1
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_6_USART_CHSIZE
#define CONF_SERCOM_6_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_6_USART_SBMODE
#define CONF_SERCOM_6_USART_SBMODE 1
#endif

// <o> Baud rate <1-3000000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_6_USART_BAUD
#define CONF_SERCOM_6_USART_BAUD 6720
#endif
// </h>

// <h> ISO7816 configuration
// <o> ISO7816 Protocol Type
// <0x1=> T=0
// <0x0=> T=1
// <i> Define ISO7816 protocol type as 0.
// <id> usart_iso7816_type
#ifndef CONF_SERCOM_6_USART_ISO7816_PROTOCOL_T
#define CONF_SERCOM_6_USART_ISO7816_PROTOCOL_T 0x0
#endif

// <o> ISO7816 Inhibit Not Acknowledge
// <0x0=> NACK is transmitted when a parity error is received.
// <0x1=> NACK is not transmitted when a parity error is received.
// <i> Define whether a NACK is transmitted when a parity error is received.
// <id> usart_inack
#ifndef CONF_SERCOM_6_USART_INACK
#define CONF_SERCOM_6_USART_INACK 0x0
#endif

// <o> ISO7816 Disable Successive Not Acknowledge
// <0x0=> The successive receive NACK is disable.
// <0x1=> The successive receive NACK is enable.
// <i> Define whether NACK will be sent on parity error reception.
// <id> usart_dsnack
#ifndef CONF_SERCOM_6_USART_DSNACK
#define CONF_SERCOM_6_USART_DSNACK 0x0
#endif

// <o> ISO7816 Maximum Iterations<0-7>
// <i> Define the maximum number of retransmit iterations.
// <id> usart_maxiter
#ifndef CONF_SERCOM_6_USART_MAXITER
#define CONF_SERCOM_6_USART_MAXITER 0x7
#endif

// <o> ISO7816 Guard Time
// <0x2=> 2-bit times
// <0x3=> 3-bit times
// <0x4=> 4-bit times
// <0x5=> 5-bit times
// <0x6=> 6-bit times
// <0x7=> 7-bit times
// <i> Define the guard time.
// <id> usart_gtime
#ifndef CONF_SERCOM_6_USART_GTIME
#define CONF_SERCOM_6_USART_GTIME 0x2
#endif

// <q> Inverse transmission and reception enabled
// <i> Define inverse transmission and reception enabled.
// <id> usart_inverse_enabled
#ifndef CONF_SERCOM_6_USART_INVERSE_ENABLED
#define CONF_SERCOM_6_USART_INVERSE_ENABLED 0x0
#endif

#if (CONF_SERCOM_6_USART_INVERSE_ENABLED == 1)
#define CONF_SERCOM_6_USART_RXINV 0x1
#define CONF_SERCOM_6_USART_TXINV 0x1
#else
#define CONF_SERCOM_6_USART_RXINV 0x0
#define CONF_SERCOM_6_USART_TXINV 0x0
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_6_USART_ADVANCED_CONFIG
#define CONF_SERCOM_6_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_6_USART_RUNSTDBY
#define CONF_SERCOM_6_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_6_USART_IBON
#define CONF_SERCOM_6_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_6_USART_SFDE
#define CONF_SERCOM_6_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_6_USART_CLODEN
#define CONF_SERCOM_6_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_6_USART_MODE
#define CONF_SERCOM_6_USART_MODE 0x1
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_6_USART_DORD
#define CONF_SERCOM_6_USART_DORD 1
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_6_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_6_USART_DEBUG_STOP_MODE 0
#endif

// Does not do anything in USRT mode
#define CONF_SERCOM_6_USART_SAMPR 0x0
#define CONF_SERCOM_6_USART_SAMPA 0x0
#define CONF_SERCOM_6_USART_FRACTIONAL 0x0

// Does not do anything in UART mode
#define CONF_SERCOM_6_USART_CPOL 0

// Does not do anything in USRT mode
#define CONF_SERCOM_6_USART_ENC 0

// </e>

#ifndef CONF_SERCOM_6_USART_CMODE
#define CONF_SERCOM_6_USART_CMODE CONF_SERCOM_6_USART_ISO7816_PROTOCOL_T
#endif

/* RX is on PIN_PC16 */
#ifndef CONF_SERCOM_6_USART_RXPO
#define CONF_SERCOM_6_USART_RXPO 0
#endif

/* TX uses the same pin with RX */
#ifndef CONF_SERCOM_6_USART_TXPO
#define CONF_SERCOM_6_USART_TXPO 2
#endif

/* Set iso7816 mode */
#define CONF_SERCOM_6_USART_PMODE (CONF_SERCOM_6_USART_PARITY - 1)
#define CONF_SERCOM_6_USART_FORM 7

#if CONF_SERCOM_6_USART_CMODE == 0
// Calculate BAUD register value in UART mode
#if CONF_SERCOM_6_USART_SAMPR == 0
#ifndef CONF_SERCOM_6_USART_BAUD_RATE
#define CONF_SERCOM_6_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_6_USART_BAUD) / CONF_GCLK_SERCOM6_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_6_USART_SAMPR == 1
#ifndef CONF_SERCOM_6_USART_BAUD_RATE
#define CONF_SERCOM_6_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM6_CORE_FREQUENCY) / (CONF_SERCOM_6_USART_BAUD * 16)) - (CONF_SERCOM_6_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_6_USART_SAMPR == 2
#ifndef CONF_SERCOM_6_USART_BAUD_RATE
#define CONF_SERCOM_6_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_6_USART_BAUD) / CONF_GCLK_SERCOM6_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_6_USART_SAMPR == 3
#ifndef CONF_SERCOM_6_USART_BAUD_RATE
#define CONF_SERCOM_6_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM6_CORE_FREQUENCY) / (CONF_SERCOM_6_USART_BAUD * 8)) - (CONF_SERCOM_6_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_6_USART_SAMPR == 4
#ifndef CONF_SERCOM_6_USART_BAUD_RATE
#define CONF_SERCOM_6_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_6_USART_BAUD) / CONF_GCLK_SERCOM6_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

#elif CONF_SERCOM_6_USART_CMODE == 1
#ifndef CONF_SERCOM_6_USART_BAUD_RATE
// Calculate BAUD register value in USRT mode
#define CONF_SERCOM_6_USART_BAUD_RATE (CONF_GCLK_SERCOM6_CORE_FREQUENCY) / (2 * CONF_SERCOM_6_USART_BAUD) - 1
#endif

#ifndef CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_6_USART_RECEIVE_PULSE_LENGTH 0
#endif
#else
#error CMODE value for SERCOM 6 in USART mode not known
#endif

#include <peripheral_clk_config.h>

#ifndef CONF_SERCOM_7_USART_ENABLE
#define CONF_SERCOM_7_USART_ENABLE 1
#endif

// <h> Basic Configuration

// <q> Receive buffer enable
// <i> Enable input buffer in SERCOM module
// <id> usart_rx_enable
#ifndef CONF_SERCOM_7_USART_RXEN
#define CONF_SERCOM_7_USART_RXEN 1
#endif

// <q> Transmitt buffer enable
// <i> Enable output buffer in SERCOM module
// <id> usart_tx_enable
#ifndef CONF_SERCOM_7_USART_TXEN
#define CONF_SERCOM_7_USART_TXEN 1
#endif

// <o> Frame parity
// <0x0=>No parity
// <0x1=>Even parity
// <0x2=>Odd parity
// <i> Parity bit mode for USART frame
// <id> usart_parity
#ifndef CONF_SERCOM_7_USART_PARITY
#define CONF_SERCOM_7_USART_PARITY 0x0
#endif

// <o> Character Size
// <0x0=>8 bits
// <0x1=>9 bits
// <0x5=>5 bits
// <0x6=>6 bits
// <0x7=>7 bits
// <i> Data character size in USART frame
// <id> usart_character_size
#ifndef CONF_SERCOM_7_USART_CHSIZE
#define CONF_SERCOM_7_USART_CHSIZE 0x0
#endif

// <o> Stop Bit
// <0=>One stop bit
// <1=>Two stop bits
// <i> Number of stop bits in USART frame
// <id> usart_stop_bit
#ifndef CONF_SERCOM_7_USART_SBMODE
#define CONF_SERCOM_7_USART_SBMODE 0
#endif

// <o> Baud rate <1-6250000>
// <i> USART baud rate setting
// <id> usart_baud_rate
#ifndef CONF_SERCOM_7_USART_BAUD
#define CONF_SERCOM_7_USART_BAUD 921600
#endif

// </h>

// <e> Advanced configuration
// <id> usart_advanced
#ifndef CONF_SERCOM_7_USART_ADVANCED_CONFIG
#define CONF_SERCOM_7_USART_ADVANCED_CONFIG 0
#endif

// <q> Run in stand-by
// <i> Keep the module running in standby sleep mode
// <id> usart_arch_runstdby
#ifndef CONF_SERCOM_7_USART_RUNSTDBY
#define CONF_SERCOM_7_USART_RUNSTDBY 0
#endif

// <q> Immediate Buffer Overflow Notification
// <i> Controls when the BUFOVF status bit is asserted
// <id> usart_arch_ibon
#ifndef CONF_SERCOM_7_USART_IBON
#define CONF_SERCOM_7_USART_IBON 0
#endif

// <q> Start of Frame Detection Enable
// <i> Will wake the device from any sleep mode if usart_init and usart_enable was run priort to going to sleep. (receive buffer must be enabled)
// <id> usart_arch_sfde
#ifndef CONF_SERCOM_7_USART_SFDE
#define CONF_SERCOM_7_USART_SFDE 0
#endif

// <q> Collision Detection Enable
// <i> Collision detection enable
// <id> usart_arch_cloden
#ifndef CONF_SERCOM_7_USART_CLODEN
#define CONF_SERCOM_7_USART_CLODEN 0
#endif

// <o> Operating Mode
// <0x0=>USART with external clock
// <0x1=>USART with internal clock
// <i> Drive the shift register by an internal clock generated by the baud rate generator or an external clock supplied on the XCK pin.
// <id> usart_arch_clock_mode
#ifndef CONF_SERCOM_7_USART_MODE
#define CONF_SERCOM_7_USART_MODE 0x1
#endif

// <o> Sample Rate
// <0x0=>16x arithmetic
// <0x1=>16x fractional
// <0x2=>8x arithmetic
// <0x3=>8x fractional
// <0x4=>3x arithmetic
// <i> How many over-sampling bits used when sampling data state
// <id> usart_arch_sampr
#ifndef CONF_SERCOM_7_USART_SAMPR
#define CONF_SERCOM_7_USART_SAMPR 0x0
#endif

// <o> Sample Adjustment
// <0x0=>7-8-9 (3-4-5 8-bit over-sampling)
// <0x1=>9-10-11 (4-5-6 8-bit over-sampling)
// <0x2=>11-12-13 (5-6-7 8-bit over-sampling)
// <0x3=>13-14-15 (6-7-8 8-bit over-sampling)
// <i> Adjust which samples to use for data sampling in asynchronous mode
// <id> usart_arch_sampa
#ifndef CONF_SERCOM_7_USART_SAMPA
#define CONF_SERCOM_7_USART_SAMPA 0x0
#endif

// <o> Fractional Part <0-7>
// <i> Fractional part of the baud rate if baud rate generator is in fractional mode
// <id> usart_arch_fractional
#ifndef CONF_SERCOM_7_USART_FRACTIONAL
#define CONF_SERCOM_7_USART_FRACTIONAL 0x0
#endif

// <o> Data Order
// <0=>MSB is transmitted first
// <1=>LSB is transmitted first
// <i> Data order of the data bits in the frame
// <id> usart_arch_dord
#ifndef CONF_SERCOM_7_USART_DORD
#define CONF_SERCOM_7_USART_DORD 1
#endif

// Does not do anything in UART mode
#define CONF_SERCOM_7_USART_CPOL 0

// <o> Encoding Format
// <0=>No encoding
// <1=>IrDA encoded
// <id> usart_arch_enc
#ifndef CONF_SERCOM_7_USART_ENC
#define CONF_SERCOM_7_USART_ENC 0
#endif

// <o> LIN Slave Enable
// <i> Break Character Detection and Auto-Baud/LIN Slave Enable.
// <i> Additional setting needed: 16x sample rate using fractional baud rate generation (CTRLA.SAMPR = 1).
// <0=>Disable
// <1=>Enable
// <id> usart_arch_lin_slave_enable
#ifndef CONF_SERCOM_7_USART_LIN_SLAVE_ENABLE
#define CONF_SERCOM_7_USART_LIN_SLAVE_ENABLE 0
#endif

// <o> Debug Stop Mode
// <i> Behavior of the baud-rate generator when CPU is halted by external debugger.
// <0=>Keep running
// <1=>Halt
// <id> usart_arch_dbgstop
#ifndef CONF_SERCOM_7_USART_DEBUG_STOP_MODE
#define CONF_SERCOM_7_USART_DEBUG_STOP_MODE 0
#endif

// </e>

#ifndef CONF_SERCOM_7_USART_INACK
#define CONF_SERCOM_7_USART_INACK 0x0
#endif

#ifndef CONF_SERCOM_7_USART_DSNACK
#define CONF_SERCOM_7_USART_DSNACK 0x0
#endif

#ifndef CONF_SERCOM_7_USART_MAXITER
#define CONF_SERCOM_7_USART_MAXITER 0x7
#endif

#ifndef CONF_SERCOM_7_USART_GTIME
#define CONF_SERCOM_7_USART_GTIME 0x2
#endif

#define CONF_SERCOM_7_USART_RXINV 0x0
#define CONF_SERCOM_7_USART_TXINV 0x0

#ifndef CONF_SERCOM_7_USART_CMODE
#define CONF_SERCOM_7_USART_CMODE 0
#endif

#ifndef CONF_SERCOM_7_USART_RXPO
#define CONF_SERCOM_7_USART_RXPO 1 /* RX is on PIN_PB31 */
#endif

#ifndef CONF_SERCOM_7_USART_TXPO
#define CONF_SERCOM_7_USART_TXPO 0 /* TX is on PIN_PB30 */
#endif

/* Set correct parity settings in register interface based on PARITY setting */
#if CONF_SERCOM_7_USART_LIN_SLAVE_ENABLE == 1
#if CONF_SERCOM_7_USART_PARITY == 0
#define CONF_SERCOM_7_USART_PMODE 0
#define CONF_SERCOM_7_USART_FORM 4
#else
#define CONF_SERCOM_7_USART_PMODE CONF_SERCOM_7_USART_PARITY - 1
#define CONF_SERCOM_7_USART_FORM 5
#endif
#else /* #if CONF_SERCOM_7_USART_LIN_SLAVE_ENABLE == 0 */
#if CONF_SERCOM_7_USART_PARITY == 0
#define CONF_SERCOM_7_USART_PMODE 0
#define CONF_SERCOM_7_USART_FORM 0
#else
#define CONF_SERCOM_7_USART_PMODE CONF_SERCOM_7_USART_PARITY - 1
#define CONF_SERCOM_7_USART_FORM 1
#endif
#endif

// Calculate BAUD register value in UART mode
#if CONF_SERCOM_7_USART_SAMPR == 0
#ifndef CONF_SERCOM_7_USART_BAUD_RATE
#define CONF_SERCOM_7_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 16.0f * CONF_SERCOM_7_USART_BAUD) / CONF_GCLK_SERCOM7_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_7_USART_SAMPR == 1
#ifndef CONF_SERCOM_7_USART_BAUD_RATE
#define CONF_SERCOM_7_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM7_CORE_FREQUENCY) / (CONF_SERCOM_7_USART_BAUD * 16)) - (CONF_SERCOM_7_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_7_USART_SAMPR == 2
#ifndef CONF_SERCOM_7_USART_BAUD_RATE
#define CONF_SERCOM_7_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 8.0f * CONF_SERCOM_7_USART_BAUD) / CONF_GCLK_SERCOM7_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_7_USART_SAMPR == 3
#ifndef CONF_SERCOM_7_USART_BAUD_RATE
#define CONF_SERCOM_7_USART_BAUD_RATE                                                                                  \
	((CONF_GCLK_SERCOM7_CORE_FREQUENCY) / (CONF_SERCOM_7_USART_BAUD * 8)) - (CONF_SERCOM_7_USART_FRACTIONAL / 8)
#endif
#ifndef CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH 0
#endif
#elif CONF_SERCOM_7_USART_SAMPR == 4
#ifndef CONF_SERCOM_7_USART_BAUD_RATE
#define CONF_SERCOM_7_USART_BAUD_RATE                                                                                  \
	65536 - ((65536 * 3.0f * CONF_SERCOM_7_USART_BAUD) / CONF_GCLK_SERCOM7_CORE_FREQUENCY)
#endif
#ifndef CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH
#define CONF_SERCOM_7_USART_RECEIVE_PULSE_LENGTH 0
#endif
#endif

// <<< end of configuration section >>>

#endif // HPL_SERCOM_CONFIG_H
