/* Iridium AMBE vocoder - ECC tables */

/* (C) 2015 by Sylvain Munaut <tnt@246tNt.com>
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __OSMO_IR77_AMBE_ECC_TABLES_H__
#define __OSMO_IR77_AMBE_ECC_TABLES_H__

/*! \addtogroup codec_private
 *  @{
 */

/*! \file codec/ecc_tables.h
 *  \brief Iridium AMBE vocoder ECC tables
 */

/*! \brief Golay 23,12 - syndrome table */
static const uint32_t _golay23_syn_tbl[] = {
	0x63a, 0x31d, 0x7b4, 0x3da, 0x1ed, 0x6cc,
	0x366, 0x1b3, 0x6e3, 0x54b, 0x49f, 0x475,
};

/*! \brief Golay 24,12 - syndrome table */
static const uint32_t _golay24_syn_tbl[] = {
	0xc75, 0x63b, 0xf68, 0x7b4, 0x3da, 0xd99,
	0x6cd, 0x367, 0xdc6, 0xa97, 0x93e, 0x8eb,
};

/*! \brief Golay 23,12 - Decoding table (idx=syndrome, value=error_mask) */
static const uint32_t _golay23_dec_tbl[] = {
	0x000000, 0x000001, 0x000002, 0x000003,
	0x000004, 0x000005, 0x000006, 0x000007,
	0x000008, 0x000009, 0x00000a, 0x00000b,
	0x00000c, 0x00000d, 0x00000e, 0x024020,
	0x000010, 0x000011, 0x000012, 0x000013,
	0x000014, 0x000015, 0x000016, 0x412000,
	0x000018, 0x000019, 0x00001a, 0x180800,
	0x00001c, 0x200300, 0x048040, 0x001480,
	0x000020, 0x000021, 0x000022, 0x000023,
	0x000024, 0x000025, 0x000026, 0x024008,
	0x000028, 0x000029, 0x00002a, 0x024004,
	0x00002c, 0x024002, 0x024001, 0x024000,
	0x000030, 0x000031, 0x000032, 0x008180,
	0x000034, 0x000c40, 0x301000, 0x0c0200,
	0x000038, 0x043000, 0x400600, 0x210040,
	0x090080, 0x508000, 0x002900, 0x024010,
	0x000040, 0x000041, 0x000042, 0x000043,
	0x000044, 0x000045, 0x000046, 0x280080,
	0x000048, 0x000049, 0x00004a, 0x002500,
	0x00004c, 0x111000, 0x048010, 0x400a00,
	0x000050, 0x000051, 0x000052, 0x021200,
	0x000054, 0x000c20, 0x048008, 0x104100,
	0x000058, 0x404080, 0x048004, 0x210020,
	0x048002, 0x0a2000, 0x048000, 0x048001,
	0x000060, 0x000061, 0x000062, 0x540000,
	0x000064, 0x000c10, 0x010300, 0x00b000,
	0x000068, 0x088200, 0x001880, 0x210010,
	0x602000, 0x040180, 0x180400, 0x024040,
	0x000070, 0x000c04, 0x086000, 0x210008,
	0x000c01, 0x000c00, 0x420080, 0x000c02,
	0x120100, 0x210002, 0x210001, 0x210000,
	0x005200, 0x000c08, 0x048020, 0x210004,
	0x000080, 0x000081, 0x000082, 0x000083,
	0x000084, 0x000085, 0x000086, 0x280040,
	0x000088, 0x000089, 0x00008a, 0x050200,
	0x00008c, 0x00a800, 0x500100, 0x001410,
	0x000090, 0x000091, 0x000092, 0x008120,
	0x000094, 0x160000, 0x004a00, 0x001408,
	0x000098, 0x404040, 0x222000, 0x001404,
	0x090020, 0x001402, 0x001401, 0x001400,
	0x0000a0, 0x0000a1, 0x0000a2, 0x008110,
	0x0000a4, 0x401200, 0x042400, 0x110800,
	0x0000a8, 0x300400, 0x001840, 0x482000,
	0x090010, 0x040140, 0x208200, 0x024080,
	0x0000b0, 0x008102, 0x008101, 0x008100,
	0x090008, 0x206000, 0x420040, 0x008104,
	0x090004, 0x020a00, 0x144000, 0x008108,
	0x090000, 0x090001, 0x090002, 0x001420,
	0x0000c0, 0x0000c1, 0x0000c2, 0x280004,
	0x0000c4, 0x280002, 0x280001, 0x280000,
	0x0000c8, 0x404010, 0x001820, 0x128000,
	0x020600, 0x040120, 0x016000, 0x280008,
	0x0000d0, 0x404008, 0x110400, 0x042800,
	0x003100, 0x018200, 0x420020, 0x280010,
	0x404001, 0x404000, 0x080300, 0x404002,
	0x300800, 0x404004, 0x048080, 0x001440,
	0x0000e0, 0x032000, 0x001808, 0x004600,
	0x10c000, 0x040108, 0x420010, 0x280020,
	0x001802, 0x040104, 0x001800, 0x001801,
	0x040101, 0x040100, 0x001804, 0x040102,
	0x240200, 0x181000, 0x420004, 0x008140,
	0x420002, 0x000c80, 0x420000, 0x420001,
	0x00a400, 0x404020, 0x001810, 0x210080,
	0x090040, 0x040110, 0x420008, 0x102200,
	0x000100, 0x000101, 0x000102, 0x000103,
	0x000104, 0x000105, 0x000106, 0x041800,
	0x000108, 0x000109, 0x00010a, 0x002440,
	0x00010c, 0x200210, 0x500080, 0x098000,
	0x000110, 0x000111, 0x000112, 0x0080a0,
	0x000114, 0x200208, 0x0a0400, 0x104040,
	0x000118, 0x200204, 0x015000, 0x460000,
	0x200201, 0x200200, 0x002820, 0x200202,
	0x000120, 0x000121, 0x000122, 0x008090,
	0x000124, 0x182000, 0x010240, 0x600400,
	0x000128, 0x410800, 0x2c0000, 0x101200,
	0x009400, 0x0400c0, 0x002810, 0x024100,
	0x000130, 0x008082, 0x008081, 0x008080,
	0x444000, 0x031000, 0x002808, 0x008084,
	0x120040, 0x084400, 0x002804, 0x008088,
	0x002802, 0x200220, 0x002800, 0x002801,
	0x000140, 0x000141, 0x000142, 0x002408,
	0x000144, 0x428000, 0x010220, 0x104010,
	0x000148, 0x002402, 0x002401, 0x002400,
	0x084800, 0x0400a0, 0x221000, 0x002404,
	0x000150, 0x0d0000, 0x600800, 0x104004,
	0x003080, 0x104002, 0x104001, 0x104000,
	0x120020, 0x009800, 0x080280, 0x002410,
	0x410400, 0x200240, 0x048100, 0x104008,
	0x000160, 0x205000, 0x010204, 0x0a0800,
	0x010202, 0x040088, 0x010200, 0x010201,
	0x120010, 0x040084, 0x40c000, 0x002420,
	0x040081, 0x040080, 0x010208, 0x040082,
	0x120008, 0x402200, 0x041400, 0x0080c0,
	0x288000, 0x000d00, 0x010210, 0x104020,
	0x120000, 0x120001, 0x120002, 0x210100,
	0x120004, 0x040090, 0x002840, 0x481000,
	0x000180, 0x000181, 0x000182, 0x008030,
	0x000184, 0x014400, 0x500008, 0x022200,
	0x000188, 0x0a1000, 0x500004, 0x204800,
	0x500002, 0x040060, 0x500000, 0x500001,
	0x000190, 0x008022, 0x008021, 0x008020,
	0x003040, 0x480800, 0x250000, 0x008024,
	0x040c00, 0x112000, 0x080240, 0x008028,
	0x02c000, 0x200280, 0x500010, 0x001500,
	0x0001a0, 0x008012, 0x008011, 0x008010,
	0x220800, 0x040048, 0x085000, 0x008014,
	0x006200, 0x040044, 0x030400, 0x008018,
	0x040041, 0x040040, 0x500020, 0x040042,
	0x008003, 0x008002, 0x008001, 0x008000,
	0x100600, 0x008006, 0x008005, 0x008004,
	0x601000, 0x00800a, 0x008009, 0x008008,
	0x090100, 0x040050, 0x002880, 0x00800c,
	0x0001c0, 0x100a00, 0x064000, 0x411000,
	0x003010, 0x040028, 0x008c00, 0x280100,
	0x218000, 0x040024, 0x080210, 0x002480,
	0x040021, 0x040020, 0x500040, 0x040022,
	0x003004, 0x220400, 0x080208, 0x008060,
	0x003000, 0x003001, 0x003002, 0x104080,
	0x080202, 0x404100, 0x080200, 0x080201,
	0x003008, 0x040030, 0x080204, 0x030800,
	0x480400, 0x04000c, 0x302000, 0x008050,
	0x040009, 0x040008, 0x010280, 0x04000a,
	0x040005, 0x040004, 0x001900, 0x040006,
	0x040001, 0x040000, 0x040003, 0x040002,
	0x014800, 0x008042, 0x008041, 0x008040,
	0x003020, 0x040018, 0x420100, 0x008044,
	0x120080, 0x040014, 0x080220, 0x008048,
	0x040011, 0x040010, 0x204400, 0x040012,
	0x000200, 0x000201, 0x000202, 0x000203,
	0x000204, 0x000205, 0x000206, 0x108400,
	0x000208, 0x000209, 0x00020a, 0x050080,
	0x00020c, 0x200110, 0x083000, 0x400840,
	0x000210, 0x000211, 0x000212, 0x021040,
	0x000214, 0x200108, 0x004880, 0x0c0020,
	0x000218, 0x200104, 0x400420, 0x00e000,
	0x200101, 0x200100, 0x130000, 0x200102,
	0x000220, 0x000221, 0x000222, 0x202800,
	0x000224, 0x401080, 0x010140, 0x0c0010,
	0x000228, 0x088040, 0x400410, 0x101100,
	0x140800, 0x012400, 0x208080, 0x024200,
	0x000230, 0x114000, 0x400408, 0x0c0004,
	0x02a000, 0x0c0002, 0x0c0001, 0x0c0000,
	0x400402, 0x020880, 0x400400, 0x400401,
	0x005040, 0x200120, 0x400404, 0x0c0008,
	0x000240, 0x000241, 0x000242, 0x021010,
	0x000244, 0x046000, 0x010120, 0x400808,
	0x000248, 0x088020, 0x304000, 0x400804,
	0x020480, 0x400802, 0x400801, 0x400800,
	0x000250, 0x021002, 0x021001, 0x021000,
	0x580000, 0x018080, 0x202400, 0x021004,
	0x012800, 0x140400, 0x080180, 0x021008,
	0x005020, 0x200140, 0x048200, 0x400810,
	0x000260, 0x088008, 0x010104, 0x004480,
	0x010102, 0x320000, 0x010100, 0x010101,
	0x088001, 0x088000, 0x062000, 0x088002,
	0x005010, 0x088004, 0x010108, 0x400820,
	0x240080, 0x402100, 0x108800, 0x021020,
	0x005008, 0x000e00, 0x010110, 0x0c0040,
	0x005004, 0x088010, 0x400440, 0x210200,
	0x005000, 0x005001, 0x005002, 0x102080,
	0x000280, 0x000281, 0x000282, 0x050008,
	0x000284, 0x401020, 0x004810, 0x022100,
	0x000288, 0x050002, 0x050001, 0x050000,
	0x020440, 0x184000, 0x208020, 0x050004,
	0x000290, 0x082400, 0x004804, 0x700000,
	0x004802, 0x018040, 0x004800, 0x004801,
	0x109000, 0x020820, 0x080140, 0x050010,
	0x442000, 0x200180, 0x004808, 0x001600,
	0x0002a0, 0x401004, 0x1a0000, 0x004440,
	0x401001, 0x401000, 0x208008, 0x401002,
	0x006100, 0x020810, 0x208004, 0x050020,
	0x208002, 0x401008, 0x208000, 0x208001,
	0x240040, 0x020808, 0x013000, 0x008300,
	0x100500, 0x401010, 0x004820, 0x0c0080,
	0x020801, 0x020800, 0x400480, 0x020802,
	0x090200, 0x020804, 0x208010, 0x102040,
	0x0002c0, 0x100900, 0x40a000, 0x004420,
	0x020408, 0x018010, 0x141000, 0x280200,
	0x020404, 0x203000, 0x080110, 0x050040,
	0x020400, 0x020401, 0x020402, 0x400880,
	0x240020, 0x018004, 0x080108, 0x021080,
	0x018001, 0x018000, 0x004840, 0x018002,
	0x080102, 0x404200, 0x080100, 0x080101,
	0x020410, 0x018008, 0x080104, 0x102020,
	0x240010, 0x004402, 0x004401, 0x004400,
	0x082800, 0x401040, 0x010180, 0x004404,
	0x510000, 0x088080, 0x001a00, 0x004408,
	0x020420, 0x040300, 0x208040, 0x102010,
	0x240000, 0x240001, 0x240002, 0x004410,
	0x240004, 0x018020, 0x420200, 0x102008,
	0x240008, 0x020840, 0x080120, 0x102004,
	0x005080, 0x102002, 0x102001, 0x102000,
	0x000300, 0x000301, 0x000302, 0x484000,
	0x000304, 0x200018, 0x010060, 0x022080,
	0x000308, 0x200014, 0x028800, 0x101020,
	0x200011, 0x200010, 0x044400, 0x200012,
	0x000310, 0x20000c, 0x142000, 0x010c00,
	0x200009, 0x200008, 0x409000, 0x20000a,
	0x200005, 0x200004, 0x0800c0, 0x200006,
	0x200001, 0x200000, 0x200003, 0x200002,
	0x000320, 0x060400, 0x010044, 0x101008,
	0x010042, 0x00c800, 0x010040, 0x010041,
	0x006080, 0x101002, 0x101001, 0x101000,
	0x4a0000, 0x200030, 0x010048, 0x101004,
	0x081800, 0x402040, 0x224000, 0x008280,
	0x100480, 0x200028, 0x010050, 0x0c0100,
	0x058000, 0x200024, 0x400500, 0x101010,
	0x200021, 0x200020, 0x002a00, 0x200022,
	0x000340, 0x100880, 0x010024, 0x248000,
	0x010022, 0x081400, 0x010020, 0x010021,
	0x441000, 0x034000, 0x080090, 0x002600,
	0x10a000, 0x200050, 0x010028, 0x400900,
	0x00c400, 0x402020, 0x080088, 0x021100,
	0x060800, 0x200048, 0x010030, 0x104200,
	0x080082, 0x200044, 0x080080, 0x080081,
	0x200041, 0x200040, 0x080084, 0x200042,
	0x010006, 0x402010, 0x010004, 0x010005,
	0x010002, 0x010003, 0x010000, 0x010001,
	0x200c00, 0x088100, 0x01000c, 0x101040,
	0x01000a, 0x040280, 0x010008, 0x010009,
	0x402001, 0x402000, 0x010014, 0x402002,
	0x010012, 0x402004, 0x010010, 0x010011,
	0x120200, 0x402008, 0x0800a0, 0x044800,
	0x005100, 0x200060, 0x010018, 0x028400,
	0x000380, 0x100840, 0x201400, 0x022004,
	0x0c8000, 0x022002, 0x022001, 0x022000,
	0x006020, 0x408400, 0x080050, 0x050100,
	0x011800, 0x200090, 0x500200, 0x022008,
	0x430000, 0x045000, 0x080048, 0x008220,
	0x100420, 0x200088, 0x004900, 0x022010,
	0x080042, 0x200084, 0x080040, 0x080041,
	0x200081, 0x200080, 0x080044, 0x200082,
	0x006008, 0x290000, 0x440800, 0x008210,
	0x100410, 0x401100, 0x0100c0, 0x022020,
	0x006000, 0x006001, 0x006002, 0x101080,
	0x006004, 0x040240, 0x208100, 0x080c00,
	0x100404, 0x008202, 0x008201, 0x008200,
	0x100400, 0x100401, 0x100402, 0x008204,
	0x006010, 0x020900, 0x080060, 0x008208,
	0x100408, 0x2000a0, 0x061000, 0x414000,
	0x100801, 0x100800, 0x080018, 0x100802,
	0x604000, 0x100804, 0x0100a0, 0x022040,
	0x080012, 0x100808, 0x080010, 0x080011,
	0x020500, 0x040220, 0x080014, 0x00d000,
	0x08000a, 0x100810, 0x080008, 0x080009,
	0x003200, 0x018100, 0x08000c, 0x440400,
	0x080002, 0x080003, 0x080000, 0x080001,
	0x080006, 0x2000c0, 0x080004, 0x080005,
	0x029000, 0x100820, 0x010084, 0x004500,
	0x010082, 0x040208, 0x010080, 0x010081,
	0x006040, 0x040204, 0x080030, 0x620000,
	0x040201, 0x040200, 0x010088, 0x040202,
	0x240100, 0x402080, 0x080028, 0x008240,
	0x100440, 0x0a4000, 0x010090, 0x201800,
	0x080022, 0x011400, 0x080020, 0x080021,
	0x408800, 0x040210, 0x080024, 0x102100,
	0x000400, 0x000401, 0x000402, 0x000403,
	0x000404, 0x000405, 0x000406, 0x108200,
	0x000408, 0x000409, 0x00040a, 0x002140,
	0x00040c, 0x4c0000, 0x210800, 0x001090,
	0x000410, 0x000411, 0x000412, 0x244000,
	0x000414, 0x000860, 0x0a0100, 0x001088,
	0x000418, 0x038000, 0x400220, 0x001084,
	0x106000, 0x001082, 0x001081, 0x001080,
	0x000420, 0x000421, 0x000422, 0x091000,
	0x000424, 0x000850, 0x042080, 0x600100,
	0x000428, 0x300080, 0x400210, 0x048800,
	0x009100, 0x012200, 0x180040, 0x024400,
	0x000430, 0x000844, 0x400208, 0x122000,
	0x000841, 0x000840, 0x01c000, 0x000842,
	0x400202, 0x084100, 0x400200, 0x400201,
	0x260000, 0x000848, 0x400204, 0x0010a0,
	0x000440, 0x000441, 0x000442, 0x002108,
	0x000444, 0x000830, 0x405000, 0x070000,
	0x000448, 0x002102, 0x002101, 0x002100,
	0x020280, 0x20c000, 0x180020, 0x002104,
	0x000450, 0x000824, 0x110080, 0x488000,
	0x000821, 0x000820, 0x202200, 0x000822,
	0x281000, 0x140200, 0x024800, 0x002110,
	0x410100, 0x000828, 0x048400, 0x0010c0,
	0x000460, 0x000814, 0x228000, 0x004280,
	0x000811, 0x000810, 0x180008, 0x000812,
	0x054000, 0x421000, 0x180004, 0x002120,
	0x180002, 0x000818, 0x180000, 0x180001,
	0x000805, 0x000804, 0x041100, 0x000806,
	0x000801, 0x000800, 0x000803, 0x000802,
	0x00a080, 0x00080c, 0x400240, 0x210400,
	0x000809, 0x000808, 0x180010, 0x00080a,
	0x000480, 0x000481, 0x000482, 0x420800,
	0x000484, 0x014100, 0x042020, 0x001018,
	0x000488, 0x300020, 0x08c000, 0x001014,
	0x020240, 0x001012, 0x001011, 0x001010,
	0x000490, 0x082200, 0x110040, 0x00100c,
	0x608000, 0x00100a, 0x001009, 0x001008,
	0x040900, 0x001006, 0x001005, 0x001004,
	0x001003, 0x001002, 0x001001, 0x001000,
	0x0004a0, 0x300008, 0x042004, 0x004240,
	0x042002, 0x0a8000, 0x042000, 0x042001,
	0x300001, 0x300000, 0x030100, 0x300002,
	0x404800, 0x300004, 0x042008, 0x001030,
	0x025000, 0x450000, 0x280800, 0x008500,
	0x100300, 0x0008c0, 0x042010, 0x001028,
	0x00a040, 0x300010, 0x400280, 0x001024,
	0x090400, 0x001022, 0x001021, 0x001020,
	0x0004c0, 0x049000, 0x110010, 0x004220,
	0x020208, 0x502000, 0x008900, 0x280400,
	0x020204, 0x090800, 0x640000, 0x002180,
	0x020200, 0x020201, 0x020202, 0x001050,
	0x110002, 0x220100, 0x110000, 0x110001,
	0x0c4000, 0x0008a0, 0x110004, 0x001048,
	0x00a020, 0x404400, 0x110008, 0x001044,
	0x020210, 0x001042, 0x001041, 0x001040,
	0x480100, 0x004202, 0x004201, 0x004200,
	0x211000, 0x000890, 0x042040, 0x004204,
	0x00a010, 0x300040, 0x001c00, 0x004208,
	0x020220, 0x040500, 0x180080, 0x418000,
	0x00a008, 0x000884, 0x110020, 0x004210,
	0x000881, 0x000880, 0x420400, 0x000882,
	0x00a000, 0x00a001, 0x00a002, 0x0e0000,
	0x00a004, 0x000888, 0x204100, 0x001060,
	0x000500, 0x000501, 0x000502, 0x002048,
	0x000504, 0x014080, 0x0a0010, 0x600020,
	0x000508, 0x002042, 0x002041, 0x002040,
	0x009020, 0x120800, 0x044200, 0x002044,
	0x000510, 0x501000, 0x0a0004, 0x010a00,
	0x0a0002, 0x04a000, 0x0a0000, 0x0a0001,
	0x040880, 0x084020, 0x308000, 0x002050,
	0x410040, 0x200600, 0x0a0008, 0x001180,
	0x000520, 0x060200, 0x104800, 0x600004,
	0x009008, 0x600002, 0x600001, 0x600000,
	0x009004, 0x084010, 0x030080, 0x002060,
	0x009000, 0x009001, 0x009002, 0x600008,
	0x212000, 0x084008, 0x041040, 0x008480,
	0x100280, 0x000940, 0x0a0020, 0x600010,
	0x084001, 0x084000, 0x400300, 0x084002,
	0x009010, 0x084004, 0x002c00, 0x150000,
	0x000540, 0x00200a, 0x002009, 0x002008,
	0x340000, 0x081200, 0x008880, 0x00200c,
	0x002003, 0x002002, 0x002001, 0x002000,
	0x410010, 0x002006, 0x002005, 0x002004,
	0x00c200, 0x220080, 0x041020, 0x002018,
	0x410008, 0x000920, 0x0a0040, 0x104400,
	0x410004, 0x002012, 0x002011, 0x002010,
	0x410000, 0x410001, 0x410002, 0x002014,
	0x480080, 0x118000, 0x041010, 0x002028,
	0x026000, 0x000910, 0x010600, 0x600040,
	0x200a00, 0x002022, 0x002021, 0x002020,
	0x009040, 0x040480, 0x180100, 0x002024,
	0x041002, 0x000904, 0x041000, 0x041001,
	0x000901, 0x000900, 0x041004, 0x000902,
	0x120400, 0x084040, 0x041008, 0x002030,
	0x410020, 0x000908, 0x204080, 0x028200,
	0x000580, 0x014004, 0x201200, 0x1c0000,
	0x014001, 0x014000, 0x008840, 0x014002,
	0x040810, 0x408200, 0x030020, 0x0020c0,
	0x282000, 0x014008, 0x500400, 0x001110,
	0x040808, 0x220040, 0x406000, 0x008420,
	0x100220, 0x014010, 0x0a0080, 0x001108,
	0x040800, 0x040801, 0x040802, 0x001104,
	0x040804, 0x001102, 0x001101, 0x001100,
	0x480040, 0x003800, 0x030008, 0x008410,
	0x100210, 0x014020, 0x042100, 0x600080,
	0x030002, 0x300100, 0x030000, 0x030001,
	0x009080, 0x040440, 0x030004, 0x080a00,
	0x100204, 0x008402, 0x008401, 0x008400,
	0x100200, 0x100201, 0x100202, 0x008404,
	0x040820, 0x084080, 0x030010, 0x008408,
	0x100208, 0x422000, 0x204040, 0x001120,
	0x480020, 0x220010, 0x008804, 0x002088,
	0x008802, 0x014040, 0x008800, 0x008801,
	0x105000, 0x002082, 0x002081, 0x002080,
	0x020300, 0x040420, 0x008808, 0x002084,
	0x220001, 0x220000, 0x110100, 0x220002,
	0x003400, 0x220004, 0x008810, 0x440200,
	0x040840, 0x220008, 0x080600, 0x002090,
	0x410080, 0x188000, 0x204020, 0x001140,
	0x480000, 0x480001, 0x480002, 0x004300,
	0x480004, 0x040408, 0x008820, 0x121000,
	0x480008, 0x040404, 0x030040, 0x0020a0,
	0x040401, 0x040400, 0x204010, 0x040402,
	0x480010, 0x220020, 0x041080, 0x008440,
	0x100240, 0x000980, 0x204008, 0x092000,
	0x00a100, 0x011200, 0x204004, 0x500800,
	0x204002, 0x040410, 0x204000, 0x204001,
	0x000600, 0x000601, 0x000602, 0x108004,
	0x000604, 0x108002, 0x108001, 0x108000,
	0x000608, 0x005800, 0x400030, 0x2a0000,
	0x0200c0, 0x012020, 0x044100, 0x108008,
	0x000610, 0x082080, 0x400028, 0x010900,
	0x051000, 0x424000, 0x202040, 0x108010,
	0x400022, 0x140040, 0x400020, 0x400021,
	0x088800, 0x200500, 0x400024, 0x001280,
	0x000620, 0x060100, 0x400018, 0x0040c0,
	0x284000, 0x012008, 0x021800, 0x108020,
	0x400012, 0x012004, 0x400010, 0x400011,
	0x012001, 0x012000, 0x400014, 0x012002,
	0x40000a, 0x209000, 0x400008, 0x400009,
	0x100180, 0x000a40, 0x40000c, 0x0c0400,
	0x400002, 0x400003, 0x400000, 0x400001,
	0x400006, 0x012010, 0x400004, 0x400005,
	0x000640, 0x610000, 0x0c0800, 0x0040a0,
	0x020088, 0x081100, 0x202010, 0x108040,
	0x020084, 0x140010, 0x019000, 0x002300,
	0x020080, 0x020081, 0x020082, 0x400c00,
	0x00c100, 0x140008, 0x202004, 0x021400,
	0x202002, 0x000a20, 0x202000, 0x202001,
	0x140001, 0x140000, 0x400060, 0x140002,
	0x020090, 0x140004, 0x202008, 0x094000,
	0x103000, 0x004082, 0x004081, 0x004080,
	0x448000, 0x000a10, 0x010500, 0x004084,
	0x200900, 0x088400, 0x400050, 0x004088,
	0x0200a0, 0x012040, 0x180200, 0x241000,
	0x0b0000, 0x000a04, 0x400048, 0x004090,
	0x000a01, 0x000a00, 0x202020, 0x000a02,
	0x400042, 0x140020, 0x400040, 0x400041,
	0x005400, 0x000a08, 0x400044, 0x028100,
	0x000680, 0x082010, 0x201100, 0x004060,
	0x020048, 0x240800, 0x490000, 0x108080,
	0x020044, 0x408100, 0x102800, 0x050400,
	0x020040, 0x020041, 0x020042, 0x001210,
	0x082001, 0x082000, 0x068000, 0x082002,
	0x100120, 0x082004, 0x004c00, 0x001208,
	0x214000, 0x082008, 0x4000a0, 0x001204,
	0x020050, 0x001202, 0x001201, 0x001200,
	0x018800, 0x004042, 0x004041, 0x004040,
	0x100110, 0x401400, 0x042200, 0x004044,
	0x0c1000, 0x300200, 0x400090, 0x004048,
	0x020060, 0x012080, 0x208400, 0x080900,
	0x100104, 0x082020, 0x400088, 0x004050,
	0x100100, 0x100101, 0x100102, 0x230000,
	0x400082, 0x020c00, 0x400080, 0x400081,
	0x100108, 0x04c000, 0x400084, 0x001220,
	0x02000c, 0x004022, 0x004021, 0x004020,
	0x020008, 0x020009, 0x02000a, 0x004024,
	0x020004, 0x020005, 0x020006, 0x004028,
	0x020000, 0x020001, 0x020002, 0x020003,
	0x401800, 0x082040, 0x110200, 0x004030,
	0x020018, 0x018400, 0x202080, 0x440100,
	0x020014, 0x140080, 0x080500, 0x208800,
	0x020010, 0x020011, 0x020012, 0x001240,
	0x004003, 0x004002, 0x004001, 0x004000,
	0x020028, 0x004006, 0x004005, 0x004004,
	0x020024, 0x00400a, 0x004009, 0x004008,
	0x020020, 0x020021, 0x020022, 0x00400c,
	0x240400, 0x004012, 0x004011, 0x004010,
	0x100140, 0x000a80, 0x089000, 0x004014,
	0x00a200, 0x011100, 0x4000c0, 0x004018,
	0x020030, 0x680000, 0x050800, 0x102400,
	0x000700, 0x060020, 0x201080, 0x010810,
	0x402800, 0x081040, 0x044008, 0x108100,
	0x190000, 0x408080, 0x044004, 0x002240,
	0x044002, 0x200410, 0x044000, 0x044001,
	0x00c040, 0x010802, 0x010801, 0x010800,
	0x1000a0, 0x200408, 0x0a0200, 0x010804,
	0x023000, 0x200404, 0x400120, 0x010808,
	0x200401, 0x200400, 0x044010, 0x200402,
	0x060001, 0x060000, 0x08a000, 0x060002,
	0x100090, 0x060004, 0x010440, 0x600200,
	0x200840, 0x060008, 0x400110, 0x101400,
	0x009200, 0x012100, 0x044020, 0x080880,
	0x100084, 0x060010, 0x400108, 0x010820,
	0x100080, 0x100081, 0x100082, 0x007000,
	0x400102, 0x084200, 0x400100, 0x400101,
	0x100088, 0x200420, 0x400104, 0x028040,
	0x00c010, 0x081004, 0x520000, 0x002208,
	0x081001, 0x081000, 0x010420, 0x081002,
	0x200820, 0x002202, 0x002201, 0x002200,
	0x020180, 0x081008, 0x044040, 0x002204,
	0x00c000, 0x00c001, 0x00c002, 0x010840,
	0x00c004, 0x081010, 0x202100, 0x440080,
	0x00c008, 0x140100, 0x080480, 0x002210,
	0x410200, 0x200440, 0x101800, 0x028020,
	0x200808, 0x060040, 0x010404, 0x004180,
	0x010402, 0x081020, 0x010400, 0x010401,
	0x200800, 0x200801, 0x200802, 0x002220,
	0x200804, 0x504000, 0x010408, 0x028010,
	0x00c020, 0x402400, 0x041200, 0x380000,
	0x1000c0, 0x000b00, 0x010410, 0x028008,
	0x200810, 0x011080, 0x400140, 0x028004,
	0x0c2000, 0x028002, 0x028001, 0x028000,
	0x201002, 0x408008, 0x201000, 0x201001,
	0x100030, 0x014200, 0x201004, 0x022400,
	0x408001, 0x408000, 0x201008, 0x408002,
	0x020140, 0x408004, 0x044080, 0x080820,
	0x100024, 0x082100, 0x201010, 0x010880,
	0x100020, 0x100021, 0x100022, 0x440040,
	0x040a00, 0x408010, 0x080440, 0x124000,
	0x100028, 0x200480, 0x01a000, 0x001300,
	0x100014, 0x060080, 0x201020, 0x004140,
	0x100010, 0x100011, 0x100012, 0x080808,
	0x006400, 0x408020, 0x030200, 0x080804,
	0x100018, 0x080802, 0x080801, 0x080800,
	0x100004, 0x100005, 0x100006, 0x008600,
	0x100000, 0x100001, 0x100002, 0x100003,
	0x10000c, 0x011040, 0x400180, 0x242000,
	0x100008, 0x100009, 0x10000a, 0x080810,
	0x052000, 0x100c00, 0x201040, 0x004120,
	0x020108, 0x081080, 0x008a00, 0x440010,
	0x020104, 0x408040, 0x080410, 0x002280,
	0x020100, 0x020101, 0x020102, 0x310000,
	0x00c080, 0x220200, 0x080408, 0x440004,
	0x100060, 0x440002, 0x440001, 0x440000,
	0x080402, 0x011020, 0x080400, 0x080401,
	0x020110, 0x006800, 0x080404, 0x440008,
	0x480200, 0x004102, 0x004101, 0x004100,
	0x100050, 0x20a000, 0x010480, 0x004104,
	0x200880, 0x011010, 0x148000, 0x004108,
	0x020120, 0x040600, 0x403000, 0x080840,
	0x100044, 0x011008, 0x022800, 0x004110,
	0x100040, 0x100041, 0x100042, 0x440020,
	0x011001, 0x011000, 0x080420, 0x011002,
	0x100048, 0x011004, 0x204200, 0x028080,
};

/*! \brief Hamming 15,11 - Mask to select which bits to use for each ECC bit */
static const uint32_t _ham1511_mask_tbl[] = {
	0x7f08, 0x78e4, 0x66d2, 0x55b1
};

/*! \brief Hamming 15,11 - Correction table (bit index to flip for each syndrome) */
static const int _ham1511_fix_tbl[] = {
	-1, 0, 1, 4, 2, 5, 6, 7, 3, 8, 9, 10, 11, 12, 13, 14
};

/*! @} */

#endif /* __OSMO_IR77_AMBE_ECC_TABLES_H__ */
