-define(S1GW_CTR_PFCP_HEARTBEAT_REQ_TX, [ctr, pfcp, heartbeat_req, tx]).
-define(S1GW_CTR_PFCP_HEARTBEAT_REQ_TIMEOUT, [ctr, pfcp, heartbeat_req, timeout]).
-define(S1GW_CTR_PFCP_HEARTBEAT_RESP_RX, [ctr, pfcp, heartbeat_resp, rx]).
-define(S1GW_CTR_PFCP_HEARTBEAT_REQ_RX, [ctr, pfcp, heartbeat_req, rx]).
-define(S1GW_CTR_PFCP_HEARTBEAT_RESP_TX, [ctr, pfcp, heartbeat_resp, tx]).
-define(S1GW_CTR_PFCP_ASSOC_SETUP_REQ_TX, [ctr, pfcp, assoc_setup_req, tx]).
-define(S1GW_CTR_PFCP_ASSOC_SETUP_REQ_TIMEOUT, [ctr, pfcp, assoc_setup_req, timeout]).
-define(S1GW_CTR_PFCP_ASSOC_SETUP_RESP_RX, [ctr, pfcp, assoc_setup_resp, rx]).
-define(S1GW_CTR_PFCP_ASSOC_SETUP_RESP_RX_ACK, [ctr, pfcp, assoc_setup_resp, rx_ack]).
-define(S1GW_CTR_PFCP_ASSOC_SETUP_RESP_RX_NACK, [ctr, pfcp, assoc_setup_resp, rx_nack]).
-define(S1GW_CTR_PFCP_UNEXPECTED_PDU, [ctr, pfcp, unexpected_pdu]).
-define(S1GW_CTR_S1AP_ENB_ALL_RX, [ctr, s1ap, enb, all, rx]).
-define(S1GW_CTR_S1AP_ENB_ALL_RX_UNKNOWN_ENB, [ctr, s1ap, enb, all, rx_unknown_enb]).
-define(S1GW_CTR_S1AP_PROXY_EXCEPTION, [ctr, s1ap, proxy, exception]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ALL, [ctr, s1ap, proxy, in_pkt, all]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_DROP_ALL, [ctr, s1ap, proxy, in_pkt, drop, all]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_DECODE_ERROR, [ctr, s1ap, proxy, in_pkt, decode_error]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_PROC_ERROR, [ctr, s1ap, proxy, in_pkt, proc_error]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_SETUP_REQ, [ctr, s1ap, proxy, in_pkt, erab_setup_req]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_SETUP_RSP, [ctr, s1ap, proxy, in_pkt, erab_setup_rsp]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_MODIFY_REQ, [ctr, s1ap, proxy, in_pkt, erab_modify_req]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_MODIFY_RSP, [ctr, s1ap, proxy, in_pkt, erab_modify_rsp]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_RELEASE_CMD, [ctr, s1ap, proxy, in_pkt, erab_release_cmd]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_RELEASE_RSP, [ctr, s1ap, proxy, in_pkt, erab_release_rsp]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_RELEASE_IND, [ctr, s1ap, proxy, in_pkt, erab_release_ind]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_MOD_IND, [ctr, s1ap, proxy, in_pkt, erab_mod_ind]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_ERAB_MOD_CNF, [ctr, s1ap, proxy, in_pkt, erab_mod_cnf]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_INIT_CTX_REQ, [ctr, s1ap, proxy, in_pkt, init_ctx_req]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_INIT_CTX_RSP, [ctr, s1ap, proxy, in_pkt, init_ctx_rsp]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_RELEASE_CTX_REQ, [ctr, s1ap, proxy, in_pkt, release_ctx_req]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_RELEASE_CTX_CMD, [ctr, s1ap, proxy, in_pkt, release_ctx_cmd]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_RELEASE_CTX_COMPL, [ctr, s1ap, proxy, in_pkt, release_ctx_compl]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_HANDOVER_CMD, [ctr, s1ap, proxy, in_pkt, handover_cmd]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_HANDOVER_REQ, [ctr, s1ap, proxy, in_pkt, handover_req]).
-define(S1GW_CTR_S1AP_PROXY_IN_PKT_HANDOVER_REQ_ACK, [ctr, s1ap, proxy, in_pkt, handover_req_ack]).
-define(S1GW_CTR_S1AP_PROXY_OUT_PKT_FWD_ALL, [ctr, s1ap, proxy, out_pkt, forward, all]).
-define(S1GW_CTR_S1AP_PROXY_OUT_PKT_FWD_PROC, [ctr, s1ap, proxy, out_pkt, forward, proc]).
-define(S1GW_CTR_S1AP_PROXY_OUT_PKT_FWD_UNMODIFIED, [ctr, s1ap, proxy, out_pkt, forward, unmodified]).
-define(S1GW_CTR_S1AP_PROXY_OUT_PKT_REPLY_ALL, [ctr, s1ap, proxy, out_pkt, reply, all]).
-define(S1GW_CTR_S1AP_PROXY_OUT_PKT_REPLY_ERAB_SETUP_RSP, [ctr, s1ap, proxy, out_pkt, reply, erab_setup_rsp]).

%% enb_proxy related metrics
-define(S1GW_CTR_ENB_PROXY_S1_SETUP_REQ, [ctr, enb_proxy, s1setup, req]).
-define(S1GW_CTR_ENB_PROXY_S1_SETUP_RSP, [ctr, enb_proxy, s1setup, rsp]).
-define(S1GW_CTR_ENB_PROXY_S1_SETUP_FAILURE, [ctr, enb_proxy, s1setup, failure]).
-define(S1GW_CTR_ENB_PROXY_S1_SETUP_REQ_TIMEOUT, [ctr, enb_proxy, s1setup, req, timeout]).
-define(S1GW_CTR_ENB_PROXY_S1_SETUP_RSP_TIMEOUT, [ctr, enb_proxy, s1setup, rsp, timeout]).
-define(S1GW_CTR_ENB_PROXY_CONN_EST_TIMEOUT, [ctr, enb_proxy, conn_est, timeout]).
-define(S1GW_CTR_ENB_PROXY_CONN_EST_FAILURE, [ctr, enb_proxy, conn_est, failure]).
-define(S1GW_CTR_ENB_PROXY_UNEXPECTED_PDU, [ctr, enb_proxy, unexpected_pdu]).
-define(S1GW_CTR_ENB_PROXY_MALFORMED_PDU, [ctr, enb_proxy, malformed_pdu]).

%% SCTP related metrics
-define(S1GW_CTR_SCTP_ERROR_ALL, [ctr, sctp, error, all]).
-define(S1GW_CTR_SCTP_ERROR_SEND_FAILED, [ctr, sctp, error, send_failed]).
-define(S1GW_CTR_SCTP_ERROR_PDAPI_EVENT, [ctr, sctp, error, pdapi_event]).
-define(S1GW_CTR_SCTP_ERROR_REMOTE_ERROR, [ctr, sctp, error, remote_error]).

%% per-eNB counters
%% NOTE: these counters shall not be listed in ?S1GW_COUNTERS,
%%       but created dynamically for each connecting eNB.
-define(S1GW_CTR_ENB_UPTIME(ENBId), [ctr, enb, ENBId, uptime]).
-define(S1GW_CTR_GTPU_PACKETS(ENBId, UDL), [ctr, enb, ENBId, gtpu, packets, UDL]).
-define(S1GW_CTR_GTPU_BYTES_UE(ENBId, UDL), [ctr, enb, ENBId, gtpu, bytes, ue, UDL]).
-define(S1GW_CTR_GTPU_BYTES_TOTAL(ENBId, UDL), [ctr, enb, ENBId, gtpu, bytes, total, UDL]).

-define(S1GW_GAUGE_PFCP_ASSOCIATED, [gauge, pfcp, associated]).
-define(S1GW_GAUGE_S1AP_ENB_NUM_SCTP_CONNECTIONS, [gauge, s1ap, enb, num_sctp_connections]).

%% NOTE: Remember to add new entries to s1gw_metric:init()!

%% vim:set ts=4 sw=4 et:
