-module(s1ap_utils_test).

-include_lib("eunit/include/eunit.hrl").
-include("S1AP-Constants.hrl").
-include("S1AP-IEs.hrl").


-define(_assertEqualIE(IEI, Values),
        ?_assertEqual(Values, proplists:get_value(IEI, IEs))).

-define(_assertMatchIE(IEI, Values),
        ?_assertMatch(Values, proplists:get_value(IEI, IEs))).


%% ------------------------------------------------------------------
%% actual testcases
%% ------------------------------------------------------------------

s1ap_setup_req_test_() ->
    {MsgType, IEs} = s1ap_utils:parse_pdu(s1ap_samples:s1_setup_req_pdu()),
    [?_assertEqual(MsgType, {?'id-S1Setup', initiatingMessage}),
     ?_assertEqualIE(?'id-Global-ENB-ID', #{enb_id => 0,
                                            plmn_id => {"001", "01"}}),
     ?_assertEqualIE(?'id-eNBname', undefined), %% optional, not present
     ?_assertMatchIE(?'id-SupportedTAs', [12345])]. %% we only parse the TACs


s1ap_setup_rsp_test_() ->
    {MsgType, IEs} = s1ap_utils:parse_pdu(s1ap_samples:s1_setup_rsp_pdu()),
    [?_assertEqual(MsgType, {?'id-S1Setup', successfulOutcome}),
     ?_assertEqualIE(?'id-MMEname', "open5gs-mme0"),
     ?_assertMatchIE(?'id-ServedGUMMEIs', [#'ServedGUMMEIsItem'{}]),
     ?_assertEqualIE(?'id-RelativeMMECapacity', 16#ff)].


%% vim:set ts=4 sw=4 et:
