# Initialize the F-Droid repository

Requirements:
```
# apt install wget apksigner fdroidserver
```

The repository index of F-Droid repositories is signed with a keystore. F-Droid
requires the password for that keystore to be stored in a `config.yml` file, it
seems not possible to type it in manually.

Therefore it is assumed that we will use a different keystore for signing the
index files than for signing the apks.

Run the following to initialize a new F-Droid repository, and to let it
generate a new keystore:

```
$ cd public/fdroid
$ fdroid init
```

Adjust the following in `public/fdroid/config.yml`:

```
# This repo is updated manually, don't let the index expire
repo_maxage: 0

repo_url: https://downloads.osmocom.org/binaries/android/fdroid/repo
repo_name: Osmocom F-Droid Repository
repo_description: >-
  A repository with Osmocom (Open Source Mobile Communications) related apps,
  to be used with F-Droid. The apks in this repository can be browsed at
  https://downloads.osmocom.org/binaries/android/apks/.

# Keep all apks in the main repo for now, don't archive them
archive_older: 0

# contrib/add-apk.sh makes symlinks with a different naming scheme
make_current_version_link: false
```

**Make backups of `public/fdroid/config.yml` and `public/fdroid/keystore.p12`!**

Afterwards you can add the first app:
```
$ contrib/add-apk.sh android-apdu-proxy 0.1.0
$ git add -A
$ git commit
$ git push
```

Run this jenkins job to deploy it:
https://jenkins.osmocom.org/jenkins/job/master-osmocom-android-binaries/
