/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

File: octvc1_gsm_api_swap.h	

Copyright (c) 2018 Octasic Inc. All rights reserved.	

Description:	

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
	

Release: OCTSDR Software Development Kit OCTSDR_GSM-02.11.00-B1927 (2018/04/27)	

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/	
#ifndef __OCTVC1_GSM_API_SWAP_H__
#define __OCTVC1_GSM_API_SWAP_H__

#ifdef __cplusplus
extern "C" {
#endif

/*****************************  INCLUDE FILES  *******************************/
#include "../octvc1_swap_hdrs.h"
#include "octvc1_gsm_api.h"

/*********************************  MACROS  **********************************/



#define mOCTVC1_GSM_CMI_PHASE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_AMR_CODEC_MODE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_ID_DIRECTION_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_DIRECTION_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_ID_TIMESLOT_NB_ENUM_SWAP( pType )	/* tOCT_UINT8 */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TIMESLOT_NB_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_TIMESLOT_NB_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */


#define mOCTVC1_GSM_ID_TIMESLOT_NB_STUB_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_MODULE_TO_CAPTURE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_CAPTURE_TYPE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_CAPTURE_STATUS_ENUM_SWAP( pType )	/* tOCT_UINT8 */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */


#define mOCTVC1_GSM_ID_STUB_MODE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_STUB_MODE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_CAPTURE_MODE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( pType )	/* tOCT_UINT8 */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_SUB_CHANNEL_NB_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_SUB_CHANNEL_NB_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_CIPHERING_ID_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_CIPHERING_ID_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_SUBCHANNEL_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_SUBCHANNEL_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */


#define mOCTVC1_GSM_TEST_MODE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_TEST_MODE_BURST_TYPE_ENUM_SWAP( pType )	/* tOCT_UINT8 */


#define mOCTVC1_GSM_MODULATION_ENUM_SWAP( pType )	/* tOCT_UINT8 */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_BURST_TYPE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_BURST_TYPE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_COMBINATION_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_LOGICAL_CHANNEL_COMBINATION_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_PAYLOAD_TYPE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_PAYLOAD_TYPE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */


#define mOCTVC1_GSM_SAPI_ENUM_SWAP( pType )	/* tOCT_UINT8 */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_SAPI_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_SAPI_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TRX_ID_SWAP( _f_pParms )
#else
#define mOCTVC1_GSM_TRX_ID_SWAP( pOCTVC1_GSM_TRX_ID )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TRX_ID_CURSOR_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TRX_ID_CURSOR * pOCTVC1_GSM_TRX_ID_CURSOR = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TRX_ID_CURSOR)\
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_TRX_ID_CURSOR *)pOCTVC1_GSM_TRX_ID_CURSOR)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_TRX_ID_CURSOR_SWAP( pOCTVC1_GSM_TRX_ID_CURSOR )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TRX_ID_GET_CURSOR_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TRX_ID_GET_CURSOR * pOCTVC1_GSM_TRX_ID_GET_CURSOR = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TRX_ID_GET_CURSOR)\
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_TRX_ID_GET_CURSOR *)pOCTVC1_GSM_TRX_ID_GET_CURSOR)->TrxId ); }  \
	{ mOCTVC1_OBJECT_CURSOR_ENUM_SWAP( &((tOCTVC1_GSM_TRX_ID_GET_CURSOR *)pOCTVC1_GSM_TRX_ID_GET_CURSOR)->ulGetMode ); }  \
}
#else
#define mOCTVC1_GSM_TRX_ID_GET_CURSOR_SWAP( pOCTVC1_GSM_TRX_ID_GET_CURSOR )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TRX_BAND_HOPPING_TSC_MASK_SWAP( pType ){ \
		*((tOCT_UINT16 *)pType) = mOCT_SWAP16_IF_LE( *((tOCT_UINT16 *)pType) ); }
#else

#define mOCTVC1_GSM_TRX_BAND_HOPPING_TSC_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_RF_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_GSM_RF_CONFIG * pOCTVC1_GSM_RF_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_RF_CONFIG)\
	((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulRxGainDb = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulRxGainDb); \
	((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulTxAttndB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulTxAttndB); \
	((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulTxAntennaId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulTxAntennaId); \
	((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulRxAntennaId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_RF_CONFIG *)pOCTVC1_GSM_RF_CONFIG)->ulRxAntennaId); \
}
#else
#define mOCTVC1_GSM_RF_CONFIG_SWAP( pOCTVC1_GSM_RF_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TRX_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TRX_CONFIG * pOCTVC1_GSM_TRX_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TRX_CONFIG)\
	{ mOCTVC1_RADIO_STANDARD_FREQ_BAND_GSM_ENUM_SWAP( &((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ulBand ); }  \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usTsc = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usTsc);  \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usArfcn = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usArfcn);  \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usBcchArfcn = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usBcchArfcn);  \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usCentreArfcn = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usCentreArfcn);  \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usHsn = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usHsn);  \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usMaio = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->usMaio);  \
	{ tOCT_UINT32 iOCTVC1_GSM_TRX_CONFIG; \
	for( iOCTVC1_GSM_TRX_CONFIG=0; \
		iOCTVC1_GSM_TRX_CONFIG<(2);iOCTVC1_GSM_TRX_CONFIG++ ) \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ausReserve[iOCTVC1_GSM_TRX_CONFIG] = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ausReserve[iOCTVC1_GSM_TRX_CONFIG]);} \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ulHoppingFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ulHoppingFlag); \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ulHoppingListLength = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ulHoppingListLength); \
	{ tOCT_UINT32 iOCTVC1_GSM_TRX_CONFIG; \
	for( iOCTVC1_GSM_TRX_CONFIG=0; \
		iOCTVC1_GSM_TRX_CONFIG<(cOCTVC1_GSM_HOPPING_LIST_MAX_ENTRY);iOCTVC1_GSM_TRX_CONFIG++ ) \
	((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ausHoppingList[iOCTVC1_GSM_TRX_CONFIG] = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_TRX_CONFIG *)pOCTVC1_GSM_TRX_CONFIG)->ausHoppingList[iOCTVC1_GSM_TRX_CONFIG]);} \
}
#else
#define mOCTVC1_GSM_TRX_CONFIG_SWAP( pOCTVC1_GSM_TRX_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TRX_STATUS_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_TRX_STATUS_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( _f_pParms ){ 	tOCTVC1_GSM_PHYSICAL_CHANNEL_ID * pOCTVC1_GSM_PHYSICAL_CHANNEL_ID = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_PHYSICAL_CHANNEL_ID)\
	{ mOCTVC1_GSM_ID_TIMESLOT_NB_ENUM_SWAP( &((tOCTVC1_GSM_PHYSICAL_CHANNEL_ID *)pOCTVC1_GSM_PHYSICAL_CHANNEL_ID)->byTimeslotNb ); }  \
}
#else
#define mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( pOCTVC1_GSM_PHYSICAL_CHANNEL_ID )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR_SWAP( _f_pParms ){ 	tOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR * pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR)\
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR *)pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR_SWAP( pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR_SWAP( _f_pParms ){ 	tOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR * pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR)\
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR *)pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR *)pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR)->PchId ); }  \
	{ mOCTVC1_OBJECT_CURSOR_ENUM_SWAP( &((tOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR *)pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR)->ulGetMode ); }  \
}
#else
#define mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR_SWAP( pOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_SUBCHANNEL_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_SUBCHANNEL_STATUS * pOCTVC1_GSM_SUBCHANNEL_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_SUBCHANNEL_STATUS)\
	((tOCTVC1_GSM_SUBCHANNEL_STATUS *)pOCTVC1_GSM_SUBCHANNEL_STATUS)->ulSubchannelNb = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_SUBCHANNEL_STATUS *)pOCTVC1_GSM_SUBCHANNEL_STATUS)->ulSubchannelNb); \
	{ mOCTVC1_GSM_SAPI_MASK_SWAP( &((tOCTVC1_GSM_SUBCHANNEL_STATUS *)pOCTVC1_GSM_SUBCHANNEL_STATUS)->ulActiveUplinkSAPIMask ); }  \
	{ mOCTVC1_GSM_SAPI_MASK_SWAP( &((tOCTVC1_GSM_SUBCHANNEL_STATUS *)pOCTVC1_GSM_SUBCHANNEL_STATUS)->ulActiveDownlinkSAPIMask ); }  \
}
#else
#define mOCTVC1_GSM_SUBCHANNEL_STATUS_SWAP( pOCTVC1_GSM_SUBCHANNEL_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_CIPHER_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_GSM_CIPHER_CONFIG * pOCTVC1_GSM_CIPHER_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_CIPHER_CONFIG)\
	{ mOCTVC1_GSM_CIPHERING_ID_ENUM_SWAP( &((tOCTVC1_GSM_CIPHER_CONFIG *)pOCTVC1_GSM_CIPHER_CONFIG)->ulCipherId ); }  \
}
#else
#define mOCTVC1_GSM_CIPHER_CONFIG_SWAP( pOCTVC1_GSM_CIPHER_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_STUB_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_STUB_STATUS * pOCTVC1_GSM_STUB_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_STUB_STATUS)\
	((tOCTVC1_GSM_STUB_STATUS *)pOCTVC1_GSM_STUB_STATUS)->byTimeslotUsed = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_STUB_STATUS *)pOCTVC1_GSM_STUB_STATUS)->byTimeslotUsed);  \
	{ mOCTVC1_GSM_STUB_MODE_ENUM_SWAP( &((tOCTVC1_GSM_STUB_STATUS *)pOCTVC1_GSM_STUB_STATUS)->byStubMode ); }  \
}
#else
#define mOCTVC1_GSM_STUB_STATUS_SWAP( pOCTVC1_GSM_STUB_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_STUB_CHANNEL_ID_SWAP( _f_pParms ){ 	tOCTVC1_GSM_STUB_CHANNEL_ID * pOCTVC1_GSM_STUB_CHANNEL_ID = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_STUB_CHANNEL_ID)\
	{ mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( &((tOCTVC1_GSM_STUB_CHANNEL_ID *)pOCTVC1_GSM_STUB_CHANNEL_ID)->byTimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_STUB_CHANNEL_ID *)pOCTVC1_GSM_STUB_CHANNEL_ID)->bySubChannelNb ); }  \
	{ mOCTVC1_GSM_SAPI_ENUM_SWAP( &((tOCTVC1_GSM_STUB_CHANNEL_ID *)pOCTVC1_GSM_STUB_CHANNEL_ID)->bySAPI ); }  \
	{ mOCTVC1_GSM_STUB_MODE_ENUM_SWAP( &((tOCTVC1_GSM_STUB_CHANNEL_ID *)pOCTVC1_GSM_STUB_CHANNEL_ID)->byStubMode ); }  \
}
#else
#define mOCTVC1_GSM_STUB_CHANNEL_ID_SWAP( pOCTVC1_GSM_STUB_CHANNEL_ID )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_CAPTURE_CHANNEL_ID_SWAP( _f_pParms ){ 	tOCTVC1_GSM_CAPTURE_CHANNEL_ID * pOCTVC1_GSM_CAPTURE_CHANNEL_ID = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_CAPTURE_CHANNEL_ID)\
	{ mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( &((tOCTVC1_GSM_CAPTURE_CHANNEL_ID *)pOCTVC1_GSM_CAPTURE_CHANNEL_ID)->byTimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_CAPTURE_CHANNEL_ID *)pOCTVC1_GSM_CAPTURE_CHANNEL_ID)->bySubChannelNb ); }  \
	{ mOCTVC1_GSM_CAPTURE_MODE_ENUM_SWAP( &((tOCTVC1_GSM_CAPTURE_CHANNEL_ID *)pOCTVC1_GSM_CAPTURE_CHANNEL_ID)->byCAPTUREMode ); }  \
}
#else
#define mOCTVC1_GSM_CAPTURE_CHANNEL_ID_SWAP( pOCTVC1_GSM_CAPTURE_CHANNEL_ID )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( _f_pParms ){ 	tOCTVC1_GSM_LOGICAL_CHANNEL_ID * pOCTVC1_GSM_LOGICAL_CHANNEL_ID = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_LOGICAL_CHANNEL_ID)\
	{ mOCTVC1_GSM_ID_TIMESLOT_NB_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID)->byTimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID)->bySubChannelNb ); }  \
	{ mOCTVC1_GSM_SAPI_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID)->bySAPI ); }  \
	{ mOCTVC1_GSM_ID_DIRECTION_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID)->byDirection ); }  \
}
#else
#define mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( pOCTVC1_GSM_LOGICAL_CHANNEL_ID )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR_SWAP( _f_pParms ){ 	tOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR * pOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR)\
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR_SWAP( pOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR_SWAP( _f_pParms ){ 	tOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR * pOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR)\
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR)->LchId ); }  \
	{ mOCTVC1_OBJECT_CURSOR_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR *)pOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR)->ulGetMode ); }  \
}
#else
#define mOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR_SWAP( pOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG * pOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG)\
	{ mOCTVC1_GSM_CMI_PHASE_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG *)pOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG)->byCmiPhase ); }  \
	{ mOCTVC1_GSM_AMR_CODEC_MODE_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG *)pOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG)->byInitRate ); }  \
	{ tOCT_UINT32 jOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG; \
	for( jOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG=0; \
		jOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG<(cOCTVC1_GSM_RATE_LIST_SIZE);jOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG++ ) \
	{ mOCTVC1_GSM_AMR_CODEC_MODE_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG *)pOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG)->abyRate[jOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG] ); }} \
}
#else
#define mOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG_SWAP( pOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_DATA_SWAP( _f_pParms ){ 	tOCTVC1_GSM_LOGICAL_CHANNEL_DATA * pOCTVC1_GSM_LOGICAL_CHANNEL_DATA = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_LOGICAL_CHANNEL_DATA)\
	((tOCTVC1_GSM_LOGICAL_CHANNEL_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_DATA)->ulFrameNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_LOGICAL_CHANNEL_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_DATA)->ulFrameNumber); \
	{ mOCTVC1_GSM_PAYLOAD_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_LOGICAL_CHANNEL_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_DATA)->ulPayloadType ); }  \
	((tOCTVC1_GSM_LOGICAL_CHANNEL_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_DATA)->ulDataLength = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_LOGICAL_CHANNEL_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_DATA)->ulDataLength); \
}
#else
#define mOCTVC1_GSM_LOGICAL_CHANNEL_DATA_SWAP( pOCTVC1_GSM_LOGICAL_CHANNEL_DATA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA_SWAP( _f_pParms ){ 	tOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA * pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA)\
	((tOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA)->ulFrameNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA)->ulFrameNumber); \
	((tOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA)->ulDataLength = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA *)pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA)->ulDataLength); \
}
#else
#define mOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA_SWAP( pOCTVC1_GSM_LOGICAL_CHANNEL_RAW_DATA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MEASUREMENT_INFO_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MEASUREMENT_INFO * pOCTVC1_GSM_MEASUREMENT_INFO = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MEASUREMENT_INFO)\
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sSNRDb = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sSNRDb);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sRSSIDbm = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sRSSIDbm);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sBurstTiming = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sBurstTiming);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sBurstTiming4x = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->sBurstTiming4x);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->usBERCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->usBERCnt);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->usBERTotalBitCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->usBERTotalBitCnt);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->uLReserved0 = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->uLReserved0);  \
	((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->uLReserved1 = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MEASUREMENT_INFO *)pOCTVC1_GSM_MEASUREMENT_INFO)->uLReserved1);  \
}
#else
#define mOCTVC1_GSM_MEASUREMENT_INFO_SWAP( pOCTVC1_GSM_MEASUREMENT_INFO )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_RAW_MEASUREMENT_INFO_SWAP( _f_pParms ){ 	tOCTVC1_GSM_RAW_MEASUREMENT_INFO * pOCTVC1_GSM_RAW_MEASUREMENT_INFO = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_RAW_MEASUREMENT_INFO)\
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sSNRDb = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sSNRDb);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sRSSIDbm = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sRSSIDbm);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sBurstTiming = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sBurstTiming);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sBurstTiming4x = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sBurstTiming4x);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usBERCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usBERCnt);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usBERTotalBitCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usBERTotalBitCnt);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usTrSqErrCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usTrSqErrCnt);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usTrSqTotalBitCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usTrSqTotalBitCnt);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sFreqErrHz = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->sFreqErrHz);  \
	((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usReserved = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_RAW_MEASUREMENT_INFO *)pOCTVC1_GSM_RAW_MEASUREMENT_INFO)->usReserved);  \
}
#else
#define mOCTVC1_GSM_RAW_MEASUREMENT_INFO_SWAP( pOCTVC1_GSM_RAW_MEASUREMENT_INFO )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TIMESLOT_POWER_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TIMESLOT_POWER * pOCTVC1_GSM_TIMESLOT_POWER = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TIMESLOT_POWER)\
	((tOCTVC1_GSM_TIMESLOT_POWER *)pOCTVC1_GSM_TIMESLOT_POWER)->ulPowerMax = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TIMESLOT_POWER *)pOCTVC1_GSM_TIMESLOT_POWER)->ulPowerMax); \
	((tOCTVC1_GSM_TIMESLOT_POWER *)pOCTVC1_GSM_TIMESLOT_POWER)->ulPowerAverage = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TIMESLOT_POWER *)pOCTVC1_GSM_TIMESLOT_POWER)->ulPowerAverage); \
	((tOCTVC1_GSM_TIMESLOT_POWER *)pOCTVC1_GSM_TIMESLOT_POWER)->ulCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TIMESLOT_POWER *)pOCTVC1_GSM_TIMESLOT_POWER)->ulCount); \
}
#else
#define mOCTVC1_GSM_TIMESLOT_POWER_SWAP( pOCTVC1_GSM_TIMESLOT_POWER )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_PHYSICAL_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_PHYSICAL_STATUS * pOCTVC1_GSM_PHYSICAL_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_PHYSICAL_STATUS)\
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_COMBINATION_ENUM_SWAP( &((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulChannelType ); }  \
	((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulSubchannelCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulSubchannelCount); \
	((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulTchDataCrcPassCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulTchDataCrcPassCount); \
	((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulTchDataCrcFailCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulTchDataCrcFailCount); \
	((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulRachCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->ulRachCount); \
	{ tOCT_UINT32 iOCTVC1_GSM_PHYSICAL_STATUS; \
	for( iOCTVC1_GSM_PHYSICAL_STATUS=0; \
		iOCTVC1_GSM_PHYSICAL_STATUS<(cOCTVC1_GSM_MAX_PDCH_DATA_BLOCKS);iOCTVC1_GSM_PHYSICAL_STATUS++ ) \
	((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->aulPdtchCrcPassCount[iOCTVC1_GSM_PHYSICAL_STATUS] = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->aulPdtchCrcPassCount[iOCTVC1_GSM_PHYSICAL_STATUS]);}\
	{ tOCT_UINT32 iOCTVC1_GSM_PHYSICAL_STATUS; \
	for( iOCTVC1_GSM_PHYSICAL_STATUS=0; \
		iOCTVC1_GSM_PHYSICAL_STATUS<(cOCTVC1_GSM_MAX_PDCH_DATA_BLOCKS);iOCTVC1_GSM_PHYSICAL_STATUS++ ) \
	((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->aulPdtchCrcFailCount[iOCTVC1_GSM_PHYSICAL_STATUS] = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_PHYSICAL_STATUS *)pOCTVC1_GSM_PHYSICAL_STATUS)->aulPdtchCrcFailCount[iOCTVC1_GSM_PHYSICAL_STATUS]);}\
}
#else
#define mOCTVC1_GSM_PHYSICAL_STATUS_SWAP( pOCTVC1_GSM_PHYSICAL_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TIMESLOT_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TIMESLOT_STATUS * pOCTVC1_GSM_TIMESLOT_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TIMESLOT_STATUS)\
	{ mOCTVC1_GSM_PHYSICAL_STATUS_SWAP( &((tOCTVC1_GSM_TIMESLOT_STATUS *)pOCTVC1_GSM_TIMESLOT_STATUS)->PhysicalStatus ); }  \
	{ mOCTVC1_GSM_TIMESLOT_POWER_SWAP( &((tOCTVC1_GSM_TIMESLOT_STATUS *)pOCTVC1_GSM_TIMESLOT_STATUS)->UplinkPower ); }  \
}
#else
#define mOCTVC1_GSM_TIMESLOT_STATUS_SWAP( pOCTVC1_GSM_TIMESLOT_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_DL_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_DL_STATUS * pOCTVC1_GSM_DL_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_DL_STATUS)\
	((tOCTVC1_GSM_DL_STATUS *)pOCTVC1_GSM_DL_STATUS)->ulElapseRspCmdMaxUs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_DL_STATUS *)pOCTVC1_GSM_DL_STATUS)->ulElapseRspCmdMaxUs); \
	((tOCTVC1_GSM_DL_STATUS *)pOCTVC1_GSM_DL_STATUS)->ulElapseRspCmdAvgUs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_DL_STATUS *)pOCTVC1_GSM_DL_STATUS)->ulElapseRspCmdAvgUs); \
	((tOCTVC1_GSM_DL_STATUS *)pOCTVC1_GSM_DL_STATUS)->ulExpectedDelayExceedCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_DL_STATUS *)pOCTVC1_GSM_DL_STATUS)->ulExpectedDelayExceedCnt); \
}
#else
#define mOCTVC1_GSM_DL_STATUS_SWAP( pOCTVC1_GSM_DL_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_UL_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_UL_STATUS * pOCTVC1_GSM_UL_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_UL_STATUS)\
	((tOCTVC1_GSM_UL_STATUS *)pOCTVC1_GSM_UL_STATUS)->ulExceedByteMaxCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_UL_STATUS *)pOCTVC1_GSM_UL_STATUS)->ulExceedByteMaxCnt); \
	((tOCTVC1_GSM_UL_STATUS *)pOCTVC1_GSM_UL_STATUS)->ulExpectedDataExceedCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_UL_STATUS *)pOCTVC1_GSM_UL_STATUS)->ulExpectedDataExceedCnt); \
}
#else
#define mOCTVC1_GSM_UL_STATUS_SWAP( pOCTVC1_GSM_UL_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_SCHED_STATUS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_SCHED_STATUS * pOCTVC1_GSM_SCHED_STATUS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_SCHED_STATUS)\
	((tOCTVC1_GSM_SCHED_STATUS *)pOCTVC1_GSM_SCHED_STATUS)->ulErrorDataInactiveCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_SCHED_STATUS *)pOCTVC1_GSM_SCHED_STATUS)->ulErrorDataInactiveCnt); \
}
#else
#define mOCTVC1_GSM_SCHED_STATUS_SWAP( pOCTVC1_GSM_SCHED_STATUS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_TYPE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_TAP_FILTER_TYPE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY * pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY)\
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY *)pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY *)pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY_SWAP( pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY * pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY)\
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY *)pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY *)pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY_SWAP( pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_GSM_TAP_FILTER_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_TRX_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER_TRX * pOCTVC1_GSM_TAP_FILTER_TRX = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER_TRX)\
	((tOCTVC1_GSM_TAP_FILTER_TRX *)pOCTVC1_GSM_TAP_FILTER_TRX)->ulAllTrxFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TAP_FILTER_TRX *)pOCTVC1_GSM_TAP_FILTER_TRX)->ulAllTrxFlag); \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_TAP_FILTER_TRX *)pOCTVC1_GSM_TAP_FILTER_TRX)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_TAP_FILTER_TRX_SWAP( pOCTVC1_GSM_TAP_FILTER_TRX )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL * pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL)\
	((tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL *)pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL)->ulEntryCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL *)pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL)->ulEntryCnt); \
	{ tOCT_UINT32 jOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL; \
	for( jOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL=0; \
		jOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL<(cOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY_COUNT_MAX);jOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL++ ) \
	{ mOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_ENTRY_SWAP( &((tOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL *)pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL)->aEntry[jOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL] ); }} \
}
#else
#define mOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_SWAP( pOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL * pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL)\
	((tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL *)pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL)->ulEntryCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL *)pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL)->ulEntryCnt); \
	{ tOCT_UINT32 jOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL; \
	for( jOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL=0; \
		jOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL<(cOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY_COUNT_MAX);jOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL++ ) \
	{ mOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_ENTRY_SWAP( &((tOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL *)pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL)->aEntry[jOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL] ); }} \
}
#else
#define mOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_SWAP( pOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER * pOCTVC1_GSM_TAP_FILTER = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER)\
	{ mOCTVC1_GSM_TAP_FILTER_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_TAP_FILTER *)pOCTVC1_GSM_TAP_FILTER)->ulType ); }  \
	{ mOCTVC1_GSM_TAP_FILTER_MASK_SWAP( &((tOCTVC1_GSM_TAP_FILTER *)pOCTVC1_GSM_TAP_FILTER)->ulMask ); }  \
	{ mOCTVC1_GSM_TAP_FILTER_TRX_SWAP( &((tOCTVC1_GSM_TAP_FILTER *)pOCTVC1_GSM_TAP_FILTER)->Trx ); }  \
	{ mOCTVC1_GSM_TAP_FILTER_PHYSICAL_CHANNEL_SWAP( &((tOCTVC1_GSM_TAP_FILTER *)pOCTVC1_GSM_TAP_FILTER)->PhysicalChannel ); }  \
	{ mOCTVC1_GSM_TAP_FILTER_LOGICAL_CHANNEL_SWAP( &((tOCTVC1_GSM_TAP_FILTER *)pOCTVC1_GSM_TAP_FILTER)->LogicalChannel ); }  \
}
#else
#define mOCTVC1_GSM_TAP_FILTER_SWAP( pOCTVC1_GSM_TAP_FILTER )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_TAP_FILTER_STATS_SWAP( _f_pParms ){ 	tOCTVC1_GSM_TAP_FILTER_STATS * pOCTVC1_GSM_TAP_FILTER_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_TAP_FILTER_STATS)\
	((tOCTVC1_GSM_TAP_FILTER_STATS *)pOCTVC1_GSM_TAP_FILTER_STATS)->ulTapIdCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TAP_FILTER_STATS *)pOCTVC1_GSM_TAP_FILTER_STATS)->ulTapIdCnt); \
	{ tOCT_UINT32 iOCTVC1_GSM_TAP_FILTER_STATS; \
	for( iOCTVC1_GSM_TAP_FILTER_STATS=0; \
		iOCTVC1_GSM_TAP_FILTER_STATS<(cOCTVC1_GSM_TAP_FILTER_TAP_COUNT_MAX);iOCTVC1_GSM_TAP_FILTER_STATS++ ) \
	((tOCTVC1_GSM_TAP_FILTER_STATS *)pOCTVC1_GSM_TAP_FILTER_STATS)->ahTapId[iOCTVC1_GSM_TAP_FILTER_STATS] = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_TAP_FILTER_STATS *)pOCTVC1_GSM_TAP_FILTER_STATS)->ahTapId[iOCTVC1_GSM_TAP_FILTER_STATS]);}\
}
#else
#define mOCTVC1_GSM_TAP_FILTER_STATS_SWAP( pOCTVC1_GSM_TAP_FILTER_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER * pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ModuleData ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->LchId ); }  \
	((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulAntennaIndex); \
	((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulFrameNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulFrameNumber); \
	((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulPower = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulPower); \
	((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulDataSizeInBytes = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER *)pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER)->ulDataSizeInBytes); \
}
#else
#define mOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER_SWAP( pOCTVC1_GSM_MODULE_DATA_RF_UPLINK_INPUT_HEADER )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_OPEN_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_OPEN_CMD * pOCTVC1_GSM_MSG_TRX_OPEN_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_OPEN_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_OPEN_CMD *)pOCTVC1_GSM_MSG_TRX_OPEN_CMD)->Header ); }  \
	((tOCTVC1_GSM_MSG_TRX_OPEN_CMD *)pOCTVC1_GSM_MSG_TRX_OPEN_CMD)->ulRfPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_OPEN_CMD *)pOCTVC1_GSM_MSG_TRX_OPEN_CMD)->ulRfPortIndex); \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_OPEN_CMD *)pOCTVC1_GSM_MSG_TRX_OPEN_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_TRX_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_OPEN_CMD *)pOCTVC1_GSM_MSG_TRX_OPEN_CMD)->Config ); }  \
	{ mOCTVC1_GSM_RF_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_OPEN_CMD *)pOCTVC1_GSM_MSG_TRX_OPEN_CMD)->RfConfig ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_OPEN_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_OPEN_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_OPEN_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_OPEN_RSP * pOCTVC1_GSM_MSG_TRX_OPEN_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_OPEN_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_OPEN_RSP *)pOCTVC1_GSM_MSG_TRX_OPEN_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_OPEN_RSP *)pOCTVC1_GSM_MSG_TRX_OPEN_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_OPEN_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_OPEN_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_CLOSE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_CLOSE_CMD * pOCTVC1_GSM_MSG_TRX_CLOSE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_CLOSE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_CLOSE_CMD *)pOCTVC1_GSM_MSG_TRX_CLOSE_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_CLOSE_CMD *)pOCTVC1_GSM_MSG_TRX_CLOSE_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_CLOSE_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_CLOSE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_CLOSE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_CLOSE_RSP * pOCTVC1_GSM_MSG_TRX_CLOSE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_CLOSE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_CLOSE_RSP *)pOCTVC1_GSM_MSG_TRX_CLOSE_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_CLOSE_RSP *)pOCTVC1_GSM_MSG_TRX_CLOSE_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_CLOSE_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_CLOSE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STATUS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STATUS_CMD * pOCTVC1_GSM_MSG_TRX_STATUS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STATUS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_CMD)->TrxId ); }  \
	((tOCTVC1_GSM_MSG_TRX_STATUS_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_CMD)->ulResetFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_STATUS_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_CMD)->ulResetFlag); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STATUS_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STATUS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STATUS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STATUS_RSP * pOCTVC1_GSM_MSG_TRX_STATUS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STATUS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_DL_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_RSP)->DlStatus ); }  \
	{ mOCTVC1_GSM_UL_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_RSP)->UlStatus ); }  \
	{ mOCTVC1_GSM_SCHED_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_RSP)->SchedStatus ); }  \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_STATUS_RSP; \
	for( jOCTVC1_GSM_MSG_TRX_STATUS_RSP=0; \
		jOCTVC1_GSM_MSG_TRX_STATUS_RSP<(cOCTVC1_GSM_TRX_MAX_TIMESLOTS);jOCTVC1_GSM_MSG_TRX_STATUS_RSP++ ) \
	{ mOCTVC1_GSM_TIMESLOT_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_RSP)->aTSlotStatus[jOCTVC1_GSM_MSG_TRX_STATUS_RSP] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STATUS_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STATUS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_CMD * pOCTVC1_GSM_MSG_TRX_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_RSP * pOCTVC1_GSM_MSG_TRX_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RSP)->TrxId ); }  \
	((tOCTVC1_GSM_MSG_TRX_INFO_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RSP)->ulRfPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_INFO_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RSP)->ulRfPortIndex); \
	{ mOCTVC1_GSM_TRX_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RSP)->Config ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_RESET_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_RESET_CMD * pOCTVC1_GSM_MSG_TRX_RESET_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_RESET_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_CMD *)pOCTVC1_GSM_MSG_TRX_RESET_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_CMD *)pOCTVC1_GSM_MSG_TRX_RESET_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_RESET_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_RESET_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_RESET_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_RESET_RSP * pOCTVC1_GSM_MSG_TRX_RESET_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_RESET_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_RSP *)pOCTVC1_GSM_MSG_TRX_RESET_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_RSP *)pOCTVC1_GSM_MSG_TRX_RESET_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_RESET_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_RESET_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_CMD * pOCTVC1_GSM_MSG_TRX_MODIFY_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_TRX_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_CMD)->Config ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_RSP * pOCTVC1_GSM_MSG_TRX_MODIFY_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_LIST_CMD * pOCTVC1_GSM_MSG_TRX_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_CMD *)pOCTVC1_GSM_MSG_TRX_LIST_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_GET_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_CMD *)pOCTVC1_GSM_MSG_TRX_LIST_CMD)->TrxIdCursor ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_LIST_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_LIST_RSP * pOCTVC1_GSM_MSG_TRX_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_GET_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_RSP)->TrxIdCursor ); }  \
	((tOCTVC1_GSM_MSG_TRX_LIST_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_RSP)->ulNumTrxId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_LIST_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_RSP)->ulNumTrxId); \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_LIST_RSP; \
	for( jOCTVC1_GSM_MSG_TRX_LIST_RSP=0; \
		jOCTVC1_GSM_MSG_TRX_LIST_RSP<(cOCTVC1_GSM_TRX_ID_LIST_MAX_ENTRY);jOCTVC1_GSM_MSG_TRX_LIST_RSP++ ) \
	{ mOCTVC1_GSM_TRX_ID_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_RSP)->aTrxId[jOCTVC1_GSM_MSG_TRX_LIST_RSP] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_LIST_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD * pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD *)pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP * pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP *)pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP)->Header ); }  \
	((tOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP *)pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP)->ulCloseCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP *)pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP)->ulCloseCount); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_CLOSE_ALL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_RECORD_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_RECORD_CMD * pOCTVC1_GSM_MSG_TRX_START_RECORD_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_RECORD_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_RECORD_CMD *)pOCTVC1_GSM_MSG_TRX_START_RECORD_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_RECORD_CMD *)pOCTVC1_GSM_MSG_TRX_START_RECORD_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_RECORD_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_START_RECORD_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_RECORD_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_RECORD_RSP * pOCTVC1_GSM_MSG_TRX_START_RECORD_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_RECORD_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_RECORD_RSP *)pOCTVC1_GSM_MSG_TRX_START_RECORD_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_RECORD_RSP *)pOCTVC1_GSM_MSG_TRX_START_RECORD_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_RECORD_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_START_RECORD_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD * pOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_RECORD_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP * pOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_RECORD_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD)->LchId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD)->Config ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_ACTIVATE_LOGICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_DEACTIVATE_LOGICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP)->LchId ); }  \
	((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP)->usStatus = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP)->usStatus);  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STATUS_LOGICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP)->LchId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP)->Config ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_LOGICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD)->LchIdCursor ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_GET_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP)->LchIdCursor ); }  \
	((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP)->ulNumLchId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP)->ulNumLchId); \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP; \
	for( jOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP=0; \
		jOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP<(cOCTVC1_GSM_LOGICAL_CHANNEL_ID_LIST_MAX_ENTRY);jOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP++ ) \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP)->aLchId[jOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_LIST_LOGICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD * pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD)->LchId ); }  \
	((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD)->ulFrameNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD)->ulFrameNumber); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP * pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_EMPTY_FRAME_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD * pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD)->LchId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_DATA_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD)->Data ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP * pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_DATA_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD)->PchId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_COMBINATION_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD)->ulChannelType ); }  \
	{ mOCTVC1_GSM_PAYLOAD_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD)->ulPayloadType ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_ACTIVATE_PHYSICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_DEACTIVATE_PHYSICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD)->PchId ); }  \
	((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD)->ulResetFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD)->ulResetFlag); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP)->PchId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP)->PhysicalStatus ); }  \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP; \
	for( jOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP=0; \
		jOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP<(cOCTVC1_GSM_TIMESLOT_MAX_SUBCHANNEL);jOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP++ ) \
	{ mOCTVC1_GSM_SUBCHANNEL_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP)->aSubchannnelStatus[jOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STATUS_PHYSICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_RESET_PHYSICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD)->PchIdCursor ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_GET_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP)->PchIdCursor ); }  \
	((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP)->ulNumPchId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP)->ulNumPchId); \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP; \
	for( jOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP=0; \
		jOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP<(cOCTVC1_GSM_PHYSICAL_CHANNEL_ID_LIST_MAX_ENTRY);jOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP++ ) \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_CURSOR_SWAP( &((tOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP)->aPchId[jOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_LIST_PHYSICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD * pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP * pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP)->PchId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_COMBINATION_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP)->ulChannelType ); }  \
	{ mOCTVC1_GSM_PAYLOAD_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP)->ulPayloadType ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD * pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)->PchId ); }  \
	{ mOCTVC1_GSM_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)->ulSubchannelNb ); }  \
	{ mOCTVC1_GSM_DIRECTION_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)->ulDirection ); }  \
	{ mOCTVC1_GSM_CIPHER_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD)->Config ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP * pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_PHYSICAL_CHANNEL_CIPHERING_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD * pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP * pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)->PchId ); }  \
	{ mOCTVC1_GSM_SUBCHANNEL_MASK_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)->ulTxSubChannelMask ); }  \
	{ mOCTVC1_GSM_SUBCHANNEL_MASK_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)->ulRxSubChannelMask ); }  \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP; \
	for( jOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP=0; \
		jOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP<(cOCTVC1_GSM_TIMESLOT_MAX_SUBCHANNEL);jOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP++ ) \
	{ mOCTVC1_GSM_CIPHER_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP)->Config[jOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_CIPHERING_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD * pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD)->PchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP * pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_PHYSICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP)->PchId ); }  \
	{ mOCTVC1_GSM_MEASUREMENT_INFO_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP)->MeasurementInfo ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_PHYSICAL_CHANNEL_MEASUREMENT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_RF_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_RF_CMD * pOCTVC1_GSM_MSG_TRX_INFO_RF_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_RF_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RF_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_RF_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RF_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_RF_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_RF_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_RF_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_RF_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_RF_RSP * pOCTVC1_GSM_MSG_TRX_INFO_RF_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_RF_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RF_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RF_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_RF_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_RF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_RF_RSP)->RfConfig ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_RF_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_RF_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD * pOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_RF_CONFIG_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD)->RfConfig ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_RF_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP * pOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_RF_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD * pOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD)->IndexGet ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP * pOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP)->IndexGet ); }  \
	{ mOCTVC1_LIST_INDEX_GET_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP)->IndexList ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD * pOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD)->Header ); }  \
	((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD)->ulFilterIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD)->ulFilterIndex); \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP * pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP)->Header ); }  \
	((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP)->ulFilterIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP)->ulFilterIndex); \
	{ mOCTVC1_GSM_TAP_FILTER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP)->Filter ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD * pOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD)->Header ); }  \
	((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD)->ulFilterIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD)->ulFilterIndex); \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP * pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP)->Header ); }  \
	((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP)->ulFilterIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP)->ulFilterIndex); \
	{ mOCTVC1_GSM_TAP_FILTER_STATS_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP)->Stats ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD * pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD)->Header ); }  \
	((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD)->ulFilterIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD)->ulFilterIndex); \
	{ mOCTVC1_GSM_TAP_FILTER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD)->Filter ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP * pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP)->Header ); }  \
	((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP)->ulFilterIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP *)pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP)->ulFilterIndex); \
}
#else
#define mOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP_SWAP( pOCTVC1_GSM_MSG_TAP_FILTER_MODIFY_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD * pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD)->Header ); }  \
	((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD)->ulOversample16xEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD)->ulOversample16xEnableFlag); \
}
#else
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD_SWAP( pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP * pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP_SWAP( pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_MODIFY_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD * pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD_SWAP( pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP * pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP)->Header ); }  \
	((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP)->ulOversample16xEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP *)pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP)->ulOversample16xEnableFlag); \
}
#else
#define mOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP_SWAP( pOCTVC1_GSM_MSG_OVERSAMPLE_SELECT_16X_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD * pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD *)pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD *)pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD *)pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP * pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP *)pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP *)pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP *)pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_START_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD * pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP * pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_LOGICAL_CHANNEL_RAW_DATA_INDICATIONS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD * pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD)->LchId ); }  \
	((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD)->ulResetFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD)->ulResetFlag); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP * pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP)->LchId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_REQUEST_LOGICAL_CHANNEL_CMU_LOOPBACK_TEST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD * pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP * pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_STUB_STATUS_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP)->StubStatus ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_STUBB_LOOPBACK_TEST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD * pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_STUB_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD)->STUB_CHANNEL_ID ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP * pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_START_STUBB_LOOPBACK_TEST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD * pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD)->byTimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD)->bySubChannelNb ); }  \
	{ mOCTVC1_GSM_STUB_MODE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD)->byStubMode ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP * pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_STUBB_LOOPBACK_TEST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD * pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_TEST_MODE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD)->testModeVal ); }  \
	{ mOCTVC1_GSM_MODULATION_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD)->modulation ); }  \
	{ tOCT_UINT32 jOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD; \
	for( jOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD=0; \
		jOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD<(cOCTVC1_GSM_TRX_MAX_TIMESLOTS);jOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD++ ) \
	{ mOCTVC1_GSM_TEST_MODE_BURST_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD)->abyBurstType[jOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD] ); }} \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP * pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP *)pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_MODIFY_TEST_MODE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD * pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP * pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TEST_MODE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP)->testModeVal ); }  \
	{ mOCTVC1_GSM_MODULATION_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP)->modulation ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_TEST_MODE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD * pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD)->TrxId ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP * pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->TrxId ); }  \
	{ mOCTVC1_GSM_CAPTURE_STATUS_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->Status ); }  \
	{ mOCTVC1_GSM_MODULE_TO_CAPTURE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->tracePoint ); }  \
	{ mOCTVC1_GSM_CAPTURE_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->Type ); }  \
	{ mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->TimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->SubChannelNb ); }  \
	((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->blockCnt = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP)->blockCnt);  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_INFO_DL_TRACE_BUFF_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD * pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_CAPTURE_MODE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->Mode ); }  \
	{ mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->TimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->SubChannelNb ); }  \
	{ mOCTVC1_GSM_MODULE_TO_CAPTURE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->tracePoint ); }  \
	{ mOCTVC1_GSM_CAPTURE_TYPE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD)->Type ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP * pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_START_DL_TRACE_BUFF_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD * pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD)->Header ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD)->TrxId ); }  \
	{ mOCTVC1_GSM_TIMESLOT_NB_STUB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD)->TimeslotNb ); }  \
	{ mOCTVC1_GSM_ID_SUB_CHANNEL_NB_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD)->SubChannelNb ); }  \
	{ mOCTVC1_GSM_CAPTURE_MODE_ENUM_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD *)pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD)->Mode ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP * pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP *)pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP)->Header ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP_SWAP( pOCTVC1_GSM_MSG_TRX_STOP_DL_TRACE_BUFF_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA * pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ModuleData ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->LchId ); }  \
	((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulAntennaIndex); \
	((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulFrameNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulFrameNumber); \
	((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulPower = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulPower); \
	((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulDataSizeInBytes = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA)->ulDataSizeInBytes); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA_SWAP( pOCTVC1_GSM_MSG_TRX_UPLINK_RF_INPUT_DATA_LOGICAL_CHANNEL_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA * pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA)->ModuleData ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA)->LchId ); }  \
	((tOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA)->ulFrameNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA)->ulFrameNumber); \
}
#else
#define mOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA_SWAP( pOCTVC1_GSM_MSG_TRX_EMPTY_FRAME_LOGICAL_CHANNEL_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA_SWAP( _f_pParms ){ 	tOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA * pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA)->ModuleData ); }  \
	{ mOCTVC1_GSM_TRX_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA)->TrxId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_ID_SWAP( &((tOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA)->LchId ); }  \
	{ mOCTVC1_GSM_LOGICAL_CHANNEL_DATA_SWAP( &((tOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA *)pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA)->Data ); }  \
}
#else
#define mOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA_SWAP( pOCTVC1_GSM_MSG_TRX_DATA_LOGICAL_CHANNEL_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#ifdef __cplusplus
}

#endif

#endif /* __OCTVC1_GSM_API_SWAP_H__ */
