/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

File: octvc1_main_api_swap.h	

Copyright (c) 2018 Octasic Inc. All rights reserved.	

Description:	

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
	

Release: OCTSDR Software Development Kit OCTSDR_GSM-02.11.00-B1927 (2018/04/27)	

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/	
#ifndef __OCTVC1_MAIN_API_SWAP_H__
#define __OCTVC1_MAIN_API_SWAP_H__

#ifdef __cplusplus
extern "C" {
#endif

/*****************************  INCLUDE FILES  *******************************/
#include "../octvc1_swap_hdrs.h"
#include "octvc1_main_api.h"

/*********************************  MACROS  **********************************/


#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_APPLICATION_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_APPLICATION_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_APPLICATION_MODULE_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_APPLICATION_MODULE_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_APPLICATION_MODULE_CONFIG_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_APPLICATION_MODULE_CONFIG_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_APPLICATION_MODULE_INFO_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_APPLICATION_MODULE_INFO * pOCTVC1_MAIN_APPLICATION_MODULE_INFO = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_APPLICATION_MODULE_INFO)\
	((tOCTVC1_MAIN_APPLICATION_MODULE_INFO *)pOCTVC1_MAIN_APPLICATION_MODULE_INFO)->ulReserved = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_INFO *)pOCTVC1_MAIN_APPLICATION_MODULE_INFO)->ulReserved); \
}
#else
#define mOCTVC1_MAIN_APPLICATION_MODULE_INFO_SWAP( pOCTVC1_MAIN_APPLICATION_MODULE_INFO )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_APPLICATION_MODULE_STATS_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_APPLICATION_MODULE_STATS * pOCTVC1_MAIN_APPLICATION_MODULE_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_APPLICATION_MODULE_STATS)\
	{ mOCTVC1_MAIN_APPLICATION_MODULE_STATE_ENUM_SWAP( &((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulState ); }  \
	{ mOCTVC1_MAIN_APPLICATION_MODULE_CONFIG_STATE_ENUM_SWAP( &((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulConfigState ); }  \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulProcessCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulProcessCnt); \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulIpcLinkCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulIpcLinkCnt); \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulIpcLinkErrCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulIpcLinkErrCnt); \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStartTotalCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStartTotalCnt); \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStartErrCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStartErrCnt); \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStopTotalCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStopTotalCnt); \
	((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStopErrCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_APPLICATION_MODULE_STATS *)pOCTVC1_MAIN_APPLICATION_MODULE_STATS)->ulStopErrCnt); \
}
#else
#define mOCTVC1_MAIN_APPLICATION_MODULE_STATS_SWAP( pOCTVC1_MAIN_APPLICATION_MODULE_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_HEARTBEAT_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_HEARTBEAT_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG * pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG)\
	((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG)->ulWaitTimeMs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG)->ulWaitTimeMs); \
	((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG)->ulIdleOnlyFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG)->ulIdleOnlyFlag); \
}
#else
#define mOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG_SWAP( pOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS * pOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS)\
	{ mOCTVC1_MAIN_HEARTBEAT_STATE_ENUM_SWAP( &((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS)->ulState ); }  \
	((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS)->ulHeartbeatSentCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS *)pOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS)->ulHeartbeatSentCnt); \
}
#else
#define mOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS_SWAP( pOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_SYSTEM_OPEN_PARMS_SWAP( _f_pParms )
#else
#define mOCTVC1_MAIN_FILE_SYSTEM_OPEN_PARMS_SWAP( pOCTVC1_MAIN_FILE_SYSTEM_OPEN_PARMS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS * pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS)\
	((tOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS *)pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS *)pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS)->hFileSystem); \
	((tOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS *)pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS)->ulFileCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS *)pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS)->ulFileCnt); \
	{ mOCTVC1_TRANSPORT_ADDRESS_SWAP( &((tOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS *)pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS)->FileServerAddress ); }  \
}
#else
#define mOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS_SWAP( pOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_TRANSFER_MODE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_FILE_TRANSFER_MODE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_TRANSFER_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_FILE_TRANSFER_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_TRANSFER_STATS_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_FILE_TRANSFER_STATS * pOCTVC1_MAIN_FILE_TRANSFER_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_FILE_TRANSFER_STATS)\
	{ mOCTVC1_MAIN_FILE_TRANSFER_MODE_ENUM_SWAP( &((tOCTVC1_MAIN_FILE_TRANSFER_STATS *)pOCTVC1_MAIN_FILE_TRANSFER_STATS)->Mode ); }  \
	{ mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( &((tOCTVC1_MAIN_FILE_TRANSFER_STATS *)pOCTVC1_MAIN_FILE_TRANSFER_STATS)->Status ); }  \
	{ mOCTVC1_STREAM_STATS_SWAP( &((tOCTVC1_MAIN_FILE_TRANSFER_STATS *)pOCTVC1_MAIN_FILE_TRANSFER_STATS)->Stream ); }  \
}
#else
#define mOCTVC1_MAIN_FILE_TRANSFER_STATS_SWAP( pOCTVC1_MAIN_FILE_TRANSFER_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_FILE_OPEN_MODE_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_FILE_OPEN_MODE_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_STREAM_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_STREAM_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_STREAM_INFO_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_STREAM_INFO * pOCTVC1_MAIN_STREAM_INFO = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_STREAM_INFO)\
	((tOCTVC1_MAIN_STREAM_INFO *)pOCTVC1_MAIN_STREAM_INFO)->hLogicalObj = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_STREAM_INFO *)pOCTVC1_MAIN_STREAM_INFO)->hLogicalObj); \
	{ mOCTVC1_MAIN_STREAM_STATE_ENUM_SWAP( &((tOCTVC1_MAIN_STREAM_INFO *)pOCTVC1_MAIN_STREAM_INFO)->ulState ); }  \
}
#else
#define mOCTVC1_MAIN_STREAM_INFO_SWAP( pOCTVC1_MAIN_STREAM_INFO )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_LOG_TRACE_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_LOG_TRACE_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_LOG_TRACE_STATS_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_LOG_TRACE_STATS * pOCTVC1_MAIN_LOG_TRACE_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_LOG_TRACE_STATS)\
	((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulCurrentFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulCurrentFileSize); \
	((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulCurrentFileIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulCurrentFileIndex); \
	((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulFileOverwriteCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulFileOverwriteCnt); \
	((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulNumFiles = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_STATS *)pOCTVC1_MAIN_LOG_TRACE_STATS)->ulNumFiles); \
}
#else
#define mOCTVC1_MAIN_LOG_TRACE_STATS_SWAP( pOCTVC1_MAIN_LOG_TRACE_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_LOG_TRACE_INFO_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_LOG_TRACE_INFO * pOCTVC1_MAIN_LOG_TRACE_INFO = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_LOG_TRACE_INFO)\
	((tOCTVC1_MAIN_LOG_TRACE_INFO *)pOCTVC1_MAIN_LOG_TRACE_INFO)->ulMaxFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_INFO *)pOCTVC1_MAIN_LOG_TRACE_INFO)->ulMaxFileSize); \
	((tOCTVC1_MAIN_LOG_TRACE_INFO *)pOCTVC1_MAIN_LOG_TRACE_INFO)->ulMaxNumFiles = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_INFO *)pOCTVC1_MAIN_LOG_TRACE_INFO)->ulMaxNumFiles); \
}
#else
#define mOCTVC1_MAIN_LOG_TRACE_INFO_SWAP( pOCTVC1_MAIN_LOG_TRACE_INFO )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_LOG_TRACE_FILTER_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_LOG_TRACE_FILTER * pOCTVC1_MAIN_LOG_TRACE_FILTER = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_LOG_TRACE_FILTER)\
	((tOCTVC1_MAIN_LOG_TRACE_FILTER *)pOCTVC1_MAIN_LOG_TRACE_FILTER)->ulTraceProcessAllFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_LOG_TRACE_FILTER *)pOCTVC1_MAIN_LOG_TRACE_FILTER)->ulTraceProcessAllFlag); \
	{ tOCT_UINT32 jOCTVC1_MAIN_LOG_TRACE_FILTER; \
	for( jOCTVC1_MAIN_LOG_TRACE_FILTER=0; \
		jOCTVC1_MAIN_LOG_TRACE_FILTER<(cOCTVC1_MAIN_LOG_TRACE_FILTER_PROCESS_ENTRY_MAX);jOCTVC1_MAIN_LOG_TRACE_FILTER++ ) \
	{ mOCTVC1_USER_ID_PROCESS_ENUM_SWAP( &((tOCTVC1_MAIN_LOG_TRACE_FILTER *)pOCTVC1_MAIN_LOG_TRACE_FILTER)->aTraceProcessUserId[jOCTVC1_MAIN_LOG_TRACE_FILTER] ); }} \
}
#else
#define mOCTVC1_MAIN_LOG_TRACE_FILTER_SWAP( pOCTVC1_MAIN_LOG_TRACE_FILTER )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_LICENSING_FEATURE_TYPE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_LICENSING_FEATURE_TYPE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_LICENSING_STATUS_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_MAIN_LICENSING_STATUS_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_TARGET_RESET_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_TARGET_RESET_CMD * pOCTVC1_MAIN_MSG_TARGET_RESET_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_TARGET_RESET_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_TARGET_RESET_CMD *)pOCTVC1_MAIN_MSG_TARGET_RESET_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_TARGET_RESET_CMD_SWAP( pOCTVC1_MAIN_MSG_TARGET_RESET_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_TARGET_RESET_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_TARGET_RESET_RSP * pOCTVC1_MAIN_MSG_TARGET_RESET_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_TARGET_RESET_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_TARGET_RESET_RSP *)pOCTVC1_MAIN_MSG_TARGET_RESET_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_TARGET_RESET_RSP_SWAP( pOCTVC1_MAIN_MSG_TARGET_RESET_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_TARGET_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_TARGET_INFO_CMD * pOCTVC1_MAIN_MSG_TARGET_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_TARGET_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_TARGET_INFO_CMD *)pOCTVC1_MAIN_MSG_TARGET_INFO_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_TARGET_INFO_CMD_SWAP( pOCTVC1_MAIN_MSG_TARGET_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_TARGET_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_TARGET_INFO_RSP * pOCTVC1_MAIN_MSG_TARGET_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_TARGET_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_TARGET_INFO_RSP *)pOCTVC1_MAIN_MSG_TARGET_INFO_RSP)->Header ); }  \
	{ mOCTDEV_DEVICES_TYPE_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_TARGET_INFO_RSP *)pOCTVC1_MAIN_MSG_TARGET_INFO_RSP)->ulTargetType ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_TARGET_INFO_RSP_SWAP( pOCTVC1_MAIN_MSG_TARGET_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_ERASE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_ERASE_CMD * pOCTVC1_MAIN_MSG_LOG_ERASE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_ERASE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_ERASE_CMD *)pOCTVC1_MAIN_MSG_LOG_ERASE_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_ERASE_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_ERASE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_ERASE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_ERASE_RSP * pOCTVC1_MAIN_MSG_LOG_ERASE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_ERASE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_ERASE_RSP *)pOCTVC1_MAIN_MSG_LOG_ERASE_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_ERASE_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_ERASE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_INFO_CMD * pOCTVC1_MAIN_MSG_LOG_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_CMD *)pOCTVC1_MAIN_MSG_LOG_INFO_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_INFO_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_INFO_RSP * pOCTVC1_MAIN_MSG_LOG_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_LOG_TRACE_INFO_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_RSP)->LogInfo ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_INFO_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STATS_CMD * pOCTVC1_MAIN_MSG_LOG_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_CMD *)pOCTVC1_MAIN_MSG_LOG_STATS_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STATS_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STATS_RSP * pOCTVC1_MAIN_MSG_LOG_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_LOG_TRACE_STATS_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_RSP)->LogStats ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STATS_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD * pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP * pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP)->ulFullAutoStopFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP)->ulFullAutoStopFlag); \
	{ mOCTVC1_LOG_TRACE_MASK_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP)->ulTraceMask ); }  \
	{ mOCTVC1_MAIN_LOG_TRACE_INFO_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP)->TraceInfo ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_INFO_TRACE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD * pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulFullAutoStopFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulFullAutoStopFlag); \
	{ mOCTVC1_LOG_TRACE_MASK_SWAP( &((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulTraceMask ); }  \
	((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulFileSize); \
	((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulFileNumber = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->ulFileNumber); \
	{ mOCTVC1_MAIN_LOG_TRACE_FILTER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD)->Filter ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_START_TRACE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP * pOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_START_TRACE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD * pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP * pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_STOP_TRACE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD * pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP * pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_ERASE_TRACE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD * pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP * pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_LOG_TRACE_STATE_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->ulState ); }  \
	((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->ulFullAutoStopFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->ulFullAutoStopFlag); \
	{ mOCTVC1_LOG_TRACE_MASK_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->ulTraceMask ); }  \
	{ mOCTVC1_MAIN_LOG_TRACE_STATS_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->TraceStats ); }  \
	{ mOCTVC1_MAIN_LOG_TRACE_FILTER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP *)pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP)->Filter ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_STATS_TRACE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD * pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD)->hProcess); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD_SWAP( pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP * pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->hProcess); \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->ulAlarmThresholdHighPercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->ulAlarmThresholdHighPercent); \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->ulAlarmThresholdLowPercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->ulAlarmThresholdLowPercent); \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->ulMonitorEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP)->ulMonitorEnableFlag); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP_SWAP( pOCTVC1_MAIN_MSG_PROCESS_INFO_CPU_USAGE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_OPEN_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_OPEN_CMD * pOCTVC1_MAIN_MSG_FILE_OPEN_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_OPEN_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_OPEN_CMD *)pOCTVC1_MAIN_MSG_FILE_OPEN_CMD)->Header ); }  \
	{ mOCTVC1_MAIN_FILE_OPEN_MODE_MASK_SWAP( &((tOCTVC1_MAIN_MSG_FILE_OPEN_CMD *)pOCTVC1_MAIN_MSG_FILE_OPEN_CMD)->ulAccessMode ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_OPEN_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_OPEN_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_OPEN_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_OPEN_RSP * pOCTVC1_MAIN_MSG_FILE_OPEN_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_OPEN_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_OPEN_RSP *)pOCTVC1_MAIN_MSG_FILE_OPEN_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_OPEN_RSP *)pOCTVC1_MAIN_MSG_FILE_OPEN_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_OPEN_RSP *)pOCTVC1_MAIN_MSG_FILE_OPEN_RSP)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_OPEN_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_OPEN_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_CLOSE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_CLOSE_CMD * pOCTVC1_MAIN_MSG_FILE_CLOSE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_CLOSE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_CLOSE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_CLOSE_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_CLOSE_CMD)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_CLOSE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_CLOSE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_CLOSE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_CLOSE_RSP * pOCTVC1_MAIN_MSG_FILE_CLOSE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_CLOSE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_CLOSE_RSP *)pOCTVC1_MAIN_MSG_FILE_CLOSE_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_CLOSE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_CLOSE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */


 /* OCTVC1_RENAMED_API */
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_DELETE_FILE_CMD_SWAP mOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_CMD_SWAP


 /* OCTVC1_RENAMED_API */
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_DELETE_FILE_RSP_SWAP mOCTVC1_MAIN_MSG_FILE_SYSTEM_REMOVE_FILE_RSP_SWAP

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_WRITE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_WRITE_CMD * pOCTVC1_MAIN_MSG_FILE_WRITE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_WRITE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_WRITE_CMD *)pOCTVC1_MAIN_MSG_FILE_WRITE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_WRITE_CMD *)pOCTVC1_MAIN_MSG_FILE_WRITE_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_WRITE_CMD *)pOCTVC1_MAIN_MSG_FILE_WRITE_CMD)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_WRITE_CMD *)pOCTVC1_MAIN_MSG_FILE_WRITE_CMD)->ulNumByteToWrite = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_WRITE_CMD *)pOCTVC1_MAIN_MSG_FILE_WRITE_CMD)->ulNumByteToWrite); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_WRITE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_WRITE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_WRITE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_WRITE_RSP * pOCTVC1_MAIN_MSG_FILE_WRITE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_WRITE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_WRITE_RSP *)pOCTVC1_MAIN_MSG_FILE_WRITE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_WRITE_RSP *)pOCTVC1_MAIN_MSG_FILE_WRITE_RSP)->ulNumByteWritten = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_WRITE_RSP *)pOCTVC1_MAIN_MSG_FILE_WRITE_RSP)->ulNumByteWritten); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_WRITE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_WRITE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_READ_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_READ_CMD * pOCTVC1_MAIN_MSG_FILE_READ_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_READ_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_READ_CMD *)pOCTVC1_MAIN_MSG_FILE_READ_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_READ_CMD *)pOCTVC1_MAIN_MSG_FILE_READ_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_READ_CMD *)pOCTVC1_MAIN_MSG_FILE_READ_CMD)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_READ_CMD *)pOCTVC1_MAIN_MSG_FILE_READ_CMD)->ulMaxNumByteToRead = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_READ_CMD *)pOCTVC1_MAIN_MSG_FILE_READ_CMD)->ulMaxNumByteToRead); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_READ_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_READ_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_READ_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_READ_RSP * pOCTVC1_MAIN_MSG_FILE_READ_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_READ_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_READ_RSP *)pOCTVC1_MAIN_MSG_FILE_READ_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_READ_RSP *)pOCTVC1_MAIN_MSG_FILE_READ_RSP)->ulNumByteRead = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_READ_RSP *)pOCTVC1_MAIN_MSG_FILE_READ_RSP)->ulNumByteRead); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_READ_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_READ_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_INFO_CMD * pOCTVC1_MAIN_MSG_FILE_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_INFO_CMD *)pOCTVC1_MAIN_MSG_FILE_INFO_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_INFO_CMD *)pOCTVC1_MAIN_MSG_FILE_INFO_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_INFO_CMD *)pOCTVC1_MAIN_MSG_FILE_INFO_CMD)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_INFO_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_INFO_RSP * pOCTVC1_MAIN_MSG_FILE_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_INFO_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_INFO_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_INFO_RSP)->hFile); \
	{ mOCTVC1_MAIN_FILE_OPEN_MODE_MASK_SWAP( &((tOCTVC1_MAIN_MSG_FILE_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_INFO_RSP)->ulAccessMode ); }  \
	((tOCTVC1_MAIN_MSG_FILE_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_INFO_RSP)->ulMinAlignBytes = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_INFO_RSP)->ulMinAlignBytes); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_INFO_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_LIST_CMD * pOCTVC1_MAIN_MSG_FILE_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_LIST_CMD *)pOCTVC1_MAIN_MSG_FILE_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_FILE_LIST_CMD *)pOCTVC1_MAIN_MSG_FILE_LIST_CMD)->ObjectCursor ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_LIST_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_LIST_RSP * pOCTVC1_MAIN_MSG_FILE_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_LIST_RSP *)pOCTVC1_MAIN_MSG_FILE_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_FILE_LIST_RSP *)pOCTVC1_MAIN_MSG_FILE_LIST_RSP)->ObjectCursor ); }  \
	{ mOCTVC1_LIST_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_FILE_LIST_RSP *)pOCTVC1_MAIN_MSG_FILE_LIST_RSP)->ObjectList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_LIST_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD)->hFileSystem); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP)->InfoParms ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->ulHostOwnerFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->ulHostOwnerFlag); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->ulFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->ulFileSize); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->ulMaxFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP)->ulMaxFileSize); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_INFO_FILE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_INFO_CMD * pOCTVC1_MAIN_MSG_PROCESS_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_INFO_CMD *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_CMD *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CMD)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_CMD *)pOCTVC1_MAIN_MSG_PROCESS_INFO_CMD)->hProcess); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_CMD_SWAP( pOCTVC1_MAIN_MSG_PROCESS_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP * pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)->hProcess); \
	((tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)->ulModuleId); \
	{ mOCTVC1_USER_ID_PROCESS_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_INFO_RSP *)pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP)->ulUserId ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_INFO_RSP_SWAP( pOCTVC1_MAIN_MSG_PROCESS_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_LIST_CMD * pOCTVC1_MAIN_MSG_PROCESS_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_LIST_CMD *)pOCTVC1_MAIN_MSG_PROCESS_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_LIST_CMD *)pOCTVC1_MAIN_MSG_PROCESS_LIST_CMD)->ObjectCursor ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_LIST_CMD_SWAP( pOCTVC1_MAIN_MSG_PROCESS_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_LIST_RSP * pOCTVC1_MAIN_MSG_PROCESS_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_LIST_RSP *)pOCTVC1_MAIN_MSG_PROCESS_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_LIST_RSP *)pOCTVC1_MAIN_MSG_PROCESS_LIST_RSP)->ObjectCursor ); }  \
	{ mOCTVC1_LIST_NAME_OBJECT32_GET_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_LIST_RSP *)pOCTVC1_MAIN_MSG_PROCESS_LIST_RSP)->ObjectNameList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_LIST_RSP_SWAP( pOCTVC1_MAIN_MSG_PROCESS_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD * pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->hProcess); \
	((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->ulAlarmThresholdHighPercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->ulAlarmThresholdHighPercent); \
	((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->ulAlarmThresholdLowPercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->ulAlarmThresholdLowPercent); \
	((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->ulMonitorEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD)->ulMonitorEnableFlag); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD_SWAP( pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP * pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP)->hProcess); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP_SWAP( pOCTVC1_MAIN_MSG_PROCESS_MONITOR_CPU_USAGE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD * pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD)->hProcess); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD_SWAP( pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP * pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->hProcess); \
	((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->ulProcessCpuUsagePercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->ulProcessCpuUsagePercent); \
	((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->ulProcessCpuUsageMinPercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->ulProcessCpuUsageMinPercent); \
	((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->ulProcessCpuUsageMaxPercent = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP *)pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP)->ulProcessCpuUsageMaxPercent); \
}
#else
#define mOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP_SWAP( pOCTVC1_MAIN_MSG_PROCESS_STATS_CPU_USAGE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD)->IndexGet ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP)->IndexGet ); }  \
	{ mOCTVC1_LIST_INDEX_GET_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP)->IndexList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_LIST_SESSION_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP)->ulSessionIndex); \
	{ mOCTVC1_API_SESSION_INFO_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP)->SessionInfo ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP)->ulSessionIndex); \
	{ mOCTVC1_API_SESSION_EVT_INFO_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP)->EvtInfo ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_EVT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)->ulSessionIndex); \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)->ulEvtActiveFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)->ulEvtActiveFlag); \
	{ mOCTVC1_API_SESSION_EVT_SYSTEM_MODULE_MASK_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD)->ulSystemEvtMask ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_EVT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP)->ulSessionIndex); \
	{ mOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP)->Config ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_INFO_SESSION_HEARTBEAT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP)->ulSessionIndex); \
	{ mOCTVC1_MAIN_API_SESSION_HEARTBEAT_STATS_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP)->Stats ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_STATS_SESSION_HEARTBEAT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD)->ulSessionIndex); \
	{ mOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD)->Config ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_START_SESSION_HEARTBEAT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_STOP_SESSION_HEARTBEAT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD * pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD)->ulSessionIndex); \
	{ mOCTVC1_MAIN_API_SESSION_HEARTBEAT_CONFIG_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD)->Config ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP * pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP)->ulSessionIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP *)pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP)->ulSessionIndex); \
}
#else
#define mOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP_SWAP( pOCTVC1_MAIN_MSG_API_SYSTEM_MODIFY_SESSION_HEARTBEAT_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD * pOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD)->ulQuit = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD)->ulQuit); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_STOP_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP * pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP)->ulModuleStopCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP)->ulModuleStopCnt); \
	((tOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP)->ulModuleStopErrCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP)->ulModuleStopErrCnt); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_STOP_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD * pOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP * pOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD * pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP * pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_INFO_SYSTEM_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD * pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD)->ObjectCursor ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP * pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP)->ObjectCursor ); }  \
	{ mOCTVC1_LIST_NAME_OBJECT32_GET_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP)->ObjectNameList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_LIST_MODULE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD * pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD)->ulModuleId); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP * pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP)->ulModuleId); \
	{ mOCTVC1_MAIN_APPLICATION_MODULE_INFO_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP)->Info ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_INFO_MODULE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD * pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD)->ulModuleId); \
	((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD)->ulResetStatsFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD)->ulResetStatsFlag); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP * pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP)->ulModuleId); \
	{ mOCTVC1_MAIN_APPLICATION_MODULE_STATS_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP)->Stats ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_STATS_MODULE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD)->ulMaxFilesize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD)->ulMaxFilesize); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_ADD_FILE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD * pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD *)pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP * pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_STREAM_INFO_SWAP( &((tOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP *)pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP)->Info ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_INFO_STREAM_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD * pOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD *)pOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_START_STREAM_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP * pOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP *)pOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP *)pOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP)->hStreamObj = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP *)pOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP)->hStreamObj); \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_START_STREAM_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD * pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD *)pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD_SWAP( pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP * pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP *)pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP_SWAP( pOCTVC1_MAIN_MSG_LOG_STOP_STREAM_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD * pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD)->ulModuleId); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP * pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP)->ulModuleId); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_START_MODULE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD * pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD)->ulModuleId); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP * pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP)->ulModuleId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP *)pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP)->ulModuleId); \
}
#else
#define mOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP_SWAP( pOCTVC1_MAIN_MSG_APPLICATION_STOP_MODULE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD)->ObjectCursor ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP)->ObjectCursor ); }  \
	{ mOCTVC1_LIST_NAME_OBJECT32_GET_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP)->ObjectNameList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD)->Header ); }  \
	{ mOCTVC1_MAIN_FILE_SYSTEM_OPEN_PARMS_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD)->OpenParms ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP)->hFileSystem); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_OPEN_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LICENSING_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LICENSING_STATS_CMD * pOCTVC1_MAIN_MSG_LICENSING_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LICENSING_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_STATS_CMD *)pOCTVC1_MAIN_MSG_LICENSING_STATS_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LICENSING_STATS_CMD_SWAP( pOCTVC1_MAIN_MSG_LICENSING_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LICENSING_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP * pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_LICENSING_STATUS_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->ulStatus ); }  \
	((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->ulFeatureCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->ulFeatureCount); \
	((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->usInfractionCount = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->usInfractionCount);  \
	((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->usInfractionMaxCount = \
		mOCT_SWAP16_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_STATS_RSP *)pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP)->usInfractionMaxCount);  \
}
#else
#define mOCTVC1_MAIN_MSG_LICENSING_STATS_RSP_SWAP( pOCTVC1_MAIN_MSG_LICENSING_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD * pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD)->ulLicenseId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD)->ulLicenseId); \
}
#else
#define mOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD_SWAP( pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP * pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulLicenseId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulLicenseId); \
	{ mOCTVC1_MAIN_LICENSING_FEATURE_TYPE_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulFeatureType ); }  \
	((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulLicenseValue = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulLicenseValue); \
	((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulCurrentCount = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP)->ulCurrentCount); \
}
#else
#define mOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP_SWAP( pOCTVC1_MAIN_MSG_LICENSING_INFO_FEATURES_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD * pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD *)pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD *)pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD)->ObjectCursor ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD_SWAP( pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP * pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP)->ObjectCursor ); }  \
	{ mOCTVC1_LIST_HANDLE_OBJECT_GET_SWAP( &((tOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP *)pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP)->ObjectList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP_SWAP( pOCTVC1_MAIN_MSG_LICENSING_LIST_FEATURES_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_STOP_FILE_TRANSFER_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->ulNumByteToWrite = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD)->ulNumByteToWrite); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->ulNumByteWritten = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP)->ulNumByteWritten); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_WRITE_FILE_TRANSFER_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->ulMaxNumByteToRead = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD)->ulMaxNumByteToRead); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->ulNumByteRead = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP)->ulNumByteRead); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_READ_FILE_TRANSFER_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD)->hFileSystem); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->ulHostOwnerFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->ulHostOwnerFlag); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->ulFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->ulFileSize); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->ulMaxFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP)->ulMaxFileSize); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_FILE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD)->ulForceFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD)->ulForceFlag); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP)->hFileSystem); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_CLOSE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD)->Header ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP)->Header ); }  \
	{ mOCTVC1_MAIN_FILE_SYSTEM_INFO_PARMS_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP)->InfoParms ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_FIND_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD)->hFile); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)->hFile); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_STATS_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP)->Stats ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_STATS_FILE_TRANSFER_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SUB_OBJECT_ID_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD)->SubObjectIdGet ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_HANDLE_OBJECT_GET_SUB_OBJECT_ID_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP)->SubObjectIdGet ); }  \
	{ mOCTVC1_LIST_HANDLE_OBJECT_GET_SUB_OBJECT_ID_NAME128_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP)->FileNameList ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_LIST_FILE_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD * pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)->hFile); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_MODE_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD)->ulTransferMode ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP * pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->Header ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->ulMinAlignBytes = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP)->ulMinAlignBytes); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_START_FILE_TRANSFER_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA * pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->ModuleData ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->hStream = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->hStream); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_MODE_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->ulTransferMode ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->ulMinAlignBytes = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->ulMinAlignBytes); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->ulToHostStreamSequenceIdInterval = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA)->ulToHostStreamSequenceIdInterval); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_FILE_TRANSFER_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA * pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->ModuleData ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->hStream = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->hStream); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->ulStatus ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->ulFileSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA)->ulFileSize); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_REQUEST_ACK_FILE_TRANSFER_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA * pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->ModuleData ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->hStream = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->hStream); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA)->ulStatus ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_ABORT_FILE_TRANSFER_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA * pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->ModuleData ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->hStream = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->hStream); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->ulStatus ); }  \
	{ mOCTVC1_MAIN_FILE_TRANSFER_MASK_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->ulMask ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->ulDataSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA)->ulDataSize); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_FILE_TRANSFER_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA * pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->ModuleData ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->hFileSystem = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->hFileSystem); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->hFile = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->hFile); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->hStream = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->hStream); \
	{ mOCTVC1_MAIN_FILE_TRANSFER_STATUS_ENUM_SWAP( &((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->ulStatus ); }  \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->ulSequenceId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->ulSequenceId); \
	((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->ulPktAckCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA *)pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA)->ulPktAckCnt); \
}
#else
#define mOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA_SWAP( pOCTVC1_MAIN_MSG_FILE_SYSTEM_DATA_ACK_FILE_TRANSFER_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_MAIN_MSG_LOG_DATA_MDA_SWAP( _f_pParms ){ 	tOCTVC1_MAIN_MSG_LOG_DATA_MDA * pOCTVC1_MAIN_MSG_LOG_DATA_MDA = (_f_pParms); SWAP_UNUSED(pOCTVC1_MAIN_MSG_LOG_DATA_MDA)\
	{ mOCTVC1_MODULE_DATA_SWAP( &((tOCTVC1_MAIN_MSG_LOG_DATA_MDA *)pOCTVC1_MAIN_MSG_LOG_DATA_MDA)->ModuleData ); }  \
}
#else
#define mOCTVC1_MAIN_MSG_LOG_DATA_MDA_SWAP( pOCTVC1_MAIN_MSG_LOG_DATA_MDA )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#ifdef __cplusplus
}

#endif

#endif /* __OCTVC1_MAIN_API_SWAP_H__ */
