
/***** DO NOT EDIT THIS FILE -- THIS CODE IS GENERATED *****
 ***** by gen_ts_55_205_test_sets/pdftxt_2_c.py        *****/

/* gen_ts_55_205_test_sets/main_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <string.h>
#include <inttypes.h>

#include <osmocom/core/application.h>
#include <osmocom/core/utils.h>
#include <osmocom/core/logging.h>
#include <osmocom/core/msgb.h>

#include <osmocom/crypt/auth.h>

#include <osmocom/hlr/logging.h>
#include <osmocom/hlr/auc.h>

#define comment_start() fprintf(stderr, "\n===== %s\n", __func__);
#define comment_end() fprintf(stderr, "===== %s: SUCCESS\n\n", __func__);

#define VERBOSE_ASSERT(val, expect_op, fmt) \
	do { \
		fprintf(stderr, #val " == " fmt "\n", (val)); \
		OSMO_ASSERT((val) expect_op); \
	} while (0);

char *vec_str(const struct osmo_auth_vector *vec)
{
	static char buf[1024];
	char *pos = buf;
	char *end = buf + sizeof(buf);

#define append(what) \
	if (pos >= end) \
		return buf; \
	pos += snprintf(pos, sizeof(buf) - (pos - buf), \
			"  " #what ": %s\n", \
			osmo_hexdump_nospc((void*)&vec->what, sizeof(vec->what)))

	append(rand);
	append(ck);
	append(ik);
	append(res);
	append(kc);
	append(sres);
#undef append

	return buf;
}

#define VEC_IS(vec, expect) do { \
		char *_is = vec_str(vec); \
		if (strcmp(_is, expect)) { \
			fprintf(stderr, "MISMATCH! expected ==\n%s\n", \
				expect); \
			char *a = _is; \
			char *b = expect; \
			for (; *a && *b; a++, b++) { \
				if (*a != *b) { \
					while (a > _is && *(a-1) != '\n') a--; \
					fprintf(stderr, "mismatch at %d:\n" \
						"%s", (int)(a - _is), a); \
					break; \
				} \
			} \
			OSMO_ASSERT(false); \
		} else \
			fprintf(stderr, "vector matches expectations\n"); \
	} while (0)

uint8_t fake_rand[16] = { 0 };

int rand_get(uint8_t *rand, unsigned int len)
{
	OSMO_ASSERT(len <= sizeof(fake_rand));
	memcpy(rand, fake_rand, len);
	return len;
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_1(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("465b5ce8b199b49faa5f0a2ee238a6bc",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("cd63cb71954a9f4e48a5994e37a02baf",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("23553cbe9637a89d218ae64dae47bf35",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 23553cbe9637a89d218ae64dae47bf35\n"
	       "  ck: b40ba9a3c58b2a05bbf0d987b21bf8cb\n"
	       "  ik: f769bcd751044604127672711c6d3441\n"
	       "  res: a54211d5e3ba50bf0000000000000000\n"
	       "  kc: eae4be823af9a08b\n"
	       "  sres: 46f8416a\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_2(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("fec86ba6eb707ed08905757b1bb44b8f",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("1006020f0a478bf6b699f15c062e42b3",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("9f7c8d021accf4db213ccff0c7f71a6a",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 9f7c8d021accf4db213ccff0c7f71a6a\n"
	       "  ck: 5dbdbb2954e8f3cde665b046179a5098\n"
	       "  ik: 59a92d3b476a0443487055cf88b2307b\n"
	       "  res: 8011c48c0c214ed20000000000000000\n"
	       "  kc: aa01739b8caa976d\n"
	       "  sres: 8c308a5e\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_3(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("9e5944aea94b81165c82fbf9f32db751",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("a64a507ae1a2a98bb88eb4210135dc87",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("ce83dbc54ac0274a157c17f80d017bd6",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: ce83dbc54ac0274a157c17f80d017bd6\n"
	       "  ck: e203edb3971574f5a94b0d61b816345d\n"
	       "  ik: 0c4524adeac041c4dd830d20854fc46b\n"
	       "  res: f365cd683cd92e960000000000000000\n"
	       "  kc: 9a8ec95f408cc507\n"
	       "  sres: cfbce3fe\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_4(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("4ab1deb05ca6ceb051fc98e77d026a84",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("dcf07cbd51855290b92a07a9891e523e",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("74b0cd6031a1c8339b2b6ce2b8c4a186",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 74b0cd6031a1c8339b2b6ce2b8c4a186\n"
	       "  ck: 7657766b373d1c2138f307e3de9242f9\n"
	       "  ik: 1c42e960d89b8fa99f2744e0708ccb53\n"
	       "  res: 5860fc1bce351e7e0000000000000000\n"
	       "  kc: cdc1dc0841b81a22\n"
	       "  sres: 9655e265\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_5(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("6c38a116ac280c454f59332ee35c8c4f",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("3803ef5363b947c6aaa225e58fae3934",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("ee6466bc96202c5a557abbeff8babf63",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: ee6466bc96202c5a557abbeff8babf63\n"
	       "  ck: 3f8c7587fe8e4b233af676aede30ba3b\n"
	       "  ik: a7466cc1e6b2a1337d49d3b66e95d7b4\n"
	       "  res: 16c8233f05a0ac280000000000000000\n"
	       "  kc: df75bc5ea899879f\n"
	       "  sres: 13688f17\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_6(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("2d609d4db0ac5bf0d2c0de267014de0d",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("c35a0ab0bcbfc9252caff15f24efbde0",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("194aa756013896b74b4a2a3b0af4539e",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 194aa756013896b74b4a2a3b0af4539e\n"
	       "  ck: 4cd0846020f8fa0731dd47cbdc6be411\n"
	       "  ik: 88ab80a415f15c73711254a1d388f696\n"
	       "  res: 8c25a16cd918a1df0000000000000000\n"
	       "  kc: 84b417ae3aeab4f3\n"
	       "  sres: 553d00b3\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_7(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("a530a7fe428fad1082c45eddfce13884",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("27953e49bc8af6dcc6e730eb80286be3",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("3a4c2b3245c50eb5c71d08639395764d",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 3a4c2b3245c50eb5c71d08639395764d\n"
	       "  ck: 10f05bab75a99a5fbb98a9c287679c3b\n"
	       "  ik: f9ec0865eb32f22369cade40c59c3a44\n"
	       "  res: a63241e1ffc3e5ab0000000000000000\n"
	       "  kc: 3b4e244cdc60ce03\n"
	       "  sres: 59f1a44a\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_8(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("d9151cf04896e25830bf2e08267b8360",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("c4c93effe8a08138c203d4c27ce4e3d9",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("f761e5e93d603feb730e27556cb8a2ca",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: f761e5e93d603feb730e27556cb8a2ca\n"
	       "  ck: 71236b7129f9b22ab77ea7a54c96da22\n"
	       "  ik: 90527ebaa5588968db41727325a04d9e\n"
	       "  res: 4a90b2171ac83a760000000000000000\n"
	       "  kc: 8d4ec01de597acfe\n"
	       "  sres: 50588861\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_9(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("a0e2971b6822e8d354a18cc235624ecb",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("82a26f22bba9e9488f949a10d98e9cc4",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("08eff828b13fdb562722c65c7f30a9b2",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 08eff828b13fdb562722c65c7f30a9b2\n"
	       "  ck: 08cef6d004ec61471a3c3cda048137fa\n"
	       "  ik: ed0318ca5deb9206272f6e8fa64ba411\n"
	       "  res: 4bc2212d8624910a0000000000000000\n"
	       "  kc: d8debc4ffbcd60aa\n"
	       "  sres: cde6b027\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_10(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("0da6f7ba86d5eac8a19cf563ac58642d",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("0db1071f8767562ca43a0a64c41e8d08",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("679ac4dbacd7d233ff9d6806f4149ce3",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 679ac4dbacd7d233ff9d6806f4149ce3\n"
	       "  ck: 69b1cae7c7429d975e245cacb05a517c\n"
	       "  ik: 74f24e8c26df58e1b38d7dcd4f1b7fbd\n"
	       "  res: 6fc30fee6d1235230000000000000000\n"
	       "  kc: f0eaa50a1edcebb7\n"
	       "  sres: 02d13acd\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_11(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("77b45843c88e58c10d202684515ed430",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("d483afae562409a326b5bb0b20c4d762",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("4c47eb3076dc55fe5106cb2034b8cd78",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 4c47eb3076dc55fe5106cb2034b8cd78\n"
	       "  ck: 908c43f0569cb8f74bc971e706c36c5f\n"
	       "  ik: c251df0d888dd9329bcf46655b226e40\n"
	       "  res: aefa357beac2a87a0000000000000000\n"
	       "  kc: 82dbab7f83f063da\n"
	       "  sres: 44389d01\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_12(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("729b17729270dd87ccdf1bfe29b4e9bb",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("228c2f2f06ac3268a9e616ee16db4ba1",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("311c4c929744d675b720f3b7e9b1cbd0",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 311c4c929744d675b720f3b7e9b1cbd0\n"
	       "  ck: 44c0f23c5493cfd241e48f197e1d1012\n"
	       "  ik: 0c9fb81613884c2535dd0eabf3b440d8\n"
	       "  res: 98dbbd099b3b408d0000000000000000\n"
	       "  kc: 3c66cb98cab2d33d\n"
	       "  sres: 03e0fd84\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_13(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("d32dd23e89dc662354ca12eb79dd32fa",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("d22a4b4180a5325708a5ff70d9f67ec7",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("cf7d0ab1d94306950bf12018fbd46887",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: cf7d0ab1d94306950bf12018fbd46887\n"
	       "  ck: 5af86b80edb70df5292cc1121cbad50c\n"
	       "  ik: 7f4d6ae7440e18789a8b75ad3f42f03a\n"
	       "  res: af4a411e1139f2c20000000000000000\n"
	       "  kc: 9612b5d88a4130bb\n"
	       "  sres: be73b3dc\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_14(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("af7c65e1927221de591187a2c5987a53",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("a4cf5c8155c08a7eff418e5443b98e55",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("1f0f8578464fd59b64bed2d09436b57a",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 1f0f8578464fd59b64bed2d09436b57a\n"
	       "  ck: 3f8c3f3ccf7625bf77fc94bcfd22fd26\n"
	       "  ik: abcbae8fd46115e9961a55d0da5f2078\n"
	       "  res: 7bffa5c2f41fbc050000000000000000\n"
	       "  kc: 75a150df3c6aed08\n"
	       "  sres: 8fe019c7\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_15(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("5bd7ecd3d3127a41d12539bed4e7cf71",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("76089d3c0ff3efdc6e36721d4fceb747",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("59b75f14251c75031d0bcbac1c2c04c7",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 59b75f14251c75031d0bcbac1c2c04c7\n"
	       "  ck: d42b2d615e49a03ac275a5aef97af892\n"
	       "  ik: 0b3f8d024fe6bfafaa982b8f82e319c2\n"
	       "  res: 7e3f44c7591f6f450000000000000000\n"
	       "  kc: b7f92e426a36fec5\n"
	       "  sres: 27202b82\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_16(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("6cd1c6ceb1e01e14f1b82316a90b7f3d",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("a219dc37f1dc7d66738b5843c799f206",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("f69b78f300a0568bce9f0cb93c4be4c9",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: f69b78f300a0568bce9f0cb93c4be4c9\n"
	       "  ck: 6edaf99e5bd9f85d5f36d91c1272fb4b\n"
	       "  ik: d61c853c280dd9c46f297baec386de17\n"
	       "  res: 70f6bdb9ad21525f0000000000000000\n"
	       "  kc: 88d9de10a22004c5\n"
	       "  sres: ddd7efe6\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_17(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("b73a90cbcf3afb622dba83c58a8415df",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("df0c67868fa25f748b7044c6e7c245b8",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("b120f1c1a0102a2f507dd543de68281f",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: b120f1c1a0102a2f507dd543de68281f\n"
	       "  ck: 66195dbed0313274c5ca7766615fa25e\n"
	       "  ik: 66bec707eb2afc476d7408a8f2927b36\n"
	       "  res: 479dd25c20792d630000000000000000\n"
	       "  kc: a819e577a8d6175b\n"
	       "  sres: 67e4ff3f\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_18(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("5122250214c33e723a5dd523fc145fc0",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("981d464c7c52eb6e5036234984ad0bcf",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("81e92b6c0ee0e12ebceba8d92a99dfa5",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 81e92b6c0ee0e12ebceba8d92a99dfa5\n"
	       "  ck: 5349fbe098649f948f5d2e973a81c00f\n"
	       "  ik: 9744871ad32bf9bbd1dd5ce54e3e2e5a\n"
	       "  res: 28d7b0f2a2ec3de50000000000000000\n"
	       "  kc: 9a8d0e883ff0887a\n"
	       "  sres: 8a3b8d17\n"
	      );

	comment_end();
}

/* gen_ts_55_205_test_sets/func_template.c: Template to generate test code
 * from 3GPP TS 55.205 test sets */

/* (C) 2016 by sysmocom s.f.m.c. GmbH <info@sysmocom.de>
 *
 * All Rights Reserved
 *
 * Author: Neels Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static void test_set_19(void)
{
	struct osmo_sub_auth_data2 aud2g;
	struct osmo_sub_auth_data2 aud3g;
	struct osmo_auth_vector vec;
	int rc;

	comment_start();

	aud2g = (struct osmo_sub_auth_data2){ 0 };

	aud3g = (struct osmo_sub_auth_data2){
		.type = OSMO_AUTH_TYPE_UMTS,
		.algo = OSMO_AUTH_ALG_MILENAGE,
		.u.umts.k_len = 16,
		.u.umts.opc_len = 16,
		.u.umts.sqn = 31,
	};

	osmo_hexparse("90dca4eda45b53cf0f12d7c9c3bc6a89",
		      aud3g.u.umts.k, sizeof(aud3g.u.umts.k));
	osmo_hexparse("cb9cccc4b9258e6dca4760379fb82581",
		      aud3g.u.umts.opc, sizeof(aud3g.u.umts.opc));

	osmo_hexparse("9fddc72092c6ad036b6e464789315b78",
		      fake_rand, sizeof(fake_rand));

	vec = (struct osmo_auth_vector){ {0} };
	vec.res_len = 8;
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 31, "%"PRIu64);
	rc = auc_compute_vectors(&vec, 1, &aud2g, &aud3g, NULL, NULL);
	VERBOSE_ASSERT(rc, == 1, "%d");
	VERBOSE_ASSERT(aud3g.u.umts.sqn, == 32, "%"PRIu64);

	VEC_IS(&vec,
	       "  rand: 9fddc72092c6ad036b6e464789315b78\n"
	       "  ck: b5f2da03883b69f96bf52e029ed9ac45\n"
	       "  ik: b4721368bc16ea67875c5598688bb0ef\n"
	       "  res: a95100e2760952cd0000000000000000\n"
	       "  kc: ed29b2f1c27f9f34\n"
	       "  sres: df58522f\n"
	      );

	comment_end();
}


int main(int argc, char **argv)
{
	printf("3GPP TS 55.205 Test Sets\n");
	void *tall_ctx = talloc_named_const(NULL, 1, "test");
	msgb_talloc_ctx_init(tall_ctx, 0);
	osmo_init_logging2(tall_ctx, &hlr_log_info);
	log_set_print_filename2(osmo_stderr_target, LOG_FILENAME_NONE);
	log_set_print_timestamp(osmo_stderr_target, 0);
	log_set_use_color(osmo_stderr_target, 0);
	log_set_print_category_hex(osmo_stderr_target, 0);
	log_set_print_category(osmo_stderr_target, 1);
	log_parse_category_mask(osmo_stderr_target, "DMAIN,1:DDB,1:DAUC,1");

	test_set_1();
	test_set_2();
	test_set_3();
	test_set_4();
	test_set_5();
	test_set_6();
	test_set_7();
	test_set_8();
	test_set_9();
	test_set_10();
	test_set_11();
	test_set_12();
	test_set_13();
	test_set_14();
	test_set_15();
	test_set_16();
	test_set_17();
	test_set_18();
	test_set_19();

	printf("Done\n");
	return 0;
}

