#
# spec file for package osmo-pcap
#
# Copyright (c) 2015, Martin Hauke <mardnh@gmx.de>
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

Name:           osmo-pcap
Version:        0.8.0.2-d0b2-dirty
Release:        0
Summary:        Osmocom's PCAP client and server
License:        AGPL-3.0-or-later AND GPL-2.0-or-later
Group:          Productivity/Telephony/Servers
URL:            https://osmocom.org/projects/osmo-pcap
Source:         %{name}-%{version}.tar.xz
BuildRequires:  autoconf
BuildRequires:  automake >= 1.6
BuildRequires:  libpcap-devel
BuildRequires:  libtool
%if 0%{?suse_version}
BuildRequires:  systemd-rpm-macros
%endif
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(gnutls)
BuildRequires:  pkgconfig(libosmo-netif) >= 1.6.0
BuildRequires:  pkgconfig(libosmocore) >= 1.11.0
BuildRequires:  pkgconfig(libosmogb) >= 1.11.0
BuildRequires:  pkgconfig(libosmogsm) >= 1.11.0
BuildRequires:  pkgconfig(libosmovty) >= 1.11.0
BuildRequires:  pkgconfig(libzmq) >= 3.2.2
%{?systemd_requires}

%description
Osmocom tools to help with pcap tracing.
Run osmo_pcap_client locally and send traces to a different system.

%prep
%setup -q

%build
echo "%{version}" >.tarball-version
autoreconf -fi
%configure \
  --docdir=%{_docdir}/%{name} \
  --with-systemdsystemunitdir=%{_unitdir}
make %{?_smp_mflags}

%install
%make_install

%if 0%{?suse_version}
%preun
%service_del_preun osmo-pcap-client.service osmo-pcap-server.service

%postun
%service_del_postun osmo-pcap-client.service osmo-pcap-server.service

%pre
getent group osmocom >/dev/null || groupadd --system osmocom
getent passwd osmocom >/dev/null || useradd --system --gid osmocom --home-dir /var/lib/osmocom \
                                            --shell /sbin/nologin --comment "Open Source Mobile Communications" osmocom
%service_add_pre osmo-pcap-client.service osmo-pcap-server.service

%post
%service_add_post osmo-pcap-client.service osmo-pcap-server.service
%endif

%check
make %{?_smp_mflags} check || (find . -name testsuite.log -exec cat {} +)

%files
%license COPYING
%doc AUTHORS
%doc %{_docdir}/%{name}/examples
%dir %attr(2775, root, osmocom) %{_sysconfdir}/osmocom
%config(noreplace) %{_sysconfdir}/osmocom/osmo-pcap-client.cfg
%config(noreplace) %{_sysconfdir}/osmocom/osmo-pcap-server.cfg
%{_bindir}/osmo-pcap-client
%{_bindir}/osmo-pcap-server
%attr(0660, osmocom, osmocom) %{_unitdir}/osmo-pcap-client.service
%attr(0660, osmocom, osmocom) %{_unitdir}/osmo-pcap-server.service
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/osmo_pcap_clean_old

%changelog
