#include <string.h>
#include <stdint.h>
#include <stdio.h>

#include <osmocom/gsm/gsm23003.h>

#include <osmocom/bb/common/networks.h>

/* list of networks */

static struct gsm_networks gsm_networks[] = {
	{ 0x001, -1,	"Test" },
	{ 0x001, 0x01f,		"Test" },
	{ 0x412, -1,	"Afghanistan" },
	{ 0x412, 0x01f,		"AWCC" },
	{ 0x412, 0x20f,		"Roshan" },
	{ 0x412, 0x30f,		"New1" },
	{ 0x412, 0x40f,		"Areeba" },
	{ 0x412, 0x50f,		"Etisalat" }, /* ? */
	{ 0x412, 0x88f,		"Afghan Telecom" },
	{ 0x276, -1,	"Albania" },
	{ 0x276, 0x01f,		"AMC" },
	{ 0x276, 0x02f,		"Vodafone" },
	{ 0x276, 0x03f,		"Eagle Mobile" },
	{ 0x276, 0x04f,		"Mobile 4 AL" },
	{ 0x603, -1,	"Algeria" },
	{ 0x603, 0x01f,		"Algerie Telecom" },
	{ 0x603, 0x02f,		"Orascom Telecom Algerie" },
	{ 0x603, 0x03f,		"Nedjma" }, /* ? */
	{ 0x213, -1,	"Andorra" },
	{ 0x213, 0x03f,		"Mobiland" },
	{ 0x631, -1,	"Angola" },
	{ 0x631, 0x02f,		"UNITEL" },
	{ 0x365, -1,	"Anguilla" },
	{ 0x365, 0x010,		"Weblinks Limited" },
	{ 0x365, 0x840,		"Cable & Wireless" }, /* ? */
	{ 0x344, -1,	"Antigua and Barbuda" },
	{ 0x344, 0x030,		"APUA PCS" },
	{ 0x338, 0x050,		"Digicel" }, /* ? */
	{ 0x344, 0x920,		"Cable & Wireless (Antigua)" },
	{ 0x344, 0x930,		"AT&T Wireless (Antigua)" },
	{ 0x722, -1,	"Argentina" },
	{ 0x722, 0x010,		"Companie de Radiocomunicatciones Moviles S.A." },
	{ 0x722, 0x020,		"Nextel Argentina srl" },
	{ 0x722, 0x070,		"Telefonica Communicationes Personales S.A." },
	{ 0x722, 0x310,		"CTI PCS S.A" },
	{ 0x722, 0x320,		"Compania de Telefonos del Interior Norte S.A." },
	{ 0x722, 0x330,		"Companie de Telefonos del Interior S.A." },
	{ 0x722, 0x340,		"Personal" }, /* ? */
	{ 0x722, 0x341,		"Telecom Personal S.A." },
	{ 0x722, 0x350,		"Hutchinson (PORT HABLE)" }, /* ? */
	{ 0x283, -1,	"Armenia" },
	{ 0x283, 0x01f,		"Beeline" },
	{ 0x283, 0x05f,		"VivaCell-MTS" },
	{ 0x283, 0x10f,		"Orange" },
	{ 0x363, -1,	"Aruba" },
	{ 0x363, 0x01f,		"SETAR" },
	{ 0x363, 0x02f,		"Digicel" }, /* ? */
	{ 0x505, -1,	"Australia" },
	{ 0x505, 0x01f,		"Telstra" },
	{ 0x505, 0x02f,		"Optus" },
	{ 0x505, 0x03f,		"Vodafone" },
	{ 0x505, 0x04f,		"Department of Defence" },
	{ 0x505, 0x05f,		"Ozitel" },
	{ 0x505, 0x06f,		"Hutchison 3G"},
	{ 0x505, 0x07f,		"Vodafone" },
	{ 0x505, 0x08f,		"One.Tel" },
	{ 0x505, 0x09f,		"Airnet" },
	{ 0x505, 0x10f,		"Norfolk Telecom" },
	{ 0x505, 0x11f,		"Telstra" },
	{ 0x505, 0x12f,		"3" },
	{ 0x505, 0x13f,		"Railcorp" },
	{ 0x505, 0x14f,		"AAPT" },
	{ 0x505, 0x15f,		"3GIS" },
	{ 0x505, 0x16f,		"Victorian Rail Track" },
	{ 0x505, 0x17f,		"Vivid Wireless Pty Ltd" },
	{ 0x505, 0x18f,		"Pactel International Pty Ltd" },
	{ 0x505, 0x19f,		"Lycamobile Pty Ltd" },
	{ 0x505, 0x21f,		"SOUL" }, /* ? */
	{ 0x505, 0x24f,		"Advanced Communications Technologies Pty. Ltd." },
	{ 0x505, 0x38f,		"Crazy John's" }, /* ? */
	{ 0x505, 0x71f,		"Telstra" },
	{ 0x505, 0x72f,		"Telstra" },
	{ 0x505, 0x88f,		"Localstar Holding Pty. Ltd." },
	{ 0x505, 0x90f,		"Optus" },
	{ 0x505, 0x99f,		"One.Tel" },
	{ 0x232, -1,	"Austria" },
	{ 0x232, 0x01f,		"A1" },
	{ 0x232, 0x02f,		"A1" },
	{ 0x232, 0x03f,		"T-Mobile" },
	{ 0x232, 0x04f,		"T-Mobile" },
	{ 0x232, 0x05f,		"Orange" },
	{ 0x232, 0x06f,		"Orange" },
	{ 0x232, 0x07f,		"T-Mobile (tele.ring)" },
	{ 0x232, 0x09f,		"Mobilkom Austria" },
	{ 0x232, 0x10f,		"Hutchison 3G Austria" },
	{ 0x232, 0x11f,		"Mobilkom Austria" },
	{ 0x232, 0x12f,		"Orange Austria" },
	{ 0x232, 0x14f,		"Hutchison 3G Austria" },
	{ 0x232, 0x15f,		"Barablu Mobile Austria" },
	{ 0x232, 0x16f,		"3" }, /* ? */
	{ 0x232, 0x91f,		"OBB - Infrastruktur Bau AG" },
	{ 0x400, -1,	"Azerbaijan" },
	{ 0x400, 0x01f,		"Azercell" },
	{ 0x400, 0x02f,		"Bakcell" },
	{ 0x400, 0x03f,		"Catel JV" },
	{ 0x400, 0x04f,		"Azerphone LLC" },
	{ 0x364, -1,	"Bahamas" },
	{ 0x364, 0x390,		"BaTelCo" },
	{ 0x426, -1,	"Bahrain" },
	{ 0x426, 0x01f,		"BHR Mobile Plus" },
	{ 0x426, 0x02f,		"zain BH" }, /* ? */
	{ 0x426, 0x04f,		"VIVA" }, /* ? */
	{ 0x470, -1,	"Bangladesh" },
	{ 0x470, 0x01f,		"Grameenphone" },
	{ 0x470, 0x02f,		"Aktel" },
	{ 0x470, 0x03f,		"Mobile 2000" },
	{ 0x470, 0x04f,		"TeleTalk" }, /* ? */
	{ 0x470, 0x05f,		"Citycell" }, /* ? */
	{ 0x470, 0x06f,		"Warid" }, /* ? */
	{ 0x470, 0x07f,		"WTBL" }, /* ? */
	{ 0x342, -1,	"Barbados" },
	{ 0x342, 0x600,		"Cable & Wireless (Barbados) Ltd." },
	{ 0x342, 0x750,		"Digicel" }, /* ? */
	{ 0x342, 0x820,		"Sunbeach Communications" },
	{ 0x257, -1,	"Belarus" },
	{ 0x257, 0x01f,		"MCD Velcom" },
	{ 0x257, 0x02f,		"MTS" },
	{ 0x257, 0x04f,		"life:)" }, /* ? */
	{ 0x257, 0x03f,		"DIALLOG" }, /* ? */
	{ 0x206, -1,	"Belgium" },
	{ 0x206, 0x01f,		"Proximus" },
	{ 0x206, 0x02f,		"SNCB GSM-R" }, /* ? */
	{ 0x206, 0x10f,		"Mobistar" },
	{ 0x206, 0x20f,		"BASE" },
	{ 0x702, -1,	"Belize" },
	{ 0x702, 0x67f,		"Belize Telemedia" },
	{ 0x702, 0x68f,		"International Telecommunications Ltd." },
	{ 0x702, 0x00f,		"Smart" }, /* ? */
	{ 0x616, -1,	"Benin" },
	{ 0x616, 0x01f,		"Libercom" },
	{ 0x616, 0x02f,		"Telecel" },
	{ 0x616, 0x03f,		"Spacetel Benin" },
	{ 0x616, 0x04f,		"BBCOM" }, /* ? */
	{ 0x616, 0x05f,		"Glo" }, /* ? */
	{ 0x350, -1,	"Bermuda" },
	{ 0x350, 0x01f,		"Digicel Bermuda" }, /* ? */
	{ 0x350, 0x02f,		"Mobility" }, /* ? */
	{ 0x338, 0x050,		"Digicel Bermuda" }, /* ? */
	{ 0x310, 0x00f,		"Cellular One" }, /* ? */
	{ 0x402, -1,	"Bhutan" },
	{ 0x402, 0x11f,		"Bhutan Telecom Ltd" },
	{ 0x402, 0x77f,		"B-Mobile" },
	{ 0x736, -1,	"Bolivia" },
	{ 0x736, 0x01f,		"Nuevatel" },
	{ 0x736, 0x02f,		"Entel" },
	{ 0x736, 0x03f,		"Telecel" },
	{ 0x218, -1,	"Bosnia and Herzegovina" },
	{ 0x218, 0x03f,		"HT-ERONET" },
	{ 0x218, 0x05f,		"MOBI'S" },
	{ 0x218, 0x90f,		"GSMBIH" },
	{ 0x652, -1,	"Botswana" },
	{ 0x652, 0x01f,		"Mascom" },
	{ 0x652, 0x02f,		"Orange" },
	{ 0x652, 0x04f,		"BTC Mobile" },
	{ 0x724, -1,	"Brazil" },
	{ 0x724, 0x00f,		"Telet" },
	{ 0x724, 0x01f,		"CRT Cellular" },
	{ 0x724, 0x02f,		"TIM" },
	{ 0x724, 0x03f,		"TIM" },
	{ 0x724, 0x04f,		"TIM" },
	{ 0x724, 0x05f,		"Claro" },
	{ 0x724, 0x06f,		"Vivo" },
	{ 0x724, 0x07f,		"CTBC Celular" },
	{ 0x724, 0x08f,		"TIM" },
	{ 0x724, 0x10f,		"Vivo" },
	{ 0x724, 0x11f,		"Vivo" },
	{ 0x724, 0x15f,		"Sercomtel" },
	{ 0x724, 0x16f,		"Oi / Brasil Telecom" },
	{ 0x724, 0x23f,		"Vivo" },
	{ 0x724, 0x24f,		"Oi / Amazonia Celular" },
	{ 0x724, 0x31f,		"Oi" },
	{ 0x724, 0x32f,		"CTBC Celular" },
	{ 0x724, 0x33f,		"CTBC Celular" },
	{ 0x724, 0x34f,		"CTBC Celular" },
	{ 0x724, 0x35f,		"TIM" },
	{ 0x724, 0x37f,		"aeiou" },
	{ 0x724, 0x39f,		"TIM" },
	{ 0x724, 0x41f,		"TIM" },
	{ 0x724, 0x43f,		"TIM" },
	{ 0x724, 0x45f,		"TIM" },
	{ 0x724, 0x47f,		"TIM" },
	{ 0x724, 0x48f,		"TIM" },
	{ 0x724, 0x51f,		"TIM" },
	{ 0x724, 0x53f,		"TIM" },
	{ 0x724, 0x55f,		"TIM" },
	{ 0x724, 0x57f,		"TIM" },
	{ 0x724, 0x59f,		"TIM" },
	{ 0x724, 0x00f,		"Nextel" },
	{ 0x348, -1,	"British Virgin Islands" },
	{ 0x348, 0x170,		"Cable & Wireless" },
	{ 0x348, 0x370,		"BVI Cable TV Ltd" },
	{ 0x348, 0x570,		"CCT Boatphone" },
	{ 0x348, 0x770,		"Digicel (BVI) Ltd" },
	{ 0x528, -1,	"Brunei" },
	{ 0x528, 0x01f,		"Jabatan Telekom" }, /* ? */
	{ 0x528, 0x02f,		"B-Mobile" }, /* ? */
	{ 0x528, 0x11f,		"DSTCom" },
	{ 0x284, -1,	"Bulgaria" },
	{ 0x284, 0x01f,		"M-Tel" },
	{ 0x284, 0x03f,		"Vivacom" }, /* ? */
	{ 0x284, 0x05f,		"GLOBUL" },
	{ 0x613, -1,	"Burkina Faso" },
	{ 0x613, 0x01f,		"Onatel" }, /* ? */
	{ 0x613, 0x02f,		"Celtel / Zain" },
	{ 0x613, 0x03f,		"Telecel Faso" },
	{ 0x642, -1,	"Burundi" },
	{ 0x642, 0x01f,		"Econet / Spacetel" },
	{ 0x642, 0x02f,		"Africell" },
	{ 0x642, 0x03f,		"Onamob" },
	{ 0x642, 0x07f,		"Lacell" },
	{ 0x642, 0x08f,		"Hits" },
	{ 0x642, 0x82f,		"U.COM / Onatel" },
	{ 0x456, -1,	"Cambodia" },
	{ 0x456, 0x01f,		"Mobitel" },
	{ 0x456, 0x02f,		"hello" },
	{ 0x456, 0x03f,		"S Telecom" },
	{ 0x456, 0x04f,		"Cadcomms / qb" },
	{ 0x456, 0x05f,		"Star-Cell" },
	{ 0x456, 0x06f,		"Smart" },
	{ 0x456, 0x08f,		"Viettel" },
	{ 0x456, 0x18f,		"Mfone" },
//	{ 0x456, ?,		"Excell" }, /* ? */
	{ 0x456, 0x09f,		"Beeline" }, /* ? */
	{ 0x456, 0x08f,		"Metfone" }, /* ? */
	{ 0x624, -1,	"Cameroon" },
	{ 0x624, 0x01f,		"MTN Cameroon" },
	{ 0x624, 0x02f,		"Orange" },
	{ 0x302, -1,	"Canada" },
	{ 0x302, 0x220,		"Telus" },
	{ 0x302, 0x221,		"Telus" },
	{ 0x302, 0x290,		"Airtel Wireless" },
	{ 0x302, 0x350,		"FIRST" },
	{ 0x302, 0x360,		"MiKe" },
	{ 0x302, 0x361,		"Telus" },
	{ 0x302, 0x370,		"Fido" },
	{ 0x302, 0x380,		"DMTS" },
	{ 0x302, 0x490,		"WIND Mobile" },
	{ 0x302, 0x500,		"Videotron" },
	{ 0x302, 0x510,		"Videotron" },
	{ 0x302, 0x610,		"Bell" },
	{ 0x302, 0x620,		"ICE Wireless" },
	{ 0x302, 0x640,		"Bell" },
	{ 0x302, 0x651,		"Bell" },
	{ 0x302, 0x652,		"BC Tel Mobility (Telus)" },
	{ 0x302, 0x653,		"Telus" },
	{ 0x302, 0x655,		"MTS" },
	{ 0x302, 0x656,		"TBay" },
	{ 0x302, 0x657,		"Telus" },
	{ 0x302, 0x680,		"SaskTel" },
	{ 0x302, 0x701,		"MB Tel Mobility" },
	{ 0x302, 0x702,		"MT&T Mobility (Aliant)" },
	{ 0x302, 0x703,		"New Tel Mobility (Aliant)" },
	{ 0x302, 0x710,		"Globalstar" },
	{ 0x302, 0x720,		"Rogers Wireless" },
	{ 0x302, 0x780,		"SaskTel" },
	{ 0x302, 0x880,		"Bell / Telus" },
	{ 0x625, -1,	"Cape Verde" },
	{ 0x625, 0x01f,		"CVMOVEL" },
	{ 0x625, 0x02f,		"T+" },
	{ 0x346, -1,	"Cayman Islands" },
	{ 0x346, 0x140,		"Cable & Wireless" },
	{ 0x338, 0x050,		"Digicel" }, /* ? */
	{ 0x623, -1,	"Central African Republic" },
	{ 0x623, 0x01f,		"CTP" },
	{ 0x623, 0x02f,		"TC" },
	{ 0x623, 0x03f,		"Celca / Socatel / Orange" },
	{ 0x623, 0x04f,		"Nationlink" }, /* ? */
	{ 0x622, -1,	"Chad" },
	{ 0x622, 0x01f,		"Celtel / Zain" },
	{ 0x622, 0x02f,		"Tchad Mobile" },
	{ 0x622, 0x03f,		"TIGO - Millicom" }, /* ? */
	{ 0x622, 0x02f,		"TAWALI" }, /* ? */
	{ 0x622, 0x04f,		"Salam" }, /* ? */
	{ 0x730, -1,	"Chile" },
	{ 0x730, 0x01f,		"Entel" },
	{ 0x730, 0x02f,		"movistar" },
	{ 0x730, 0x03f,		"Smartcom / Claro" },
	{ 0x730, 0x04f,		"Centennial Cayman Corp / Nextel" },
	{ 0x730, 0x05f,		"Multikom S.A." },
	{ 0x730, 0x06f,		"Blue Two Chile S.A." },
	{ 0x730, 0x07f,		"Telefonica" },
	{ 0x730, 0x10f,		"Entel" },
	{ 0x730, 0x99f,		"WILL" }, /* ? */
	{ 0x460, -1,	"China" },
	{ 0x460, 0x00f,		"China Mobile" },
	{ 0x460, 0x01f,		"China Unicom" },
	{ 0x460, 0x02f,		"China Mobile" },
	{ 0x460, 0x03f,		"China Unicom CMDA" },
	{ 0x460, 0x04f,		"China Satellite Global Star Network" },
	{ 0x460, 0x05f,		"China Telecom" }, /* ? */
	{ 0x460, 0x06f,		"China Unicom" }, /* ? */
	{ 0x460, 0x20f,		"China TIETONG" }, /* ? */
	{ 0x732, -1,	"Colombia" },
	{ 0x732, 0x001,		"Colombia Telecomunicaciones S.A." },
	{ 0x732, 0x002,		"Edatel" },
	{ 0x732, 0x020,		"Emtelsa" },
	{ 0x732, 0x099,		"Emcali" },
	{ 0x732, 0x101,		"Comcel" },
	{ 0x732, 0x102,		"Bellsouth / movistar" },
	{ 0x732, 0x103,		"Colombia Movil / Tigo" },
	{ 0x732, 0x111,		"Colombia Movil / Tigo" },
	{ 0x732, 0x123,		"movistar" },
	{ 0x732, 0x12f,		"movistar" }, /* ? */
	{ 0x732, 0x130,		"Avantel" },
	{ 0x654, -1,	"Comoros" },
	{ 0x654, 0x01f,		"HURI - SNPT" },
	{ 0x629, -1,	"Republic of the Congo" },
	{ 0x629, 0x01f,		"Celtel / Zain" },
	{ 0x629, 0x10f,		"Libertis Telecom" },
//	{ 0x629, ?,		"Warid Telecom" },
	{ 0x548, -1,	"Cook Islands" },
	{ 0x548, 0x01f,		"Telecom Cook" },
	{ 0x712, -1,	"Costa Rica" },
	{ 0x712, 0x01f,		"ICE" },
	{ 0x712, 0x02f,		"ICE" }, /* ? */
	{ 0x712, 0x03f,		"ICE" }, /* ? */
	{ 0x219, -1,	"Croatia" },
	{ 0x219, 0x01f,		"T-Mobile" },
	{ 0x219, 0x02f,		"Tele2" },
	{ 0x219, 0x10f,		"VIPnet" },
	{ 0x368, -1,	"Cuba" },
	{ 0x368, 0x01f,		"ETECSA" },
	{ 0x280, -1,	"Cyprus" },
	{ 0x280, 0x01f,		"Cytamobile-Vodafone" },
	{ 0x280, 0x10f,		"Scanacom / MTN" },
	{ 0x230, -1,	"Czech Republic" },
	{ 0x230, 0x01f,		"T-Mobile" },
	{ 0x230, 0x02f,		"O2" },
	{ 0x230, 0x03f,		"Vodafone" },
	{ 0x230, 0x04f,		"Mobilkom / U:fon" },
	{ 0x230, 0x98f,		"SZDC s.o." },
	{ 0x230, 0x99f,		"Vodafone" },
	{ 0x630, -1,	"Democratic Republic of the Congo" },
	{ 0x630, 0x01f,		"Vodacom" },
	{ 0x630, 0x02f,		"Zain" }, /* ? */
	{ 0x630, 0x04f,		"Cellco" }, /* ? */
	{ 0x630, 0x05f,		"Supercell" },
	{ 0x630, 0x86f,		"CCT" },
	{ 0x630, 0x89f,		"SAIT Telecom" }, /* ? */
//	{ 0x630, ?,		"Africell" },
	{ 0x238, -1,	"Denmark" },
	{ 0x238, 0x01f,		"TDC" },
	{ 0x238, 0x02f,		"Sonofon / Telenor" },
	{ 0x238, 0x03f,		"MIGway A/S" },
	{ 0x238, 0x05f,		"ApS KBUS" },
	{ 0x238, 0x06f,		"Hi3G" },
	{ 0x238, 0x07f,		"Lycamobile / Barablu Mobile" },
	{ 0x238, 0x09f,		"Dansk Beredskabskommunikation A/S" }, /* ? */
	{ 0x238, 0x10f,		"TDC" },
	{ 0x238, 0x11f,		"Dansk Beredskabskommunikation A/S" }, /* ? */
	{ 0x238, 0x12f,		"Lycamobile Denmark Ltd" },
	{ 0x238, 0x20f,		"Telia" },
	{ 0x238, 0x30f,		"Telia" },
	{ 0x238, 0x40f,		"Ericsson Danmark A/S" }, /* ? */
	{ 0x238, 0x77f,		"Tele2 / Telenor" },
	{ 0x638, -1,	"Djibouti" },
	{ 0x638, 0x01f,		"Evatis" },
	{ 0x366, -1,	"Dominica" },
	{ 0x366, 0x020,		"Digicel" }, /* ? */
	{ 0x366, 0x110,		"Cable &  Wireless" }, /* ? */
	{ 0x370, -1,	"Dominican Republic" },
	{ 0x370, 0x01f,		"Orange" },
	{ 0x370, 0x02f,		"Verizon / Claro" },
	{ 0x370, 0x03f,		"Tricom" },
	{ 0x370, 0x04f,		"CentennialDominicana / Viva" },
	{ 0x514, -1,	"East Timor" },
	{ 0x514, 0x02f,		"Timor Telecom" }, /* ? */
	{ 0x740, -1,	"Ecuador" },
	{ 0x740, 0x00f,		"Otecel / Bellsouth / Movistar" },
	{ 0x740, 0x01f,		"Porta GSM" },
	{ 0x740, 0x02f,		"Telecsa / Alegro" },
	{ 0x602, -1,	"Egypt" },
	{ 0x602, 0x01f,		"Mobinil" },
	{ 0x602, 0x02f,		"Vodafone" },
	{ 0x602, 0x03f,		"Etisalat" },
	{ 0x706, -1,	"El Salvador" },
	{ 0x706, 0x01f,		"CTE Telecom Personal" },
	{ 0x706, 0x02f,		"digicel" },
	{ 0x706, 0x03f,		"Telemovil EL Salvador" },
	{ 0x706, 0x04f,		"movistar" }, /* ? */
	{ 0x706, 0x10f,		"Claro" }, /* ? */
	{ 0x627, -1,	"Equatorial Guinea" },
	{ 0x627, 0x01f,		"Orange GQ" },
	{ 0x627, 0x03f,		"Hits GQ" },
	{ 0x657, -1,	"Eritrea" },
	{ 0x657, 0x01f,		"Eritel" }, /* ? */
	{ 0x248, -1,	"Estonia" },
	{ 0x248, 0x01f,		"EMT" },
	{ 0x248, 0x02f,		"RLE / Elisa" },
	{ 0x248, 0x03f,		"Tele 2" },
	{ 0x248, 0x04f,		"OY Top Connect" },
	{ 0x248, 0x05f,		"AS Bravocom Mobiil" },
	{ 0x248, 0x06f,		"Pro Group Holding / ViaTel" },
	{ 0x248, 0x07f,		"Televorgu AS" },
	{ 0x248, 0x71f,		"Siseministeerium" },
	{ 0x636, -1,	"Ethiopia" },
	{ 0x636, 0x01f,		"ETMTN" },
	{ 0x750, -1,	"Falkland Islands (Malvinas)" },
	{ 0x750, 0x001,		"Touch" },
	{ 0x288, -1,	"Faroe Islands" },
	{ 0x288, 0x01f,		"Faroese Telecom" },
	{ 0x288, 0x02f,		"Kall / Vodafone" },
	{ 0x274, 0x02f,		"P/F Kall" },
	{ 0x542, -1,	"Fiji" },
	{ 0x542, 0x01f,		"Vodafone" },
	{ 0x542, 0x02f,		"Digicel" },
	{ 0x542, 0x03f,		"Telecom Fiji" },
	{ 0x244, -1,	"Finland" },
	{ 0x244, 0x03f,		"DNA" }, /* ? */
	{ 0x244, 0x04f,		"Finnet" },
	{ 0x244, 0x05f,		"Elisa" },
	{ 0x244, 0x07f,		"Nokia" },
	{ 0x244, 0x08f,		"Unknown" },
	{ 0x244, 0x09f,		"Finnet Group" },
	{ 0x244, 0x10f,		"TDC Oy" },
	{ 0x244, 0x12f,		"Finnet Networks / DNA" },
	{ 0x244, 0x14f,		"AMT" },
	{ 0x244, 0x16f,		"Oy Finland Tele2" },
	{ 0x244, 0x21f,		"Saunalahti" },
	{ 0x244, 0x29f,		"Scnl Truphone" }, /* ? */
	{ 0x244, 0x91f,		"Sonera" },
	{ 0x208, -1,	"France" },
	{ 0x208, 0x00f,		"Orange" }, /* ? */
	{ 0x208, 0x01f,		"Orange" },
	{ 0x208, 0x02f,		"Orange" },
	{ 0x208, 0x05f,		"Globalstar Europe" },
	{ 0x208, 0x06f,		"Globalstar Europe" },
	{ 0x208, 0x07f,		"Globalstar Europe" },
	{ 0x208, 0x10f,		"SFR" },
	{ 0x208, 0x11f,		"SFR" },
	{ 0x208, 0x13f,		"SFR" }, /* ? */
	{ 0x208, 0x20f,		"Bouygues" },
	{ 0x208, 0x21f,		"Bouygues" },
	{ 0x208, 0x22f,		"Transatel Mobile" },
	{ 0x208, 0x88f,		"Bouygues" },
	{ 0x628, -1,	"Gabon" },
	{ 0x628, 0x01f,		"Libertis" },
	{ 0x628, 0x02f,		"Moov (Telecel) Gabon S.A." },
	{ 0x628, 0x03f,		"Celtel / Zain" },
	{ 0x628, 0x04f,		"USAN Gabon" },
	{ 0x607, -1,	"Gambia" },
	{ 0x607, 0x01f,		"Gamcel" },
	{ 0x607, 0x02f,		"Africel" },
	{ 0x607, 0x03f,		"Comium" },
	{ 0x607, 0x04f,		"QCell" }, /* ? */
	{ 0x282, -1,	"Georgia" },
	{ 0x282, 0x01f,		"Geocell" },
	{ 0x282, 0x02f,		"MagtiCom" },
	{ 0x282, 0x03f,		"Iberiatel" },
	{ 0x282, 0x04f,		"Beeline" },
	{ 0x282, 0x05f,		"Silknet JSC" },
	{ 0x289, 0x67f,		"Aquafon" }, /* ? */
	{ 0x289, 0x88f,		"A-Mobile" }, /* ? */
	{ 0x262, -1,	"Germany" },
	{ 0x262, 0x01f,		"T-Mobile" },
	{ 0x262, 0x02f,		"Vodafone" },
	{ 0x262, 0x03f,		"E-Plus" },
	{ 0x262, 0x04f,		"Vodafone" },
	{ 0x262, 0x05f,		"E-Plus" },
	{ 0x262, 0x06f,		"T-Mobile" },
	{ 0x262, 0x07f,		"O2" },
	{ 0x262, 0x08f,		"O2" },
	{ 0x262, 0x09f,		"Vodafone" },
	{ 0x262, 0x10f,		"DB Netz AG GSM-R" },
	{ 0x262, 0x11f,		"O2" },
	{ 0x262, 0x12f,		"Dolphin Telecom" },
	{ 0x262, 0x13f,		"Mobilcom Multimedia" },
	{ 0x262, 0x14f,		"Group 3G UMTS" },
	{ 0x262, 0x15f,		"Airdata" },
	{ 0x262, 0x16f,		"Vistream" }, /* ? */
	{ 0x262, 0x42f,		"OpenBSC" }, /* ? */
	{ 0x262, 0x60f,		"DB Telematik" },
	{ 0x262, 0x76f,		"Siemens AG" },
	{ 0x262, 0x77f,		"E-Plus" },
	{ 0x262, 0x901,		"Debitel" }, /* ? */
	{ 0x620, -1,	"Ghana" },
	{ 0x620, 0x01f,		"Spacefon / MTN" },
	{ 0x620, 0x02f,		"Ghana Telecom Mobile / Vodafone" },
	{ 0x620, 0x03f,		"Mobiltel / tiGO" },
	{ 0x620, 0x04f,		"Kasapa / Hutchison Telecom" },
	{ 0x620, 0x06f,		"Zain" }, /* ? */
	{ 0x620, 0x10f,		"Netafriques" }, /* ? */
	{ 0x266, -1,	"Gibraltar" },
	{ 0x266, 0x01f,		"GibTel" },
	{ 0x266, 0x06f,		"CTS Mobile" },
	{ 0x266, 0x09f,		"Cloud9 Mobile Communications" },
	{ 0x202, -1,	"Greece" },
	{ 0x202, 0x01f,		"Cosmote" },
	{ 0x202, 0x05f,		"Vodafone" },
	{ 0x202, 0x09f,		"Infoquest / Wind" },
	{ 0x202, 0x10f,		"Wind" },
	{ 0x290, -1,	"Greenland" },
	{ 0x290, 0x01f,		"TELE Greenland A/S" },
	{ 0x352, -1,	"Grenada" },
	{ 0x352, 0x030,		"Digicel" },
	{ 0x352, 0x110,		"Cable &  Wireless" },
	{ 0x340, -1,	"Guadeloupe" },
	{ 0x340, 0x01f,		"Orange" },
	{ 0x340, 0x02f,		"Outremer" },
	{ 0x340, 0x03f,		"Telcell" },
	{ 0x340, 0x08f,		"MIO GSM" },
	{ 0x340, 0x10f,		"Guadeloupe Telephone Mobile" },
	{ 0x340, 0x20f,		"Digicel" },
	{ 0x310, -1,	"United States of America" },
	{ 0x310, 0x010,		"Verizon Wireless" },
	{ 0x310, 0x012,		"Verizon Wireless" },
	{ 0x310, 0x013,		"Verizon Wireless" },
	{ 0x310, 0x016,		"Cricket Communications" },
	{ 0x310, 0x017,		"North Sight Communications Inc." },
	{ 0x310, 0x020,		"Union Telephone Company" },
	{ 0x310, 0x030,		"Centennial Communications" },
	{ 0x310, 0x035,		"ETEX Communications dba ETEX Wireless" },
	{ 0x310, 0x040,		"MTA Communications dba MTA Wireless" },
	{ 0x310, 0x050,		"ACS Wireless Inc." },
	{ 0x310, 0x060,		"Consolidated Telecom" },
	{ 0x310, 0x070,		"Cingular Wireless" },
	{ 0x310, 0x080,		"Corr Wireless Communications LLC" },
	{ 0x310, 0x090,		"Cingular Wireless" },
	{ 0x310, 0x100,		"New Mexicu RSA 4 East Ltd. Partnership" },
	{ 0x310, 0x110,		"Pacific Telecom Inc." },
	{ 0x310, 0x130,		"Carolina West Wireless" },
	{ 0x310, 0x140,		"GTA Wireless LLC" },
	{ 0x310, 0x150,		"Cingular Wireless" },
	{ 0x310, 0x160,		"T-Mobile USA" },
	{ 0x310, 0x170,		"Cingular Wireless" },
	{ 0x310, 0x180,		"West Central Wireless" },
	{ 0x310, 0x190,		"Alaska Wireless Communications LLC" },
	{ 0x310, 0x200,		"T-Mobile USA" },
	{ 0x310, 0x210,		"T-Mobile USA" },
	{ 0x310, 0x220,		"T-Mobile USA" },
	{ 0x310, 0x230,		"T-Mobile USA" },
	{ 0x310, 0x240,		"T-Mobile USA" },
	{ 0x310, 0x250,		"T-Mobile USA" },
	{ 0x310, 0x260,		"T-Mobile USA" },
	{ 0x310, 0x270,		"T-Mobile USA" },
	{ 0x310, 0x280,		"Contennial Puerto Rio License Corp." },
	{ 0x310, 0x290,		"Nep Cellcorp Inc." },
	{ 0x310, 0x300,		"Blanca Telephone Company" },
	{ 0x310, 0x310,		"T-Mobile USA" },
	{ 0x310, 0x320,		"Simth Bagley Inc, dba Cellular One" },
	{ 0x310, 0x340,		"High Plains Midwest LLC, dba Wetlink Communications" },
	{ 0x310, 0x350, 	"Mohave Cellular L.P." },
	{ 0x310, 0x360,		"Cellular Network Partnership dba Pioneer Cellular" },
	{ 0x310, 0x370,		"Guamcell Cellular and Paging" },
	{ 0x310, 0x380, 	"New Cingular Wireless PCS, LLC" },
	{ 0x310, 0x390,		"TX-11 Acquisition LLC" },
	{ 0x310, 0x400,		"Wave Runner LLC" },
	{ 0x310, 0x410,		"Cingular Wireless" },
	{ 0x310, 0x420,		"Cincinnati Bell Wireless LLC" },
	{ 0x310, 0x430,		"Alaska Digital LLC" },
	{ 0x310, 0x440,		"Numerex Corp" },
	{ 0x310, 0x450,		"North East Cellular Inc" },
	{ 0x310, 0x460,		"TMP Corporation" },
	{ 0x310, 0x470,		"nTELOS Communications Inc" },
	{ 0x310, 0x480,		"Choice Phone LLC" },
	{ 0x310, 0x490,		"T-Mobile USA" },
	{ 0x310, 0x500,		"Public Service Cellular, Inc." },
	{ 0x310, 0x520,		"Transactions Network Services" },
	{ 0x310, 0x530,		"Iowa Wireless Services LLC" },
	{ 0x310, 0x540,		"Oklahoma Western Telephone Company" },
	{ 0x310, 0x550,		"Wireless Solutions International" },
	{ 0x310, 0x560,		"Cingular Wireless" },
	{ 0x310, 0x570,		"MTPCS LLC" },
	{ 0x310, 0x580,		"Inland Celluar Telephone Company" },
	{ 0x310, 0x590,		"Western Wireless Corporation" },
	{ 0x310, 0x600,		"New Cell Inc. dba Cellcom" },
	{ 0x310, 0x610,		"Elkhart Telephone Co. Inc. dba Epic Touch Co." },
	{ 0x310, 0x620,		"Coleman County Telecommunications Inc. (Trans Texas PCS)" },
	{ 0x310, 0x640,		"Airadigm Communications" },
	{ 0x310, 0x650,		"Jasper Wireless Inc." },
	{ 0x310, 0x660,		"T-Mobile USA" },
	{ 0x310, 0x670,		"AT&T Mobility Vanguard Services" },
	{ 0x310, 0x680,		"Cingular Wireless" },
	{ 0x310, 0x690,		"Keystane Wireless LLC" },
	{ 0x310, 0x700,		"Cross Valiant Cellular Partnership" },
	{ 0x310, 0x710,		"Arctic Slope Telephone Association Cooperative" },
	{ 0x310, 0x720,		"Wireless Solutions International Inc." },
	{ 0x310, 0x730,		"US Cellular" },
	{ 0x310, 0x740,		"Convey Communications Inc" },
	{ 0x310, 0x750,		"East Kentucky Network LLC dba Appalachian Wireless" },
	{ 0x310, 0x760,		"Lynch 3G Communcations Corporation" },
	{ 0x310, 0x770,		"Iowa Wireless Services LLC dba I Wireless" },
	{ 0x310, 0x780,		"Connect Net Inc" },
	{ 0x310, 0x790,		"PinPoint Communications Inc."},
	{ 0x310, 0x800,		"T-Mobile USA" },
	{ 0x310, 0x810,		"LCFR LLC" },
	{ 0x310, 0x820,		"South Canaan Cellular Communications Co. LP" },
	{ 0x310, 0x830,		"Caprock Cellular Ltd. Partnership" },
	{ 0x310, 0x840,		"Telecom North America Mobile Inc" },
	{ 0x310, 0x850,		"Aeris Communications Inc." },
	{ 0x310, 0x860,		"TX RSA 15B2, LP dba Five Star Wireless" },
	{ 0x310, 0x870,		"Kaplan Telephone Company, Inc" },
	{ 0x310, 0x890,		"Rural Cellular Corporation" },
	{ 0x310, 0x900,		"Cable & Communications Corporation dba Mid-Rivers Wireless" },
	{ 0x310, 0x910,		"Verizon Wireless" },
	{ 0x310, 0x930,		"Copper Valley Wireless" },
	{ 0x310, 0x940,		"Iris Wireless LLC" },
	{ 0x310, 0x950,		"Texas RSA 1 dba XIT Wireless" },
	{ 0x310, 0x960,		"UBET Wireless" },
	{ 0x310, 0x970,		"Globalstar USA" },
	{ 0x310, 0x980,		"Texas RSA 7B3 dba Peoples Wireless Services" },
	{ 0x310, 0x99,		"Worldcall Interconnect" },

	{ 0x704, -1,	"Guatemala" },
	{ 0x704, 0x01f,		"Claro" },
	{ 0x704, 0x02f,		"Comcel / Tigo" },
	{ 0x704, 0x03f,		"movistar" },
//	{ 0x704, ?,		"digicel" },
	{ 0x234, -1,	"Guernsey" },
	{ 0x234, 0x55f,		"Sure Mobile" },
	{ 0x234, 0x50f,		"Wave Telecom" },
	{ 0x234, 0x03f,		"Airtel Vodafone" },
	{ 0x611, -1,	"Guinea" },
	{ 0x611, 0x01f,		"Orange / Spacetel" },
	{ 0x611, 0x02f,		"Sotelgui / Lagui" },
	{ 0x611, 0x03f,		"Telecel Guinee" }, /* ? */
	{ 0x611, 0x04f,		"MTN" }, /* ? */
	{ 0x611, 0x05f,		"Cellcom Guinee" },
	{ 0x632, -1,	"Guinea-Bissau" },
	{ 0x632, 0x01f,		"Guinetel" },
	{ 0x632, 0x02f,		"Spacetel / Areeba" },
	{ 0x632, 0x03f,		"Orange" },
	{ 0x738, -1,	"Guyana" },
	{ 0x738, 0x01f,		"Digicel" },
	{ 0x738, 0x02f,		"GT&T Cellink Plus" }, /* ? */
	{ 0x372, -1,	"Haiti" },
	{ 0x372, 0x01f,		"Comcel / Voila" },
	{ 0x338, 0x050,		"Digicel" },
	{ 0x338, 0x03f,		"Rectel" },
	{ 0x708, -1,	"Honduras" },
	{ 0x708, 0x01f,		"Claro" },
	{ 0x708, 0x02f,		"Celtel / Tigo" },
	{ 0x708, 0x30f,		"Hondutel" }, /* ? */
	{ 0x708, 0x40f,		"DIGICEL" },
	{ 0x454, -1,	"Hong Kong" },
	{ 0x454, 0x00f,		"1O1O and One2Free" },
	{ 0x454, 0x01f,		"CITIC Telecom 1616" },
	{ 0x454, 0x02f,		"CSL Limited" },
	{ 0x454, 0x03f,		"3 (3G)" },
	{ 0x454, 0x04f,		"3 DualBand (2G)" },
	{ 0x454, 0x05f,		"3 CDMA" },
	{ 0x454, 0x06f,		"SmarTone-Vodafone" },
	{ 0x454, 0x07f,		"China Unicom (Hong Kong) Limited" },
	{ 0x454, 0x08f,		"Trident" },
	{ 0x454, 0x09f,		"China Motion Telecom" },
	{ 0x454, 0x10f,		"New World Mobility" },
	{ 0x454, 0x11f,		"China-Hongkong Telecom" },
	{ 0x454, 0x12f,		"CMCC HK" },
	{ 0x454, 0x14f,		"Hutchison Telecom" },
	{ 0x454, 0x15f,		"SmarTone Mobile Communications Limited" },
	{ 0x454, 0x16f,		"PCCW Mobile (2G)" },
	{ 0x454, 0x17f,		"SmarTone Mobile Communications Limited" },
	{ 0x454, 0x18f,		"CSL Limited" },
	{ 0x454, 0x19f,		"Sunday3G" },
	{ 0x454, 0x19f,		"PCCW Mobile (3G)" },
	{ 0x454, 0x29f,		"PCCW Mobile (CDMA)" },
	{ 0x216, -1,	"Hungary" },
	{ 0x216, 0x01f,		"Pannon GSM" },
	{ 0x216, 0x30f,		"Westel 900" },
	{ 0x216, 0x70f,		"Vodafone" },
	{ 0x274, -1,	"Iceland" },
	{ 0x274, 0x01f,		"Siminn" },
	{ 0x274, 0x02f,		"Vodafone" },
	{ 0x274, 0x03f,		"Vodafone" },
	{ 0x274, 0x04f,		"IMC Viking" },
	{ 0x274, 0x06f,		"N?ll n?u ehf" }, /* ? */
	{ 0x274, 0x07f,		"IceCell" },
	{ 0x274, 0x08f,		"On-waves" },
	{ 0x274, 0x11f,		"Nova" },
	/* FIXME: update the list from here below */
	{ 0x404, -1,	"India" },
	{ 0x404, 0x01f,		"Vodafone IN" },
	{ 0x404, 0x02f,		"AirTel" },
	{ 0x404, 0x04f,		"IDEA" },
	{ 0x404, 0x05f,		"Vodafone IN" },
	{ 0x404, 0x07f,		"IDEA" },
	{ 0x404, 0x09f,		"Reliance" },
	{ 0x404, 0x10f,		"AirTel" },
	{ 0x404, 0x11f,		"Vodafone IN" },
	{ 0x404, 0x12f,		"IDEA" },
	{ 0x404, 0x13f,		"Vodafone IN" },
	{ 0x404, 0x14f,		"IDEA" },
	{ 0x404, 0x15f,		"Vodafone IN" },
	{ 0x404, 0x17f,		"AIRCEL" },
	{ 0x404, 0x19f,		"IDEA" },
	{ 0x404, 0x20f,		"Vodafone IN" },
	{ 0x404, 0x21f,		"Loop Mobile" },
	{ 0x404, 0x22f,		"IDEA" },
	{ 0x404, 0x24f,		"IDEA" },
	{ 0x404, 0x27f,		"Vodafone IN" },
	{ 0x404, 0x28f,		"AIRCEL" },
	{ 0x404, 0x29f,		"AIRCEL" },
	{ 0x404, 0x30f,		"Vodafone IN" },
	{ 0x404, 0x31f,		"AirTel" },
	{ 0x404, 0x34f,		"CellOne" },
	{ 0x404, 0x36f,		"Reliance" },
	{ 0x404, 0x37f,		"Aircel" },
	{ 0x404, 0x38f,		"CellOne" },
	{ 0x404, 0x41f,		"Aircel" },
	{ 0x404, 0x42f,		"Aircel" },
	{ 0x404, 0x44f,		"IDEA" },
	{ 0x404, 0x45f,		"Airtel" },
	{ 0x404, 0x51f,		"CellOne" },
	{ 0x404, 0x52f,		"Reliance" },
	{ 0x404, 0x53f,		"CellOne" },
	{ 0x404, 0x54f,		"CellOne" },
	{ 0x404, 0x55f,		"CellOne" },
	{ 0x404, 0x56f,		"IDEA" },
	{ 0x404, 0x57f,		"CellOne" },
	{ 0x404, 0x58f,		"CellOne" },
	{ 0x404, 0x59f,		"CellOne" },
	{ 0x404, 0x60f,		"Vodafone IN" },
	{ 0x404, 0x62f,		"CellOne" },
	{ 0x404, 0x64f,		"CellOne" },
	{ 0x404, 0x66f,		"CellOne" },
	{ 0x404, 0x67f,		"Reliance GSM" },
	{ 0x404, 0x68f,		"DOLPHIN" },
	{ 0x404, 0x69f,		"DOLPHIN" },
	{ 0x404, 0x72f,		"CellOne" },
	{ 0x404, 0x74f,		"CellOne" },
	{ 0x404, 0x76f,		"CellOne" },
	{ 0x404, 0x78f,		"Idea Cellular Ltd" },
	{ 0x404, 0x80f,		"BSNL MOBILE" },
	{ 0x404, 0x81f,		"CellOne" },
	{ 0x404, 0x82f,		"Idea" },
	{ 0x404, 0x83f,		"Reliance Smart GSM" },
	{ 0x404, 0x84f,		"Vodafone IN" },
	{ 0x404, 0x85f,		"Reliance" },
	{ 0x404, 0x86f,		"Vodafone IN" },
	{ 0x404, 0x90f,		"AirTel" },
	{ 0x404, 0x91f,		"AIRCEL" },
	{ 0x404, 0x92f,		"AirTel" },
	{ 0x404, 0x93f,		"AirTel" },
	{ 0x404, 0x96f,		"AirTel" },
	{ 0x405, 0x05f,		"Reliance" },
	{ 0x405, 0x10f,		"Reliance" },
	{ 0x405, 0x13f,		"Reliance" },
	{ 0x405, 0x025,		"TATA DOCOMO" },
	{ 0x405, 0x026,		"TATA DOCOMO" },
	{ 0x405, 0x027,		"TATA DOCOMO" },
	{ 0x405, 0x029,		"TATA DOCOMO" },
	{ 0x405, 0x030,		"TATA DOCOMO" },
	{ 0x405, 0x031,		"TATA DOCOMO" },
	{ 0x405, 0x032,		"TATA DOCOMO" },
	{ 0x405, 0x034,		"TATA DOCOMO" },
	{ 0x405, 0x035,		"TATA DOCOMO" },
	{ 0x405, 0x036,		"TATA DOCOMO" },
	{ 0x405, 0x037,		"TATA DOCOMO" },
	{ 0x405, 0x038,		"TATA DOCOMO" },
	{ 0x405, 0x039,		"TATA DOCOMO" },
	{ 0x405, 0x041,		"TATA DOCOMO" },
	{ 0x405, 0x042,		"TATA DOCOMO" },
	{ 0x405, 0x043,		"TATA DOCOMO" },
	{ 0x405, 0x044,		"TATA DOCOMO" },
	{ 0x405, 0x045,		"TATA DOCOMO" },
	{ 0x405, 0x046,		"TATA DOCOMO" },
	{ 0x405, 0x047,		"TATA DOCOMO" },
	{ 0x405, 0x51f,		"AirTel" },
	{ 0x405, 0x52f,		"AirTel" },
	{ 0x405, 0x54f,		"AirTel" },
	{ 0x405, 0x56f,		"AirTel" },
	{ 0x405, 0x66f,		"Vodafone IN" },
	{ 0x405, 0x70f,		"IDEA" },
	{ 0x405, 0x750,		"Vodafone IN" },
	{ 0x405, 0x751,		"Vodafone IN" },
	{ 0x405, 0x752,		"Vodafone IN" },
	{ 0x405, 0x753,		"Vodafone IN" },
	{ 0x405, 0x754,		"Vodafone IN" },
	{ 0x405, 0x755,		"Vodafone IN" },
	{ 0x405, 0x756,		"Vodafone IN" },
	{ 0x405, 0x799,		"IDEA" },
	{ 0x405, 0x800,		"AIRCEL" },
	{ 0x405, 0x801,		"AIRCEL" },
	{ 0x405, 0x802,		"AIRCEL" },
	{ 0x405, 0x803,		"AIRCEL" },
	{ 0x405, 0x804,		"AIRCEL" },
	{ 0x405, 0x805,		"AIRCEL" },
	{ 0x405, 0x806,		"AIRCEL" },
	{ 0x405, 0x807,		"AIRCEL" },
	{ 0x405, 0x808,		"AIRCEL" },
	{ 0x405, 0x809,		"AIRCEL" },
	{ 0x405, 0x810,		"AIRCEL" },
	{ 0x405, 0x811,		"AIRCEL" },
	{ 0x405, 0x812,		"AIRCEL" },
	{ 0x405, 0x819,		"Uninor" },
	{ 0x405, 0x818,		"[Uninor]" },
	{ 0x405, 0x820,		"Uninor" },
	{ 0x405, 0x821,		"Uninor" },
	{ 0x405, 0x822,		"Uninor" },
	{ 0x405, 0x880,		"Uninor" },
	{ 0x405, 0x824,		"Videocon Datacom" },
	{ 0x405, 0x834,		"Videocon Datacom" },
	{ 0x405, 0x844,		"Uninor" },
	{ 0x405, 0x845,		"IDEA" },
	{ 0x405, 0x848,		"IDEA" },
	{ 0x405, 0x850,		"IDEA" },
	{ 0x405, 0x855,		"Loop Mobile" },
	{ 0x405, 0x864,		"Loop Mobile" },
	{ 0x405, 0x865,		"Loop Mobile" },
	{ 0x405, 0x875,		"Uninor" },
	{ 0x405, 0x881,		"S Tel" },
	{ 0x405, 0x912,		"Etisalat DB" },
	{ 0x405, 0x913,		"Etisalat DB" },
	{ 0x405, 0x917,		"Etisalat DB" },
	{ 0x405, 0x929,		"Uninor" },
	{ 0x510, -1,	"Indonesia" },
	{ 0x510, 0x00f,		"PSN" },
	{ 0x510, 0x01f,		"INDOSAT" },
	{ 0x510, 0x03f,		"StarOne" },
	{ 0x510, 0x07f,		"TelkomFlexi" },
	{ 0x510, 0x08f,		"AXIS" },
	{ 0x510, 0x09f,		"SMART" },
	{ 0x510, 0x10f,		"Telkomsel" },
	{ 0x510, 0x11f,		"XL" },
	{ 0x510, 0x20f,		"TELKOMMobile" },
	{ 0x510, 0x21f,		"IM3" },
	{ 0x510, 0x27f,		"Ceria" },
	{ 0x510, 0x28f,		"Fren/Hepi" },
	{ 0x510, 0x89f,		"3" },
	{ 0x510, 0x99f,		"Esia " },
	{ 0x432, -1,	"Iran" },
	{ 0x432, 0x11f,		"MCI" },
	{ 0x432, 0x14f,		"TKC" },
	{ 0x432, 0x19f,		"MTCE" },
	{ 0x432, 0x32f,		"Taliya" },
	{ 0x432, 0x35f,		"Irancell" },
	{ 0x418, -1,	"Iraq" },
	{ 0x418, 0x20f,		"Zain IQ" },
	{ 0x418, 0x30f,		"Zain IQ" },
	{ 0x418, 0x05f,		"Asia Cell" },
	{ 0x418, 0x40f,		"Korek" },
	{ 0x418, 0x08f,		"SanaTel" },
//	{ 0x418, ?,		"IRAQNA" },
	{ 0x272, -1,	"Ireland" },
	{ 0x272, 0x01f,		"Vodafone" },
	{ 0x272, 0x02f,		"O2" },
	{ 0x272, 0x03f,		"Meteor" },
	{ 0x272, 0x04f,		"Access Telecom" },
	{ 0x272, 0x05f,		"3" },
	{ 0x272, 0x07f,		"Eircom" },
	{ 0x272, 0x09f,		"Clever Communications" },
	{ 0x234, -1,	"Isle of Man" },
	{ 0x234, 0x58f,		"Pronto GSM" },
	{ 0x425, -1,	"Israel" },
	{ 0x425, 0x01f,		"Orange" },
	{ 0x425, 0x02f,		"Cellcom" },
	{ 0x425, 0x03f,		"Pelephone" },
	{ 0x425, 0x77f,		"Mirs" },
	{ 0x222, -1,	"Italy" },
	{ 0x222, 0x01f,		"TIM" },
	{ 0x222, 0x02f,		"Elsacom" },
	{ 0x222, 0x10f,		"Vodafone" },
	{ 0x222, 0x30f,		"RFI" },
	{ 0x222, 0x77f,		"IPSE 2000" },
	{ 0x222, 0x88f,		"Wind" },
	{ 0x222, 0x98f,		"Blu" },
	{ 0x222, 0x99f,		"3 Italia" },
	{ 0x612, -1,	"Ivory Coast" },
	{ 0x612, 0x01f,		"Cora de Comstar" },
	{ 0x612, 0x02f,		"Moov" },
	{ 0x612, 0x03f,		"Orange" },
	{ 0x612, 0x04f,		"KoZ" },
	{ 0x612, 0x05f,		"MTN" },
	{ 0x612, 0x06f,		"ORICEL" },
	{ 0x338, -1,	"Jamaica" },
	{ 0x338, 0x020,		"LIME (formerly known as Cable & Wireless)" },
	{ 0x338, 0x050,		"Digicel" },
	{ 0x338, 0x070,		"Claro" },
	{ 0x338, 0x180,		"LIME (formerly known as Cable & Wireless)" },
	{ 0x440, -1,	"Japan" },
	{ 0x440, 0x00f,		"eMobile" },
	{ 0x440, 0x01f,		"NTT docomo" },
	{ 0x440, 0x02f,		"NTT docomo" },
	{ 0x440, 0x03f,		"NTT docomo" },
	{ 0x440, 0x04f,		"SoftBank" },
	{ 0x440, 0x06f,		"SoftBank" },
	{ 0x440, 0x07f,		"KDDI" },
	{ 0x440, 0x08f,		"KDDI" },
	{ 0x440, 0x09f,		"NTT docomo" },
	{ 0x440, 0x10f,		"NTT docomo" },
	{ 0x440, 0x11f,		"NTT docomo" },
	{ 0x440, 0x12f,		"NTT docomo" },
	{ 0x440, 0x13f,		"NTT docomo" },
	{ 0x440, 0x14f,		"NTT docomo" },
	{ 0x440, 0x15f,		"NTT docomo" },
	{ 0x440, 0x16f,		"NTT docomo" },
	{ 0x440, 0x17f,		"NTT docomo" },
	{ 0x440, 0x18f,		"NTT docomo" },
	{ 0x440, 0x19f,		"NTT docomo" },
	{ 0x440, 0x20f,		"SoftBank" },
	{ 0x440, 0x21f,		"NTT docomo" },
	{ 0x440, 0x22f,		"NTT docomo" },
	{ 0x440, 0x23f,		"DoCoMo" },
	{ 0x440, 0x24f,		"DoCoMo" },
	{ 0x440, 0x25f,		"DoCoMo" },
	{ 0x440, 0x26f,		"DoCoMo" },
	{ 0x440, 0x27f,		"DoCoMo" },
	{ 0x440, 0x28f,		"DoCoMo" },
	{ 0x440, 0x29f,		"DoCoMo" },
	{ 0x440, 0x30f,		"DoCoMo" },
	{ 0x440, 0x31f,		"DoCoMo" },
	{ 0x440, 0x32f,		"DoCoMo" },
	{ 0x440, 0x33f,		"DoCoMo" },
	{ 0x440, 0x34f,		"DoCoMo" },
	{ 0x440, 0x35f,		"DoCoMo" },
	{ 0x440, 0x36f,		"DoCoMo" },
	{ 0x440, 0x37f,		"DoCoMo" },
	{ 0x440, 0x38f,		"DoCoMo" },
	{ 0x440, 0x39f,		"DoCoMo" },
	{ 0x440, 0x40f,		"SoftBank" },
	{ 0x440, 0x41f,		"SoftBank" },
	{ 0x440, 0x42f,		"SoftBank" },
	{ 0x440, 0x43f,		"SoftBank" },
	{ 0x440, 0x44f,		"SoftBank" },
	{ 0x440, 0x45f,		"SoftBank" },
	{ 0x440, 0x46f,		"SoftBank" },
	{ 0x440, 0x47f,		"SoftBank" },
	{ 0x440, 0x48f,		"SoftBank" },
	{ 0x440, 0x49f,		"DoCoMo" },
	{ 0x440, 0x50f,		"KDDI" },
	{ 0x440, 0x51f,		"KDDI" },
	{ 0x440, 0x52f,		"KDDI" },
	{ 0x440, 0x53f,		"KDDI" },
	{ 0x440, 0x54f,		"KDDI" },
	{ 0x440, 0x55f,		"KDDI" },
	{ 0x440, 0x56f,		"KDDI" },
	{ 0x440, 0x58f,		"DoCoMo" },
	{ 0x440, 0x60f,		"DoCoMo" },
	{ 0x440, 0x61f,		"DoCoMo" },
	{ 0x440, 0x62f,		"DoCoMo" },
	{ 0x440, 0x63f,		"DoCoMo" },
	{ 0x440, 0x64f,		"DoCoMo" },
	{ 0x440, 0x65f,		"DoCoMo" },
	{ 0x440, 0x66f,		"DoCoMo" },
	{ 0x440, 0x67f,		"DoCoMo" },
	{ 0x440, 0x68f,		"DoCoMo" },
	{ 0x440, 0x69f,		"DoCoMo" },
	{ 0x440, 0x70f,		"au" },
	{ 0x440, 0x71f,		"KDDI" },
	{ 0x440, 0x72f,		"KDDI" },
	{ 0x440, 0x73f,		"KDDI" },
	{ 0x440, 0x74f,		"KDDI" },
	{ 0x440, 0x75f,		"KDDI" },
	{ 0x440, 0x76f,		"KDDI" },
	{ 0x440, 0x77f,		"KDDI" },
	{ 0x440, 0x78f,		"Okinawa Cellular Telephone" },
	{ 0x440, 0x79f,		"KDDI" },
	{ 0x440, 0x80f,		"TU-KA" },
	{ 0x440, 0x81f,		"TU-KA" },
	{ 0x440, 0x82f,		"TU-KA" },
	{ 0x440, 0x83f,		"TU-KA" },
	{ 0x440, 0x84f,		"TU-KA" },
	{ 0x440, 0x85f,		"TU-KA" },
	{ 0x440, 0x86f,		"TU-KA" },
	{ 0x440, 0x87f,		"DoCoMo" },
	{ 0x440, 0x88f,		"KDDI" },
	{ 0x440, 0x89f,		"KDDI" },
	{ 0x440, 0x90f,		"SoftBank" },
	{ 0x440, 0x92f,		"SoftBank" },
	{ 0x440, 0x93f,		"SoftBank" },
	{ 0x440, 0x94f,		"SoftBank" },
	{ 0x440, 0x95f,		"SoftBank" },
	{ 0x440, 0x96f,		"SoftBank" },
	{ 0x440, 0x97f,		"SoftBank" },
	{ 0x440, 0x98f,		"SoftBank" },
	{ 0x440, 0x99f,		"DoCoMo" },
	{ 0x234, -1,	"Jersey" },
	{ 0x234, 0x50f,		"JT-Wave" },
	{ 0x234, 0x55f,		"Sure Mobile" },
	{ 0x234, 0x03f,		"Airtel Vodafone" },
	{ 0x416, -1,	"Jordan" },
	{ 0x416, 0x01f,		"zain JO" },
	{ 0x416, 0x02f,		"XPress Telecom" },
	{ 0x416, 0x03f,		"Umniah" },
	{ 0x416, 0x77f,		"Orange" },
	{ 0x401, -1,	"Kazakhstan" },
	{ 0x401, 0x01f,		"Beeline" },
	{ 0x401, 0x02f,		"Kcell" },
	{ 0x401, 0x07f,		"Dalacom" },
	{ 0x401, 0x77f,		"Mobile Telecom Service" },
	{ 0x639, -1,	"Kenya" },
	{ 0x639, 0x02f,		"Safaricom" },
	{ 0x639, 0x03f,		"Zain" },
	{ 0x639, 0x07f,		"Orange Kenya" },
	{ 0x545, -1,	"Kiribati" },
	{ 0x545, 0x09f,		"Kiribati Frigate" },
	{ 0x467, -1,	"North Korea" },
	{ 0x467, 0x193,		"SUN NET" },
	{ 0x450, -1,	"South Korea" },
	{ 0x450, 0x02f,		"KT" },
	{ 0x450, 0x03f,		"Power 017" },
	{ 0x450, 0x04f,		"KT" },
	{ 0x450, 0x05f,		"SKT" },
	{ 0x450, 0x06f,		"LGT" },
	{ 0x450, 0x08f,		"KT SHOW" },
	{ 0x212, -1,	"Kosovo" },
	{ 0x212, 0x01f,		"Vala" },
	{ 0x293, 0x41f,		"iPKO" },
	{ 0x293, 0x41f,		"D3 Mobile" },
	{ 0x212, 0x01f,		"Z Mobile" },
	{ 0x419, -1,	"Kuwait" },
	{ 0x419, 0x02f,		"zain KW" },
	{ 0x419, 0x03f,		"Wataniya" },
	{ 0x419, 0x04f,		"Viva" },
	{ 0x437, -1,	"Kyrgyzstan" },
	{ 0x437, 0x01f,		"Beeline" },
	{ 0x437, 0x05f,		"MegaCom" },
	{ 0x437, 0x09f,		"O!" },
	{ 0x457, -1,	"Laos" },
	{ 0x457, 0x01f,		"LaoTel" },
	{ 0x457, 0x02f,		"ETL" },
	{ 0x457, 0x03f,		"Unitel" },
	{ 0x457, 0x08f,		"Tigo" },
	{ 0x247, -1,	"Latvia" },
	{ 0x247, 0x01f,		"LMT" },
	{ 0x247, 0x02f,		"Tele2" },
	{ 0x247, 0x03f,		"TRIATEL" },
	{ 0x247, 0x05f,		"Bite" },
	{ 0x247, 0x06f,		"Rigatta" },
	{ 0x247, 0x07f,		"MTS" },
	{ 0x247, 0x08f,		"IZZI" },
	{ 0x247, 0x09f,		"Camel Mobile" },
	{ 0x415, -1,	"Lebanon" },
	{ 0x415, 0x01f,		"Alfa" },
	{ 0x415, 0x03f,		"MTC-Touch" },
	{ 0x651, -1,	"Lesotho" },
	{ 0x651, 0x01f,		"Vodacom" },
	{ 0x651, 0x02f,		"Econet Ezin-cel" },
	{ 0x618, -1,	"Liberia" },
	{ 0x618, 0x01f,		"Lonestar Cell" },
	{ 0x618, 0x04f,		"Comium" },
	{ 0x618, 0x20f,		"LIBTELCO" },
	{ 0x606, -1,	"Libya" },
	{ 0x606, 0x00f,		"Libyana" },
	{ 0x606, 0x01f,		"Madar" },
	{ 0x295, -1,	"Liechtenstein" },
	{ 0x295, 0x01f,		"Swisscom" },
	{ 0x295, 0x02f,		"Orange" },
	{ 0x295, 0x05f,		"FL1" },
	{ 0x295, 0x77f,		"Tele 2" },
	{ 0x246, -1,	"Lithuania" },
	{ 0x246, 0x01f,		"Omnitel" },
	{ 0x246, 0x02f,		"BITE" },
	{ 0x246, 0x03f,		"Tele 2" },
	{ 0x270, -1,	"Luxembourg" },
	{ 0x270, 0x01f,		"LuxGSM" },
	{ 0x270, 0x77f,		"Tango" },
	{ 0x270, 0x99f,		"Orange" },
	{ 0x455, -1,	"Macau" },
	{ 0x455, 0x00f,		"SmarTone" },
	{ 0x455, 0x01f,		"CTM" },
	{ 0x455, 0x02f,		"China Telecom" },
	{ 0x455, 0x03f,		"3" },
	{ 0x455, 0x04f,		"CTM" },
	{ 0x455, 0x05f,		"3" },
	{ 0x294, -1,	"Republic of Macedonia" },
	{ 0x294, 0x01f,		"T-Mobile MK" },
	{ 0x294, 0x02f,		"ONE" },
	{ 0x294, 0x03f,		"Vip MK" },
	{ 0x646, -1,	"Madagascar" },
	{ 0x646, 0x01f,		"Zain" },
	{ 0x646, 0x02f,		"Orange" },
	{ 0x646, 0x03f,		"Sacel" },
	{ 0x646, 0x04f,		"Telma" },
	{ 0x650, -1,	"Malawi" },
	{ 0x650, 0x01f,		"TNM" },
	{ 0x650, 0x10f,		"Zain" },
	{ 0x502, -1,	"Malaysia" },
	{ 0x502, 0x12f,		"Maxis" },
	{ 0x502, 0x13f,		"Celcom" },
	{ 0x502, 0x16f,		"DiGi" },
	{ 0x502, 0x17f,		"Maxis" },
	{ 0x502, 0x18f,		"U Mobile" },
	{ 0x502, 0x19f,		"Celcom" },
	{ 0x472, -1,	"Maldives" },
	{ 0x472, 0x01f,		"Dhiraagu" },
	{ 0x472, 0x02f,		"Wataniya" },
	{ 0x610, -1,	"Mali" },
	{ 0x610, 0x01f,		"Malitel" },
	{ 0x610, 0x02f,		"Orange" },
	{ 0x278, -1,	"Malta" },
	{ 0x278, 0x01f,		"Vodafone" },
	{ 0x278, 0x21f,		"GO" },
	{ 0x278, 0x77f,		"Melita" },
	{ 0x000, -1,	"Marshall Islands" },
//	{ 0x000, ?,		"?" },
	{ 0x340, -1,	"Martinique" },
	{ 0x340, 0x01f,		"Orange" },
	{ 0x340, 0x02f,		"Outremer" },
	{ 0x340, 0x20f,		"Digicel" },
	{ 0x609, -1,	"Mauritania" },
	{ 0x609, 0x01f,		"Mattel" },
	{ 0x609, 0x10f,		"Mauritel" },
	{ 0x617, -1,	"Mauritius" },
	{ 0x617, 0x01f,		"Orange" },
	{ 0x617, 0x02f,		"MTML" },
	{ 0x617, 0x10f,		"Emtel" },
	{ 0x334, -1,	"Mexico" },
	{ 0x334, 0x01f,		"Nextel" },
	{ 0x334, 0x02f,		"Telcel" },
	{ 0x334, 0x03f,		"movistar" },
	{ 0x334, 0x04f,		"Iusacell / Unefon" },
	{ 0x550, -1,	"Federated States of Micronesia" },
	{ 0x550, 0x01f,		"FSM Telecom" },
	{ 0x259, -1,	"Moldova" },
	{ 0x259, 0x01f,		"Orange" },
	{ 0x259, 0x02f,		"Moldcell" },
	{ 0x259, 0x03f,		"IDC" },
	{ 0x259, 0x03f,		"Unit?" },
	{ 0x259, 0x04f,		"Eventis" },
	{ 0x259, 0x05f,		"Unit?" },
	{ 0x212, -1,	"Monaco" },
	{ 0x212, 0x01f,		"Office des Telephones" },
	{ 0x428, -1,	"Mongolia" },
	{ 0x428, 0x99f,		"MobiCom" },
	{ 0x428, 0x88f,		"Unitel" },
	{ 0x428, 0x91f,		"Skytel" },
	{ 0x428, 0x98f,		"G.Mobile" },
	{ 0x297, -1,	"Montenegro" },
	{ 0x297, 0x01f,		"Telenor" },
	{ 0x297, 0x02f,		"T-Mobile" },
	{ 0x297, 0x03f,		"m:tel CG" },
	{ 0x604, -1,	"Morocco" },
	{ 0x604, 0x00f,		"Moditel" },
	{ 0x604, 0x01f,		"IAM" },
	{ 0x604, 0x02f,		"INWI" },
	{ 0x605, 0x03f,		"yassine" },
	{ 0x643, -1,	"Mozambique" },
	{ 0x643, 0x01f,		"mCel" },
	{ 0x643, 0x04f,		"Vodacom" },
	{ 0x414, -1,	"Myanmar" },
	{ 0x414, 0x01f,		"MPT" },
	{ 0x649, -1,	"Namibia" },
	{ 0x649, 0x01f,		"MTC" },
	{ 0x649, 0x02f,		"switch" },
	{ 0x649, 0x03f,		"Leo" },
	{ 0x536, -1,	"Nauru" },
	{ 0x429, -1,	"Nepal" },
	{ 0x429, 0x01f,		"Namaste / NT Mobile" },
	{ 0x429, 0x02f,		"Ncell" },
	{ 0x429, 0x03f,		"Sky/C-Phone" },
	{ 0x204, -1,	"Netherlands" },
	{ 0x204, 0x01f,		"OneFoon" },
	{ 0x204, 0x02f,		"Tele2" },
	{ 0x204, 0x03f,		"Blyk" },
	{ 0x204, 0x04f,		"Vodafone" },
	{ 0x204, 0x05f,		"Elephant Talk" },
	{ 0x204, 0x06f,		"Barablu Mobile" },
	{ 0x204, 0x07f,		"Teleena" },
	{ 0x204, 0x08f,		"KPN" },
	{ 0x204, 0x09f,		"Lycamobile" },
	{ 0x204, 0x10f,		"KPN" },
	{ 0x204, 0x12f,		"Telfort" },
	{ 0x204, 0x14f,		"6Gmobile" },
	{ 0x204, 0x16f,		"T-Mobile" },
	{ 0x204, 0x18f,		"Telfort" },
	{ 0x204, 0x20f,		"Orange Nederland" },
	{ 0x204, 0x21f,		"NS Railinfrabeheer B.V." },
	{ 0x204, 0x67f,		"RadioAccess" },
	{ 0x204, 0x69f,		"KPN Mobile" },
	{ 0x362, -1,	"Netherlands Antilles" },
	{ 0x362, 0x51f,		"Telcell" },
	{ 0x362, 0x69f,		"Digicel" },
	{ 0x362, 0x91f,		"UTS" },
	{ 0x362, 0x00f,		"East Caribbean Cellular" },
	{ 0x362, 0x00f,		"Antiliano Por N.V." },
	{ 0x362, 0x95f,		"MIO" },
	{ 0x362, 0x94f,		"Bay?s" },
	{ 0x546, -1,	"New Caledonia" },
	{ 0x546, 0x01f,		"Mobilis" },
	{ 0x530, -1,	"New Zealand" },
	{ 0x530, 0x00f,		"Telecom" },
	{ 0x530, 0x01f,		"Vodafone" },
	{ 0x530, 0x02f,		"Telecom" },
	{ 0x530, 0x03f,		"Woosh" },
	{ 0x530, 0x04f,		"TelstraClear" },
	{ 0x530, 0x05f,		"XT Mobile Network" },
	{ 0x530, 0x12f,		"360" },
	{ 0x530, 0x24f,		"2degrees" },
	{ 0x710, -1,	"Nicaragua" },
	{ 0x710, 0x21f,		"Claro" },
	{ 0x710, 0x30f,		"movistar" },
	{ 0x710, 0x73f,		"SERCOM" },
	{ 0x614, -1,	"Niger" },
	{ 0x614, 0x01f,		"SahelCom" },
	{ 0x614, 0x02f,		"Zain" },
	{ 0x614, 0x03f,		"Telecel" },
	{ 0x614, 0x04f,		"Orange" },
	{ 0x621, -1,	"Nigeria" },
	{ 0x621, 0x20f,		"Zain" },
	{ 0x621, 0x30f,		"MTN" },
	{ 0x621, 0x40f,		"M-Tel" },
	{ 0x621, 0x50f,		"Glo" },
	{ 0x621, 0x60f,		"Etisalat" },
	{ 0x242, -1,	"Norway" },
	{ 0x242, 0x01f,		"Telenor" },
	{ 0x242, 0x02f,		"NetCom" },
	{ 0x242, 0x03f,		"Teletopia" },
	{ 0x242, 0x04f,		"Tele2" },
	{ 0x242, 0x05f,		"Network Norway" },
	{ 0x242, 0x06f,		"Ice" },
	{ 0x242, 0x07f,		"Ventelo" },
	{ 0x242, 0x08f,		"TDC Mobil AS" },
	{ 0x242, 0x09f,		"Barablu Mobile Norway Ltd" },
	{ 0x242, 0x20f,		"Jernbaneverket AS" },
	{ 0x422, -1,	"Oman" },
	{ 0x422, 0x02f,		"Oman Mobile" },
	{ 0x422, 0x03f,		"Nawras" },
	{ 0x410, -1,	"Pakistan" },
	{ 0x410, 0x01f,		"Mobilink" },
	{ 0x410, 0x03f,		"Ufone" },
	{ 0x410, 0x04f,		"Zong" },
	{ 0x410, 0x06f,		"Telenor" },
	{ 0x410, 0x07f,		"Warid" },
	{ 0x552, -1,	"Palau" },
	{ 0x552, 0x01f,		"PNCC" },
	{ 0x552, 0x80f,		"Palau Mobile" },
	{ 0x423, -1,	"Palestinian Authority" },
	{ 0x423, 0x05f,		"Jawwal" },
	{ 0x423, 0x06f,		"Wataniya" },
	{ 0x714, -1,	"Panama" },
	{ 0x714, 0x01f,		"Cable & Wireless" },
	{ 0x714, 0x02f,		"movistar" },
	{ 0x714, 0x04f,		"Digicel" },
	{ 0x714, 0x03f,		"Claro" },
	{ 0x537, -1,	"Papua New Guinea" },
	{ 0x537, 0x01f,		"B-Mobile" },
	{ 0x537, 0x03f,		"Digicel" },
	{ 0x744, -1,	"Paraguay" },
	{ 0x744, 0x01f,		"VOX" },
	{ 0x744, 0x02f,		"Claro" },
	{ 0x744, 0x04f,		"Tigo" },
	{ 0x744, 0x05f,		"Personal" },
	{ 0x716, -1,	"Peru" },
	{ 0x716, 0x06f,		"movistar" },
	{ 0x716, 0x10f,		"Claro" },
	{ 0x716, 0x17f,		"NEXTEL" },
	{ 0x515, -1,	"Philippines" },
	{ 0x515, 0x01f,		"Islacom" },
	{ 0x515, 0x02f,		"Globe" },
	{ 0x515, 0x03f,		"Smart" },
	{ 0x515, 0x05f,		"Sun" },
	{ 0x515, 0x11f,		"PLDT via ACeS Philippines" },
	{ 0x515, 0x18f,		"Cure" },
	{ 0x515, 0x88f,		"Nextel" },
	{ 0x260, -1,	"Poland" },
	{ 0x260, 0x01f,		"Plus" },
	{ 0x260, 0x02f,		"Era" },
	{ 0x260, 0x03f,		"Orange" },
	{ 0x260, 0x04f,		"Netia S.A." },
	{ 0x260, 0x05f,		"Polska Telefonia Kom?rkowa Centertel Sp. z o.o." },
	{ 0x260, 0x06f,		"Play" },
	{ 0x260, 0x07f,		"Netia" },
	{ 0x260, 0x08f,		"E-Telko Sp. z o.o." },
	{ 0x260, 0x09f,		"Telekomunikacja Kolejowa Sp. z o.o." },
	{ 0x260, 0x10f,		"Sferia" },
	{ 0x260, 0x11f,		"Nordisk Polska" },
	{ 0x260, 0x12f,		"Cyfrowy Polsat" },
	{ 0x260, 0x13f,		"Sferia" },
	{ 0x260, 0x14f,		"Sferia" },
	{ 0x260, 0x15f,		"CenterNet" },
	{ 0x260, 0x16f,		"Mobyland" },
	{ 0x260, 0x17f,		"Aero2" },
	{ 0x268, -1,	"Portugal" },
	{ 0x268, 0x01f,		"Vodafone" },
	{ 0x268, 0x03f,		"Optimus" },
	{ 0x268, 0x06f,		"TMN" },
	{ 0x268, 0x21f,		"Zapp" },
	{ 0x330, -1,	"Puerto Rico" },
	{ 0x330, 0x11f,		"Claro" },
	{ 0x427, -1,	"Qatar" },
	{ 0x427, 0x01f,		"Qatarnet" },
	{ 0x427, 0x02f,		"Vodafone Qatar" },
	{ 0x647, -1,	"R&?union" },
	{ 0x647, 0x00f,		"Orange" },
	{ 0x647, 0x02f,		"Outremer" },
	{ 0x647, 0x10f,		"SFR Reunion" },
	{ 0x226, -1,	"Romania" },
	{ 0x226, 0x01f,		"Vodafone" },
	{ 0x226, 0x02f,		"Romtelecom" },
	{ 0x226, 0x03f,		"Cosmote" },
	{ 0x226, 0x04f,		"Cosmote" },
	{ 0x226, 0x05f,		"Digi.Mobil" },
	{ 0x226, 0x06f,		"Cosmote" },
	{ 0x226, 0x10f,		"Orange" },
	{ 0x250, -1,	"Russian Federation" },
	{ 0x250, 0x01f,		"MTS" },
	{ 0x250, 0x02f,		"MegaFon" },
	{ 0x250, 0x03f,		"NCC" },
	{ 0x250, 0x04f,		"Sibchallenge" },
	{ 0x250, 0x05f,		"ETK" },
	{ 0x250, 0x06f,		"Skylink" },
	{ 0x250, 0x07f,		"SMARTS" },
	{ 0x250, 0x09f,		"Skylink" },
	{ 0x250, 0x10f,		"DTC" },
	{ 0x250, 0x11f,		"Orensot" },
	{ 0x250, 0x12f,		"Baykalwestcom" },
	{ 0x250, 0x12f,		"Akos" },
	{ 0x250, 0x13f,		"KUGSM" },
	{ 0x250, 0x15f,		"SMARTS" },
	{ 0x250, 0x16f,		"NTC" },
	{ 0x250, 0x17f,		"Utel" },
	{ 0x250, 0x19f,		"INDIGO" },
	{ 0x250, 0x20f,		"Tele2" },
	{ 0x250, 0x23f,		"Mobicom - Novosibirsk" },
	{ 0x250, 0x28f,		"Beeline" },
	{ 0x250, 0x35f,		"MOTIV" },
	{ 0x250, 0x38f,		"Tambov GSM" },
	{ 0x250, 0x39f,		"Utel" },
	{ 0x250, 0x44f,		"Stavtelesot / North Caucasian GSM" },
	{ 0x250, 0x92f,		"Primtelefon" },
	{ 0x250, 0x93f,		"Telecom XXI" },
	{ 0x250, 0x99f,		"Beeline" },
//	{ 0x250, ?,		"SkyLink/MTS/the Moscow Cellular communication" },
	{ 0x635, -1,	"Rwanda" },
	{ 0x635, 0x10f,		"MTN" },
	{ 0x635, 0x13f,		"Tigo" },
	{ 0x356, -1,	"Saint Kitts and Nevis" },
	{ 0x356, 0x050,		"Digicel" },
	{ 0x356, 0x110,		"Cable &  Wireless" },
	{ 0x358, -1,	"Saint Lucia" },
	{ 0x358, 0x050,		"Digicel" },
	{ 0x358, 0x110,		"Cable &  Wireless" },
	{ 0x308, -1,	"Saint Pierre and Miquelon" },
	{ 0x308, 0x01f,		"Ameris" },
	{ 0x360, -1,	"Saint Vincent and the Grenadines" },
	{ 0x360, 0x070,		"Digicel" },
	{ 0x360, 0x100,		"Cingular Wireless" },
	{ 0x360, 0x110,		"Cable & Wireless" },
	{ 0x549, -1,	"Samoa" },
	{ 0x549, 0x01f,		"Digicel" },
	{ 0x549, 0x27f,		"SamoaTel" },
	{ 0x292, -1,	"San Marino" },
	{ 0x292, 0x01f,		"PRIMA" },
	{ 0x626, -1,	"Sao Tome and Principe" },
	{ 0x626, 0x01f,		"CSTmovel" },
	{ 0x420, -1,	"Saudi Arabia" },
	{ 0x420, 0x01f,		"Al Jawal" },
	{ 0x420, 0x03f,		"Mobily" },
	{ 0x420, 0x07f,		"EAE" },
	{ 0x420, 0x04f,		"Zain SA" },
	{ 0x608, -1,	"Senegal" },
	{ 0x608, 0x01f,		"Orange (telecommunications)" },
	{ 0x608, 0x02f,		"Tigo" },
	{ 0x608, 0x03f,		"Expresso" },
	{ 0x220, -1,	"Serbia" },
	{ 0x220, 0x01f,		"Telenor" },
	{ 0x220, 0x03f,		"mt:s" },
	{ 0x220, 0x05f,		"VIP" },
	{ 0x633, -1,	"Seychelles" },
	{ 0x633, 0x01f,		"Cable & Wireless" },
	{ 0x633, 0x02f,		"Mediatech International" },
	{ 0x633, 0x10f,		"Airtel" },
	{ 0x619, -1,	"Sierra Leone" },
	{ 0x619, 0x01f,		"Zain" },
	{ 0x619, 0x02f,		"Millicom" },
	{ 0x619, 0x03f,		"Datatel" },
	{ 0x619, 0x04f,		"Comium" },
	{ 0x619, 0x05f,		"Africell" },
	{ 0x619, 0x25f,		"Mobitel" },
//	{ 0x619, ?,		"LeoneCel" },
	{ 0x525, -1,	"Singapore" },
	{ 0x525, 0x01f,		"SingTel" },
	{ 0x525, 0x02f,		"SingTel-G18" },
	{ 0x525, 0x03f,		"M1" },
	{ 0x525, 0x05f,		"StarHub" },
	{ 0x525, 0x12f,		"Digital Trunked Radio Network" },
	{ 0x231, -1,	"Slovakia" },
	{ 0x231, 0x01f,		"Orange" },
	{ 0x231, 0x02f,		"T-Mobile" },
	{ 0x231, 0x03f,		"Unient Communications" },
	{ 0x231, 0x04f,		"T-Mobile" },
	{ 0x231, 0x05f,		"Mobile Entertainment Company" },
	{ 0x231, 0x06f,		"O2" },
	{ 0x231, 0x99f,		"?SR" },
	{ 0x293, -1,	"Slovenia" },
	{ 0x293, 0x40f,		"Si.mobil" },
	{ 0x293, 0x41f,		"Mobitel" },
	{ 0x293, 0x64f,		"T-2" },
	{ 0x293, 0x70f,		"Tu?mobil" },
	{ 0x540, -1,	"Solomon Islands" },
	{ 0x637, -1,	"Somalia" },
	{ 0x637, 0x01f,		"Telesom" },
	{ 0x637, 0x04f,		"Somafone" },
	{ 0x637, 0x10f,		"Nationlink" },
	{ 0x637, 0x25f,		"Hormuud" },
	{ 0x637, 0x30f,		"Golis" },
	{ 0x637, 0x82f,		"Telcom" },
	{ 0x655, -1,	"South Africa" },
	{ 0x655, 0x01f,		"Vodacom" },
	{ 0x655, 0x06f,		"Sentech" },
	{ 0x655, 0x07f,		"Cell C" },
	{ 0x655, 0x10f,		"MTN" },
	{ 0x655, 0x11f,		"SAPS Gauteng" },
	{ 0x655, 0x13f,		"Neotel" },
	{ 0x655, 0x21f,		"Cape Town Metropolitan Council" },
	{ 0x655, 0x30f,		"Bokamoso Consortium" },
	{ 0x655, 0x31f,		"Karabo Telecoms (Pty) Ltd." },
	{ 0x655, 0x32f,		"Ilizwi Telecommunications" },
	{ 0x655, 0x33f,		"Thinta Thinta Telecommunications" },
	{ 0x655, 0x02f,		"Telkom" },
	{ 0x214, -1,	"Spain" },
	{ 0x214, 0x01f,		"Vodafone" },
	{ 0x214, 0x03f,		"Orange" },
	{ 0x214, 0x04f,		"Yoigo" },
	{ 0x214, 0x05f,		"TME" },
	{ 0x214, 0x06f,		"Vodafone" },
	{ 0x214, 0x07f,		"movistar" },
	{ 0x214, 0x08f,		"Euskaltel" },
	{ 0x214, 0x09f,		"Orange" },
	{ 0x214, 0x15f,		"BT" },
	{ 0x214, 0x16f,		"TeleCable" },
	{ 0x214, 0x17f,		"M?bil R" },
	{ 0x214, 0x18f,		"ONO" },
	{ 0x214, 0x19f,		"Simyo" },
	{ 0x214, 0x21f,		"Jazztel" },
	{ 0x214, 0x22f,		"DigiMobil" },
	{ 0x214, 0x23f,		"Barablu" },
	{ 0x413, -1,	"Sri Lanka" },
	{ 0x413, 0x01f,		"Mobitel" },
	{ 0x413, 0x02f,		"Dialog" },
	{ 0x413, 0x03f,		"Etisalat" },
	{ 0x413, 0x05f,		"Airtel" },
	{ 0x413, 0x08f,		"Hutch" },
	{ 0x413, 0x00f,		"RTEC Mobile" },
	{ 0x634, -1,	"Sudan" },
	{ 0x634, 0x01f,		"Zain SD" },
	{ 0x634, 0x02f,		"MTN" },
	{ 0x634, 0x05f,		"Vivacell" },
	{ 0x746, -1,	"Suriname" },
	{ 0x746, 0x05f,		"Telesur" },
	{ 0x653, -1,	"Swaziland" },
	{ 0x653, 0x10f,		"Swazi MTN" },
	{ 0x240, -1,	"Sweden" },
	{ 0x240, 0x01f,		"Telia" },
	{ 0x240, 0x02f,		"3" },
	{ 0x240, 0x03f,		"Ice.net" },
	{ 0x240, 0x04f,		"3G Infrastructure Services" },
	{ 0x240, 0x05f,		"Sweden 3G" },
	{ 0x240, 0x06f,		"Telenor" },
	{ 0x240, 0x07f,		"Tele2" },
	{ 0x240, 0x08f,		"Telenor" },
	{ 0x240, 0x09f,		"djuice" },
	{ 0x240, 0x10f,		"Spring Mobil" },
	{ 0x240, 0x11f,		"Lindholmen Science Park" },
	{ 0x240, 0x12f,		"Barablu Mobile Scandinavia" },
	{ 0x240, 0x13f,		"Ventelo Sverige" },
	{ 0x240, 0x14f,		"TDC Mobil" },
	{ 0x240, 0x15f,		"Wireless Maingate Nordic" },
	{ 0x240, 0x16f,		"42IT" },
	{ 0x240, 0x17f,		"G?talandsn?tet" },
	{ 0x240, 0x20f,		"Wireless Maingate Message Services" },
	{ 0x240, 0x21f,		"MobiSir" },
	{ 0x240, 0x25f,		"DigiTelMobile" },
	{ 0x228, -1,	"Switzerland" },
	{ 0x228, 0x01f,		"Swisscom" },
	{ 0x228, 0x02f,		"Sunrise" },
	{ 0x228, 0x03f,		"Orange" },
	{ 0x228, 0x05f,		"Togewanet AG (Comfone)" },
	{ 0x228, 0x06f,		"SBB AG" },
	{ 0x228, 0x07f,		"IN&Phone" },
	{ 0x228, 0x08f,		"Tele2" },
	{ 0x228, 0x50f,		"3G Mobile AG" },
	{ 0x228, 0x51f,		"BebbiCell AG" },
	{ 0x417, -1,	"Syria" },
	{ 0x417, 0x01f,		"Syriatel" },
	{ 0x417, 0x02f,		"MTN" },
	{ 0x466, -1,	"Taiwan" },
	{ 0x466, 0x01f,		"FarEasTone" },
	{ 0x466, 0x02f,		"APTG" },
	{ 0x466, 0x06f,		"Tuntex" },
	{ 0x466, 0x11f,		"Chunghwa LDM" },
	{ 0x466, 0x88f,		"KG Telecom" },
	{ 0x466, 0x89f,		"VIBO" },
	{ 0x466, 0x92f,		"Chungwa" },
	{ 0x466, 0x93f,		"MobiTai" },
	{ 0x466, 0x97f,		"Taiwan Mobile" },
	{ 0x466, 0x99f,		"TransAsia" },
	{ 0x436, -1,	"Tajikistan" },
	{ 0x436, 0x01f,		"Tcell" },
	{ 0x436, 0x02f,		"Indigo" },
	{ 0x436, 0x03f,		"MLT" },
	{ 0x436, 0x04f,		"Babilon-M" },
	{ 0x436, 0x05f,		"Beeline" },
	{ 0x640, -1,	"Tanzania" },
	{ 0x640, 0x06f,		"SasaTel" },
	{ 0x640, 0x02f,		"tiGO" },
	{ 0x640, 0x03f,		"Zantel" },
	{ 0x640, 0x04f,		"Vodacom" },
	{ 0x640, 0x05f,		"Zain" },
	{ 0x520, -1,	"Thailand" },
	{ 0x520, 0x00f,		"Hutch" },
	{ 0x520, 0x01f,		"AIS" },
	{ 0x520, 0x02f,		"CAT CDMA" },
	{ 0x520, 0x10f,		"?" },
	{ 0x520, 0x15f,		"Thai Mobile" },
	{ 0x520, 0x15f,		"TOT 3G" },
	{ 0x520, 0x18f,		"dtac" },
	{ 0x520, 0x23f,		"AIS GSM 1800" },
	{ 0x520, 0x99f,		"True Move" },
	{ 0x520, 0x00f,		"WE PCT" },
	{ 0x615, -1,	"Togo" },
	{ 0x615, 0x01f,		"Togo Cell" },
	{ 0x615, 0x03f,		"Moov" },
	{ 0x539, -1,	"Tonga" },
	{ 0x539, 0x01f,		"Tonga Communications Corporation" },
	{ 0x539, 0x43f,		"Shoreline Communication" },
	{ 0x539, 0x88f,		"Digicel" },
	{ 0x374, -1,	"Trinidad and Tobago" },
	{ 0x374, 0x12f,		"bmobile" },
	{ 0x374, 0x13f,		"Digicel" },
	{ 0x605, -1,	"Tunisia" },
	{ 0x605, 0x01f,		"Orange" },
	{ 0x605, 0x02f,		"Tunicell" },
	{ 0x605, 0x03f,		"Tunisiana" },
	{ 0x286, -1,	"Turkey" },
	{ 0x286, 0x01f,		"Turkcell" },
	{ 0x286, 0x02f,		"Vodafone" },
	{ 0x286, 0x03f,		"Avea" },
	{ 0x286, 0x04f,		"Aycell" },
	{ 0x438, -1,	"Turkmenistan" },
	{ 0x438, 0x01f,		"MTS" },
	{ 0x438, 0x02f,		"TM-Cell" },
	{ 0x376, -1,	"Turks and Caicos Islands" },
	{ 0x376, 0x350,		"C&W" },
	{ 0x376, 0x352,		"Islandcom" },
	{ 0x338, 0x05f,		"Digicel" },
	{ 0x553, -1,	"Tuvalu" },
	{ 0x553, 0x01f,		"TTC" },
	{ 0x641, -1,	"Uganda" },
	{ 0x641, 0x01f,		"Zain" },
	{ 0x641, 0x10f,		"MTN" },
	{ 0x641, 0x11f,		"Uganda Telecom Ltd." },
	{ 0x641, 0x22f,		"Warid Telecom" },
	{ 0x641, 0x14f,		"Orange" },
	{ 0x255, -1,	"Ukraine" },
	{ 0x255, 0x01f,		"MTS" },
	{ 0x255, 0x02f,		"Beeline" },
	{ 0x255, 0x03f,		"Kyivstar" },
	{ 0x255, 0x04f,		"IT" },
	{ 0x255, 0x05f,		"Golden Telecom" },
	{ 0x255, 0x06f,		"life:)" },
	{ 0x255, 0x07f,		"Ukrtelecom" },
	{ 0x255, 0x21f,		"PEOPLEnet" },
	{ 0x255, 0x23f,		"CDMA Ukraine" },
	{ 0x424, -1,	"United Arab Emirates" },
	{ 0x424, 0x02f,		"Etisalat" },
	{ 0x424, 0x03f,		"du" },
	{ 0x234, -1,	"United Kingdom" },
	{ 0x234, 0x00f,		"BT" },
	{ 0x234, 0x01f,		"UK01" },
	{ 0x234, 0x02f,		"O2" },
	{ 0x234, 0x03f,		"Airtel-Vodafone" },
	{ 0x234, 0x04f,		"FMS Solutions Ltd" },
	{ 0x234, 0x07f,		"Cable and Wireless UK" },
	{ 0x234, 0x08f,		"OnePhone Ltd" },
	{ 0x234, 0x10f,		"O2" },
	{ 0x234, 0x11f,		"O2" },
	{ 0x234, 0x12f,		"Railtrack" },
	{ 0x234, 0x14f,		"Hay Systems Ltd" },
	{ 0x234, 0x15f,		"Vodafone" },
	{ 0x234, 0x16f,		"Opal Telecom Ltd" },
	{ 0x234, 0x18f,		"Cloud9" },
	{ 0x234, 0x19f,		"Teleware" },
	{ 0x234, 0x20f,		"3" },
	{ 0x234, 0x22f,		"RoutoMessaging" },
	{ 0x234, 0x25f,		"Truphone" },
	{ 0x234, 0x30f,		"T-Mobile" },
	{ 0x234, 0x31f,		"Virgin" },
	{ 0x234, 0x32f,		"Virgin" },
	{ 0x234, 0x33f,		"Orange" },
	{ 0x234, 0x34f,		"Orange" },
	{ 0x234, 0x50f,		"JT-Wave" },
	{ 0x234, 0x55f,		"Cable & Wireless Guernsey / Sure Mobile (Jersey)" },
	{ 0x234, 0x58f,		"Manx Telecom" },
	{ 0x234, 0x75f,		"Inquam" },
	{ 0x234, 0x77f,		"BT" },
	{ 0x200, -1,	"United States of America" },
	{ 0x200, 0x053,		"Virgin Mobile US" },
	{ 0x200, 0x054,		"Alltel US" },
	{ 0x200, 0x066,		"U.S. Cellular" },
	/* 0x310 taken from Annex to ITU Operational Bulletin No. 958 – 15.VI.2010 */
	{ 0x310, 0x00f,		"nTelos" },
	{ 0x310, 0x000,		"Mid-Tex Cellular" },
	{ 0x310, 0x004,		"Verizon" },
	{ 0x310, 0x010,		"MCI" },
	{ 0x310, 0x012,		"Verizon" },
	{ 0x310, 0x013,		"MobileTel" },
	{ 0x310, 0x014,		"Testing" },
	{ 0x310, 0x016,		"Cricket Communications" },
	{ 0x310, 0x017,		"North Sight Communications Inc." },
	{ 0x310, 0x020,		"Union Telephone Company" },
	{ 0x310, 0x026,		"T-Mobile" },
	{ 0x310, 0x030,		"Centennial" },
	{ 0x310, 0x034,		"Airpeak" },
	{ 0x310, 0x038,		"AT&T" },
	{ 0x310, 0x040,		"Concho" },
	{ 0x310, 0x046,		"SIMMETRY" },
	{ 0x310, 0x060,		"Consolidated Telcom" },
	{ 0x310, 0x070,		"Highland Cellular" },
	{ 0x310, 0x080,		"Corr" },
	{ 0x310, 0x090,		"AT&T" },
	{ 0x310, 0x100,		"Plateau Wireless" },
	{ 0x310, 0x110,		"PTI Pacifica" },
	{ 0x310, 0x120,		"Sprint" },
	{ 0x310, 0x150,		"AT&T" },
	{ 0x310, 0x160,		"T-Mobile" },
	{ 0x310, 0x170,		"T-Mobile" },
	{ 0x310, 0x180,		"West Central" },
	{ 0x310, 0x190,		"Dutch Harbor" },
	{ 0x310, 0x200,		"T-Mobile" },
	{ 0x310, 0x210,		"T-Mobile" },
	{ 0x310, 0x220,		"T-Mobile" },
	{ 0x310, 0x230,		"T-Mobile" },
	{ 0x310, 0x240,		"T-Mobile" },
	{ 0x310, 0x250,		"T-Mobile" },
	{ 0x310, 0x260,		"T-Mobile" },
	{ 0x310, 0x270,		"T-Mobile" },
	{ 0x310, 0x280,		"T-Mobile" },
	{ 0x310, 0x290,		"T-Mobile" },
	{ 0x310, 0x300,		"iSmart Mobile" },
	{ 0x310, 0x310,		"T-Mobile" },
	{ 0x310, 0x311,		"Farmers Wireless" },
	{ 0x310, 0x320,		"Cellular One" },
	{ 0x310, 0x330,		"T-Mobile" },
	{ 0x310, 0x340,		"Westlink" },
	{ 0x310, 0x350,		"Carolina Phone" },
	{ 0x310, 0x380,		"AT&T Mobility" },
	{ 0x310, 0x390,		"Cellular One of East Texas" },
	{ 0x310, 0x400,		"i CAN_GSM" },
	{ 0x310, 0x410,		"AT&T" },
	{ 0x310, 0x420,		"Cincinnati Bell" },
	{ 0x310, 0x430,		"Alaska Digitel" },
	{ 0x310, 0x440,		"Cellular One" },
	{ 0x310, 0x450,		"Viaero" },
	{ 0x310, 0x460,		"Simmetry" },
	{ 0x310, 0x480,		"Choice Phone" },
	{ 0x310, 0x490,		"T-Mobile" },
	{ 0x310, 0x500,		"Alltel" },
	{ 0x310, 0x510,		"Airtel" },
	{ 0x310, 0x520,		"VeriSign" },
	{ 0x310, 0x530,		"West Virginia Wireless" },
	{ 0x310, 0x540,		"Oklahoma Western" },
	{ 0x310, 0x560,		"AT&T" },
	{ 0x310, 0x570,		"Cellular One" },
	{ 0x310, 0x580,		"T-Mobile" },
	{ 0x310, 0x590,		"Alltel" },
	{ 0x310, 0x610,		"Epic Touch" },
	{ 0x310, 0x620,		"Coleman County Telecom" },
	{ 0x310, 0x630,		"AmeriLink PCS" },
	{ 0x310, 0x640,		"Airadigm" },
	{ 0x310, 0x650,		"Jasper" },
	{ 0x310, 0x660,		"T-Mobile" },
	{ 0x310, 0x670,		"Northstar" },
	{ 0x310, 0x680,		"AT&T" },
	{ 0x310, 0x690,		"Conestoga" },
	{ 0x310, 0x730,		"SeaMobile" },
	{ 0x310, 0x740,		"Convey" },
	{ 0x310, 0x760,		"Panhandle" },
	{ 0x310, 0x770,		"i wireless" },
	{ 0x310, 0x780,		"Airlink PCS" },
	{ 0x310, 0x790,		"PinPoint" },
	{ 0x310, 0x800,		"T-Mobile" },
	{ 0x310, 0x830,		"Caprock" },
	{ 0x310, 0x850,		"Aeris" },
	{ 0x310, 0x870,		"PACE" },
	{ 0x310, 0x880,		"Advantage" },
	{ 0x310, 0x890,		"Unicel" },
	{ 0x310, 0x900,		"Mid-Rivers Wireless" },
	{ 0x310, 0x910,		"First Cellular" },
	{ 0x310, 0x940,		"Iris Wireless LLC" },
	{ 0x310, 0x950,		"XIT Wireless" },
	{ 0x310, 0x960,		"Plateau Wireless" },
	{ 0x310, 0x970,		"Globalstar" },
	{ 0x310, 0x980,		"AT&T Mobility" },
	{ 0x310, 0x990,		"AT&T Mobility" },
	{ 0x311, 0x000,		"Mid-Tex Cellular" },
	{ 0x311, 0x010,		"Chariton Valley" },
	{ 0x311, 0x020,		"Missouri RSA 5 Partnership" },
	{ 0x311, 0x030,		"Indigo Wireless" },
	{ 0x311, 0x040,		"Commnet Wireless" },
	{ 0x311, 0x050,		"Wikes Cellular" },
	{ 0x311, 0x060,		"Farmers Cellular" },
	{ 0x311, 0x070,		"Easterbrooke" },
	{ 0x311, 0x080,		"Pine Cellular" },
	{ 0x311, 0x090,		"Long Lines Wireless" },
	{ 0x311, 0x100,		"High Plains Wireless" },
	{ 0x311, 0x110,		"High Plains Wireless" },
	{ 0x311, 0x120,		"Choice Phone" },
	{ 0x311, 0x130,		"Cell One Amarillo" },
	{ 0x311, 0x140,		"Sprocket" },
	{ 0x311, 0x150,		"Wilkes Cellular" },
	{ 0x311, 0x160,		"Endless Mountains Wireless" },
	{ 0x311, 0x170,		"PetroCom" },
	{ 0x311, 0x180,		"Cingular Wireless" },
	{ 0x311, 0x190,		"Cellular Properties" },
	{ 0x311, 0x210,		"Farmers Cellular" },
	{ 0x316, 0x010,		"Nextel" },
	{ 0x316, 0x011,		"Southern Communications Services" },
	{ 0x748, -1,	"Uruguay" },
	{ 0x748, 0x00f,		"Ancel" },
	{ 0x748, 0x01f,		"Ancel" },
	{ 0x748, 0x07f,		"Movistar" },
	{ 0x748, 0x10f,		"Claro" },
	{ 0x434, -1,	"Uzbekistan" },
	{ 0x434, 0x01f,		"Buztel" },
	{ 0x434, 0x02f,		"Uzmacom" },
	{ 0x434, 0x04f,		"Beeline" },
	{ 0x434, 0x05f,		"Ucell" },
	{ 0x434, 0x06f,		"Perfectum Mobile" },
	{ 0x434, 0x07f,		"MTS" },
	{ 0x541, -1,	"Vanuatu" },
	{ 0x541, 0x01f,		"SMILE" },
	{ 0x225, -1,	"Vatican" },
	{ 0x734, -1,	"Venezuela" },
	{ 0x734, 0x01f,		"Digitel" },
	{ 0x734, 0x02f,		"Digitel" },
	{ 0x734, 0x03f,		"Digitel" },
	{ 0x734, 0x04f,		"movistar" },
	{ 0x734, 0x06f,		"Movilnet" },
	{ 0x452, -1,	"Vietnam" },
	{ 0x452, 0x01f,		"MobiFone" },
	{ 0x452, 0x02f,		"Vinaphone" },
	{ 0x452, 0x03f,		"S-Fone" },
	{ 0x452, 0x04f,		"Viettel Mobile" },
	{ 0x452, 0x05f,		"Vietnamobile" },
	{ 0x452, 0x06f,		"E-Mobile" },
	{ 0x452, 0x07f,		"Beeline VN" },
	{ 0x421, -1,	"Yemen" },
	{ 0x421, 0x01f,		"SabaFon" },
	{ 0x421, 0x02f,		"MTN" },
	{ 0x421, 0x03f,		"Yemen Mobile" },
	{ 0x421, 0x04f,		"HiTS-UNITEL" },
	{ 0x645, -1,	"Zambia" },
	{ 0x645, 0x01f,		"Zain" },
	{ 0x645, 0x02f,		"MTN" },
	{ 0x645, 0x03f,		"ZAMTEL" },
	{ 0x648, -1,	"Zimbabwe" },
	{ 0x648, 0x01f,		"Net*One" },
	{ 0x648, 0x03f,		"Telecel" },
	{ 0x648, 0x04f,		"Econet" },
	{ 0x901, -1,	"International" },
	{ 0x901, 0x01f,		"ICO" },
	{ 0x901, 0x02f,		"Sense Communications International" },
	{ 0x901, 0x03f,		"Iridium" },
	{ 0x901, 0x04f,		"Globalstar" },
	{ 0x901, 0x05f,		"Thuraya RMSS Network" },
	{ 0x901, 0x06f,		"Thuraya Satellite Telecommunications Company" },
	{ 0x901, 0x07f,		"Ellipso" },
	{ 0x901, 0x08f,		"" },
	{ 0x901, 0x09f,		"Tele1 Europe" },
	{ 0x901, 0x10f,		"ACeS" },
	{ 0x901, 0x11f,		"Inmarsat" },
	{ 0x901, 0x12f,		"MCP" },
	{ 0x901, 0x13f,		"GSM.AQ" },
	{ 0x901, 0x14f,		"AeroMobile AS" },
	{ 0x901, 0x15f,		"OnAir Switzerland Sarl" },
	{ 0x901, 0x16f,		"Jasper Systems" },
	{ 0x901, 0x17f,		"Navitas" },
	{ 0x901, 0x18f,		"Cellular @Sea" },
	{ 0x901, 0x19f,		"Vodafone Malta Maritime" },
	{ 0x901, 0x21f,		"Seanet" },
	{ 0x901, 0x24f,		"iNum" },
	{ 0x901, 0x29f,		"Telenor" },
	{ 0, 0, NULL }
};

/* param: numerically stored mcc as per osmo_plmn_id. */
uint16_t gsm_mcc_to_hex(uint16_t mcc)
{
	uint8_t buf[3];
	uint16_t in = mcc;

	buf[2] = in % 10;
	in = in / 10;
	buf[1] = in % 10;
	in = in / 10;
	buf[0] = in % 10;

	return ((buf[0] << 8) +
		(buf[1] << 4) +
		buf[2]);
}

/* param: numerically stored mnc as per osmo_plmn_id. */
uint16_t gsm_mnc_to_hex(uint16_t mnc, bool mnc_3_digits)
{
	uint8_t buf[3];
	uint16_t in = mnc;
	if (mnc_3_digits) {
		buf[2] = in % 10;
		in = in / 10;
	} else {
		buf[2] = 0x0f;
	}
	buf[1] = in % 10;
	in = in / 10;
	buf[0] = in % 10;

	return ((buf[0] << 8) +
		(buf[1] << 4) +
		buf[2]);
}

/* GSM 03.22 Annex A */
int gsm_match_mcc(uint16_t mcc, char *imsi)
{
	uint16_t sim_mcc;

	sim_mcc = ((imsi[0] - '0') << 8)
		 + ((imsi[1] - '0') << 4)
		 + imsi[2] - '0';

	return (gsm_mcc_to_hex(mcc) == sim_mcc);
}

/* GSM 03.22 Annex A */
int gsm_match_mnc(uint16_t mcc, uint16_t mnc, bool mnc_3_digits, char *imsi)
{
	uint16_t sim_mnc;
	uint16_t mnc_hex;

	/* 1. SIM-MCC = BCCH-MCC */
	if (!gsm_match_mcc(mcc, imsi))
		return 0;

	mnc_hex = gsm_mnc_to_hex(mnc, mnc_3_digits);

	/* 2. 3rd digit of BCCH-MNC is not 0xf */
	if ((mnc_hex & 0x00f) != 0x00f) {
		/* 3. 3 digit SIM-MNC = BCCH-MNC */
		sim_mnc = ((imsi[3] - '0') << 8)
			 + ((imsi[4] - '0') << 4)
			 + imsi[5] - '0';

		return (mnc_hex == sim_mnc);
	}

	/* 4. BCCH-MCC in the range 310-316 */
	if (gsm_mcc_to_hex(mcc) >= 310 && mnc_hex <= 316) {
		/* 5. 3rd diit of SIM-MNC is 0 */
		if (imsi[5] != 0)
			return 0;
	}

	/* 6. 1st 2 digits of SIM-MNC and BCCH-MNC match */
	sim_mnc = ((imsi[3] - '0') << 8)
		 + ((imsi[4] - '0') << 4)
		 + 0x00f;

	return (mnc_hex == sim_mnc);
}

const char *gsm_get_mcc(uint16_t mcc)
{
	int i;
	uint16_t mcc_hex = gsm_mcc_to_hex(mcc);

	for (i = 0; gsm_networks[i].name; i++)
		if (gsm_networks[i].mnc_hex < 0 && gsm_networks[i].mcc_hex == mcc_hex)
			return gsm_networks[i].name;

	return osmo_mcc_name(mcc);
}

const char *gsm_get_mnc(const struct osmo_plmn_id *plmn)
{
	int i;
	uint16_t mcc_hex = gsm_mcc_to_hex(plmn->mcc);
	uint16_t mnc_hex = gsm_mnc_to_hex(plmn->mnc, plmn->mnc_3_digits);

	for (i = 0; gsm_networks[i].name; i++)
		if (gsm_networks[i].mcc_hex == mcc_hex &&
		    gsm_networks[i].mnc_hex == mnc_hex)
			return gsm_networks[i].name;

	return osmo_mnc_name(plmn->mnc, plmn->mnc_3_digits);
}

/* get MCC from IMSI */
const char *gsm_imsi_mcc(char *imsi)
{
	int i, found = 0;
	uint16_t mcc_hex;

	mcc_hex = ((imsi[0] - '0') << 8)
	    | ((imsi[1] - '0') << 4)
	    | ((imsi[2] - '0'));

	for (i = 0; gsm_networks[i].name; i++) {
		if (gsm_networks[i].mcc_hex == mcc_hex) {
			found = 1;
			break;
		}
	}
	if (found == 0)
		return "Unknown";

	return gsm_networks[i].name;
}

/* get MNC from IMSI */
const char *gsm_imsi_mnc(char *imsi)
{
	int i, found = 0, position = 0;
	uint16_t mcc, mnc2, mnc3;

	mcc = ((imsi[0] - '0') << 8)
	    | ((imsi[1] - '0') << 4)
	    | ((imsi[2] - '0'));
	mnc2 = ((imsi[3] - '0') << 8)
	     + ((imsi[4] - '0') << 4)
	     + 0x00f;
	mnc3 = ((imsi[3] - '0') << 8)
	     + ((imsi[4] - '0') << 4)
	     + imsi[5] - '0';

	for (i = 0; gsm_networks[i].name; i++) {
		if (gsm_networks[i].mcc_hex != mcc)
			continue;
		if ((gsm_networks[i].mnc_hex & 0x00f) == 0x00f) {
			if (mnc2 == gsm_networks[i].mnc_hex) {
				found++;
				position = i;
			}
		} else {
			if (mnc3 == gsm_networks[i].mnc_hex) {
				found++;
				position = i;
			}
		}
	}

	if (found == 0)
		return "Unknown";
	if (found > 1)
		return "Ambiguous";
	return gsm_networks[position].name;
}


