/*
 * This code was written by Mychaela Falconia <falcon@freecalypso.org>
 * who refuses to claim copyright on it and has released it as public domain
 * instead. NO rights reserved, all rights relinquished.
 *
 * Tweaked (coding style changes) by Vadim Yanitskiy <axilirator@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdint.h>
#include <rf/txcal.h>
#include <rf/vcxocal.h>

/*
 * Pirelli's official fw runs with the following Psi parameters, as read out
 * of a running fw via rftr 9 Test Mode command:
 *
 * Psi_sta_inv: 6974
 * Psi_st: 8
 * Psi_st_32: 492713
 * Psi_st_inv: 8717
 *
 * The following AFC slope number is the closest OsmocomBB-style afc_slope
 * integer corresponding to these Psi numbers; the true value is somewhere
 * between 225 and 226.
 */
int16_t afc_slope = 226;

/*
 * The compiled-in AFC initial DAC value below is the same as was used by
 * the old OsmocomBB code written for Mot C1xx phones, but it will normally
 * be overridden by the per-unit factory calibration value read from
 * Pirelli's factory data block.
 */
int16_t afc_initial_dac_value = -700;

/* APC offset (comes from the official firmware) for Pirelli targets */
uint8_t apc_offset = 0;

/*
 * The following Tx levels and ramps tables are the ones compiled into
 * Pirelli's firmware; these are the tables which the firmware uses in
 * the absence of per-unit calibration records in the factory data block
 * in the last 64 KiB sector of the flash.  In normal operation the
 * records read from that block fully override all of these compiled-in
 * tables, with the exception of 850 MHz bands ones - the Pirelli DP-L10
 * does not support that band, and there are no calibration records for it.
 */
struct txcal_tx_level rf_tx_levels_850[RF_TX_LEVELS_TABLE_SIZE] = {
	{ 600,  0,  0 }, /* 0 */
	{ 600,  0,  0 }, /* 1 */
	{ 600,  0,  0 }, /* 2 */
	{ 600,  0,  0 }, /* 3 */
	{ 600,  0,  0 }, /* 4 */
	{ 600,  0,  0 }, /* 5 */
	{ 540,  1,  0 }, /* 6 */
	{ 450,  2,  0 }, /* 7 */
	{ 385,  3,  0 }, /* 8 */
	{ 330,  4,  0 }, /* 9 */
	{ 285,  5,  0 }, /* 10 */
	{ 250,  6,  0 }, /* 11 */
	{ 220,  7,  0 }, /* 12 */
	{ 195,  8,  0 }, /* 13 */
	{ 175,  9,  0 }, /* 14 */
	{ 160, 10,  0 }, /* 15 */
	{ 145, 11,  0 }, /* 16 */
	{ 133, 12,  0 }, /* 17 */
	{ 123, 13,  0 }, /* 18 */
	{ 115, 14,  0 }, /* 19 */
	{ 115, 14,  0 }, /* 20 */
	{ 115, 14,  0 }, /* 21 */
	{ 115, 14,  0 }, /* 22 */
	{ 115, 14,  0 }, /* 23 */
	{ 115, 14,  0 }, /* 24 */
	{ 115, 14,  0 }, /* 25 */
	{ 115, 14,  0 }, /* 26 */
	{ 115, 14,  0 }, /* 27 */
	{ 115, 14,  0 }, /* 28 */
	{ 115, 14,  0 }, /* 29 */
	{ 115, 14,  0 }, /* 30 */
	{ 115, 14,  0 }, /* 31 */
};

struct txcal_tx_level rf_tx_levels_900[RF_TX_LEVELS_TABLE_SIZE] = {
	{ 570,  0,  0 }, /* 0 */
	{ 570,  0,  0 }, /* 1 */
	{ 570,  0,  0 }, /* 2 */
	{ 570,  0,  0 }, /* 3 */
	{ 570,  0,  0 }, /* 4 */
	{ 570,  0,  0 }, /* 5 */
	{ 496,  1,  1 }, /* 6 */
	{ 437,  2,  1 }, /* 7 */
	{ 385,  3,  1 }, /* 8 */
	{ 339,  4,  1 }, /* 9 */
	{ 299,  5,  2 }, /* 10 */
	{ 263,  6,  2 }, /* 11 */
	{ 232,  7,  2 }, /* 12 */
	{ 204,  8,  2 }, /* 13 */
	{ 180,  9,  2 }, /* 14 */
	{ 159, 10,  3 }, /* 15 */
	{ 141, 11,  3 }, /* 16 */
	{ 125, 12,  3 }, /* 17 */
	{ 111, 13,  3 }, /* 18 */
	{  99, 14,  3 }, /* 19 */
	{  99, 14,  0 }, /* 20 */
	{  99, 14,  0 }, /* 21 */
	{  99, 14,  0 }, /* 22 */
	{  99, 14,  0 }, /* 23 */
	{  99, 14,  0 }, /* 24 */
	{  99, 14,  0 }, /* 25 */
	{  99, 14,  0 }, /* 26 */
	{  99, 14,  0 }, /* 27 */
	{  99, 14,  0 }, /* 28 */
	{  99, 14,  0 }, /* 29 */
	{  99, 14,  0 }, /* 30 */
	{  99, 14,  0 }, /* 31 */
};

struct txcal_tx_level rf_tx_levels_1800[RF_TX_LEVELS_TABLE_SIZE] = {
	{ 640,  0,  0 }, /* 0 */
	{ 558,  1,  0 }, /* 1 */
	{ 493,  2,  1 }, /* 2 */
	{ 435,  3,  1 }, /* 3 */
	{ 384,  4,  1 }, /* 4 */
	{ 338,  5,  1 }, /* 5 */
	{ 297,  6,  1 }, /* 6 */
	{ 261,  7,  1 }, /* 7 */
	{ 228,  8,  2 }, /* 8 */
	{ 199,  9,  2 }, /* 9 */
	{ 174, 10,  3 }, /* 10 */
	{ 151, 11,  3 }, /* 11 */
	{ 132, 12,  3 }, /* 12 */
	{ 115, 13,  3 }, /* 13 */
	{ 100, 14,  3 }, /* 14 */
	{  87, 15,  3 }, /* 15 */
	{  87, 15,  0 }, /* 16 */
	{  87, 15,  0 }, /* 17 */
	{  87, 15,  0 }, /* 18 */
	{  87, 15,  0 }, /* 19 */
	{  87, 15,  0 }, /* 20 */
	{  87, 15,  0 }, /* 21 */
	{  87, 15,  0 }, /* 22 */
	{  87, 15,  0 }, /* 23 */
	{  87, 15,  0 }, /* 24 */
	{  87, 15,  0 }, /* 25 */
	{  87, 15,  0 }, /* 26 */
	{  87, 15,  0 }, /* 27 */
	{  87, 15,  0 }, /* 28 */
	{  87,  0,  0 }, /* 29 */
	{  87,  0,  0 }, /* 30 */
	{  87,  0,  0 }, /* 31 */
};

struct txcal_tx_level rf_tx_levels_1900[RF_TX_LEVELS_TABLE_SIZE] = {
	{ 577,  0,  0 }, /* 0 */
	{ 493,  1,  0 }, /* 1 */
	{ 432,  2,  0 }, /* 2 */
	{ 379,  3,  0 }, /* 3 */
	{ 335,  4,  1 }, /* 4 */
	{ 291,  5,  1 }, /* 5 */
	{ 255,  6,  1 }, /* 6 */
	{ 222,  7,  2 }, /* 7 */
	{ 194,  8,  2 }, /* 8 */
	{ 169,  9,  2 }, /* 9 */
	{ 147, 10,  2 }, /* 10 */
	{ 128, 11,  2 }, /* 11 */
	{ 111, 12,  3 }, /* 12 */
	{  97, 13,  3 }, /* 13 */
	{  85, 14,  3 }, /* 14 */
	{  74, 15,  3 }, /* 15 */
	{ 101, 15,  0 }, /* 16 */
	{ 101, 15,  0 }, /* 17 */
	{ 101, 15,  0 }, /* 18 */
	{ 101, 15,  0 }, /* 19 */
	{ 101, 15,  0 }, /* 20 */
	{ 101, 15,  0 }, /* 21 */
	{ 101, 15,  0 }, /* 22 */
	{ 101, 15,  0 }, /* 23 */
	{ 101, 15,  0 }, /* 24 */
	{ 101, 15,  0 }, /* 25 */
	{ 101, 15,  0 }, /* 26 */
	{ 101, 15,  0 }, /* 27 */
	{ 101, 15,  0 }, /* 28 */
	{ 101,  0,  0 }, /* 29 */
	{ 101,  0,  0 }, /* 30 */
	{ 101,  0,  0 }, /* 31 */
};

struct txcal_ramp_def rf_tx_ramps_850[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
	/* ramp-down */
	{  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};

struct txcal_ramp_def rf_tx_ramps_900[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{ 15, 10,  3, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  0,  0,  0, 19,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  0,  0,  0, 19,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  0,  0,  0,  0, 19,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  0,  0,  0,  0, 19,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{  0,  0,  0, 31,  8,  0,  0,  0,  0,  0, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{  0,  0,  0, 31, 12,  0,  0,  0,  0,  0, 25, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{  0,  0,  0, 31, 16,  0,  0,  0,  0,  0, 21, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{  0,  0,  0, 31, 20,  0,  0,  0,  0,  0, 17, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{  0,  0,  0, 31, 24,  0,  0,  0,  0,  0, 13, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
	/* ramp-down */
	{  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};

struct txcal_ramp_def rf_tx_ramps_1800[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};

struct txcal_ramp_def rf_tx_ramps_1900[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  0,  0,  0, 19,  0,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  0,  0,  0, 19,  0,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  0,  0,  0, 19,  0,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{  0,  0,  0, 19,  0,  0,  0,  0,  1, 19, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{  0,  0,  0, 31,  0,  0,  0,  0,  0,  8, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{  0,  0,  0, 31,  8,  0,  0,  0,  0,  0, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{  0,  0,  0, 31,  8,  0,  0,  0,  0,  0, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{  0,  0,  0, 31,  8,  0,  0,  0,  0,  0, 29, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{  0,  0,  0, 31, 12,  0,  0,  0,  0,  0, 25, 31, 29,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{  0,  0,  0, 14,  0,  0,  1, 19, 29, 31, 29,  5,  0,  0,  0,  0},
	/* ramp-down */
	{  0, 19,  9, 31, 29, 20, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};
