// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "GSM_Types.hh"

namespace GSM__Types {

/* Member functions of C++ classes */

CBCH__BlockType::CBCH__BlockType()
{
}

CBCH__BlockType::CBCH__BlockType(const BITSTRING& par_spare,
    const BITSTRING& par_lpd,
    const BOOLEAN& par_last__block,
    const INTEGER& par_seq__nr)
  :   field_spare(par_spare),
  field_lpd(par_lpd),
  field_last__block(par_last__block),
  field_seq__nr(par_seq__nr)
{
}

CBCH__BlockType::CBCH__BlockType(const CBCH__BlockType& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSM_Types.CBCH_BlockType.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.lpd().is_bound()) field_lpd = other_value.lpd();
else field_lpd.clean_up();
if (other_value.last__block().is_bound()) field_last__block = other_value.last__block();
else field_last__block.clean_up();
if (other_value.seq__nr().is_bound()) field_seq__nr = other_value.seq__nr();
else field_seq__nr.clean_up();
}

void CBCH__BlockType::clean_up()
{
field_spare.clean_up();
field_lpd.clean_up();
field_last__block.clean_up();
field_seq__nr.clean_up();
}

const TTCN_Typedescriptor_t* CBCH__BlockType::get_descriptor() const { return &CBCH__BlockType_descr_; }
CBCH__BlockType& CBCH__BlockType::operator=(const CBCH__BlockType& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSM_Types.CBCH_BlockType.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.lpd().is_bound()) field_lpd = other_value.lpd();
  else field_lpd.clean_up();
  if (other_value.last__block().is_bound()) field_last__block = other_value.last__block();
  else field_last__block.clean_up();
  if (other_value.seq__nr().is_bound()) field_seq__nr = other_value.seq__nr();
  else field_seq__nr.clean_up();
}
return *this;
}

boolean CBCH__BlockType::operator==(const CBCH__BlockType& other_value) const
{
return field_spare==other_value.field_spare
  && field_lpd==other_value.field_lpd
  && field_last__block==other_value.field_last__block
  && field_seq__nr==other_value.field_seq__nr;
}

boolean CBCH__BlockType::is_bound() const
{
return (field_spare.is_bound())
  || (field_lpd.is_bound())
  || (field_last__block.is_bound())
  || (field_seq__nr.is_bound());
}
boolean CBCH__BlockType::is_value() const
{
return field_spare.is_value()
  && field_lpd.is_value()
  && field_last__block.is_value()
  && field_seq__nr.is_value();
}
void CBCH__BlockType::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", lpd := ");
field_lpd.log();
TTCN_Logger::log_event_str(", last_block := ");
field_last__block.log();
TTCN_Logger::log_event_str(", seq_nr := ");
field_seq__nr.log();
TTCN_Logger::log_event_str(" }");
}

void CBCH__BlockType::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (lpd().is_bound()) lpd().set_implicit_omit();
if (last__block().is_bound()) last__block().set_implicit_omit();
if (seq__nr().is_bound()) seq__nr().set_implicit_omit();
}

void CBCH__BlockType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GSM_Types.CBCH_BlockType has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lpd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) last__block().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) seq__nr().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lpd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lpd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "last_block")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          last__block().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "seq_nr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          seq__nr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.CBCH_BlockType: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSM_Types.CBCH_BlockType");
  }
}

void CBCH__BlockType::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_lpd.encode_text(text_buf);
field_last__block.encode_text(text_buf);
field_seq__nr.encode_text(text_buf);
}

void CBCH__BlockType::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_lpd.decode_text(text_buf);
field_last__block.decode_text(text_buf);
field_seq__nr.decode_text(text_buf);
}

void CBCH__BlockType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CBCH__BlockType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CBCH__BlockType::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, CBCH__BlockType_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(CBCH__BlockType_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, CBCH__BlockType_lpd_descr_.raw->forceomit);
  decoded_field_length = field_lpd.RAW_decode(CBCH__BlockType_lpd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, CBCH__BlockType_last__block_descr_.raw->forceomit);
  decoded_field_length = field_last__block.RAW_decode(CBCH__BlockType_last__block_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, CBCH__BlockType_seq__nr_descr_.raw->forceomit);
  decoded_field_length = field_seq__nr.RAW_decode(CBCH__BlockType_seq__nr_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CBCH__BlockType::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, CBCH__BlockType_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CBCH__BlockType_lpd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, CBCH__BlockType_last__block_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, CBCH__BlockType_seq__nr_descr_.raw);
  encoded_length += field_spare.RAW_encode(CBCH__BlockType_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lpd.RAW_encode(CBCH__BlockType_lpd_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_last__block.RAW_encode(CBCH__BlockType_last__block_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_seq__nr.RAW_encode(CBCH__BlockType_seq__nr_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct CBCH__BlockType_template::single_value_struct {
BITSTRING_template field_spare;
BITSTRING_template field_lpd;
BOOLEAN_template field_last__block;
INTEGER_template field_seq__nr;
};

void CBCH__BlockType_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_lpd = ANY_VALUE;
single_value->field_last__block = ANY_VALUE;
single_value->field_seq__nr = ANY_VALUE;
}
}
}

void CBCH__BlockType_template::copy_value(const CBCH__BlockType& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.lpd().is_bound()) {
  single_value->field_lpd = other_value.lpd();
} else {
  single_value->field_lpd.clean_up();
}
if (other_value.last__block().is_bound()) {
  single_value->field_last__block = other_value.last__block();
} else {
  single_value->field_last__block.clean_up();
}
if (other_value.seq__nr().is_bound()) {
  single_value->field_seq__nr = other_value.seq__nr();
} else {
  single_value->field_seq__nr.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CBCH__BlockType_template::copy_template(const CBCH__BlockType_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lpd().get_selection()) {
single_value->field_lpd = other_value.lpd();
} else {
single_value->field_lpd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.last__block().get_selection()) {
single_value->field_last__block = other_value.last__block();
} else {
single_value->field_last__block.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.seq__nr().get_selection()) {
single_value->field_seq__nr = other_value.seq__nr();
} else {
single_value->field_seq__nr.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CBCH__BlockType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CBCH__BlockType_template(*other_value.implication_.precondition);
implication_.implied_template = new CBCH__BlockType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSM_Types.CBCH_BlockType.");
break;
}
set_selection(other_value);
}

CBCH__BlockType_template::CBCH__BlockType_template()
{
}

CBCH__BlockType_template::CBCH__BlockType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CBCH__BlockType_template::CBCH__BlockType_template(const CBCH__BlockType& other_value)
{
copy_value(other_value);
}

CBCH__BlockType_template::CBCH__BlockType_template(const OPTIONAL<CBCH__BlockType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CBCH__BlockType&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSM_Types.CBCH_BlockType from an unbound optional field.");
}
}

CBCH__BlockType_template::CBCH__BlockType_template(CBCH__BlockType_template* p_precondition, CBCH__BlockType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CBCH__BlockType_template::CBCH__BlockType_template(Dynamic_Match_Interface<CBCH__BlockType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CBCH__BlockType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CBCH__BlockType_template::CBCH__BlockType_template(const CBCH__BlockType_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CBCH__BlockType_template::~CBCH__BlockType_template()
{
clean_up();
}

CBCH__BlockType_template& CBCH__BlockType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CBCH__BlockType_template& CBCH__BlockType_template::operator=(const CBCH__BlockType& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CBCH__BlockType_template& CBCH__BlockType_template::operator=(const OPTIONAL<CBCH__BlockType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CBCH__BlockType&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSM_Types.CBCH_BlockType.");
}
return *this;
}

CBCH__BlockType_template& CBCH__BlockType_template::operator=(const CBCH__BlockType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CBCH__BlockType_template::match(const CBCH__BlockType& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.lpd().is_bound()) return FALSE;
if(!single_value->field_lpd.match(other_value.lpd(), legacy))return FALSE;
if(!other_value.last__block().is_bound()) return FALSE;
if(!single_value->field_last__block.match(other_value.last__block(), legacy))return FALSE;
if(!other_value.seq__nr().is_bound()) return FALSE;
if(!single_value->field_seq__nr.match(other_value.seq__nr(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSM_Types.CBCH_BlockType.");
}
return FALSE;
}

boolean CBCH__BlockType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_lpd.is_bound()
 || single_value->field_last__block.is_bound()
 || single_value->field_seq__nr.is_bound();
}

boolean CBCH__BlockType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_lpd.is_value()
 && single_value->field_last__block.is_value()
 && single_value->field_seq__nr.is_value();
}

void CBCH__BlockType_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CBCH__BlockType CBCH__BlockType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSM_Types.CBCH_BlockType.");
CBCH__BlockType ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_lpd.is_bound()) {
ret_val.lpd() = single_value->field_lpd.valueof();
}
if (single_value->field_last__block.is_bound()) {
ret_val.last__block() = single_value->field_last__block.valueof();
}
if (single_value->field_seq__nr.is_bound()) {
ret_val.seq__nr() = single_value->field_seq__nr.valueof();
}
return ret_val;
}

void CBCH__BlockType_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSM_Types.CBCH_BlockType.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CBCH__BlockType_template[list_length];
}

CBCH__BlockType_template& CBCH__BlockType_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSM_Types.CBCH_BlockType.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSM_Types.CBCH_BlockType.");
return value_list.list_value[list_index];
}

BITSTRING_template& CBCH__BlockType_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& CBCH__BlockType_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GSM_Types.CBCH_BlockType.");
return single_value->field_spare;
}

BITSTRING_template& CBCH__BlockType_template::lpd()
{
set_specific();
return single_value->field_lpd;
}

const BITSTRING_template& CBCH__BlockType_template::lpd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lpd of a non-specific template of type @GSM_Types.CBCH_BlockType.");
return single_value->field_lpd;
}

BOOLEAN_template& CBCH__BlockType_template::last__block()
{
set_specific();
return single_value->field_last__block;
}

const BOOLEAN_template& CBCH__BlockType_template::last__block() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field last_block of a non-specific template of type @GSM_Types.CBCH_BlockType.");
return single_value->field_last__block;
}

INTEGER_template& CBCH__BlockType_template::seq__nr()
{
set_specific();
return single_value->field_seq__nr;
}

const INTEGER_template& CBCH__BlockType_template::seq__nr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field seq_nr of a non-specific template of type @GSM_Types.CBCH_BlockType.");
return single_value->field_seq__nr;
}

int CBCH__BlockType_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_BlockType containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSM_Types.CBCH_BlockType.");
  }
  return 0;
}

void CBCH__BlockType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", lpd := ");
single_value->field_lpd.log();
TTCN_Logger::log_event_str(", last_block := ");
single_value->field_last__block.log();
TTCN_Logger::log_event_str(", seq_nr := ");
single_value->field_seq__nr.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CBCH__BlockType_template::log_match(const CBCH__BlockType& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lpd.match(match_value.lpd(), legacy)){
TTCN_Logger::log_logmatch_info(".lpd");
single_value->field_lpd.log_match(match_value.lpd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_last__block.match(match_value.last__block(), legacy)){
TTCN_Logger::log_logmatch_info(".last_block");
single_value->field_last__block.log_match(match_value.last__block(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_seq__nr.match(match_value.seq__nr(), legacy)){
TTCN_Logger::log_logmatch_info(".seq_nr");
single_value->field_seq__nr.log_match(match_value.seq__nr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", lpd := ");
single_value->field_lpd.log_match(match_value.lpd(), legacy);
TTCN_Logger::log_event_str(", last_block := ");
single_value->field_last__block.log_match(match_value.last__block(), legacy);
TTCN_Logger::log_event_str(", seq_nr := ");
single_value->field_seq__nr.log_match(match_value.seq__nr(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CBCH__BlockType_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (lpd().is_bound()) lpd().set_implicit_omit();
if (last__block().is_bound()) last__block().set_implicit_omit();
if (seq__nr().is_bound()) seq__nr().set_implicit_omit();
}

void CBCH__BlockType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_lpd.encode_text(text_buf);
single_value->field_last__block.encode_text(text_buf);
single_value->field_seq__nr.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSM_Types.CBCH_BlockType.");
}
}

void CBCH__BlockType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_lpd.decode_text(text_buf);
single_value->field_last__block.decode_text(text_buf);
single_value->field_seq__nr.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CBCH__BlockType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSM_Types.CBCH_BlockType.");
}
}

void CBCH__BlockType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CBCH__BlockType_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GSM_Types.CBCH_BlockType has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lpd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) last__block().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) seq__nr().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lpd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lpd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "last_block")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          last__block().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "seq_nr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          seq__nr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.CBCH_BlockType: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CBCH__BlockType_template* precondition = new CBCH__BlockType_template;
    precondition->set_param(*param.get_elem(0));
    CBCH__BlockType_template* implied_template = new CBCH__BlockType_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CBCH__BlockType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSM_Types.CBCH_BlockType");
  }
  is_ifpresent = param.get_ifpresent();
}

void CBCH__BlockType_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GSM_Types.CBCH_BlockType");
single_value->field_lpd.check_restriction(t_res, t_name ? t_name : "@GSM_Types.CBCH_BlockType");
single_value->field_last__block.check_restriction(t_res, t_name ? t_name : "@GSM_Types.CBCH_BlockType");
single_value->field_seq__nr.check_restriction(t_res, t_name ? t_name : "@GSM_Types.CBCH_BlockType");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSM_Types.CBCH_BlockType");
}

boolean CBCH__BlockType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CBCH__BlockType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CBCH__Block::CBCH__Block()
{
}

CBCH__Block::CBCH__Block(const CBCH__BlockType& par_block__type,
    const OCTETSTRING& par_payload)
  :   field_block__type(par_block__type),
  field_payload(par_payload)
{
}

CBCH__Block::CBCH__Block(const CBCH__Block& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSM_Types.CBCH_Block.");
if (other_value.block__type().is_bound()) field_block__type = other_value.block__type();
else field_block__type.clean_up();
if (other_value.payload().is_bound()) field_payload = other_value.payload();
else field_payload.clean_up();
}

void CBCH__Block::clean_up()
{
field_block__type.clean_up();
field_payload.clean_up();
}

const TTCN_Typedescriptor_t* CBCH__Block::get_descriptor() const { return &CBCH__Block_descr_; }
CBCH__Block& CBCH__Block::operator=(const CBCH__Block& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSM_Types.CBCH_Block.");
  if (other_value.block__type().is_bound()) field_block__type = other_value.block__type();
  else field_block__type.clean_up();
  if (other_value.payload().is_bound()) field_payload = other_value.payload();
  else field_payload.clean_up();
}
return *this;
}

boolean CBCH__Block::operator==(const CBCH__Block& other_value) const
{
return field_block__type==other_value.field_block__type
  && field_payload==other_value.field_payload;
}

boolean CBCH__Block::is_bound() const
{
return (field_block__type.is_bound())
  || (field_payload.is_bound());
}
boolean CBCH__Block::is_value() const
{
return field_block__type.is_value()
  && field_payload.is_value();
}
void CBCH__Block::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ block_type := ");
field_block__type.log();
TTCN_Logger::log_event_str(", payload := ");
field_payload.log();
TTCN_Logger::log_event_str(" }");
}

void CBCH__Block::set_implicit_omit()
{
if (block__type().is_bound()) block__type().set_implicit_omit();
if (payload().is_bound()) payload().set_implicit_omit();
}

void CBCH__Block::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GSM_Types.CBCH_Block has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) block__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) payload().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "block_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          block__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.CBCH_Block: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSM_Types.CBCH_Block");
  }
}

void CBCH__Block::encode_text(Text_Buf& text_buf) const
{
field_block__type.encode_text(text_buf);
field_payload.encode_text(text_buf);
}

void CBCH__Block::decode_text(Text_Buf& text_buf)
{
field_block__type.decode_text(text_buf);
field_payload.decode_text(text_buf);
}

void CBCH__Block::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CBCH__Block::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CBCH__Block::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, CBCH__Block_block__type_descr_.raw->forceomit);
  decoded_field_length = field_block__type.RAW_decode(CBCH__Block_block__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, CBCH__Block_payload_descr_.raw->forceomit);
  decoded_field_length = field_payload.RAW_decode(CBCH__Block_payload_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CBCH__Block::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, CBCH__Block_block__type_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CBCH__Block_payload_descr_.raw);
  encoded_length += field_block__type.RAW_encode(CBCH__Block_block__type_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_payload.RAW_encode(CBCH__Block_payload_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct CBCH__Block_template::single_value_struct {
CBCH__BlockType_template field_block__type;
OCTETSTRING_template field_payload;
};

void CBCH__Block_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_block__type = ANY_VALUE;
single_value->field_payload = ANY_VALUE;
}
}
}

void CBCH__Block_template::copy_value(const CBCH__Block& other_value)
{
single_value = new single_value_struct;
if (other_value.block__type().is_bound()) {
  single_value->field_block__type = other_value.block__type();
} else {
  single_value->field_block__type.clean_up();
}
if (other_value.payload().is_bound()) {
  single_value->field_payload = other_value.payload();
} else {
  single_value->field_payload.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CBCH__Block_template::copy_template(const CBCH__Block_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.block__type().get_selection()) {
single_value->field_block__type = other_value.block__type();
} else {
single_value->field_block__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.payload().get_selection()) {
single_value->field_payload = other_value.payload();
} else {
single_value->field_payload.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CBCH__Block_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CBCH__Block_template(*other_value.implication_.precondition);
implication_.implied_template = new CBCH__Block_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSM_Types.CBCH_Block.");
break;
}
set_selection(other_value);
}

CBCH__Block_template::CBCH__Block_template()
{
}

CBCH__Block_template::CBCH__Block_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CBCH__Block_template::CBCH__Block_template(const CBCH__Block& other_value)
{
copy_value(other_value);
}

CBCH__Block_template::CBCH__Block_template(const OPTIONAL<CBCH__Block>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CBCH__Block&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSM_Types.CBCH_Block from an unbound optional field.");
}
}

CBCH__Block_template::CBCH__Block_template(CBCH__Block_template* p_precondition, CBCH__Block_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CBCH__Block_template::CBCH__Block_template(Dynamic_Match_Interface<CBCH__Block>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CBCH__Block>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CBCH__Block_template::CBCH__Block_template(const CBCH__Block_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CBCH__Block_template::~CBCH__Block_template()
{
clean_up();
}

CBCH__Block_template& CBCH__Block_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CBCH__Block_template& CBCH__Block_template::operator=(const CBCH__Block& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CBCH__Block_template& CBCH__Block_template::operator=(const OPTIONAL<CBCH__Block>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CBCH__Block&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSM_Types.CBCH_Block.");
}
return *this;
}

CBCH__Block_template& CBCH__Block_template::operator=(const CBCH__Block_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CBCH__Block_template::match(const CBCH__Block& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.block__type().is_bound()) return FALSE;
if(!single_value->field_block__type.match(other_value.block__type(), legacy))return FALSE;
if(!other_value.payload().is_bound()) return FALSE;
if(!single_value->field_payload.match(other_value.payload(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSM_Types.CBCH_Block.");
}
return FALSE;
}

boolean CBCH__Block_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_block__type.is_bound()
 || single_value->field_payload.is_bound();
}

boolean CBCH__Block_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_block__type.is_value()
 && single_value->field_payload.is_value();
}

void CBCH__Block_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CBCH__Block CBCH__Block_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSM_Types.CBCH_Block.");
CBCH__Block ret_val;
if (single_value->field_block__type.is_bound()) {
ret_val.block__type() = single_value->field_block__type.valueof();
}
if (single_value->field_payload.is_bound()) {
ret_val.payload() = single_value->field_payload.valueof();
}
return ret_val;
}

void CBCH__Block_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSM_Types.CBCH_Block.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CBCH__Block_template[list_length];
}

CBCH__Block_template& CBCH__Block_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSM_Types.CBCH_Block.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSM_Types.CBCH_Block.");
return value_list.list_value[list_index];
}

CBCH__BlockType_template& CBCH__Block_template::block__type()
{
set_specific();
return single_value->field_block__type;
}

const CBCH__BlockType_template& CBCH__Block_template::block__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field block_type of a non-specific template of type @GSM_Types.CBCH_Block.");
return single_value->field_block__type;
}

OCTETSTRING_template& CBCH__Block_template::payload()
{
set_specific();
return single_value->field_payload;
}

const OCTETSTRING_template& CBCH__Block_template::payload() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field payload of a non-specific template of type @GSM_Types.CBCH_Block.");
return single_value->field_payload;
}

int CBCH__Block_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.CBCH_Block containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSM_Types.CBCH_Block.");
  }
  return 0;
}

void CBCH__Block_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ block_type := ");
single_value->field_block__type.log();
TTCN_Logger::log_event_str(", payload := ");
single_value->field_payload.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CBCH__Block_template::log_match(const CBCH__Block& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_block__type.match(match_value.block__type(), legacy)){
TTCN_Logger::log_logmatch_info(".block_type");
single_value->field_block__type.log_match(match_value.block__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_payload.match(match_value.payload(), legacy)){
TTCN_Logger::log_logmatch_info(".payload");
single_value->field_payload.log_match(match_value.payload(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ block_type := ");
single_value->field_block__type.log_match(match_value.block__type(), legacy);
TTCN_Logger::log_event_str(", payload := ");
single_value->field_payload.log_match(match_value.payload(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CBCH__Block_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (block__type().is_bound()) block__type().set_implicit_omit();
if (payload().is_bound()) payload().set_implicit_omit();
}

void CBCH__Block_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_block__type.encode_text(text_buf);
single_value->field_payload.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSM_Types.CBCH_Block.");
}
}

void CBCH__Block_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_block__type.decode_text(text_buf);
single_value->field_payload.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CBCH__Block_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSM_Types.CBCH_Block.");
}
}

void CBCH__Block_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CBCH__Block_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GSM_Types.CBCH_Block has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) block__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) payload().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "block_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          block__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "payload")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          payload().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.CBCH_Block: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CBCH__Block_template* precondition = new CBCH__Block_template;
    precondition->set_param(*param.get_elem(0));
    CBCH__Block_template* implied_template = new CBCH__Block_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CBCH__Block_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSM_Types.CBCH_Block");
  }
  is_ifpresent = param.get_ifpresent();
}

void CBCH__Block_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_block__type.check_restriction(t_res, t_name ? t_name : "@GSM_Types.CBCH_Block");
single_value->field_payload.check_restriction(t_res, t_name ? t_name : "@GSM_Types.CBCH_Block");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSM_Types.CBCH_Block");
}

boolean CBCH__Block_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CBCH__Block_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LocationAreaIdentification::LocationAreaIdentification()
{
}

LocationAreaIdentification::LocationAreaIdentification(const HEXSTRING& par_mcc__mnc,
    const INTEGER& par_lac)
  :   field_mcc__mnc(par_mcc__mnc),
  field_lac(par_lac)
{
}

LocationAreaIdentification::LocationAreaIdentification(const LocationAreaIdentification& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSM_Types.LocationAreaIdentification.");
if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
else field_mcc__mnc.clean_up();
if (other_value.lac().is_bound()) field_lac = other_value.lac();
else field_lac.clean_up();
}

void LocationAreaIdentification::clean_up()
{
field_mcc__mnc.clean_up();
field_lac.clean_up();
}

const TTCN_Typedescriptor_t* LocationAreaIdentification::get_descriptor() const { return &LocationAreaIdentification_descr_; }
LocationAreaIdentification& LocationAreaIdentification::operator=(const LocationAreaIdentification& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSM_Types.LocationAreaIdentification.");
  if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
  else field_mcc__mnc.clean_up();
  if (other_value.lac().is_bound()) field_lac = other_value.lac();
  else field_lac.clean_up();
}
return *this;
}

boolean LocationAreaIdentification::operator==(const LocationAreaIdentification& other_value) const
{
return field_mcc__mnc==other_value.field_mcc__mnc
  && field_lac==other_value.field_lac;
}

boolean LocationAreaIdentification::is_bound() const
{
return (field_mcc__mnc.is_bound())
  || (field_lac.is_bound());
}
boolean LocationAreaIdentification::is_value() const
{
return field_mcc__mnc.is_value()
  && field_lac.is_value();
}
void LocationAreaIdentification::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ mcc_mnc := ");
field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
field_lac.log();
TTCN_Logger::log_event_str(" }");
}

void LocationAreaIdentification::set_implicit_omit()
{
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
}

void LocationAreaIdentification::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GSM_Types.LocationAreaIdentification has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.LocationAreaIdentification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSM_Types.LocationAreaIdentification");
  }
}

void LocationAreaIdentification::encode_text(Text_Buf& text_buf) const
{
field_mcc__mnc.encode_text(text_buf);
field_lac.encode_text(text_buf);
}

void LocationAreaIdentification::decode_text(Text_Buf& text_buf)
{
field_mcc__mnc.decode_text(text_buf);
field_lac.decode_text(text_buf);
}

void LocationAreaIdentification::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LocationAreaIdentification::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LocationAreaIdentification::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, LocationAreaIdentification_mcc__mnc_descr_.raw->forceomit);
  decoded_field_length = field_mcc__mnc.RAW_decode(LocationAreaIdentification_mcc__mnc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, LocationAreaIdentification_lac_descr_.raw->forceomit);
  decoded_field_length = field_lac.RAW_decode(LocationAreaIdentification_lac_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LocationAreaIdentification::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, LocationAreaIdentification_mcc__mnc_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LocationAreaIdentification_lac_descr_.raw);
  encoded_length += field_mcc__mnc.RAW_encode(LocationAreaIdentification_mcc__mnc_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lac.RAW_encode(LocationAreaIdentification_lac_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LocationAreaIdentification_template::single_value_struct {
HEXSTRING_template field_mcc__mnc;
INTEGER_template field_lac;
};

void LocationAreaIdentification_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_mcc__mnc = ANY_VALUE;
single_value->field_lac = ANY_VALUE;
}
}
}

void LocationAreaIdentification_template::copy_value(const LocationAreaIdentification& other_value)
{
single_value = new single_value_struct;
if (other_value.mcc__mnc().is_bound()) {
  single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
  single_value->field_mcc__mnc.clean_up();
}
if (other_value.lac().is_bound()) {
  single_value->field_lac = other_value.lac();
} else {
  single_value->field_lac.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LocationAreaIdentification_template::copy_template(const LocationAreaIdentification_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.mcc__mnc().get_selection()) {
single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
single_value->field_mcc__mnc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lac().get_selection()) {
single_value->field_lac = other_value.lac();
} else {
single_value->field_lac.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LocationAreaIdentification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LocationAreaIdentification_template(*other_value.implication_.precondition);
implication_.implied_template = new LocationAreaIdentification_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSM_Types.LocationAreaIdentification.");
break;
}
set_selection(other_value);
}

LocationAreaIdentification_template::LocationAreaIdentification_template()
{
}

LocationAreaIdentification_template::LocationAreaIdentification_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LocationAreaIdentification_template::LocationAreaIdentification_template(const LocationAreaIdentification& other_value)
{
copy_value(other_value);
}

LocationAreaIdentification_template::LocationAreaIdentification_template(const OPTIONAL<LocationAreaIdentification>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LocationAreaIdentification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSM_Types.LocationAreaIdentification from an unbound optional field.");
}
}

LocationAreaIdentification_template::LocationAreaIdentification_template(LocationAreaIdentification_template* p_precondition, LocationAreaIdentification_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LocationAreaIdentification_template::LocationAreaIdentification_template(Dynamic_Match_Interface<LocationAreaIdentification>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LocationAreaIdentification>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LocationAreaIdentification_template::LocationAreaIdentification_template(const LocationAreaIdentification_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LocationAreaIdentification_template::~LocationAreaIdentification_template()
{
clean_up();
}

LocationAreaIdentification_template& LocationAreaIdentification_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LocationAreaIdentification_template& LocationAreaIdentification_template::operator=(const LocationAreaIdentification& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LocationAreaIdentification_template& LocationAreaIdentification_template::operator=(const OPTIONAL<LocationAreaIdentification>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LocationAreaIdentification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSM_Types.LocationAreaIdentification.");
}
return *this;
}

LocationAreaIdentification_template& LocationAreaIdentification_template::operator=(const LocationAreaIdentification_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LocationAreaIdentification_template::match(const LocationAreaIdentification& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.mcc__mnc().is_bound()) return FALSE;
if(!single_value->field_mcc__mnc.match(other_value.mcc__mnc(), legacy))return FALSE;
if(!other_value.lac().is_bound()) return FALSE;
if(!single_value->field_lac.match(other_value.lac(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSM_Types.LocationAreaIdentification.");
}
return FALSE;
}

boolean LocationAreaIdentification_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_mcc__mnc.is_bound()
 || single_value->field_lac.is_bound();
}

boolean LocationAreaIdentification_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_mcc__mnc.is_value()
 && single_value->field_lac.is_value();
}

void LocationAreaIdentification_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LocationAreaIdentification LocationAreaIdentification_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSM_Types.LocationAreaIdentification.");
LocationAreaIdentification ret_val;
if (single_value->field_mcc__mnc.is_bound()) {
ret_val.mcc__mnc() = single_value->field_mcc__mnc.valueof();
}
if (single_value->field_lac.is_bound()) {
ret_val.lac() = single_value->field_lac.valueof();
}
return ret_val;
}

void LocationAreaIdentification_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSM_Types.LocationAreaIdentification.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LocationAreaIdentification_template[list_length];
}

LocationAreaIdentification_template& LocationAreaIdentification_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSM_Types.LocationAreaIdentification.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSM_Types.LocationAreaIdentification.");
return value_list.list_value[list_index];
}

HEXSTRING_template& LocationAreaIdentification_template::mcc__mnc()
{
set_specific();
return single_value->field_mcc__mnc;
}

const HEXSTRING_template& LocationAreaIdentification_template::mcc__mnc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcc_mnc of a non-specific template of type @GSM_Types.LocationAreaIdentification.");
return single_value->field_mcc__mnc;
}

INTEGER_template& LocationAreaIdentification_template::lac()
{
set_specific();
return single_value->field_lac;
}

const INTEGER_template& LocationAreaIdentification_template::lac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lac of a non-specific template of type @GSM_Types.LocationAreaIdentification.");
return single_value->field_lac;
}

int LocationAreaIdentification_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.LocationAreaIdentification containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSM_Types.LocationAreaIdentification.");
  }
  return 0;
}

void LocationAreaIdentification_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LocationAreaIdentification_template::log_match(const LocationAreaIdentification& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_mcc__mnc.match(match_value.mcc__mnc(), legacy)){
TTCN_Logger::log_logmatch_info(".mcc_mnc");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lac.match(match_value.lac(), legacy)){
TTCN_Logger::log_logmatch_info(".lac");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LocationAreaIdentification_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
}

void LocationAreaIdentification_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_mcc__mnc.encode_text(text_buf);
single_value->field_lac.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSM_Types.LocationAreaIdentification.");
}
}

void LocationAreaIdentification_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_mcc__mnc.decode_text(text_buf);
single_value->field_lac.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LocationAreaIdentification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSM_Types.LocationAreaIdentification.");
}
}

void LocationAreaIdentification_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LocationAreaIdentification_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GSM_Types.LocationAreaIdentification has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.LocationAreaIdentification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LocationAreaIdentification_template* precondition = new LocationAreaIdentification_template;
    precondition->set_param(*param.get_elem(0));
    LocationAreaIdentification_template* implied_template = new LocationAreaIdentification_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LocationAreaIdentification_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSM_Types.LocationAreaIdentification");
  }
  is_ifpresent = param.get_ifpresent();
}

void LocationAreaIdentification_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_mcc__mnc.check_restriction(t_res, t_name ? t_name : "@GSM_Types.LocationAreaIdentification");
single_value->field_lac.check_restriction(t_res, t_name ? t_name : "@GSM_Types.LocationAreaIdentification");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSM_Types.LocationAreaIdentification");
}

boolean LocationAreaIdentification_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LocationAreaIdentification_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RoutingAreaIdentification::RoutingAreaIdentification()
{
}

RoutingAreaIdentification::RoutingAreaIdentification(const LocationAreaIdentification& par_lai,
    const INTEGER& par_rac)
  :   field_lai(par_lai),
  field_rac(par_rac)
{
}

RoutingAreaIdentification::RoutingAreaIdentification(const RoutingAreaIdentification& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSM_Types.RoutingAreaIdentification.");
if (other_value.lai().is_bound()) field_lai = other_value.lai();
else field_lai.clean_up();
if (other_value.rac().is_bound()) field_rac = other_value.rac();
else field_rac.clean_up();
}

void RoutingAreaIdentification::clean_up()
{
field_lai.clean_up();
field_rac.clean_up();
}

const TTCN_Typedescriptor_t* RoutingAreaIdentification::get_descriptor() const { return &RoutingAreaIdentification_descr_; }
RoutingAreaIdentification& RoutingAreaIdentification::operator=(const RoutingAreaIdentification& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSM_Types.RoutingAreaIdentification.");
  if (other_value.lai().is_bound()) field_lai = other_value.lai();
  else field_lai.clean_up();
  if (other_value.rac().is_bound()) field_rac = other_value.rac();
  else field_rac.clean_up();
}
return *this;
}

boolean RoutingAreaIdentification::operator==(const RoutingAreaIdentification& other_value) const
{
return field_lai==other_value.field_lai
  && field_rac==other_value.field_rac;
}

boolean RoutingAreaIdentification::is_bound() const
{
return (field_lai.is_bound())
  || (field_rac.is_bound());
}
boolean RoutingAreaIdentification::is_value() const
{
return field_lai.is_value()
  && field_rac.is_value();
}
void RoutingAreaIdentification::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lai := ");
field_lai.log();
TTCN_Logger::log_event_str(", rac := ");
field_rac.log();
TTCN_Logger::log_event_str(" }");
}

void RoutingAreaIdentification::set_implicit_omit()
{
if (lai().is_bound()) lai().set_implicit_omit();
if (rac().is_bound()) rac().set_implicit_omit();
}

void RoutingAreaIdentification::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GSM_Types.RoutingAreaIdentification has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lai().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rac().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lai")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lai().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.RoutingAreaIdentification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSM_Types.RoutingAreaIdentification");
  }
}

void RoutingAreaIdentification::encode_text(Text_Buf& text_buf) const
{
field_lai.encode_text(text_buf);
field_rac.encode_text(text_buf);
}

void RoutingAreaIdentification::decode_text(Text_Buf& text_buf)
{
field_lai.decode_text(text_buf);
field_rac.decode_text(text_buf);
}

void RoutingAreaIdentification::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RoutingAreaIdentification::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RoutingAreaIdentification::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RoutingAreaIdentification_lai_descr_.raw->forceomit);
  decoded_field_length = field_lai.RAW_decode(RoutingAreaIdentification_lai_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RoutingAreaIdentification_rac_descr_.raw->forceomit);
  decoded_field_length = field_rac.RAW_decode(RoutingAreaIdentification_rac_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RoutingAreaIdentification::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RoutingAreaIdentification_lai_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RoutingAreaIdentification_rac_descr_.raw);
  encoded_length += field_lai.RAW_encode(RoutingAreaIdentification_lai_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_rac.RAW_encode(RoutingAreaIdentification_rac_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RoutingAreaIdentification_template::single_value_struct {
LocationAreaIdentification_template field_lai;
INTEGER_template field_rac;
};

void RoutingAreaIdentification_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lai = ANY_VALUE;
single_value->field_rac = ANY_VALUE;
}
}
}

void RoutingAreaIdentification_template::copy_value(const RoutingAreaIdentification& other_value)
{
single_value = new single_value_struct;
if (other_value.lai().is_bound()) {
  single_value->field_lai = other_value.lai();
} else {
  single_value->field_lai.clean_up();
}
if (other_value.rac().is_bound()) {
  single_value->field_rac = other_value.rac();
} else {
  single_value->field_rac.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RoutingAreaIdentification_template::copy_template(const RoutingAreaIdentification_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lai().get_selection()) {
single_value->field_lai = other_value.lai();
} else {
single_value->field_lai.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rac().get_selection()) {
single_value->field_rac = other_value.rac();
} else {
single_value->field_rac.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RoutingAreaIdentification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RoutingAreaIdentification_template(*other_value.implication_.precondition);
implication_.implied_template = new RoutingAreaIdentification_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSM_Types.RoutingAreaIdentification.");
break;
}
set_selection(other_value);
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template()
{
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template(const RoutingAreaIdentification& other_value)
{
copy_value(other_value);
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template(const OPTIONAL<RoutingAreaIdentification>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RoutingAreaIdentification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSM_Types.RoutingAreaIdentification from an unbound optional field.");
}
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template(RoutingAreaIdentification_template* p_precondition, RoutingAreaIdentification_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template(Dynamic_Match_Interface<RoutingAreaIdentification>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RoutingAreaIdentification>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RoutingAreaIdentification_template::RoutingAreaIdentification_template(const RoutingAreaIdentification_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RoutingAreaIdentification_template::~RoutingAreaIdentification_template()
{
clean_up();
}

RoutingAreaIdentification_template& RoutingAreaIdentification_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RoutingAreaIdentification_template& RoutingAreaIdentification_template::operator=(const RoutingAreaIdentification& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RoutingAreaIdentification_template& RoutingAreaIdentification_template::operator=(const OPTIONAL<RoutingAreaIdentification>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RoutingAreaIdentification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSM_Types.RoutingAreaIdentification.");
}
return *this;
}

RoutingAreaIdentification_template& RoutingAreaIdentification_template::operator=(const RoutingAreaIdentification_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RoutingAreaIdentification_template::match(const RoutingAreaIdentification& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lai().is_bound()) return FALSE;
if(!single_value->field_lai.match(other_value.lai(), legacy))return FALSE;
if(!other_value.rac().is_bound()) return FALSE;
if(!single_value->field_rac.match(other_value.rac(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSM_Types.RoutingAreaIdentification.");
}
return FALSE;
}

boolean RoutingAreaIdentification_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lai.is_bound()
 || single_value->field_rac.is_bound();
}

boolean RoutingAreaIdentification_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lai.is_value()
 && single_value->field_rac.is_value();
}

void RoutingAreaIdentification_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RoutingAreaIdentification RoutingAreaIdentification_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSM_Types.RoutingAreaIdentification.");
RoutingAreaIdentification ret_val;
if (single_value->field_lai.is_bound()) {
ret_val.lai() = single_value->field_lai.valueof();
}
if (single_value->field_rac.is_bound()) {
ret_val.rac() = single_value->field_rac.valueof();
}
return ret_val;
}

void RoutingAreaIdentification_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSM_Types.RoutingAreaIdentification.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RoutingAreaIdentification_template[list_length];
}

RoutingAreaIdentification_template& RoutingAreaIdentification_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSM_Types.RoutingAreaIdentification.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSM_Types.RoutingAreaIdentification.");
return value_list.list_value[list_index];
}

LocationAreaIdentification_template& RoutingAreaIdentification_template::lai()
{
set_specific();
return single_value->field_lai;
}

const LocationAreaIdentification_template& RoutingAreaIdentification_template::lai() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lai of a non-specific template of type @GSM_Types.RoutingAreaIdentification.");
return single_value->field_lai;
}

INTEGER_template& RoutingAreaIdentification_template::rac()
{
set_specific();
return single_value->field_rac;
}

const INTEGER_template& RoutingAreaIdentification_template::rac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rac of a non-specific template of type @GSM_Types.RoutingAreaIdentification.");
return single_value->field_rac;
}

int RoutingAreaIdentification_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSM_Types.RoutingAreaIdentification containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSM_Types.RoutingAreaIdentification.");
  }
  return 0;
}

void RoutingAreaIdentification_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lai := ");
single_value->field_lai.log();
TTCN_Logger::log_event_str(", rac := ");
single_value->field_rac.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RoutingAreaIdentification_template::log_match(const RoutingAreaIdentification& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lai.match(match_value.lai(), legacy)){
TTCN_Logger::log_logmatch_info(".lai");
single_value->field_lai.log_match(match_value.lai(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rac.match(match_value.rac(), legacy)){
TTCN_Logger::log_logmatch_info(".rac");
single_value->field_rac.log_match(match_value.rac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lai := ");
single_value->field_lai.log_match(match_value.lai(), legacy);
TTCN_Logger::log_event_str(", rac := ");
single_value->field_rac.log_match(match_value.rac(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RoutingAreaIdentification_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lai().is_bound()) lai().set_implicit_omit();
if (rac().is_bound()) rac().set_implicit_omit();
}

void RoutingAreaIdentification_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lai.encode_text(text_buf);
single_value->field_rac.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSM_Types.RoutingAreaIdentification.");
}
}

void RoutingAreaIdentification_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lai.decode_text(text_buf);
single_value->field_rac.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RoutingAreaIdentification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSM_Types.RoutingAreaIdentification.");
}
}

void RoutingAreaIdentification_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RoutingAreaIdentification_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GSM_Types.RoutingAreaIdentification has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lai().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rac().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lai")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lai().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSM_Types.RoutingAreaIdentification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RoutingAreaIdentification_template* precondition = new RoutingAreaIdentification_template;
    precondition->set_param(*param.get_elem(0));
    RoutingAreaIdentification_template* implied_template = new RoutingAreaIdentification_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RoutingAreaIdentification_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSM_Types.RoutingAreaIdentification");
  }
  is_ifpresent = param.get_ifpresent();
}

void RoutingAreaIdentification_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lai.check_restriction(t_res, t_name ? t_name : "@GSM_Types.RoutingAreaIdentification");
single_value->field_rac.check_restriction(t_res, t_name ? t_name : "@GSM_Types.RoutingAreaIdentification");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSM_Types.RoutingAreaIdentification");
}

boolean RoutingAreaIdentification_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RoutingAreaIdentification_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


/* Bodies of functions, altsteps and testcases */

void GsmArfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmArfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmArfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmArfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UmtsArfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UmtsArfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UmtsArfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UmtsArfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UmtsScramblingCode_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UmtsScramblingCode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UmtsScramblingCode_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UmtsScramblingCode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmFrameNumber_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmFrameNumber_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmFrameNumber_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmFrameNumber_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmRxLev_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmRxLev_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmRxLev_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmRxLev_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmTsc_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmTsc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmTsc_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmTsc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmTmsi_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmTmsi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmTmsi_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmTmsi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GprsTlli_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GprsTlli_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GprsTlli_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GprsTlli_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmMcc_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmMcc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmMcc_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmMcc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmMnc_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmMnc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmMnc_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmMnc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmLac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmLac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmLac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmLac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmCellId_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmCellId_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmCellId_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmCellId_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GroupCallRef_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GroupCallRef_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GroupCallRef_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GroupCallRef_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmBandArfcn_pcs_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmBandArfcn_pcs_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmBandArfcn_pcs_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmBandArfcn_pcs_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmBandArfcn_uplink_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmBandArfcn_uplink_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmBandArfcn_uplink_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmBandArfcn_uplink_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmBandArfcn_spare_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmBandArfcn_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmBandArfcn_spare_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmBandArfcn_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmBandArfcn_arfcn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmBandArfcn_arfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmBandArfcn_arfcn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmBandArfcn_arfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmBandArfcn_encoder(const GsmBandArfcn& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.GsmBandArfcn' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmBandArfcn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmBandArfcn_decoder(OCTETSTRING& input_stream, GsmBandArfcn& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.GsmBandArfcn' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmBandArfcn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

GsmBandArfcn_template ts__GsmBandArfcn(const INTEGER_template& arfcn, const BOOLEAN_template& pcs, const BOOLEAN_template& uplink)
{
TTCN_Location current_location("GSM_Types.ttcn", 46, TTCN_Location::LOCATION_TEMPLATE, "ts_GsmBandArfcn");
GsmBandArfcn_template ret_val;
ret_val.pcs() = pcs;
ret_val.uplink() = uplink;
ret_val.spare() = bs_4;
ret_val.arfcn() = arfcn;
return ret_val;
}

GsmBandArfcn_template tr__GsmBandArfcn(const INTEGER_template& arfcn, const BOOLEAN_template& pcs, const BOOLEAN_template& uplink)
{
TTCN_Location current_location("GSM_Types.ttcn", 55, TTCN_Location::LOCATION_TEMPLATE, "tr_GsmBandArfcn");
GsmBandArfcn_template ret_val;
ret_val.pcs() = pcs;
ret_val.uplink() = uplink;
ret_val.spare() = ANY_VALUE;
ret_val.arfcn() = arfcn;
return ret_val;
}

void PchanConfig_encoder(const PchanConfig& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.PchanConfig' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PchanConfig_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PchanConfig_decoder(OCTETSTRING& input_stream, PchanConfig& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.PchanConfig' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PchanConfig_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GprsCodingScheme_encoder(const GprsCodingScheme& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.GprsCodingScheme' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GprsCodingScheme_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GprsCodingScheme_decoder(OCTETSTRING& input_stream, GprsCodingScheme& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.GprsCodingScheme' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GprsCodingScheme_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

INTEGER f__gprs__blocksize(const GprsCodingScheme& cs)
{
TTCN_Location current_location("GSM_Types.ttcn", 86, TTCN_Location::LOCATION_FUNCTION, "f_gprs_blocksize");
{
const GprsCodingScheme &tmp_1 = cs;
current_location.update_lineno(88);
/* GSM_Types.ttcn, line 88 */
if(tmp_1 == GprsCodingScheme::CS1) goto tmp_0_0;
current_location.update_lineno(89);
/* GSM_Types.ttcn, line 89 */
if(tmp_1 == GprsCodingScheme::CS2) goto tmp_0_1;
current_location.update_lineno(90);
/* GSM_Types.ttcn, line 90 */
if(tmp_1 == GprsCodingScheme::CS3) goto tmp_0_2;
current_location.update_lineno(91);
/* GSM_Types.ttcn, line 91 */
if(tmp_1 == GprsCodingScheme::CS3) goto tmp_0_3;
goto tmp_0_end;
tmp_0_0:
{
current_location.update_lineno(88);
/* GSM_Types.ttcn, line 88 */
return 22;
}
tmp_0_1:
{
current_location.update_lineno(89);
/* GSM_Types.ttcn, line 89 */
return 32;
}
tmp_0_2:
{
current_location.update_lineno(90);
/* GSM_Types.ttcn, line 90 */
return 38;
}
tmp_0_3:
{
current_location.update_lineno(91);
/* GSM_Types.ttcn, line 91 */
return 52;
}
tmp_0_end: /* empty */;
}
current_location.update_lineno(93);
/* GSM_Types.ttcn, line 93 */
Misc__Helpers::f__shutdown(cs_0, 93, FAIL, (TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("Invalid GPRS CS "),cs.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(95);
/* GSM_Types.ttcn, line 95 */
return 0;
}

OCTETSTRING f__gen__tlli()
{
TTCN_Location current_location("GSM_Types.ttcn", 99, TTCN_Location::LOCATION_FUNCTION, "f_gen_tlli");
current_location.update_lineno(100);
/* GSM_Types.ttcn, line 100 */
OCTETSTRING tlli(Osmocom__Types::f__rnd__octstring(4));
current_location.update_lineno(101);
/* GSM_Types.ttcn, line 101 */
if ((tlli == os_0)) {
current_location.update_lineno(102);
/* GSM_Types.ttcn, line 102 */
tlli = os_1;
}
current_location.update_lineno(104);
/* GSM_Types.ttcn, line 104 */
return tlli;
}

void ChannelNeeded_encoder(const ChannelNeeded& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ChannelNeeded_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ChannelNeeded_decoder(OCTETSTRING& input_stream, ChannelNeeded& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ChannelNeeded_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ChannelNeeded12_second_encoder(const ChannelNeeded& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ChannelNeeded12_second_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ChannelNeeded12_second_decoder(OCTETSTRING& input_stream, ChannelNeeded& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ChannelNeeded12_second_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ChannelNeeded12_first_encoder(const ChannelNeeded& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ChannelNeeded12_first_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ChannelNeeded12_first_decoder(OCTETSTRING& input_stream, ChannelNeeded& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ChannelNeeded12_first_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ChannelNeeded12_encoder(const ChannelNeeded12& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded12' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ChannelNeeded12_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ChannelNeeded12_decoder(OCTETSTRING& input_stream, ChannelNeeded12& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.ChannelNeeded12' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ChannelNeeded12_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr0_encoder(const RslChanNr0& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr0' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr0_decoder(OCTETSTRING& input_stream, RslChanNr0& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr0' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr2_tag_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr2_tag_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr2_tag_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr2_tag_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr2_sub__chan_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr2_sub__chan_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr2_sub__chan_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr2_sub__chan_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr2_encoder(const RslChanNr2& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr2' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr2_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr2_decoder(OCTETSTRING& input_stream, RslChanNr2& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr2' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr2_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr4_tag_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr4_tag_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr4_tag_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr4_tag_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr4_sub__chan_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr4_sub__chan_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr4_sub__chan_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr4_sub__chan_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr4_encoder(const RslChanNr4& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr4_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr4_decoder(OCTETSTRING& input_stream, RslChanNr4& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr4_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr8_tag_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr8_tag_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr8_tag_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr8_tag_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr8_sub__chan_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr8_sub__chan_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr8_sub__chan_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr8_sub__chan_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNr8_encoder(const RslChanNr8& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr8' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNr8_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNr8_decoder(OCTETSTRING& input_stream, RslChanNr8& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr8' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNr8_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNrU_ch0_encoder(const RslChanNr0& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr0' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNrU_ch0_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNrU_ch0_decoder(OCTETSTRING& input_stream, RslChanNr0& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr0' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNrU_ch0_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNrU_lm_encoder(const RslChanNr2& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr2' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNrU_lm_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNrU_lm_decoder(OCTETSTRING& input_stream, RslChanNr2& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr2' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNrU_lm_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNrU_sdcch4_encoder(const RslChanNr4& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNrU_sdcch4_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNrU_sdcch4_decoder(OCTETSTRING& input_stream, RslChanNr4& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr4' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNrU_sdcch4_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNrU_sdcch8_encoder(const RslChanNr8& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr8' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNrU_sdcch8_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNrU_sdcch8_decoder(OCTETSTRING& input_stream, RslChanNr8& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNr8' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNrU_sdcch8_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChanNrU_encoder(const RslChanNrU& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNrU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChanNrU_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChanNrU_decoder(OCTETSTRING& input_stream, RslChanNrU& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNrU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChanNrU_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChannelNr_u_encoder(const RslChanNrU& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNrU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChannelNr_u_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChannelNr_u_decoder(OCTETSTRING& input_stream, RslChanNrU& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChanNrU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChannelNr_u_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChannelNr_tn_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChannelNr_tn_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChannelNr_tn_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChannelNr_tn_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslChannelNr_encoder(const RslChannelNr& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChannelNr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslChannelNr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslChannelNr_decoder(OCTETSTRING& input_stream, RslChannelNr& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslChannelNr' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslChannelNr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

RslChannelNr_template t__RslChanNr0(const INTEGER_template& tn, const RslChanNr0_template& cht)
{
TTCN_Location current_location("GSM_Types.ttcn", 168, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr0");
RslChannelNr_template ret_val;
ret_val.u().ch0() = cht;
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template t__RslChanNr__RACH(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 173, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_RACH");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__RACH));
return ret_val;
}

RslChannelNr_template t__RslChanNr__BCCH(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 174, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_BCCH");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__BCCH));
return ret_val;
}

RslChannelNr_template t__RslChanNr__PCH__AGCH(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 175, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_PCH_AGCH");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__PCH__AGCH));
return ret_val;
}

RslChannelNr_template t__RslChanNr__Bm(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 176, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_Bm");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__Bm__ACCH));
return ret_val;
}

RslChannelNr_template t__RslChanNr__PDCH(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 177, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_PDCH");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__OSMO__PDCH));
return ret_val;
}

RslChannelNr_template t__RslChanNr__CBCH4(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 178, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_CBCH4");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__OSMO__CBCH4));
return ret_val;
}

RslChannelNr_template t__RslChanNr__CBCH8(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 179, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_CBCH8");
RslChannelNr_template ret_val;
ret_val = t__RslChanNr0(tn, RslChanNr0_template(RslChanNr0::RSL__CHAN__NR__OSMO__CBCH8));
return ret_val;
}

RslChannelNr_template t__RslChanNr__Lm(const INTEGER_template& tn, const INTEGER_template& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 180, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_Lm");
RslChannelNr_template ret_val;
{
RslChanNr2_template& tmp_3 = ret_val.u().lm();
tmp_3.tag() = bs_0;
tmp_3.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template t__RslChanNr__SDCCH4(const INTEGER_template& tn, const INTEGER_template& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 184, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_SDCCH4");
RslChannelNr_template ret_val;
{
RslChanNr4_template& tmp_4 = ret_val.u().sdcch4();
tmp_4.tag() = bs_2;
tmp_4.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template t__RslChanNr__SDCCH8(const INTEGER_template& tn, const INTEGER_template& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 188, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_SDCCH8");
RslChannelNr_template ret_val;
{
RslChanNr8_template& tmp_5 = ret_val.u().sdcch8();
tmp_5.tag() = bs_3;
tmp_5.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template t__RslChanNr__Osmo__VAMOS__Bm(const INTEGER_template& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 192, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_Osmo_VAMOS_Bm");
RslChannelNr_template ret_val;
ret_val.u().ch0() = RslChanNr0::RSL__CHAN__NR__OSMO__VAMOS__Bm__ACCH;
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template t__RslChanNr__Osmo__VAMOS__Lm(const INTEGER_template& tn, const INTEGER_template& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 197, TTCN_Location::LOCATION_TEMPLATE, "t_RslChanNr_Osmo_VAMOS_Lm");
RslChannelNr_template ret_val;
{
RslChanNr2_template& tmp_6 = ret_val.u().lm();
tmp_6.tag() = bs_1;
tmp_6.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template ts__RslChanNr0(const INTEGER& tn, const RslChanNr0& cht)
{
TTCN_Location current_location("GSM_Types.ttcn", 202, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr0");
RslChannelNr_template ret_val;
ret_val.u().ch0() = cht;
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template ts__RslChanNr__RACH(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 206, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_RACH");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__RACH);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__BCCH(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 207, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_BCCH");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__BCCH);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__PCH__AGCH(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 208, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_PCH_AGCH");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__PCH__AGCH);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__Bm(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 209, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_Bm");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__Bm__ACCH);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__PDCH(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 210, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_PDCH");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__OSMO__PDCH);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__CBCH4(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 211, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_CBCH4");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__OSMO__CBCH4);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__CBCH8(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 212, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_CBCH8");
RslChannelNr_template ret_val;
ret_val = ts__RslChanNr0(tn, RslChanNr0::RSL__CHAN__NR__OSMO__CBCH8);
return ret_val;
}

RslChannelNr_template ts__RslChanNr__Lm(const INTEGER& tn, const INTEGER& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 213, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_Lm");
RslChannelNr_template ret_val;
{
RslChanNr2_template& tmp_7 = ret_val.u().lm();
tmp_7.tag() = bs_0;
tmp_7.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template ts__RslChanNr__SDCCH4(const INTEGER& tn, const INTEGER& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 217, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_SDCCH4");
RslChannelNr_template ret_val;
{
RslChanNr4_template& tmp_8 = ret_val.u().sdcch4();
tmp_8.tag() = bs_2;
tmp_8.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template ts__RslChanNr__SDCCH8(const INTEGER& tn, const INTEGER& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 221, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_SDCCH8");
RslChannelNr_template ret_val;
{
RslChanNr8_template& tmp_9 = ret_val.u().sdcch8();
tmp_9.tag() = bs_3;
tmp_9.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template ts__RslChanNr__Osmo__VAMOS__Bm(const INTEGER& tn)
{
TTCN_Location current_location("GSM_Types.ttcn", 225, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_Osmo_VAMOS_Bm");
RslChannelNr_template ret_val;
ret_val.u().ch0() = RslChanNr0::RSL__CHAN__NR__OSMO__VAMOS__Bm__ACCH;
ret_val.tn() = tn;
return ret_val;
}

RslChannelNr_template ts__RslChanNr__Osmo__VAMOS__Lm(const INTEGER& tn, const INTEGER& sub__slot)
{
TTCN_Location current_location("GSM_Types.ttcn", 229, TTCN_Location::LOCATION_TEMPLATE, "ts_RslChanNr_Osmo_VAMOS_Lm");
RslChannelNr_template ret_val;
{
RslChanNr2_template& tmp_10 = ret_val.u().lm();
tmp_10.tag() = bs_1;
tmp_10.sub__chan() = sub__slot;
}
ret_val.tn() = tn;
return ret_val;
}

void RslLinkIdC_encoder(const RslLinkIdC& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslLinkIdC' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslLinkIdC_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslLinkIdC_decoder(OCTETSTRING& input_stream, RslLinkIdC& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslLinkIdC' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslLinkIdC_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslSapi0Prio_encoder(const RslSapi0Prio& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslSapi0Prio' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslSapi0Prio_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslSapi0Prio_decoder(OCTETSTRING& input_stream, RslSapi0Prio& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslSapi0Prio' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslSapi0Prio_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GsmSapi_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmSapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmSapi_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmSapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslLinkId_c_encoder(const RslLinkIdC& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslLinkIdC' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslLinkId_c_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslLinkId_c_decoder(OCTETSTRING& input_stream, RslLinkIdC& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslLinkIdC' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslLinkId_c_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslLinkId_na_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslLinkId_na_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslLinkId_na_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslLinkId_na_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslLinkId_prio_encoder(const RslSapi0Prio& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslSapi0Prio' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslLinkId_prio_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslLinkId_prio_decoder(OCTETSTRING& input_stream, RslSapi0Prio& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslSapi0Prio' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslLinkId_prio_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslLinkId_sapi_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslLinkId_sapi_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslLinkId_sapi_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslLinkId_sapi_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RslLinkId_encoder(const RslLinkId& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslLinkId' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RslLinkId_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RslLinkId_decoder(OCTETSTRING& input_stream, RslLinkId& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RslLinkId' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RslLinkId_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

RslLinkId_template tr__RslLinkID__DCCH(const INTEGER_template& sapi)
{
TTCN_Location current_location("GSM_Types.ttcn", 264, TTCN_Location::LOCATION_TEMPLATE, "tr_RslLinkID_DCCH");
RslLinkId_template ret_val(tr__RslLinkId);
ret_val.c() = RslLinkIdC::FACCH__SDCCH;
ret_val.na() = FALSE;
ret_val.sapi() = sapi;
return ret_val;
}

RslLinkId_template tr__RslLinkID__SACCH(const INTEGER_template& sapi)
{
TTCN_Location current_location("GSM_Types.ttcn", 270, TTCN_Location::LOCATION_TEMPLATE, "tr_RslLinkID_SACCH");
RslLinkId_template ret_val(tr__RslLinkId);
ret_val.c() = RslLinkIdC::SACCH;
ret_val.na() = FALSE;
ret_val.sapi() = sapi;
return ret_val;
}

RslLinkId_template tr__RslLinkID__OSMO__PTCCH(const INTEGER_template& sapi)
{
TTCN_Location current_location("GSM_Types.ttcn", 276, TTCN_Location::LOCATION_TEMPLATE, "tr_RslLinkID_OSMO_PTCCH");
RslLinkId_template ret_val(tr__RslLinkId);
ret_val.c() = RslLinkIdC::OSMO__PTCCH;
ret_val.na() = FALSE;
ret_val.sapi() = sapi;
return ret_val;
}

RslLinkId_template ts__RslLinkID__DCCH(const INTEGER& sapi)
{
TTCN_Location current_location("GSM_Types.ttcn", 282, TTCN_Location::LOCATION_TEMPLATE, "ts_RslLinkID_DCCH");
RslLinkId_template ret_val;
ret_val.c() = RslLinkIdC::FACCH__SDCCH;
ret_val.na() = FALSE;
ret_val.prio() = RslSapi0Prio::SAPI0__PRIO__NORMAL;
ret_val.sapi() = sapi;
return ret_val;
}

RslLinkId_template ts__RslLinkID__SACCH(const INTEGER& sapi)
{
TTCN_Location current_location("GSM_Types.ttcn", 289, TTCN_Location::LOCATION_TEMPLATE, "ts_RslLinkID_SACCH");
RslLinkId_template ret_val;
ret_val.c() = RslLinkIdC::SACCH;
ret_val.na() = FALSE;
ret_val.prio() = RslSapi0Prio::SAPI0__PRIO__NORMAL;
ret_val.sapi() = sapi;
return ret_val;
}

RslLinkId_template ts__RslLinkID__OSMO__PTCCH(const INTEGER& sapi)
{
TTCN_Location current_location("GSM_Types.ttcn", 296, TTCN_Location::LOCATION_TEMPLATE, "ts_RslLinkID_OSMO_PTCCH");
RslLinkId_template ret_val;
ret_val.c() = RslLinkIdC::OSMO__PTCCH;
ret_val.na() = FALSE;
ret_val.prio() = RslSapi0Prio::SAPI0__PRIO__NORMAL;
ret_val.sapi() = sapi;
return ret_val;
}

BITSTRING f__hex__is__odd__length(const HEXSTRING& digits)
{
TTCN_Location current_location("GSM_Types.ttcn", 303, TTCN_Location::LOCATION_FUNCTION, "f_hex_is_odd_length");
current_location.update_lineno(304);
/* GSM_Types.ttcn, line 304 */
if ((rem(digits.lengthof(), 2) == 1)) {
current_location.update_lineno(305);
/* GSM_Types.ttcn, line 305 */
return bs_5;
}
else {
current_location.update_lineno(307);
/* GSM_Types.ttcn, line 307 */
return bs_6;
}
}

void CBCH__BlockType_spare_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__BlockType_spare_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__BlockType_spare_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__BlockType_spare_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBCH__BlockType_lpd_encoder(const BITSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__BlockType_lpd_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__BlockType_lpd_decoder(OCTETSTRING& input_stream, BITSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `bitstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__BlockType_lpd_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBCH__BlockType_last__block_encoder(const BOOLEAN& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__BlockType_last__block_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__BlockType_last__block_decoder(OCTETSTRING& input_stream, BOOLEAN& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `boolean' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__BlockType_last__block_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBCH__BlockType_seq__nr_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__BlockType_seq__nr_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__BlockType_seq__nr_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__BlockType_seq__nr_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBCH__BlockType_encoder(const CBCH__BlockType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.CBCH_BlockType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__BlockType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__BlockType_decoder(OCTETSTRING& input_stream, CBCH__BlockType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.CBCH_BlockType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__BlockType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

CBCH__BlockType_template ts__CBCH__BlockType(const INTEGER_template& seq__nr, const BOOLEAN_template& last__block)
{
TTCN_Location current_location("GSM_Types.ttcn", 319, TTCN_Location::LOCATION_TEMPLATE, "ts_CBCH_BlockType");
CBCH__BlockType_template ret_val;
ret_val.spare() = bs_6;
ret_val.lpd() = bs_3;
ret_val.last__block() = last__block;
ret_val.seq__nr() = seq__nr;
return ret_val;
}

CBCH__BlockType_template tr__CBCH__BlockType(const INTEGER_template& seq__nr, const BOOLEAN_template& last__block)
{
TTCN_Location current_location("GSM_Types.ttcn", 325, TTCN_Location::LOCATION_TEMPLATE, "tr_CBCH_BlockType");
CBCH__BlockType_template ret_val;
ret_val.spare() = bs_6;
ret_val.lpd() = bs_3;
ret_val.last__block() = last__block;
ret_val.seq__nr() = seq__nr;
return ret_val;
}

void CBCH__Block_block__type_encoder(const CBCH__BlockType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.CBCH_BlockType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__Block_block__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__Block_block__type_decoder(OCTETSTRING& input_stream, CBCH__BlockType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.CBCH_BlockType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__Block_block__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBCH__Block_payload_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__Block_payload_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__Block_payload_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__Block_payload_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBCH__Block_encoder(const CBCH__Block& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.CBCH_Block' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBCH__Block_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBCH__Block_decoder(OCTETSTRING& input_stream, CBCH__Block& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.CBCH_Block' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBCH__Block_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

CBCH__Block_template ts__CBCH__Block(const INTEGER_template& seq__nr, const BOOLEAN_template& last__block, const OCTETSTRING_template& payload)
{
TTCN_Location current_location("GSM_Types.ttcn", 337, TTCN_Location::LOCATION_TEMPLATE, "ts_CBCH_Block");
CBCH__Block_template ret_val;
ret_val.block__type() = ts__CBCH__BlockType(seq__nr, last__block);
ret_val.payload() = payload;
return ret_val;
}

CBCH__Block_template tr__CBCH__Block(const INTEGER_template& seq__nr, const BOOLEAN_template& last__block, const OCTETSTRING_template& payload)
{
TTCN_Location current_location("GSM_Types.ttcn", 341, TTCN_Location::LOCATION_TEMPLATE, "tr_CBCH_Block");
CBCH__Block_template ret_val;
ret_val.block__type() = tr__CBCH__BlockType(seq__nr, last__block);
ret_val.payload() = payload;
return ret_val;
}

OCTETSTRING enc__CBCH__Block(const CBCH__Block& msg)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_CBCH_Block(): Encoding @GSM_Types.CBCH_Block: ");
msg.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
msg.encode(CBCH__Block_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_CBCH_Block(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

CBCH__Block dec__CBCH__Block(const OCTETSTRING& stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_CBCH_Block(): Stream before decoding: ");
stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(stream);
CBCH__Block ret_val;
ret_val.decode(CBCH__Block_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_CBCH_Block(): Decoded @GSM_Types.CBCH_Block: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_CBCH_Block(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

INTEGER dbm2rxlev(const INTEGER& dbm)
{
TTCN_Location current_location("GSM_Types.ttcn", 354, TTCN_Location::LOCATION_FUNCTION, "dbm2rxlev");
current_location.update_lineno(355);
/* GSM_Types.ttcn, line 355 */
INTEGER rxlev((dbm + 110));
current_location.update_lineno(356);
/* GSM_Types.ttcn, line 356 */
if ((rxlev > 63)) {
current_location.update_lineno(357);
/* GSM_Types.ttcn, line 357 */
rxlev = 63;
}
else {
current_location.update_lineno(358);
/* GSM_Types.ttcn, line 358 */
if ((rxlev < 0)) {
current_location.update_lineno(359);
/* GSM_Types.ttcn, line 359 */
rxlev = 0;
}
}
current_location.update_lineno(361);
/* GSM_Types.ttcn, line 361 */
return rxlev;
}

INTEGER rxlev2dbm(const INTEGER& rxlev)
{
TTCN_Location current_location("GSM_Types.ttcn", 364, TTCN_Location::LOCATION_FUNCTION, "rxlev2dbm");
current_location.update_lineno(365);
/* GSM_Types.ttcn, line 365 */
return (-110 + rxlev);
}

INTEGER ber2rxqual(const FLOAT& ber)
{
TTCN_Location current_location("GSM_Types.ttcn", 369, TTCN_Location::LOCATION_FUNCTION, "ber2rxqual");
current_location.update_lineno(370);
/* GSM_Types.ttcn, line 370 */
if ((ber < 2.0e-1)) {
current_location.update_lineno(371);
/* GSM_Types.ttcn, line 371 */
return 0;
}
else {
current_location.update_lineno(372);
/* GSM_Types.ttcn, line 372 */
if ((ber < 4.0e-1)) {
current_location.update_lineno(373);
/* GSM_Types.ttcn, line 373 */
return 1;
}
else {
current_location.update_lineno(374);
/* GSM_Types.ttcn, line 374 */
if ((ber < 8.0e-1)) {
current_location.update_lineno(375);
/* GSM_Types.ttcn, line 375 */
return 2;
}
else {
current_location.update_lineno(376);
/* GSM_Types.ttcn, line 376 */
if ((ber < 1.6)) {
current_location.update_lineno(377);
/* GSM_Types.ttcn, line 377 */
return 3;
}
else {
current_location.update_lineno(378);
/* GSM_Types.ttcn, line 378 */
if ((ber < 3.2)) {
current_location.update_lineno(379);
/* GSM_Types.ttcn, line 379 */
return 4;
}
else {
current_location.update_lineno(380);
/* GSM_Types.ttcn, line 380 */
if ((ber < 6.4)) {
current_location.update_lineno(381);
/* GSM_Types.ttcn, line 381 */
return 5;
}
else {
current_location.update_lineno(382);
/* GSM_Types.ttcn, line 382 */
if ((ber < 1.28e1)) {
current_location.update_lineno(383);
/* GSM_Types.ttcn, line 383 */
return 6;
}
else {
current_location.update_lineno(385);
/* GSM_Types.ttcn, line 385 */
return 7;
}
}
}
}
}
}
}
}

FLOAT rxqual2ber(const INTEGER& rxqual)
{
TTCN_Location current_location("GSM_Types.ttcn", 390, TTCN_Location::LOCATION_FUNCTION, "rxqual2ber");
{
const INTEGER &tmp_14 = rxqual;
switch(tmp_14.get_long_long_val()) {
case(0):
{
current_location.update_lineno(392);
/* GSM_Types.ttcn, line 392 */
return 1.4e-1;
break;
}
case(1):
{
current_location.update_lineno(393);
/* GSM_Types.ttcn, line 393 */
return 2.8e-1;
break;
}
case(2):
{
current_location.update_lineno(394);
/* GSM_Types.ttcn, line 394 */
return 5.7e-1;
break;
}
case(3):
{
current_location.update_lineno(395);
/* GSM_Types.ttcn, line 395 */
return 1.13;
break;
}
case(4):
{
current_location.update_lineno(396);
/* GSM_Types.ttcn, line 396 */
return 2.26;
break;
}
case(5):
{
current_location.update_lineno(397);
/* GSM_Types.ttcn, line 397 */
return 4.53;
break;
}
case(6):
{
current_location.update_lineno(398);
/* GSM_Types.ttcn, line 398 */
return 9.05;
break;
}
case(7):
{
current_location.update_lineno(399);
/* GSM_Types.ttcn, line 399 */
return 1.81e1;
break;
}
default:
{
current_location.update_lineno(400);
/* GSM_Types.ttcn, line 400 */
return 1.0e3;
break;
}
};}
}

INTEGER f__ccch__blocks__per__mframe(const BOOLEAN& combined__ccch)
{
TTCN_Location current_location("GSM_Types.ttcn", 409, TTCN_Location::LOCATION_FUNCTION, "f_ccch_blocks_per_mframe");
current_location.update_lineno(410);
/* GSM_Types.ttcn, line 410 */
if ((!(combined__ccch))) {
current_location.update_lineno(412);
/* GSM_Types.ttcn, line 412 */
return 9;
}
else {
current_location.update_lineno(415);
/* GSM_Types.ttcn, line 415 */
return 3;
}
}

FLOAT f__pch__block__rate__est(const BOOLEAN& combined__ccch, const INTEGER& bs__ag__blks__res)
{
TTCN_Location current_location("GSM_Types.ttcn", 420, TTCN_Location::LOCATION_FUNCTION, "f_pch_block_rate_est");
current_location.update_lineno(421);
/* GSM_Types.ttcn, line 421 */
INTEGER ccch__per__mframe(f__ccch__blocks__per__mframe(combined__ccch));
current_location.update_lineno(422);
/* GSM_Types.ttcn, line 422 */
INTEGER pch__per__mframe((ccch__per__mframe - bs__ag__blks__res));
current_location.update_lineno(423);
/* GSM_Types.ttcn, line 423 */
return (4.2483660130719 * int2float(pch__per__mframe));
}

FLOAT f__agch__block__rate__est(const BOOLEAN& combined__ccch, const INTEGER& bs__ag__blks__res)
{
TTCN_Location current_location("GSM_Types.ttcn", 427, TTCN_Location::LOCATION_FUNCTION, "f_agch_block_rate_est");
current_location.update_lineno(428);
/* GSM_Types.ttcn, line 428 */
INTEGER ccch__per__mframe(f__ccch__blocks__per__mframe(combined__ccch));
current_location.update_lineno(429);
/* GSM_Types.ttcn, line 429 */
return (4.2483660130719 * int2float(bs__ag__blks__res));
}

INTEGER f__gsm__compute__tc(const INTEGER& fn)
{
TTCN_Location current_location("GSM_Types.ttcn", 433, TTCN_Location::LOCATION_FUNCTION, "f_gsm_compute_tc");
current_location.update_lineno(434);
/* GSM_Types.ttcn, line 434 */
return mod((fn / 51), 8);
}

void GsmBcdString_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(GsmBcdString_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GsmBcdString_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(GsmBcdString_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BcdMccMnc_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BcdMccMnc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BcdMccMnc_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BcdMccMnc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__BcdMccMnc(const HEXSTRING& str)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_BcdMccMnc(): Encoding hexstring: ");
str.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
str.encode(BcdMccMnc_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_BcdMccMnc(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

HEXSTRING dec__BcdMccMnc(const OCTETSTRING& str)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_BcdMccMnc(): Stream before decoding: ");
str.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(str);
HEXSTRING ret_val;
ret_val.decode(BcdMccMnc_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_BcdMccMnc(): Decoded hexstring: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_BcdMccMnc(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

HEXSTRING f__build__BcdMccMnc(const HEXSTRING& mcc, const HEXSTRING& mnc)
{
HEXSTRING mnc_shadow(mnc);
TTCN_Location current_location("GSM_Types.ttcn", 448, TTCN_Location::LOCATION_FUNCTION, "f_build_BcdMccMnc");
current_location.update_lineno(449);
/* GSM_Types.ttcn, line 449 */
if ((mnc_shadow.lengthof() == 2)) {
current_location.update_lineno(450);
/* GSM_Types.ttcn, line 450 */
{
HEXSTRING tmp_15;
tmp_15 = ((const_cast< const HEXSTRING&>(mnc_shadow)[0] + const_cast< const HEXSTRING&>(mnc_shadow)[1]) + hs_0);
mnc_shadow = tmp_15;
}
}
current_location.update_lineno(459);
/* GSM_Types.ttcn, line 459 */
return (((((const_cast< const HEXSTRING&>(mcc)[0] + const_cast< const HEXSTRING&>(mcc)[1]) + const_cast< const HEXSTRING&>(mcc)[2]) + const_cast< const HEXSTRING&>(mnc_shadow)[2]) + const_cast< const HEXSTRING&>(mnc_shadow)[0]) + const_cast< const HEXSTRING&>(mnc_shadow)[1]);
}

HEXSTRING f__build__BcdMccMnc__int(const INTEGER& mcc, const INTEGER& mnc, const BOOLEAN& mnc__3__digits)
{
TTCN_Location current_location("GSM_Types.ttcn", 463, TTCN_Location::LOCATION_FUNCTION, "f_build_BcdMccMnc_int");
current_location.update_lineno(464);
/* GSM_Types.ttcn, line 464 */
HEXSTRING mcc__str(str2hex(int2str(mcc)));
current_location.update_lineno(465);
/* GSM_Types.ttcn, line 465 */
HEXSTRING mnc__str(str2hex(int2str(mnc)));
current_location.update_lineno(466);
/* GSM_Types.ttcn, line 466 */
if ((mnc__3__digits == TRUE)) {
current_location.update_lineno(467);
/* GSM_Types.ttcn, line 467 */
return f__build__BcdMccMnc(((const_cast< const HEXSTRING&>(mcc__str)[0] + const_cast< const HEXSTRING&>(mcc__str)[1]) + const_cast< const HEXSTRING&>(mcc__str)[2]), ((const_cast< const HEXSTRING&>(mnc__str)[0] + const_cast< const HEXSTRING&>(mnc__str)[1]) + const_cast< const HEXSTRING&>(mnc__str)[2]));
}
else {
current_location.update_lineno(470);
/* GSM_Types.ttcn, line 470 */
return f__build__BcdMccMnc(((const_cast< const HEXSTRING&>(mcc__str)[0] + const_cast< const HEXSTRING&>(mcc__str)[1]) + const_cast< const HEXSTRING&>(mcc__str)[2]), (const_cast< const HEXSTRING&>(mnc__str)[0] + const_cast< const HEXSTRING&>(mnc__str)[1]));
}
}

verdicttype testcase_TC__selftest__BcdMccMnc(boolean has_timer, double timer_value)
{
TTCN_Runtime::check_begin_testcase(has_timer, timer_value);
TTCN_Location current_location("GSM_Types.ttcn", 475, TTCN_Location::LOCATION_TESTCASE, "TC_selftest_BcdMccMnc");
try {
TTCN_Runtime::begin_testcase("GSM_Types", "TC_selftest_BcdMccMnc", "General_Types", "Dummy_CT", "General_Types", "Dummy_CT", has_timer, timer_value);
current_location.update_lineno(476);
/* GSM_Types.ttcn, line 476 */
{
boolean tmp_19;
{
OCTETSTRING_template tmp_16;
class Dec_Match_tmp_17 : public Dec_Match_Interface {
HEXSTRING_template target;
HEXSTRING* dec_val;
public:
Dec_Match_tmp_17(HEXSTRING_template p_target): target(p_target), dec_val(NULL) { }
~Dec_Match_tmp_17() { if (dec_val != NULL) delete dec_val; }
virtual boolean match(TTCN_Buffer& buff)
{
if (dec_val != NULL) delete dec_val;
dec_val = new HEXSTRING;
boolean ret_val;
OCTETSTRING os;
buff.get_string(os);
if (BcdMccMnc_decoder(os, *dec_val, BcdMccMnc_default_coding) != 0) {
TTCN_warning("Decoded content matching failed, because the data could not be decoded.");
ret_val = FALSE;
}
else if (os.lengthof() != 0) {
TTCN_warning("Decoded content matching failed, because the buffer was not empty after decoding. Remaining octets: %d.", os.lengthof());
ret_val = FALSE;
}
else ret_val = target.match(*dec_val);
if (!ret_val) {
delete dec_val;
dec_val = NULL;
}
return ret_val;
}
virtual void log() const
{
TTCN_Logger::log_event_str("hexstring: ");
target.log();
}
void* get_dec_res() const { return dec_val; }
const TTCN_Typedescriptor_t* get_type_descr() const { return &BcdMccMnc_descr_; }
};
tmp_16.set_type(DECODE_MATCH);
{
HEXSTRING_template tmp_18;
tmp_18 = hs_1;
tmp_16.set_decmatch(new Dec_Match_tmp_17(tmp_18));
}
tmp_19 = (!(tmp_16.match(os_2)));
}
if (tmp_19) {
current_location.update_lineno(476);
/* GSM_Types.ttcn, line 476 */
TTCN_Runtime::setverdict(FAIL);
}
}
current_location.update_lineno(477);
/* GSM_Types.ttcn, line 477 */
{
boolean tmp_23;
{
OCTETSTRING_template tmp_20;
class Dec_Match_tmp_21 : public Dec_Match_Interface {
HEXSTRING_template target;
HEXSTRING* dec_val;
public:
Dec_Match_tmp_21(HEXSTRING_template p_target): target(p_target), dec_val(NULL) { }
~Dec_Match_tmp_21() { if (dec_val != NULL) delete dec_val; }
virtual boolean match(TTCN_Buffer& buff)
{
if (dec_val != NULL) delete dec_val;
dec_val = new HEXSTRING;
boolean ret_val;
OCTETSTRING os;
buff.get_string(os);
if (BcdMccMnc_decoder(os, *dec_val, BcdMccMnc_default_coding) != 0) {
TTCN_warning("Decoded content matching failed, because the data could not be decoded.");
ret_val = FALSE;
}
else if (os.lengthof() != 0) {
TTCN_warning("Decoded content matching failed, because the buffer was not empty after decoding. Remaining octets: %d.", os.lengthof());
ret_val = FALSE;
}
else ret_val = target.match(*dec_val);
if (!ret_val) {
delete dec_val;
dec_val = NULL;
}
return ret_val;
}
virtual void log() const
{
TTCN_Logger::log_event_str("hexstring: ");
target.log();
}
void* get_dec_res() const { return dec_val; }
const TTCN_Typedescriptor_t* get_type_descr() const { return &BcdMccMnc_descr_; }
};
tmp_20.set_type(DECODE_MATCH);
{
HEXSTRING_template tmp_22;
tmp_22 = hs_2;
tmp_20.set_decmatch(new Dec_Match_tmp_21(tmp_22));
}
tmp_23 = (!(tmp_20.match(os_3)));
}
if (tmp_23) {
current_location.update_lineno(477);
/* GSM_Types.ttcn, line 477 */
TTCN_Runtime::setverdict(FAIL);
}
}
current_location.update_lineno(478);
/* GSM_Types.ttcn, line 478 */
{
boolean tmp_27;
{
OCTETSTRING_template tmp_24;
class Dec_Match_tmp_25 : public Dec_Match_Interface {
HEXSTRING_template target;
HEXSTRING* dec_val;
public:
Dec_Match_tmp_25(HEXSTRING_template p_target): target(p_target), dec_val(NULL) { }
~Dec_Match_tmp_25() { if (dec_val != NULL) delete dec_val; }
virtual boolean match(TTCN_Buffer& buff)
{
if (dec_val != NULL) delete dec_val;
dec_val = new HEXSTRING;
boolean ret_val;
OCTETSTRING os;
buff.get_string(os);
if (BcdMccMnc_decoder(os, *dec_val, BcdMccMnc_default_coding) != 0) {
TTCN_warning("Decoded content matching failed, because the data could not be decoded.");
ret_val = FALSE;
}
else if (os.lengthof() != 0) {
TTCN_warning("Decoded content matching failed, because the buffer was not empty after decoding. Remaining octets: %d.", os.lengthof());
ret_val = FALSE;
}
else ret_val = target.match(*dec_val);
if (!ret_val) {
delete dec_val;
dec_val = NULL;
}
return ret_val;
}
virtual void log() const
{
TTCN_Logger::log_event_str("hexstring: ");
target.log();
}
void* get_dec_res() const { return dec_val; }
const TTCN_Typedescriptor_t* get_type_descr() const { return &BcdMccMnc_descr_; }
};
tmp_24.set_type(DECODE_MATCH);
{
HEXSTRING_template tmp_26;
tmp_26 = hs_3;
tmp_24.set_decmatch(new Dec_Match_tmp_25(tmp_26));
}
tmp_27 = (!(tmp_24.match(os_4)));
}
if (tmp_27) {
current_location.update_lineno(478);
/* GSM_Types.ttcn, line 478 */
TTCN_Runtime::setverdict(FAIL);
}
}
current_location.update_lineno(480);
/* GSM_Types.ttcn, line 480 */
if ((!(OCTETSTRING_template(os_2).match(enc__BcdMccMnc(hs_1))))) {
current_location.update_lineno(480);
/* GSM_Types.ttcn, line 480 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(481);
/* GSM_Types.ttcn, line 481 */
if ((!(OCTETSTRING_template(os_3).match(enc__BcdMccMnc(hs_2))))) {
current_location.update_lineno(481);
/* GSM_Types.ttcn, line 481 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(482);
/* GSM_Types.ttcn, line 482 */
if ((!(OCTETSTRING_template(os_4).match(enc__BcdMccMnc(hs_3))))) {
current_location.update_lineno(482);
/* GSM_Types.ttcn, line 482 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(484);
/* GSM_Types.ttcn, line 484 */
if ((!(HEXSTRING_template(hs_1).match(f__build__BcdMccMnc(hs_4, hs_5))))) {
current_location.update_lineno(484);
/* GSM_Types.ttcn, line 484 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(485);
/* GSM_Types.ttcn, line 485 */
if ((!(HEXSTRING_template(hs_2).match(f__build__BcdMccMnc(hs_6, hs_7))))) {
current_location.update_lineno(485);
/* GSM_Types.ttcn, line 485 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(486);
/* GSM_Types.ttcn, line 486 */
if ((!(HEXSTRING_template(hs_3).match(f__build__BcdMccMnc(hs_6, hs_8))))) {
current_location.update_lineno(486);
/* GSM_Types.ttcn, line 486 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(488);
/* GSM_Types.ttcn, line 488 */
if ((!(HEXSTRING_template(hs_1).match(f__build__BcdMccMnc__int(262, 42, FALSE))))) {
current_location.update_lineno(488);
/* GSM_Types.ttcn, line 488 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(489);
/* GSM_Types.ttcn, line 489 */
if ((!(HEXSTRING_template(hs_2).match(f__build__BcdMccMnc__int(123, 45, FALSE))))) {
current_location.update_lineno(489);
/* GSM_Types.ttcn, line 489 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(490);
/* GSM_Types.ttcn, line 490 */
if ((!(HEXSTRING_template(hs_3).match(f__build__BcdMccMnc__int(123, 456, TRUE))))) {
current_location.update_lineno(490);
/* GSM_Types.ttcn, line 490 */
TTCN_Runtime::setverdict(FAIL);
}
current_location.update_lineno(492);
/* GSM_Types.ttcn, line 492 */
TTCN_Runtime::setverdict(PASS);
} catch (const TC_Error& tc_error) {
} catch (const TC_End& tc_end) {
TTCN_Logger::log_str(TTCN_FUNCTION, "Test case TC_selftest_BcdMccMnc was stopped.");
}
return TTCN_Runtime::end_testcase();
}

OCTETSTRING f__enc__mcc__mnc(const HEXSTRING& mcc, const HEXSTRING& mnc)
{
TTCN_Location current_location("GSM_Types.ttcn", 495, TTCN_Location::LOCATION_FUNCTION, "f_enc_mcc_mnc");
current_location.update_lineno(496);
/* GSM_Types.ttcn, line 496 */
if ((mnc.lengthof() == 2)) {
current_location.update_lineno(497);
/* GSM_Types.ttcn, line 497 */
return hex2oct((((((const_cast< const HEXSTRING&>(mcc)[1] + const_cast< const HEXSTRING&>(mcc)[0]) + hs_0) + const_cast< const HEXSTRING&>(mcc)[2]) + const_cast< const HEXSTRING&>(mnc)[1]) + const_cast< const HEXSTRING&>(mnc)[0]));
}
else {
current_location.update_lineno(499);
/* GSM_Types.ttcn, line 499 */
return hex2oct((((((const_cast< const HEXSTRING&>(mcc)[1] + const_cast< const HEXSTRING&>(mcc)[0]) + const_cast< const HEXSTRING&>(mnc)[2]) + const_cast< const HEXSTRING&>(mcc)[2]) + const_cast< const HEXSTRING&>(mnc)[1]) + const_cast< const HEXSTRING&>(mnc)[0]));
}
}

void f__dec__mcc__mnc(const OCTETSTRING& mcc__mnc, HEXSTRING& mcc, HEXSTRING& mnc)
{
TTCN_Location current_location("GSM_Types.ttcn", 503, TTCN_Location::LOCATION_FUNCTION, "f_dec_mcc_mnc");
current_location.update_lineno(504);
/* GSM_Types.ttcn, line 504 */
HEXSTRING hs(oct2hex(mcc__mnc));
current_location.update_lineno(505);
/* GSM_Types.ttcn, line 505 */
mcc = ((const_cast< const HEXSTRING&>(hs)[1] + const_cast< const HEXSTRING&>(hs)[0]) + const_cast< const HEXSTRING&>(hs)[3]);
current_location.update_lineno(506);
/* GSM_Types.ttcn, line 506 */
mnc = (const_cast< const HEXSTRING&>(hs)[5] + const_cast< const HEXSTRING&>(hs)[4]);
current_location.update_lineno(507);
/* GSM_Types.ttcn, line 507 */
if ((const_cast< const HEXSTRING&>(hs)[2] != hs_0)) {
current_location.update_lineno(508);
/* GSM_Types.ttcn, line 508 */
{
HEXSTRING tmp_30;
tmp_30 = (mnc + const_cast< const HEXSTRING&>(hs)[2]);
mnc = tmp_30;
}
}
}

void LocationAreaIdentification_mcc__mnc_encoder(const HEXSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(LocationAreaIdentification_mcc__mnc_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LocationAreaIdentification_mcc__mnc_decoder(OCTETSTRING& input_stream, HEXSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `hexstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(LocationAreaIdentification_mcc__mnc_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void LocationAreaIdentification_lac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(LocationAreaIdentification_lac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LocationAreaIdentification_lac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(LocationAreaIdentification_lac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void LocationAreaIdentification_encoder(const LocationAreaIdentification& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.LocationAreaIdentification' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(LocationAreaIdentification_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LocationAreaIdentification_decoder(OCTETSTRING& input_stream, LocationAreaIdentification& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.LocationAreaIdentification' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(LocationAreaIdentification_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

LocationAreaIdentification_template ts__LAI(const HEXSTRING& mcc__mnc, const INTEGER& lac)
{
TTCN_Location current_location("GSM_Types.ttcn", 517, TTCN_Location::LOCATION_TEMPLATE, "ts_LAI");
LocationAreaIdentification_template ret_val;
ret_val.mcc__mnc() = mcc__mnc;
ret_val.lac() = lac;
return ret_val;
}

void RoutingAreaIdentification_lai_encoder(const LocationAreaIdentification& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.LocationAreaIdentification' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoutingAreaIdentification_lai_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoutingAreaIdentification_lai_decoder(OCTETSTRING& input_stream, LocationAreaIdentification& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.LocationAreaIdentification' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoutingAreaIdentification_lai_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RoutingAreaIdentification_rac_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoutingAreaIdentification_rac_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoutingAreaIdentification_rac_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoutingAreaIdentification_rac_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RoutingAreaIdentification_encoder(const RoutingAreaIdentification& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RoutingAreaIdentification' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoutingAreaIdentification_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoutingAreaIdentification_decoder(OCTETSTRING& input_stream, RoutingAreaIdentification& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@GSM_Types.RoutingAreaIdentification' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoutingAreaIdentification_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

RoutingAreaIdentification_template ts__RAI(const LocationAreaIdentification_template& lai, const INTEGER& rac)
{
TTCN_Location current_location("GSM_Types.ttcn", 527, TTCN_Location::LOCATION_TEMPLATE, "ts_RAI");
RoutingAreaIdentification_template ret_val;
ret_val.lai() = lai;
ret_val.rac() = rac;
return ret_val;
}

OCTETSTRING enc__RoutingAreaIdentification(const RoutingAreaIdentification& rai)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_RoutingAreaIdentification(): Encoding @GSM_Types.RoutingAreaIdentification: ");
rai.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
rai.encode(RoutingAreaIdentification_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_RoutingAreaIdentification(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

void CellIdentity_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CellIdentity_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CellIdentity_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CellIdentity_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

INTEGER fn2bn(const INTEGER& fn)
{
TTCN_Location current_location("GSM_Types.ttcn", 539, TTCN_Location::LOCATION_FUNCTION, "fn2bn");
current_location.update_lineno(540);
/* GSM_Types.ttcn, line 540 */
return (mod(fn, 52) / 4);
}

INTEGER f__next__pdtch__block(const INTEGER& fn)
{
INTEGER fn_shadow(fn);
TTCN_Location current_location("GSM_Types.ttcn", 542, TTCN_Location::LOCATION_FUNCTION, "f_next_pdtch_block");
current_location.update_lineno(544);
/* GSM_Types.ttcn, line 544 */
INTEGER bn((fn2bn(fn_shadow) + 1));
current_location.update_lineno(545);
/* GSM_Types.ttcn, line 545 */
{
INTEGER tmp_31;
tmp_31 = (fn_shadow - mod(fn_shadow, 52));
fn_shadow = tmp_31;
}
current_location.update_lineno(546);
/* GSM_Types.ttcn, line 546 */
{
INTEGER tmp_32;
tmp_32 = ((fn_shadow + (bn * 4)) + (bn / 3));
fn_shadow = tmp_32;
}
current_location.update_lineno(547);
/* GSM_Types.ttcn, line 547 */
return mod(fn_shadow, 2715648);
}

INTEGER ptcch__fn2bn(const INTEGER& fn)
{
TTCN_Location current_location("GSM_Types.ttcn", 550, TTCN_Location::LOCATION_FUNCTION, "ptcch_fn2bn");
current_location.update_lineno(551);
/* GSM_Types.ttcn, line 551 */
return (mod(fn, 416) / 104);
}

INTEGER f__next__ptcch__dl__block(const INTEGER& fn)
{
INTEGER fn_shadow(fn);
TTCN_Location current_location("GSM_Types.ttcn", 553, TTCN_Location::LOCATION_FUNCTION, "f_next_ptcch_dl_block");
current_location.update_lineno(555);
/* GSM_Types.ttcn, line 555 */
INTEGER bn((ptcch__fn2bn(fn_shadow) + 1));
current_location.update_lineno(556);
/* GSM_Types.ttcn, line 556 */
{
INTEGER tmp_33;
tmp_33 = (fn_shadow - mod(fn_shadow, 416));
fn_shadow = tmp_33;
}
current_location.update_lineno(557);
/* GSM_Types.ttcn, line 557 */
{
INTEGER tmp_34;
tmp_34 = ((fn_shadow + (bn * 104)) + 12);
fn_shadow = tmp_34;
}
current_location.update_lineno(558);
/* GSM_Types.ttcn, line 558 */
return mod(fn_shadow, 2715648);
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("GSM_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "GSM_Types");
Osmocom__Types::module_object.pre_init_module();
Misc__Helpers::module_object.pre_init_module();
current_location.update_lineno(22);
/* GSM_Types.ttcn, line 22 */
const_GsmMaxFrameNumber = 2715648;
module_object.add_function("f_gprs_blocksize", (genericfunc_t)&f__gprs__blocksize, NULL);
current_location.update_lineno(98);
/* GSM_Types.ttcn, line 98 */
const_TLLI__UNUSED = os_0;
module_object.add_function("f_gen_tlli", (genericfunc_t)&f__gen__tlli, NULL);
module_object.add_function("f_hex_is_odd_length", (genericfunc_t)&f__hex__is__odd__length, NULL);
module_object.add_function("enc_CBCH_Block", (genericfunc_t)&enc__CBCH__Block, NULL);
module_object.add_function("dec_CBCH_Block", (genericfunc_t)&dec__CBCH__Block, NULL);
module_object.add_function("dbm2rxlev", (genericfunc_t)&dbm2rxlev, NULL);
module_object.add_function("rxlev2dbm", (genericfunc_t)&rxlev2dbm, NULL);
module_object.add_function("ber2rxqual", (genericfunc_t)&ber2rxqual, NULL);
module_object.add_function("rxqual2ber", (genericfunc_t)&rxqual2ber, NULL);
current_location.update_lineno(404);
/* GSM_Types.ttcn, line 404 */
const_GSM__FRAME__DURATION = 4.61538461538461e-3;
current_location.update_lineno(405);
/* GSM_Types.ttcn, line 405 */
const_GSM51__MFRAME__DURATION = 2.35384615384615e-1;
current_location.update_lineno(406);
/* GSM_Types.ttcn, line 406 */
const_GSM51__MFRAMES__PER__SEC = 4.2483660130719;
module_object.add_function("f_ccch_blocks_per_mframe", (genericfunc_t)&f__ccch__blocks__per__mframe, NULL);
module_object.add_function("f_pch_block_rate_est", (genericfunc_t)&f__pch__block__rate__est, NULL);
module_object.add_function("f_agch_block_rate_est", (genericfunc_t)&f__agch__block__rate__est, NULL);
module_object.add_function("f_gsm_compute_tc", (genericfunc_t)&f__gsm__compute__tc, NULL);
module_object.add_function("enc_BcdMccMnc", (genericfunc_t)&enc__BcdMccMnc, NULL);
module_object.add_function("dec_BcdMccMnc", (genericfunc_t)&dec__BcdMccMnc, NULL);
module_object.add_function("f_build_BcdMccMnc", (genericfunc_t)&f__build__BcdMccMnc, NULL);
module_object.add_function("f_build_BcdMccMnc_int", (genericfunc_t)&f__build__BcdMccMnc__int, NULL);
module_object.add_testcase_nonpard("TC_selftest_BcdMccMnc", testcase_TC__selftest__BcdMccMnc);
module_object.add_function("f_enc_mcc_mnc", (genericfunc_t)&f__enc__mcc__mnc, NULL);
module_object.add_function("f_dec_mcc_mnc", (genericfunc_t)&f__dec__mcc__mnc, NULL);
module_object.add_function("enc_RoutingAreaIdentification", (genericfunc_t)&enc__RoutingAreaIdentification, NULL);
module_object.add_function("fn2bn", (genericfunc_t)&fn2bn, NULL);
module_object.add_function("f_next_pdtch_block", (genericfunc_t)&f__next__pdtch__block, NULL);
module_object.add_function("ptcch_fn2bn", (genericfunc_t)&ptcch__fn2bn, NULL);
module_object.add_function("f_next_ptcch_dl_block", (genericfunc_t)&f__next__ptcch__dl__block, NULL);
}

void post_init_module()
{
TTCN_Location current_location("GSM_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "GSM_Types");
Osmocom__Types::module_object.post_init_module();
Misc__Helpers::module_object.post_init_module();
current_location.update_lineno(48);
/* GSM_Types.ttcn, line 48 */
template_ts__GsmBandArfcn_pcs_defval = FALSE;
current_location.update_lineno(49);
/* GSM_Types.ttcn, line 49 */
template_ts__GsmBandArfcn_uplink_defval = FALSE;
current_location.update_lineno(57);
/* GSM_Types.ttcn, line 57 */
template_tr__GsmBandArfcn_pcs_defval = ANY_VALUE;
current_location.update_lineno(58);
/* GSM_Types.ttcn, line 58 */
template_tr__GsmBandArfcn_uplink_defval = ANY_VALUE;
current_location.update_lineno(257);
/* GSM_Types.ttcn, line 257 */
template_tr__RslLinkId.c() = ANY_VALUE;
template_tr__RslLinkId.na() = ANY_VALUE;
template_tr__RslLinkId.prio() = ANY_VALUE;
template_tr__RslLinkId.sapi() = ANY_VALUE;
current_location.update_lineno(325);
/* GSM_Types.ttcn, line 325 */
template_tr__CBCH__BlockType_seq__nr_defval = ANY_VALUE;
current_location.update_lineno(325);
/* GSM_Types.ttcn, line 325 */
template_tr__CBCH__BlockType_last__block_defval = ANY_VALUE;
current_location.update_lineno(341);
/* GSM_Types.ttcn, line 341 */
template_tr__CBCH__Block_seq__nr_defval = ANY_VALUE;
current_location.update_lineno(341);
/* GSM_Types.ttcn, line 341 */
template_tr__CBCH__Block_last__block_defval = ANY_VALUE;
current_location.update_lineno(341);
/* GSM_Types.ttcn, line 341 */
template_tr__CBCH__Block_payload_defval = ANY_VALUE;
}


} /* end of namespace */
