// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "IPL4asp_Types.hh"

namespace IPL4asp__Types {

/* Member functions of C++ classes */


const Option OptionList::UNBOUND_ELEM;
OptionList::OptionList()
{
val_ptr = NULL;
}

OptionList::OptionList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

OptionList::OptionList(const OptionList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @IPL4asp_Types.OptionList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

OptionList::~OptionList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void OptionList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

OptionList& OptionList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

OptionList& OptionList::operator=(const OptionList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @IPL4asp_Types.OptionList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean OptionList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @IPL4asp_Types.OptionList.");
return val_ptr->n_elements == 0 ;
}

boolean OptionList::operator==(const OptionList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @IPL4asp_Types.OptionList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @IPL4asp_Types.OptionList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

Option& OptionList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @IPL4asp_Types.OptionList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (Option**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Option(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new Option;
}
return *val_ptr->value_elements[index_value];
}

Option& OptionList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @IPL4asp_Types.OptionList.");
return (*this)[(int)index_value];
}

const Option& OptionList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @IPL4asp_Types.OptionList.");
if (index_value < 0) TTCN_error("Accessing an element of type @IPL4asp_Types.OptionList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @IPL4asp_Types.OptionList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const Option& OptionList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @IPL4asp_Types.OptionList.");
return (*this)[(int)index_value];
}

OptionList OptionList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

OptionList OptionList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

OptionList OptionList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

OptionList OptionList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @IPL4asp_Types.OptionList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
OptionList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new Option(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

OptionList OptionList::operator+(const OptionList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @IPL4asp_Types.OptionList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
OptionList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Option(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new Option(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

OptionList OptionList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @IPL4asp_Types.OptionList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@IPL4asp_Types.OptionList","element");
OptionList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new Option(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

OptionList OptionList::replace(int index, int len, const OptionList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @IPL4asp_Types.OptionList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @IPL4asp_Types.OptionList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@IPL4asp_Types.OptionList","element");
OptionList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Option(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new Option(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new Option(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

OptionList OptionList::replace(int index, int len, const OptionList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void OptionList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @IPL4asp_Types.OptionList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (Option**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Option(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (Option**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @IPL4asp_Types.OptionList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (Option**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean OptionList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int OptionList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @IPL4asp_Types.OptionList.");
return val_ptr->n_elements;
}

int OptionList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @IPL4asp_Types.OptionList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void OptionList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void OptionList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void OptionList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@IPL4asp_Types.OptionList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@IPL4asp_Types.OptionList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void OptionList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @IPL4asp_Types.OptionList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void OptionList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @IPL4asp_Types.OptionList.");
val_ptr->value_elements = (Option**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new Option;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void OptionList_template::copy_value(const OptionList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @IPL4asp_Types.OptionList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (Option_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new Option_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new Option_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void OptionList_template::copy_template(const OptionList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (Option_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new Option_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new Option_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new OptionList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new OptionList_template(*other_value.implication_.precondition);
implication_.implied_template = new OptionList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @IPL4asp_Types.OptionList.");
break;
}
set_selection(other_value);
}

boolean OptionList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const OptionList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const OptionList*)value_ptr)[value_index], legacy);
else return ((const OptionList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

OptionList_template::OptionList_template()
{
}

OptionList_template::OptionList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

OptionList_template::OptionList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

OptionList_template::OptionList_template(const OptionList& other_value)
{
copy_value(other_value);
}

OptionList_template::OptionList_template(const OPTIONAL<OptionList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const OptionList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @IPL4asp_Types.OptionList from an unbound optional field.");
}
}

OptionList_template::OptionList_template(OptionList_template* p_precondition, OptionList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

OptionList_template::OptionList_template(Dynamic_Match_Interface<OptionList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<OptionList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

OptionList_template::OptionList_template(const OptionList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

OptionList_template::~OptionList_template()
{
clean_up();
}

void OptionList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

OptionList_template& OptionList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

OptionList_template& OptionList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

OptionList_template& OptionList_template::operator=(const OptionList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

OptionList_template& OptionList_template::operator=(const OPTIONAL<OptionList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const OptionList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @IPL4asp_Types.OptionList.");
}
return *this;
}

OptionList_template& OptionList_template::operator=(const OptionList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

Option_template& OptionList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @IPL4asp_Types.OptionList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @IPL4asp_Types.OptionList.");
    break;
}
return *single_value.value_elements[index_value];
}

Option_template& OptionList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @IPL4asp_Types.OptionList.");
return (*this)[(int)index_value];
}

const Option_template& OptionList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @IPL4asp_Types.OptionList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @IPL4asp_Types.OptionList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @IPL4asp_Types.OptionList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const Option_template& OptionList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @IPL4asp_Types.OptionList.");
return (*this)[(int)index_value];
}

void OptionList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @IPL4asp_Types.OptionList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (Option_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Option_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Option_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (Option_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int OptionList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int OptionList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @IPL4asp_Types.OptionList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @IPL4asp_Types.OptionList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @IPL4asp_Types.OptionList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @IPL4asp_Types.OptionList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @IPL4asp_Types.OptionList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @IPL4asp_Types.OptionList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @IPL4asp_Types.OptionList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @IPL4asp_Types.OptionList");
}

boolean OptionList_template::match(const OptionList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @IPL4asp_Types.OptionList.");
}
return FALSE;
}

boolean OptionList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

OptionList OptionList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @IPL4asp_Types.OptionList.");
OptionList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

OptionList OptionList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

OptionList OptionList_template::replace(int index, int len, const OptionList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

OptionList OptionList_template::replace(int index, int len, const OptionList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void OptionList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new OptionList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @IPL4asp_Types.OptionList.");
}
set_selection(template_type);
}

OptionList_template& OptionList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @IPL4asp_Types.OptionList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @IPL4asp_Types.OptionList.");
return value_list.list_value[list_index];
}

void OptionList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void OptionList_template::log_match(const OptionList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void OptionList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @IPL4asp_Types.OptionList.");
}
}

void OptionList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @IPL4asp_Types.OptionList.");
single_value.value_elements = (Option_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new Option_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new OptionList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @IPL4asp_Types.OptionList.");
}
}

boolean OptionList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean OptionList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void OptionList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void OptionList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    OptionList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    OptionList_template* precondition = new OptionList_template;
    precondition->set_param(*param.get_elem(0));
    OptionList_template* implied_template = new OptionList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = OptionList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@IPL4asp_Types.OptionList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void OptionList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.OptionList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.OptionList");
}

boolean OptionList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
ASP__Send::ASP__Send()
{
}

ASP__Send::ASP__Send(const INTEGER& par_connId,
    const OPTIONAL< Socket__API__Definitions::ProtoTuple >& par_proto,
    const OCTETSTRING& par_msg)
  :   field_connId(par_connId),
  field_proto(par_proto),
  field_msg(par_msg)
{
}

ASP__Send::ASP__Send(const ASP__Send& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @IPL4asp_Types.ASP_Send.");
if (other_value.connId().is_bound()) field_connId = other_value.connId();
else field_connId.clean_up();
if (other_value.proto().is_bound()) field_proto = other_value.proto();
else field_proto.clean_up();
if (other_value.msg().is_bound()) field_msg = other_value.msg();
else field_msg.clean_up();
}

void ASP__Send::clean_up()
{
field_connId.clean_up();
field_proto.clean_up();
field_msg.clean_up();
}

const TTCN_Typedescriptor_t* ASP__Send::get_descriptor() const { return &ASP__Send_descr_; }
ASP__Send& ASP__Send::operator=(const ASP__Send& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @IPL4asp_Types.ASP_Send.");
  if (other_value.connId().is_bound()) field_connId = other_value.connId();
  else field_connId.clean_up();
  if (other_value.proto().is_bound()) field_proto = other_value.proto();
  else field_proto.clean_up();
  if (other_value.msg().is_bound()) field_msg = other_value.msg();
  else field_msg.clean_up();
}
return *this;
}

boolean ASP__Send::operator==(const ASP__Send& other_value) const
{
return field_connId==other_value.field_connId
  && field_proto==other_value.field_proto
  && field_msg==other_value.field_msg;
}

boolean ASP__Send::is_bound() const
{
return (field_connId.is_bound())
  || (OPTIONAL_OMIT == field_proto.get_selection() || field_proto.is_bound())
  || (field_msg.is_bound());
}
boolean ASP__Send::is_value() const
{
return field_connId.is_value()
  && (OPTIONAL_OMIT == field_proto.get_selection() || field_proto.is_value())
  && field_msg.is_value();
}
int ASP__Send::size_of() const
{
  int ret_val = 2;
  if (field_proto.ispresent()) ret_val++;
  return ret_val;
}

void ASP__Send::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ connId := ");
field_connId.log();
TTCN_Logger::log_event_str(", proto := ");
field_proto.log();
TTCN_Logger::log_event_str(", msg := ");
field_msg.log();
TTCN_Logger::log_event_str(" }");
}

void ASP__Send::set_implicit_omit()
{
if (connId().is_bound()) connId().set_implicit_omit();
if (!proto().is_bound()) proto() = OMIT_VALUE;
else proto().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void ASP__Send::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @IPL4asp_Types.ASP_Send has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) proto().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "proto")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          proto().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_Send: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@IPL4asp_Types.ASP_Send");
  }
}

void ASP__Send::encode_text(Text_Buf& text_buf) const
{
field_connId.encode_text(text_buf);
field_proto.encode_text(text_buf);
field_msg.encode_text(text_buf);
}

void ASP__Send::decode_text(Text_Buf& text_buf)
{
field_connId.decode_text(text_buf);
field_proto.decode_text(text_buf);
field_msg.decode_text(text_buf);
}

struct ASP__Send_template::single_value_struct {
INTEGER_template field_connId;
Socket__API__Definitions::ProtoTuple_template field_proto;
OCTETSTRING_template field_msg;
};

void ASP__Send_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_connId = ANY_VALUE;
single_value->field_proto = ANY_OR_OMIT;
single_value->field_msg = ANY_VALUE;
}
}
}

void ASP__Send_template::copy_value(const ASP__Send& other_value)
{
single_value = new single_value_struct;
if (other_value.connId().is_bound()) {
  single_value->field_connId = other_value.connId();
} else {
  single_value->field_connId.clean_up();
}
if (other_value.proto().is_bound()) {
  if (other_value.proto().ispresent()) single_value->field_proto = other_value.proto()();
  else single_value->field_proto = OMIT_VALUE;
} else {
  single_value->field_proto.clean_up();
}
if (other_value.msg().is_bound()) {
  single_value->field_msg = other_value.msg();
} else {
  single_value->field_msg.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ASP__Send_template::copy_template(const ASP__Send_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.connId().get_selection()) {
single_value->field_connId = other_value.connId();
} else {
single_value->field_connId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.proto().get_selection()) {
single_value->field_proto = other_value.proto();
} else {
single_value->field_proto.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msg().get_selection()) {
single_value->field_msg = other_value.msg();
} else {
single_value->field_msg.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ASP__Send_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ASP__Send_template(*other_value.implication_.precondition);
implication_.implied_template = new ASP__Send_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @IPL4asp_Types.ASP_Send.");
break;
}
set_selection(other_value);
}

ASP__Send_template::ASP__Send_template()
{
}

ASP__Send_template::ASP__Send_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ASP__Send_template::ASP__Send_template(const ASP__Send& other_value)
{
copy_value(other_value);
}

ASP__Send_template::ASP__Send_template(const OPTIONAL<ASP__Send>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__Send&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @IPL4asp_Types.ASP_Send from an unbound optional field.");
}
}

ASP__Send_template::ASP__Send_template(ASP__Send_template* p_precondition, ASP__Send_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ASP__Send_template::ASP__Send_template(Dynamic_Match_Interface<ASP__Send>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ASP__Send>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ASP__Send_template::ASP__Send_template(const ASP__Send_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ASP__Send_template::~ASP__Send_template()
{
clean_up();
}

ASP__Send_template& ASP__Send_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ASP__Send_template& ASP__Send_template::operator=(const ASP__Send& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ASP__Send_template& ASP__Send_template::operator=(const OPTIONAL<ASP__Send>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__Send&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @IPL4asp_Types.ASP_Send.");
}
return *this;
}

ASP__Send_template& ASP__Send_template::operator=(const ASP__Send_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ASP__Send_template::match(const ASP__Send& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.connId().is_bound()) return FALSE;
if(!single_value->field_connId.match(other_value.connId(), legacy))return FALSE;
if(!other_value.proto().is_bound()) return FALSE;
if((other_value.proto().ispresent() ? !single_value->field_proto.match((const Socket__API__Definitions::ProtoTuple&)other_value.proto(), legacy) : !single_value->field_proto.match_omit(legacy)))return FALSE;
if(!other_value.msg().is_bound()) return FALSE;
if(!single_value->field_msg.match(other_value.msg(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @IPL4asp_Types.ASP_Send.");
}
return FALSE;
}

boolean ASP__Send_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_connId.is_bound()
 || (single_value->field_proto.is_omit() || single_value->field_proto.is_bound())
 || single_value->field_msg.is_bound();
}

boolean ASP__Send_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_connId.is_value()
 && (single_value->field_proto.is_omit() || single_value->field_proto.is_value())
 && single_value->field_msg.is_value();
}

void ASP__Send_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ASP__Send ASP__Send_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @IPL4asp_Types.ASP_Send.");
ASP__Send ret_val;
if (single_value->field_connId.is_bound()) {
ret_val.connId() = single_value->field_connId.valueof();
}
if (single_value->field_proto.is_omit()) ret_val.proto() = OMIT_VALUE;
else if (single_value->field_proto.is_bound()) {
ret_val.proto() = single_value->field_proto.valueof();
}
if (single_value->field_msg.is_bound()) {
ret_val.msg() = single_value->field_msg.valueof();
}
return ret_val;
}

void ASP__Send_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @IPL4asp_Types.ASP_Send.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ASP__Send_template[list_length];
}

ASP__Send_template& ASP__Send_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @IPL4asp_Types.ASP_Send.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @IPL4asp_Types.ASP_Send.");
return value_list.list_value[list_index];
}

INTEGER_template& ASP__Send_template::connId()
{
set_specific();
return single_value->field_connId;
}

const INTEGER_template& ASP__Send_template::connId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connId of a non-specific template of type @IPL4asp_Types.ASP_Send.");
return single_value->field_connId;
}

Socket__API__Definitions::ProtoTuple_template& ASP__Send_template::proto()
{
set_specific();
return single_value->field_proto;
}

const Socket__API__Definitions::ProtoTuple_template& ASP__Send_template::proto() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field proto of a non-specific template of type @IPL4asp_Types.ASP_Send.");
return single_value->field_proto;
}

OCTETSTRING_template& ASP__Send_template::msg()
{
set_specific();
return single_value->field_msg;
}

const OCTETSTRING_template& ASP__Send_template::msg() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msg of a non-specific template of type @IPL4asp_Types.ASP_Send.");
return single_value->field_msg;
}

int ASP__Send_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_proto.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_Send containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @IPL4asp_Types.ASP_Send.");
  }
  return 0;
}

void ASP__Send_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log();
TTCN_Logger::log_event_str(", proto := ");
single_value->field_proto.log();
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ASP__Send_template::log_match(const ASP__Send& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_connId.match(match_value.connId(), legacy)){
TTCN_Logger::log_logmatch_info(".connId");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.proto().ispresent()){
if(!single_value->field_proto.match(match_value.proto(), legacy)){
TTCN_Logger::log_logmatch_info(".proto");
single_value->field_proto.log_match(match_value.proto(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_proto.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".proto := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_proto.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_msg.match(match_value.msg(), legacy)){
TTCN_Logger::log_logmatch_info(".msg");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::log_event_str(", proto := ");
if (match_value.proto().ispresent()) {
single_value->field_proto.log_match(match_value.proto(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_proto.log();
if (single_value->field_proto.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ASP__Send_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (connId().is_bound()) connId().set_implicit_omit();
if (!proto().is_bound()) proto() = OMIT_VALUE;
else proto().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void ASP__Send_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_connId.encode_text(text_buf);
single_value->field_proto.encode_text(text_buf);
single_value->field_msg.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @IPL4asp_Types.ASP_Send.");
}
}

void ASP__Send_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_connId.decode_text(text_buf);
single_value->field_proto.decode_text(text_buf);
single_value->field_msg.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ASP__Send_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @IPL4asp_Types.ASP_Send.");
}
}

void ASP__Send_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ASP__Send_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @IPL4asp_Types.ASP_Send has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) proto().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "proto")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          proto().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_Send: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ASP__Send_template* precondition = new ASP__Send_template;
    precondition->set_param(*param.get_elem(0));
    ASP__Send_template* implied_template = new ASP__Send_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ASP__Send_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@IPL4asp_Types.ASP_Send");
  }
  is_ifpresent = param.get_ifpresent();
}

void ASP__Send_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_connId.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_Send");
single_value->field_proto.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_Send");
single_value->field_msg.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_Send");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.ASP_Send");
}

boolean ASP__Send_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ASP__Send_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ASP__SendTo::ASP__SendTo()
{
}

ASP__SendTo::ASP__SendTo(const INTEGER& par_connId,
    const CHARSTRING& par_remName,
    const INTEGER& par_remPort,
    const OPTIONAL< Socket__API__Definitions::ProtoTuple >& par_proto,
    const OCTETSTRING& par_msg)
  :   field_connId(par_connId),
  field_remName(par_remName),
  field_remPort(par_remPort),
  field_proto(par_proto),
  field_msg(par_msg)
{
}

ASP__SendTo::ASP__SendTo(const ASP__SendTo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @IPL4asp_Types.ASP_SendTo.");
if (other_value.connId().is_bound()) field_connId = other_value.connId();
else field_connId.clean_up();
if (other_value.remName().is_bound()) field_remName = other_value.remName();
else field_remName.clean_up();
if (other_value.remPort().is_bound()) field_remPort = other_value.remPort();
else field_remPort.clean_up();
if (other_value.proto().is_bound()) field_proto = other_value.proto();
else field_proto.clean_up();
if (other_value.msg().is_bound()) field_msg = other_value.msg();
else field_msg.clean_up();
}

void ASP__SendTo::clean_up()
{
field_connId.clean_up();
field_remName.clean_up();
field_remPort.clean_up();
field_proto.clean_up();
field_msg.clean_up();
}

const TTCN_Typedescriptor_t* ASP__SendTo::get_descriptor() const { return &ASP__SendTo_descr_; }
ASP__SendTo& ASP__SendTo::operator=(const ASP__SendTo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @IPL4asp_Types.ASP_SendTo.");
  if (other_value.connId().is_bound()) field_connId = other_value.connId();
  else field_connId.clean_up();
  if (other_value.remName().is_bound()) field_remName = other_value.remName();
  else field_remName.clean_up();
  if (other_value.remPort().is_bound()) field_remPort = other_value.remPort();
  else field_remPort.clean_up();
  if (other_value.proto().is_bound()) field_proto = other_value.proto();
  else field_proto.clean_up();
  if (other_value.msg().is_bound()) field_msg = other_value.msg();
  else field_msg.clean_up();
}
return *this;
}

boolean ASP__SendTo::operator==(const ASP__SendTo& other_value) const
{
return field_connId==other_value.field_connId
  && field_remName==other_value.field_remName
  && field_remPort==other_value.field_remPort
  && field_proto==other_value.field_proto
  && field_msg==other_value.field_msg;
}

boolean ASP__SendTo::is_bound() const
{
return (field_connId.is_bound())
  || (field_remName.is_bound())
  || (field_remPort.is_bound())
  || (OPTIONAL_OMIT == field_proto.get_selection() || field_proto.is_bound())
  || (field_msg.is_bound());
}
boolean ASP__SendTo::is_value() const
{
return field_connId.is_value()
  && field_remName.is_value()
  && field_remPort.is_value()
  && (OPTIONAL_OMIT == field_proto.get_selection() || field_proto.is_value())
  && field_msg.is_value();
}
int ASP__SendTo::size_of() const
{
  int ret_val = 4;
  if (field_proto.ispresent()) ret_val++;
  return ret_val;
}

void ASP__SendTo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ connId := ");
field_connId.log();
TTCN_Logger::log_event_str(", remName := ");
field_remName.log();
TTCN_Logger::log_event_str(", remPort := ");
field_remPort.log();
TTCN_Logger::log_event_str(", proto := ");
field_proto.log();
TTCN_Logger::log_event_str(", msg := ");
field_msg.log();
TTCN_Logger::log_event_str(" }");
}

void ASP__SendTo::set_implicit_omit()
{
if (connId().is_bound()) connId().set_implicit_omit();
if (remName().is_bound()) remName().set_implicit_omit();
if (remPort().is_bound()) remPort().set_implicit_omit();
if (!proto().is_bound()) proto() = OMIT_VALUE;
else proto().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void ASP__SendTo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @IPL4asp_Types.ASP_SendTo has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) remName().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) remPort().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) proto().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remPort")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remPort().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "proto")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          proto().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_SendTo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@IPL4asp_Types.ASP_SendTo");
  }
}

void ASP__SendTo::encode_text(Text_Buf& text_buf) const
{
field_connId.encode_text(text_buf);
field_remName.encode_text(text_buf);
field_remPort.encode_text(text_buf);
field_proto.encode_text(text_buf);
field_msg.encode_text(text_buf);
}

void ASP__SendTo::decode_text(Text_Buf& text_buf)
{
field_connId.decode_text(text_buf);
field_remName.decode_text(text_buf);
field_remPort.decode_text(text_buf);
field_proto.decode_text(text_buf);
field_msg.decode_text(text_buf);
}

struct ASP__SendTo_template::single_value_struct {
INTEGER_template field_connId;
CHARSTRING_template field_remName;
INTEGER_template field_remPort;
Socket__API__Definitions::ProtoTuple_template field_proto;
OCTETSTRING_template field_msg;
};

void ASP__SendTo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_connId = ANY_VALUE;
single_value->field_remName = ANY_VALUE;
single_value->field_remPort = ANY_VALUE;
single_value->field_proto = ANY_OR_OMIT;
single_value->field_msg = ANY_VALUE;
}
}
}

void ASP__SendTo_template::copy_value(const ASP__SendTo& other_value)
{
single_value = new single_value_struct;
if (other_value.connId().is_bound()) {
  single_value->field_connId = other_value.connId();
} else {
  single_value->field_connId.clean_up();
}
if (other_value.remName().is_bound()) {
  single_value->field_remName = other_value.remName();
} else {
  single_value->field_remName.clean_up();
}
if (other_value.remPort().is_bound()) {
  single_value->field_remPort = other_value.remPort();
} else {
  single_value->field_remPort.clean_up();
}
if (other_value.proto().is_bound()) {
  if (other_value.proto().ispresent()) single_value->field_proto = other_value.proto()();
  else single_value->field_proto = OMIT_VALUE;
} else {
  single_value->field_proto.clean_up();
}
if (other_value.msg().is_bound()) {
  single_value->field_msg = other_value.msg();
} else {
  single_value->field_msg.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ASP__SendTo_template::copy_template(const ASP__SendTo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.connId().get_selection()) {
single_value->field_connId = other_value.connId();
} else {
single_value->field_connId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remName().get_selection()) {
single_value->field_remName = other_value.remName();
} else {
single_value->field_remName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remPort().get_selection()) {
single_value->field_remPort = other_value.remPort();
} else {
single_value->field_remPort.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.proto().get_selection()) {
single_value->field_proto = other_value.proto();
} else {
single_value->field_proto.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msg().get_selection()) {
single_value->field_msg = other_value.msg();
} else {
single_value->field_msg.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ASP__SendTo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ASP__SendTo_template(*other_value.implication_.precondition);
implication_.implied_template = new ASP__SendTo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @IPL4asp_Types.ASP_SendTo.");
break;
}
set_selection(other_value);
}

ASP__SendTo_template::ASP__SendTo_template()
{
}

ASP__SendTo_template::ASP__SendTo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ASP__SendTo_template::ASP__SendTo_template(const ASP__SendTo& other_value)
{
copy_value(other_value);
}

ASP__SendTo_template::ASP__SendTo_template(const OPTIONAL<ASP__SendTo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__SendTo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @IPL4asp_Types.ASP_SendTo from an unbound optional field.");
}
}

ASP__SendTo_template::ASP__SendTo_template(ASP__SendTo_template* p_precondition, ASP__SendTo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ASP__SendTo_template::ASP__SendTo_template(Dynamic_Match_Interface<ASP__SendTo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ASP__SendTo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ASP__SendTo_template::ASP__SendTo_template(const ASP__SendTo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ASP__SendTo_template::~ASP__SendTo_template()
{
clean_up();
}

ASP__SendTo_template& ASP__SendTo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ASP__SendTo_template& ASP__SendTo_template::operator=(const ASP__SendTo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ASP__SendTo_template& ASP__SendTo_template::operator=(const OPTIONAL<ASP__SendTo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__SendTo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @IPL4asp_Types.ASP_SendTo.");
}
return *this;
}

ASP__SendTo_template& ASP__SendTo_template::operator=(const ASP__SendTo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ASP__SendTo_template::match(const ASP__SendTo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.connId().is_bound()) return FALSE;
if(!single_value->field_connId.match(other_value.connId(), legacy))return FALSE;
if(!other_value.remName().is_bound()) return FALSE;
if(!single_value->field_remName.match(other_value.remName(), legacy))return FALSE;
if(!other_value.remPort().is_bound()) return FALSE;
if(!single_value->field_remPort.match(other_value.remPort(), legacy))return FALSE;
if(!other_value.proto().is_bound()) return FALSE;
if((other_value.proto().ispresent() ? !single_value->field_proto.match((const Socket__API__Definitions::ProtoTuple&)other_value.proto(), legacy) : !single_value->field_proto.match_omit(legacy)))return FALSE;
if(!other_value.msg().is_bound()) return FALSE;
if(!single_value->field_msg.match(other_value.msg(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @IPL4asp_Types.ASP_SendTo.");
}
return FALSE;
}

boolean ASP__SendTo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_connId.is_bound()
 || single_value->field_remName.is_bound()
 || single_value->field_remPort.is_bound()
 || (single_value->field_proto.is_omit() || single_value->field_proto.is_bound())
 || single_value->field_msg.is_bound();
}

boolean ASP__SendTo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_connId.is_value()
 && single_value->field_remName.is_value()
 && single_value->field_remPort.is_value()
 && (single_value->field_proto.is_omit() || single_value->field_proto.is_value())
 && single_value->field_msg.is_value();
}

void ASP__SendTo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ASP__SendTo ASP__SendTo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @IPL4asp_Types.ASP_SendTo.");
ASP__SendTo ret_val;
if (single_value->field_connId.is_bound()) {
ret_val.connId() = single_value->field_connId.valueof();
}
if (single_value->field_remName.is_bound()) {
ret_val.remName() = single_value->field_remName.valueof();
}
if (single_value->field_remPort.is_bound()) {
ret_val.remPort() = single_value->field_remPort.valueof();
}
if (single_value->field_proto.is_omit()) ret_val.proto() = OMIT_VALUE;
else if (single_value->field_proto.is_bound()) {
ret_val.proto() = single_value->field_proto.valueof();
}
if (single_value->field_msg.is_bound()) {
ret_val.msg() = single_value->field_msg.valueof();
}
return ret_val;
}

void ASP__SendTo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @IPL4asp_Types.ASP_SendTo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ASP__SendTo_template[list_length];
}

ASP__SendTo_template& ASP__SendTo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @IPL4asp_Types.ASP_SendTo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @IPL4asp_Types.ASP_SendTo.");
return value_list.list_value[list_index];
}

INTEGER_template& ASP__SendTo_template::connId()
{
set_specific();
return single_value->field_connId;
}

const INTEGER_template& ASP__SendTo_template::connId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connId of a non-specific template of type @IPL4asp_Types.ASP_SendTo.");
return single_value->field_connId;
}

CHARSTRING_template& ASP__SendTo_template::remName()
{
set_specific();
return single_value->field_remName;
}

const CHARSTRING_template& ASP__SendTo_template::remName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remName of a non-specific template of type @IPL4asp_Types.ASP_SendTo.");
return single_value->field_remName;
}

INTEGER_template& ASP__SendTo_template::remPort()
{
set_specific();
return single_value->field_remPort;
}

const INTEGER_template& ASP__SendTo_template::remPort() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remPort of a non-specific template of type @IPL4asp_Types.ASP_SendTo.");
return single_value->field_remPort;
}

Socket__API__Definitions::ProtoTuple_template& ASP__SendTo_template::proto()
{
set_specific();
return single_value->field_proto;
}

const Socket__API__Definitions::ProtoTuple_template& ASP__SendTo_template::proto() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field proto of a non-specific template of type @IPL4asp_Types.ASP_SendTo.");
return single_value->field_proto;
}

OCTETSTRING_template& ASP__SendTo_template::msg()
{
set_specific();
return single_value->field_msg;
}

const OCTETSTRING_template& ASP__SendTo_template::msg() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msg of a non-specific template of type @IPL4asp_Types.ASP_SendTo.");
return single_value->field_msg;
}

int ASP__SendTo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_proto.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_SendTo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @IPL4asp_Types.ASP_SendTo.");
  }
  return 0;
}

void ASP__SendTo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log();
TTCN_Logger::log_event_str(", remName := ");
single_value->field_remName.log();
TTCN_Logger::log_event_str(", remPort := ");
single_value->field_remPort.log();
TTCN_Logger::log_event_str(", proto := ");
single_value->field_proto.log();
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ASP__SendTo_template::log_match(const ASP__SendTo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_connId.match(match_value.connId(), legacy)){
TTCN_Logger::log_logmatch_info(".connId");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remName.match(match_value.remName(), legacy)){
TTCN_Logger::log_logmatch_info(".remName");
single_value->field_remName.log_match(match_value.remName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remPort.match(match_value.remPort(), legacy)){
TTCN_Logger::log_logmatch_info(".remPort");
single_value->field_remPort.log_match(match_value.remPort(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.proto().ispresent()){
if(!single_value->field_proto.match(match_value.proto(), legacy)){
TTCN_Logger::log_logmatch_info(".proto");
single_value->field_proto.log_match(match_value.proto(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_proto.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".proto := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_proto.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_msg.match(match_value.msg(), legacy)){
TTCN_Logger::log_logmatch_info(".msg");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::log_event_str(", remName := ");
single_value->field_remName.log_match(match_value.remName(), legacy);
TTCN_Logger::log_event_str(", remPort := ");
single_value->field_remPort.log_match(match_value.remPort(), legacy);
TTCN_Logger::log_event_str(", proto := ");
if (match_value.proto().ispresent()) {
single_value->field_proto.log_match(match_value.proto(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_proto.log();
if (single_value->field_proto.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ASP__SendTo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (connId().is_bound()) connId().set_implicit_omit();
if (remName().is_bound()) remName().set_implicit_omit();
if (remPort().is_bound()) remPort().set_implicit_omit();
if (!proto().is_bound()) proto() = OMIT_VALUE;
else proto().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void ASP__SendTo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_connId.encode_text(text_buf);
single_value->field_remName.encode_text(text_buf);
single_value->field_remPort.encode_text(text_buf);
single_value->field_proto.encode_text(text_buf);
single_value->field_msg.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @IPL4asp_Types.ASP_SendTo.");
}
}

void ASP__SendTo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_connId.decode_text(text_buf);
single_value->field_remName.decode_text(text_buf);
single_value->field_remPort.decode_text(text_buf);
single_value->field_proto.decode_text(text_buf);
single_value->field_msg.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ASP__SendTo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @IPL4asp_Types.ASP_SendTo.");
}
}

void ASP__SendTo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ASP__SendTo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @IPL4asp_Types.ASP_SendTo has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) remName().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) remPort().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) proto().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remPort")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remPort().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "proto")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          proto().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_SendTo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ASP__SendTo_template* precondition = new ASP__SendTo_template;
    precondition->set_param(*param.get_elem(0));
    ASP__SendTo_template* implied_template = new ASP__SendTo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ASP__SendTo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@IPL4asp_Types.ASP_SendTo");
  }
  is_ifpresent = param.get_ifpresent();
}

void ASP__SendTo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_connId.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_SendTo");
single_value->field_remName.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_SendTo");
single_value->field_remPort.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_SendTo");
single_value->field_proto.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_SendTo");
single_value->field_msg.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_SendTo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.ASP_SendTo");
}

boolean ASP__SendTo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ASP__SendTo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ASP__RecvFrom::ASP__RecvFrom()
{
}

ASP__RecvFrom::ASP__RecvFrom(const INTEGER& par_connId,
    const CHARSTRING& par_remName,
    const INTEGER& par_remPort,
    const CHARSTRING& par_locName,
    const INTEGER& par_locPort,
    const Socket__API__Definitions::ProtoTuple& par_proto,
    const INTEGER& par_userData,
    const OCTETSTRING& par_msg)
  :   field_connId(par_connId),
  field_remName(par_remName),
  field_remPort(par_remPort),
  field_locName(par_locName),
  field_locPort(par_locPort),
  field_proto(par_proto),
  field_userData(par_userData),
  field_msg(par_msg)
{
}

ASP__RecvFrom::ASP__RecvFrom(const ASP__RecvFrom& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @IPL4asp_Types.ASP_RecvFrom.");
if (other_value.connId().is_bound()) field_connId = other_value.connId();
else field_connId.clean_up();
if (other_value.remName().is_bound()) field_remName = other_value.remName();
else field_remName.clean_up();
if (other_value.remPort().is_bound()) field_remPort = other_value.remPort();
else field_remPort.clean_up();
if (other_value.locName().is_bound()) field_locName = other_value.locName();
else field_locName.clean_up();
if (other_value.locPort().is_bound()) field_locPort = other_value.locPort();
else field_locPort.clean_up();
if (other_value.proto().is_bound()) field_proto = other_value.proto();
else field_proto.clean_up();
if (other_value.userData().is_bound()) field_userData = other_value.userData();
else field_userData.clean_up();
if (other_value.msg().is_bound()) field_msg = other_value.msg();
else field_msg.clean_up();
}

void ASP__RecvFrom::clean_up()
{
field_connId.clean_up();
field_remName.clean_up();
field_remPort.clean_up();
field_locName.clean_up();
field_locPort.clean_up();
field_proto.clean_up();
field_userData.clean_up();
field_msg.clean_up();
}

const TTCN_Typedescriptor_t* ASP__RecvFrom::get_descriptor() const { return &ASP__RecvFrom_descr_; }
ASP__RecvFrom& ASP__RecvFrom::operator=(const ASP__RecvFrom& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @IPL4asp_Types.ASP_RecvFrom.");
  if (other_value.connId().is_bound()) field_connId = other_value.connId();
  else field_connId.clean_up();
  if (other_value.remName().is_bound()) field_remName = other_value.remName();
  else field_remName.clean_up();
  if (other_value.remPort().is_bound()) field_remPort = other_value.remPort();
  else field_remPort.clean_up();
  if (other_value.locName().is_bound()) field_locName = other_value.locName();
  else field_locName.clean_up();
  if (other_value.locPort().is_bound()) field_locPort = other_value.locPort();
  else field_locPort.clean_up();
  if (other_value.proto().is_bound()) field_proto = other_value.proto();
  else field_proto.clean_up();
  if (other_value.userData().is_bound()) field_userData = other_value.userData();
  else field_userData.clean_up();
  if (other_value.msg().is_bound()) field_msg = other_value.msg();
  else field_msg.clean_up();
}
return *this;
}

boolean ASP__RecvFrom::operator==(const ASP__RecvFrom& other_value) const
{
return field_connId==other_value.field_connId
  && field_remName==other_value.field_remName
  && field_remPort==other_value.field_remPort
  && field_locName==other_value.field_locName
  && field_locPort==other_value.field_locPort
  && field_proto==other_value.field_proto
  && field_userData==other_value.field_userData
  && field_msg==other_value.field_msg;
}

boolean ASP__RecvFrom::is_bound() const
{
return (field_connId.is_bound())
  || (field_remName.is_bound())
  || (field_remPort.is_bound())
  || (field_locName.is_bound())
  || (field_locPort.is_bound())
  || (field_proto.is_bound())
  || (field_userData.is_bound())
  || (field_msg.is_bound());
}
boolean ASP__RecvFrom::is_value() const
{
return field_connId.is_value()
  && field_remName.is_value()
  && field_remPort.is_value()
  && field_locName.is_value()
  && field_locPort.is_value()
  && field_proto.is_value()
  && field_userData.is_value()
  && field_msg.is_value();
}
void ASP__RecvFrom::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ connId := ");
field_connId.log();
TTCN_Logger::log_event_str(", remName := ");
field_remName.log();
TTCN_Logger::log_event_str(", remPort := ");
field_remPort.log();
TTCN_Logger::log_event_str(", locName := ");
field_locName.log();
TTCN_Logger::log_event_str(", locPort := ");
field_locPort.log();
TTCN_Logger::log_event_str(", proto := ");
field_proto.log();
TTCN_Logger::log_event_str(", userData := ");
field_userData.log();
TTCN_Logger::log_event_str(", msg := ");
field_msg.log();
TTCN_Logger::log_event_str(" }");
}

void ASP__RecvFrom::set_implicit_omit()
{
if (connId().is_bound()) connId().set_implicit_omit();
if (remName().is_bound()) remName().set_implicit_omit();
if (remPort().is_bound()) remPort().set_implicit_omit();
if (locName().is_bound()) locName().set_implicit_omit();
if (locPort().is_bound()) locPort().set_implicit_omit();
if (proto().is_bound()) proto().set_implicit_omit();
if (userData().is_bound()) userData().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void ASP__RecvFrom::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @IPL4asp_Types.ASP_RecvFrom has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) remName().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) remPort().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) locName().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) locPort().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) proto().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) userData().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remPort")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remPort().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locPort")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locPort().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "proto")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          proto().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_RecvFrom: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@IPL4asp_Types.ASP_RecvFrom");
  }
}

void ASP__RecvFrom::encode_text(Text_Buf& text_buf) const
{
field_connId.encode_text(text_buf);
field_remName.encode_text(text_buf);
field_remPort.encode_text(text_buf);
field_locName.encode_text(text_buf);
field_locPort.encode_text(text_buf);
field_proto.encode_text(text_buf);
field_userData.encode_text(text_buf);
field_msg.encode_text(text_buf);
}

void ASP__RecvFrom::decode_text(Text_Buf& text_buf)
{
field_connId.decode_text(text_buf);
field_remName.decode_text(text_buf);
field_remPort.decode_text(text_buf);
field_locName.decode_text(text_buf);
field_locPort.decode_text(text_buf);
field_proto.decode_text(text_buf);
field_userData.decode_text(text_buf);
field_msg.decode_text(text_buf);
}

struct ASP__RecvFrom_template::single_value_struct {
INTEGER_template field_connId;
CHARSTRING_template field_remName;
INTEGER_template field_remPort;
CHARSTRING_template field_locName;
INTEGER_template field_locPort;
Socket__API__Definitions::ProtoTuple_template field_proto;
INTEGER_template field_userData;
OCTETSTRING_template field_msg;
};

void ASP__RecvFrom_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_connId = ANY_VALUE;
single_value->field_remName = ANY_VALUE;
single_value->field_remPort = ANY_VALUE;
single_value->field_locName = ANY_VALUE;
single_value->field_locPort = ANY_VALUE;
single_value->field_proto = ANY_VALUE;
single_value->field_userData = ANY_VALUE;
single_value->field_msg = ANY_VALUE;
}
}
}

void ASP__RecvFrom_template::copy_value(const ASP__RecvFrom& other_value)
{
single_value = new single_value_struct;
if (other_value.connId().is_bound()) {
  single_value->field_connId = other_value.connId();
} else {
  single_value->field_connId.clean_up();
}
if (other_value.remName().is_bound()) {
  single_value->field_remName = other_value.remName();
} else {
  single_value->field_remName.clean_up();
}
if (other_value.remPort().is_bound()) {
  single_value->field_remPort = other_value.remPort();
} else {
  single_value->field_remPort.clean_up();
}
if (other_value.locName().is_bound()) {
  single_value->field_locName = other_value.locName();
} else {
  single_value->field_locName.clean_up();
}
if (other_value.locPort().is_bound()) {
  single_value->field_locPort = other_value.locPort();
} else {
  single_value->field_locPort.clean_up();
}
if (other_value.proto().is_bound()) {
  single_value->field_proto = other_value.proto();
} else {
  single_value->field_proto.clean_up();
}
if (other_value.userData().is_bound()) {
  single_value->field_userData = other_value.userData();
} else {
  single_value->field_userData.clean_up();
}
if (other_value.msg().is_bound()) {
  single_value->field_msg = other_value.msg();
} else {
  single_value->field_msg.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ASP__RecvFrom_template::copy_template(const ASP__RecvFrom_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.connId().get_selection()) {
single_value->field_connId = other_value.connId();
} else {
single_value->field_connId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remName().get_selection()) {
single_value->field_remName = other_value.remName();
} else {
single_value->field_remName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remPort().get_selection()) {
single_value->field_remPort = other_value.remPort();
} else {
single_value->field_remPort.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locName().get_selection()) {
single_value->field_locName = other_value.locName();
} else {
single_value->field_locName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.locPort().get_selection()) {
single_value->field_locPort = other_value.locPort();
} else {
single_value->field_locPort.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.proto().get_selection()) {
single_value->field_proto = other_value.proto();
} else {
single_value->field_proto.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userData().get_selection()) {
single_value->field_userData = other_value.userData();
} else {
single_value->field_userData.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msg().get_selection()) {
single_value->field_msg = other_value.msg();
} else {
single_value->field_msg.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ASP__RecvFrom_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ASP__RecvFrom_template(*other_value.implication_.precondition);
implication_.implied_template = new ASP__RecvFrom_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @IPL4asp_Types.ASP_RecvFrom.");
break;
}
set_selection(other_value);
}

ASP__RecvFrom_template::ASP__RecvFrom_template()
{
}

ASP__RecvFrom_template::ASP__RecvFrom_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ASP__RecvFrom_template::ASP__RecvFrom_template(const ASP__RecvFrom& other_value)
{
copy_value(other_value);
}

ASP__RecvFrom_template::ASP__RecvFrom_template(const OPTIONAL<ASP__RecvFrom>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__RecvFrom&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @IPL4asp_Types.ASP_RecvFrom from an unbound optional field.");
}
}

ASP__RecvFrom_template::ASP__RecvFrom_template(ASP__RecvFrom_template* p_precondition, ASP__RecvFrom_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ASP__RecvFrom_template::ASP__RecvFrom_template(Dynamic_Match_Interface<ASP__RecvFrom>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ASP__RecvFrom>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ASP__RecvFrom_template::ASP__RecvFrom_template(const ASP__RecvFrom_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ASP__RecvFrom_template::~ASP__RecvFrom_template()
{
clean_up();
}

ASP__RecvFrom_template& ASP__RecvFrom_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ASP__RecvFrom_template& ASP__RecvFrom_template::operator=(const ASP__RecvFrom& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ASP__RecvFrom_template& ASP__RecvFrom_template::operator=(const OPTIONAL<ASP__RecvFrom>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__RecvFrom&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @IPL4asp_Types.ASP_RecvFrom.");
}
return *this;
}

ASP__RecvFrom_template& ASP__RecvFrom_template::operator=(const ASP__RecvFrom_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ASP__RecvFrom_template::match(const ASP__RecvFrom& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.connId().is_bound()) return FALSE;
if(!single_value->field_connId.match(other_value.connId(), legacy))return FALSE;
if(!other_value.remName().is_bound()) return FALSE;
if(!single_value->field_remName.match(other_value.remName(), legacy))return FALSE;
if(!other_value.remPort().is_bound()) return FALSE;
if(!single_value->field_remPort.match(other_value.remPort(), legacy))return FALSE;
if(!other_value.locName().is_bound()) return FALSE;
if(!single_value->field_locName.match(other_value.locName(), legacy))return FALSE;
if(!other_value.locPort().is_bound()) return FALSE;
if(!single_value->field_locPort.match(other_value.locPort(), legacy))return FALSE;
if(!other_value.proto().is_bound()) return FALSE;
if(!single_value->field_proto.match(other_value.proto(), legacy))return FALSE;
if(!other_value.userData().is_bound()) return FALSE;
if(!single_value->field_userData.match(other_value.userData(), legacy))return FALSE;
if(!other_value.msg().is_bound()) return FALSE;
if(!single_value->field_msg.match(other_value.msg(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @IPL4asp_Types.ASP_RecvFrom.");
}
return FALSE;
}

boolean ASP__RecvFrom_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_connId.is_bound()
 || single_value->field_remName.is_bound()
 || single_value->field_remPort.is_bound()
 || single_value->field_locName.is_bound()
 || single_value->field_locPort.is_bound()
 || single_value->field_proto.is_bound()
 || single_value->field_userData.is_bound()
 || single_value->field_msg.is_bound();
}

boolean ASP__RecvFrom_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_connId.is_value()
 && single_value->field_remName.is_value()
 && single_value->field_remPort.is_value()
 && single_value->field_locName.is_value()
 && single_value->field_locPort.is_value()
 && single_value->field_proto.is_value()
 && single_value->field_userData.is_value()
 && single_value->field_msg.is_value();
}

void ASP__RecvFrom_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ASP__RecvFrom ASP__RecvFrom_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
ASP__RecvFrom ret_val;
if (single_value->field_connId.is_bound()) {
ret_val.connId() = single_value->field_connId.valueof();
}
if (single_value->field_remName.is_bound()) {
ret_val.remName() = single_value->field_remName.valueof();
}
if (single_value->field_remPort.is_bound()) {
ret_val.remPort() = single_value->field_remPort.valueof();
}
if (single_value->field_locName.is_bound()) {
ret_val.locName() = single_value->field_locName.valueof();
}
if (single_value->field_locPort.is_bound()) {
ret_val.locPort() = single_value->field_locPort.valueof();
}
if (single_value->field_proto.is_bound()) {
ret_val.proto() = single_value->field_proto.valueof();
}
if (single_value->field_userData.is_bound()) {
ret_val.userData() = single_value->field_userData.valueof();
}
if (single_value->field_msg.is_bound()) {
ret_val.msg() = single_value->field_msg.valueof();
}
return ret_val;
}

void ASP__RecvFrom_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @IPL4asp_Types.ASP_RecvFrom.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ASP__RecvFrom_template[list_length];
}

ASP__RecvFrom_template& ASP__RecvFrom_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @IPL4asp_Types.ASP_RecvFrom.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @IPL4asp_Types.ASP_RecvFrom.");
return value_list.list_value[list_index];
}

INTEGER_template& ASP__RecvFrom_template::connId()
{
set_specific();
return single_value->field_connId;
}

const INTEGER_template& ASP__RecvFrom_template::connId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connId of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_connId;
}

CHARSTRING_template& ASP__RecvFrom_template::remName()
{
set_specific();
return single_value->field_remName;
}

const CHARSTRING_template& ASP__RecvFrom_template::remName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remName of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_remName;
}

INTEGER_template& ASP__RecvFrom_template::remPort()
{
set_specific();
return single_value->field_remPort;
}

const INTEGER_template& ASP__RecvFrom_template::remPort() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remPort of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_remPort;
}

CHARSTRING_template& ASP__RecvFrom_template::locName()
{
set_specific();
return single_value->field_locName;
}

const CHARSTRING_template& ASP__RecvFrom_template::locName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locName of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_locName;
}

INTEGER_template& ASP__RecvFrom_template::locPort()
{
set_specific();
return single_value->field_locPort;
}

const INTEGER_template& ASP__RecvFrom_template::locPort() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field locPort of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_locPort;
}

Socket__API__Definitions::ProtoTuple_template& ASP__RecvFrom_template::proto()
{
set_specific();
return single_value->field_proto;
}

const Socket__API__Definitions::ProtoTuple_template& ASP__RecvFrom_template::proto() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field proto of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_proto;
}

INTEGER_template& ASP__RecvFrom_template::userData()
{
set_specific();
return single_value->field_userData;
}

const INTEGER_template& ASP__RecvFrom_template::userData() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userData of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_userData;
}

OCTETSTRING_template& ASP__RecvFrom_template::msg()
{
set_specific();
return single_value->field_msg;
}

const OCTETSTRING_template& ASP__RecvFrom_template::msg() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msg of a non-specific template of type @IPL4asp_Types.ASP_RecvFrom.");
return single_value->field_msg;
}

int ASP__RecvFrom_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 8;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_RecvFrom containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @IPL4asp_Types.ASP_RecvFrom.");
  }
  return 0;
}

void ASP__RecvFrom_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log();
TTCN_Logger::log_event_str(", remName := ");
single_value->field_remName.log();
TTCN_Logger::log_event_str(", remPort := ");
single_value->field_remPort.log();
TTCN_Logger::log_event_str(", locName := ");
single_value->field_locName.log();
TTCN_Logger::log_event_str(", locPort := ");
single_value->field_locPort.log();
TTCN_Logger::log_event_str(", proto := ");
single_value->field_proto.log();
TTCN_Logger::log_event_str(", userData := ");
single_value->field_userData.log();
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ASP__RecvFrom_template::log_match(const ASP__RecvFrom& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_connId.match(match_value.connId(), legacy)){
TTCN_Logger::log_logmatch_info(".connId");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remName.match(match_value.remName(), legacy)){
TTCN_Logger::log_logmatch_info(".remName");
single_value->field_remName.log_match(match_value.remName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remPort.match(match_value.remPort(), legacy)){
TTCN_Logger::log_logmatch_info(".remPort");
single_value->field_remPort.log_match(match_value.remPort(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_locName.match(match_value.locName(), legacy)){
TTCN_Logger::log_logmatch_info(".locName");
single_value->field_locName.log_match(match_value.locName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_locPort.match(match_value.locPort(), legacy)){
TTCN_Logger::log_logmatch_info(".locPort");
single_value->field_locPort.log_match(match_value.locPort(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_proto.match(match_value.proto(), legacy)){
TTCN_Logger::log_logmatch_info(".proto");
single_value->field_proto.log_match(match_value.proto(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_userData.match(match_value.userData(), legacy)){
TTCN_Logger::log_logmatch_info(".userData");
single_value->field_userData.log_match(match_value.userData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_msg.match(match_value.msg(), legacy)){
TTCN_Logger::log_logmatch_info(".msg");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::log_event_str(", remName := ");
single_value->field_remName.log_match(match_value.remName(), legacy);
TTCN_Logger::log_event_str(", remPort := ");
single_value->field_remPort.log_match(match_value.remPort(), legacy);
TTCN_Logger::log_event_str(", locName := ");
single_value->field_locName.log_match(match_value.locName(), legacy);
TTCN_Logger::log_event_str(", locPort := ");
single_value->field_locPort.log_match(match_value.locPort(), legacy);
TTCN_Logger::log_event_str(", proto := ");
single_value->field_proto.log_match(match_value.proto(), legacy);
TTCN_Logger::log_event_str(", userData := ");
single_value->field_userData.log_match(match_value.userData(), legacy);
TTCN_Logger::log_event_str(", msg := ");
single_value->field_msg.log_match(match_value.msg(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ASP__RecvFrom_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (connId().is_bound()) connId().set_implicit_omit();
if (remName().is_bound()) remName().set_implicit_omit();
if (remPort().is_bound()) remPort().set_implicit_omit();
if (locName().is_bound()) locName().set_implicit_omit();
if (locPort().is_bound()) locPort().set_implicit_omit();
if (proto().is_bound()) proto().set_implicit_omit();
if (userData().is_bound()) userData().set_implicit_omit();
if (msg().is_bound()) msg().set_implicit_omit();
}

void ASP__RecvFrom_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_connId.encode_text(text_buf);
single_value->field_remName.encode_text(text_buf);
single_value->field_remPort.encode_text(text_buf);
single_value->field_locName.encode_text(text_buf);
single_value->field_locPort.encode_text(text_buf);
single_value->field_proto.encode_text(text_buf);
single_value->field_userData.encode_text(text_buf);
single_value->field_msg.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @IPL4asp_Types.ASP_RecvFrom.");
}
}

void ASP__RecvFrom_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_connId.decode_text(text_buf);
single_value->field_remName.decode_text(text_buf);
single_value->field_remPort.decode_text(text_buf);
single_value->field_locName.decode_text(text_buf);
single_value->field_locPort.decode_text(text_buf);
single_value->field_proto.decode_text(text_buf);
single_value->field_userData.decode_text(text_buf);
single_value->field_msg.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ASP__RecvFrom_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @IPL4asp_Types.ASP_RecvFrom.");
}
}

void ASP__RecvFrom_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ASP__RecvFrom_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @IPL4asp_Types.ASP_RecvFrom has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) remName().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) remPort().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) locName().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) locPort().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) proto().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) userData().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) msg().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remPort")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remPort().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "locPort")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          locPort().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "proto")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          proto().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_RecvFrom: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ASP__RecvFrom_template* precondition = new ASP__RecvFrom_template;
    precondition->set_param(*param.get_elem(0));
    ASP__RecvFrom_template* implied_template = new ASP__RecvFrom_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ASP__RecvFrom_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@IPL4asp_Types.ASP_RecvFrom");
  }
  is_ifpresent = param.get_ifpresent();
}

void ASP__RecvFrom_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_connId.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_remName.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_remPort.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_locName.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_locPort.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_proto.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_userData.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
single_value->field_msg.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.ASP_RecvFrom");
}

boolean ASP__RecvFrom_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ASP__RecvFrom_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ASP__ConnId__ReadyToRelease::ASP__ConnId__ReadyToRelease()
{
}

ASP__ConnId__ReadyToRelease::ASP__ConnId__ReadyToRelease(const INTEGER& par_connId)
  :   field_connId(par_connId)
{
}

ASP__ConnId__ReadyToRelease::ASP__ConnId__ReadyToRelease(const ASP__ConnId__ReadyToRelease& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
if (other_value.connId().is_bound()) field_connId = other_value.connId();
else field_connId.clean_up();
}

void ASP__ConnId__ReadyToRelease::clean_up()
{
field_connId.clean_up();
}

const TTCN_Typedescriptor_t* ASP__ConnId__ReadyToRelease::get_descriptor() const { return &ASP__ConnId__ReadyToRelease_descr_; }
ASP__ConnId__ReadyToRelease& ASP__ConnId__ReadyToRelease::operator=(const ASP__ConnId__ReadyToRelease& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
  if (other_value.connId().is_bound()) field_connId = other_value.connId();
  else field_connId.clean_up();
}
return *this;
}

boolean ASP__ConnId__ReadyToRelease::operator==(const ASP__ConnId__ReadyToRelease& other_value) const
{
return field_connId==other_value.field_connId;
}

boolean ASP__ConnId__ReadyToRelease::is_bound() const
{
return (field_connId.is_bound());
}
boolean ASP__ConnId__ReadyToRelease::is_value() const
{
return field_connId.is_value();
}
void ASP__ConnId__ReadyToRelease::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ connId := ");
field_connId.log();
TTCN_Logger::log_event_str(" }");
}

void ASP__ConnId__ReadyToRelease::set_implicit_omit()
{
if (connId().is_bound()) connId().set_implicit_omit();
}

void ASP__ConnId__ReadyToRelease::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_ConnId_ReadyToRelease: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@IPL4asp_Types.ASP_ConnId_ReadyToRelease");
  }
}

void ASP__ConnId__ReadyToRelease::encode_text(Text_Buf& text_buf) const
{
field_connId.encode_text(text_buf);
}

void ASP__ConnId__ReadyToRelease::decode_text(Text_Buf& text_buf)
{
field_connId.decode_text(text_buf);
}

struct ASP__ConnId__ReadyToRelease_template::single_value_struct {
INTEGER_template field_connId;
};

void ASP__ConnId__ReadyToRelease_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_connId = ANY_VALUE;
}
}
}

void ASP__ConnId__ReadyToRelease_template::copy_value(const ASP__ConnId__ReadyToRelease& other_value)
{
single_value = new single_value_struct;
if (other_value.connId().is_bound()) {
  single_value->field_connId = other_value.connId();
} else {
  single_value->field_connId.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ASP__ConnId__ReadyToRelease_template::copy_template(const ASP__ConnId__ReadyToRelease_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.connId().get_selection()) {
single_value->field_connId = other_value.connId();
} else {
single_value->field_connId.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ASP__ConnId__ReadyToRelease_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ASP__ConnId__ReadyToRelease_template(*other_value.implication_.precondition);
implication_.implied_template = new ASP__ConnId__ReadyToRelease_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
break;
}
set_selection(other_value);
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template()
{
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template(const ASP__ConnId__ReadyToRelease& other_value)
{
copy_value(other_value);
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template(const OPTIONAL<ASP__ConnId__ReadyToRelease>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__ConnId__ReadyToRelease&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease from an unbound optional field.");
}
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template(ASP__ConnId__ReadyToRelease_template* p_precondition, ASP__ConnId__ReadyToRelease_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template(Dynamic_Match_Interface<ASP__ConnId__ReadyToRelease>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ASP__ConnId__ReadyToRelease>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ASP__ConnId__ReadyToRelease_template::ASP__ConnId__ReadyToRelease_template(const ASP__ConnId__ReadyToRelease_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ASP__ConnId__ReadyToRelease_template::~ASP__ConnId__ReadyToRelease_template()
{
clean_up();
}

ASP__ConnId__ReadyToRelease_template& ASP__ConnId__ReadyToRelease_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ASP__ConnId__ReadyToRelease_template& ASP__ConnId__ReadyToRelease_template::operator=(const ASP__ConnId__ReadyToRelease& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ASP__ConnId__ReadyToRelease_template& ASP__ConnId__ReadyToRelease_template::operator=(const OPTIONAL<ASP__ConnId__ReadyToRelease>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ASP__ConnId__ReadyToRelease&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
}
return *this;
}

ASP__ConnId__ReadyToRelease_template& ASP__ConnId__ReadyToRelease_template::operator=(const ASP__ConnId__ReadyToRelease_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ASP__ConnId__ReadyToRelease_template::match(const ASP__ConnId__ReadyToRelease& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.connId().is_bound()) return FALSE;
if(!single_value->field_connId.match(other_value.connId(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
}
return FALSE;
}

boolean ASP__ConnId__ReadyToRelease_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_connId.is_bound();
}

boolean ASP__ConnId__ReadyToRelease_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_connId.is_value();
}

void ASP__ConnId__ReadyToRelease_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ASP__ConnId__ReadyToRelease ASP__ConnId__ReadyToRelease_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
ASP__ConnId__ReadyToRelease ret_val;
if (single_value->field_connId.is_bound()) {
ret_val.connId() = single_value->field_connId.valueof();
}
return ret_val;
}

void ASP__ConnId__ReadyToRelease_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ASP__ConnId__ReadyToRelease_template[list_length];
}

ASP__ConnId__ReadyToRelease_template& ASP__ConnId__ReadyToRelease_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
return value_list.list_value[list_index];
}

INTEGER_template& ASP__ConnId__ReadyToRelease_template::connId()
{
set_specific();
return single_value->field_connId;
}

const INTEGER_template& ASP__ConnId__ReadyToRelease_template::connId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connId of a non-specific template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
return single_value->field_connId;
}

int ASP__ConnId__ReadyToRelease_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
  }
  return 0;
}

void ASP__ConnId__ReadyToRelease_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ASP__ConnId__ReadyToRelease_template::log_match(const ASP__ConnId__ReadyToRelease& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_connId.match(match_value.connId(), legacy)){
TTCN_Logger::log_logmatch_info(".connId");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ connId := ");
single_value->field_connId.log_match(match_value.connId(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ASP__ConnId__ReadyToRelease_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (connId().is_bound()) connId().set_implicit_omit();
}

void ASP__ConnId__ReadyToRelease_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_connId.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
}
}

void ASP__ConnId__ReadyToRelease_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_connId.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ASP__ConnId__ReadyToRelease_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease.");
}
}

void ASP__ConnId__ReadyToRelease_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ASP__ConnId__ReadyToRelease_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @IPL4asp_Types.ASP_ConnId_ReadyToRelease has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) connId().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.ASP_ConnId_ReadyToRelease: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ASP__ConnId__ReadyToRelease_template* precondition = new ASP__ConnId__ReadyToRelease_template;
    precondition->set_param(*param.get_elem(0));
    ASP__ConnId__ReadyToRelease_template* implied_template = new ASP__ConnId__ReadyToRelease_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ASP__ConnId__ReadyToRelease_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@IPL4asp_Types.ASP_ConnId_ReadyToRelease");
  }
  is_ifpresent = param.get_ifpresent();
}

void ASP__ConnId__ReadyToRelease_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_connId.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.ASP_ConnId_ReadyToRelease");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.ASP_ConnId_ReadyToRelease");
}

boolean ASP__ConnId__ReadyToRelease_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ASP__ConnId__ReadyToRelease_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

IPL4__Param::IPL4__Param()
{
enum_value = UNBOUND_VALUE;
}

IPL4__Param::IPL4__Param(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @IPL4asp_Types.IPL4_Param with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

IPL4__Param::IPL4__Param(enum_type other_value)
{
enum_value = other_value;
}

IPL4__Param::IPL4__Param(const IPL4__Param& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
enum_value = other_value.enum_value;
}

IPL4__Param& IPL4__Param::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @IPL4asp_Types.IPL4_Param.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

IPL4__Param& IPL4__Param::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

IPL4__Param& IPL4__Param::operator=(const IPL4__Param& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
enum_value = other_value.enum_value;
return *this;
}

boolean IPL4__Param::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_Param comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean IPL4__Param::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value == other_value;
}

boolean IPL4__Param::operator==(const IPL4__Param& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value == other_value.enum_value;
}

boolean IPL4__Param::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_Param comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean IPL4__Param::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value < other_value;
}

boolean IPL4__Param::operator<(const IPL4__Param& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value < other_value.enum_value;
}

boolean IPL4__Param::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_Param comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean IPL4__Param::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value > other_value;
}

boolean IPL4__Param::operator>(const IPL4__Param& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value > other_value.enum_value;
}

const char *IPL4__Param::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case IPL4__LOCALADDRESS: return "IPL4_LOCALADDRESS";
case IPL4__REMOTEADDRESS: return "IPL4_REMOTEADDRESS";
case IPL4__PROTO: return "IPL4_PROTO";
case IPL4__USERDATA: return "IPL4_USERDATA";
case IPL4__PARENTIDX: return "IPL4_PARENTIDX";
default:
return "<unknown>";
}
}

IPL4__Param::enum_type IPL4__Param::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "IPL4_LOCALADDRESS")) return IPL4__LOCALADDRESS;
if (!strcmp(str_par, "IPL4_REMOTEADDRESS")) return IPL4__REMOTEADDRESS;
if (!strcmp(str_par, "IPL4_PROTO")) return IPL4__PROTO;
if (!strcmp(str_par, "IPL4_USERDATA")) return IPL4__USERDATA;
if (!strcmp(str_par, "IPL4_PARENTIDX")) return IPL4__PARENTIDX;
}
return UNKNOWN_VALUE;
}

boolean IPL4__Param::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
return TRUE;
default:
return FALSE;
}
}

int IPL4__Param::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @IPL4asp_Types.IPL4_Param.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int IPL4__Param::enum2int(const IPL4__Param& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @IPL4asp_Types.IPL4_Param.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void IPL4__Param::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @IPL4asp_Types.IPL4_Param.", int_val);
enum_value = (enum_type)int_val;
}

IPL4__Param::operator IPL4__Param::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @IPL4asp_Types.IPL4_Param.");
return enum_value;
}

void IPL4__Param::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void IPL4__Param::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@IPL4asp_Types.IPL4_Param");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @IPL4asp_Types.IPL4_Param.");
  }
}

void IPL4__Param::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
text_buf.push_int(enum_value);
}

void IPL4__Param::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @IPL4asp_Types.IPL4_Param.", enum_value);
}

void IPL4__Param_template::copy_template(const IPL4__Param_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new IPL4__Param_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new IPL4__Param_template(*other_value.implication_.precondition);
implication_.implied_template = new IPL4__Param_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_Param.");
}
}

IPL4__Param_template::IPL4__Param_template()
{
}

IPL4__Param_template::IPL4__Param_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

IPL4__Param_template::IPL4__Param_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!IPL4__Param::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @IPL4asp_Types.IPL4_Param with unknown numeric value %d.", other_value);
single_value = (IPL4__Param::enum_type)other_value;
}

IPL4__Param_template::IPL4__Param_template(IPL4__Param::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

IPL4__Param_template::IPL4__Param_template(const IPL4__Param& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == IPL4__Param::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @IPL4asp_Types.IPL4_Param.");
single_value = other_value.enum_value;
}

IPL4__Param_template::IPL4__Param_template(const OPTIONAL<IPL4__Param>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__Param::enum_type)(const IPL4__Param&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @IPL4asp_Types.IPL4_Param from an unbound optional field.");
}
}

IPL4__Param_template::IPL4__Param_template(IPL4__Param_template* p_precondition, IPL4__Param_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

IPL4__Param_template::IPL4__Param_template(Dynamic_Match_Interface<IPL4__Param>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<IPL4__Param>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

IPL4__Param_template::IPL4__Param_template(const IPL4__Param_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

IPL4__Param_template::~IPL4__Param_template()
{
clean_up();
}

boolean IPL4__Param_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean IPL4__Param_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != IPL4__Param::UNBOUND_VALUE;
}

void IPL4__Param_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

IPL4__Param_template& IPL4__Param_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

IPL4__Param_template& IPL4__Param_template::operator=(int other_value)
{
if (!IPL4__Param::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @IPL4asp_Types.IPL4_Param.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__Param::enum_type)other_value;
return *this;
}

IPL4__Param_template& IPL4__Param_template::operator=(IPL4__Param::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

IPL4__Param_template& IPL4__Param_template::operator=(const IPL4__Param& other_value)
{
if (other_value.enum_value == IPL4__Param::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @IPL4asp_Types.IPL4_Param to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

IPL4__Param_template& IPL4__Param_template::operator=(const OPTIONAL<IPL4__Param>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__Param::enum_type)(const IPL4__Param&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @IPL4asp_Types.IPL4_Param.");
}
return *this;
}

IPL4__Param_template& IPL4__Param_template::operator=(const IPL4__Param_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean IPL4__Param_template::match(IPL4__Param::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_Param.");
}
return FALSE;
}

boolean IPL4__Param_template::match(const IPL4__Param& other_value, boolean) const
{
if (other_value.enum_value == IPL4__Param::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @IPL4asp_Types.IPL4_Param with an unbound value.");
return match(other_value.enum_value);
}

IPL4__Param::enum_type IPL4__Param_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @IPL4asp_Types.IPL4_Param.");
return single_value;
}

void IPL4__Param_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new IPL4__Param_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @IPL4asp_Types.IPL4_Param.");
}
}

IPL4__Param_template& IPL4__Param_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @IPL4asp_Types.IPL4_Param.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @IPL4asp_Types.IPL4_Param.");
return value_list.list_value[list_index];
}

void IPL4__Param_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(IPL4__Param::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void IPL4__Param_template::log_match(const IPL4__Param& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void IPL4__Param_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_Param.");
}
}

void IPL4__Param_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (IPL4__Param::enum_type)text_buf.pull_int().get_val();
if (!IPL4__Param::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @IPL4asp_Types.IPL4_Param.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new IPL4__Param_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @IPL4asp_Types.IPL4_Param.");
}
}

boolean IPL4__Param_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean IPL4__Param_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void IPL4__Param_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    IPL4__Param_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    IPL4__Param::enum_type enum_val = IPL4__Param::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!IPL4__Param::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @IPL4asp_Types.IPL4_Param.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    IPL4__Param_template* precondition = new IPL4__Param_template;
    precondition->set_param(*m_p->get_elem(0));
    IPL4__Param_template* implied_template = new IPL4__Param_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = IPL4__Param_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@IPL4asp_Types.IPL4_Param");
  }
  is_ifpresent = param.get_ifpresent();
}

void IPL4__Param_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.IPL4_Param");
}

void IPL4__ParamResult::copy_value(const IPL4__ParamResult& other_value)
{
switch (other_value.union_selection) {
case ALT_local:
field_local = new Socket__API__Definitions::Socket(*other_value.field_local);
break;
case ALT_remote:
field_remote = new Socket__API__Definitions::Socket(*other_value.field_remote);
break;
case ALT_proto:
field_proto = new Socket__API__Definitions::ProtoTuple(*other_value.field_proto);
break;
case ALT_userData:
field_userData = new INTEGER(*other_value.field_userData);
break;
case ALT_parentIdx:
field_parentIdx = new INTEGER(*other_value.field_parentIdx);
break;
default:
TTCN_error("Assignment of an unbound union value of type @IPL4asp_Types.IPL4_ParamResult.");
}
union_selection = other_value.union_selection;
}

IPL4__ParamResult::IPL4__ParamResult()
{
union_selection = UNBOUND_VALUE;
}

IPL4__ParamResult::IPL4__ParamResult(const IPL4__ParamResult& other_value)
: Base_Type(){
copy_value(other_value);
}

IPL4__ParamResult::~IPL4__ParamResult()
{
clean_up();
}

IPL4__ParamResult& IPL4__ParamResult::operator=(const IPL4__ParamResult& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean IPL4__ParamResult::operator==(const IPL4__ParamResult& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @IPL4asp_Types.IPL4_ParamResult.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @IPL4asp_Types.IPL4_ParamResult.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_local:
return *field_local == *other_value.field_local;
case ALT_remote:
return *field_remote == *other_value.field_remote;
case ALT_proto:
return *field_proto == *other_value.field_proto;
case ALT_userData:
return *field_userData == *other_value.field_userData;
case ALT_parentIdx:
return *field_parentIdx == *other_value.field_parentIdx;
default:
return FALSE;
}
}

Socket__API__Definitions::Socket& IPL4__ParamResult::local()
{
if (union_selection != ALT_local) {
clean_up();
field_local = new Socket__API__Definitions::Socket;
union_selection = ALT_local;
}
return *field_local;
}

const Socket__API__Definitions::Socket& IPL4__ParamResult::local() const
{
if (union_selection != ALT_local) TTCN_error("Using non-selected field local in a value of union type @IPL4asp_Types.IPL4_ParamResult.");
return *field_local;
}

Socket__API__Definitions::Socket& IPL4__ParamResult::remote()
{
if (union_selection != ALT_remote) {
clean_up();
field_remote = new Socket__API__Definitions::Socket;
union_selection = ALT_remote;
}
return *field_remote;
}

const Socket__API__Definitions::Socket& IPL4__ParamResult::remote() const
{
if (union_selection != ALT_remote) TTCN_error("Using non-selected field remote in a value of union type @IPL4asp_Types.IPL4_ParamResult.");
return *field_remote;
}

Socket__API__Definitions::ProtoTuple& IPL4__ParamResult::proto()
{
if (union_selection != ALT_proto) {
clean_up();
field_proto = new Socket__API__Definitions::ProtoTuple;
union_selection = ALT_proto;
}
return *field_proto;
}

const Socket__API__Definitions::ProtoTuple& IPL4__ParamResult::proto() const
{
if (union_selection != ALT_proto) TTCN_error("Using non-selected field proto in a value of union type @IPL4asp_Types.IPL4_ParamResult.");
return *field_proto;
}

INTEGER& IPL4__ParamResult::userData()
{
if (union_selection != ALT_userData) {
clean_up();
field_userData = new INTEGER;
union_selection = ALT_userData;
}
return *field_userData;
}

const INTEGER& IPL4__ParamResult::userData() const
{
if (union_selection != ALT_userData) TTCN_error("Using non-selected field userData in a value of union type @IPL4asp_Types.IPL4_ParamResult.");
return *field_userData;
}

INTEGER& IPL4__ParamResult::parentIdx()
{
if (union_selection != ALT_parentIdx) {
clean_up();
field_parentIdx = new INTEGER;
union_selection = ALT_parentIdx;
}
return *field_parentIdx;
}

const INTEGER& IPL4__ParamResult::parentIdx() const
{
if (union_selection != ALT_parentIdx) TTCN_error("Using non-selected field parentIdx in a value of union type @IPL4asp_Types.IPL4_ParamResult.");
return *field_parentIdx;
}

boolean IPL4__ParamResult::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @IPL4asp_Types.IPL4_ParamResult.");
return union_selection == checked_selection;
}

boolean IPL4__ParamResult::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean IPL4__ParamResult::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_local: return field_local->is_value();
case ALT_remote: return field_remote->is_value();
case ALT_proto: return field_proto->is_value();
case ALT_userData: return field_userData->is_value();
case ALT_parentIdx: return field_parentIdx->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void IPL4__ParamResult::clean_up()
{
switch (union_selection) {
case ALT_local:
  delete field_local;
  break;
case ALT_remote:
  delete field_remote;
  break;
case ALT_proto:
  delete field_proto;
  break;
case ALT_userData:
  delete field_userData;
  break;
case ALT_parentIdx:
  delete field_parentIdx;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void IPL4__ParamResult::log() const
{
switch (union_selection) {
case ALT_local:
TTCN_Logger::log_event_str("{ local := ");
field_local->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_remote:
TTCN_Logger::log_event_str("{ remote := ");
field_remote->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_proto:
TTCN_Logger::log_event_str("{ proto := ");
field_proto->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_userData:
TTCN_Logger::log_event_str("{ userData := ");
field_userData->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_parentIdx:
TTCN_Logger::log_event_str("{ parentIdx := ");
field_parentIdx->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void IPL4__ParamResult::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "local")) {
    local().set_param(*mp_last);
    if (!local().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "remote")) {
    remote().set_param(*mp_last);
    if (!remote().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "proto")) {
    proto().set_param(*mp_last);
    if (!proto().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "userData")) {
    userData().set_param(*mp_last);
    if (!userData().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "parentIdx")) {
    parentIdx().set_param(*mp_last);
    if (!parentIdx().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @IPL4asp_Types.IPL4_ParamResult.", last_name);
}

void IPL4__ParamResult::set_implicit_omit()
{
switch (union_selection) {
case ALT_local:
field_local->set_implicit_omit(); break;
case ALT_remote:
field_remote->set_implicit_omit(); break;
case ALT_proto:
field_proto->set_implicit_omit(); break;
case ALT_userData:
field_userData->set_implicit_omit(); break;
case ALT_parentIdx:
field_parentIdx->set_implicit_omit(); break;
default: break;
}
}

void IPL4__ParamResult::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_local:
field_local->encode_text(text_buf);
break;
case ALT_remote:
field_remote->encode_text(text_buf);
break;
case ALT_proto:
field_proto->encode_text(text_buf);
break;
case ALT_userData:
field_userData->encode_text(text_buf);
break;
case ALT_parentIdx:
field_parentIdx->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @IPL4asp_Types.IPL4_ParamResult.");
}
}

void IPL4__ParamResult::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_local:
local().decode_text(text_buf);
break;
case ALT_remote:
remote().decode_text(text_buf);
break;
case ALT_proto:
proto().decode_text(text_buf);
break;
case ALT_userData:
userData().decode_text(text_buf);
break;
case ALT_parentIdx:
parentIdx().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @IPL4asp_Types.IPL4_ParamResult.");
}
}

void IPL4__ParamResult_template::copy_value(const IPL4__ParamResult& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
single_value.field_local = new Socket__API__Definitions::Socket_template(other_value.local());
break;
case IPL4__ParamResult::ALT_remote:
single_value.field_remote = new Socket__API__Definitions::Socket_template(other_value.remote());
break;
case IPL4__ParamResult::ALT_proto:
single_value.field_proto = new Socket__API__Definitions::ProtoTuple_template(other_value.proto());
break;
case IPL4__ParamResult::ALT_userData:
single_value.field_userData = new INTEGER_template(other_value.userData());
break;
case IPL4__ParamResult::ALT_parentIdx:
single_value.field_parentIdx = new INTEGER_template(other_value.parentIdx());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @IPL4asp_Types.IPL4_ParamResult.");
}
set_selection(SPECIFIC_VALUE);
}

void IPL4__ParamResult_template::copy_template(const IPL4__ParamResult_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
single_value.field_local = new Socket__API__Definitions::Socket_template(*other_value.single_value.field_local);
break;
case IPL4__ParamResult::ALT_remote:
single_value.field_remote = new Socket__API__Definitions::Socket_template(*other_value.single_value.field_remote);
break;
case IPL4__ParamResult::ALT_proto:
single_value.field_proto = new Socket__API__Definitions::ProtoTuple_template(*other_value.single_value.field_proto);
break;
case IPL4__ParamResult::ALT_userData:
single_value.field_userData = new INTEGER_template(*other_value.single_value.field_userData);
break;
case IPL4__ParamResult::ALT_parentIdx:
single_value.field_parentIdx = new INTEGER_template(*other_value.single_value.field_parentIdx);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @IPL4asp_Types.IPL4_ParamResult.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new IPL4__ParamResult_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new IPL4__ParamResult_template(*other_value.implication_.precondition);
implication_.implied_template = new IPL4__ParamResult_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
set_selection(other_value);
}

IPL4__ParamResult_template::IPL4__ParamResult_template()
{
}

IPL4__ParamResult_template::IPL4__ParamResult_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

IPL4__ParamResult_template::IPL4__ParamResult_template(const IPL4__ParamResult& other_value)
{
copy_value(other_value);
}

IPL4__ParamResult_template::IPL4__ParamResult_template(const OPTIONAL<IPL4__ParamResult>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const IPL4__ParamResult&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @IPL4asp_Types.IPL4_ParamResult from an unbound optional field.");
}
}

IPL4__ParamResult_template::IPL4__ParamResult_template(IPL4__ParamResult_template* p_precondition, IPL4__ParamResult_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

IPL4__ParamResult_template::IPL4__ParamResult_template(Dynamic_Match_Interface<IPL4__ParamResult>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<IPL4__ParamResult>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

IPL4__ParamResult_template::IPL4__ParamResult_template(const IPL4__ParamResult_template& other_value)
: Base_Template(){
copy_template(other_value);
}

IPL4__ParamResult_template::~IPL4__ParamResult_template()
{
clean_up();
}

void IPL4__ParamResult_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
delete single_value.field_local;
break;
case IPL4__ParamResult::ALT_remote:
delete single_value.field_remote;
break;
case IPL4__ParamResult::ALT_proto:
delete single_value.field_proto;
break;
case IPL4__ParamResult::ALT_userData:
delete single_value.field_userData;
break;
case IPL4__ParamResult::ALT_parentIdx:
delete single_value.field_parentIdx;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

IPL4__ParamResult_template& IPL4__ParamResult_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

IPL4__ParamResult_template& IPL4__ParamResult_template::operator=(const IPL4__ParamResult& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

IPL4__ParamResult_template& IPL4__ParamResult_template::operator=(const OPTIONAL<IPL4__ParamResult>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const IPL4__ParamResult&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
return *this;
}

IPL4__ParamResult_template& IPL4__ParamResult_template::operator=(const IPL4__ParamResult_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean IPL4__ParamResult_template::match(const IPL4__ParamResult& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
IPL4__ParamResult::union_selection_type value_selection = other_value.get_selection();
if (value_selection == IPL4__ParamResult::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case IPL4__ParamResult::ALT_local:
return single_value.field_local->match(other_value.local(), legacy);
case IPL4__ParamResult::ALT_remote:
return single_value.field_remote->match(other_value.remote(), legacy);
case IPL4__ParamResult::ALT_proto:
return single_value.field_proto->match(other_value.proto(), legacy);
case IPL4__ParamResult::ALT_userData:
return single_value.field_userData->match(other_value.userData(), legacy);
case IPL4__ParamResult::ALT_parentIdx:
return single_value.field_parentIdx->match(other_value.parentIdx(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
return FALSE;
}

boolean IPL4__ParamResult_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
return single_value.field_local->is_value();
case IPL4__ParamResult::ALT_remote:
return single_value.field_remote->is_value();
case IPL4__ParamResult::ALT_proto:
return single_value.field_proto->is_value();
case IPL4__ParamResult::ALT_userData:
return single_value.field_userData->is_value();
case IPL4__ParamResult::ALT_parentIdx:
return single_value.field_parentIdx->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
}

IPL4__ParamResult IPL4__ParamResult_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @IPL4asp_Types.IPL4_ParamResult.");
IPL4__ParamResult ret_val;
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
ret_val.local() = single_value.field_local->valueof();
break;
case IPL4__ParamResult::ALT_remote:
ret_val.remote() = single_value.field_remote->valueof();
break;
case IPL4__ParamResult::ALT_proto:
ret_val.proto() = single_value.field_proto->valueof();
break;
case IPL4__ParamResult::ALT_userData:
ret_val.userData() = single_value.field_userData->valueof();
break;
case IPL4__ParamResult::ALT_parentIdx:
ret_val.parentIdx() = single_value.field_parentIdx->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
return ret_val;
}

IPL4__ParamResult_template& IPL4__ParamResult_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @IPL4asp_Types.IPL4_ParamResult.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @IPL4asp_Types.IPL4_ParamResult.");
return value_list.list_value[list_index];
}
void IPL4__ParamResult_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @IPL4asp_Types.IPL4_ParamResult.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new IPL4__ParamResult_template[list_length];
}

Socket__API__Definitions::Socket_template& IPL4__ParamResult_template::local()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != IPL4__ParamResult::ALT_local) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_local = new Socket__API__Definitions::Socket_template(ANY_VALUE);
else single_value.field_local = new Socket__API__Definitions::Socket_template;
single_value.union_selection = IPL4__ParamResult::ALT_local;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_local;
}

const Socket__API__Definitions::Socket_template& IPL4__ParamResult_template::local() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field local in a non-specific template of union type @IPL4asp_Types.IPL4_ParamResult.");
if (single_value.union_selection != IPL4__ParamResult::ALT_local) TTCN_error("Accessing non-selected field local in a template of union type @IPL4asp_Types.IPL4_ParamResult.");
return *single_value.field_local;
}

Socket__API__Definitions::Socket_template& IPL4__ParamResult_template::remote()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != IPL4__ParamResult::ALT_remote) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_remote = new Socket__API__Definitions::Socket_template(ANY_VALUE);
else single_value.field_remote = new Socket__API__Definitions::Socket_template;
single_value.union_selection = IPL4__ParamResult::ALT_remote;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_remote;
}

const Socket__API__Definitions::Socket_template& IPL4__ParamResult_template::remote() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field remote in a non-specific template of union type @IPL4asp_Types.IPL4_ParamResult.");
if (single_value.union_selection != IPL4__ParamResult::ALT_remote) TTCN_error("Accessing non-selected field remote in a template of union type @IPL4asp_Types.IPL4_ParamResult.");
return *single_value.field_remote;
}

Socket__API__Definitions::ProtoTuple_template& IPL4__ParamResult_template::proto()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != IPL4__ParamResult::ALT_proto) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_proto = new Socket__API__Definitions::ProtoTuple_template(ANY_VALUE);
else single_value.field_proto = new Socket__API__Definitions::ProtoTuple_template;
single_value.union_selection = IPL4__ParamResult::ALT_proto;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_proto;
}

const Socket__API__Definitions::ProtoTuple_template& IPL4__ParamResult_template::proto() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field proto in a non-specific template of union type @IPL4asp_Types.IPL4_ParamResult.");
if (single_value.union_selection != IPL4__ParamResult::ALT_proto) TTCN_error("Accessing non-selected field proto in a template of union type @IPL4asp_Types.IPL4_ParamResult.");
return *single_value.field_proto;
}

INTEGER_template& IPL4__ParamResult_template::userData()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != IPL4__ParamResult::ALT_userData) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_userData = new INTEGER_template(ANY_VALUE);
else single_value.field_userData = new INTEGER_template;
single_value.union_selection = IPL4__ParamResult::ALT_userData;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_userData;
}

const INTEGER_template& IPL4__ParamResult_template::userData() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field userData in a non-specific template of union type @IPL4asp_Types.IPL4_ParamResult.");
if (single_value.union_selection != IPL4__ParamResult::ALT_userData) TTCN_error("Accessing non-selected field userData in a template of union type @IPL4asp_Types.IPL4_ParamResult.");
return *single_value.field_userData;
}

INTEGER_template& IPL4__ParamResult_template::parentIdx()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != IPL4__ParamResult::ALT_parentIdx) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_parentIdx = new INTEGER_template(ANY_VALUE);
else single_value.field_parentIdx = new INTEGER_template;
single_value.union_selection = IPL4__ParamResult::ALT_parentIdx;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_parentIdx;
}

const INTEGER_template& IPL4__ParamResult_template::parentIdx() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field parentIdx in a non-specific template of union type @IPL4asp_Types.IPL4_ParamResult.");
if (single_value.union_selection != IPL4__ParamResult::ALT_parentIdx) TTCN_error("Accessing non-selected field parentIdx in a template of union type @IPL4asp_Types.IPL4_ParamResult.");
return *single_value.field_parentIdx;
}

boolean IPL4__ParamResult_template::ischosen(IPL4__ParamResult::union_selection_type checked_selection) const
{
if (checked_selection == IPL4__ParamResult::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @IPL4asp_Types.IPL4_ParamResult.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == IPL4__ParamResult::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @IPL4asp_Types.IPL4_ParamResult.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @IPL4asp_Types.IPL4_ParamResult containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void IPL4__ParamResult_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
TTCN_Logger::log_event_str("{ local := ");
single_value.field_local->log();
TTCN_Logger::log_event_str(" }");
break;
case IPL4__ParamResult::ALT_remote:
TTCN_Logger::log_event_str("{ remote := ");
single_value.field_remote->log();
TTCN_Logger::log_event_str(" }");
break;
case IPL4__ParamResult::ALT_proto:
TTCN_Logger::log_event_str("{ proto := ");
single_value.field_proto->log();
TTCN_Logger::log_event_str(" }");
break;
case IPL4__ParamResult::ALT_userData:
TTCN_Logger::log_event_str("{ userData := ");
single_value.field_userData->log();
TTCN_Logger::log_event_str(" }");
break;
case IPL4__ParamResult::ALT_parentIdx:
TTCN_Logger::log_event_str("{ parentIdx := ");
single_value.field_parentIdx->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void IPL4__ParamResult_template::log_match(const IPL4__ParamResult& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".local");
single_value.field_local->log_match(match_value.local(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ local := ");
single_value.field_local->log_match(match_value.local(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case IPL4__ParamResult::ALT_remote:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".remote");
single_value.field_remote->log_match(match_value.remote(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ remote := ");
single_value.field_remote->log_match(match_value.remote(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case IPL4__ParamResult::ALT_proto:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".proto");
single_value.field_proto->log_match(match_value.proto(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ proto := ");
single_value.field_proto->log_match(match_value.proto(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case IPL4__ParamResult::ALT_userData:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".userData");
single_value.field_userData->log_match(match_value.userData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ userData := ");
single_value.field_userData->log_match(match_value.userData(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case IPL4__ParamResult::ALT_parentIdx:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".parentIdx");
single_value.field_parentIdx->log_match(match_value.parentIdx(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ parentIdx := ");
single_value.field_parentIdx->log_match(match_value.parentIdx(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void IPL4__ParamResult_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
single_value.field_local->set_implicit_omit(); break;
case IPL4__ParamResult::ALT_remote:
single_value.field_remote->set_implicit_omit(); break;
case IPL4__ParamResult::ALT_proto:
single_value.field_proto->set_implicit_omit(); break;
case IPL4__ParamResult::ALT_userData:
single_value.field_userData->set_implicit_omit(); break;
case IPL4__ParamResult::ALT_parentIdx:
single_value.field_parentIdx->set_implicit_omit(); break;
default: break;
}
}

void IPL4__ParamResult_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
single_value.field_local->encode_text(text_buf);
break;
case IPL4__ParamResult::ALT_remote:
single_value.field_remote->encode_text(text_buf);
break;
case IPL4__ParamResult::ALT_proto:
single_value.field_proto->encode_text(text_buf);
break;
case IPL4__ParamResult::ALT_userData:
single_value.field_userData->encode_text(text_buf);
break;
case IPL4__ParamResult::ALT_parentIdx:
single_value.field_parentIdx->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @IPL4asp_Types.IPL4_ParamResult.");
}
}

void IPL4__ParamResult_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = IPL4__ParamResult::UNBOUND_VALUE;
IPL4__ParamResult::union_selection_type new_selection = (IPL4__ParamResult::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case IPL4__ParamResult::ALT_local:
single_value.field_local = new Socket__API__Definitions::Socket_template;
single_value.field_local->decode_text(text_buf);
break;
case IPL4__ParamResult::ALT_remote:
single_value.field_remote = new Socket__API__Definitions::Socket_template;
single_value.field_remote->decode_text(text_buf);
break;
case IPL4__ParamResult::ALT_proto:
single_value.field_proto = new Socket__API__Definitions::ProtoTuple_template;
single_value.field_proto->decode_text(text_buf);
break;
case IPL4__ParamResult::ALT_userData:
single_value.field_userData = new INTEGER_template;
single_value.field_userData->decode_text(text_buf);
break;
case IPL4__ParamResult::ALT_parentIdx:
single_value.field_parentIdx = new INTEGER_template;
single_value.field_parentIdx->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @IPL4asp_Types.IPL4_ParamResult.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new IPL4__ParamResult_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @IPL4asp_Types.IPL4_ParamResult.");
}
}

boolean IPL4__ParamResult_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean IPL4__ParamResult_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void IPL4__ParamResult_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@IPL4asp_Types.IPL4_ParamResult'");
    }
    if (strcmp("local", param_field) == 0) {
      local().set_param(param);
      return;
    } else if (strcmp("remote", param_field) == 0) {
      remote().set_param(param);
      return;
    } else if (strcmp("proto", param_field) == 0) {
      proto().set_param(param);
      return;
    } else if (strcmp("userData", param_field) == 0) {
      userData().set_param(param);
      return;
    } else if (strcmp("parentIdx", param_field) == 0) {
      parentIdx().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@IPL4asp_Types.IPL4_ParamResult'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    IPL4__ParamResult_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@IPL4asp_Types.IPL4_ParamResult");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "local")) {
      local().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "remote")) {
      remote().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "proto")) {
      proto().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "userData")) {
      userData().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "parentIdx")) {
      parentIdx().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @IPL4asp_Types.IPL4_ParamResult.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    IPL4__ParamResult_template* precondition = new IPL4__ParamResult_template;
    precondition->set_param(*m_p->get_elem(0));
    IPL4__ParamResult_template* implied_template = new IPL4__ParamResult_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = IPL4__ParamResult_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@IPL4asp_Types.IPL4_ParamResult");
  }
  is_ifpresent = param.get_ifpresent();
}

void IPL4__ParamResult_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case IPL4__ParamResult::ALT_local:
single_value.field_local->check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_ParamResult");
return;
case IPL4__ParamResult::ALT_remote:
single_value.field_remote->check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_ParamResult");
return;
case IPL4__ParamResult::ALT_proto:
single_value.field_proto->check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_ParamResult");
return;
case IPL4__ParamResult::ALT_userData:
single_value.field_userData->check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_ParamResult");
return;
case IPL4__ParamResult::ALT_parentIdx:
single_value.field_parentIdx->check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_ParamResult");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @IPL4asp_Types.IPL4_ParamResult.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.IPL4_ParamResult");
}

IPL4__IPAddressType::IPL4__IPAddressType()
{
enum_value = UNBOUND_VALUE;
}

IPL4__IPAddressType::IPL4__IPAddressType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @IPL4asp_Types.IPL4_IPAddressType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

IPL4__IPAddressType::IPL4__IPAddressType(enum_type other_value)
{
enum_value = other_value;
}

IPL4__IPAddressType::IPL4__IPAddressType(const IPL4__IPAddressType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
enum_value = other_value.enum_value;
}

IPL4__IPAddressType& IPL4__IPAddressType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @IPL4asp_Types.IPL4_IPAddressType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

IPL4__IPAddressType& IPL4__IPAddressType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

IPL4__IPAddressType& IPL4__IPAddressType::operator=(const IPL4__IPAddressType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
enum_value = other_value.enum_value;
return *this;
}

boolean IPL4__IPAddressType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_IPAddressType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean IPL4__IPAddressType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value == other_value;
}

boolean IPL4__IPAddressType::operator==(const IPL4__IPAddressType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value == other_value.enum_value;
}

boolean IPL4__IPAddressType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_IPAddressType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean IPL4__IPAddressType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value < other_value;
}

boolean IPL4__IPAddressType::operator<(const IPL4__IPAddressType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value < other_value.enum_value;
}

boolean IPL4__IPAddressType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_IPAddressType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean IPL4__IPAddressType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value > other_value;
}

boolean IPL4__IPAddressType::operator>(const IPL4__IPAddressType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value > other_value.enum_value;
}

const char *IPL4__IPAddressType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case ErrorReadingAddress: return "ErrorReadingAddress";
case IPv4: return "IPv4";
case IPv6: return "IPv6";
default:
return "<unknown>";
}
}

IPL4__IPAddressType::enum_type IPL4__IPAddressType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "ErrorReadingAddress")) return ErrorReadingAddress;
if (!strcmp(str_par, "IPv4")) return IPv4;
if (!strcmp(str_par, "IPv6")) return IPv6;
}
return UNKNOWN_VALUE;
}

boolean IPL4__IPAddressType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int IPL4__IPAddressType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int IPL4__IPAddressType::enum2int(const IPL4__IPAddressType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void IPL4__IPAddressType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @IPL4asp_Types.IPL4_IPAddressType.", int_val);
enum_value = (enum_type)int_val;
}

IPL4__IPAddressType::operator IPL4__IPAddressType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return enum_value;
}

void IPL4__IPAddressType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void IPL4__IPAddressType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@IPL4asp_Types.IPL4_IPAddressType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @IPL4asp_Types.IPL4_IPAddressType.");
  }
}

void IPL4__IPAddressType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
text_buf.push_int(enum_value);
}

void IPL4__IPAddressType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @IPL4asp_Types.IPL4_IPAddressType.", enum_value);
}

void IPL4__IPAddressType_template::copy_template(const IPL4__IPAddressType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new IPL4__IPAddressType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new IPL4__IPAddressType_template(*other_value.implication_.precondition);
implication_.implied_template = new IPL4__IPAddressType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
}
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template()
{
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!IPL4__IPAddressType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType with unknown numeric value %d.", other_value);
single_value = (IPL4__IPAddressType::enum_type)other_value;
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(IPL4__IPAddressType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(const IPL4__IPAddressType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == IPL4__IPAddressType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
single_value = other_value.enum_value;
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(const OPTIONAL<IPL4__IPAddressType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__IPAddressType::enum_type)(const IPL4__IPAddressType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType from an unbound optional field.");
}
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(IPL4__IPAddressType_template* p_precondition, IPL4__IPAddressType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(Dynamic_Match_Interface<IPL4__IPAddressType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<IPL4__IPAddressType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

IPL4__IPAddressType_template::IPL4__IPAddressType_template(const IPL4__IPAddressType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

IPL4__IPAddressType_template::~IPL4__IPAddressType_template()
{
clean_up();
}

boolean IPL4__IPAddressType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean IPL4__IPAddressType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != IPL4__IPAddressType::UNBOUND_VALUE;
}

void IPL4__IPAddressType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::operator=(int other_value)
{
if (!IPL4__IPAddressType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__IPAddressType::enum_type)other_value;
return *this;
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::operator=(IPL4__IPAddressType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::operator=(const IPL4__IPAddressType& other_value)
{
if (other_value.enum_value == IPL4__IPAddressType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @IPL4asp_Types.IPL4_IPAddressType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::operator=(const OPTIONAL<IPL4__IPAddressType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__IPAddressType::enum_type)(const IPL4__IPAddressType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
}
return *this;
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::operator=(const IPL4__IPAddressType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean IPL4__IPAddressType_template::match(IPL4__IPAddressType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
}
return FALSE;
}

boolean IPL4__IPAddressType_template::match(const IPL4__IPAddressType& other_value, boolean) const
{
if (other_value.enum_value == IPL4__IPAddressType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType with an unbound value.");
return match(other_value.enum_value);
}

IPL4__IPAddressType::enum_type IPL4__IPAddressType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return single_value;
}

void IPL4__IPAddressType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new IPL4__IPAddressType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
}
}

IPL4__IPAddressType_template& IPL4__IPAddressType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
return value_list.list_value[list_index];
}

void IPL4__IPAddressType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(IPL4__IPAddressType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void IPL4__IPAddressType_template::log_match(const IPL4__IPAddressType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void IPL4__IPAddressType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
}
}

void IPL4__IPAddressType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (IPL4__IPAddressType::enum_type)text_buf.pull_int().get_val();
if (!IPL4__IPAddressType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new IPL4__IPAddressType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @IPL4asp_Types.IPL4_IPAddressType.");
}
}

boolean IPL4__IPAddressType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean IPL4__IPAddressType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void IPL4__IPAddressType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    IPL4__IPAddressType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    IPL4__IPAddressType::enum_type enum_val = IPL4__IPAddressType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!IPL4__IPAddressType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @IPL4asp_Types.IPL4_IPAddressType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    IPL4__IPAddressType_template* precondition = new IPL4__IPAddressType_template;
    precondition->set_param(*m_p->get_elem(0));
    IPL4__IPAddressType_template* implied_template = new IPL4__IPAddressType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = IPL4__IPAddressType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@IPL4asp_Types.IPL4_IPAddressType");
  }
  is_ifpresent = param.get_ifpresent();
}

void IPL4__IPAddressType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.IPL4_IPAddressType");
}

IPL4__SrtpKeysAndSalts::IPL4__SrtpKeysAndSalts()
{
}

IPL4__SrtpKeysAndSalts::IPL4__SrtpKeysAndSalts(const OCTETSTRING& par_localKey,
    const OCTETSTRING& par_remoteKey,
    const OCTETSTRING& par_localSalt,
    const OCTETSTRING& par_remoteSalt)
  :   field_localKey(par_localKey),
  field_remoteKey(par_remoteKey),
  field_localSalt(par_localSalt),
  field_remoteSalt(par_remoteSalt)
{
}

IPL4__SrtpKeysAndSalts::IPL4__SrtpKeysAndSalts(const IPL4__SrtpKeysAndSalts& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
if (other_value.localKey().is_bound()) field_localKey = other_value.localKey();
else field_localKey.clean_up();
if (other_value.remoteKey().is_bound()) field_remoteKey = other_value.remoteKey();
else field_remoteKey.clean_up();
if (other_value.localSalt().is_bound()) field_localSalt = other_value.localSalt();
else field_localSalt.clean_up();
if (other_value.remoteSalt().is_bound()) field_remoteSalt = other_value.remoteSalt();
else field_remoteSalt.clean_up();
}

void IPL4__SrtpKeysAndSalts::clean_up()
{
field_localKey.clean_up();
field_remoteKey.clean_up();
field_localSalt.clean_up();
field_remoteSalt.clean_up();
}

const TTCN_Typedescriptor_t* IPL4__SrtpKeysAndSalts::get_descriptor() const { return &IPL4__SrtpKeysAndSalts_descr_; }
IPL4__SrtpKeysAndSalts& IPL4__SrtpKeysAndSalts::operator=(const IPL4__SrtpKeysAndSalts& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
  if (other_value.localKey().is_bound()) field_localKey = other_value.localKey();
  else field_localKey.clean_up();
  if (other_value.remoteKey().is_bound()) field_remoteKey = other_value.remoteKey();
  else field_remoteKey.clean_up();
  if (other_value.localSalt().is_bound()) field_localSalt = other_value.localSalt();
  else field_localSalt.clean_up();
  if (other_value.remoteSalt().is_bound()) field_remoteSalt = other_value.remoteSalt();
  else field_remoteSalt.clean_up();
}
return *this;
}

boolean IPL4__SrtpKeysAndSalts::operator==(const IPL4__SrtpKeysAndSalts& other_value) const
{
return field_localKey==other_value.field_localKey
  && field_remoteKey==other_value.field_remoteKey
  && field_localSalt==other_value.field_localSalt
  && field_remoteSalt==other_value.field_remoteSalt;
}

boolean IPL4__SrtpKeysAndSalts::is_bound() const
{
return (field_localKey.is_bound())
  || (field_remoteKey.is_bound())
  || (field_localSalt.is_bound())
  || (field_remoteSalt.is_bound());
}
boolean IPL4__SrtpKeysAndSalts::is_value() const
{
return field_localKey.is_value()
  && field_remoteKey.is_value()
  && field_localSalt.is_value()
  && field_remoteSalt.is_value();
}
void IPL4__SrtpKeysAndSalts::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ localKey := ");
field_localKey.log();
TTCN_Logger::log_event_str(", remoteKey := ");
field_remoteKey.log();
TTCN_Logger::log_event_str(", localSalt := ");
field_localSalt.log();
TTCN_Logger::log_event_str(", remoteSalt := ");
field_remoteSalt.log();
TTCN_Logger::log_event_str(" }");
}

void IPL4__SrtpKeysAndSalts::set_implicit_omit()
{
if (localKey().is_bound()) localKey().set_implicit_omit();
if (remoteKey().is_bound()) remoteKey().set_implicit_omit();
if (localSalt().is_bound()) localSalt().set_implicit_omit();
if (remoteSalt().is_bound()) remoteSalt().set_implicit_omit();
}

void IPL4__SrtpKeysAndSalts::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) localKey().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) remoteKey().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) localSalt().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) remoteSalt().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "localKey")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          localKey().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remoteKey")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remoteKey().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "localSalt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          localSalt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remoteSalt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remoteSalt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.IPL4_SrtpKeysAndSalts: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
  }
}

void IPL4__SrtpKeysAndSalts::encode_text(Text_Buf& text_buf) const
{
field_localKey.encode_text(text_buf);
field_remoteKey.encode_text(text_buf);
field_localSalt.encode_text(text_buf);
field_remoteSalt.encode_text(text_buf);
}

void IPL4__SrtpKeysAndSalts::decode_text(Text_Buf& text_buf)
{
field_localKey.decode_text(text_buf);
field_remoteKey.decode_text(text_buf);
field_localSalt.decode_text(text_buf);
field_remoteSalt.decode_text(text_buf);
}

struct IPL4__SrtpKeysAndSalts_template::single_value_struct {
OCTETSTRING_template field_localKey;
OCTETSTRING_template field_remoteKey;
OCTETSTRING_template field_localSalt;
OCTETSTRING_template field_remoteSalt;
};

void IPL4__SrtpKeysAndSalts_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_localKey = ANY_VALUE;
single_value->field_remoteKey = ANY_VALUE;
single_value->field_localSalt = ANY_VALUE;
single_value->field_remoteSalt = ANY_VALUE;
}
}
}

void IPL4__SrtpKeysAndSalts_template::copy_value(const IPL4__SrtpKeysAndSalts& other_value)
{
single_value = new single_value_struct;
if (other_value.localKey().is_bound()) {
  single_value->field_localKey = other_value.localKey();
} else {
  single_value->field_localKey.clean_up();
}
if (other_value.remoteKey().is_bound()) {
  single_value->field_remoteKey = other_value.remoteKey();
} else {
  single_value->field_remoteKey.clean_up();
}
if (other_value.localSalt().is_bound()) {
  single_value->field_localSalt = other_value.localSalt();
} else {
  single_value->field_localSalt.clean_up();
}
if (other_value.remoteSalt().is_bound()) {
  single_value->field_remoteSalt = other_value.remoteSalt();
} else {
  single_value->field_remoteSalt.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void IPL4__SrtpKeysAndSalts_template::copy_template(const IPL4__SrtpKeysAndSalts_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.localKey().get_selection()) {
single_value->field_localKey = other_value.localKey();
} else {
single_value->field_localKey.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remoteKey().get_selection()) {
single_value->field_remoteKey = other_value.remoteKey();
} else {
single_value->field_remoteKey.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.localSalt().get_selection()) {
single_value->field_localSalt = other_value.localSalt();
} else {
single_value->field_localSalt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remoteSalt().get_selection()) {
single_value->field_remoteSalt = other_value.remoteSalt();
} else {
single_value->field_remoteSalt.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new IPL4__SrtpKeysAndSalts_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new IPL4__SrtpKeysAndSalts_template(*other_value.implication_.precondition);
implication_.implied_template = new IPL4__SrtpKeysAndSalts_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
break;
}
set_selection(other_value);
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template()
{
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template(const IPL4__SrtpKeysAndSalts& other_value)
{
copy_value(other_value);
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template(const OPTIONAL<IPL4__SrtpKeysAndSalts>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const IPL4__SrtpKeysAndSalts&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts from an unbound optional field.");
}
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template(IPL4__SrtpKeysAndSalts_template* p_precondition, IPL4__SrtpKeysAndSalts_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template(Dynamic_Match_Interface<IPL4__SrtpKeysAndSalts>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<IPL4__SrtpKeysAndSalts>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

IPL4__SrtpKeysAndSalts_template::IPL4__SrtpKeysAndSalts_template(const IPL4__SrtpKeysAndSalts_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

IPL4__SrtpKeysAndSalts_template::~IPL4__SrtpKeysAndSalts_template()
{
clean_up();
}

IPL4__SrtpKeysAndSalts_template& IPL4__SrtpKeysAndSalts_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

IPL4__SrtpKeysAndSalts_template& IPL4__SrtpKeysAndSalts_template::operator=(const IPL4__SrtpKeysAndSalts& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

IPL4__SrtpKeysAndSalts_template& IPL4__SrtpKeysAndSalts_template::operator=(const OPTIONAL<IPL4__SrtpKeysAndSalts>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const IPL4__SrtpKeysAndSalts&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
}
return *this;
}

IPL4__SrtpKeysAndSalts_template& IPL4__SrtpKeysAndSalts_template::operator=(const IPL4__SrtpKeysAndSalts_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean IPL4__SrtpKeysAndSalts_template::match(const IPL4__SrtpKeysAndSalts& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.localKey().is_bound()) return FALSE;
if(!single_value->field_localKey.match(other_value.localKey(), legacy))return FALSE;
if(!other_value.remoteKey().is_bound()) return FALSE;
if(!single_value->field_remoteKey.match(other_value.remoteKey(), legacy))return FALSE;
if(!other_value.localSalt().is_bound()) return FALSE;
if(!single_value->field_localSalt.match(other_value.localSalt(), legacy))return FALSE;
if(!other_value.remoteSalt().is_bound()) return FALSE;
if(!single_value->field_remoteSalt.match(other_value.remoteSalt(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
}
return FALSE;
}

boolean IPL4__SrtpKeysAndSalts_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_localKey.is_bound()
 || single_value->field_remoteKey.is_bound()
 || single_value->field_localSalt.is_bound()
 || single_value->field_remoteSalt.is_bound();
}

boolean IPL4__SrtpKeysAndSalts_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_localKey.is_value()
 && single_value->field_remoteKey.is_value()
 && single_value->field_localSalt.is_value()
 && single_value->field_remoteSalt.is_value();
}

void IPL4__SrtpKeysAndSalts_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

IPL4__SrtpKeysAndSalts IPL4__SrtpKeysAndSalts_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
IPL4__SrtpKeysAndSalts ret_val;
if (single_value->field_localKey.is_bound()) {
ret_val.localKey() = single_value->field_localKey.valueof();
}
if (single_value->field_remoteKey.is_bound()) {
ret_val.remoteKey() = single_value->field_remoteKey.valueof();
}
if (single_value->field_localSalt.is_bound()) {
ret_val.localSalt() = single_value->field_localSalt.valueof();
}
if (single_value->field_remoteSalt.is_bound()) {
ret_val.remoteSalt() = single_value->field_remoteSalt.valueof();
}
return ret_val;
}

void IPL4__SrtpKeysAndSalts_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new IPL4__SrtpKeysAndSalts_template[list_length];
}

IPL4__SrtpKeysAndSalts_template& IPL4__SrtpKeysAndSalts_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::localKey()
{
set_specific();
return single_value->field_localKey;
}

const OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::localKey() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field localKey of a non-specific template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
return single_value->field_localKey;
}

OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::remoteKey()
{
set_specific();
return single_value->field_remoteKey;
}

const OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::remoteKey() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remoteKey of a non-specific template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
return single_value->field_remoteKey;
}

OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::localSalt()
{
set_specific();
return single_value->field_localSalt;
}

const OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::localSalt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field localSalt of a non-specific template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
return single_value->field_localSalt;
}

OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::remoteSalt()
{
set_specific();
return single_value->field_remoteSalt;
}

const OCTETSTRING_template& IPL4__SrtpKeysAndSalts_template::remoteSalt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remoteSalt of a non-specific template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
return single_value->field_remoteSalt;
}

int IPL4__SrtpKeysAndSalts_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
  }
  return 0;
}

void IPL4__SrtpKeysAndSalts_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ localKey := ");
single_value->field_localKey.log();
TTCN_Logger::log_event_str(", remoteKey := ");
single_value->field_remoteKey.log();
TTCN_Logger::log_event_str(", localSalt := ");
single_value->field_localSalt.log();
TTCN_Logger::log_event_str(", remoteSalt := ");
single_value->field_remoteSalt.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void IPL4__SrtpKeysAndSalts_template::log_match(const IPL4__SrtpKeysAndSalts& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_localKey.match(match_value.localKey(), legacy)){
TTCN_Logger::log_logmatch_info(".localKey");
single_value->field_localKey.log_match(match_value.localKey(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remoteKey.match(match_value.remoteKey(), legacy)){
TTCN_Logger::log_logmatch_info(".remoteKey");
single_value->field_remoteKey.log_match(match_value.remoteKey(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_localSalt.match(match_value.localSalt(), legacy)){
TTCN_Logger::log_logmatch_info(".localSalt");
single_value->field_localSalt.log_match(match_value.localSalt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remoteSalt.match(match_value.remoteSalt(), legacy)){
TTCN_Logger::log_logmatch_info(".remoteSalt");
single_value->field_remoteSalt.log_match(match_value.remoteSalt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ localKey := ");
single_value->field_localKey.log_match(match_value.localKey(), legacy);
TTCN_Logger::log_event_str(", remoteKey := ");
single_value->field_remoteKey.log_match(match_value.remoteKey(), legacy);
TTCN_Logger::log_event_str(", localSalt := ");
single_value->field_localSalt.log_match(match_value.localSalt(), legacy);
TTCN_Logger::log_event_str(", remoteSalt := ");
single_value->field_remoteSalt.log_match(match_value.remoteSalt(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void IPL4__SrtpKeysAndSalts_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (localKey().is_bound()) localKey().set_implicit_omit();
if (remoteKey().is_bound()) remoteKey().set_implicit_omit();
if (localSalt().is_bound()) localSalt().set_implicit_omit();
if (remoteSalt().is_bound()) remoteSalt().set_implicit_omit();
}

void IPL4__SrtpKeysAndSalts_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_localKey.encode_text(text_buf);
single_value->field_remoteKey.encode_text(text_buf);
single_value->field_localSalt.encode_text(text_buf);
single_value->field_remoteSalt.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
}
}

void IPL4__SrtpKeysAndSalts_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_localKey.decode_text(text_buf);
single_value->field_remoteKey.decode_text(text_buf);
single_value->field_localSalt.decode_text(text_buf);
single_value->field_remoteSalt.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new IPL4__SrtpKeysAndSalts_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts.");
}
}

void IPL4__SrtpKeysAndSalts_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    IPL4__SrtpKeysAndSalts_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @IPL4asp_Types.IPL4_SrtpKeysAndSalts has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) localKey().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) remoteKey().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) localSalt().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) remoteSalt().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "localKey")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          localKey().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remoteKey")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remoteKey().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "localSalt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          localSalt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remoteSalt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remoteSalt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @IPL4asp_Types.IPL4_SrtpKeysAndSalts: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    IPL4__SrtpKeysAndSalts_template* precondition = new IPL4__SrtpKeysAndSalts_template;
    precondition->set_param(*param.get_elem(0));
    IPL4__SrtpKeysAndSalts_template* implied_template = new IPL4__SrtpKeysAndSalts_template;
    implied_template->set_param(*param.get_elem(1));
    *this = IPL4__SrtpKeysAndSalts_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
  }
  is_ifpresent = param.get_ifpresent();
}

void IPL4__SrtpKeysAndSalts_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_localKey.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
single_value->field_remoteKey.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
single_value->field_localSalt.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
single_value->field_remoteSalt.check_restriction(t_res, t_name ? t_name : "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.IPL4_SrtpKeysAndSalts");
}

boolean IPL4__SrtpKeysAndSalts_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean IPL4__SrtpKeysAndSalts_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

IPL4__DigestMethods::IPL4__DigestMethods()
{
enum_value = UNBOUND_VALUE;
}

IPL4__DigestMethods::IPL4__DigestMethods(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @IPL4asp_Types.IPL4_DigestMethods with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

IPL4__DigestMethods::IPL4__DigestMethods(enum_type other_value)
{
enum_value = other_value;
}

IPL4__DigestMethods::IPL4__DigestMethods(const IPL4__DigestMethods& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
enum_value = other_value.enum_value;
}

IPL4__DigestMethods& IPL4__DigestMethods::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @IPL4asp_Types.IPL4_DigestMethods.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

IPL4__DigestMethods& IPL4__DigestMethods::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

IPL4__DigestMethods& IPL4__DigestMethods::operator=(const IPL4__DigestMethods& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
enum_value = other_value.enum_value;
return *this;
}

boolean IPL4__DigestMethods::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_DigestMethods comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean IPL4__DigestMethods::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value == other_value;
}

boolean IPL4__DigestMethods::operator==(const IPL4__DigestMethods& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value == other_value.enum_value;
}

boolean IPL4__DigestMethods::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_DigestMethods comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean IPL4__DigestMethods::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value < other_value;
}

boolean IPL4__DigestMethods::operator<(const IPL4__DigestMethods& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value < other_value.enum_value;
}

boolean IPL4__DigestMethods::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @IPL4asp_Types.IPL4_DigestMethods comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean IPL4__DigestMethods::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value > other_value;
}

boolean IPL4__DigestMethods::operator>(const IPL4__DigestMethods& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value > other_value.enum_value;
}

const char *IPL4__DigestMethods::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case NULL__method: return "NULL_method";
case MD4: return "MD4";
case MD5: return "MD5";
case SHA: return "SHA";
case SHA1: return "SHA1";
case DSS: return "DSS";
case DSS1: return "DSS1";
case ECDSA: return "ECDSA";
case SHA224: return "SHA224";
case SHA256: return "SHA256";
case SHA384: return "SHA384";
case SHA512: return "SHA512";
case MDC2: return "MDC2";
case RIPEMD160: return "RIPEMD160";
case WHIRLPOOL: return "WHIRLPOOL";
default:
return "<unknown>";
}
}

IPL4__DigestMethods::enum_type IPL4__DigestMethods::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "NULL_method")) return NULL__method;
if (!strcmp(str_par, "MD4")) return MD4;
if (!strcmp(str_par, "MD5")) return MD5;
if (!strcmp(str_par, "SHA")) return SHA;
if (!strcmp(str_par, "SHA1")) return SHA1;
if (!strcmp(str_par, "DSS")) return DSS;
if (!strcmp(str_par, "DSS1")) return DSS1;
if (!strcmp(str_par, "ECDSA")) return ECDSA;
if (!strcmp(str_par, "SHA224")) return SHA224;
if (!strcmp(str_par, "SHA256")) return SHA256;
if (!strcmp(str_par, "SHA384")) return SHA384;
if (!strcmp(str_par, "SHA512")) return SHA512;
if (!strcmp(str_par, "MDC2")) return MDC2;
if (!strcmp(str_par, "RIPEMD160")) return RIPEMD160;
if (!strcmp(str_par, "WHIRLPOOL")) return WHIRLPOOL;
}
return UNKNOWN_VALUE;
}

boolean IPL4__DigestMethods::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
case 8:
case 9:
case 10:
case 11:
case 12:
case 13:
case 14:
return TRUE;
default:
return FALSE;
}
}

int IPL4__DigestMethods::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int IPL4__DigestMethods::enum2int(const IPL4__DigestMethods& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void IPL4__DigestMethods::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @IPL4asp_Types.IPL4_DigestMethods.", int_val);
enum_value = (enum_type)int_val;
}

IPL4__DigestMethods::operator IPL4__DigestMethods::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return enum_value;
}

void IPL4__DigestMethods::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void IPL4__DigestMethods::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@IPL4asp_Types.IPL4_DigestMethods");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @IPL4asp_Types.IPL4_DigestMethods.");
  }
}

void IPL4__DigestMethods::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
text_buf.push_int(enum_value);
}

void IPL4__DigestMethods::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @IPL4asp_Types.IPL4_DigestMethods.", enum_value);
}

void IPL4__DigestMethods_template::copy_template(const IPL4__DigestMethods_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new IPL4__DigestMethods_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new IPL4__DigestMethods_template(*other_value.implication_.precondition);
implication_.implied_template = new IPL4__DigestMethods_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
}
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template()
{
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!IPL4__DigestMethods::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods with unknown numeric value %d.", other_value);
single_value = (IPL4__DigestMethods::enum_type)other_value;
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(IPL4__DigestMethods::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(const IPL4__DigestMethods& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == IPL4__DigestMethods::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
single_value = other_value.enum_value;
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(const OPTIONAL<IPL4__DigestMethods>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__DigestMethods::enum_type)(const IPL4__DigestMethods&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods from an unbound optional field.");
}
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(IPL4__DigestMethods_template* p_precondition, IPL4__DigestMethods_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(Dynamic_Match_Interface<IPL4__DigestMethods>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<IPL4__DigestMethods>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

IPL4__DigestMethods_template::IPL4__DigestMethods_template(const IPL4__DigestMethods_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

IPL4__DigestMethods_template::~IPL4__DigestMethods_template()
{
clean_up();
}

boolean IPL4__DigestMethods_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean IPL4__DigestMethods_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != IPL4__DigestMethods::UNBOUND_VALUE;
}

void IPL4__DigestMethods_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::operator=(int other_value)
{
if (!IPL4__DigestMethods::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__DigestMethods::enum_type)other_value;
return *this;
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::operator=(IPL4__DigestMethods::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::operator=(const IPL4__DigestMethods& other_value)
{
if (other_value.enum_value == IPL4__DigestMethods::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @IPL4asp_Types.IPL4_DigestMethods to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::operator=(const OPTIONAL<IPL4__DigestMethods>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (IPL4__DigestMethods::enum_type)(const IPL4__DigestMethods&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
}
return *this;
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::operator=(const IPL4__DigestMethods_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean IPL4__DigestMethods_template::match(IPL4__DigestMethods::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
}
return FALSE;
}

boolean IPL4__DigestMethods_template::match(const IPL4__DigestMethods& other_value, boolean) const
{
if (other_value.enum_value == IPL4__DigestMethods::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods with an unbound value.");
return match(other_value.enum_value);
}

IPL4__DigestMethods::enum_type IPL4__DigestMethods_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return single_value;
}

void IPL4__DigestMethods_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new IPL4__DigestMethods_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
}
}

IPL4__DigestMethods_template& IPL4__DigestMethods_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
return value_list.list_value[list_index];
}

void IPL4__DigestMethods_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(IPL4__DigestMethods::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void IPL4__DigestMethods_template::log_match(const IPL4__DigestMethods& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void IPL4__DigestMethods_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
}
}

void IPL4__DigestMethods_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (IPL4__DigestMethods::enum_type)text_buf.pull_int().get_val();
if (!IPL4__DigestMethods::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new IPL4__DigestMethods_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @IPL4asp_Types.IPL4_DigestMethods.");
}
}

boolean IPL4__DigestMethods_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean IPL4__DigestMethods_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void IPL4__DigestMethods_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    IPL4__DigestMethods_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    IPL4__DigestMethods::enum_type enum_val = IPL4__DigestMethods::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!IPL4__DigestMethods::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @IPL4asp_Types.IPL4_DigestMethods.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    IPL4__DigestMethods_template* precondition = new IPL4__DigestMethods_template;
    precondition->set_param(*m_p->get_elem(0));
    IPL4__DigestMethods_template* implied_template = new IPL4__DigestMethods_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = IPL4__DigestMethods_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@IPL4asp_Types.IPL4_DigestMethods");
  }
  is_ifpresent = param.get_ifpresent();
}

void IPL4__DigestMethods_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@IPL4asp_Types.IPL4_DigestMethods");
}


/* Bodies of functions, altsteps and testcases */

boolean operator==(null_type, const SSL__proto__support& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @IPL4asp_Types.SSL_proto_support.");
return other_value.val_ptr->n_elements == 0;
}

boolean operator==(null_type, const OptionList& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @IPL4asp_Types.OptionList.");
return other_value.val_ptr->n_elements == 0;
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("IPL4asp_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "IPL4asp_Types");
Socket__API__Definitions::module_object.pre_init_module();
current_location.update_lineno(546);
/* IPL4asp_Types.ttcn, line 546 */
const_IPL4__ERROR__GENERAL = Socket__API__Definitions::PortError::ERROR__GENERAL;
current_location.update_lineno(547);
/* IPL4asp_Types.ttcn, line 547 */
const_IPL4__ERROR__INSUFFICIENT__MEMORY = Socket__API__Definitions::PortError::ERROR__INSUFFICIENT__MEMORY;
current_location.update_lineno(548);
/* IPL4asp_Types.ttcn, line 548 */
const_IPL4__ERROR__INVALID__INPUT__PARAMETER = Socket__API__Definitions::PortError::ERROR__INVALID__INPUT__PARAMETER;
current_location.update_lineno(549);
/* IPL4asp_Types.ttcn, line 549 */
const_IPL4__ERROR__UNSUPPORTED__TRANSPORT = Socket__API__Definitions::PortError::ERROR__UNSUPPORTED__PROTOCOL;
current_location.update_lineno(550);
/* IPL4asp_Types.ttcn, line 550 */
const_IPL4__ERROR__SOCKET = Socket__API__Definitions::PortError::ERROR__SOCKET;
current_location.update_lineno(551);
/* IPL4asp_Types.ttcn, line 551 */
const_IPL4__ERROR__HOSTNAME = Socket__API__Definitions::PortError::ERROR__HOSTNAME;
current_location.update_lineno(552);
/* IPL4asp_Types.ttcn, line 552 */
const_IPL4__ERROR__INVALID__CONNECTION = Socket__API__Definitions::PortError::ERROR__INVALID__CONNECTION;
current_location.update_lineno(553);
/* IPL4asp_Types.ttcn, line 553 */
const_IPL4__ERROR__TEMPORARILY__UNAVAILABLE = Socket__API__Definitions::PortError::ERROR__TEMPORARILY__UNAVAILABLE;
current_location.update_lineno(554);
/* IPL4asp_Types.ttcn, line 554 */
const_IPL4__ERROR__AVAILABLE = Socket__API__Definitions::PortError::ERROR__AVAILABLE;
current_location.update_lineno(555);
/* IPL4asp_Types.ttcn, line 555 */
const_IPL4__ERROR__LENGTH = Socket__API__Definitions::PortError::ERROR__LENGTH;
current_location.update_lineno(626);
/* IPL4asp_Types.ttcn, line 626 */
const_c__IPL4__DTLS__SRTP__AES128__CM__SHA1__32__Profile = cs_0;
current_location.update_lineno(627);
/* IPL4asp_Types.ttcn, line 627 */
const_c__IPL4__DTLS__SRTP__AES128__CM__SHA1__80__Profile = cs_1;
current_location.update_lineno(628);
/* IPL4asp_Types.ttcn, line 628 */
const_c__IPL4__DTLS__SRTP__AES128__F8__SHA1__80__Profile = cs_2;
current_location.update_lineno(629);
/* IPL4asp_Types.ttcn, line 629 */
const_c__IPL4__DTLS__SRTP__AES128__F8__SHA1__32__Profile = cs_3;
current_location.update_lineno(630);
/* IPL4asp_Types.ttcn, line 630 */
const_c__IPL4__DTLS__SRTP__NULL__SHA1__80__Profile = cs_4;
current_location.update_lineno(631);
/* IPL4asp_Types.ttcn, line 631 */
const_c__IPL4__DTLS__SRTP__NULL__SHA1__32__Profile = cs_5;
current_location.update_lineno(633);
/* IPL4asp_Types.ttcn, line 633 */
const_c__IPL4__DTLS__SRTP__ALL__KNOWN__Profile = cs_6;
}

void post_init_module()
{
TTCN_Location current_location("IPL4asp_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "IPL4asp_Types");
Socket__API__Definitions::module_object.post_init_module();
}


} /* end of namespace */
