// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "M3UA_Types.hh"

namespace M3UA__Types {

/* Member functions of C++ classes */

M3UA__Protocol__Data::M3UA__Protocol__Data()
{
}

M3UA__Protocol__Data::M3UA__Protocol__Data(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_oPC,
    const OCTETSTRING& par_dPC,
    const OCTETSTRING& par_sI,
    const OCTETSTRING& par_nI,
    const OCTETSTRING& par_mP,
    const OCTETSTRING& par_sLS,
    const OCTETSTRING& par_userProtocolData)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_oPC(par_oPC),
  field_dPC(par_dPC),
  field_sI(par_sI),
  field_nI(par_nI),
  field_mP(par_mP),
  field_sLS(par_sLS),
  field_userProtocolData(par_userProtocolData)
{
}

M3UA__Protocol__Data::M3UA__Protocol__Data(const M3UA__Protocol__Data& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Protocol_Data.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.oPC().is_bound()) field_oPC = other_value.oPC();
else field_oPC.clean_up();
if (other_value.dPC().is_bound()) field_dPC = other_value.dPC();
else field_dPC.clean_up();
if (other_value.sI().is_bound()) field_sI = other_value.sI();
else field_sI.clean_up();
if (other_value.nI().is_bound()) field_nI = other_value.nI();
else field_nI.clean_up();
if (other_value.mP().is_bound()) field_mP = other_value.mP();
else field_mP.clean_up();
if (other_value.sLS().is_bound()) field_sLS = other_value.sLS();
else field_sLS.clean_up();
if (other_value.userProtocolData().is_bound()) field_userProtocolData = other_value.userProtocolData();
else field_userProtocolData.clean_up();
}

void M3UA__Protocol__Data::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_oPC.clean_up();
field_dPC.clean_up();
field_sI.clean_up();
field_nI.clean_up();
field_mP.clean_up();
field_sLS.clean_up();
field_userProtocolData.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Protocol__Data::get_descriptor() const { return &M3UA__Protocol__Data_descr_; }
M3UA__Protocol__Data& M3UA__Protocol__Data::operator=(const M3UA__Protocol__Data& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Protocol_Data.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.oPC().is_bound()) field_oPC = other_value.oPC();
  else field_oPC.clean_up();
  if (other_value.dPC().is_bound()) field_dPC = other_value.dPC();
  else field_dPC.clean_up();
  if (other_value.sI().is_bound()) field_sI = other_value.sI();
  else field_sI.clean_up();
  if (other_value.nI().is_bound()) field_nI = other_value.nI();
  else field_nI.clean_up();
  if (other_value.mP().is_bound()) field_mP = other_value.mP();
  else field_mP.clean_up();
  if (other_value.sLS().is_bound()) field_sLS = other_value.sLS();
  else field_sLS.clean_up();
  if (other_value.userProtocolData().is_bound()) field_userProtocolData = other_value.userProtocolData();
  else field_userProtocolData.clean_up();
}
return *this;
}

boolean M3UA__Protocol__Data::operator==(const M3UA__Protocol__Data& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_oPC==other_value.field_oPC
  && field_dPC==other_value.field_dPC
  && field_sI==other_value.field_sI
  && field_nI==other_value.field_nI
  && field_mP==other_value.field_mP
  && field_sLS==other_value.field_sLS
  && field_userProtocolData==other_value.field_userProtocolData;
}

boolean M3UA__Protocol__Data::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_oPC.is_bound())
  || (field_dPC.is_bound())
  || (field_sI.is_bound())
  || (field_nI.is_bound())
  || (field_mP.is_bound())
  || (field_sLS.is_bound())
  || (field_userProtocolData.is_bound());
}
boolean M3UA__Protocol__Data::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_oPC.is_value()
  && field_dPC.is_value()
  && field_sI.is_value()
  && field_nI.is_value()
  && field_mP.is_value()
  && field_sLS.is_value()
  && field_userProtocolData.is_value();
}
void M3UA__Protocol__Data::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", oPC := ");
field_oPC.log();
TTCN_Logger::log_event_str(", dPC := ");
field_dPC.log();
TTCN_Logger::log_event_str(", sI := ");
field_sI.log();
TTCN_Logger::log_event_str(", nI := ");
field_nI.log();
TTCN_Logger::log_event_str(", mP := ");
field_mP.log();
TTCN_Logger::log_event_str(", sLS := ");
field_sLS.log();
TTCN_Logger::log_event_str(", userProtocolData := ");
field_userProtocolData.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Protocol__Data::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (oPC().is_bound()) oPC().set_implicit_omit();
if (dPC().is_bound()) dPC().set_implicit_omit();
if (sI().is_bound()) sI().set_implicit_omit();
if (nI().is_bound()) nI().set_implicit_omit();
if (mP().is_bound()) mP().set_implicit_omit();
if (sLS().is_bound()) sLS().set_implicit_omit();
if (userProtocolData().is_bound()) userProtocolData().set_implicit_omit();
}

void M3UA__Protocol__Data::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Protocol_Data has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) oPC().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) dPC().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nI().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) mP().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) sLS().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) userProtocolData().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "oPC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          oPC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dPC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dPC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mP")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mP().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sLS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sLS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userProtocolData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userProtocolData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Protocol_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Protocol_Data");
  }
}

void M3UA__Protocol__Data::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_oPC.encode_text(text_buf);
field_dPC.encode_text(text_buf);
field_sI.encode_text(text_buf);
field_nI.encode_text(text_buf);
field_mP.encode_text(text_buf);
field_sLS.encode_text(text_buf);
field_userProtocolData.encode_text(text_buf);
}

void M3UA__Protocol__Data::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_oPC.decode_text(text_buf);
field_dPC.decode_text(text_buf);
field_sI.decode_text(text_buf);
field_nI.decode_text(text_buf);
field_mP.decode_text(text_buf);
field_sLS.decode_text(text_buf);
field_userProtocolData.decode_text(text_buf);
}

void M3UA__Protocol__Data::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Protocol__Data::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Protocol__Data::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Protocol__Data_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Protocol__Data_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Protocol__Data_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_oPC.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_dPC.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_sI.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_nI.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_mP.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_sLS.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_8_force_omit(8, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_userProtocolData.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Protocol__Data::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Protocol__Data_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, OCTETSTRING_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Protocol__Data_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 9;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(9);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[6].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[6].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[7].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[7].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[8].level = myleaf.body.node.nodes[8]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[8].pos = myleaf.body.node.nodes[8]->curr_pos.pos;
  encoded_length += field_oPC.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_dPC.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_sI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_nI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_mP.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_sLS.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[7]);
  encoded_length += field_userProtocolData.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[8]);
  return myleaf.length = encoded_length;
}

struct M3UA__Protocol__Data_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_oPC;
OCTETSTRING_template field_dPC;
OCTETSTRING_template field_sI;
OCTETSTRING_template field_nI;
OCTETSTRING_template field_mP;
OCTETSTRING_template field_sLS;
OCTETSTRING_template field_userProtocolData;
};

void M3UA__Protocol__Data_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_oPC = ANY_VALUE;
single_value->field_dPC = ANY_VALUE;
single_value->field_sI = ANY_VALUE;
single_value->field_nI = ANY_VALUE;
single_value->field_mP = ANY_VALUE;
single_value->field_sLS = ANY_VALUE;
single_value->field_userProtocolData = ANY_VALUE;
}
}
}

void M3UA__Protocol__Data_template::copy_value(const M3UA__Protocol__Data& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.oPC().is_bound()) {
  single_value->field_oPC = other_value.oPC();
} else {
  single_value->field_oPC.clean_up();
}
if (other_value.dPC().is_bound()) {
  single_value->field_dPC = other_value.dPC();
} else {
  single_value->field_dPC.clean_up();
}
if (other_value.sI().is_bound()) {
  single_value->field_sI = other_value.sI();
} else {
  single_value->field_sI.clean_up();
}
if (other_value.nI().is_bound()) {
  single_value->field_nI = other_value.nI();
} else {
  single_value->field_nI.clean_up();
}
if (other_value.mP().is_bound()) {
  single_value->field_mP = other_value.mP();
} else {
  single_value->field_mP.clean_up();
}
if (other_value.sLS().is_bound()) {
  single_value->field_sLS = other_value.sLS();
} else {
  single_value->field_sLS.clean_up();
}
if (other_value.userProtocolData().is_bound()) {
  single_value->field_userProtocolData = other_value.userProtocolData();
} else {
  single_value->field_userProtocolData.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Protocol__Data_template::copy_template(const M3UA__Protocol__Data_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.oPC().get_selection()) {
single_value->field_oPC = other_value.oPC();
} else {
single_value->field_oPC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dPC().get_selection()) {
single_value->field_dPC = other_value.dPC();
} else {
single_value->field_dPC.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sI().get_selection()) {
single_value->field_sI = other_value.sI();
} else {
single_value->field_sI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nI().get_selection()) {
single_value->field_nI = other_value.nI();
} else {
single_value->field_nI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mP().get_selection()) {
single_value->field_mP = other_value.mP();
} else {
single_value->field_mP.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sLS().get_selection()) {
single_value->field_sLS = other_value.sLS();
} else {
single_value->field_sLS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userProtocolData().get_selection()) {
single_value->field_userProtocolData = other_value.userProtocolData();
} else {
single_value->field_userProtocolData.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Protocol__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Protocol__Data_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Protocol__Data_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Protocol_Data.");
break;
}
set_selection(other_value);
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template()
{
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template(const M3UA__Protocol__Data& other_value)
{
copy_value(other_value);
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template(const OPTIONAL<M3UA__Protocol__Data>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Protocol__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Protocol_Data from an unbound optional field.");
}
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template(M3UA__Protocol__Data_template* p_precondition, M3UA__Protocol__Data_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template(Dynamic_Match_Interface<M3UA__Protocol__Data>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Protocol__Data>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Protocol__Data_template::M3UA__Protocol__Data_template(const M3UA__Protocol__Data_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Protocol__Data_template::~M3UA__Protocol__Data_template()
{
clean_up();
}

M3UA__Protocol__Data_template& M3UA__Protocol__Data_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Protocol__Data_template& M3UA__Protocol__Data_template::operator=(const M3UA__Protocol__Data& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Protocol__Data_template& M3UA__Protocol__Data_template::operator=(const OPTIONAL<M3UA__Protocol__Data>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Protocol__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Protocol_Data.");
}
return *this;
}

M3UA__Protocol__Data_template& M3UA__Protocol__Data_template::operator=(const M3UA__Protocol__Data_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Protocol__Data_template::match(const M3UA__Protocol__Data& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.oPC().is_bound()) return FALSE;
if(!single_value->field_oPC.match(other_value.oPC(), legacy))return FALSE;
if(!other_value.dPC().is_bound()) return FALSE;
if(!single_value->field_dPC.match(other_value.dPC(), legacy))return FALSE;
if(!other_value.sI().is_bound()) return FALSE;
if(!single_value->field_sI.match(other_value.sI(), legacy))return FALSE;
if(!other_value.nI().is_bound()) return FALSE;
if(!single_value->field_nI.match(other_value.nI(), legacy))return FALSE;
if(!other_value.mP().is_bound()) return FALSE;
if(!single_value->field_mP.match(other_value.mP(), legacy))return FALSE;
if(!other_value.sLS().is_bound()) return FALSE;
if(!single_value->field_sLS.match(other_value.sLS(), legacy))return FALSE;
if(!other_value.userProtocolData().is_bound()) return FALSE;
if(!single_value->field_userProtocolData.match(other_value.userProtocolData(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Protocol_Data.");
}
return FALSE;
}

boolean M3UA__Protocol__Data_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_oPC.is_bound()
 || single_value->field_dPC.is_bound()
 || single_value->field_sI.is_bound()
 || single_value->field_nI.is_bound()
 || single_value->field_mP.is_bound()
 || single_value->field_sLS.is_bound()
 || single_value->field_userProtocolData.is_bound();
}

boolean M3UA__Protocol__Data_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_oPC.is_value()
 && single_value->field_dPC.is_value()
 && single_value->field_sI.is_value()
 && single_value->field_nI.is_value()
 && single_value->field_mP.is_value()
 && single_value->field_sLS.is_value()
 && single_value->field_userProtocolData.is_value();
}

void M3UA__Protocol__Data_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Protocol__Data M3UA__Protocol__Data_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
M3UA__Protocol__Data ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_oPC.is_bound()) {
ret_val.oPC() = single_value->field_oPC.valueof();
}
if (single_value->field_dPC.is_bound()) {
ret_val.dPC() = single_value->field_dPC.valueof();
}
if (single_value->field_sI.is_bound()) {
ret_val.sI() = single_value->field_sI.valueof();
}
if (single_value->field_nI.is_bound()) {
ret_val.nI() = single_value->field_nI.valueof();
}
if (single_value->field_mP.is_bound()) {
ret_val.mP() = single_value->field_mP.valueof();
}
if (single_value->field_sLS.is_bound()) {
ret_val.sLS() = single_value->field_sLS.valueof();
}
if (single_value->field_userProtocolData.is_bound()) {
ret_val.userProtocolData() = single_value->field_userProtocolData.valueof();
}
return ret_val;
}

void M3UA__Protocol__Data_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Protocol_Data.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Protocol__Data_template[list_length];
}

M3UA__Protocol__Data_template& M3UA__Protocol__Data_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Protocol_Data.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Protocol_Data.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Protocol__Data_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Protocol__Data_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Protocol__Data_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::oPC()
{
set_specific();
return single_value->field_oPC;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::oPC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field oPC of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_oPC;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::dPC()
{
set_specific();
return single_value->field_dPC;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::dPC() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dPC of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_dPC;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::sI()
{
set_specific();
return single_value->field_sI;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::sI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sI of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_sI;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::nI()
{
set_specific();
return single_value->field_nI;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::nI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nI of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_nI;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::mP()
{
set_specific();
return single_value->field_mP;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::mP() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mP of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_mP;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::sLS()
{
set_specific();
return single_value->field_sLS;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::sLS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sLS of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_sLS;
}

OCTETSTRING_template& M3UA__Protocol__Data_template::userProtocolData()
{
set_specific();
return single_value->field_userProtocolData;
}

const OCTETSTRING_template& M3UA__Protocol__Data_template::userProtocolData() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userProtocolData of a non-specific template of type @M3UA_Types.M3UA_Protocol_Data.");
return single_value->field_userProtocolData;
}

int M3UA__Protocol__Data_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 9;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Protocol_Data containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Protocol_Data.");
  }
  return 0;
}

void M3UA__Protocol__Data_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", oPC := ");
single_value->field_oPC.log();
TTCN_Logger::log_event_str(", dPC := ");
single_value->field_dPC.log();
TTCN_Logger::log_event_str(", sI := ");
single_value->field_sI.log();
TTCN_Logger::log_event_str(", nI := ");
single_value->field_nI.log();
TTCN_Logger::log_event_str(", mP := ");
single_value->field_mP.log();
TTCN_Logger::log_event_str(", sLS := ");
single_value->field_sLS.log();
TTCN_Logger::log_event_str(", userProtocolData := ");
single_value->field_userProtocolData.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Protocol__Data_template::log_match(const M3UA__Protocol__Data& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_oPC.match(match_value.oPC(), legacy)){
TTCN_Logger::log_logmatch_info(".oPC");
single_value->field_oPC.log_match(match_value.oPC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dPC.match(match_value.dPC(), legacy)){
TTCN_Logger::log_logmatch_info(".dPC");
single_value->field_dPC.log_match(match_value.dPC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sI.match(match_value.sI(), legacy)){
TTCN_Logger::log_logmatch_info(".sI");
single_value->field_sI.log_match(match_value.sI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nI.match(match_value.nI(), legacy)){
TTCN_Logger::log_logmatch_info(".nI");
single_value->field_nI.log_match(match_value.nI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mP.match(match_value.mP(), legacy)){
TTCN_Logger::log_logmatch_info(".mP");
single_value->field_mP.log_match(match_value.mP(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sLS.match(match_value.sLS(), legacy)){
TTCN_Logger::log_logmatch_info(".sLS");
single_value->field_sLS.log_match(match_value.sLS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_userProtocolData.match(match_value.userProtocolData(), legacy)){
TTCN_Logger::log_logmatch_info(".userProtocolData");
single_value->field_userProtocolData.log_match(match_value.userProtocolData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", oPC := ");
single_value->field_oPC.log_match(match_value.oPC(), legacy);
TTCN_Logger::log_event_str(", dPC := ");
single_value->field_dPC.log_match(match_value.dPC(), legacy);
TTCN_Logger::log_event_str(", sI := ");
single_value->field_sI.log_match(match_value.sI(), legacy);
TTCN_Logger::log_event_str(", nI := ");
single_value->field_nI.log_match(match_value.nI(), legacy);
TTCN_Logger::log_event_str(", mP := ");
single_value->field_mP.log_match(match_value.mP(), legacy);
TTCN_Logger::log_event_str(", sLS := ");
single_value->field_sLS.log_match(match_value.sLS(), legacy);
TTCN_Logger::log_event_str(", userProtocolData := ");
single_value->field_userProtocolData.log_match(match_value.userProtocolData(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Protocol__Data_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (oPC().is_bound()) oPC().set_implicit_omit();
if (dPC().is_bound()) dPC().set_implicit_omit();
if (sI().is_bound()) sI().set_implicit_omit();
if (nI().is_bound()) nI().set_implicit_omit();
if (mP().is_bound()) mP().set_implicit_omit();
if (sLS().is_bound()) sLS().set_implicit_omit();
if (userProtocolData().is_bound()) userProtocolData().set_implicit_omit();
}

void M3UA__Protocol__Data_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_oPC.encode_text(text_buf);
single_value->field_dPC.encode_text(text_buf);
single_value->field_sI.encode_text(text_buf);
single_value->field_nI.encode_text(text_buf);
single_value->field_mP.encode_text(text_buf);
single_value->field_sLS.encode_text(text_buf);
single_value->field_userProtocolData.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Protocol_Data.");
}
}

void M3UA__Protocol__Data_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_oPC.decode_text(text_buf);
single_value->field_dPC.decode_text(text_buf);
single_value->field_sI.decode_text(text_buf);
single_value->field_nI.decode_text(text_buf);
single_value->field_mP.decode_text(text_buf);
single_value->field_sLS.decode_text(text_buf);
single_value->field_userProtocolData.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Protocol__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Protocol_Data.");
}
}

void M3UA__Protocol__Data_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Protocol__Data_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Protocol_Data has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) oPC().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) dPC().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nI().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) mP().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) sLS().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) userProtocolData().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "oPC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          oPC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dPC")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dPC().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mP")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mP().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sLS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sLS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userProtocolData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userProtocolData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Protocol_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Protocol__Data_template* precondition = new M3UA__Protocol__Data_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Protocol__Data_template* implied_template = new M3UA__Protocol__Data_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Protocol__Data_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Protocol_Data");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Protocol__Data_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_oPC.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_dPC.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_sI.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_nI.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_mP.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_sLS.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
single_value->field_userProtocolData.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Protocol_Data");
}

boolean M3UA__Protocol__Data_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Protocol__Data_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Info__String::M3UA__Info__String()
{
}

M3UA__Info__String::M3UA__Info__String(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_infoString)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_infoString(par_infoString)
{
}

M3UA__Info__String::M3UA__Info__String(const M3UA__Info__String& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Info_String.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.infoString().is_bound()) field_infoString = other_value.infoString();
else field_infoString.clean_up();
}

void M3UA__Info__String::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_infoString.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Info__String::get_descriptor() const { return &M3UA__Info__String_descr_; }
M3UA__Info__String& M3UA__Info__String::operator=(const M3UA__Info__String& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Info_String.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.infoString().is_bound()) field_infoString = other_value.infoString();
  else field_infoString.clean_up();
}
return *this;
}

boolean M3UA__Info__String::operator==(const M3UA__Info__String& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_infoString==other_value.field_infoString;
}

boolean M3UA__Info__String::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_infoString.is_bound());
}
boolean M3UA__Info__String::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_infoString.is_value();
}
void M3UA__Info__String::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", infoString := ");
field_infoString.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Info__String::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (infoString().is_bound()) infoString().set_implicit_omit();
}

void M3UA__Info__String::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Info_String has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) infoString().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "infoString")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          infoString().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Info_String: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Info_String");
  }
}

void M3UA__Info__String::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_infoString.encode_text(text_buf);
}

void M3UA__Info__String::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_infoString.decode_text(text_buf);
}

void M3UA__Info__String::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Info__String::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Info__String::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Info__String_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Info__String_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Info__String_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__OCT0__255_descr_.raw->forceomit);
  decoded_field_length = field_infoString.RAW_decode(M3UA__OCT0__255_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Info__String::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Info__String_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__OCT0__255_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Info__String_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_infoString.RAW_encode(M3UA__OCT0__255_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Info__String_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_infoString;
};

void M3UA__Info__String_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_infoString = ANY_VALUE;
}
}
}

void M3UA__Info__String_template::copy_value(const M3UA__Info__String& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.infoString().is_bound()) {
  single_value->field_infoString = other_value.infoString();
} else {
  single_value->field_infoString.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Info__String_template::copy_template(const M3UA__Info__String_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.infoString().get_selection()) {
single_value->field_infoString = other_value.infoString();
} else {
single_value->field_infoString.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Info__String_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Info__String_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Info__String_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Info_String.");
break;
}
set_selection(other_value);
}

M3UA__Info__String_template::M3UA__Info__String_template()
{
}

M3UA__Info__String_template::M3UA__Info__String_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Info__String_template::M3UA__Info__String_template(const M3UA__Info__String& other_value)
{
copy_value(other_value);
}

M3UA__Info__String_template::M3UA__Info__String_template(const OPTIONAL<M3UA__Info__String>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Info__String&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Info_String from an unbound optional field.");
}
}

M3UA__Info__String_template::M3UA__Info__String_template(M3UA__Info__String_template* p_precondition, M3UA__Info__String_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Info__String_template::M3UA__Info__String_template(Dynamic_Match_Interface<M3UA__Info__String>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Info__String>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Info__String_template::M3UA__Info__String_template(const M3UA__Info__String_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Info__String_template::~M3UA__Info__String_template()
{
clean_up();
}

M3UA__Info__String_template& M3UA__Info__String_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Info__String_template& M3UA__Info__String_template::operator=(const M3UA__Info__String& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Info__String_template& M3UA__Info__String_template::operator=(const OPTIONAL<M3UA__Info__String>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Info__String&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Info_String.");
}
return *this;
}

M3UA__Info__String_template& M3UA__Info__String_template::operator=(const M3UA__Info__String_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Info__String_template::match(const M3UA__Info__String& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.infoString().is_bound()) return FALSE;
if(!single_value->field_infoString.match(other_value.infoString(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Info_String.");
}
return FALSE;
}

boolean M3UA__Info__String_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_infoString.is_bound();
}

boolean M3UA__Info__String_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_infoString.is_value();
}

void M3UA__Info__String_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Info__String M3UA__Info__String_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Info_String.");
M3UA__Info__String ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_infoString.is_bound()) {
ret_val.infoString() = single_value->field_infoString.valueof();
}
return ret_val;
}

void M3UA__Info__String_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Info_String.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Info__String_template[list_length];
}

M3UA__Info__String_template& M3UA__Info__String_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Info_String.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Info_String.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Info__String_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Info__String_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Info_String.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Info__String_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Info__String_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Info_String.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Info__String_template::infoString()
{
set_specific();
return single_value->field_infoString;
}

const OCTETSTRING_template& M3UA__Info__String_template::infoString() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field infoString of a non-specific template of type @M3UA_Types.M3UA_Info_String.");
return single_value->field_infoString;
}

int M3UA__Info__String_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Info_String containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Info_String.");
  }
  return 0;
}

void M3UA__Info__String_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", infoString := ");
single_value->field_infoString.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Info__String_template::log_match(const M3UA__Info__String& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_infoString.match(match_value.infoString(), legacy)){
TTCN_Logger::log_logmatch_info(".infoString");
single_value->field_infoString.log_match(match_value.infoString(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", infoString := ");
single_value->field_infoString.log_match(match_value.infoString(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Info__String_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (infoString().is_bound()) infoString().set_implicit_omit();
}

void M3UA__Info__String_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_infoString.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Info_String.");
}
}

void M3UA__Info__String_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_infoString.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Info__String_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Info_String.");
}
}

void M3UA__Info__String_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Info__String_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Info_String has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) infoString().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "infoString")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          infoString().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Info_String: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Info__String_template* precondition = new M3UA__Info__String_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Info__String_template* implied_template = new M3UA__Info__String_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Info__String_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Info_String");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Info__String_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Info_String");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Info_String");
single_value->field_infoString.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Info_String");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Info_String");
}

boolean M3UA__Info__String_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Info__String_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Concerned__Destination::M3UA__Concerned__Destination()
{
}

M3UA__Concerned__Destination::M3UA__Concerned__Destination(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_reserved,
    const OCTETSTRING& par_concernedDestination)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_reserved(par_reserved),
  field_concernedDestination(par_concernedDestination)
{
}

M3UA__Concerned__Destination::M3UA__Concerned__Destination(const M3UA__Concerned__Destination& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Concerned_Destination.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.concernedDestination().is_bound()) field_concernedDestination = other_value.concernedDestination();
else field_concernedDestination.clean_up();
}

void M3UA__Concerned__Destination::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_reserved.clean_up();
field_concernedDestination.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Concerned__Destination::get_descriptor() const { return &M3UA__Concerned__Destination_descr_; }
M3UA__Concerned__Destination& M3UA__Concerned__Destination::operator=(const M3UA__Concerned__Destination& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Concerned_Destination.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.concernedDestination().is_bound()) field_concernedDestination = other_value.concernedDestination();
  else field_concernedDestination.clean_up();
}
return *this;
}

boolean M3UA__Concerned__Destination::operator==(const M3UA__Concerned__Destination& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_reserved==other_value.field_reserved
  && field_concernedDestination==other_value.field_concernedDestination;
}

boolean M3UA__Concerned__Destination::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_reserved.is_bound())
  || (field_concernedDestination.is_bound());
}
boolean M3UA__Concerned__Destination::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_reserved.is_value()
  && field_concernedDestination.is_value();
}
void M3UA__Concerned__Destination::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", concernedDestination := ");
field_concernedDestination.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Concerned__Destination::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (concernedDestination().is_bound()) concernedDestination().set_implicit_omit();
}

void M3UA__Concerned__Destination::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Concerned_Destination has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) concernedDestination().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "concernedDestination")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          concernedDestination().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Concerned_Destination: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Concerned_Destination");
  }
}

void M3UA__Concerned__Destination::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_reserved.encode_text(text_buf);
field_concernedDestination.encode_text(text_buf);
}

void M3UA__Concerned__Destination::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_reserved.decode_text(text_buf);
field_concernedDestination.decode_text(text_buf);
}

void M3UA__Concerned__Destination::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Concerned__Destination::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Concerned__Destination::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Concerned__Destination_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Concerned__Destination_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Concerned__Destination_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_concernedDestination.RAW_decode(General__Types::OCT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Concerned__Destination::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Concerned__Destination_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT3_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Concerned__Destination_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_reserved.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_concernedDestination.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct M3UA__Concerned__Destination_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_reserved;
OCTETSTRING_template field_concernedDestination;
};

void M3UA__Concerned__Destination_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
single_value->field_concernedDestination = ANY_VALUE;
}
}
}

void M3UA__Concerned__Destination_template::copy_value(const M3UA__Concerned__Destination& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.concernedDestination().is_bound()) {
  single_value->field_concernedDestination = other_value.concernedDestination();
} else {
  single_value->field_concernedDestination.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Concerned__Destination_template::copy_template(const M3UA__Concerned__Destination_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.concernedDestination().get_selection()) {
single_value->field_concernedDestination = other_value.concernedDestination();
} else {
single_value->field_concernedDestination.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Concerned__Destination_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Concerned__Destination_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Concerned__Destination_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Concerned_Destination.");
break;
}
set_selection(other_value);
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template()
{
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template(const M3UA__Concerned__Destination& other_value)
{
copy_value(other_value);
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template(const OPTIONAL<M3UA__Concerned__Destination>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Concerned__Destination&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Concerned_Destination from an unbound optional field.");
}
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template(M3UA__Concerned__Destination_template* p_precondition, M3UA__Concerned__Destination_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template(Dynamic_Match_Interface<M3UA__Concerned__Destination>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Concerned__Destination>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Concerned__Destination_template::M3UA__Concerned__Destination_template(const M3UA__Concerned__Destination_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Concerned__Destination_template::~M3UA__Concerned__Destination_template()
{
clean_up();
}

M3UA__Concerned__Destination_template& M3UA__Concerned__Destination_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Concerned__Destination_template& M3UA__Concerned__Destination_template::operator=(const M3UA__Concerned__Destination& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Concerned__Destination_template& M3UA__Concerned__Destination_template::operator=(const OPTIONAL<M3UA__Concerned__Destination>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Concerned__Destination&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Concerned_Destination.");
}
return *this;
}

M3UA__Concerned__Destination_template& M3UA__Concerned__Destination_template::operator=(const M3UA__Concerned__Destination_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Concerned__Destination_template::match(const M3UA__Concerned__Destination& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.concernedDestination().is_bound()) return FALSE;
if(!single_value->field_concernedDestination.match(other_value.concernedDestination(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Concerned_Destination.");
}
return FALSE;
}

boolean M3UA__Concerned__Destination_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_reserved.is_bound()
 || single_value->field_concernedDestination.is_bound();
}

boolean M3UA__Concerned__Destination_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_reserved.is_value()
 && single_value->field_concernedDestination.is_value();
}

void M3UA__Concerned__Destination_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Concerned__Destination M3UA__Concerned__Destination_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Concerned_Destination.");
M3UA__Concerned__Destination ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_concernedDestination.is_bound()) {
ret_val.concernedDestination() = single_value->field_concernedDestination.valueof();
}
return ret_val;
}

void M3UA__Concerned__Destination_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Concerned_Destination.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Concerned__Destination_template[list_length];
}

M3UA__Concerned__Destination_template& M3UA__Concerned__Destination_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Concerned_Destination.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Concerned_Destination.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Concerned__Destination_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Concerned__Destination_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Concerned_Destination.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Concerned__Destination_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Concerned__Destination_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Concerned_Destination.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Concerned__Destination_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const OCTETSTRING_template& M3UA__Concerned__Destination_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @M3UA_Types.M3UA_Concerned_Destination.");
return single_value->field_reserved;
}

OCTETSTRING_template& M3UA__Concerned__Destination_template::concernedDestination()
{
set_specific();
return single_value->field_concernedDestination;
}

const OCTETSTRING_template& M3UA__Concerned__Destination_template::concernedDestination() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field concernedDestination of a non-specific template of type @M3UA_Types.M3UA_Concerned_Destination.");
return single_value->field_concernedDestination;
}

int M3UA__Concerned__Destination_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Concerned_Destination containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Concerned_Destination.");
  }
  return 0;
}

void M3UA__Concerned__Destination_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", concernedDestination := ");
single_value->field_concernedDestination.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Concerned__Destination_template::log_match(const M3UA__Concerned__Destination& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_concernedDestination.match(match_value.concernedDestination(), legacy)){
TTCN_Logger::log_logmatch_info(".concernedDestination");
single_value->field_concernedDestination.log_match(match_value.concernedDestination(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", concernedDestination := ");
single_value->field_concernedDestination.log_match(match_value.concernedDestination(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Concerned__Destination_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (concernedDestination().is_bound()) concernedDestination().set_implicit_omit();
}

void M3UA__Concerned__Destination_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
single_value->field_concernedDestination.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Concerned_Destination.");
}
}

void M3UA__Concerned__Destination_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
single_value->field_concernedDestination.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Concerned__Destination_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Concerned_Destination.");
}
}

void M3UA__Concerned__Destination_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Concerned__Destination_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Concerned_Destination has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) concernedDestination().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "concernedDestination")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          concernedDestination().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Concerned_Destination: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Concerned__Destination_template* precondition = new M3UA__Concerned__Destination_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Concerned__Destination_template* implied_template = new M3UA__Concerned__Destination_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Concerned__Destination_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Concerned_Destination");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Concerned__Destination_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Concerned_Destination");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Concerned_Destination");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Concerned_Destination");
single_value->field_concernedDestination.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Concerned_Destination");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Concerned_Destination");
}

boolean M3UA__Concerned__Destination_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Concerned__Destination_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Congestion__Indicators::M3UA__Congestion__Indicators()
{
}

M3UA__Congestion__Indicators::M3UA__Congestion__Indicators(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_reserved,
    const OCTETSTRING& par_congestionLevel)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_reserved(par_reserved),
  field_congestionLevel(par_congestionLevel)
{
}

M3UA__Congestion__Indicators::M3UA__Congestion__Indicators(const M3UA__Congestion__Indicators& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Congestion_Indicators.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.congestionLevel().is_bound()) field_congestionLevel = other_value.congestionLevel();
else field_congestionLevel.clean_up();
}

void M3UA__Congestion__Indicators::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_reserved.clean_up();
field_congestionLevel.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Congestion__Indicators::get_descriptor() const { return &M3UA__Congestion__Indicators_descr_; }
M3UA__Congestion__Indicators& M3UA__Congestion__Indicators::operator=(const M3UA__Congestion__Indicators& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Congestion_Indicators.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.congestionLevel().is_bound()) field_congestionLevel = other_value.congestionLevel();
  else field_congestionLevel.clean_up();
}
return *this;
}

boolean M3UA__Congestion__Indicators::operator==(const M3UA__Congestion__Indicators& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_reserved==other_value.field_reserved
  && field_congestionLevel==other_value.field_congestionLevel;
}

boolean M3UA__Congestion__Indicators::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_reserved.is_bound())
  || (field_congestionLevel.is_bound());
}
boolean M3UA__Congestion__Indicators::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_reserved.is_value()
  && field_congestionLevel.is_value();
}
void M3UA__Congestion__Indicators::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", congestionLevel := ");
field_congestionLevel.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Congestion__Indicators::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (congestionLevel().is_bound()) congestionLevel().set_implicit_omit();
}

void M3UA__Congestion__Indicators::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Congestion_Indicators has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) congestionLevel().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "congestionLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          congestionLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Congestion_Indicators: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Congestion_Indicators");
  }
}

void M3UA__Congestion__Indicators::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_reserved.encode_text(text_buf);
field_congestionLevel.encode_text(text_buf);
}

void M3UA__Congestion__Indicators::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_reserved.decode_text(text_buf);
field_congestionLevel.decode_text(text_buf);
}

void M3UA__Congestion__Indicators::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Congestion__Indicators::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Congestion__Indicators::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Congestion__Indicators_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Congestion__Indicators_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Congestion__Indicators_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_congestionLevel.RAW_decode(General__Types::OCT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Congestion__Indicators::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Congestion__Indicators_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT3_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Congestion__Indicators_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_reserved.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_congestionLevel.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct M3UA__Congestion__Indicators_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_reserved;
OCTETSTRING_template field_congestionLevel;
};

void M3UA__Congestion__Indicators_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
single_value->field_congestionLevel = ANY_VALUE;
}
}
}

void M3UA__Congestion__Indicators_template::copy_value(const M3UA__Congestion__Indicators& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.congestionLevel().is_bound()) {
  single_value->field_congestionLevel = other_value.congestionLevel();
} else {
  single_value->field_congestionLevel.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Congestion__Indicators_template::copy_template(const M3UA__Congestion__Indicators_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.congestionLevel().get_selection()) {
single_value->field_congestionLevel = other_value.congestionLevel();
} else {
single_value->field_congestionLevel.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Congestion__Indicators_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Congestion__Indicators_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Congestion__Indicators_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Congestion_Indicators.");
break;
}
set_selection(other_value);
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template()
{
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template(const M3UA__Congestion__Indicators& other_value)
{
copy_value(other_value);
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template(const OPTIONAL<M3UA__Congestion__Indicators>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Congestion__Indicators&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Congestion_Indicators from an unbound optional field.");
}
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template(M3UA__Congestion__Indicators_template* p_precondition, M3UA__Congestion__Indicators_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template(Dynamic_Match_Interface<M3UA__Congestion__Indicators>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Congestion__Indicators>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Congestion__Indicators_template::M3UA__Congestion__Indicators_template(const M3UA__Congestion__Indicators_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Congestion__Indicators_template::~M3UA__Congestion__Indicators_template()
{
clean_up();
}

M3UA__Congestion__Indicators_template& M3UA__Congestion__Indicators_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Congestion__Indicators_template& M3UA__Congestion__Indicators_template::operator=(const M3UA__Congestion__Indicators& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Congestion__Indicators_template& M3UA__Congestion__Indicators_template::operator=(const OPTIONAL<M3UA__Congestion__Indicators>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Congestion__Indicators&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Congestion_Indicators.");
}
return *this;
}

M3UA__Congestion__Indicators_template& M3UA__Congestion__Indicators_template::operator=(const M3UA__Congestion__Indicators_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Congestion__Indicators_template::match(const M3UA__Congestion__Indicators& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.congestionLevel().is_bound()) return FALSE;
if(!single_value->field_congestionLevel.match(other_value.congestionLevel(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Congestion_Indicators.");
}
return FALSE;
}

boolean M3UA__Congestion__Indicators_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_reserved.is_bound()
 || single_value->field_congestionLevel.is_bound();
}

boolean M3UA__Congestion__Indicators_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_reserved.is_value()
 && single_value->field_congestionLevel.is_value();
}

void M3UA__Congestion__Indicators_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Congestion__Indicators M3UA__Congestion__Indicators_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Congestion_Indicators.");
M3UA__Congestion__Indicators ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_congestionLevel.is_bound()) {
ret_val.congestionLevel() = single_value->field_congestionLevel.valueof();
}
return ret_val;
}

void M3UA__Congestion__Indicators_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Congestion_Indicators.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Congestion__Indicators_template[list_length];
}

M3UA__Congestion__Indicators_template& M3UA__Congestion__Indicators_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Congestion_Indicators.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Congestion_Indicators.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Congestion__Indicators_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Congestion__Indicators_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Congestion_Indicators.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Congestion__Indicators_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Congestion__Indicators_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Congestion_Indicators.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Congestion__Indicators_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const OCTETSTRING_template& M3UA__Congestion__Indicators_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @M3UA_Types.M3UA_Congestion_Indicators.");
return single_value->field_reserved;
}

OCTETSTRING_template& M3UA__Congestion__Indicators_template::congestionLevel()
{
set_specific();
return single_value->field_congestionLevel;
}

const OCTETSTRING_template& M3UA__Congestion__Indicators_template::congestionLevel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field congestionLevel of a non-specific template of type @M3UA_Types.M3UA_Congestion_Indicators.");
return single_value->field_congestionLevel;
}

int M3UA__Congestion__Indicators_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Congestion_Indicators containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Congestion_Indicators.");
  }
  return 0;
}

void M3UA__Congestion__Indicators_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", congestionLevel := ");
single_value->field_congestionLevel.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Congestion__Indicators_template::log_match(const M3UA__Congestion__Indicators& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_congestionLevel.match(match_value.congestionLevel(), legacy)){
TTCN_Logger::log_logmatch_info(".congestionLevel");
single_value->field_congestionLevel.log_match(match_value.congestionLevel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", congestionLevel := ");
single_value->field_congestionLevel.log_match(match_value.congestionLevel(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Congestion__Indicators_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (congestionLevel().is_bound()) congestionLevel().set_implicit_omit();
}

void M3UA__Congestion__Indicators_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
single_value->field_congestionLevel.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Congestion_Indicators.");
}
}

void M3UA__Congestion__Indicators_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
single_value->field_congestionLevel.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Congestion__Indicators_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Congestion_Indicators.");
}
}

void M3UA__Congestion__Indicators_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Congestion__Indicators_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Congestion_Indicators has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) congestionLevel().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "congestionLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          congestionLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Congestion_Indicators: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Congestion__Indicators_template* precondition = new M3UA__Congestion__Indicators_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Congestion__Indicators_template* implied_template = new M3UA__Congestion__Indicators_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Congestion__Indicators_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Congestion_Indicators");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Congestion__Indicators_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Congestion_Indicators");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Congestion_Indicators");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Congestion_Indicators");
single_value->field_congestionLevel.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Congestion_Indicators");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Congestion_Indicators");
}

boolean M3UA__Congestion__Indicators_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Congestion__Indicators_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__User__Cause::M3UA__User__Cause()
{
}

M3UA__User__Cause::M3UA__User__Cause(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_cause,
    const OCTETSTRING& par_user)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_cause(par_cause),
  field_user(par_user)
{
}

M3UA__User__Cause::M3UA__User__Cause(const M3UA__User__Cause& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_User_Cause.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.user().is_bound()) field_user = other_value.user();
else field_user.clean_up();
}

void M3UA__User__Cause::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_cause.clean_up();
field_user.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__User__Cause::get_descriptor() const { return &M3UA__User__Cause_descr_; }
M3UA__User__Cause& M3UA__User__Cause::operator=(const M3UA__User__Cause& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_User_Cause.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.user().is_bound()) field_user = other_value.user();
  else field_user.clean_up();
}
return *this;
}

boolean M3UA__User__Cause::operator==(const M3UA__User__Cause& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_cause==other_value.field_cause
  && field_user==other_value.field_user;
}

boolean M3UA__User__Cause::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_cause.is_bound())
  || (field_user.is_bound());
}
boolean M3UA__User__Cause::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_cause.is_value()
  && field_user.is_value();
}
void M3UA__User__Cause::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", user := ");
field_user.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__User__Cause::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (user().is_bound()) user().set_implicit_omit();
}

void M3UA__User__Cause::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_User_Cause has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_User_Cause: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_User_Cause");
  }
}

void M3UA__User__Cause::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_user.encode_text(text_buf);
}

void M3UA__User__Cause::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_user.decode_text(text_buf);
}

void M3UA__User__Cause::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__User__Cause::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__User__Cause::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__User__Cause_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__User__Cause_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__User__Cause_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_user.RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__User__Cause::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__User__Cause_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT2_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__User__Cause_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_cause.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_user.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct M3UA__User__Cause_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_cause;
OCTETSTRING_template field_user;
};

void M3UA__User__Cause_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_user = ANY_VALUE;
}
}
}

void M3UA__User__Cause_template::copy_value(const M3UA__User__Cause& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.user().is_bound()) {
  single_value->field_user = other_value.user();
} else {
  single_value->field_user.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__User__Cause_template::copy_template(const M3UA__User__Cause_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user().get_selection()) {
single_value->field_user = other_value.user();
} else {
single_value->field_user.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__User__Cause_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__User__Cause_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__User__Cause_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_User_Cause.");
break;
}
set_selection(other_value);
}

M3UA__User__Cause_template::M3UA__User__Cause_template()
{
}

M3UA__User__Cause_template::M3UA__User__Cause_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__User__Cause_template::M3UA__User__Cause_template(const M3UA__User__Cause& other_value)
{
copy_value(other_value);
}

M3UA__User__Cause_template::M3UA__User__Cause_template(const OPTIONAL<M3UA__User__Cause>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__User__Cause&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_User_Cause from an unbound optional field.");
}
}

M3UA__User__Cause_template::M3UA__User__Cause_template(M3UA__User__Cause_template* p_precondition, M3UA__User__Cause_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__User__Cause_template::M3UA__User__Cause_template(Dynamic_Match_Interface<M3UA__User__Cause>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__User__Cause>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__User__Cause_template::M3UA__User__Cause_template(const M3UA__User__Cause_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__User__Cause_template::~M3UA__User__Cause_template()
{
clean_up();
}

M3UA__User__Cause_template& M3UA__User__Cause_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__User__Cause_template& M3UA__User__Cause_template::operator=(const M3UA__User__Cause& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__User__Cause_template& M3UA__User__Cause_template::operator=(const OPTIONAL<M3UA__User__Cause>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__User__Cause&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_User_Cause.");
}
return *this;
}

M3UA__User__Cause_template& M3UA__User__Cause_template::operator=(const M3UA__User__Cause_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__User__Cause_template::match(const M3UA__User__Cause& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.user().is_bound()) return FALSE;
if(!single_value->field_user.match(other_value.user(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_User_Cause.");
}
return FALSE;
}

boolean M3UA__User__Cause_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_cause.is_bound()
 || single_value->field_user.is_bound();
}

boolean M3UA__User__Cause_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_cause.is_value()
 && single_value->field_user.is_value();
}

void M3UA__User__Cause_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__User__Cause M3UA__User__Cause_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_User_Cause.");
M3UA__User__Cause ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_user.is_bound()) {
ret_val.user() = single_value->field_user.valueof();
}
return ret_val;
}

void M3UA__User__Cause_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_User_Cause.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__User__Cause_template[list_length];
}

M3UA__User__Cause_template& M3UA__User__Cause_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_User_Cause.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_User_Cause.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__User__Cause_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__User__Cause_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_User_Cause.");
return single_value->field_tag;
}

INTEGER_template& M3UA__User__Cause_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__User__Cause_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_User_Cause.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__User__Cause_template::cause()
{
set_specific();
return single_value->field_cause;
}

const OCTETSTRING_template& M3UA__User__Cause_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @M3UA_Types.M3UA_User_Cause.");
return single_value->field_cause;
}

OCTETSTRING_template& M3UA__User__Cause_template::user()
{
set_specific();
return single_value->field_user;
}

const OCTETSTRING_template& M3UA__User__Cause_template::user() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user of a non-specific template of type @M3UA_Types.M3UA_User_Cause.");
return single_value->field_user;
}

int M3UA__User__Cause_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_User_Cause containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_User_Cause.");
  }
  return 0;
}

void M3UA__User__Cause_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", user := ");
single_value->field_user.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__User__Cause_template::log_match(const M3UA__User__Cause& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user.match(match_value.user(), legacy)){
TTCN_Logger::log_logmatch_info(".user");
single_value->field_user.log_match(match_value.user(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", user := ");
single_value->field_user.log_match(match_value.user(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__User__Cause_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (user().is_bound()) user().set_implicit_omit();
}

void M3UA__User__Cause_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_user.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_User_Cause.");
}
}

void M3UA__User__Cause_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_user.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__User__Cause_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_User_Cause.");
}
}

void M3UA__User__Cause_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__User__Cause_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_User_Cause has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_User_Cause: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__User__Cause_template* precondition = new M3UA__User__Cause_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__User__Cause_template* implied_template = new M3UA__User__Cause_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__User__Cause_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_User_Cause");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__User__Cause_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_User_Cause");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_User_Cause");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_User_Cause");
single_value->field_user.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_User_Cause");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_User_Cause");
}

boolean M3UA__User__Cause_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__User__Cause_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__ASP__Identifier::M3UA__ASP__Identifier()
{
}

M3UA__ASP__Identifier::M3UA__ASP__Identifier(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_aSPIdentifier)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_aSPIdentifier(par_aSPIdentifier)
{
}

M3UA__ASP__Identifier::M3UA__ASP__Identifier(const M3UA__ASP__Identifier& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_ASP_Identifier.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.aSPIdentifier().is_bound()) field_aSPIdentifier = other_value.aSPIdentifier();
else field_aSPIdentifier.clean_up();
}

void M3UA__ASP__Identifier::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_aSPIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__ASP__Identifier::get_descriptor() const { return &M3UA__ASP__Identifier_descr_; }
M3UA__ASP__Identifier& M3UA__ASP__Identifier::operator=(const M3UA__ASP__Identifier& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_ASP_Identifier.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.aSPIdentifier().is_bound()) field_aSPIdentifier = other_value.aSPIdentifier();
  else field_aSPIdentifier.clean_up();
}
return *this;
}

boolean M3UA__ASP__Identifier::operator==(const M3UA__ASP__Identifier& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_aSPIdentifier==other_value.field_aSPIdentifier;
}

boolean M3UA__ASP__Identifier::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_aSPIdentifier.is_bound());
}
boolean M3UA__ASP__Identifier::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_aSPIdentifier.is_value();
}
void M3UA__ASP__Identifier::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", aSPIdentifier := ");
field_aSPIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__ASP__Identifier::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (aSPIdentifier().is_bound()) aSPIdentifier().set_implicit_omit();
}

void M3UA__ASP__Identifier::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_ASP_Identifier has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) aSPIdentifier().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aSPIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aSPIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_ASP_Identifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_ASP_Identifier");
  }
}

void M3UA__ASP__Identifier::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_aSPIdentifier.encode_text(text_buf);
}

void M3UA__ASP__Identifier::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_aSPIdentifier.decode_text(text_buf);
}

void M3UA__ASP__Identifier::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__ASP__Identifier::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__ASP__Identifier::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__ASP__Identifier_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__ASP__Identifier_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__ASP__Identifier_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_aSPIdentifier.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__ASP__Identifier::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__ASP__Identifier_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__ASP__Identifier_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_aSPIdentifier.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__ASP__Identifier_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_aSPIdentifier;
};

void M3UA__ASP__Identifier_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_aSPIdentifier = ANY_VALUE;
}
}
}

void M3UA__ASP__Identifier_template::copy_value(const M3UA__ASP__Identifier& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.aSPIdentifier().is_bound()) {
  single_value->field_aSPIdentifier = other_value.aSPIdentifier();
} else {
  single_value->field_aSPIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__ASP__Identifier_template::copy_template(const M3UA__ASP__Identifier_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aSPIdentifier().get_selection()) {
single_value->field_aSPIdentifier = other_value.aSPIdentifier();
} else {
single_value->field_aSPIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__ASP__Identifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__ASP__Identifier_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__ASP__Identifier_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_ASP_Identifier.");
break;
}
set_selection(other_value);
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template()
{
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template(const M3UA__ASP__Identifier& other_value)
{
copy_value(other_value);
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template(const OPTIONAL<M3UA__ASP__Identifier>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__ASP__Identifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_ASP_Identifier from an unbound optional field.");
}
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template(M3UA__ASP__Identifier_template* p_precondition, M3UA__ASP__Identifier_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template(Dynamic_Match_Interface<M3UA__ASP__Identifier>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__ASP__Identifier>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__ASP__Identifier_template::M3UA__ASP__Identifier_template(const M3UA__ASP__Identifier_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__ASP__Identifier_template::~M3UA__ASP__Identifier_template()
{
clean_up();
}

M3UA__ASP__Identifier_template& M3UA__ASP__Identifier_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__ASP__Identifier_template& M3UA__ASP__Identifier_template::operator=(const M3UA__ASP__Identifier& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__ASP__Identifier_template& M3UA__ASP__Identifier_template::operator=(const OPTIONAL<M3UA__ASP__Identifier>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__ASP__Identifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_ASP_Identifier.");
}
return *this;
}

M3UA__ASP__Identifier_template& M3UA__ASP__Identifier_template::operator=(const M3UA__ASP__Identifier_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__ASP__Identifier_template::match(const M3UA__ASP__Identifier& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.aSPIdentifier().is_bound()) return FALSE;
if(!single_value->field_aSPIdentifier.match(other_value.aSPIdentifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_ASP_Identifier.");
}
return FALSE;
}

boolean M3UA__ASP__Identifier_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_aSPIdentifier.is_bound();
}

boolean M3UA__ASP__Identifier_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_aSPIdentifier.is_value();
}

void M3UA__ASP__Identifier_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__ASP__Identifier M3UA__ASP__Identifier_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_ASP_Identifier.");
M3UA__ASP__Identifier ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_aSPIdentifier.is_bound()) {
ret_val.aSPIdentifier() = single_value->field_aSPIdentifier.valueof();
}
return ret_val;
}

void M3UA__ASP__Identifier_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_ASP_Identifier.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__ASP__Identifier_template[list_length];
}

M3UA__ASP__Identifier_template& M3UA__ASP__Identifier_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_ASP_Identifier.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_ASP_Identifier.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__ASP__Identifier_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__ASP__Identifier_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_ASP_Identifier.");
return single_value->field_tag;
}

INTEGER_template& M3UA__ASP__Identifier_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__ASP__Identifier_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_ASP_Identifier.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__ASP__Identifier_template::aSPIdentifier()
{
set_specific();
return single_value->field_aSPIdentifier;
}

const OCTETSTRING_template& M3UA__ASP__Identifier_template::aSPIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aSPIdentifier of a non-specific template of type @M3UA_Types.M3UA_ASP_Identifier.");
return single_value->field_aSPIdentifier;
}

int M3UA__ASP__Identifier_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ASP_Identifier containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_ASP_Identifier.");
  }
  return 0;
}

void M3UA__ASP__Identifier_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", aSPIdentifier := ");
single_value->field_aSPIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__ASP__Identifier_template::log_match(const M3UA__ASP__Identifier& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_aSPIdentifier.match(match_value.aSPIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".aSPIdentifier");
single_value->field_aSPIdentifier.log_match(match_value.aSPIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", aSPIdentifier := ");
single_value->field_aSPIdentifier.log_match(match_value.aSPIdentifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__ASP__Identifier_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (aSPIdentifier().is_bound()) aSPIdentifier().set_implicit_omit();
}

void M3UA__ASP__Identifier_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_aSPIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_ASP_Identifier.");
}
}

void M3UA__ASP__Identifier_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_aSPIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__ASP__Identifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_ASP_Identifier.");
}
}

void M3UA__ASP__Identifier_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__ASP__Identifier_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_ASP_Identifier has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) aSPIdentifier().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aSPIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aSPIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_ASP_Identifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__ASP__Identifier_template* precondition = new M3UA__ASP__Identifier_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__ASP__Identifier_template* implied_template = new M3UA__ASP__Identifier_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__ASP__Identifier_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_ASP_Identifier");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__ASP__Identifier_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ASP_Identifier");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ASP_Identifier");
single_value->field_aSPIdentifier.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ASP_Identifier");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_ASP_Identifier");
}

boolean M3UA__ASP__Identifier_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__ASP__Identifier_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Heartbeat__Data::M3UA__Heartbeat__Data()
{
}

M3UA__Heartbeat__Data::M3UA__Heartbeat__Data(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_heartbeat__Data)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_heartbeat__Data(par_heartbeat__Data)
{
}

M3UA__Heartbeat__Data::M3UA__Heartbeat__Data(const M3UA__Heartbeat__Data& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Heartbeat_Data.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.heartbeat__Data().is_bound()) field_heartbeat__Data = other_value.heartbeat__Data();
else field_heartbeat__Data.clean_up();
}

void M3UA__Heartbeat__Data::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_heartbeat__Data.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Heartbeat__Data::get_descriptor() const { return &M3UA__Heartbeat__Data_descr_; }
M3UA__Heartbeat__Data& M3UA__Heartbeat__Data::operator=(const M3UA__Heartbeat__Data& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Heartbeat_Data.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.heartbeat__Data().is_bound()) field_heartbeat__Data = other_value.heartbeat__Data();
  else field_heartbeat__Data.clean_up();
}
return *this;
}

boolean M3UA__Heartbeat__Data::operator==(const M3UA__Heartbeat__Data& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_heartbeat__Data==other_value.field_heartbeat__Data;
}

boolean M3UA__Heartbeat__Data::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_heartbeat__Data.is_bound());
}
boolean M3UA__Heartbeat__Data::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_heartbeat__Data.is_value();
}
void M3UA__Heartbeat__Data::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", heartbeat_Data := ");
field_heartbeat__Data.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Heartbeat__Data::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (heartbeat__Data().is_bound()) heartbeat__Data().set_implicit_omit();
}

void M3UA__Heartbeat__Data::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Heartbeat_Data has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) heartbeat__Data().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "heartbeat_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          heartbeat__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Heartbeat_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Heartbeat_Data");
  }
}

void M3UA__Heartbeat__Data::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_heartbeat__Data.encode_text(text_buf);
}

void M3UA__Heartbeat__Data::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_heartbeat__Data.decode_text(text_buf);
}

void M3UA__Heartbeat__Data::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Heartbeat__Data::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Heartbeat__Data::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Heartbeat__Data_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Heartbeat__Data_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Heartbeat__Data_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_heartbeat__Data.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Heartbeat__Data::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Heartbeat__Data_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Heartbeat__Data_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_heartbeat__Data.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Heartbeat__Data_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_heartbeat__Data;
};

void M3UA__Heartbeat__Data_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_heartbeat__Data = ANY_VALUE;
}
}
}

void M3UA__Heartbeat__Data_template::copy_value(const M3UA__Heartbeat__Data& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.heartbeat__Data().is_bound()) {
  single_value->field_heartbeat__Data = other_value.heartbeat__Data();
} else {
  single_value->field_heartbeat__Data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Heartbeat__Data_template::copy_template(const M3UA__Heartbeat__Data_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.heartbeat__Data().get_selection()) {
single_value->field_heartbeat__Data = other_value.heartbeat__Data();
} else {
single_value->field_heartbeat__Data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Heartbeat__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Heartbeat__Data_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Heartbeat__Data_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Heartbeat_Data.");
break;
}
set_selection(other_value);
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template()
{
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template(const M3UA__Heartbeat__Data& other_value)
{
copy_value(other_value);
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template(const OPTIONAL<M3UA__Heartbeat__Data>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Heartbeat__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Heartbeat_Data from an unbound optional field.");
}
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template(M3UA__Heartbeat__Data_template* p_precondition, M3UA__Heartbeat__Data_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template(Dynamic_Match_Interface<M3UA__Heartbeat__Data>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Heartbeat__Data>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Heartbeat__Data_template::M3UA__Heartbeat__Data_template(const M3UA__Heartbeat__Data_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Heartbeat__Data_template::~M3UA__Heartbeat__Data_template()
{
clean_up();
}

M3UA__Heartbeat__Data_template& M3UA__Heartbeat__Data_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Heartbeat__Data_template& M3UA__Heartbeat__Data_template::operator=(const M3UA__Heartbeat__Data& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Heartbeat__Data_template& M3UA__Heartbeat__Data_template::operator=(const OPTIONAL<M3UA__Heartbeat__Data>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Heartbeat__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Heartbeat_Data.");
}
return *this;
}

M3UA__Heartbeat__Data_template& M3UA__Heartbeat__Data_template::operator=(const M3UA__Heartbeat__Data_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Heartbeat__Data_template::match(const M3UA__Heartbeat__Data& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.heartbeat__Data().is_bound()) return FALSE;
if(!single_value->field_heartbeat__Data.match(other_value.heartbeat__Data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Heartbeat_Data.");
}
return FALSE;
}

boolean M3UA__Heartbeat__Data_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_heartbeat__Data.is_bound();
}

boolean M3UA__Heartbeat__Data_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_heartbeat__Data.is_value();
}

void M3UA__Heartbeat__Data_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Heartbeat__Data M3UA__Heartbeat__Data_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Heartbeat_Data.");
M3UA__Heartbeat__Data ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_heartbeat__Data.is_bound()) {
ret_val.heartbeat__Data() = single_value->field_heartbeat__Data.valueof();
}
return ret_val;
}

void M3UA__Heartbeat__Data_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Heartbeat_Data.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Heartbeat__Data_template[list_length];
}

M3UA__Heartbeat__Data_template& M3UA__Heartbeat__Data_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Heartbeat_Data.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Heartbeat_Data.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Heartbeat__Data_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Heartbeat__Data_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Heartbeat_Data.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Heartbeat__Data_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Heartbeat__Data_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Heartbeat_Data.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Heartbeat__Data_template::heartbeat__Data()
{
set_specific();
return single_value->field_heartbeat__Data;
}

const OCTETSTRING_template& M3UA__Heartbeat__Data_template::heartbeat__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field heartbeat_Data of a non-specific template of type @M3UA_Types.M3UA_Heartbeat_Data.");
return single_value->field_heartbeat__Data;
}

int M3UA__Heartbeat__Data_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Heartbeat_Data containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Heartbeat_Data.");
  }
  return 0;
}

void M3UA__Heartbeat__Data_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", heartbeat_Data := ");
single_value->field_heartbeat__Data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Heartbeat__Data_template::log_match(const M3UA__Heartbeat__Data& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_heartbeat__Data.match(match_value.heartbeat__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".heartbeat_Data");
single_value->field_heartbeat__Data.log_match(match_value.heartbeat__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", heartbeat_Data := ");
single_value->field_heartbeat__Data.log_match(match_value.heartbeat__Data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Heartbeat__Data_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (heartbeat__Data().is_bound()) heartbeat__Data().set_implicit_omit();
}

void M3UA__Heartbeat__Data_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_heartbeat__Data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Heartbeat_Data.");
}
}

void M3UA__Heartbeat__Data_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_heartbeat__Data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Heartbeat__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Heartbeat_Data.");
}
}

void M3UA__Heartbeat__Data_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Heartbeat__Data_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Heartbeat_Data has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) heartbeat__Data().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "heartbeat_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          heartbeat__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Heartbeat_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Heartbeat__Data_template* precondition = new M3UA__Heartbeat__Data_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Heartbeat__Data_template* implied_template = new M3UA__Heartbeat__Data_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Heartbeat__Data_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Heartbeat_Data");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Heartbeat__Data_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Heartbeat_Data");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Heartbeat_Data");
single_value->field_heartbeat__Data.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Heartbeat_Data");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Heartbeat_Data");
}

boolean M3UA__Heartbeat__Data_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Heartbeat__Data_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Traffic__Mode__Type::M3UA__Traffic__Mode__Type()
{
}

M3UA__Traffic__Mode__Type::M3UA__Traffic__Mode__Type(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_trafficModeType)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_trafficModeType(par_trafficModeType)
{
}

M3UA__Traffic__Mode__Type::M3UA__Traffic__Mode__Type(const M3UA__Traffic__Mode__Type& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.trafficModeType().is_bound()) field_trafficModeType = other_value.trafficModeType();
else field_trafficModeType.clean_up();
}

void M3UA__Traffic__Mode__Type::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_trafficModeType.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Traffic__Mode__Type::get_descriptor() const { return &M3UA__Traffic__Mode__Type_descr_; }
M3UA__Traffic__Mode__Type& M3UA__Traffic__Mode__Type::operator=(const M3UA__Traffic__Mode__Type& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.trafficModeType().is_bound()) field_trafficModeType = other_value.trafficModeType();
  else field_trafficModeType.clean_up();
}
return *this;
}

boolean M3UA__Traffic__Mode__Type::operator==(const M3UA__Traffic__Mode__Type& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_trafficModeType==other_value.field_trafficModeType;
}

boolean M3UA__Traffic__Mode__Type::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_trafficModeType.is_bound());
}
boolean M3UA__Traffic__Mode__Type::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_trafficModeType.is_value();
}
void M3UA__Traffic__Mode__Type::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", trafficModeType := ");
field_trafficModeType.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Traffic__Mode__Type::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (trafficModeType().is_bound()) trafficModeType().set_implicit_omit();
}

void M3UA__Traffic__Mode__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Traffic_Mode_Type has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) trafficModeType().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trafficModeType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trafficModeType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Traffic_Mode_Type: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Traffic_Mode_Type");
  }
}

void M3UA__Traffic__Mode__Type::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_trafficModeType.encode_text(text_buf);
}

void M3UA__Traffic__Mode__Type::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_trafficModeType.decode_text(text_buf);
}

void M3UA__Traffic__Mode__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Traffic__Mode__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Traffic__Mode__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Traffic__Mode__Type_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Traffic__Mode__Type_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Traffic__Mode__Type_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_trafficModeType.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Traffic__Mode__Type::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Traffic__Mode__Type_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Traffic__Mode__Type_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_trafficModeType.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Traffic__Mode__Type_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_trafficModeType;
};

void M3UA__Traffic__Mode__Type_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_trafficModeType = ANY_VALUE;
}
}
}

void M3UA__Traffic__Mode__Type_template::copy_value(const M3UA__Traffic__Mode__Type& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.trafficModeType().is_bound()) {
  single_value->field_trafficModeType = other_value.trafficModeType();
} else {
  single_value->field_trafficModeType.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Traffic__Mode__Type_template::copy_template(const M3UA__Traffic__Mode__Type_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trafficModeType().get_selection()) {
single_value->field_trafficModeType = other_value.trafficModeType();
} else {
single_value->field_trafficModeType.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Traffic__Mode__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Traffic__Mode__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Traffic__Mode__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
break;
}
set_selection(other_value);
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template()
{
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template(const M3UA__Traffic__Mode__Type& other_value)
{
copy_value(other_value);
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template(const OPTIONAL<M3UA__Traffic__Mode__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Traffic__Mode__Type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Traffic_Mode_Type from an unbound optional field.");
}
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template(M3UA__Traffic__Mode__Type_template* p_precondition, M3UA__Traffic__Mode__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template(Dynamic_Match_Interface<M3UA__Traffic__Mode__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Traffic__Mode__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Traffic__Mode__Type_template::M3UA__Traffic__Mode__Type_template(const M3UA__Traffic__Mode__Type_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Traffic__Mode__Type_template::~M3UA__Traffic__Mode__Type_template()
{
clean_up();
}

M3UA__Traffic__Mode__Type_template& M3UA__Traffic__Mode__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Traffic__Mode__Type_template& M3UA__Traffic__Mode__Type_template::operator=(const M3UA__Traffic__Mode__Type& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Traffic__Mode__Type_template& M3UA__Traffic__Mode__Type_template::operator=(const OPTIONAL<M3UA__Traffic__Mode__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Traffic__Mode__Type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
}
return *this;
}

M3UA__Traffic__Mode__Type_template& M3UA__Traffic__Mode__Type_template::operator=(const M3UA__Traffic__Mode__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Traffic__Mode__Type_template::match(const M3UA__Traffic__Mode__Type& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.trafficModeType().is_bound()) return FALSE;
if(!single_value->field_trafficModeType.match(other_value.trafficModeType(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
}
return FALSE;
}

boolean M3UA__Traffic__Mode__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_trafficModeType.is_bound();
}

boolean M3UA__Traffic__Mode__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_trafficModeType.is_value();
}

void M3UA__Traffic__Mode__Type_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Traffic__Mode__Type M3UA__Traffic__Mode__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
M3UA__Traffic__Mode__Type ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_trafficModeType.is_bound()) {
ret_val.trafficModeType() = single_value->field_trafficModeType.valueof();
}
return ret_val;
}

void M3UA__Traffic__Mode__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Traffic__Mode__Type_template[list_length];
}

M3UA__Traffic__Mode__Type_template& M3UA__Traffic__Mode__Type_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Traffic__Mode__Type_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Traffic__Mode__Type_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Traffic__Mode__Type_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Traffic__Mode__Type_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Traffic__Mode__Type_template::trafficModeType()
{
set_specific();
return single_value->field_trafficModeType;
}

const OCTETSTRING_template& M3UA__Traffic__Mode__Type_template::trafficModeType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trafficModeType of a non-specific template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
return single_value->field_trafficModeType;
}

int M3UA__Traffic__Mode__Type_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Traffic_Mode_Type containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
  }
  return 0;
}

void M3UA__Traffic__Mode__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", trafficModeType := ");
single_value->field_trafficModeType.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Traffic__Mode__Type_template::log_match(const M3UA__Traffic__Mode__Type& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_trafficModeType.match(match_value.trafficModeType(), legacy)){
TTCN_Logger::log_logmatch_info(".trafficModeType");
single_value->field_trafficModeType.log_match(match_value.trafficModeType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", trafficModeType := ");
single_value->field_trafficModeType.log_match(match_value.trafficModeType(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Traffic__Mode__Type_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (trafficModeType().is_bound()) trafficModeType().set_implicit_omit();
}

void M3UA__Traffic__Mode__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_trafficModeType.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
}
}

void M3UA__Traffic__Mode__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_trafficModeType.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Traffic__Mode__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Traffic_Mode_Type.");
}
}

void M3UA__Traffic__Mode__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Traffic__Mode__Type_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Traffic_Mode_Type has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) trafficModeType().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trafficModeType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trafficModeType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Traffic_Mode_Type: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Traffic__Mode__Type_template* precondition = new M3UA__Traffic__Mode__Type_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Traffic__Mode__Type_template* implied_template = new M3UA__Traffic__Mode__Type_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Traffic__Mode__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Traffic_Mode_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Traffic__Mode__Type_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Traffic_Mode_Type");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Traffic_Mode_Type");
single_value->field_trafficModeType.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Traffic_Mode_Type");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Traffic_Mode_Type");
}

boolean M3UA__Traffic__Mode__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Traffic__Mode__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Status::M3UA__Status()
{
}

M3UA__Status::M3UA__Status(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_statusType,
    const OCTETSTRING& par_statusInfo)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_statusType(par_statusType),
  field_statusInfo(par_statusInfo)
{
}

M3UA__Status::M3UA__Status(const M3UA__Status& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Status.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.statusType().is_bound()) field_statusType = other_value.statusType();
else field_statusType.clean_up();
if (other_value.statusInfo().is_bound()) field_statusInfo = other_value.statusInfo();
else field_statusInfo.clean_up();
}

void M3UA__Status::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_statusType.clean_up();
field_statusInfo.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Status::get_descriptor() const { return &M3UA__Status_descr_; }
M3UA__Status& M3UA__Status::operator=(const M3UA__Status& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Status.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.statusType().is_bound()) field_statusType = other_value.statusType();
  else field_statusType.clean_up();
  if (other_value.statusInfo().is_bound()) field_statusInfo = other_value.statusInfo();
  else field_statusInfo.clean_up();
}
return *this;
}

boolean M3UA__Status::operator==(const M3UA__Status& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_statusType==other_value.field_statusType
  && field_statusInfo==other_value.field_statusInfo;
}

boolean M3UA__Status::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_statusType.is_bound())
  || (field_statusInfo.is_bound());
}
boolean M3UA__Status::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_statusType.is_value()
  && field_statusInfo.is_value();
}
void M3UA__Status::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", statusType := ");
field_statusType.log();
TTCN_Logger::log_event_str(", statusInfo := ");
field_statusInfo.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Status::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (statusType().is_bound()) statusType().set_implicit_omit();
if (statusInfo().is_bound()) statusInfo().set_implicit_omit();
}

void M3UA__Status::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Status has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) statusType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) statusInfo().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "statusType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          statusType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "statusInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          statusInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Status");
  }
}

void M3UA__Status::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_statusType.encode_text(text_buf);
field_statusInfo.encode_text(text_buf);
}

void M3UA__Status::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_statusType.decode_text(text_buf);
field_statusInfo.decode_text(text_buf);
}

void M3UA__Status::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Status::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Status::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Status_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Status_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Status_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_statusType.RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_statusInfo.RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Status::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Status_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT2_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Status_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_statusType.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_statusInfo.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct M3UA__Status_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_statusType;
OCTETSTRING_template field_statusInfo;
};

void M3UA__Status_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_statusType = ANY_VALUE;
single_value->field_statusInfo = ANY_VALUE;
}
}
}

void M3UA__Status_template::copy_value(const M3UA__Status& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.statusType().is_bound()) {
  single_value->field_statusType = other_value.statusType();
} else {
  single_value->field_statusType.clean_up();
}
if (other_value.statusInfo().is_bound()) {
  single_value->field_statusInfo = other_value.statusInfo();
} else {
  single_value->field_statusInfo.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Status_template::copy_template(const M3UA__Status_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.statusType().get_selection()) {
single_value->field_statusType = other_value.statusType();
} else {
single_value->field_statusType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.statusInfo().get_selection()) {
single_value->field_statusInfo = other_value.statusInfo();
} else {
single_value->field_statusInfo.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Status_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Status_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Status.");
break;
}
set_selection(other_value);
}

M3UA__Status_template::M3UA__Status_template()
{
}

M3UA__Status_template::M3UA__Status_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Status_template::M3UA__Status_template(const M3UA__Status& other_value)
{
copy_value(other_value);
}

M3UA__Status_template::M3UA__Status_template(const OPTIONAL<M3UA__Status>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Status from an unbound optional field.");
}
}

M3UA__Status_template::M3UA__Status_template(M3UA__Status_template* p_precondition, M3UA__Status_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Status_template::M3UA__Status_template(Dynamic_Match_Interface<M3UA__Status>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Status>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Status_template::M3UA__Status_template(const M3UA__Status_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Status_template::~M3UA__Status_template()
{
clean_up();
}

M3UA__Status_template& M3UA__Status_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Status_template& M3UA__Status_template::operator=(const M3UA__Status& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Status_template& M3UA__Status_template::operator=(const OPTIONAL<M3UA__Status>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Status.");
}
return *this;
}

M3UA__Status_template& M3UA__Status_template::operator=(const M3UA__Status_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Status_template::match(const M3UA__Status& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.statusType().is_bound()) return FALSE;
if(!single_value->field_statusType.match(other_value.statusType(), legacy))return FALSE;
if(!other_value.statusInfo().is_bound()) return FALSE;
if(!single_value->field_statusInfo.match(other_value.statusInfo(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Status.");
}
return FALSE;
}

boolean M3UA__Status_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_statusType.is_bound()
 || single_value->field_statusInfo.is_bound();
}

boolean M3UA__Status_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_statusType.is_value()
 && single_value->field_statusInfo.is_value();
}

void M3UA__Status_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Status M3UA__Status_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Status.");
M3UA__Status ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_statusType.is_bound()) {
ret_val.statusType() = single_value->field_statusType.valueof();
}
if (single_value->field_statusInfo.is_bound()) {
ret_val.statusInfo() = single_value->field_statusInfo.valueof();
}
return ret_val;
}

void M3UA__Status_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Status.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Status_template[list_length];
}

M3UA__Status_template& M3UA__Status_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Status.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Status.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Status_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Status_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Status.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Status_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Status_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Status.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Status_template::statusType()
{
set_specific();
return single_value->field_statusType;
}

const OCTETSTRING_template& M3UA__Status_template::statusType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field statusType of a non-specific template of type @M3UA_Types.M3UA_Status.");
return single_value->field_statusType;
}

OCTETSTRING_template& M3UA__Status_template::statusInfo()
{
set_specific();
return single_value->field_statusInfo;
}

const OCTETSTRING_template& M3UA__Status_template::statusInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field statusInfo of a non-specific template of type @M3UA_Types.M3UA_Status.");
return single_value->field_statusInfo;
}

int M3UA__Status_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Status containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Status.");
  }
  return 0;
}

void M3UA__Status_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", statusType := ");
single_value->field_statusType.log();
TTCN_Logger::log_event_str(", statusInfo := ");
single_value->field_statusInfo.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Status_template::log_match(const M3UA__Status& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_statusType.match(match_value.statusType(), legacy)){
TTCN_Logger::log_logmatch_info(".statusType");
single_value->field_statusType.log_match(match_value.statusType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_statusInfo.match(match_value.statusInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".statusInfo");
single_value->field_statusInfo.log_match(match_value.statusInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", statusType := ");
single_value->field_statusType.log_match(match_value.statusType(), legacy);
TTCN_Logger::log_event_str(", statusInfo := ");
single_value->field_statusInfo.log_match(match_value.statusInfo(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Status_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (statusType().is_bound()) statusType().set_implicit_omit();
if (statusInfo().is_bound()) statusInfo().set_implicit_omit();
}

void M3UA__Status_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_statusType.encode_text(text_buf);
single_value->field_statusInfo.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Status.");
}
}

void M3UA__Status_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_statusType.decode_text(text_buf);
single_value->field_statusInfo.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Status.");
}
}

void M3UA__Status_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Status_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Status has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) statusType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) statusInfo().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "statusType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          statusType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "statusInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          statusInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Status_template* precondition = new M3UA__Status_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Status_template* implied_template = new M3UA__Status_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Status_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Status");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Status_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Status");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Status");
single_value->field_statusType.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Status");
single_value->field_statusInfo.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Status");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Status");
}

boolean M3UA__Status_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Status_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Local__Routing__Key__Id::M3UA__Local__Routing__Key__Id()
{
}

M3UA__Local__Routing__Key__Id::M3UA__Local__Routing__Key__Id(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_localRkId)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_localRkId(par_localRkId)
{
}

M3UA__Local__Routing__Key__Id::M3UA__Local__Routing__Key__Id(const M3UA__Local__Routing__Key__Id& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.localRkId().is_bound()) field_localRkId = other_value.localRkId();
else field_localRkId.clean_up();
}

void M3UA__Local__Routing__Key__Id::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_localRkId.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Local__Routing__Key__Id::get_descriptor() const { return &M3UA__Local__Routing__Key__Id_descr_; }
M3UA__Local__Routing__Key__Id& M3UA__Local__Routing__Key__Id::operator=(const M3UA__Local__Routing__Key__Id& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.localRkId().is_bound()) field_localRkId = other_value.localRkId();
  else field_localRkId.clean_up();
}
return *this;
}

boolean M3UA__Local__Routing__Key__Id::operator==(const M3UA__Local__Routing__Key__Id& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_localRkId==other_value.field_localRkId;
}

boolean M3UA__Local__Routing__Key__Id::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_localRkId.is_bound());
}
boolean M3UA__Local__Routing__Key__Id::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_localRkId.is_value();
}
void M3UA__Local__Routing__Key__Id::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", localRkId := ");
field_localRkId.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Local__Routing__Key__Id::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (localRkId().is_bound()) localRkId().set_implicit_omit();
}

void M3UA__Local__Routing__Key__Id::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Local_Routing_Key_Id has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) localRkId().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "localRkId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          localRkId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Local_Routing_Key_Id: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Local_Routing_Key_Id");
  }
}

void M3UA__Local__Routing__Key__Id::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_localRkId.encode_text(text_buf);
}

void M3UA__Local__Routing__Key__Id::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_localRkId.decode_text(text_buf);
}

void M3UA__Local__Routing__Key__Id::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Local__Routing__Key__Id::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Local__Routing__Key__Id::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Local__Routing__Key__Id_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Local__Routing__Key__Id_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Local__Routing__Key__Id_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_localRkId.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Local__Routing__Key__Id::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Local__Routing__Key__Id_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Local__Routing__Key__Id_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_localRkId.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Local__Routing__Key__Id_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_localRkId;
};

void M3UA__Local__Routing__Key__Id_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_localRkId = ANY_VALUE;
}
}
}

void M3UA__Local__Routing__Key__Id_template::copy_value(const M3UA__Local__Routing__Key__Id& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.localRkId().is_bound()) {
  single_value->field_localRkId = other_value.localRkId();
} else {
  single_value->field_localRkId.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Local__Routing__Key__Id_template::copy_template(const M3UA__Local__Routing__Key__Id_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.localRkId().get_selection()) {
single_value->field_localRkId = other_value.localRkId();
} else {
single_value->field_localRkId.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Local__Routing__Key__Id_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Local__Routing__Key__Id_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Local__Routing__Key__Id_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
break;
}
set_selection(other_value);
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template()
{
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template(const M3UA__Local__Routing__Key__Id& other_value)
{
copy_value(other_value);
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template(const OPTIONAL<M3UA__Local__Routing__Key__Id>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Local__Routing__Key__Id&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id from an unbound optional field.");
}
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template(M3UA__Local__Routing__Key__Id_template* p_precondition, M3UA__Local__Routing__Key__Id_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template(Dynamic_Match_Interface<M3UA__Local__Routing__Key__Id>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Local__Routing__Key__Id>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Local__Routing__Key__Id_template::M3UA__Local__Routing__Key__Id_template(const M3UA__Local__Routing__Key__Id_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Local__Routing__Key__Id_template::~M3UA__Local__Routing__Key__Id_template()
{
clean_up();
}

M3UA__Local__Routing__Key__Id_template& M3UA__Local__Routing__Key__Id_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Local__Routing__Key__Id_template& M3UA__Local__Routing__Key__Id_template::operator=(const M3UA__Local__Routing__Key__Id& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Local__Routing__Key__Id_template& M3UA__Local__Routing__Key__Id_template::operator=(const OPTIONAL<M3UA__Local__Routing__Key__Id>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Local__Routing__Key__Id&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
}
return *this;
}

M3UA__Local__Routing__Key__Id_template& M3UA__Local__Routing__Key__Id_template::operator=(const M3UA__Local__Routing__Key__Id_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Local__Routing__Key__Id_template::match(const M3UA__Local__Routing__Key__Id& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.localRkId().is_bound()) return FALSE;
if(!single_value->field_localRkId.match(other_value.localRkId(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
}
return FALSE;
}

boolean M3UA__Local__Routing__Key__Id_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_localRkId.is_bound();
}

boolean M3UA__Local__Routing__Key__Id_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_localRkId.is_value();
}

void M3UA__Local__Routing__Key__Id_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Local__Routing__Key__Id M3UA__Local__Routing__Key__Id_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
M3UA__Local__Routing__Key__Id ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_localRkId.is_bound()) {
ret_val.localRkId() = single_value->field_localRkId.valueof();
}
return ret_val;
}

void M3UA__Local__Routing__Key__Id_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Local__Routing__Key__Id_template[list_length];
}

M3UA__Local__Routing__Key__Id_template& M3UA__Local__Routing__Key__Id_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Local__Routing__Key__Id_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Local__Routing__Key__Id_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Local__Routing__Key__Id_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Local__Routing__Key__Id_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Local__Routing__Key__Id_template::localRkId()
{
set_specific();
return single_value->field_localRkId;
}

const OCTETSTRING_template& M3UA__Local__Routing__Key__Id_template::localRkId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field localRkId of a non-specific template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
return single_value->field_localRkId;
}

int M3UA__Local__Routing__Key__Id_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
  }
  return 0;
}

void M3UA__Local__Routing__Key__Id_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", localRkId := ");
single_value->field_localRkId.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Local__Routing__Key__Id_template::log_match(const M3UA__Local__Routing__Key__Id& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_localRkId.match(match_value.localRkId(), legacy)){
TTCN_Logger::log_logmatch_info(".localRkId");
single_value->field_localRkId.log_match(match_value.localRkId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", localRkId := ");
single_value->field_localRkId.log_match(match_value.localRkId(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Local__Routing__Key__Id_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (localRkId().is_bound()) localRkId().set_implicit_omit();
}

void M3UA__Local__Routing__Key__Id_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_localRkId.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
}
}

void M3UA__Local__Routing__Key__Id_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_localRkId.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Local__Routing__Key__Id_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Local_Routing_Key_Id.");
}
}

void M3UA__Local__Routing__Key__Id_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Local__Routing__Key__Id_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Local_Routing_Key_Id has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) localRkId().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "localRkId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          localRkId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Local_Routing_Key_Id: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Local__Routing__Key__Id_template* precondition = new M3UA__Local__Routing__Key__Id_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Local__Routing__Key__Id_template* implied_template = new M3UA__Local__Routing__Key__Id_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Local__Routing__Key__Id_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Local_Routing_Key_Id");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Local__Routing__Key__Id_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Local_Routing_Key_Id");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Local_Routing_Key_Id");
single_value->field_localRkId.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Local_Routing_Key_Id");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Local_Routing_Key_Id");
}

boolean M3UA__Local__Routing__Key__Id_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Local__Routing__Key__Id_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Destination__PointCode::M3UA__Destination__PointCode()
{
}

M3UA__Destination__PointCode::M3UA__Destination__PointCode(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const M3UA__Point__Code& par_pointCode)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_pointCode(par_pointCode)
{
}

M3UA__Destination__PointCode::M3UA__Destination__PointCode(const M3UA__Destination__PointCode& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Destination_PointCode.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.pointCode().is_bound()) field_pointCode = other_value.pointCode();
else field_pointCode.clean_up();
}

void M3UA__Destination__PointCode::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_pointCode.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Destination__PointCode::get_descriptor() const { return &M3UA__Destination__PointCode_descr_; }
M3UA__Destination__PointCode& M3UA__Destination__PointCode::operator=(const M3UA__Destination__PointCode& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Destination_PointCode.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.pointCode().is_bound()) field_pointCode = other_value.pointCode();
  else field_pointCode.clean_up();
}
return *this;
}

boolean M3UA__Destination__PointCode::operator==(const M3UA__Destination__PointCode& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_pointCode==other_value.field_pointCode;
}

boolean M3UA__Destination__PointCode::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_pointCode.is_bound());
}
boolean M3UA__Destination__PointCode::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_pointCode.is_value();
}
void M3UA__Destination__PointCode::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", pointCode := ");
field_pointCode.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Destination__PointCode::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (pointCode().is_bound()) pointCode().set_implicit_omit();
}

void M3UA__Destination__PointCode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Destination_PointCode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pointCode().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Destination_PointCode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Destination_PointCode");
  }
}

void M3UA__Destination__PointCode::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_pointCode.encode_text(text_buf);
}

void M3UA__Destination__PointCode::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_pointCode.decode_text(text_buf);
}

void M3UA__Destination__PointCode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Destination__PointCode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Destination__PointCode::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Destination__PointCode_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Destination__PointCode_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Destination__PointCode_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Point__Code_descr_.raw->forceomit);
  decoded_field_length = field_pointCode.RAW_decode(M3UA__Point__Code_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Destination__PointCode::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Destination__PointCode_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Point__Code_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Destination__PointCode_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_pointCode.RAW_encode(M3UA__Point__Code_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Destination__PointCode_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
M3UA__Point__Code_template field_pointCode;
};

void M3UA__Destination__PointCode_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_pointCode = ANY_VALUE;
}
}
}

void M3UA__Destination__PointCode_template::copy_value(const M3UA__Destination__PointCode& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.pointCode().is_bound()) {
  single_value->field_pointCode = other_value.pointCode();
} else {
  single_value->field_pointCode.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Destination__PointCode_template::copy_template(const M3UA__Destination__PointCode_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointCode().get_selection()) {
single_value->field_pointCode = other_value.pointCode();
} else {
single_value->field_pointCode.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Destination__PointCode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Destination__PointCode_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Destination__PointCode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Destination_PointCode.");
break;
}
set_selection(other_value);
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template()
{
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template(const M3UA__Destination__PointCode& other_value)
{
copy_value(other_value);
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template(const OPTIONAL<M3UA__Destination__PointCode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Destination__PointCode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Destination_PointCode from an unbound optional field.");
}
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template(M3UA__Destination__PointCode_template* p_precondition, M3UA__Destination__PointCode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template(Dynamic_Match_Interface<M3UA__Destination__PointCode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Destination__PointCode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Destination__PointCode_template::M3UA__Destination__PointCode_template(const M3UA__Destination__PointCode_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Destination__PointCode_template::~M3UA__Destination__PointCode_template()
{
clean_up();
}

M3UA__Destination__PointCode_template& M3UA__Destination__PointCode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Destination__PointCode_template& M3UA__Destination__PointCode_template::operator=(const M3UA__Destination__PointCode& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Destination__PointCode_template& M3UA__Destination__PointCode_template::operator=(const OPTIONAL<M3UA__Destination__PointCode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Destination__PointCode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Destination_PointCode.");
}
return *this;
}

M3UA__Destination__PointCode_template& M3UA__Destination__PointCode_template::operator=(const M3UA__Destination__PointCode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Destination__PointCode_template::match(const M3UA__Destination__PointCode& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.pointCode().is_bound()) return FALSE;
if(!single_value->field_pointCode.match(other_value.pointCode(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Destination_PointCode.");
}
return FALSE;
}

boolean M3UA__Destination__PointCode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_pointCode.is_bound();
}

boolean M3UA__Destination__PointCode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_pointCode.is_value();
}

void M3UA__Destination__PointCode_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Destination__PointCode M3UA__Destination__PointCode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Destination_PointCode.");
M3UA__Destination__PointCode ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_pointCode.is_bound()) {
ret_val.pointCode() = single_value->field_pointCode.valueof();
}
return ret_val;
}

void M3UA__Destination__PointCode_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Destination_PointCode.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Destination__PointCode_template[list_length];
}

M3UA__Destination__PointCode_template& M3UA__Destination__PointCode_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Destination_PointCode.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Destination_PointCode.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Destination__PointCode_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Destination__PointCode_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Destination_PointCode.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Destination__PointCode_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Destination__PointCode_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Destination_PointCode.");
return single_value->field_lengthInd;
}

M3UA__Point__Code_template& M3UA__Destination__PointCode_template::pointCode()
{
set_specific();
return single_value->field_pointCode;
}

const M3UA__Point__Code_template& M3UA__Destination__PointCode_template::pointCode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointCode of a non-specific template of type @M3UA_Types.M3UA_Destination_PointCode.");
return single_value->field_pointCode;
}

int M3UA__Destination__PointCode_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Destination_PointCode containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Destination_PointCode.");
  }
  return 0;
}

void M3UA__Destination__PointCode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", pointCode := ");
single_value->field_pointCode.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Destination__PointCode_template::log_match(const M3UA__Destination__PointCode& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointCode.match(match_value.pointCode(), legacy)){
TTCN_Logger::log_logmatch_info(".pointCode");
single_value->field_pointCode.log_match(match_value.pointCode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", pointCode := ");
single_value->field_pointCode.log_match(match_value.pointCode(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Destination__PointCode_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (pointCode().is_bound()) pointCode().set_implicit_omit();
}

void M3UA__Destination__PointCode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_pointCode.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Destination_PointCode.");
}
}

void M3UA__Destination__PointCode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_pointCode.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Destination__PointCode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Destination_PointCode.");
}
}

void M3UA__Destination__PointCode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Destination__PointCode_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Destination_PointCode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pointCode().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Destination_PointCode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Destination__PointCode_template* precondition = new M3UA__Destination__PointCode_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Destination__PointCode_template* implied_template = new M3UA__Destination__PointCode_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Destination__PointCode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Destination_PointCode");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Destination__PointCode_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Destination_PointCode");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Destination_PointCode");
single_value->field_pointCode.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Destination_PointCode");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Destination_PointCode");
}

boolean M3UA__Destination__PointCode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Destination__PointCode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Service__Indicators::M3UA__Service__Indicators()
{
}

M3UA__Service__Indicators::M3UA__Service__Indicators(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_serviceIndicators)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_serviceIndicators(par_serviceIndicators)
{
}

M3UA__Service__Indicators::M3UA__Service__Indicators(const M3UA__Service__Indicators& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Service_Indicators.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.serviceIndicators().is_bound()) field_serviceIndicators = other_value.serviceIndicators();
else field_serviceIndicators.clean_up();
}

void M3UA__Service__Indicators::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_serviceIndicators.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Service__Indicators::get_descriptor() const { return &M3UA__Service__Indicators_descr_; }
M3UA__Service__Indicators& M3UA__Service__Indicators::operator=(const M3UA__Service__Indicators& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Service_Indicators.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.serviceIndicators().is_bound()) field_serviceIndicators = other_value.serviceIndicators();
  else field_serviceIndicators.clean_up();
}
return *this;
}

boolean M3UA__Service__Indicators::operator==(const M3UA__Service__Indicators& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_serviceIndicators==other_value.field_serviceIndicators;
}

boolean M3UA__Service__Indicators::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_serviceIndicators.is_bound());
}
boolean M3UA__Service__Indicators::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_serviceIndicators.is_value();
}
void M3UA__Service__Indicators::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", serviceIndicators := ");
field_serviceIndicators.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Service__Indicators::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (serviceIndicators().is_bound()) serviceIndicators().set_implicit_omit();
}

void M3UA__Service__Indicators::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Service_Indicators has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) serviceIndicators().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "serviceIndicators")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          serviceIndicators().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Service_Indicators: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Service_Indicators");
  }
}

void M3UA__Service__Indicators::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_serviceIndicators.encode_text(text_buf);
}

void M3UA__Service__Indicators::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_serviceIndicators.decode_text(text_buf);
}

void M3UA__Service__Indicators::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Service__Indicators::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Service__Indicators::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Service__Indicators_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Service__Indicators_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Service__Indicators_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_serviceIndicators.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Service__Indicators::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Service__Indicators_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Service__Indicators_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_serviceIndicators.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Service__Indicators_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_serviceIndicators;
};

void M3UA__Service__Indicators_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_serviceIndicators = ANY_VALUE;
}
}
}

void M3UA__Service__Indicators_template::copy_value(const M3UA__Service__Indicators& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.serviceIndicators().is_bound()) {
  single_value->field_serviceIndicators = other_value.serviceIndicators();
} else {
  single_value->field_serviceIndicators.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Service__Indicators_template::copy_template(const M3UA__Service__Indicators_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.serviceIndicators().get_selection()) {
single_value->field_serviceIndicators = other_value.serviceIndicators();
} else {
single_value->field_serviceIndicators.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Service__Indicators_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Service__Indicators_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Service__Indicators_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Service_Indicators.");
break;
}
set_selection(other_value);
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template()
{
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template(const M3UA__Service__Indicators& other_value)
{
copy_value(other_value);
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template(const OPTIONAL<M3UA__Service__Indicators>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Service__Indicators&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Service_Indicators from an unbound optional field.");
}
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template(M3UA__Service__Indicators_template* p_precondition, M3UA__Service__Indicators_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template(Dynamic_Match_Interface<M3UA__Service__Indicators>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Service__Indicators>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Service__Indicators_template::M3UA__Service__Indicators_template(const M3UA__Service__Indicators_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Service__Indicators_template::~M3UA__Service__Indicators_template()
{
clean_up();
}

M3UA__Service__Indicators_template& M3UA__Service__Indicators_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Service__Indicators_template& M3UA__Service__Indicators_template::operator=(const M3UA__Service__Indicators& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Service__Indicators_template& M3UA__Service__Indicators_template::operator=(const OPTIONAL<M3UA__Service__Indicators>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Service__Indicators&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Service_Indicators.");
}
return *this;
}

M3UA__Service__Indicators_template& M3UA__Service__Indicators_template::operator=(const M3UA__Service__Indicators_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Service__Indicators_template::match(const M3UA__Service__Indicators& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.serviceIndicators().is_bound()) return FALSE;
if(!single_value->field_serviceIndicators.match(other_value.serviceIndicators(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Service_Indicators.");
}
return FALSE;
}

boolean M3UA__Service__Indicators_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_serviceIndicators.is_bound();
}

boolean M3UA__Service__Indicators_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_serviceIndicators.is_value();
}

void M3UA__Service__Indicators_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Service__Indicators M3UA__Service__Indicators_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Service_Indicators.");
M3UA__Service__Indicators ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_serviceIndicators.is_bound()) {
ret_val.serviceIndicators() = single_value->field_serviceIndicators.valueof();
}
return ret_val;
}

void M3UA__Service__Indicators_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Service_Indicators.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Service__Indicators_template[list_length];
}

M3UA__Service__Indicators_template& M3UA__Service__Indicators_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Service_Indicators.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Service_Indicators.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Service__Indicators_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Service__Indicators_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Service_Indicators.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Service__Indicators_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Service__Indicators_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Service_Indicators.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Service__Indicators_template::serviceIndicators()
{
set_specific();
return single_value->field_serviceIndicators;
}

const OCTETSTRING_template& M3UA__Service__Indicators_template::serviceIndicators() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field serviceIndicators of a non-specific template of type @M3UA_Types.M3UA_Service_Indicators.");
return single_value->field_serviceIndicators;
}

int M3UA__Service__Indicators_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Service_Indicators containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Service_Indicators.");
  }
  return 0;
}

void M3UA__Service__Indicators_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", serviceIndicators := ");
single_value->field_serviceIndicators.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Service__Indicators_template::log_match(const M3UA__Service__Indicators& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_serviceIndicators.match(match_value.serviceIndicators(), legacy)){
TTCN_Logger::log_logmatch_info(".serviceIndicators");
single_value->field_serviceIndicators.log_match(match_value.serviceIndicators(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", serviceIndicators := ");
single_value->field_serviceIndicators.log_match(match_value.serviceIndicators(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Service__Indicators_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (serviceIndicators().is_bound()) serviceIndicators().set_implicit_omit();
}

void M3UA__Service__Indicators_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_serviceIndicators.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Service_Indicators.");
}
}

void M3UA__Service__Indicators_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_serviceIndicators.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Service__Indicators_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Service_Indicators.");
}
}

void M3UA__Service__Indicators_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Service__Indicators_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Service_Indicators has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) serviceIndicators().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "serviceIndicators")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          serviceIndicators().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Service_Indicators: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Service__Indicators_template* precondition = new M3UA__Service__Indicators_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Service__Indicators_template* implied_template = new M3UA__Service__Indicators_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Service__Indicators_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Service_Indicators");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Service__Indicators_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Service_Indicators");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Service_Indicators");
single_value->field_serviceIndicators.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Service_Indicators");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Service_Indicators");
}

boolean M3UA__Service__Indicators_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Service__Indicators_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
