// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "M3UA_Types.hh"

namespace M3UA__Types {

/* Member functions of C++ classes */

M3UA__OPC__List::M3UA__OPC__List()
{
}

M3UA__OPC__List::M3UA__OPC__List(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const M3UA__Point__Codes& par_pointCodes)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_pointCodes(par_pointCodes)
{
}

M3UA__OPC__List::M3UA__OPC__List(const M3UA__OPC__List& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_OPC_List.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.pointCodes().is_bound()) field_pointCodes = other_value.pointCodes();
else field_pointCodes.clean_up();
}

void M3UA__OPC__List::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_pointCodes.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__OPC__List::get_descriptor() const { return &M3UA__OPC__List_descr_; }
M3UA__OPC__List& M3UA__OPC__List::operator=(const M3UA__OPC__List& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_OPC_List.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.pointCodes().is_bound()) field_pointCodes = other_value.pointCodes();
  else field_pointCodes.clean_up();
}
return *this;
}

boolean M3UA__OPC__List::operator==(const M3UA__OPC__List& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_pointCodes==other_value.field_pointCodes;
}

boolean M3UA__OPC__List::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_pointCodes.is_bound());
}
boolean M3UA__OPC__List::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_pointCodes.is_value();
}
void M3UA__OPC__List::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", pointCodes := ");
field_pointCodes.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__OPC__List::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (pointCodes().is_bound()) pointCodes().set_implicit_omit();
}

void M3UA__OPC__List::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_OPC_List has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pointCodes().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointCodes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointCodes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_OPC_List: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_OPC_List");
  }
}

void M3UA__OPC__List::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_pointCodes.encode_text(text_buf);
}

void M3UA__OPC__List::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_pointCodes.decode_text(text_buf);
}

void M3UA__OPC__List::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__OPC__List::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__OPC__List::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__OPC__List_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__OPC__List_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__OPC__List_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Point__Codes_descr_.raw->forceomit);
  decoded_field_length = field_pointCodes.RAW_decode(M3UA__Point__Codes_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__OPC__List::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__OPC__List_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Point__Codes_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__OPC__List_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_pointCodes.RAW_encode(M3UA__Point__Codes_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__OPC__List_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
M3UA__Point__Codes_template field_pointCodes;
};

void M3UA__OPC__List_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_pointCodes = ANY_VALUE;
}
}
}

void M3UA__OPC__List_template::copy_value(const M3UA__OPC__List& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.pointCodes().is_bound()) {
  single_value->field_pointCodes = other_value.pointCodes();
} else {
  single_value->field_pointCodes.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__OPC__List_template::copy_template(const M3UA__OPC__List_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointCodes().get_selection()) {
single_value->field_pointCodes = other_value.pointCodes();
} else {
single_value->field_pointCodes.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__OPC__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__OPC__List_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__OPC__List_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_OPC_List.");
break;
}
set_selection(other_value);
}

M3UA__OPC__List_template::M3UA__OPC__List_template()
{
}

M3UA__OPC__List_template::M3UA__OPC__List_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__OPC__List_template::M3UA__OPC__List_template(const M3UA__OPC__List& other_value)
{
copy_value(other_value);
}

M3UA__OPC__List_template::M3UA__OPC__List_template(const OPTIONAL<M3UA__OPC__List>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__OPC__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_OPC_List from an unbound optional field.");
}
}

M3UA__OPC__List_template::M3UA__OPC__List_template(M3UA__OPC__List_template* p_precondition, M3UA__OPC__List_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__OPC__List_template::M3UA__OPC__List_template(Dynamic_Match_Interface<M3UA__OPC__List>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__OPC__List>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__OPC__List_template::M3UA__OPC__List_template(const M3UA__OPC__List_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__OPC__List_template::~M3UA__OPC__List_template()
{
clean_up();
}

M3UA__OPC__List_template& M3UA__OPC__List_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__OPC__List_template& M3UA__OPC__List_template::operator=(const M3UA__OPC__List& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__OPC__List_template& M3UA__OPC__List_template::operator=(const OPTIONAL<M3UA__OPC__List>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__OPC__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_OPC_List.");
}
return *this;
}

M3UA__OPC__List_template& M3UA__OPC__List_template::operator=(const M3UA__OPC__List_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__OPC__List_template::match(const M3UA__OPC__List& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.pointCodes().is_bound()) return FALSE;
if(!single_value->field_pointCodes.match(other_value.pointCodes(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_OPC_List.");
}
return FALSE;
}

boolean M3UA__OPC__List_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_pointCodes.is_bound();
}

boolean M3UA__OPC__List_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_pointCodes.is_value();
}

void M3UA__OPC__List_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__OPC__List M3UA__OPC__List_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_OPC_List.");
M3UA__OPC__List ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_pointCodes.is_bound()) {
ret_val.pointCodes() = single_value->field_pointCodes.valueof();
}
return ret_val;
}

void M3UA__OPC__List_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_OPC_List.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__OPC__List_template[list_length];
}

M3UA__OPC__List_template& M3UA__OPC__List_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_OPC_List.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_OPC_List.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__OPC__List_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__OPC__List_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_OPC_List.");
return single_value->field_tag;
}

INTEGER_template& M3UA__OPC__List_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__OPC__List_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_OPC_List.");
return single_value->field_lengthInd;
}

M3UA__Point__Codes_template& M3UA__OPC__List_template::pointCodes()
{
set_specific();
return single_value->field_pointCodes;
}

const M3UA__Point__Codes_template& M3UA__OPC__List_template::pointCodes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointCodes of a non-specific template of type @M3UA_Types.M3UA_OPC_List.");
return single_value->field_pointCodes;
}

int M3UA__OPC__List_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_OPC_List containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_OPC_List.");
  }
  return 0;
}

void M3UA__OPC__List_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", pointCodes := ");
single_value->field_pointCodes.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__OPC__List_template::log_match(const M3UA__OPC__List& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointCodes.match(match_value.pointCodes(), legacy)){
TTCN_Logger::log_logmatch_info(".pointCodes");
single_value->field_pointCodes.log_match(match_value.pointCodes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", pointCodes := ");
single_value->field_pointCodes.log_match(match_value.pointCodes(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__OPC__List_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (pointCodes().is_bound()) pointCodes().set_implicit_omit();
}

void M3UA__OPC__List_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_pointCodes.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_OPC_List.");
}
}

void M3UA__OPC__List_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_pointCodes.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__OPC__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_OPC_List.");
}
}

void M3UA__OPC__List_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__OPC__List_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_OPC_List has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pointCodes().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointCodes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointCodes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_OPC_List: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__OPC__List_template* precondition = new M3UA__OPC__List_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__OPC__List_template* implied_template = new M3UA__OPC__List_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__OPC__List_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_OPC_List");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__OPC__List_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_OPC_List");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_OPC_List");
single_value->field_pointCodes.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_OPC_List");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_OPC_List");
}

boolean M3UA__OPC__List_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__OPC__List_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Routing__Key__Parameters::M3UA__Routing__Key__Parameters()
{
}

M3UA__Routing__Key__Parameters::M3UA__Routing__Key__Parameters(const M3UA__Local__Routing__Key__Id& par_local__Routing__Key__Id,
    const OPTIONAL< M3UA__Routing__Context >& par_routing__Context,
    const OPTIONAL< M3UA__Traffic__Mode__Type >& par_traffic__Mode__Type,
    const M3UA__Destination__PointCode& par_destination__Point__Code,
    const OPTIONAL< M3UA__Network__Appearance >& par_network__Appearance,
    const OPTIONAL< M3UA__Service__Indicators >& par_service__Indicators,
    const OPTIONAL< M3UA__OPC__List >& par_opc__List)
  :   field_local__Routing__Key__Id(par_local__Routing__Key__Id),
  field_routing__Context(par_routing__Context),
  field_traffic__Mode__Type(par_traffic__Mode__Type),
  field_destination__Point__Code(par_destination__Point__Code),
  field_network__Appearance(par_network__Appearance),
  field_service__Indicators(par_service__Indicators),
  field_opc__List(par_opc__List)
{
}

M3UA__Routing__Key__Parameters::M3UA__Routing__Key__Parameters(const M3UA__Routing__Key__Parameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
if (other_value.local__Routing__Key__Id().is_bound()) field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
else field_local__Routing__Key__Id.clean_up();
if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
else field_routing__Context.clean_up();
if (other_value.traffic__Mode__Type().is_bound()) field_traffic__Mode__Type = other_value.traffic__Mode__Type();
else field_traffic__Mode__Type.clean_up();
if (other_value.destination__Point__Code().is_bound()) field_destination__Point__Code = other_value.destination__Point__Code();
else field_destination__Point__Code.clean_up();
if (other_value.network__Appearance().is_bound()) field_network__Appearance = other_value.network__Appearance();
else field_network__Appearance.clean_up();
if (other_value.service__Indicators().is_bound()) field_service__Indicators = other_value.service__Indicators();
else field_service__Indicators.clean_up();
if (other_value.opc__List().is_bound()) field_opc__List = other_value.opc__List();
else field_opc__List.clean_up();
}

void M3UA__Routing__Key__Parameters::clean_up()
{
field_local__Routing__Key__Id.clean_up();
field_routing__Context.clean_up();
field_traffic__Mode__Type.clean_up();
field_destination__Point__Code.clean_up();
field_network__Appearance.clean_up();
field_service__Indicators.clean_up();
field_opc__List.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Routing__Key__Parameters::get_descriptor() const { return &M3UA__Routing__Key__Parameters_descr_; }
M3UA__Routing__Key__Parameters& M3UA__Routing__Key__Parameters::operator=(const M3UA__Routing__Key__Parameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
  if (other_value.local__Routing__Key__Id().is_bound()) field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
  else field_local__Routing__Key__Id.clean_up();
  if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
  else field_routing__Context.clean_up();
  if (other_value.traffic__Mode__Type().is_bound()) field_traffic__Mode__Type = other_value.traffic__Mode__Type();
  else field_traffic__Mode__Type.clean_up();
  if (other_value.destination__Point__Code().is_bound()) field_destination__Point__Code = other_value.destination__Point__Code();
  else field_destination__Point__Code.clean_up();
  if (other_value.network__Appearance().is_bound()) field_network__Appearance = other_value.network__Appearance();
  else field_network__Appearance.clean_up();
  if (other_value.service__Indicators().is_bound()) field_service__Indicators = other_value.service__Indicators();
  else field_service__Indicators.clean_up();
  if (other_value.opc__List().is_bound()) field_opc__List = other_value.opc__List();
  else field_opc__List.clean_up();
}
return *this;
}

boolean M3UA__Routing__Key__Parameters::operator==(const M3UA__Routing__Key__Parameters& other_value) const
{
return field_local__Routing__Key__Id==other_value.field_local__Routing__Key__Id
  && field_routing__Context==other_value.field_routing__Context
  && field_traffic__Mode__Type==other_value.field_traffic__Mode__Type
  && field_destination__Point__Code==other_value.field_destination__Point__Code
  && field_network__Appearance==other_value.field_network__Appearance
  && field_service__Indicators==other_value.field_service__Indicators
  && field_opc__List==other_value.field_opc__List;
}

boolean M3UA__Routing__Key__Parameters::is_bound() const
{
return (field_local__Routing__Key__Id.is_bound())
  || (OPTIONAL_OMIT == field_routing__Context.get_selection() || field_routing__Context.is_bound())
  || (OPTIONAL_OMIT == field_traffic__Mode__Type.get_selection() || field_traffic__Mode__Type.is_bound())
  || (field_destination__Point__Code.is_bound())
  || (OPTIONAL_OMIT == field_network__Appearance.get_selection() || field_network__Appearance.is_bound())
  || (OPTIONAL_OMIT == field_service__Indicators.get_selection() || field_service__Indicators.is_bound())
  || (OPTIONAL_OMIT == field_opc__List.get_selection() || field_opc__List.is_bound());
}
boolean M3UA__Routing__Key__Parameters::is_value() const
{
return field_local__Routing__Key__Id.is_value()
  && (OPTIONAL_OMIT == field_routing__Context.get_selection() || field_routing__Context.is_value())
  && (OPTIONAL_OMIT == field_traffic__Mode__Type.get_selection() || field_traffic__Mode__Type.is_value())
  && field_destination__Point__Code.is_value()
  && (OPTIONAL_OMIT == field_network__Appearance.get_selection() || field_network__Appearance.is_value())
  && (OPTIONAL_OMIT == field_service__Indicators.get_selection() || field_service__Indicators.is_value())
  && (OPTIONAL_OMIT == field_opc__List.get_selection() || field_opc__List.is_value());
}
int M3UA__Routing__Key__Parameters::size_of() const
{
  int ret_val = 2;
  if (field_routing__Context.ispresent()) ret_val++;
  if (field_traffic__Mode__Type.ispresent()) ret_val++;
  if (field_network__Appearance.ispresent()) ret_val++;
  if (field_service__Indicators.ispresent()) ret_val++;
  if (field_opc__List.ispresent()) ret_val++;
  return ret_val;
}

void M3UA__Routing__Key__Parameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ local_Routing_Key_Id := ");
field_local__Routing__Key__Id.log();
TTCN_Logger::log_event_str(", routing_Context := ");
field_routing__Context.log();
TTCN_Logger::log_event_str(", traffic_Mode_Type := ");
field_traffic__Mode__Type.log();
TTCN_Logger::log_event_str(", destination_Point_Code := ");
field_destination__Point__Code.log();
TTCN_Logger::log_event_str(", network_Appearance := ");
field_network__Appearance.log();
TTCN_Logger::log_event_str(", service_Indicators := ");
field_service__Indicators.log();
TTCN_Logger::log_event_str(", opc_List := ");
field_opc__List.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Routing__Key__Parameters::set_implicit_omit()
{
if (local__Routing__Key__Id().is_bound()) local__Routing__Key__Id().set_implicit_omit();
if (!routing__Context().is_bound()) routing__Context() = OMIT_VALUE;
else routing__Context().set_implicit_omit();
if (!traffic__Mode__Type().is_bound()) traffic__Mode__Type() = OMIT_VALUE;
else traffic__Mode__Type().set_implicit_omit();
if (destination__Point__Code().is_bound()) destination__Point__Code().set_implicit_omit();
if (!network__Appearance().is_bound()) network__Appearance() = OMIT_VALUE;
else network__Appearance().set_implicit_omit();
if (!service__Indicators().is_bound()) service__Indicators() = OMIT_VALUE;
else service__Indicators().set_implicit_omit();
if (!opc__List().is_bound()) opc__List() = OMIT_VALUE;
else opc__List().set_implicit_omit();
}

void M3UA__Routing__Key__Parameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("set value of type @M3UA_Types.M3UA_Routing_Key_Parameters has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) local__Routing__Key__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) traffic__Mode__Type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) destination__Point__Code().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) network__Appearance().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) service__Indicators().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) opc__List().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "local_Routing_Key_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          local__Routing__Key__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "traffic_Mode_Type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          traffic__Mode__Type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destination_Point_Code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destination__Point__Code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "network_Appearance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          network__Appearance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "service_Indicators")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          service__Indicators().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "opc_List")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          opc__List().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Routing_Key_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@M3UA_Types.M3UA_Routing_Key_Parameters");
  }
}

void M3UA__Routing__Key__Parameters::encode_text(Text_Buf& text_buf) const
{
field_local__Routing__Key__Id.encode_text(text_buf);
field_routing__Context.encode_text(text_buf);
field_traffic__Mode__Type.encode_text(text_buf);
field_destination__Point__Code.encode_text(text_buf);
field_network__Appearance.encode_text(text_buf);
field_service__Indicators.encode_text(text_buf);
field_opc__List.encode_text(text_buf);
}

void M3UA__Routing__Key__Parameters::decode_text(Text_Buf& text_buf)
{
field_local__Routing__Key__Id.decode_text(text_buf);
field_routing__Context.decode_text(text_buf);
field_traffic__Mode__Type.decode_text(text_buf);
field_destination__Point__Code.decode_text(text_buf);
field_network__Appearance.decode_text(text_buf);
field_service__Indicators.decode_text(text_buf);
field_opc__List.decode_text(text_buf);
}

void M3UA__Routing__Key__Parameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Routing__Key__Parameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Routing__Key__Parameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[7];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_routing__Context = OMIT_VALUE;
field_traffic__Mode__Type = OMIT_VALUE;
field_network__Appearance = OMIT_VALUE;
field_service__Indicators = OMIT_VALUE;
field_opc__List = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Local__Routing__Key__Id_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Local__Routing__Key__Id_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_14) {
RAW_Force_Omit field_0_force_omit(0, force_omit, M3UA__Local__Routing__Key__Id_descr_.raw->forceomit);
int decoded_field_length = field_local__Routing__Key__Id.RAW_decode(M3UA__Local__Routing__Key__Id_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0 && (field_local__Routing__Key__Id.tag() ==  os_14)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_1) {
RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Routing__Context_descr_.raw->forceomit);
int decoded_field_length = field_routing__Context().RAW_decode(M3UA__Routing__Context_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0 && (field_routing__Context.ispresent() && field_routing__Context().tag() ==  os_1)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_routing__Context = OMIT_VALUE;
}
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Traffic__Mode__Type_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Traffic__Mode__Type_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_15) {
RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Traffic__Mode__Type_descr_.raw->forceomit);
int decoded_field_length = field_traffic__Mode__Type().RAW_decode(M3UA__Traffic__Mode__Type_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0 && (field_traffic__Mode__Type.ispresent() && field_traffic__Mode__Type().tag() ==  os_15)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_traffic__Mode__Type = OMIT_VALUE;
}
}
}
if (field_map[3] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Destination__PointCode_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Destination__PointCode_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_16) {
RAW_Force_Omit field_3_force_omit(3, force_omit, M3UA__Destination__PointCode_descr_.raw->forceomit);
int decoded_field_length = field_destination__Point__Code.RAW_decode(M3UA__Destination__PointCode_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length >= 0 && (field_destination__Point__Code.tag() ==  os_16)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
if (field_map[4] == 0 && (force_omit == NULL || !(*force_omit)(4))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Network__Appearance_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Network__Appearance_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_3) {
RAW_Force_Omit field_4_force_omit(4, force_omit, M3UA__Network__Appearance_descr_.raw->forceomit);
int decoded_field_length = field_network__Appearance().RAW_decode(M3UA__Network__Appearance_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
if (decoded_field_length > 0 && (field_network__Appearance.ispresent() && field_network__Appearance().tag() ==  os_3)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_network__Appearance = OMIT_VALUE;
}
}
}
if (field_map[5] == 0 && (force_omit == NULL || !(*force_omit)(5))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Service__Indicators_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Service__Indicators_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_17) {
RAW_Force_Omit field_5_force_omit(5, force_omit, M3UA__Service__Indicators_descr_.raw->forceomit);
int decoded_field_length = field_service__Indicators().RAW_decode(M3UA__Service__Indicators_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
if (decoded_field_length > 0 && (field_service__Indicators.ispresent() && field_service__Indicators().tag() ==  os_17)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[5] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_service__Indicators = OMIT_VALUE;
}
}
}
if (field_map[6] == 0 && (force_omit == NULL || !(*force_omit)(6))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__OPC__List_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__OPC__List_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_18) {
RAW_Force_Omit field_6_force_omit(6, force_omit, M3UA__OPC__List_descr_.raw->forceomit);
int decoded_field_length = field_opc__List().RAW_decode(M3UA__OPC__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
if (decoded_field_length > 0 && (field_opc__List.ispresent() && field_opc__List().tag() ==  os_18)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[6] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_opc__List = OMIT_VALUE;
}
}
}
break;
}
if (nof_mand_fields != 2) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Routing__Key__Parameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, M3UA__Local__Routing__Key__Id_descr_.raw);
  if (field_routing__Context.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Routing__Context_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_traffic__Mode__Type.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Traffic__Mode__Type_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, M3UA__Destination__PointCode_descr_.raw);
  if (field_network__Appearance.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, M3UA__Network__Appearance_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_service__Indicators.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, M3UA__Service__Indicators_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_opc__List.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, M3UA__OPC__List_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_local__Routing__Key__Id.RAW_encode(M3UA__Local__Routing__Key__Id_descr_, *myleaf.body.node.nodes[0]);
  if (field_routing__Context.ispresent()) {
  encoded_length += field_routing__Context().RAW_encode(M3UA__Routing__Context_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_traffic__Mode__Type.ispresent()) {
  encoded_length += field_traffic__Mode__Type().RAW_encode(M3UA__Traffic__Mode__Type_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_destination__Point__Code.RAW_encode(M3UA__Destination__PointCode_descr_, *myleaf.body.node.nodes[3]);
  if (field_network__Appearance.ispresent()) {
  encoded_length += field_network__Appearance().RAW_encode(M3UA__Network__Appearance_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_service__Indicators.ispresent()) {
  encoded_length += field_service__Indicators().RAW_encode(M3UA__Service__Indicators_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_opc__List.ispresent()) {
  encoded_length += field_opc__List().RAW_encode(M3UA__OPC__List_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_local__Routing__Key__Id.tag() !=  os_14) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_14.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_routing__Context.ispresent() && (!field_routing__Context.ispresent() || field_routing__Context().tag() !=  os_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_traffic__Mode__Type.ispresent() && (!field_traffic__Mode__Type.ispresent() || field_traffic__Mode__Type().tag() !=  os_15)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_15.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_destination__Point__Code.tag() !=  os_16) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_16.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_network__Appearance.ispresent() && (!field_network__Appearance.ispresent() || field_network__Appearance().tag() !=  os_3)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_3.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_service__Indicators.ispresent() && (!field_service__Indicators.ispresent() || field_service__Indicators().tag() !=  os_17)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_17.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_opc__List.ispresent() && (!field_opc__List.ispresent() || field_opc__List().tag() !=  os_18)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_18.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct M3UA__Routing__Key__Parameters_template::single_value_struct {
M3UA__Local__Routing__Key__Id_template field_local__Routing__Key__Id;
M3UA__Routing__Context_template field_routing__Context;
M3UA__Traffic__Mode__Type_template field_traffic__Mode__Type;
M3UA__Destination__PointCode_template field_destination__Point__Code;
M3UA__Network__Appearance_template field_network__Appearance;
M3UA__Service__Indicators_template field_service__Indicators;
M3UA__OPC__List_template field_opc__List;
};

void M3UA__Routing__Key__Parameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_local__Routing__Key__Id = ANY_VALUE;
single_value->field_routing__Context = ANY_OR_OMIT;
single_value->field_traffic__Mode__Type = ANY_OR_OMIT;
single_value->field_destination__Point__Code = ANY_VALUE;
single_value->field_network__Appearance = ANY_OR_OMIT;
single_value->field_service__Indicators = ANY_OR_OMIT;
single_value->field_opc__List = ANY_OR_OMIT;
}
}
}

void M3UA__Routing__Key__Parameters_template::copy_value(const M3UA__Routing__Key__Parameters& other_value)
{
single_value = new single_value_struct;
if (other_value.local__Routing__Key__Id().is_bound()) {
  single_value->field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
} else {
  single_value->field_local__Routing__Key__Id.clean_up();
}
if (other_value.routing__Context().is_bound()) {
  if (other_value.routing__Context().ispresent()) single_value->field_routing__Context = other_value.routing__Context()();
  else single_value->field_routing__Context = OMIT_VALUE;
} else {
  single_value->field_routing__Context.clean_up();
}
if (other_value.traffic__Mode__Type().is_bound()) {
  if (other_value.traffic__Mode__Type().ispresent()) single_value->field_traffic__Mode__Type = other_value.traffic__Mode__Type()();
  else single_value->field_traffic__Mode__Type = OMIT_VALUE;
} else {
  single_value->field_traffic__Mode__Type.clean_up();
}
if (other_value.destination__Point__Code().is_bound()) {
  single_value->field_destination__Point__Code = other_value.destination__Point__Code();
} else {
  single_value->field_destination__Point__Code.clean_up();
}
if (other_value.network__Appearance().is_bound()) {
  if (other_value.network__Appearance().ispresent()) single_value->field_network__Appearance = other_value.network__Appearance()();
  else single_value->field_network__Appearance = OMIT_VALUE;
} else {
  single_value->field_network__Appearance.clean_up();
}
if (other_value.service__Indicators().is_bound()) {
  if (other_value.service__Indicators().ispresent()) single_value->field_service__Indicators = other_value.service__Indicators()();
  else single_value->field_service__Indicators = OMIT_VALUE;
} else {
  single_value->field_service__Indicators.clean_up();
}
if (other_value.opc__List().is_bound()) {
  if (other_value.opc__List().ispresent()) single_value->field_opc__List = other_value.opc__List()();
  else single_value->field_opc__List = OMIT_VALUE;
} else {
  single_value->field_opc__List.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Routing__Key__Parameters_template::copy_template(const M3UA__Routing__Key__Parameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.local__Routing__Key__Id().get_selection()) {
single_value->field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
} else {
single_value->field_local__Routing__Key__Id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.routing__Context().get_selection()) {
single_value->field_routing__Context = other_value.routing__Context();
} else {
single_value->field_routing__Context.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.traffic__Mode__Type().get_selection()) {
single_value->field_traffic__Mode__Type = other_value.traffic__Mode__Type();
} else {
single_value->field_traffic__Mode__Type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destination__Point__Code().get_selection()) {
single_value->field_destination__Point__Code = other_value.destination__Point__Code();
} else {
single_value->field_destination__Point__Code.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.network__Appearance().get_selection()) {
single_value->field_network__Appearance = other_value.network__Appearance();
} else {
single_value->field_network__Appearance.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.service__Indicators().get_selection()) {
single_value->field_service__Indicators = other_value.service__Indicators();
} else {
single_value->field_service__Indicators.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.opc__List().get_selection()) {
single_value->field_opc__List = other_value.opc__List();
} else {
single_value->field_opc__List.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Routing__Key__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Routing__Key__Parameters_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Routing__Key__Parameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
break;
}
set_selection(other_value);
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template()
{
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template(const M3UA__Routing__Key__Parameters& other_value)
{
copy_value(other_value);
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template(const OPTIONAL<M3UA__Routing__Key__Parameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Routing__Key__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Routing_Key_Parameters from an unbound optional field.");
}
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template(M3UA__Routing__Key__Parameters_template* p_precondition, M3UA__Routing__Key__Parameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template(Dynamic_Match_Interface<M3UA__Routing__Key__Parameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Routing__Key__Parameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Routing__Key__Parameters_template::M3UA__Routing__Key__Parameters_template(const M3UA__Routing__Key__Parameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Routing__Key__Parameters_template::~M3UA__Routing__Key__Parameters_template()
{
clean_up();
}

M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key__Parameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key__Parameters_template::operator=(const M3UA__Routing__Key__Parameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key__Parameters_template::operator=(const OPTIONAL<M3UA__Routing__Key__Parameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Routing__Key__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
}
return *this;
}

M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key__Parameters_template::operator=(const M3UA__Routing__Key__Parameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Routing__Key__Parameters_template::match(const M3UA__Routing__Key__Parameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.local__Routing__Key__Id().is_bound()) return FALSE;
if(!single_value->field_local__Routing__Key__Id.match(other_value.local__Routing__Key__Id(), legacy))return FALSE;
if(!other_value.routing__Context().is_bound()) return FALSE;
if((other_value.routing__Context().ispresent() ? !single_value->field_routing__Context.match((const M3UA__Routing__Context&)other_value.routing__Context(), legacy) : !single_value->field_routing__Context.match_omit(legacy)))return FALSE;
if(!other_value.traffic__Mode__Type().is_bound()) return FALSE;
if((other_value.traffic__Mode__Type().ispresent() ? !single_value->field_traffic__Mode__Type.match((const M3UA__Traffic__Mode__Type&)other_value.traffic__Mode__Type(), legacy) : !single_value->field_traffic__Mode__Type.match_omit(legacy)))return FALSE;
if(!other_value.destination__Point__Code().is_bound()) return FALSE;
if(!single_value->field_destination__Point__Code.match(other_value.destination__Point__Code(), legacy))return FALSE;
if(!other_value.network__Appearance().is_bound()) return FALSE;
if((other_value.network__Appearance().ispresent() ? !single_value->field_network__Appearance.match((const M3UA__Network__Appearance&)other_value.network__Appearance(), legacy) : !single_value->field_network__Appearance.match_omit(legacy)))return FALSE;
if(!other_value.service__Indicators().is_bound()) return FALSE;
if((other_value.service__Indicators().ispresent() ? !single_value->field_service__Indicators.match((const M3UA__Service__Indicators&)other_value.service__Indicators(), legacy) : !single_value->field_service__Indicators.match_omit(legacy)))return FALSE;
if(!other_value.opc__List().is_bound()) return FALSE;
if((other_value.opc__List().ispresent() ? !single_value->field_opc__List.match((const M3UA__OPC__List&)other_value.opc__List(), legacy) : !single_value->field_opc__List.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
}
return FALSE;
}

boolean M3UA__Routing__Key__Parameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_local__Routing__Key__Id.is_bound()
 || (single_value->field_routing__Context.is_omit() || single_value->field_routing__Context.is_bound())
 || (single_value->field_traffic__Mode__Type.is_omit() || single_value->field_traffic__Mode__Type.is_bound())
 || single_value->field_destination__Point__Code.is_bound()
 || (single_value->field_network__Appearance.is_omit() || single_value->field_network__Appearance.is_bound())
 || (single_value->field_service__Indicators.is_omit() || single_value->field_service__Indicators.is_bound())
 || (single_value->field_opc__List.is_omit() || single_value->field_opc__List.is_bound());
}

boolean M3UA__Routing__Key__Parameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_local__Routing__Key__Id.is_value()
 && (single_value->field_routing__Context.is_omit() || single_value->field_routing__Context.is_value())
 && (single_value->field_traffic__Mode__Type.is_omit() || single_value->field_traffic__Mode__Type.is_value())
 && single_value->field_destination__Point__Code.is_value()
 && (single_value->field_network__Appearance.is_omit() || single_value->field_network__Appearance.is_value())
 && (single_value->field_service__Indicators.is_omit() || single_value->field_service__Indicators.is_value())
 && (single_value->field_opc__List.is_omit() || single_value->field_opc__List.is_value());
}

void M3UA__Routing__Key__Parameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Routing__Key__Parameters M3UA__Routing__Key__Parameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
M3UA__Routing__Key__Parameters ret_val;
if (single_value->field_local__Routing__Key__Id.is_bound()) {
ret_val.local__Routing__Key__Id() = single_value->field_local__Routing__Key__Id.valueof();
}
if (single_value->field_routing__Context.is_omit()) ret_val.routing__Context() = OMIT_VALUE;
else if (single_value->field_routing__Context.is_bound()) {
ret_val.routing__Context() = single_value->field_routing__Context.valueof();
}
if (single_value->field_traffic__Mode__Type.is_omit()) ret_val.traffic__Mode__Type() = OMIT_VALUE;
else if (single_value->field_traffic__Mode__Type.is_bound()) {
ret_val.traffic__Mode__Type() = single_value->field_traffic__Mode__Type.valueof();
}
if (single_value->field_destination__Point__Code.is_bound()) {
ret_val.destination__Point__Code() = single_value->field_destination__Point__Code.valueof();
}
if (single_value->field_network__Appearance.is_omit()) ret_val.network__Appearance() = OMIT_VALUE;
else if (single_value->field_network__Appearance.is_bound()) {
ret_val.network__Appearance() = single_value->field_network__Appearance.valueof();
}
if (single_value->field_service__Indicators.is_omit()) ret_val.service__Indicators() = OMIT_VALUE;
else if (single_value->field_service__Indicators.is_bound()) {
ret_val.service__Indicators() = single_value->field_service__Indicators.valueof();
}
if (single_value->field_opc__List.is_omit()) ret_val.opc__List() = OMIT_VALUE;
else if (single_value->field_opc__List.is_bound()) {
ret_val.opc__List() = single_value->field_opc__List.valueof();
}
return ret_val;
}

void M3UA__Routing__Key__Parameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Routing__Key__Parameters_template[list_length];
}

M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key__Parameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return value_list.list_value[list_index];
}

M3UA__Local__Routing__Key__Id_template& M3UA__Routing__Key__Parameters_template::local__Routing__Key__Id()
{
set_specific();
return single_value->field_local__Routing__Key__Id;
}

const M3UA__Local__Routing__Key__Id_template& M3UA__Routing__Key__Parameters_template::local__Routing__Key__Id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field local_Routing_Key_Id of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_local__Routing__Key__Id;
}

M3UA__Routing__Context_template& M3UA__Routing__Key__Parameters_template::routing__Context()
{
set_specific();
return single_value->field_routing__Context;
}

const M3UA__Routing__Context_template& M3UA__Routing__Key__Parameters_template::routing__Context() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field routing_Context of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_routing__Context;
}

M3UA__Traffic__Mode__Type_template& M3UA__Routing__Key__Parameters_template::traffic__Mode__Type()
{
set_specific();
return single_value->field_traffic__Mode__Type;
}

const M3UA__Traffic__Mode__Type_template& M3UA__Routing__Key__Parameters_template::traffic__Mode__Type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field traffic_Mode_Type of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_traffic__Mode__Type;
}

M3UA__Destination__PointCode_template& M3UA__Routing__Key__Parameters_template::destination__Point__Code()
{
set_specific();
return single_value->field_destination__Point__Code;
}

const M3UA__Destination__PointCode_template& M3UA__Routing__Key__Parameters_template::destination__Point__Code() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destination_Point_Code of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_destination__Point__Code;
}

M3UA__Network__Appearance_template& M3UA__Routing__Key__Parameters_template::network__Appearance()
{
set_specific();
return single_value->field_network__Appearance;
}

const M3UA__Network__Appearance_template& M3UA__Routing__Key__Parameters_template::network__Appearance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field network_Appearance of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_network__Appearance;
}

M3UA__Service__Indicators_template& M3UA__Routing__Key__Parameters_template::service__Indicators()
{
set_specific();
return single_value->field_service__Indicators;
}

const M3UA__Service__Indicators_template& M3UA__Routing__Key__Parameters_template::service__Indicators() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field service_Indicators of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_service__Indicators;
}

M3UA__OPC__List_template& M3UA__Routing__Key__Parameters_template::opc__List()
{
set_specific();
return single_value->field_opc__List;
}

const M3UA__OPC__List_template& M3UA__Routing__Key__Parameters_template::opc__List() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field opc_List of a non-specific template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
return single_value->field_opc__List;
}

int M3UA__Routing__Key__Parameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_routing__Context.is_present()) ret_val++;
      if (single_value->field_traffic__Mode__Type.is_present()) ret_val++;
      if (single_value->field_network__Appearance.is_present()) ret_val++;
      if (single_value->field_service__Indicators.is_present()) ret_val++;
      if (single_value->field_opc__List.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key_Parameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
  }
  return 0;
}

void M3UA__Routing__Key__Parameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ local_Routing_Key_Id := ");
single_value->field_local__Routing__Key__Id.log();
TTCN_Logger::log_event_str(", routing_Context := ");
single_value->field_routing__Context.log();
TTCN_Logger::log_event_str(", traffic_Mode_Type := ");
single_value->field_traffic__Mode__Type.log();
TTCN_Logger::log_event_str(", destination_Point_Code := ");
single_value->field_destination__Point__Code.log();
TTCN_Logger::log_event_str(", network_Appearance := ");
single_value->field_network__Appearance.log();
TTCN_Logger::log_event_str(", service_Indicators := ");
single_value->field_service__Indicators.log();
TTCN_Logger::log_event_str(", opc_List := ");
single_value->field_opc__List.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Routing__Key__Parameters_template::log_match(const M3UA__Routing__Key__Parameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_local__Routing__Key__Id.match(match_value.local__Routing__Key__Id(), legacy)){
TTCN_Logger::log_logmatch_info(".local_Routing_Key_Id");
single_value->field_local__Routing__Key__Id.log_match(match_value.local__Routing__Key__Id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.routing__Context().ispresent()){
if(!single_value->field_routing__Context.match(match_value.routing__Context(), legacy)){
TTCN_Logger::log_logmatch_info(".routing_Context");
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_routing__Context.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".routing_Context := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_routing__Context.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.traffic__Mode__Type().ispresent()){
if(!single_value->field_traffic__Mode__Type.match(match_value.traffic__Mode__Type(), legacy)){
TTCN_Logger::log_logmatch_info(".traffic_Mode_Type");
single_value->field_traffic__Mode__Type.log_match(match_value.traffic__Mode__Type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_traffic__Mode__Type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".traffic_Mode_Type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_traffic__Mode__Type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_destination__Point__Code.match(match_value.destination__Point__Code(), legacy)){
TTCN_Logger::log_logmatch_info(".destination_Point_Code");
single_value->field_destination__Point__Code.log_match(match_value.destination__Point__Code(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.network__Appearance().ispresent()){
if(!single_value->field_network__Appearance.match(match_value.network__Appearance(), legacy)){
TTCN_Logger::log_logmatch_info(".network_Appearance");
single_value->field_network__Appearance.log_match(match_value.network__Appearance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_network__Appearance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".network_Appearance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_network__Appearance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.service__Indicators().ispresent()){
if(!single_value->field_service__Indicators.match(match_value.service__Indicators(), legacy)){
TTCN_Logger::log_logmatch_info(".service_Indicators");
single_value->field_service__Indicators.log_match(match_value.service__Indicators(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_service__Indicators.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".service_Indicators := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_service__Indicators.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.opc__List().ispresent()){
if(!single_value->field_opc__List.match(match_value.opc__List(), legacy)){
TTCN_Logger::log_logmatch_info(".opc_List");
single_value->field_opc__List.log_match(match_value.opc__List(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_opc__List.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".opc_List := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_opc__List.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ local_Routing_Key_Id := ");
single_value->field_local__Routing__Key__Id.log_match(match_value.local__Routing__Key__Id(), legacy);
TTCN_Logger::log_event_str(", routing_Context := ");
if (match_value.routing__Context().ispresent()) {
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_routing__Context.log();
if (single_value->field_routing__Context.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", traffic_Mode_Type := ");
if (match_value.traffic__Mode__Type().ispresent()) {
single_value->field_traffic__Mode__Type.log_match(match_value.traffic__Mode__Type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_traffic__Mode__Type.log();
if (single_value->field_traffic__Mode__Type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", destination_Point_Code := ");
single_value->field_destination__Point__Code.log_match(match_value.destination__Point__Code(), legacy);
TTCN_Logger::log_event_str(", network_Appearance := ");
if (match_value.network__Appearance().ispresent()) {
single_value->field_network__Appearance.log_match(match_value.network__Appearance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_network__Appearance.log();
if (single_value->field_network__Appearance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", service_Indicators := ");
if (match_value.service__Indicators().ispresent()) {
single_value->field_service__Indicators.log_match(match_value.service__Indicators(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_service__Indicators.log();
if (single_value->field_service__Indicators.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", opc_List := ");
if (match_value.opc__List().ispresent()) {
single_value->field_opc__List.log_match(match_value.opc__List(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_opc__List.log();
if (single_value->field_opc__List.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Routing__Key__Parameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (local__Routing__Key__Id().is_bound()) local__Routing__Key__Id().set_implicit_omit();
if (!routing__Context().is_bound()) routing__Context() = OMIT_VALUE;
else routing__Context().set_implicit_omit();
if (!traffic__Mode__Type().is_bound()) traffic__Mode__Type() = OMIT_VALUE;
else traffic__Mode__Type().set_implicit_omit();
if (destination__Point__Code().is_bound()) destination__Point__Code().set_implicit_omit();
if (!network__Appearance().is_bound()) network__Appearance() = OMIT_VALUE;
else network__Appearance().set_implicit_omit();
if (!service__Indicators().is_bound()) service__Indicators() = OMIT_VALUE;
else service__Indicators().set_implicit_omit();
if (!opc__List().is_bound()) opc__List() = OMIT_VALUE;
else opc__List().set_implicit_omit();
}

void M3UA__Routing__Key__Parameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_local__Routing__Key__Id.encode_text(text_buf);
single_value->field_routing__Context.encode_text(text_buf);
single_value->field_traffic__Mode__Type.encode_text(text_buf);
single_value->field_destination__Point__Code.encode_text(text_buf);
single_value->field_network__Appearance.encode_text(text_buf);
single_value->field_service__Indicators.encode_text(text_buf);
single_value->field_opc__List.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
}
}

void M3UA__Routing__Key__Parameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_local__Routing__Key__Id.decode_text(text_buf);
single_value->field_routing__Context.decode_text(text_buf);
single_value->field_traffic__Mode__Type.decode_text(text_buf);
single_value->field_destination__Point__Code.decode_text(text_buf);
single_value->field_network__Appearance.decode_text(text_buf);
single_value->field_service__Indicators.decode_text(text_buf);
single_value->field_opc__List.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Routing__Key__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Routing_Key_Parameters.");
}
}

void M3UA__Routing__Key__Parameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Routing__Key__Parameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("set template of type @M3UA_Types.M3UA_Routing_Key_Parameters has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) local__Routing__Key__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) traffic__Mode__Type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) destination__Point__Code().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) network__Appearance().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) service__Indicators().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) opc__List().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "local_Routing_Key_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          local__Routing__Key__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "traffic_Mode_Type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          traffic__Mode__Type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destination_Point_Code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destination__Point__Code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "network_Appearance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          network__Appearance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "service_Indicators")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          service__Indicators().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "opc_List")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          opc__List().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Routing_Key_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Routing__Key__Parameters_template* precondition = new M3UA__Routing__Key__Parameters_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Routing__Key__Parameters_template* implied_template = new M3UA__Routing__Key__Parameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Routing__Key__Parameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@M3UA_Types.M3UA_Routing_Key_Parameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Routing__Key__Parameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_local__Routing__Key__Id.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
single_value->field_routing__Context.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
single_value->field_traffic__Mode__Type.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
single_value->field_destination__Point__Code.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
single_value->field_network__Appearance.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
single_value->field_service__Indicators.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
single_value->field_opc__List.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key_Parameters");
}

boolean M3UA__Routing__Key__Parameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Routing__Key__Parameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Routing__Key::M3UA__Routing__Key()
{
}

M3UA__Routing__Key::M3UA__Routing__Key(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const M3UA__Routing__Key__Parameters& par_routingKey)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_routingKey(par_routingKey)
{
}

M3UA__Routing__Key::M3UA__Routing__Key(const M3UA__Routing__Key& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Routing_Key.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.routingKey().is_bound()) field_routingKey = other_value.routingKey();
else field_routingKey.clean_up();
}

void M3UA__Routing__Key::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_routingKey.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Routing__Key::get_descriptor() const { return &M3UA__Routing__Key_descr_; }
M3UA__Routing__Key& M3UA__Routing__Key::operator=(const M3UA__Routing__Key& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Routing_Key.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.routingKey().is_bound()) field_routingKey = other_value.routingKey();
  else field_routingKey.clean_up();
}
return *this;
}

boolean M3UA__Routing__Key::operator==(const M3UA__Routing__Key& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_routingKey==other_value.field_routingKey;
}

boolean M3UA__Routing__Key::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_routingKey.is_bound());
}
boolean M3UA__Routing__Key::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_routingKey.is_value();
}
void M3UA__Routing__Key::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", routingKey := ");
field_routingKey.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Routing__Key::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (routingKey().is_bound()) routingKey().set_implicit_omit();
}

void M3UA__Routing__Key::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Routing_Key has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) routingKey().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routingKey")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routingKey().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Routing_Key: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Routing_Key");
  }
}

void M3UA__Routing__Key::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_routingKey.encode_text(text_buf);
}

void M3UA__Routing__Key::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_routingKey.decode_text(text_buf);
}

void M3UA__Routing__Key::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Routing__Key::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Routing__Key::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Routing__Key_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Routing__Key_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Routing__Key_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Routing__Key__Parameters_descr_.raw->forceomit);
  decoded_field_length = field_routingKey.RAW_decode(M3UA__Routing__Key__Parameters_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Routing__Key::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Routing__Key_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Routing__Key__Parameters_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Routing__Key_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_routingKey.RAW_encode(M3UA__Routing__Key__Parameters_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Routing__Key_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
M3UA__Routing__Key__Parameters_template field_routingKey;
};

void M3UA__Routing__Key_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_routingKey = ANY_VALUE;
}
}
}

void M3UA__Routing__Key_template::copy_value(const M3UA__Routing__Key& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.routingKey().is_bound()) {
  single_value->field_routingKey = other_value.routingKey();
} else {
  single_value->field_routingKey.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Routing__Key_template::copy_template(const M3UA__Routing__Key_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.routingKey().get_selection()) {
single_value->field_routingKey = other_value.routingKey();
} else {
single_value->field_routingKey.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Routing__Key_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Routing__Key_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Routing__Key_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key.");
break;
}
set_selection(other_value);
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template()
{
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template(const M3UA__Routing__Key& other_value)
{
copy_value(other_value);
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template(const OPTIONAL<M3UA__Routing__Key>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Routing__Key&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Routing_Key from an unbound optional field.");
}
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template(M3UA__Routing__Key_template* p_precondition, M3UA__Routing__Key_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template(Dynamic_Match_Interface<M3UA__Routing__Key>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Routing__Key>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Routing__Key_template::M3UA__Routing__Key_template(const M3UA__Routing__Key_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Routing__Key_template::~M3UA__Routing__Key_template()
{
clean_up();
}

M3UA__Routing__Key_template& M3UA__Routing__Key_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Routing__Key_template& M3UA__Routing__Key_template::operator=(const M3UA__Routing__Key& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Routing__Key_template& M3UA__Routing__Key_template::operator=(const OPTIONAL<M3UA__Routing__Key>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Routing__Key&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Routing_Key.");
}
return *this;
}

M3UA__Routing__Key_template& M3UA__Routing__Key_template::operator=(const M3UA__Routing__Key_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Routing__Key_template::match(const M3UA__Routing__Key& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.routingKey().is_bound()) return FALSE;
if(!single_value->field_routingKey.match(other_value.routingKey(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key.");
}
return FALSE;
}

boolean M3UA__Routing__Key_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_routingKey.is_bound();
}

boolean M3UA__Routing__Key_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_routingKey.is_value();
}

void M3UA__Routing__Key_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Routing__Key M3UA__Routing__Key_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Routing_Key.");
M3UA__Routing__Key ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_routingKey.is_bound()) {
ret_val.routingKey() = single_value->field_routingKey.valueof();
}
return ret_val;
}

void M3UA__Routing__Key_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Routing_Key.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Routing__Key_template[list_length];
}

M3UA__Routing__Key_template& M3UA__Routing__Key_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Routing_Key.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Routing_Key.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Routing__Key_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Routing__Key_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Routing_Key.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Routing__Key_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Routing__Key_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Routing_Key.");
return single_value->field_lengthInd;
}

M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key_template::routingKey()
{
set_specific();
return single_value->field_routingKey;
}

const M3UA__Routing__Key__Parameters_template& M3UA__Routing__Key_template::routingKey() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field routingKey of a non-specific template of type @M3UA_Types.M3UA_Routing_Key.");
return single_value->field_routingKey;
}

int M3UA__Routing__Key_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Routing_Key containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key.");
  }
  return 0;
}

void M3UA__Routing__Key_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", routingKey := ");
single_value->field_routingKey.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Routing__Key_template::log_match(const M3UA__Routing__Key& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_routingKey.match(match_value.routingKey(), legacy)){
TTCN_Logger::log_logmatch_info(".routingKey");
single_value->field_routingKey.log_match(match_value.routingKey(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", routingKey := ");
single_value->field_routingKey.log_match(match_value.routingKey(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Routing__Key_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (routingKey().is_bound()) routingKey().set_implicit_omit();
}

void M3UA__Routing__Key_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_routingKey.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Routing_Key.");
}
}

void M3UA__Routing__Key_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_routingKey.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Routing__Key_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Routing_Key.");
}
}

void M3UA__Routing__Key_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Routing__Key_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Routing_Key has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) routingKey().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routingKey")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routingKey().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Routing_Key: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Routing__Key_template* precondition = new M3UA__Routing__Key_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Routing__Key_template* implied_template = new M3UA__Routing__Key_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Routing__Key_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Routing_Key");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Routing__Key_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key");
single_value->field_routingKey.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Routing_Key");
}

boolean M3UA__Routing__Key_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Routing__Key_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Registration__Status::M3UA__Registration__Status()
{
}

M3UA__Registration__Status::M3UA__Registration__Status(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_registrationStatus)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_registrationStatus(par_registrationStatus)
{
}

M3UA__Registration__Status::M3UA__Registration__Status(const M3UA__Registration__Status& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Registration_Status.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.registrationStatus().is_bound()) field_registrationStatus = other_value.registrationStatus();
else field_registrationStatus.clean_up();
}

void M3UA__Registration__Status::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_registrationStatus.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Registration__Status::get_descriptor() const { return &M3UA__Registration__Status_descr_; }
M3UA__Registration__Status& M3UA__Registration__Status::operator=(const M3UA__Registration__Status& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Registration_Status.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.registrationStatus().is_bound()) field_registrationStatus = other_value.registrationStatus();
  else field_registrationStatus.clean_up();
}
return *this;
}

boolean M3UA__Registration__Status::operator==(const M3UA__Registration__Status& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_registrationStatus==other_value.field_registrationStatus;
}

boolean M3UA__Registration__Status::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_registrationStatus.is_bound());
}
boolean M3UA__Registration__Status::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_registrationStatus.is_value();
}
void M3UA__Registration__Status::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", registrationStatus := ");
field_registrationStatus.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Registration__Status::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (registrationStatus().is_bound()) registrationStatus().set_implicit_omit();
}

void M3UA__Registration__Status::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Registration_Status has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) registrationStatus().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "registrationStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          registrationStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Registration_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Registration_Status");
  }
}

void M3UA__Registration__Status::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_registrationStatus.encode_text(text_buf);
}

void M3UA__Registration__Status::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_registrationStatus.decode_text(text_buf);
}

void M3UA__Registration__Status::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Registration__Status::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Registration__Status::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Registration__Status_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Registration__Status_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Registration__Status_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_registrationStatus.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Registration__Status::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Registration__Status_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Registration__Status_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_registrationStatus.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Registration__Status_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_registrationStatus;
};

void M3UA__Registration__Status_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_registrationStatus = ANY_VALUE;
}
}
}

void M3UA__Registration__Status_template::copy_value(const M3UA__Registration__Status& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.registrationStatus().is_bound()) {
  single_value->field_registrationStatus = other_value.registrationStatus();
} else {
  single_value->field_registrationStatus.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Registration__Status_template::copy_template(const M3UA__Registration__Status_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.registrationStatus().get_selection()) {
single_value->field_registrationStatus = other_value.registrationStatus();
} else {
single_value->field_registrationStatus.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Registration__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Registration__Status_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Registration__Status_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Status.");
break;
}
set_selection(other_value);
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template()
{
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template(const M3UA__Registration__Status& other_value)
{
copy_value(other_value);
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template(const OPTIONAL<M3UA__Registration__Status>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Registration__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Registration_Status from an unbound optional field.");
}
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template(M3UA__Registration__Status_template* p_precondition, M3UA__Registration__Status_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template(Dynamic_Match_Interface<M3UA__Registration__Status>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Registration__Status>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Registration__Status_template::M3UA__Registration__Status_template(const M3UA__Registration__Status_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Registration__Status_template::~M3UA__Registration__Status_template()
{
clean_up();
}

M3UA__Registration__Status_template& M3UA__Registration__Status_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Registration__Status_template& M3UA__Registration__Status_template::operator=(const M3UA__Registration__Status& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Registration__Status_template& M3UA__Registration__Status_template::operator=(const OPTIONAL<M3UA__Registration__Status>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Registration__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Registration_Status.");
}
return *this;
}

M3UA__Registration__Status_template& M3UA__Registration__Status_template::operator=(const M3UA__Registration__Status_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Registration__Status_template::match(const M3UA__Registration__Status& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.registrationStatus().is_bound()) return FALSE;
if(!single_value->field_registrationStatus.match(other_value.registrationStatus(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Status.");
}
return FALSE;
}

boolean M3UA__Registration__Status_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_registrationStatus.is_bound();
}

boolean M3UA__Registration__Status_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_registrationStatus.is_value();
}

void M3UA__Registration__Status_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Registration__Status M3UA__Registration__Status_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Registration_Status.");
M3UA__Registration__Status ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_registrationStatus.is_bound()) {
ret_val.registrationStatus() = single_value->field_registrationStatus.valueof();
}
return ret_val;
}

void M3UA__Registration__Status_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Registration_Status.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Registration__Status_template[list_length];
}

M3UA__Registration__Status_template& M3UA__Registration__Status_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Registration_Status.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Registration_Status.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Registration__Status_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Registration__Status_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Registration_Status.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Registration__Status_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Registration__Status_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Registration_Status.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Registration__Status_template::registrationStatus()
{
set_specific();
return single_value->field_registrationStatus;
}

const OCTETSTRING_template& M3UA__Registration__Status_template::registrationStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field registrationStatus of a non-specific template of type @M3UA_Types.M3UA_Registration_Status.");
return single_value->field_registrationStatus;
}

int M3UA__Registration__Status_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Status containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Status.");
  }
  return 0;
}

void M3UA__Registration__Status_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", registrationStatus := ");
single_value->field_registrationStatus.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Registration__Status_template::log_match(const M3UA__Registration__Status& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_registrationStatus.match(match_value.registrationStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".registrationStatus");
single_value->field_registrationStatus.log_match(match_value.registrationStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", registrationStatus := ");
single_value->field_registrationStatus.log_match(match_value.registrationStatus(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Registration__Status_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (registrationStatus().is_bound()) registrationStatus().set_implicit_omit();
}

void M3UA__Registration__Status_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_registrationStatus.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Status.");
}
}

void M3UA__Registration__Status_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_registrationStatus.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Registration__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Registration_Status.");
}
}

void M3UA__Registration__Status_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Registration__Status_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Registration_Status has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) registrationStatus().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "registrationStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          registrationStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Registration_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Registration__Status_template* precondition = new M3UA__Registration__Status_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Registration__Status_template* implied_template = new M3UA__Registration__Status_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Registration__Status_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Registration_Status");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Registration__Status_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Status");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Status");
single_value->field_registrationStatus.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Status");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Registration_Status");
}

boolean M3UA__Registration__Status_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Registration__Status_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Deregistration__Status::M3UA__Deregistration__Status()
{
}

M3UA__Deregistration__Status::M3UA__Deregistration__Status(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const OCTETSTRING& par_deregistrationStatus)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_deregistrationStatus(par_deregistrationStatus)
{
}

M3UA__Deregistration__Status::M3UA__Deregistration__Status(const M3UA__Deregistration__Status& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Deregistration_Status.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.deregistrationStatus().is_bound()) field_deregistrationStatus = other_value.deregistrationStatus();
else field_deregistrationStatus.clean_up();
}

void M3UA__Deregistration__Status::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_deregistrationStatus.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Deregistration__Status::get_descriptor() const { return &M3UA__Deregistration__Status_descr_; }
M3UA__Deregistration__Status& M3UA__Deregistration__Status::operator=(const M3UA__Deregistration__Status& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Deregistration_Status.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.deregistrationStatus().is_bound()) field_deregistrationStatus = other_value.deregistrationStatus();
  else field_deregistrationStatus.clean_up();
}
return *this;
}

boolean M3UA__Deregistration__Status::operator==(const M3UA__Deregistration__Status& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_deregistrationStatus==other_value.field_deregistrationStatus;
}

boolean M3UA__Deregistration__Status::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_deregistrationStatus.is_bound());
}
boolean M3UA__Deregistration__Status::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_deregistrationStatus.is_value();
}
void M3UA__Deregistration__Status::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", deregistrationStatus := ");
field_deregistrationStatus.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Deregistration__Status::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (deregistrationStatus().is_bound()) deregistrationStatus().set_implicit_omit();
}

void M3UA__Deregistration__Status::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Deregistration_Status has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) deregistrationStatus().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deregistrationStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deregistrationStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Deregistration_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Deregistration_Status");
  }
}

void M3UA__Deregistration__Status::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_deregistrationStatus.encode_text(text_buf);
}

void M3UA__Deregistration__Status::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_deregistrationStatus.decode_text(text_buf);
}

void M3UA__Deregistration__Status::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Deregistration__Status::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Deregistration__Status::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Deregistration__Status_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Deregistration__Status_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Deregistration__Status_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_deregistrationStatus.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Deregistration__Status::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Deregistration__Status_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Deregistration__Status_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_deregistrationStatus.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Deregistration__Status_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
OCTETSTRING_template field_deregistrationStatus;
};

void M3UA__Deregistration__Status_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_deregistrationStatus = ANY_VALUE;
}
}
}

void M3UA__Deregistration__Status_template::copy_value(const M3UA__Deregistration__Status& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.deregistrationStatus().is_bound()) {
  single_value->field_deregistrationStatus = other_value.deregistrationStatus();
} else {
  single_value->field_deregistrationStatus.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Deregistration__Status_template::copy_template(const M3UA__Deregistration__Status_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deregistrationStatus().get_selection()) {
single_value->field_deregistrationStatus = other_value.deregistrationStatus();
} else {
single_value->field_deregistrationStatus.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Deregistration__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Deregistration__Status_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Deregistration__Status_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Status.");
break;
}
set_selection(other_value);
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template()
{
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template(const M3UA__Deregistration__Status& other_value)
{
copy_value(other_value);
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template(const OPTIONAL<M3UA__Deregistration__Status>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Deregistration__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Deregistration_Status from an unbound optional field.");
}
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template(M3UA__Deregistration__Status_template* p_precondition, M3UA__Deregistration__Status_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template(Dynamic_Match_Interface<M3UA__Deregistration__Status>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Deregistration__Status>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Deregistration__Status_template::M3UA__Deregistration__Status_template(const M3UA__Deregistration__Status_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Deregistration__Status_template::~M3UA__Deregistration__Status_template()
{
clean_up();
}

M3UA__Deregistration__Status_template& M3UA__Deregistration__Status_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Deregistration__Status_template& M3UA__Deregistration__Status_template::operator=(const M3UA__Deregistration__Status& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Deregistration__Status_template& M3UA__Deregistration__Status_template::operator=(const OPTIONAL<M3UA__Deregistration__Status>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Deregistration__Status&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Deregistration_Status.");
}
return *this;
}

M3UA__Deregistration__Status_template& M3UA__Deregistration__Status_template::operator=(const M3UA__Deregistration__Status_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Deregistration__Status_template::match(const M3UA__Deregistration__Status& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.deregistrationStatus().is_bound()) return FALSE;
if(!single_value->field_deregistrationStatus.match(other_value.deregistrationStatus(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Status.");
}
return FALSE;
}

boolean M3UA__Deregistration__Status_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_deregistrationStatus.is_bound();
}

boolean M3UA__Deregistration__Status_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_deregistrationStatus.is_value();
}

void M3UA__Deregistration__Status_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Deregistration__Status M3UA__Deregistration__Status_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Deregistration_Status.");
M3UA__Deregistration__Status ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_deregistrationStatus.is_bound()) {
ret_val.deregistrationStatus() = single_value->field_deregistrationStatus.valueof();
}
return ret_val;
}

void M3UA__Deregistration__Status_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Deregistration_Status.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Deregistration__Status_template[list_length];
}

M3UA__Deregistration__Status_template& M3UA__Deregistration__Status_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Deregistration_Status.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Deregistration_Status.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Deregistration__Status_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Deregistration__Status_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Status.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Deregistration__Status_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Deregistration__Status_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Status.");
return single_value->field_lengthInd;
}

OCTETSTRING_template& M3UA__Deregistration__Status_template::deregistrationStatus()
{
set_specific();
return single_value->field_deregistrationStatus;
}

const OCTETSTRING_template& M3UA__Deregistration__Status_template::deregistrationStatus() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deregistrationStatus of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Status.");
return single_value->field_deregistrationStatus;
}

int M3UA__Deregistration__Status_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Status containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Status.");
  }
  return 0;
}

void M3UA__Deregistration__Status_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", deregistrationStatus := ");
single_value->field_deregistrationStatus.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Deregistration__Status_template::log_match(const M3UA__Deregistration__Status& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_deregistrationStatus.match(match_value.deregistrationStatus(), legacy)){
TTCN_Logger::log_logmatch_info(".deregistrationStatus");
single_value->field_deregistrationStatus.log_match(match_value.deregistrationStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", deregistrationStatus := ");
single_value->field_deregistrationStatus.log_match(match_value.deregistrationStatus(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Deregistration__Status_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (deregistrationStatus().is_bound()) deregistrationStatus().set_implicit_omit();
}

void M3UA__Deregistration__Status_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_deregistrationStatus.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Status.");
}
}

void M3UA__Deregistration__Status_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_deregistrationStatus.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Deregistration__Status_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Deregistration_Status.");
}
}

void M3UA__Deregistration__Status_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Deregistration__Status_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Deregistration_Status has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) deregistrationStatus().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deregistrationStatus")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deregistrationStatus().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Deregistration_Status: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Deregistration__Status_template* precondition = new M3UA__Deregistration__Status_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Deregistration__Status_template* implied_template = new M3UA__Deregistration__Status_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Deregistration__Status_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Deregistration_Status");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Deregistration__Status_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Status");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Status");
single_value->field_deregistrationStatus.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Status");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Status");
}

boolean M3UA__Deregistration__Status_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Deregistration__Status_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Registration__Result__Parameters::M3UA__Registration__Result__Parameters()
{
}

M3UA__Registration__Result__Parameters::M3UA__Registration__Result__Parameters(const M3UA__Local__Routing__Key__Id& par_local__Routing__Key__Id,
    const M3UA__Registration__Status& par_registration__Status,
    const M3UA__Routing__Context& par_routing__Context)
  :   field_local__Routing__Key__Id(par_local__Routing__Key__Id),
  field_registration__Status(par_registration__Status),
  field_routing__Context(par_routing__Context)
{
}

M3UA__Registration__Result__Parameters::M3UA__Registration__Result__Parameters(const M3UA__Registration__Result__Parameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
if (other_value.local__Routing__Key__Id().is_bound()) field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
else field_local__Routing__Key__Id.clean_up();
if (other_value.registration__Status().is_bound()) field_registration__Status = other_value.registration__Status();
else field_registration__Status.clean_up();
if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
else field_routing__Context.clean_up();
}

void M3UA__Registration__Result__Parameters::clean_up()
{
field_local__Routing__Key__Id.clean_up();
field_registration__Status.clean_up();
field_routing__Context.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Registration__Result__Parameters::get_descriptor() const { return &M3UA__Registration__Result__Parameters_descr_; }
M3UA__Registration__Result__Parameters& M3UA__Registration__Result__Parameters::operator=(const M3UA__Registration__Result__Parameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
  if (other_value.local__Routing__Key__Id().is_bound()) field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
  else field_local__Routing__Key__Id.clean_up();
  if (other_value.registration__Status().is_bound()) field_registration__Status = other_value.registration__Status();
  else field_registration__Status.clean_up();
  if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
  else field_routing__Context.clean_up();
}
return *this;
}

boolean M3UA__Registration__Result__Parameters::operator==(const M3UA__Registration__Result__Parameters& other_value) const
{
return field_local__Routing__Key__Id==other_value.field_local__Routing__Key__Id
  && field_registration__Status==other_value.field_registration__Status
  && field_routing__Context==other_value.field_routing__Context;
}

boolean M3UA__Registration__Result__Parameters::is_bound() const
{
return (field_local__Routing__Key__Id.is_bound())
  || (field_registration__Status.is_bound())
  || (field_routing__Context.is_bound());
}
boolean M3UA__Registration__Result__Parameters::is_value() const
{
return field_local__Routing__Key__Id.is_value()
  && field_registration__Status.is_value()
  && field_routing__Context.is_value();
}
void M3UA__Registration__Result__Parameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ local_Routing_Key_Id := ");
field_local__Routing__Key__Id.log();
TTCN_Logger::log_event_str(", registration_Status := ");
field_registration__Status.log();
TTCN_Logger::log_event_str(", routing_Context := ");
field_routing__Context.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Registration__Result__Parameters::set_implicit_omit()
{
if (local__Routing__Key__Id().is_bound()) local__Routing__Key__Id().set_implicit_omit();
if (registration__Status().is_bound()) registration__Status().set_implicit_omit();
if (routing__Context().is_bound()) routing__Context().set_implicit_omit();
}

void M3UA__Registration__Result__Parameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("set value of type @M3UA_Types.M3UA_Registration_Result_Parameters has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) local__Routing__Key__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) registration__Status().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "local_Routing_Key_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          local__Routing__Key__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "registration_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          registration__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Registration_Result_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@M3UA_Types.M3UA_Registration_Result_Parameters");
  }
}

void M3UA__Registration__Result__Parameters::encode_text(Text_Buf& text_buf) const
{
field_local__Routing__Key__Id.encode_text(text_buf);
field_registration__Status.encode_text(text_buf);
field_routing__Context.encode_text(text_buf);
}

void M3UA__Registration__Result__Parameters::decode_text(Text_Buf& text_buf)
{
field_local__Routing__Key__Id.decode_text(text_buf);
field_registration__Status.decode_text(text_buf);
field_routing__Context.decode_text(text_buf);
}

void M3UA__Registration__Result__Parameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Registration__Result__Parameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Registration__Result__Parameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[3];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Local__Routing__Key__Id_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Local__Routing__Key__Id_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_14) {
RAW_Force_Omit field_0_force_omit(0, force_omit, M3UA__Local__Routing__Key__Id_descr_.raw->forceomit);
int decoded_field_length = field_local__Routing__Key__Id.RAW_decode(M3UA__Local__Routing__Key__Id_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0 && (field_local__Routing__Key__Id.tag() ==  os_14)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
if (field_map[1] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Registration__Status_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Registration__Status_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_19) {
RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Registration__Status_descr_.raw->forceomit);
int decoded_field_length = field_registration__Status.RAW_decode(M3UA__Registration__Status_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length >= 0 && (field_registration__Status.tag() ==  os_19)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
if (field_map[2] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_1) {
RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Routing__Context_descr_.raw->forceomit);
int decoded_field_length = field_routing__Context.RAW_decode(M3UA__Routing__Context_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length >= 0 && (field_routing__Context.tag() ==  os_1)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
break;
}
if (nof_mand_fields != 3) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Registration__Result__Parameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, M3UA__Local__Routing__Key__Id_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Registration__Status_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Routing__Context_descr_.raw);
  encoded_length += field_local__Routing__Key__Id.RAW_encode(M3UA__Local__Routing__Key__Id_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_registration__Status.RAW_encode(M3UA__Registration__Status_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_routing__Context.RAW_encode(M3UA__Routing__Context_descr_, *myleaf.body.node.nodes[2]);
  if (field_local__Routing__Key__Id.tag() !=  os_14) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_14.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_registration__Status.tag() !=  os_19) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_19.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_routing__Context.tag() !=  os_1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct M3UA__Registration__Result__Parameters_template::single_value_struct {
M3UA__Local__Routing__Key__Id_template field_local__Routing__Key__Id;
M3UA__Registration__Status_template field_registration__Status;
M3UA__Routing__Context_template field_routing__Context;
};

void M3UA__Registration__Result__Parameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_local__Routing__Key__Id = ANY_VALUE;
single_value->field_registration__Status = ANY_VALUE;
single_value->field_routing__Context = ANY_VALUE;
}
}
}

void M3UA__Registration__Result__Parameters_template::copy_value(const M3UA__Registration__Result__Parameters& other_value)
{
single_value = new single_value_struct;
if (other_value.local__Routing__Key__Id().is_bound()) {
  single_value->field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
} else {
  single_value->field_local__Routing__Key__Id.clean_up();
}
if (other_value.registration__Status().is_bound()) {
  single_value->field_registration__Status = other_value.registration__Status();
} else {
  single_value->field_registration__Status.clean_up();
}
if (other_value.routing__Context().is_bound()) {
  single_value->field_routing__Context = other_value.routing__Context();
} else {
  single_value->field_routing__Context.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Registration__Result__Parameters_template::copy_template(const M3UA__Registration__Result__Parameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.local__Routing__Key__Id().get_selection()) {
single_value->field_local__Routing__Key__Id = other_value.local__Routing__Key__Id();
} else {
single_value->field_local__Routing__Key__Id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.registration__Status().get_selection()) {
single_value->field_registration__Status = other_value.registration__Status();
} else {
single_value->field_registration__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.routing__Context().get_selection()) {
single_value->field_routing__Context = other_value.routing__Context();
} else {
single_value->field_routing__Context.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Registration__Result__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Registration__Result__Parameters_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Registration__Result__Parameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
break;
}
set_selection(other_value);
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template()
{
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template(const M3UA__Registration__Result__Parameters& other_value)
{
copy_value(other_value);
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template(const OPTIONAL<M3UA__Registration__Result__Parameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Registration__Result__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Registration_Result_Parameters from an unbound optional field.");
}
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template(M3UA__Registration__Result__Parameters_template* p_precondition, M3UA__Registration__Result__Parameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template(Dynamic_Match_Interface<M3UA__Registration__Result__Parameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Registration__Result__Parameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Registration__Result__Parameters_template::M3UA__Registration__Result__Parameters_template(const M3UA__Registration__Result__Parameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Registration__Result__Parameters_template::~M3UA__Registration__Result__Parameters_template()
{
clean_up();
}

M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result__Parameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result__Parameters_template::operator=(const M3UA__Registration__Result__Parameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result__Parameters_template::operator=(const OPTIONAL<M3UA__Registration__Result__Parameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Registration__Result__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
}
return *this;
}

M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result__Parameters_template::operator=(const M3UA__Registration__Result__Parameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Registration__Result__Parameters_template::match(const M3UA__Registration__Result__Parameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.local__Routing__Key__Id().is_bound()) return FALSE;
if(!single_value->field_local__Routing__Key__Id.match(other_value.local__Routing__Key__Id(), legacy))return FALSE;
if(!other_value.registration__Status().is_bound()) return FALSE;
if(!single_value->field_registration__Status.match(other_value.registration__Status(), legacy))return FALSE;
if(!other_value.routing__Context().is_bound()) return FALSE;
if(!single_value->field_routing__Context.match(other_value.routing__Context(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
}
return FALSE;
}

boolean M3UA__Registration__Result__Parameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_local__Routing__Key__Id.is_bound()
 || single_value->field_registration__Status.is_bound()
 || single_value->field_routing__Context.is_bound();
}

boolean M3UA__Registration__Result__Parameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_local__Routing__Key__Id.is_value()
 && single_value->field_registration__Status.is_value()
 && single_value->field_routing__Context.is_value();
}

void M3UA__Registration__Result__Parameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Registration__Result__Parameters M3UA__Registration__Result__Parameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
M3UA__Registration__Result__Parameters ret_val;
if (single_value->field_local__Routing__Key__Id.is_bound()) {
ret_val.local__Routing__Key__Id() = single_value->field_local__Routing__Key__Id.valueof();
}
if (single_value->field_registration__Status.is_bound()) {
ret_val.registration__Status() = single_value->field_registration__Status.valueof();
}
if (single_value->field_routing__Context.is_bound()) {
ret_val.routing__Context() = single_value->field_routing__Context.valueof();
}
return ret_val;
}

void M3UA__Registration__Result__Parameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Registration__Result__Parameters_template[list_length];
}

M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result__Parameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
return value_list.list_value[list_index];
}

M3UA__Local__Routing__Key__Id_template& M3UA__Registration__Result__Parameters_template::local__Routing__Key__Id()
{
set_specific();
return single_value->field_local__Routing__Key__Id;
}

const M3UA__Local__Routing__Key__Id_template& M3UA__Registration__Result__Parameters_template::local__Routing__Key__Id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field local_Routing_Key_Id of a non-specific template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
return single_value->field_local__Routing__Key__Id;
}

M3UA__Registration__Status_template& M3UA__Registration__Result__Parameters_template::registration__Status()
{
set_specific();
return single_value->field_registration__Status;
}

const M3UA__Registration__Status_template& M3UA__Registration__Result__Parameters_template::registration__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field registration_Status of a non-specific template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
return single_value->field_registration__Status;
}

M3UA__Routing__Context_template& M3UA__Registration__Result__Parameters_template::routing__Context()
{
set_specific();
return single_value->field_routing__Context;
}

const M3UA__Routing__Context_template& M3UA__Registration__Result__Parameters_template::routing__Context() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field routing_Context of a non-specific template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
return single_value->field_routing__Context;
}

int M3UA__Registration__Result__Parameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result_Parameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
  }
  return 0;
}

void M3UA__Registration__Result__Parameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ local_Routing_Key_Id := ");
single_value->field_local__Routing__Key__Id.log();
TTCN_Logger::log_event_str(", registration_Status := ");
single_value->field_registration__Status.log();
TTCN_Logger::log_event_str(", routing_Context := ");
single_value->field_routing__Context.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Registration__Result__Parameters_template::log_match(const M3UA__Registration__Result__Parameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_local__Routing__Key__Id.match(match_value.local__Routing__Key__Id(), legacy)){
TTCN_Logger::log_logmatch_info(".local_Routing_Key_Id");
single_value->field_local__Routing__Key__Id.log_match(match_value.local__Routing__Key__Id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_registration__Status.match(match_value.registration__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".registration_Status");
single_value->field_registration__Status.log_match(match_value.registration__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_routing__Context.match(match_value.routing__Context(), legacy)){
TTCN_Logger::log_logmatch_info(".routing_Context");
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ local_Routing_Key_Id := ");
single_value->field_local__Routing__Key__Id.log_match(match_value.local__Routing__Key__Id(), legacy);
TTCN_Logger::log_event_str(", registration_Status := ");
single_value->field_registration__Status.log_match(match_value.registration__Status(), legacy);
TTCN_Logger::log_event_str(", routing_Context := ");
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Registration__Result__Parameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (local__Routing__Key__Id().is_bound()) local__Routing__Key__Id().set_implicit_omit();
if (registration__Status().is_bound()) registration__Status().set_implicit_omit();
if (routing__Context().is_bound()) routing__Context().set_implicit_omit();
}

void M3UA__Registration__Result__Parameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_local__Routing__Key__Id.encode_text(text_buf);
single_value->field_registration__Status.encode_text(text_buf);
single_value->field_routing__Context.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
}
}

void M3UA__Registration__Result__Parameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_local__Routing__Key__Id.decode_text(text_buf);
single_value->field_registration__Status.decode_text(text_buf);
single_value->field_routing__Context.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Registration__Result__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Registration_Result_Parameters.");
}
}

void M3UA__Registration__Result__Parameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Registration__Result__Parameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("set template of type @M3UA_Types.M3UA_Registration_Result_Parameters has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) local__Routing__Key__Id().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) registration__Status().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "local_Routing_Key_Id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          local__Routing__Key__Id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "registration_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          registration__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Registration_Result_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Registration__Result__Parameters_template* precondition = new M3UA__Registration__Result__Parameters_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Registration__Result__Parameters_template* implied_template = new M3UA__Registration__Result__Parameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Registration__Result__Parameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@M3UA_Types.M3UA_Registration_Result_Parameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Registration__Result__Parameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_local__Routing__Key__Id.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result_Parameters");
single_value->field_registration__Status.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result_Parameters");
single_value->field_routing__Context.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result_Parameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result_Parameters");
}

boolean M3UA__Registration__Result__Parameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Registration__Result__Parameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Registration__Result::M3UA__Registration__Result()
{
}

M3UA__Registration__Result::M3UA__Registration__Result(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const M3UA__Registration__Result__Parameters& par_registrationResult)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_registrationResult(par_registrationResult)
{
}

M3UA__Registration__Result::M3UA__Registration__Result(const M3UA__Registration__Result& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Registration_Result.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.registrationResult().is_bound()) field_registrationResult = other_value.registrationResult();
else field_registrationResult.clean_up();
}

void M3UA__Registration__Result::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_registrationResult.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Registration__Result::get_descriptor() const { return &M3UA__Registration__Result_descr_; }
M3UA__Registration__Result& M3UA__Registration__Result::operator=(const M3UA__Registration__Result& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Registration_Result.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.registrationResult().is_bound()) field_registrationResult = other_value.registrationResult();
  else field_registrationResult.clean_up();
}
return *this;
}

boolean M3UA__Registration__Result::operator==(const M3UA__Registration__Result& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_registrationResult==other_value.field_registrationResult;
}

boolean M3UA__Registration__Result::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_registrationResult.is_bound());
}
boolean M3UA__Registration__Result::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_registrationResult.is_value();
}
void M3UA__Registration__Result::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", registrationResult := ");
field_registrationResult.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Registration__Result::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (registrationResult().is_bound()) registrationResult().set_implicit_omit();
}

void M3UA__Registration__Result::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Registration_Result has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) registrationResult().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "registrationResult")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          registrationResult().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Registration_Result: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Registration_Result");
  }
}

void M3UA__Registration__Result::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_registrationResult.encode_text(text_buf);
}

void M3UA__Registration__Result::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_registrationResult.decode_text(text_buf);
}

void M3UA__Registration__Result::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Registration__Result::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Registration__Result::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Registration__Result_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Registration__Result_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Registration__Result_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Registration__Result__Parameters_descr_.raw->forceomit);
  decoded_field_length = field_registrationResult.RAW_decode(M3UA__Registration__Result__Parameters_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Registration__Result::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Registration__Result_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Registration__Result__Parameters_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Registration__Result_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_registrationResult.RAW_encode(M3UA__Registration__Result__Parameters_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Registration__Result_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
M3UA__Registration__Result__Parameters_template field_registrationResult;
};

void M3UA__Registration__Result_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_registrationResult = ANY_VALUE;
}
}
}

void M3UA__Registration__Result_template::copy_value(const M3UA__Registration__Result& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.registrationResult().is_bound()) {
  single_value->field_registrationResult = other_value.registrationResult();
} else {
  single_value->field_registrationResult.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Registration__Result_template::copy_template(const M3UA__Registration__Result_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.registrationResult().get_selection()) {
single_value->field_registrationResult = other_value.registrationResult();
} else {
single_value->field_registrationResult.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Registration__Result_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Registration__Result_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Registration__Result_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result.");
break;
}
set_selection(other_value);
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template()
{
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template(const M3UA__Registration__Result& other_value)
{
copy_value(other_value);
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template(const OPTIONAL<M3UA__Registration__Result>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Registration__Result&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Registration_Result from an unbound optional field.");
}
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template(M3UA__Registration__Result_template* p_precondition, M3UA__Registration__Result_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template(Dynamic_Match_Interface<M3UA__Registration__Result>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Registration__Result>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Registration__Result_template::M3UA__Registration__Result_template(const M3UA__Registration__Result_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Registration__Result_template::~M3UA__Registration__Result_template()
{
clean_up();
}

M3UA__Registration__Result_template& M3UA__Registration__Result_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Registration__Result_template& M3UA__Registration__Result_template::operator=(const M3UA__Registration__Result& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Registration__Result_template& M3UA__Registration__Result_template::operator=(const OPTIONAL<M3UA__Registration__Result>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Registration__Result&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Registration_Result.");
}
return *this;
}

M3UA__Registration__Result_template& M3UA__Registration__Result_template::operator=(const M3UA__Registration__Result_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Registration__Result_template::match(const M3UA__Registration__Result& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.registrationResult().is_bound()) return FALSE;
if(!single_value->field_registrationResult.match(other_value.registrationResult(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result.");
}
return FALSE;
}

boolean M3UA__Registration__Result_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_registrationResult.is_bound();
}

boolean M3UA__Registration__Result_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_registrationResult.is_value();
}

void M3UA__Registration__Result_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Registration__Result M3UA__Registration__Result_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Registration_Result.");
M3UA__Registration__Result ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_registrationResult.is_bound()) {
ret_val.registrationResult() = single_value->field_registrationResult.valueof();
}
return ret_val;
}

void M3UA__Registration__Result_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Registration_Result.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Registration__Result_template[list_length];
}

M3UA__Registration__Result_template& M3UA__Registration__Result_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Registration_Result.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Registration_Result.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Registration__Result_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Registration__Result_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Registration_Result.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Registration__Result_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Registration__Result_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Registration_Result.");
return single_value->field_lengthInd;
}

M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result_template::registrationResult()
{
set_specific();
return single_value->field_registrationResult;
}

const M3UA__Registration__Result__Parameters_template& M3UA__Registration__Result_template::registrationResult() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field registrationResult of a non-specific template of type @M3UA_Types.M3UA_Registration_Result.");
return single_value->field_registrationResult;
}

int M3UA__Registration__Result_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Registration_Result containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result.");
  }
  return 0;
}

void M3UA__Registration__Result_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", registrationResult := ");
single_value->field_registrationResult.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Registration__Result_template::log_match(const M3UA__Registration__Result& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_registrationResult.match(match_value.registrationResult(), legacy)){
TTCN_Logger::log_logmatch_info(".registrationResult");
single_value->field_registrationResult.log_match(match_value.registrationResult(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", registrationResult := ");
single_value->field_registrationResult.log_match(match_value.registrationResult(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Registration__Result_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (registrationResult().is_bound()) registrationResult().set_implicit_omit();
}

void M3UA__Registration__Result_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_registrationResult.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Registration_Result.");
}
}

void M3UA__Registration__Result_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_registrationResult.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Registration__Result_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Registration_Result.");
}
}

void M3UA__Registration__Result_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Registration__Result_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Registration_Result has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) registrationResult().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "registrationResult")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          registrationResult().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Registration_Result: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Registration__Result_template* precondition = new M3UA__Registration__Result_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Registration__Result_template* implied_template = new M3UA__Registration__Result_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Registration__Result_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Registration_Result");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Registration__Result_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result");
single_value->field_registrationResult.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Registration_Result");
}

boolean M3UA__Registration__Result_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Registration__Result_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Deregistration__Result__Parameters::M3UA__Deregistration__Result__Parameters()
{
}

M3UA__Deregistration__Result__Parameters::M3UA__Deregistration__Result__Parameters(const M3UA__Routing__Context& par_routing__Context,
    const M3UA__Deregistration__Status& par_deregistration__Status)
  :   field_routing__Context(par_routing__Context),
  field_deregistration__Status(par_deregistration__Status)
{
}

M3UA__Deregistration__Result__Parameters::M3UA__Deregistration__Result__Parameters(const M3UA__Deregistration__Result__Parameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
else field_routing__Context.clean_up();
if (other_value.deregistration__Status().is_bound()) field_deregistration__Status = other_value.deregistration__Status();
else field_deregistration__Status.clean_up();
}

void M3UA__Deregistration__Result__Parameters::clean_up()
{
field_routing__Context.clean_up();
field_deregistration__Status.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Deregistration__Result__Parameters::get_descriptor() const { return &M3UA__Deregistration__Result__Parameters_descr_; }
M3UA__Deregistration__Result__Parameters& M3UA__Deregistration__Result__Parameters::operator=(const M3UA__Deregistration__Result__Parameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
  if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
  else field_routing__Context.clean_up();
  if (other_value.deregistration__Status().is_bound()) field_deregistration__Status = other_value.deregistration__Status();
  else field_deregistration__Status.clean_up();
}
return *this;
}

boolean M3UA__Deregistration__Result__Parameters::operator==(const M3UA__Deregistration__Result__Parameters& other_value) const
{
return field_routing__Context==other_value.field_routing__Context
  && field_deregistration__Status==other_value.field_deregistration__Status;
}

boolean M3UA__Deregistration__Result__Parameters::is_bound() const
{
return (field_routing__Context.is_bound())
  || (field_deregistration__Status.is_bound());
}
boolean M3UA__Deregistration__Result__Parameters::is_value() const
{
return field_routing__Context.is_value()
  && field_deregistration__Status.is_value();
}
void M3UA__Deregistration__Result__Parameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ routing_Context := ");
field_routing__Context.log();
TTCN_Logger::log_event_str(", deregistration_Status := ");
field_deregistration__Status.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Deregistration__Result__Parameters::set_implicit_omit()
{
if (routing__Context().is_bound()) routing__Context().set_implicit_omit();
if (deregistration__Status().is_bound()) deregistration__Status().set_implicit_omit();
}

void M3UA__Deregistration__Result__Parameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("set value of type @M3UA_Types.M3UA_Deregistration_Result_Parameters has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) deregistration__Status().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deregistration_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deregistration__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Deregistration_Result_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@M3UA_Types.M3UA_Deregistration_Result_Parameters");
  }
}

void M3UA__Deregistration__Result__Parameters::encode_text(Text_Buf& text_buf) const
{
field_routing__Context.encode_text(text_buf);
field_deregistration__Status.encode_text(text_buf);
}

void M3UA__Deregistration__Result__Parameters::decode_text(Text_Buf& text_buf)
{
field_routing__Context.decode_text(text_buf);
field_deregistration__Status.decode_text(text_buf);
}

void M3UA__Deregistration__Result__Parameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Deregistration__Result__Parameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Deregistration__Result__Parameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[2];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_1) {
RAW_Force_Omit field_0_force_omit(0, force_omit, M3UA__Routing__Context_descr_.raw->forceomit);
int decoded_field_length = field_routing__Context.RAW_decode(M3UA__Routing__Context_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0 && (field_routing__Context.tag() ==  os_1)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
if (field_map[1] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Deregistration__Status_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Deregistration__Status_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_20) {
RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Deregistration__Status_descr_.raw->forceomit);
int decoded_field_length = field_deregistration__Status.RAW_decode(M3UA__Deregistration__Status_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length >= 0 && (field_deregistration__Status.tag() ==  os_20)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
break;
}
if (nof_mand_fields != 2) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Deregistration__Result__Parameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, M3UA__Routing__Context_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Deregistration__Status_descr_.raw);
  encoded_length += field_routing__Context.RAW_encode(M3UA__Routing__Context_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_deregistration__Status.RAW_encode(M3UA__Deregistration__Status_descr_, *myleaf.body.node.nodes[1]);
  if (field_routing__Context.tag() !=  os_1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_deregistration__Status.tag() !=  os_20) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_20.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct M3UA__Deregistration__Result__Parameters_template::single_value_struct {
M3UA__Routing__Context_template field_routing__Context;
M3UA__Deregistration__Status_template field_deregistration__Status;
};

void M3UA__Deregistration__Result__Parameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_routing__Context = ANY_VALUE;
single_value->field_deregistration__Status = ANY_VALUE;
}
}
}

void M3UA__Deregistration__Result__Parameters_template::copy_value(const M3UA__Deregistration__Result__Parameters& other_value)
{
single_value = new single_value_struct;
if (other_value.routing__Context().is_bound()) {
  single_value->field_routing__Context = other_value.routing__Context();
} else {
  single_value->field_routing__Context.clean_up();
}
if (other_value.deregistration__Status().is_bound()) {
  single_value->field_deregistration__Status = other_value.deregistration__Status();
} else {
  single_value->field_deregistration__Status.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Deregistration__Result__Parameters_template::copy_template(const M3UA__Deregistration__Result__Parameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.routing__Context().get_selection()) {
single_value->field_routing__Context = other_value.routing__Context();
} else {
single_value->field_routing__Context.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deregistration__Status().get_selection()) {
single_value->field_deregistration__Status = other_value.deregistration__Status();
} else {
single_value->field_deregistration__Status.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Deregistration__Result__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Deregistration__Result__Parameters_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Deregistration__Result__Parameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
break;
}
set_selection(other_value);
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template()
{
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template(const M3UA__Deregistration__Result__Parameters& other_value)
{
copy_value(other_value);
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template(const OPTIONAL<M3UA__Deregistration__Result__Parameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Deregistration__Result__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters from an unbound optional field.");
}
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template(M3UA__Deregistration__Result__Parameters_template* p_precondition, M3UA__Deregistration__Result__Parameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template(Dynamic_Match_Interface<M3UA__Deregistration__Result__Parameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Deregistration__Result__Parameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Deregistration__Result__Parameters_template::M3UA__Deregistration__Result__Parameters_template(const M3UA__Deregistration__Result__Parameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Deregistration__Result__Parameters_template::~M3UA__Deregistration__Result__Parameters_template()
{
clean_up();
}

M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result__Parameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result__Parameters_template::operator=(const M3UA__Deregistration__Result__Parameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result__Parameters_template::operator=(const OPTIONAL<M3UA__Deregistration__Result__Parameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Deregistration__Result__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
}
return *this;
}

M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result__Parameters_template::operator=(const M3UA__Deregistration__Result__Parameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Deregistration__Result__Parameters_template::match(const M3UA__Deregistration__Result__Parameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.routing__Context().is_bound()) return FALSE;
if(!single_value->field_routing__Context.match(other_value.routing__Context(), legacy))return FALSE;
if(!other_value.deregistration__Status().is_bound()) return FALSE;
if(!single_value->field_deregistration__Status.match(other_value.deregistration__Status(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
}
return FALSE;
}

boolean M3UA__Deregistration__Result__Parameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_routing__Context.is_bound()
 || single_value->field_deregistration__Status.is_bound();
}

boolean M3UA__Deregistration__Result__Parameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_routing__Context.is_value()
 && single_value->field_deregistration__Status.is_value();
}

void M3UA__Deregistration__Result__Parameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Deregistration__Result__Parameters M3UA__Deregistration__Result__Parameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
M3UA__Deregistration__Result__Parameters ret_val;
if (single_value->field_routing__Context.is_bound()) {
ret_val.routing__Context() = single_value->field_routing__Context.valueof();
}
if (single_value->field_deregistration__Status.is_bound()) {
ret_val.deregistration__Status() = single_value->field_deregistration__Status.valueof();
}
return ret_val;
}

void M3UA__Deregistration__Result__Parameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Deregistration__Result__Parameters_template[list_length];
}

M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result__Parameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
return value_list.list_value[list_index];
}

M3UA__Routing__Context_template& M3UA__Deregistration__Result__Parameters_template::routing__Context()
{
set_specific();
return single_value->field_routing__Context;
}

const M3UA__Routing__Context_template& M3UA__Deregistration__Result__Parameters_template::routing__Context() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field routing_Context of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
return single_value->field_routing__Context;
}

M3UA__Deregistration__Status_template& M3UA__Deregistration__Result__Parameters_template::deregistration__Status()
{
set_specific();
return single_value->field_deregistration__Status;
}

const M3UA__Deregistration__Status_template& M3UA__Deregistration__Result__Parameters_template::deregistration__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deregistration_Status of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
return single_value->field_deregistration__Status;
}

int M3UA__Deregistration__Result__Parameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
  }
  return 0;
}

void M3UA__Deregistration__Result__Parameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ routing_Context := ");
single_value->field_routing__Context.log();
TTCN_Logger::log_event_str(", deregistration_Status := ");
single_value->field_deregistration__Status.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Deregistration__Result__Parameters_template::log_match(const M3UA__Deregistration__Result__Parameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_routing__Context.match(match_value.routing__Context(), legacy)){
TTCN_Logger::log_logmatch_info(".routing_Context");
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_deregistration__Status.match(match_value.deregistration__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".deregistration_Status");
single_value->field_deregistration__Status.log_match(match_value.deregistration__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ routing_Context := ");
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
TTCN_Logger::log_event_str(", deregistration_Status := ");
single_value->field_deregistration__Status.log_match(match_value.deregistration__Status(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Deregistration__Result__Parameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (routing__Context().is_bound()) routing__Context().set_implicit_omit();
if (deregistration__Status().is_bound()) deregistration__Status().set_implicit_omit();
}

void M3UA__Deregistration__Result__Parameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_routing__Context.encode_text(text_buf);
single_value->field_deregistration__Status.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
}
}

void M3UA__Deregistration__Result__Parameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_routing__Context.decode_text(text_buf);
single_value->field_deregistration__Status.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Deregistration__Result__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters.");
}
}

void M3UA__Deregistration__Result__Parameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Deregistration__Result__Parameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("set template of type @M3UA_Types.M3UA_Deregistration_Result_Parameters has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) deregistration__Status().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deregistration_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deregistration__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Deregistration_Result_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Deregistration__Result__Parameters_template* precondition = new M3UA__Deregistration__Result__Parameters_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Deregistration__Result__Parameters_template* implied_template = new M3UA__Deregistration__Result__Parameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Deregistration__Result__Parameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@M3UA_Types.M3UA_Deregistration_Result_Parameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Deregistration__Result__Parameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_routing__Context.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result_Parameters");
single_value->field_deregistration__Status.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result_Parameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result_Parameters");
}

boolean M3UA__Deregistration__Result__Parameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Deregistration__Result__Parameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__Deregistration__Result::M3UA__Deregistration__Result()
{
}

M3UA__Deregistration__Result::M3UA__Deregistration__Result(const OCTETSTRING& par_tag,
    const INTEGER& par_lengthInd,
    const M3UA__Deregistration__Result__Parameters& par_deregistrationResult)
  :   field_tag(par_tag),
  field_lengthInd(par_lengthInd),
  field_deregistrationResult(par_deregistrationResult)
{
}

M3UA__Deregistration__Result::M3UA__Deregistration__Result(const M3UA__Deregistration__Result& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_Deregistration_Result.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
else field_lengthInd.clean_up();
if (other_value.deregistrationResult().is_bound()) field_deregistrationResult = other_value.deregistrationResult();
else field_deregistrationResult.clean_up();
}

void M3UA__Deregistration__Result::clean_up()
{
field_tag.clean_up();
field_lengthInd.clean_up();
field_deregistrationResult.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__Deregistration__Result::get_descriptor() const { return &M3UA__Deregistration__Result_descr_; }
M3UA__Deregistration__Result& M3UA__Deregistration__Result::operator=(const M3UA__Deregistration__Result& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_Deregistration_Result.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.lengthInd().is_bound()) field_lengthInd = other_value.lengthInd();
  else field_lengthInd.clean_up();
  if (other_value.deregistrationResult().is_bound()) field_deregistrationResult = other_value.deregistrationResult();
  else field_deregistrationResult.clean_up();
}
return *this;
}

boolean M3UA__Deregistration__Result::operator==(const M3UA__Deregistration__Result& other_value) const
{
return field_tag==other_value.field_tag
  && field_lengthInd==other_value.field_lengthInd
  && field_deregistrationResult==other_value.field_deregistrationResult;
}

boolean M3UA__Deregistration__Result::is_bound() const
{
return (field_tag.is_bound())
  || (field_lengthInd.is_bound())
  || (field_deregistrationResult.is_bound());
}
boolean M3UA__Deregistration__Result::is_value() const
{
return field_tag.is_value()
  && field_lengthInd.is_value()
  && field_deregistrationResult.is_value();
}
void M3UA__Deregistration__Result::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
field_lengthInd.log();
TTCN_Logger::log_event_str(", deregistrationResult := ");
field_deregistrationResult.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__Deregistration__Result::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (deregistrationResult().is_bound()) deregistrationResult().set_implicit_omit();
}

void M3UA__Deregistration__Result::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_Deregistration_Result has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) deregistrationResult().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deregistrationResult")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deregistrationResult().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Deregistration_Result: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_Deregistration_Result");
  }
}

void M3UA__Deregistration__Result::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_lengthInd.encode_text(text_buf);
field_deregistrationResult.encode_text(text_buf);
}

void M3UA__Deregistration__Result::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_lengthInd.decode_text(text_buf);
field_deregistrationResult.decode_text(text_buf);
}

void M3UA__Deregistration__Result::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__Deregistration__Result::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__Deregistration__Result::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Deregistration__Result_lengthInd_descr_.raw->forceomit);
  decoded_field_length = field_lengthInd.RAW_decode(M3UA__Deregistration__Result_lengthInd_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthInd.convert_to_Integer(M3UA__Deregistration__Result_lengthInd_descr_);
  field_lengthInd = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  value_of_length_field1 -= decoded_field_length;
  if (value_of_length_field1 < 0) return -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Deregistration__Result__Parameters_descr_.raw->forceomit);
  decoded_field_length = field_deregistrationResult.RAW_decode(M3UA__Deregistration__Result__Parameters_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__Deregistration__Result::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Deregistration__Result_lengthInd_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Deregistration__Result__Parameters_descr_.raw);
  encoded_length += field_tag.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &M3UA__Deregistration__Result_lengthInd_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_deregistrationResult.RAW_encode(M3UA__Deregistration__Result__Parameters_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct M3UA__Deregistration__Result_template::single_value_struct {
OCTETSTRING_template field_tag;
INTEGER_template field_lengthInd;
M3UA__Deregistration__Result__Parameters_template field_deregistrationResult;
};

void M3UA__Deregistration__Result_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tag = ANY_VALUE;
single_value->field_lengthInd = ANY_VALUE;
single_value->field_deregistrationResult = ANY_VALUE;
}
}
}

void M3UA__Deregistration__Result_template::copy_value(const M3UA__Deregistration__Result& other_value)
{
single_value = new single_value_struct;
if (other_value.tag().is_bound()) {
  single_value->field_tag = other_value.tag();
} else {
  single_value->field_tag.clean_up();
}
if (other_value.lengthInd().is_bound()) {
  single_value->field_lengthInd = other_value.lengthInd();
} else {
  single_value->field_lengthInd.clean_up();
}
if (other_value.deregistrationResult().is_bound()) {
  single_value->field_deregistrationResult = other_value.deregistrationResult();
} else {
  single_value->field_deregistrationResult.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__Deregistration__Result_template::copy_template(const M3UA__Deregistration__Result_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tag().get_selection()) {
single_value->field_tag = other_value.tag();
} else {
single_value->field_tag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthInd().get_selection()) {
single_value->field_lengthInd = other_value.lengthInd();
} else {
single_value->field_lengthInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deregistrationResult().get_selection()) {
single_value->field_deregistrationResult = other_value.deregistrationResult();
} else {
single_value->field_deregistrationResult.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__Deregistration__Result_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__Deregistration__Result_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__Deregistration__Result_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result.");
break;
}
set_selection(other_value);
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template()
{
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template(const M3UA__Deregistration__Result& other_value)
{
copy_value(other_value);
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template(const OPTIONAL<M3UA__Deregistration__Result>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Deregistration__Result&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_Deregistration_Result from an unbound optional field.");
}
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template(M3UA__Deregistration__Result_template* p_precondition, M3UA__Deregistration__Result_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template(Dynamic_Match_Interface<M3UA__Deregistration__Result>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__Deregistration__Result>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__Deregistration__Result_template::M3UA__Deregistration__Result_template(const M3UA__Deregistration__Result_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__Deregistration__Result_template::~M3UA__Deregistration__Result_template()
{
clean_up();
}

M3UA__Deregistration__Result_template& M3UA__Deregistration__Result_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__Deregistration__Result_template& M3UA__Deregistration__Result_template::operator=(const M3UA__Deregistration__Result& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__Deregistration__Result_template& M3UA__Deregistration__Result_template::operator=(const OPTIONAL<M3UA__Deregistration__Result>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__Deregistration__Result&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_Deregistration_Result.");
}
return *this;
}

M3UA__Deregistration__Result_template& M3UA__Deregistration__Result_template::operator=(const M3UA__Deregistration__Result_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__Deregistration__Result_template::match(const M3UA__Deregistration__Result& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tag().is_bound()) return FALSE;
if(!single_value->field_tag.match(other_value.tag(), legacy))return FALSE;
if(!other_value.lengthInd().is_bound()) return FALSE;
if(!single_value->field_lengthInd.match(other_value.lengthInd(), legacy))return FALSE;
if(!other_value.deregistrationResult().is_bound()) return FALSE;
if(!single_value->field_deregistrationResult.match(other_value.deregistrationResult(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result.");
}
return FALSE;
}

boolean M3UA__Deregistration__Result_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tag.is_bound()
 || single_value->field_lengthInd.is_bound()
 || single_value->field_deregistrationResult.is_bound();
}

boolean M3UA__Deregistration__Result_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tag.is_value()
 && single_value->field_lengthInd.is_value()
 && single_value->field_deregistrationResult.is_value();
}

void M3UA__Deregistration__Result_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__Deregistration__Result M3UA__Deregistration__Result_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result.");
M3UA__Deregistration__Result ret_val;
if (single_value->field_tag.is_bound()) {
ret_val.tag() = single_value->field_tag.valueof();
}
if (single_value->field_lengthInd.is_bound()) {
ret_val.lengthInd() = single_value->field_lengthInd.valueof();
}
if (single_value->field_deregistrationResult.is_bound()) {
ret_val.deregistrationResult() = single_value->field_deregistrationResult.valueof();
}
return ret_val;
}

void M3UA__Deregistration__Result_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_Deregistration_Result.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__Deregistration__Result_template[list_length];
}

M3UA__Deregistration__Result_template& M3UA__Deregistration__Result_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_Deregistration_Result.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_Deregistration_Result.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__Deregistration__Result_template::tag()
{
set_specific();
return single_value->field_tag;
}

const OCTETSTRING_template& M3UA__Deregistration__Result_template::tag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tag of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result.");
return single_value->field_tag;
}

INTEGER_template& M3UA__Deregistration__Result_template::lengthInd()
{
set_specific();
return single_value->field_lengthInd;
}

const INTEGER_template& M3UA__Deregistration__Result_template::lengthInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthInd of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result.");
return single_value->field_lengthInd;
}

M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result_template::deregistrationResult()
{
set_specific();
return single_value->field_deregistrationResult;
}

const M3UA__Deregistration__Result__Parameters_template& M3UA__Deregistration__Result_template::deregistrationResult() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deregistrationResult of a non-specific template of type @M3UA_Types.M3UA_Deregistration_Result.");
return single_value->field_deregistrationResult;
}

int M3UA__Deregistration__Result_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_Deregistration_Result containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result.");
  }
  return 0;
}

void M3UA__Deregistration__Result_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log();
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log();
TTCN_Logger::log_event_str(", deregistrationResult := ");
single_value->field_deregistrationResult.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__Deregistration__Result_template::log_match(const M3UA__Deregistration__Result& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tag.match(match_value.tag(), legacy)){
TTCN_Logger::log_logmatch_info(".tag");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthInd.match(match_value.lengthInd(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthInd");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_deregistrationResult.match(match_value.deregistrationResult(), legacy)){
TTCN_Logger::log_logmatch_info(".deregistrationResult");
single_value->field_deregistrationResult.log_match(match_value.deregistrationResult(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tag := ");
single_value->field_tag.log_match(match_value.tag(), legacy);
TTCN_Logger::log_event_str(", lengthInd := ");
single_value->field_lengthInd.log_match(match_value.lengthInd(), legacy);
TTCN_Logger::log_event_str(", deregistrationResult := ");
single_value->field_deregistrationResult.log_match(match_value.deregistrationResult(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__Deregistration__Result_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tag().is_bound()) tag().set_implicit_omit();
if (lengthInd().is_bound()) lengthInd().set_implicit_omit();
if (deregistrationResult().is_bound()) deregistrationResult().set_implicit_omit();
}

void M3UA__Deregistration__Result_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tag.encode_text(text_buf);
single_value->field_lengthInd.encode_text(text_buf);
single_value->field_deregistrationResult.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_Deregistration_Result.");
}
}

void M3UA__Deregistration__Result_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tag.decode_text(text_buf);
single_value->field_lengthInd.decode_text(text_buf);
single_value->field_deregistrationResult.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__Deregistration__Result_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_Deregistration_Result.");
}
}

void M3UA__Deregistration__Result_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__Deregistration__Result_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_Deregistration_Result has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) deregistrationResult().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deregistrationResult")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deregistrationResult().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_Deregistration_Result: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__Deregistration__Result_template* precondition = new M3UA__Deregistration__Result_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__Deregistration__Result_template* implied_template = new M3UA__Deregistration__Result_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__Deregistration__Result_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_Deregistration_Result");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__Deregistration__Result_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tag.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result");
single_value->field_lengthInd.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result");
single_value->field_deregistrationResult.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_Deregistration_Result");
}

boolean M3UA__Deregistration__Result_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__Deregistration__Result_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__ERR__MessageParameters::M3UA__ERR__MessageParameters()
{
}

M3UA__ERR__MessageParameters::M3UA__ERR__MessageParameters(const M3UA__Error__Code& par_error__Code,
    const OPTIONAL< M3UA__Routing__Context >& par_routing__Context,
    const OPTIONAL< M3UA__Affected__Point__Codes >& par_affected__Point__Codes,
    const OPTIONAL< M3UA__Network__Appearance >& par_network__Appearance,
    const OPTIONAL< M3UA__Diagnostic__information >& par_diagnostic__information)
  :   field_error__Code(par_error__Code),
  field_routing__Context(par_routing__Context),
  field_affected__Point__Codes(par_affected__Point__Codes),
  field_network__Appearance(par_network__Appearance),
  field_diagnostic__information(par_diagnostic__information)
{
}

M3UA__ERR__MessageParameters::M3UA__ERR__MessageParameters(const M3UA__ERR__MessageParameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_ERR_MessageParameters.");
if (other_value.error__Code().is_bound()) field_error__Code = other_value.error__Code();
else field_error__Code.clean_up();
if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
else field_routing__Context.clean_up();
if (other_value.affected__Point__Codes().is_bound()) field_affected__Point__Codes = other_value.affected__Point__Codes();
else field_affected__Point__Codes.clean_up();
if (other_value.network__Appearance().is_bound()) field_network__Appearance = other_value.network__Appearance();
else field_network__Appearance.clean_up();
if (other_value.diagnostic__information().is_bound()) field_diagnostic__information = other_value.diagnostic__information();
else field_diagnostic__information.clean_up();
}

void M3UA__ERR__MessageParameters::clean_up()
{
field_error__Code.clean_up();
field_routing__Context.clean_up();
field_affected__Point__Codes.clean_up();
field_network__Appearance.clean_up();
field_diagnostic__information.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__ERR__MessageParameters::get_descriptor() const { return &M3UA__ERR__MessageParameters_descr_; }
M3UA__ERR__MessageParameters& M3UA__ERR__MessageParameters::operator=(const M3UA__ERR__MessageParameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_ERR_MessageParameters.");
  if (other_value.error__Code().is_bound()) field_error__Code = other_value.error__Code();
  else field_error__Code.clean_up();
  if (other_value.routing__Context().is_bound()) field_routing__Context = other_value.routing__Context();
  else field_routing__Context.clean_up();
  if (other_value.affected__Point__Codes().is_bound()) field_affected__Point__Codes = other_value.affected__Point__Codes();
  else field_affected__Point__Codes.clean_up();
  if (other_value.network__Appearance().is_bound()) field_network__Appearance = other_value.network__Appearance();
  else field_network__Appearance.clean_up();
  if (other_value.diagnostic__information().is_bound()) field_diagnostic__information = other_value.diagnostic__information();
  else field_diagnostic__information.clean_up();
}
return *this;
}

boolean M3UA__ERR__MessageParameters::operator==(const M3UA__ERR__MessageParameters& other_value) const
{
return field_error__Code==other_value.field_error__Code
  && field_routing__Context==other_value.field_routing__Context
  && field_affected__Point__Codes==other_value.field_affected__Point__Codes
  && field_network__Appearance==other_value.field_network__Appearance
  && field_diagnostic__information==other_value.field_diagnostic__information;
}

boolean M3UA__ERR__MessageParameters::is_bound() const
{
return (field_error__Code.is_bound())
  || (OPTIONAL_OMIT == field_routing__Context.get_selection() || field_routing__Context.is_bound())
  || (OPTIONAL_OMIT == field_affected__Point__Codes.get_selection() || field_affected__Point__Codes.is_bound())
  || (OPTIONAL_OMIT == field_network__Appearance.get_selection() || field_network__Appearance.is_bound())
  || (OPTIONAL_OMIT == field_diagnostic__information.get_selection() || field_diagnostic__information.is_bound());
}
boolean M3UA__ERR__MessageParameters::is_value() const
{
return field_error__Code.is_value()
  && (OPTIONAL_OMIT == field_routing__Context.get_selection() || field_routing__Context.is_value())
  && (OPTIONAL_OMIT == field_affected__Point__Codes.get_selection() || field_affected__Point__Codes.is_value())
  && (OPTIONAL_OMIT == field_network__Appearance.get_selection() || field_network__Appearance.is_value())
  && (OPTIONAL_OMIT == field_diagnostic__information.get_selection() || field_diagnostic__information.is_value());
}
int M3UA__ERR__MessageParameters::size_of() const
{
  int ret_val = 1;
  if (field_routing__Context.ispresent()) ret_val++;
  if (field_affected__Point__Codes.ispresent()) ret_val++;
  if (field_network__Appearance.ispresent()) ret_val++;
  if (field_diagnostic__information.ispresent()) ret_val++;
  return ret_val;
}

void M3UA__ERR__MessageParameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ error_Code := ");
field_error__Code.log();
TTCN_Logger::log_event_str(", routing_Context := ");
field_routing__Context.log();
TTCN_Logger::log_event_str(", affected_Point_Codes := ");
field_affected__Point__Codes.log();
TTCN_Logger::log_event_str(", network_Appearance := ");
field_network__Appearance.log();
TTCN_Logger::log_event_str(", diagnostic_information := ");
field_diagnostic__information.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__ERR__MessageParameters::set_implicit_omit()
{
if (error__Code().is_bound()) error__Code().set_implicit_omit();
if (!routing__Context().is_bound()) routing__Context() = OMIT_VALUE;
else routing__Context().set_implicit_omit();
if (!affected__Point__Codes().is_bound()) affected__Point__Codes() = OMIT_VALUE;
else affected__Point__Codes().set_implicit_omit();
if (!network__Appearance().is_bound()) network__Appearance() = OMIT_VALUE;
else network__Appearance().set_implicit_omit();
if (!diagnostic__information().is_bound()) diagnostic__information() = OMIT_VALUE;
else diagnostic__information().set_implicit_omit();
}

void M3UA__ERR__MessageParameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("set value of type @M3UA_Types.M3UA_ERR_MessageParameters has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) error__Code().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) affected__Point__Codes().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) network__Appearance().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) diagnostic__information().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "error_Code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          error__Code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "affected_Point_Codes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          affected__Point__Codes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "network_Appearance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          network__Appearance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "diagnostic_information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          diagnostic__information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_ERR_MessageParameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@M3UA_Types.M3UA_ERR_MessageParameters");
  }
}

void M3UA__ERR__MessageParameters::encode_text(Text_Buf& text_buf) const
{
field_error__Code.encode_text(text_buf);
field_routing__Context.encode_text(text_buf);
field_affected__Point__Codes.encode_text(text_buf);
field_network__Appearance.encode_text(text_buf);
field_diagnostic__information.encode_text(text_buf);
}

void M3UA__ERR__MessageParameters::decode_text(Text_Buf& text_buf)
{
field_error__Code.decode_text(text_buf);
field_routing__Context.decode_text(text_buf);
field_affected__Point__Codes.decode_text(text_buf);
field_network__Appearance.decode_text(text_buf);
field_diagnostic__information.decode_text(text_buf);
}

void M3UA__ERR__MessageParameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__ERR__MessageParameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__ERR__MessageParameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[5];
memset(field_map, 0, sizeof(field_map));
size_t nof_mand_fields = 0;
field_routing__Context = OMIT_VALUE;
field_affected__Point__Codes = OMIT_VALUE;
field_network__Appearance = OMIT_VALUE;
field_diagnostic__information = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Error__Code_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Error__Code_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_0) {
RAW_Force_Omit field_0_force_omit(0, force_omit, M3UA__Error__Code_descr_.raw->forceomit);
int decoded_field_length = field_error__Code.RAW_decode(M3UA__Error__Code_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length >= 0 && (field_error__Code.tag() ==  os_0)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
nof_mand_fields++;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
}
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Routing__Context_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_1) {
RAW_Force_Omit field_1_force_omit(1, force_omit, M3UA__Routing__Context_descr_.raw->forceomit);
int decoded_field_length = field_routing__Context().RAW_decode(M3UA__Routing__Context_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0 && (field_routing__Context.ispresent() && field_routing__Context().tag() ==  os_1)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_routing__Context = OMIT_VALUE;
}
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Affected__Point__Codes_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Affected__Point__Codes_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_2) {
RAW_Force_Omit field_2_force_omit(2, force_omit, M3UA__Affected__Point__Codes_descr_.raw->forceomit);
int decoded_field_length = field_affected__Point__Codes().RAW_decode(M3UA__Affected__Point__Codes_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0 && (field_affected__Point__Codes.ispresent() && field_affected__Point__Codes().tag() ==  os_2)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_affected__Point__Codes = OMIT_VALUE;
}
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Network__Appearance_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Network__Appearance_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_3) {
RAW_Force_Omit field_3_force_omit(3, force_omit, M3UA__Network__Appearance_descr_.raw->forceomit);
int decoded_field_length = field_network__Appearance().RAW_decode(M3UA__Network__Appearance_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0 && (field_network__Appearance.ispresent() && field_network__Appearance().tag() ==  os_3)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_network__Appearance = OMIT_VALUE;
}
}
}
if (field_map[4] == 0 && (force_omit == NULL || !(*force_omit)(4))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (M3UA__Diagnostic__information_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (M3UA__Diagnostic__information_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
OCTETSTRING temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 ==  os_4) {
RAW_Force_Omit field_4_force_omit(4, force_omit, M3UA__Diagnostic__information_descr_.raw->forceomit);
int decoded_field_length = field_diagnostic__information().RAW_decode(M3UA__Diagnostic__information_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
if (decoded_field_length > 0 && (field_diagnostic__information.ispresent() && field_diagnostic__information().tag() ==  os_4)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_diagnostic__information = OMIT_VALUE;
}
}
}
break;
}
if (nof_mand_fields != 1) return limit ? -1 : -TTCN_EncDec::ET_INCOMPL_MSG;
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__ERR__MessageParameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, M3UA__Error__Code_descr_.raw);
  if (field_routing__Context.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, M3UA__Routing__Context_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_affected__Point__Codes.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, M3UA__Affected__Point__Codes_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_network__Appearance.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, M3UA__Network__Appearance_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_diagnostic__information.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, M3UA__Diagnostic__information_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_error__Code.RAW_encode(M3UA__Error__Code_descr_, *myleaf.body.node.nodes[0]);
  if (field_routing__Context.ispresent()) {
  encoded_length += field_routing__Context().RAW_encode(M3UA__Routing__Context_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_affected__Point__Codes.ispresent()) {
  encoded_length += field_affected__Point__Codes().RAW_encode(M3UA__Affected__Point__Codes_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_network__Appearance.ispresent()) {
  encoded_length += field_network__Appearance().RAW_encode(M3UA__Network__Appearance_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_diagnostic__information.ispresent()) {
  encoded_length += field_diagnostic__information().RAW_encode(M3UA__Diagnostic__information_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_error__Code.tag() !=  os_0) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_routing__Context.ispresent() && (!field_routing__Context.ispresent() || field_routing__Context().tag() !=  os_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_affected__Point__Codes.ispresent() && (!field_affected__Point__Codes.ispresent() || field_affected__Point__Codes().tag() !=  os_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_network__Appearance.ispresent() && (!field_network__Appearance.ispresent() || field_network__Appearance().tag() !=  os_3)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_3.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_diagnostic__information.ispresent() && (!field_diagnostic__information.ispresent() || field_diagnostic__information().tag() !=  os_4)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_4.RAW_encode(General__Types::OCT2_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct M3UA__ERR__MessageParameters_template::single_value_struct {
M3UA__Error__Code_template field_error__Code;
M3UA__Routing__Context_template field_routing__Context;
M3UA__Affected__Point__Codes_template field_affected__Point__Codes;
M3UA__Network__Appearance_template field_network__Appearance;
M3UA__Diagnostic__information_template field_diagnostic__information;
};

void M3UA__ERR__MessageParameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_error__Code = ANY_VALUE;
single_value->field_routing__Context = ANY_OR_OMIT;
single_value->field_affected__Point__Codes = ANY_OR_OMIT;
single_value->field_network__Appearance = ANY_OR_OMIT;
single_value->field_diagnostic__information = ANY_OR_OMIT;
}
}
}

void M3UA__ERR__MessageParameters_template::copy_value(const M3UA__ERR__MessageParameters& other_value)
{
single_value = new single_value_struct;
if (other_value.error__Code().is_bound()) {
  single_value->field_error__Code = other_value.error__Code();
} else {
  single_value->field_error__Code.clean_up();
}
if (other_value.routing__Context().is_bound()) {
  if (other_value.routing__Context().ispresent()) single_value->field_routing__Context = other_value.routing__Context()();
  else single_value->field_routing__Context = OMIT_VALUE;
} else {
  single_value->field_routing__Context.clean_up();
}
if (other_value.affected__Point__Codes().is_bound()) {
  if (other_value.affected__Point__Codes().ispresent()) single_value->field_affected__Point__Codes = other_value.affected__Point__Codes()();
  else single_value->field_affected__Point__Codes = OMIT_VALUE;
} else {
  single_value->field_affected__Point__Codes.clean_up();
}
if (other_value.network__Appearance().is_bound()) {
  if (other_value.network__Appearance().ispresent()) single_value->field_network__Appearance = other_value.network__Appearance()();
  else single_value->field_network__Appearance = OMIT_VALUE;
} else {
  single_value->field_network__Appearance.clean_up();
}
if (other_value.diagnostic__information().is_bound()) {
  if (other_value.diagnostic__information().ispresent()) single_value->field_diagnostic__information = other_value.diagnostic__information()();
  else single_value->field_diagnostic__information = OMIT_VALUE;
} else {
  single_value->field_diagnostic__information.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__ERR__MessageParameters_template::copy_template(const M3UA__ERR__MessageParameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.error__Code().get_selection()) {
single_value->field_error__Code = other_value.error__Code();
} else {
single_value->field_error__Code.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.routing__Context().get_selection()) {
single_value->field_routing__Context = other_value.routing__Context();
} else {
single_value->field_routing__Context.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.affected__Point__Codes().get_selection()) {
single_value->field_affected__Point__Codes = other_value.affected__Point__Codes();
} else {
single_value->field_affected__Point__Codes.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.network__Appearance().get_selection()) {
single_value->field_network__Appearance = other_value.network__Appearance();
} else {
single_value->field_network__Appearance.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.diagnostic__information().get_selection()) {
single_value->field_diagnostic__information = other_value.diagnostic__information();
} else {
single_value->field_diagnostic__information.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__ERR__MessageParameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__ERR__MessageParameters_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__ERR__MessageParameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
break;
}
set_selection(other_value);
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template()
{
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template(const M3UA__ERR__MessageParameters& other_value)
{
copy_value(other_value);
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template(const OPTIONAL<M3UA__ERR__MessageParameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__ERR__MessageParameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_ERR_MessageParameters from an unbound optional field.");
}
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template(M3UA__ERR__MessageParameters_template* p_precondition, M3UA__ERR__MessageParameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template(Dynamic_Match_Interface<M3UA__ERR__MessageParameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__ERR__MessageParameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__ERR__MessageParameters_template::M3UA__ERR__MessageParameters_template(const M3UA__ERR__MessageParameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__ERR__MessageParameters_template::~M3UA__ERR__MessageParameters_template()
{
clean_up();
}

M3UA__ERR__MessageParameters_template& M3UA__ERR__MessageParameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__ERR__MessageParameters_template& M3UA__ERR__MessageParameters_template::operator=(const M3UA__ERR__MessageParameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__ERR__MessageParameters_template& M3UA__ERR__MessageParameters_template::operator=(const OPTIONAL<M3UA__ERR__MessageParameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__ERR__MessageParameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
}
return *this;
}

M3UA__ERR__MessageParameters_template& M3UA__ERR__MessageParameters_template::operator=(const M3UA__ERR__MessageParameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__ERR__MessageParameters_template::match(const M3UA__ERR__MessageParameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.error__Code().is_bound()) return FALSE;
if(!single_value->field_error__Code.match(other_value.error__Code(), legacy))return FALSE;
if(!other_value.routing__Context().is_bound()) return FALSE;
if((other_value.routing__Context().ispresent() ? !single_value->field_routing__Context.match((const M3UA__Routing__Context&)other_value.routing__Context(), legacy) : !single_value->field_routing__Context.match_omit(legacy)))return FALSE;
if(!other_value.affected__Point__Codes().is_bound()) return FALSE;
if((other_value.affected__Point__Codes().ispresent() ? !single_value->field_affected__Point__Codes.match((const M3UA__Affected__Point__Codes&)other_value.affected__Point__Codes(), legacy) : !single_value->field_affected__Point__Codes.match_omit(legacy)))return FALSE;
if(!other_value.network__Appearance().is_bound()) return FALSE;
if((other_value.network__Appearance().ispresent() ? !single_value->field_network__Appearance.match((const M3UA__Network__Appearance&)other_value.network__Appearance(), legacy) : !single_value->field_network__Appearance.match_omit(legacy)))return FALSE;
if(!other_value.diagnostic__information().is_bound()) return FALSE;
if((other_value.diagnostic__information().ispresent() ? !single_value->field_diagnostic__information.match((const M3UA__Diagnostic__information&)other_value.diagnostic__information(), legacy) : !single_value->field_diagnostic__information.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
}
return FALSE;
}

boolean M3UA__ERR__MessageParameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_error__Code.is_bound()
 || (single_value->field_routing__Context.is_omit() || single_value->field_routing__Context.is_bound())
 || (single_value->field_affected__Point__Codes.is_omit() || single_value->field_affected__Point__Codes.is_bound())
 || (single_value->field_network__Appearance.is_omit() || single_value->field_network__Appearance.is_bound())
 || (single_value->field_diagnostic__information.is_omit() || single_value->field_diagnostic__information.is_bound());
}

boolean M3UA__ERR__MessageParameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_error__Code.is_value()
 && (single_value->field_routing__Context.is_omit() || single_value->field_routing__Context.is_value())
 && (single_value->field_affected__Point__Codes.is_omit() || single_value->field_affected__Point__Codes.is_value())
 && (single_value->field_network__Appearance.is_omit() || single_value->field_network__Appearance.is_value())
 && (single_value->field_diagnostic__information.is_omit() || single_value->field_diagnostic__information.is_value());
}

void M3UA__ERR__MessageParameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__ERR__MessageParameters M3UA__ERR__MessageParameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
M3UA__ERR__MessageParameters ret_val;
if (single_value->field_error__Code.is_bound()) {
ret_val.error__Code() = single_value->field_error__Code.valueof();
}
if (single_value->field_routing__Context.is_omit()) ret_val.routing__Context() = OMIT_VALUE;
else if (single_value->field_routing__Context.is_bound()) {
ret_val.routing__Context() = single_value->field_routing__Context.valueof();
}
if (single_value->field_affected__Point__Codes.is_omit()) ret_val.affected__Point__Codes() = OMIT_VALUE;
else if (single_value->field_affected__Point__Codes.is_bound()) {
ret_val.affected__Point__Codes() = single_value->field_affected__Point__Codes.valueof();
}
if (single_value->field_network__Appearance.is_omit()) ret_val.network__Appearance() = OMIT_VALUE;
else if (single_value->field_network__Appearance.is_bound()) {
ret_val.network__Appearance() = single_value->field_network__Appearance.valueof();
}
if (single_value->field_diagnostic__information.is_omit()) ret_val.diagnostic__information() = OMIT_VALUE;
else if (single_value->field_diagnostic__information.is_bound()) {
ret_val.diagnostic__information() = single_value->field_diagnostic__information.valueof();
}
return ret_val;
}

void M3UA__ERR__MessageParameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__ERR__MessageParameters_template[list_length];
}

M3UA__ERR__MessageParameters_template& M3UA__ERR__MessageParameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
return value_list.list_value[list_index];
}

M3UA__Error__Code_template& M3UA__ERR__MessageParameters_template::error__Code()
{
set_specific();
return single_value->field_error__Code;
}

const M3UA__Error__Code_template& M3UA__ERR__MessageParameters_template::error__Code() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field error_Code of a non-specific template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
return single_value->field_error__Code;
}

M3UA__Routing__Context_template& M3UA__ERR__MessageParameters_template::routing__Context()
{
set_specific();
return single_value->field_routing__Context;
}

const M3UA__Routing__Context_template& M3UA__ERR__MessageParameters_template::routing__Context() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field routing_Context of a non-specific template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
return single_value->field_routing__Context;
}

M3UA__Affected__Point__Codes_template& M3UA__ERR__MessageParameters_template::affected__Point__Codes()
{
set_specific();
return single_value->field_affected__Point__Codes;
}

const M3UA__Affected__Point__Codes_template& M3UA__ERR__MessageParameters_template::affected__Point__Codes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field affected_Point_Codes of a non-specific template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
return single_value->field_affected__Point__Codes;
}

M3UA__Network__Appearance_template& M3UA__ERR__MessageParameters_template::network__Appearance()
{
set_specific();
return single_value->field_network__Appearance;
}

const M3UA__Network__Appearance_template& M3UA__ERR__MessageParameters_template::network__Appearance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field network_Appearance of a non-specific template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
return single_value->field_network__Appearance;
}

M3UA__Diagnostic__information_template& M3UA__ERR__MessageParameters_template::diagnostic__information()
{
set_specific();
return single_value->field_diagnostic__information;
}

const M3UA__Diagnostic__information_template& M3UA__ERR__MessageParameters_template::diagnostic__information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field diagnostic_information of a non-specific template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
return single_value->field_diagnostic__information;
}

int M3UA__ERR__MessageParameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_routing__Context.is_present()) ret_val++;
      if (single_value->field_affected__Point__Codes.is_present()) ret_val++;
      if (single_value->field_network__Appearance.is_present()) ret_val++;
      if (single_value->field_diagnostic__information.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR_MessageParameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
  }
  return 0;
}

void M3UA__ERR__MessageParameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ error_Code := ");
single_value->field_error__Code.log();
TTCN_Logger::log_event_str(", routing_Context := ");
single_value->field_routing__Context.log();
TTCN_Logger::log_event_str(", affected_Point_Codes := ");
single_value->field_affected__Point__Codes.log();
TTCN_Logger::log_event_str(", network_Appearance := ");
single_value->field_network__Appearance.log();
TTCN_Logger::log_event_str(", diagnostic_information := ");
single_value->field_diagnostic__information.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__ERR__MessageParameters_template::log_match(const M3UA__ERR__MessageParameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_error__Code.match(match_value.error__Code(), legacy)){
TTCN_Logger::log_logmatch_info(".error_Code");
single_value->field_error__Code.log_match(match_value.error__Code(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.routing__Context().ispresent()){
if(!single_value->field_routing__Context.match(match_value.routing__Context(), legacy)){
TTCN_Logger::log_logmatch_info(".routing_Context");
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_routing__Context.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".routing_Context := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_routing__Context.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.affected__Point__Codes().ispresent()){
if(!single_value->field_affected__Point__Codes.match(match_value.affected__Point__Codes(), legacy)){
TTCN_Logger::log_logmatch_info(".affected_Point_Codes");
single_value->field_affected__Point__Codes.log_match(match_value.affected__Point__Codes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_affected__Point__Codes.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".affected_Point_Codes := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_affected__Point__Codes.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.network__Appearance().ispresent()){
if(!single_value->field_network__Appearance.match(match_value.network__Appearance(), legacy)){
TTCN_Logger::log_logmatch_info(".network_Appearance");
single_value->field_network__Appearance.log_match(match_value.network__Appearance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_network__Appearance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".network_Appearance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_network__Appearance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.diagnostic__information().ispresent()){
if(!single_value->field_diagnostic__information.match(match_value.diagnostic__information(), legacy)){
TTCN_Logger::log_logmatch_info(".diagnostic_information");
single_value->field_diagnostic__information.log_match(match_value.diagnostic__information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_diagnostic__information.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".diagnostic_information := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_diagnostic__information.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ error_Code := ");
single_value->field_error__Code.log_match(match_value.error__Code(), legacy);
TTCN_Logger::log_event_str(", routing_Context := ");
if (match_value.routing__Context().ispresent()) {
single_value->field_routing__Context.log_match(match_value.routing__Context(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_routing__Context.log();
if (single_value->field_routing__Context.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", affected_Point_Codes := ");
if (match_value.affected__Point__Codes().ispresent()) {
single_value->field_affected__Point__Codes.log_match(match_value.affected__Point__Codes(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_affected__Point__Codes.log();
if (single_value->field_affected__Point__Codes.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", network_Appearance := ");
if (match_value.network__Appearance().ispresent()) {
single_value->field_network__Appearance.log_match(match_value.network__Appearance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_network__Appearance.log();
if (single_value->field_network__Appearance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", diagnostic_information := ");
if (match_value.diagnostic__information().ispresent()) {
single_value->field_diagnostic__information.log_match(match_value.diagnostic__information(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_diagnostic__information.log();
if (single_value->field_diagnostic__information.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__ERR__MessageParameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (error__Code().is_bound()) error__Code().set_implicit_omit();
if (!routing__Context().is_bound()) routing__Context() = OMIT_VALUE;
else routing__Context().set_implicit_omit();
if (!affected__Point__Codes().is_bound()) affected__Point__Codes() = OMIT_VALUE;
else affected__Point__Codes().set_implicit_omit();
if (!network__Appearance().is_bound()) network__Appearance() = OMIT_VALUE;
else network__Appearance().set_implicit_omit();
if (!diagnostic__information().is_bound()) diagnostic__information() = OMIT_VALUE;
else diagnostic__information().set_implicit_omit();
}

void M3UA__ERR__MessageParameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_error__Code.encode_text(text_buf);
single_value->field_routing__Context.encode_text(text_buf);
single_value->field_affected__Point__Codes.encode_text(text_buf);
single_value->field_network__Appearance.encode_text(text_buf);
single_value->field_diagnostic__information.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
}
}

void M3UA__ERR__MessageParameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_error__Code.decode_text(text_buf);
single_value->field_routing__Context.decode_text(text_buf);
single_value->field_affected__Point__Codes.decode_text(text_buf);
single_value->field_network__Appearance.decode_text(text_buf);
single_value->field_diagnostic__information.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__ERR__MessageParameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_ERR_MessageParameters.");
}
}

void M3UA__ERR__MessageParameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__ERR__MessageParameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("set template of type @M3UA_Types.M3UA_ERR_MessageParameters has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) error__Code().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) routing__Context().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) affected__Point__Codes().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) network__Appearance().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) diagnostic__information().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "error_Code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          error__Code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "routing_Context")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          routing__Context().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "affected_Point_Codes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          affected__Point__Codes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "network_Appearance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          network__Appearance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "diagnostic_information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          diagnostic__information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_ERR_MessageParameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__ERR__MessageParameters_template* precondition = new M3UA__ERR__MessageParameters_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__ERR__MessageParameters_template* implied_template = new M3UA__ERR__MessageParameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__ERR__MessageParameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@M3UA_Types.M3UA_ERR_MessageParameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__ERR__MessageParameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_error__Code.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR_MessageParameters");
single_value->field_routing__Context.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR_MessageParameters");
single_value->field_affected__Point__Codes.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR_MessageParameters");
single_value->field_network__Appearance.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR_MessageParameters");
single_value->field_diagnostic__information.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR_MessageParameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_ERR_MessageParameters");
}

boolean M3UA__ERR__MessageParameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__ERR__MessageParameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

M3UA__ERR::M3UA__ERR()
{
}

M3UA__ERR::M3UA__ERR(const OCTETSTRING& par_version,
    const OCTETSTRING& par_reserved,
    const OCTETSTRING& par_messageClassAndType,
    const INTEGER& par_messageLength,
    const M3UA__ERR__MessageParameters& par_messageParameters)
  :   field_version(par_version),
  field_reserved(par_reserved),
  field_messageClassAndType(par_messageClassAndType),
  field_messageLength(par_messageLength),
  field_messageParameters(par_messageParameters)
{
}

M3UA__ERR::M3UA__ERR(const M3UA__ERR& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @M3UA_Types.M3UA_ERR.");
if (other_value.version().is_bound()) field_version = other_value.version();
else field_version.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.messageClassAndType().is_bound()) field_messageClassAndType = other_value.messageClassAndType();
else field_messageClassAndType.clean_up();
if (other_value.messageLength().is_bound()) field_messageLength = other_value.messageLength();
else field_messageLength.clean_up();
if (other_value.messageParameters().is_bound()) field_messageParameters = other_value.messageParameters();
else field_messageParameters.clean_up();
}

void M3UA__ERR::clean_up()
{
field_version.clean_up();
field_reserved.clean_up();
field_messageClassAndType.clean_up();
field_messageLength.clean_up();
field_messageParameters.clean_up();
}

const TTCN_Typedescriptor_t* M3UA__ERR::get_descriptor() const { return &M3UA__ERR_descr_; }
M3UA__ERR& M3UA__ERR::operator=(const M3UA__ERR& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @M3UA_Types.M3UA_ERR.");
  if (other_value.version().is_bound()) field_version = other_value.version();
  else field_version.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.messageClassAndType().is_bound()) field_messageClassAndType = other_value.messageClassAndType();
  else field_messageClassAndType.clean_up();
  if (other_value.messageLength().is_bound()) field_messageLength = other_value.messageLength();
  else field_messageLength.clean_up();
  if (other_value.messageParameters().is_bound()) field_messageParameters = other_value.messageParameters();
  else field_messageParameters.clean_up();
}
return *this;
}

boolean M3UA__ERR::operator==(const M3UA__ERR& other_value) const
{
return field_version==other_value.field_version
  && field_reserved==other_value.field_reserved
  && field_messageClassAndType==other_value.field_messageClassAndType
  && field_messageLength==other_value.field_messageLength
  && field_messageParameters==other_value.field_messageParameters;
}

boolean M3UA__ERR::is_bound() const
{
return (field_version.is_bound())
  || (field_reserved.is_bound())
  || (field_messageClassAndType.is_bound())
  || (field_messageLength.is_bound())
  || (field_messageParameters.is_bound());
}
boolean M3UA__ERR::is_value() const
{
return field_version.is_value()
  && field_reserved.is_value()
  && field_messageClassAndType.is_value()
  && field_messageLength.is_value()
  && field_messageParameters.is_value();
}
void M3UA__ERR::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ version := ");
field_version.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", messageClassAndType := ");
field_messageClassAndType.log();
TTCN_Logger::log_event_str(", messageLength := ");
field_messageLength.log();
TTCN_Logger::log_event_str(", messageParameters := ");
field_messageParameters.log();
TTCN_Logger::log_event_str(" }");
}

void M3UA__ERR::set_implicit_omit()
{
if (version().is_bound()) version().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (messageClassAndType().is_bound()) messageClassAndType().set_implicit_omit();
if (messageLength().is_bound()) messageLength().set_implicit_omit();
if (messageParameters().is_bound()) messageParameters().set_implicit_omit();
}

void M3UA__ERR::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @M3UA_Types.M3UA_ERR has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) messageClassAndType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) messageLength().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) messageParameters().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageClassAndType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageClassAndType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageParameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageParameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_ERR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@M3UA_Types.M3UA_ERR");
  }
}

void M3UA__ERR::encode_text(Text_Buf& text_buf) const
{
field_version.encode_text(text_buf);
field_reserved.encode_text(text_buf);
field_messageClassAndType.encode_text(text_buf);
field_messageLength.encode_text(text_buf);
field_messageParameters.encode_text(text_buf);
}

void M3UA__ERR::decode_text(Text_Buf& text_buf)
{
field_version.decode_text(text_buf);
field_reserved.decode_text(text_buf);
field_messageClassAndType.decode_text(text_buf);
field_messageLength.decode_text(text_buf);
field_messageParameters.decode_text(text_buf);
}

void M3UA__ERR::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void M3UA__ERR::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int M3UA__ERR::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field3 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_version.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_messageClassAndType.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, M3UA__ERR_messageLength_descr_.raw->forceomit);
  decoded_field_length = field_messageLength.RAW_decode(M3UA__ERR_messageLength_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp3 = field_messageLength.convert_to_Integer(M3UA__ERR_messageLength_descr_);
  field_messageLength = tmp3;
  value_of_length_field3 += tmp3.get_long_long_val() * 8;
  value_of_length_field3 -= decoded_field_length;
  if (value_of_length_field3 < 0) return -1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, M3UA__ERR__MessageParameters_descr_.raw->forceomit);
  decoded_field_length = field_messageParameters.RAW_decode(M3UA__ERR__MessageParameters_descr_, p_buf, min_of_ints(2, limit, value_of_length_field3), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int M3UA__ERR::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, M3UA__ERR_messageLength_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, M3UA__ERR__MessageParameters_descr_.raw);
  encoded_length += field_version.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_reserved.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_messageClassAndType.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += 32;
  myleaf.body.node.nodes[3]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[3]->coding_descr = &M3UA__ERR_messageLength_descr_;
  myleaf.body.node.nodes[3]->calcof.lengthto.num_of_fields = 5;
  myleaf.body.node.nodes[3]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[3]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields = init_lengthto_fields_list(5);
  myleaf.body.node.nodes[3]->length = 32;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[0]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[0]->curr_pos.pos;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_messageParameters.RAW_encode(M3UA__ERR__MessageParameters_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct M3UA__ERR_template::single_value_struct {
OCTETSTRING_template field_version;
OCTETSTRING_template field_reserved;
OCTETSTRING_template field_messageClassAndType;
INTEGER_template field_messageLength;
M3UA__ERR__MessageParameters_template field_messageParameters;
};

void M3UA__ERR_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_version = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
single_value->field_messageClassAndType = ANY_VALUE;
single_value->field_messageLength = ANY_VALUE;
single_value->field_messageParameters = ANY_VALUE;
}
}
}

void M3UA__ERR_template::copy_value(const M3UA__ERR& other_value)
{
single_value = new single_value_struct;
if (other_value.version().is_bound()) {
  single_value->field_version = other_value.version();
} else {
  single_value->field_version.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.messageClassAndType().is_bound()) {
  single_value->field_messageClassAndType = other_value.messageClassAndType();
} else {
  single_value->field_messageClassAndType.clean_up();
}
if (other_value.messageLength().is_bound()) {
  single_value->field_messageLength = other_value.messageLength();
} else {
  single_value->field_messageLength.clean_up();
}
if (other_value.messageParameters().is_bound()) {
  single_value->field_messageParameters = other_value.messageParameters();
} else {
  single_value->field_messageParameters.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void M3UA__ERR_template::copy_template(const M3UA__ERR_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.version().get_selection()) {
single_value->field_version = other_value.version();
} else {
single_value->field_version.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.messageClassAndType().get_selection()) {
single_value->field_messageClassAndType = other_value.messageClassAndType();
} else {
single_value->field_messageClassAndType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.messageLength().get_selection()) {
single_value->field_messageLength = other_value.messageLength();
} else {
single_value->field_messageLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.messageParameters().get_selection()) {
single_value->field_messageParameters = other_value.messageParameters();
} else {
single_value->field_messageParameters.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new M3UA__ERR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new M3UA__ERR_template(*other_value.implication_.precondition);
implication_.implied_template = new M3UA__ERR_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR.");
break;
}
set_selection(other_value);
}

M3UA__ERR_template::M3UA__ERR_template()
{
}

M3UA__ERR_template::M3UA__ERR_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

M3UA__ERR_template::M3UA__ERR_template(const M3UA__ERR& other_value)
{
copy_value(other_value);
}

M3UA__ERR_template::M3UA__ERR_template(const OPTIONAL<M3UA__ERR>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__ERR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @M3UA_Types.M3UA_ERR from an unbound optional field.");
}
}

M3UA__ERR_template::M3UA__ERR_template(M3UA__ERR_template* p_precondition, M3UA__ERR_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

M3UA__ERR_template::M3UA__ERR_template(Dynamic_Match_Interface<M3UA__ERR>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<M3UA__ERR>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

M3UA__ERR_template::M3UA__ERR_template(const M3UA__ERR_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

M3UA__ERR_template::~M3UA__ERR_template()
{
clean_up();
}

M3UA__ERR_template& M3UA__ERR_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

M3UA__ERR_template& M3UA__ERR_template::operator=(const M3UA__ERR& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

M3UA__ERR_template& M3UA__ERR_template::operator=(const OPTIONAL<M3UA__ERR>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const M3UA__ERR&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @M3UA_Types.M3UA_ERR.");
}
return *this;
}

M3UA__ERR_template& M3UA__ERR_template::operator=(const M3UA__ERR_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean M3UA__ERR_template::match(const M3UA__ERR& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.version().is_bound()) return FALSE;
if(!single_value->field_version.match(other_value.version(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.messageClassAndType().is_bound()) return FALSE;
if(!single_value->field_messageClassAndType.match(other_value.messageClassAndType(), legacy))return FALSE;
if(!other_value.messageLength().is_bound()) return FALSE;
if(!single_value->field_messageLength.match(other_value.messageLength(), legacy))return FALSE;
if(!other_value.messageParameters().is_bound()) return FALSE;
if(!single_value->field_messageParameters.match(other_value.messageParameters(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR.");
}
return FALSE;
}

boolean M3UA__ERR_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_version.is_bound()
 || single_value->field_reserved.is_bound()
 || single_value->field_messageClassAndType.is_bound()
 || single_value->field_messageLength.is_bound()
 || single_value->field_messageParameters.is_bound();
}

boolean M3UA__ERR_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_version.is_value()
 && single_value->field_reserved.is_value()
 && single_value->field_messageClassAndType.is_value()
 && single_value->field_messageLength.is_value()
 && single_value->field_messageParameters.is_value();
}

void M3UA__ERR_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

M3UA__ERR M3UA__ERR_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @M3UA_Types.M3UA_ERR.");
M3UA__ERR ret_val;
if (single_value->field_version.is_bound()) {
ret_val.version() = single_value->field_version.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_messageClassAndType.is_bound()) {
ret_val.messageClassAndType() = single_value->field_messageClassAndType.valueof();
}
if (single_value->field_messageLength.is_bound()) {
ret_val.messageLength() = single_value->field_messageLength.valueof();
}
if (single_value->field_messageParameters.is_bound()) {
ret_val.messageParameters() = single_value->field_messageParameters.valueof();
}
return ret_val;
}

void M3UA__ERR_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @M3UA_Types.M3UA_ERR.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new M3UA__ERR_template[list_length];
}

M3UA__ERR_template& M3UA__ERR_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @M3UA_Types.M3UA_ERR.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @M3UA_Types.M3UA_ERR.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& M3UA__ERR_template::version()
{
set_specific();
return single_value->field_version;
}

const OCTETSTRING_template& M3UA__ERR_template::version() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field version of a non-specific template of type @M3UA_Types.M3UA_ERR.");
return single_value->field_version;
}

OCTETSTRING_template& M3UA__ERR_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const OCTETSTRING_template& M3UA__ERR_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @M3UA_Types.M3UA_ERR.");
return single_value->field_reserved;
}

OCTETSTRING_template& M3UA__ERR_template::messageClassAndType()
{
set_specific();
return single_value->field_messageClassAndType;
}

const OCTETSTRING_template& M3UA__ERR_template::messageClassAndType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageClassAndType of a non-specific template of type @M3UA_Types.M3UA_ERR.");
return single_value->field_messageClassAndType;
}

INTEGER_template& M3UA__ERR_template::messageLength()
{
set_specific();
return single_value->field_messageLength;
}

const INTEGER_template& M3UA__ERR_template::messageLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageLength of a non-specific template of type @M3UA_Types.M3UA_ERR.");
return single_value->field_messageLength;
}

M3UA__ERR__MessageParameters_template& M3UA__ERR_template::messageParameters()
{
set_specific();
return single_value->field_messageParameters;
}

const M3UA__ERR__MessageParameters_template& M3UA__ERR_template::messageParameters() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageParameters of a non-specific template of type @M3UA_Types.M3UA_ERR.");
return single_value->field_messageParameters;
}

int M3UA__ERR_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @M3UA_Types.M3UA_ERR containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR.");
  }
  return 0;
}

void M3UA__ERR_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", messageClassAndType := ");
single_value->field_messageClassAndType.log();
TTCN_Logger::log_event_str(", messageLength := ");
single_value->field_messageLength.log();
TTCN_Logger::log_event_str(", messageParameters := ");
single_value->field_messageParameters.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void M3UA__ERR_template::log_match(const M3UA__ERR& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_version.match(match_value.version(), legacy)){
TTCN_Logger::log_logmatch_info(".version");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_messageClassAndType.match(match_value.messageClassAndType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageClassAndType");
single_value->field_messageClassAndType.log_match(match_value.messageClassAndType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_messageLength.match(match_value.messageLength(), legacy)){
TTCN_Logger::log_logmatch_info(".messageLength");
single_value->field_messageLength.log_match(match_value.messageLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_messageParameters.match(match_value.messageParameters(), legacy)){
TTCN_Logger::log_logmatch_info(".messageParameters");
single_value->field_messageParameters.log_match(match_value.messageParameters(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ version := ");
single_value->field_version.log_match(match_value.version(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", messageClassAndType := ");
single_value->field_messageClassAndType.log_match(match_value.messageClassAndType(), legacy);
TTCN_Logger::log_event_str(", messageLength := ");
single_value->field_messageLength.log_match(match_value.messageLength(), legacy);
TTCN_Logger::log_event_str(", messageParameters := ");
single_value->field_messageParameters.log_match(match_value.messageParameters(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void M3UA__ERR_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (version().is_bound()) version().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (messageClassAndType().is_bound()) messageClassAndType().set_implicit_omit();
if (messageLength().is_bound()) messageLength().set_implicit_omit();
if (messageParameters().is_bound()) messageParameters().set_implicit_omit();
}

void M3UA__ERR_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_version.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
single_value->field_messageClassAndType.encode_text(text_buf);
single_value->field_messageLength.encode_text(text_buf);
single_value->field_messageParameters.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @M3UA_Types.M3UA_ERR.");
}
}

void M3UA__ERR_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_version.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
single_value->field_messageClassAndType.decode_text(text_buf);
single_value->field_messageLength.decode_text(text_buf);
single_value->field_messageParameters.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new M3UA__ERR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @M3UA_Types.M3UA_ERR.");
}
}

void M3UA__ERR_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    M3UA__ERR_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @M3UA_Types.M3UA_ERR has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) messageClassAndType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) messageLength().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) messageParameters().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageClassAndType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageClassAndType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageParameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageParameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @M3UA_Types.M3UA_ERR: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    M3UA__ERR_template* precondition = new M3UA__ERR_template;
    precondition->set_param(*param.get_elem(0));
    M3UA__ERR_template* implied_template = new M3UA__ERR_template;
    implied_template->set_param(*param.get_elem(1));
    *this = M3UA__ERR_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@M3UA_Types.M3UA_ERR");
  }
  is_ifpresent = param.get_ifpresent();
}

void M3UA__ERR_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_version.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR");
single_value->field_messageClassAndType.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR");
single_value->field_messageLength.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR");
single_value->field_messageParameters.check_restriction(t_res, t_name ? t_name : "@M3UA_Types.M3UA_ERR");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@M3UA_Types.M3UA_ERR");
}

boolean M3UA__ERR_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean M3UA__ERR_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
