// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "SCCP_Types.hh"

namespace SCCP__Types {

/* Member functions of C++ classes */

SCCP__param__SequencingSegmenting::SCCP__param__SequencingSegmenting()
{
}

SCCP__param__SequencingSegmenting::SCCP__param__SequencingSegmenting(const BITSTRING& par_reserved,
    const BITSTRING& par_p__s,
    const BITSTRING& par_more,
    const BITSTRING& par_pr)
  :   field_reserved(par_reserved),
  field_p__s(par_p__s),
  field_more(par_more),
  field_pr(par_pr)
{
}

SCCP__param__SequencingSegmenting::SCCP__param__SequencingSegmenting(const SCCP__param__SequencingSegmenting& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.p__s().is_bound()) field_p__s = other_value.p__s();
else field_p__s.clean_up();
if (other_value.more().is_bound()) field_more = other_value.more();
else field_more.clean_up();
if (other_value.pr().is_bound()) field_pr = other_value.pr();
else field_pr.clean_up();
}

void SCCP__param__SequencingSegmenting::clean_up()
{
field_reserved.clean_up();
field_p__s.clean_up();
field_more.clean_up();
field_pr.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__SequencingSegmenting::get_descriptor() const { return &SCCP__param__SequencingSegmenting_descr_; }
SCCP__param__SequencingSegmenting& SCCP__param__SequencingSegmenting::operator=(const SCCP__param__SequencingSegmenting& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.p__s().is_bound()) field_p__s = other_value.p__s();
  else field_p__s.clean_up();
  if (other_value.more().is_bound()) field_more = other_value.more();
  else field_more.clean_up();
  if (other_value.pr().is_bound()) field_pr = other_value.pr();
  else field_pr.clean_up();
}
return *this;
}

boolean SCCP__param__SequencingSegmenting::operator==(const SCCP__param__SequencingSegmenting& other_value) const
{
return field_reserved==other_value.field_reserved
  && field_p__s==other_value.field_p__s
  && field_more==other_value.field_more
  && field_pr==other_value.field_pr;
}

boolean SCCP__param__SequencingSegmenting::is_bound() const
{
return (field_reserved.is_bound())
  || (field_p__s.is_bound())
  || (field_more.is_bound())
  || (field_pr.is_bound());
}
boolean SCCP__param__SequencingSegmenting::is_value() const
{
return field_reserved.is_value()
  && field_p__s.is_value()
  && field_more.is_value()
  && field_pr.is_value();
}
void SCCP__param__SequencingSegmenting::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", p_s := ");
field_p__s.log();
TTCN_Logger::log_event_str(", more := ");
field_more.log();
TTCN_Logger::log_event_str(", pr := ");
field_pr.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__SequencingSegmenting::set_implicit_omit()
{
if (reserved().is_bound()) reserved().set_implicit_omit();
if (p__s().is_bound()) p__s().set_implicit_omit();
if (more().is_bound()) more().set_implicit_omit();
if (pr().is_bound()) pr().set_implicit_omit();
}

void SCCP__param__SequencingSegmenting::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_SequencingSegmenting has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) p__s().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) more().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pr().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "p_s")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          p__s().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "more")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          more().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_SequencingSegmenting: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_SequencingSegmenting");
  }
}

void SCCP__param__SequencingSegmenting::encode_text(Text_Buf& text_buf) const
{
field_reserved.encode_text(text_buf);
field_p__s.encode_text(text_buf);
field_more.encode_text(text_buf);
field_pr.encode_text(text_buf);
}

void SCCP__param__SequencingSegmenting::decode_text(Text_Buf& text_buf)
{
field_reserved.decode_text(text_buf);
field_p__s.decode_text(text_buf);
field_more.decode_text(text_buf);
field_pr.decode_text(text_buf);
}

void SCCP__param__SequencingSegmenting::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__SequencingSegmenting::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__SequencingSegmenting::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_p__s.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_more.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_pr.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__SequencingSegmenting::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT7_descr_.raw);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_p__s.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_more.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_pr.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__SequencingSegmenting_template::single_value_struct {
BITSTRING_template field_reserved;
BITSTRING_template field_p__s;
BITSTRING_template field_more;
BITSTRING_template field_pr;
};

void SCCP__param__SequencingSegmenting_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_reserved = ANY_VALUE;
single_value->field_p__s = ANY_VALUE;
single_value->field_more = ANY_VALUE;
single_value->field_pr = ANY_VALUE;
}
}
}

void SCCP__param__SequencingSegmenting_template::copy_value(const SCCP__param__SequencingSegmenting& other_value)
{
single_value = new single_value_struct;
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.p__s().is_bound()) {
  single_value->field_p__s = other_value.p__s();
} else {
  single_value->field_p__s.clean_up();
}
if (other_value.more().is_bound()) {
  single_value->field_more = other_value.more();
} else {
  single_value->field_more.clean_up();
}
if (other_value.pr().is_bound()) {
  single_value->field_pr = other_value.pr();
} else {
  single_value->field_pr.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__SequencingSegmenting_template::copy_template(const SCCP__param__SequencingSegmenting_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.p__s().get_selection()) {
single_value->field_p__s = other_value.p__s();
} else {
single_value->field_p__s.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.more().get_selection()) {
single_value->field_more = other_value.more();
} else {
single_value->field_more.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pr().get_selection()) {
single_value->field_pr = other_value.pr();
} else {
single_value->field_pr.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__SequencingSegmenting_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__SequencingSegmenting_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__SequencingSegmenting_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
break;
}
set_selection(other_value);
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template()
{
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template(const SCCP__param__SequencingSegmenting& other_value)
{
copy_value(other_value);
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template(const OPTIONAL<SCCP__param__SequencingSegmenting>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__SequencingSegmenting&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_SequencingSegmenting from an unbound optional field.");
}
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template(SCCP__param__SequencingSegmenting_template* p_precondition, SCCP__param__SequencingSegmenting_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template(Dynamic_Match_Interface<SCCP__param__SequencingSegmenting>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__SequencingSegmenting>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__SequencingSegmenting_template::SCCP__param__SequencingSegmenting_template(const SCCP__param__SequencingSegmenting_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__SequencingSegmenting_template::~SCCP__param__SequencingSegmenting_template()
{
clean_up();
}

SCCP__param__SequencingSegmenting_template& SCCP__param__SequencingSegmenting_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__SequencingSegmenting_template& SCCP__param__SequencingSegmenting_template::operator=(const SCCP__param__SequencingSegmenting& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__SequencingSegmenting_template& SCCP__param__SequencingSegmenting_template::operator=(const OPTIONAL<SCCP__param__SequencingSegmenting>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__SequencingSegmenting&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
}
return *this;
}

SCCP__param__SequencingSegmenting_template& SCCP__param__SequencingSegmenting_template::operator=(const SCCP__param__SequencingSegmenting_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__SequencingSegmenting_template::match(const SCCP__param__SequencingSegmenting& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.p__s().is_bound()) return FALSE;
if(!single_value->field_p__s.match(other_value.p__s(), legacy))return FALSE;
if(!other_value.more().is_bound()) return FALSE;
if(!single_value->field_more.match(other_value.more(), legacy))return FALSE;
if(!other_value.pr().is_bound()) return FALSE;
if(!single_value->field_pr.match(other_value.pr(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
}
return FALSE;
}

boolean SCCP__param__SequencingSegmenting_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_reserved.is_bound()
 || single_value->field_p__s.is_bound()
 || single_value->field_more.is_bound()
 || single_value->field_pr.is_bound();
}

boolean SCCP__param__SequencingSegmenting_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_reserved.is_value()
 && single_value->field_p__s.is_value()
 && single_value->field_more.is_value()
 && single_value->field_pr.is_value();
}

void SCCP__param__SequencingSegmenting_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__SequencingSegmenting SCCP__param__SequencingSegmenting_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
SCCP__param__SequencingSegmenting ret_val;
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_p__s.is_bound()) {
ret_val.p__s() = single_value->field_p__s.valueof();
}
if (single_value->field_more.is_bound()) {
ret_val.more() = single_value->field_more.valueof();
}
if (single_value->field_pr.is_bound()) {
ret_val.pr() = single_value->field_pr.valueof();
}
return ret_val;
}

void SCCP__param__SequencingSegmenting_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__SequencingSegmenting_template[list_length];
}

SCCP__param__SequencingSegmenting_template& SCCP__param__SequencingSegmenting_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
return value_list.list_value[list_index];
}

BITSTRING_template& SCCP__param__SequencingSegmenting_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& SCCP__param__SequencingSegmenting_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
return single_value->field_reserved;
}

BITSTRING_template& SCCP__param__SequencingSegmenting_template::p__s()
{
set_specific();
return single_value->field_p__s;
}

const BITSTRING_template& SCCP__param__SequencingSegmenting_template::p__s() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field p_s of a non-specific template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
return single_value->field_p__s;
}

BITSTRING_template& SCCP__param__SequencingSegmenting_template::more()
{
set_specific();
return single_value->field_more;
}

const BITSTRING_template& SCCP__param__SequencingSegmenting_template::more() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field more of a non-specific template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
return single_value->field_more;
}

BITSTRING_template& SCCP__param__SequencingSegmenting_template::pr()
{
set_specific();
return single_value->field_pr;
}

const BITSTRING_template& SCCP__param__SequencingSegmenting_template::pr() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pr of a non-specific template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
return single_value->field_pr;
}

int SCCP__param__SequencingSegmenting_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_SequencingSegmenting containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
  }
  return 0;
}

void SCCP__param__SequencingSegmenting_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", p_s := ");
single_value->field_p__s.log();
TTCN_Logger::log_event_str(", more := ");
single_value->field_more.log();
TTCN_Logger::log_event_str(", pr := ");
single_value->field_pr.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__SequencingSegmenting_template::log_match(const SCCP__param__SequencingSegmenting& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_p__s.match(match_value.p__s(), legacy)){
TTCN_Logger::log_logmatch_info(".p_s");
single_value->field_p__s.log_match(match_value.p__s(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_more.match(match_value.more(), legacy)){
TTCN_Logger::log_logmatch_info(".more");
single_value->field_more.log_match(match_value.more(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pr.match(match_value.pr(), legacy)){
TTCN_Logger::log_logmatch_info(".pr");
single_value->field_pr.log_match(match_value.pr(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", p_s := ");
single_value->field_p__s.log_match(match_value.p__s(), legacy);
TTCN_Logger::log_event_str(", more := ");
single_value->field_more.log_match(match_value.more(), legacy);
TTCN_Logger::log_event_str(", pr := ");
single_value->field_pr.log_match(match_value.pr(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__SequencingSegmenting_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (reserved().is_bound()) reserved().set_implicit_omit();
if (p__s().is_bound()) p__s().set_implicit_omit();
if (more().is_bound()) more().set_implicit_omit();
if (pr().is_bound()) pr().set_implicit_omit();
}

void SCCP__param__SequencingSegmenting_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_reserved.encode_text(text_buf);
single_value->field_p__s.encode_text(text_buf);
single_value->field_more.encode_text(text_buf);
single_value->field_pr.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
}
}

void SCCP__param__SequencingSegmenting_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_reserved.decode_text(text_buf);
single_value->field_p__s.decode_text(text_buf);
single_value->field_more.decode_text(text_buf);
single_value->field_pr.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__SequencingSegmenting_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_SequencingSegmenting.");
}
}

void SCCP__param__SequencingSegmenting_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__SequencingSegmenting_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_SequencingSegmenting has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) p__s().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) more().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pr().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "p_s")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          p__s().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "more")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          more().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pr")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pr().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_SequencingSegmenting: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__SequencingSegmenting_template* precondition = new SCCP__param__SequencingSegmenting_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__SequencingSegmenting_template* implied_template = new SCCP__param__SequencingSegmenting_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__SequencingSegmenting_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_SequencingSegmenting");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__SequencingSegmenting_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_SequencingSegmenting");
single_value->field_p__s.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_SequencingSegmenting");
single_value->field_more.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_SequencingSegmenting");
single_value->field_pr.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_SequencingSegmenting");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_SequencingSegmenting");
}

boolean SCCP__param__SequencingSegmenting_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__SequencingSegmenting_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__Credit__opt::SCCP__param__Credit__opt()
{
}

SCCP__param__Credit__opt::SCCP__param__Credit__opt(const INTEGER& par_paramName,
    const INTEGER& par_paramLength,
    const OCTETSTRING& par_credit)
  :   field_paramName(par_paramName),
  field_paramLength(par_paramLength),
  field_credit(par_credit)
{
}

SCCP__param__Credit__opt::SCCP__param__Credit__opt(const SCCP__param__Credit__opt& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_Credit_opt.");
if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
else field_paramName.clean_up();
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.credit().is_bound()) field_credit = other_value.credit();
else field_credit.clean_up();
}

void SCCP__param__Credit__opt::clean_up()
{
field_paramName.clean_up();
field_paramLength.clean_up();
field_credit.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__Credit__opt::get_descriptor() const { return &SCCP__param__Credit__opt_descr_; }
SCCP__param__Credit__opt& SCCP__param__Credit__opt::operator=(const SCCP__param__Credit__opt& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_Credit_opt.");
  if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
  else field_paramName.clean_up();
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.credit().is_bound()) field_credit = other_value.credit();
  else field_credit.clean_up();
}
return *this;
}

boolean SCCP__param__Credit__opt::operator==(const SCCP__param__Credit__opt& other_value) const
{
return field_paramName==other_value.field_paramName
  && field_paramLength==other_value.field_paramLength
  && field_credit==other_value.field_credit;
}

boolean SCCP__param__Credit__opt::is_bound() const
{
return (field_paramName.is_bound())
  || (field_paramLength.is_bound())
  || (field_credit.is_bound());
}
boolean SCCP__param__Credit__opt::is_value() const
{
return field_paramName.is_value()
  && field_paramLength.is_value()
  && field_credit.is_value();
}
void SCCP__param__Credit__opt::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramName := ");
field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", credit := ");
field_credit.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__Credit__opt::set_implicit_omit()
{
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (credit().is_bound()) credit().set_implicit_omit();
}

void SCCP__param__Credit__opt::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_Credit_opt has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Credit_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_Credit_opt");
  }
}

void SCCP__param__Credit__opt::encode_text(Text_Buf& text_buf) const
{
field_paramName.encode_text(text_buf);
field_paramLength.encode_text(text_buf);
field_credit.encode_text(text_buf);
}

void SCCP__param__Credit__opt::decode_text(Text_Buf& text_buf)
{
field_paramName.decode_text(text_buf);
field_paramLength.decode_text(text_buf);
field_credit.decode_text(text_buf);
}

void SCCP__param__Credit__opt::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__Credit__opt::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__Credit__opt::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__field__ParameterName_descr_.raw->forceomit);
  decoded_field_length = field_paramName.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::LIN1_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(General__Types::LIN1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_credit.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__Credit__opt::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__field__ParameterName_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::LIN1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_paramName.RAW_encode(SCCP__field__ParameterName_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_paramLength.RAW_encode(General__Types::LIN1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_credit.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__Credit__opt_template::single_value_struct {
INTEGER_template field_paramName;
INTEGER_template field_paramLength;
OCTETSTRING_template field_credit;
};

void SCCP__param__Credit__opt_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramName = ANY_VALUE;
single_value->field_paramLength = ANY_VALUE;
single_value->field_credit = ANY_VALUE;
}
}
}

void SCCP__param__Credit__opt_template::copy_value(const SCCP__param__Credit__opt& other_value)
{
single_value = new single_value_struct;
if (other_value.paramName().is_bound()) {
  single_value->field_paramName = other_value.paramName();
} else {
  single_value->field_paramName.clean_up();
}
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.credit().is_bound()) {
  single_value->field_credit = other_value.credit();
} else {
  single_value->field_credit.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__Credit__opt_template::copy_template(const SCCP__param__Credit__opt_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramName().get_selection()) {
single_value->field_paramName = other_value.paramName();
} else {
single_value->field_paramName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.credit().get_selection()) {
single_value->field_credit = other_value.credit();
} else {
single_value->field_credit.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__Credit__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__Credit__opt_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__Credit__opt_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Credit_opt.");
break;
}
set_selection(other_value);
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template()
{
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template(const SCCP__param__Credit__opt& other_value)
{
copy_value(other_value);
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template(const OPTIONAL<SCCP__param__Credit__opt>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Credit__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_Credit_opt from an unbound optional field.");
}
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template(SCCP__param__Credit__opt_template* p_precondition, SCCP__param__Credit__opt_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template(Dynamic_Match_Interface<SCCP__param__Credit__opt>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__Credit__opt>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__Credit__opt_template::SCCP__param__Credit__opt_template(const SCCP__param__Credit__opt_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__Credit__opt_template::~SCCP__param__Credit__opt_template()
{
clean_up();
}

SCCP__param__Credit__opt_template& SCCP__param__Credit__opt_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__Credit__opt_template& SCCP__param__Credit__opt_template::operator=(const SCCP__param__Credit__opt& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__Credit__opt_template& SCCP__param__Credit__opt_template::operator=(const OPTIONAL<SCCP__param__Credit__opt>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Credit__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_Credit_opt.");
}
return *this;
}

SCCP__param__Credit__opt_template& SCCP__param__Credit__opt_template::operator=(const SCCP__param__Credit__opt_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__Credit__opt_template::match(const SCCP__param__Credit__opt& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramName().is_bound()) return FALSE;
if(!single_value->field_paramName.match(other_value.paramName(), legacy))return FALSE;
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.credit().is_bound()) return FALSE;
if(!single_value->field_credit.match(other_value.credit(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Credit_opt.");
}
return FALSE;
}

boolean SCCP__param__Credit__opt_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramName.is_bound()
 || single_value->field_paramLength.is_bound()
 || single_value->field_credit.is_bound();
}

boolean SCCP__param__Credit__opt_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramName.is_value()
 && single_value->field_paramLength.is_value()
 && single_value->field_credit.is_value();
}

void SCCP__param__Credit__opt_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__Credit__opt SCCP__param__Credit__opt_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_Credit_opt.");
SCCP__param__Credit__opt ret_val;
if (single_value->field_paramName.is_bound()) {
ret_val.paramName() = single_value->field_paramName.valueof();
}
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_credit.is_bound()) {
ret_val.credit() = single_value->field_credit.valueof();
}
return ret_val;
}

void SCCP__param__Credit__opt_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_Credit_opt.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__Credit__opt_template[list_length];
}

SCCP__param__Credit__opt_template& SCCP__param__Credit__opt_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_Credit_opt.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_Credit_opt.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__Credit__opt_template::paramName()
{
set_specific();
return single_value->field_paramName;
}

const INTEGER_template& SCCP__param__Credit__opt_template::paramName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramName of a non-specific template of type @SCCP_Types.SCCP_param_Credit_opt.");
return single_value->field_paramName;
}

INTEGER_template& SCCP__param__Credit__opt_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__Credit__opt_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_Credit_opt.");
return single_value->field_paramLength;
}

OCTETSTRING_template& SCCP__param__Credit__opt_template::credit()
{
set_specific();
return single_value->field_credit;
}

const OCTETSTRING_template& SCCP__param__Credit__opt_template::credit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field credit of a non-specific template of type @SCCP_Types.SCCP_param_Credit_opt.");
return single_value->field_credit;
}

int SCCP__param__Credit__opt_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Credit_opt containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Credit_opt.");
  }
  return 0;
}

void SCCP__param__Credit__opt_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", credit := ");
single_value->field_credit.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__Credit__opt_template::log_match(const SCCP__param__Credit__opt& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramName.match(match_value.paramName(), legacy)){
TTCN_Logger::log_logmatch_info(".paramName");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_credit.match(match_value.credit(), legacy)){
TTCN_Logger::log_logmatch_info(".credit");
single_value->field_credit.log_match(match_value.credit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", credit := ");
single_value->field_credit.log_match(match_value.credit(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__Credit__opt_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (credit().is_bound()) credit().set_implicit_omit();
}

void SCCP__param__Credit__opt_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramName.encode_text(text_buf);
single_value->field_paramLength.encode_text(text_buf);
single_value->field_credit.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Credit_opt.");
}
}

void SCCP__param__Credit__opt_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramName.decode_text(text_buf);
single_value->field_paramLength.decode_text(text_buf);
single_value->field_credit.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__Credit__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_Credit_opt.");
}
}

void SCCP__param__Credit__opt_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__Credit__opt_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_Credit_opt has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Credit_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__Credit__opt_template* precondition = new SCCP__param__Credit__opt_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__Credit__opt_template* implied_template = new SCCP__param__Credit__opt_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__Credit__opt_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_Credit_opt");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__Credit__opt_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramName.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Credit_opt");
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Credit_opt");
single_value->field_credit.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Credit_opt");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_Credit_opt");
}

boolean SCCP__param__Credit__opt_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__Credit__opt_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__Data::SCCP__param__Data()
{
}

SCCP__param__Data::SCCP__param__Data(const INTEGER& par_paramLength,
    const OCTETSTRING& par_data)
  :   field_paramLength(par_paramLength),
  field_data(par_data)
{
}

SCCP__param__Data::SCCP__param__Data(const SCCP__param__Data& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_Data.");
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
}

void SCCP__param__Data::clean_up()
{
field_paramLength.clean_up();
field_data.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__Data::get_descriptor() const { return &SCCP__param__Data_descr_; }
SCCP__param__Data& SCCP__param__Data::operator=(const SCCP__param__Data& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_Data.");
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
}
return *this;
}

boolean SCCP__param__Data::operator==(const SCCP__param__Data& other_value) const
{
return field_paramLength==other_value.field_paramLength
  && field_data==other_value.field_data;
}

boolean SCCP__param__Data::is_bound() const
{
return (field_paramLength.is_bound())
  || (field_data.is_bound());
}
boolean SCCP__param__Data::is_value() const
{
return field_paramLength.is_value()
  && field_data.is_value();
}
void SCCP__param__Data::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__Data::set_implicit_omit()
{
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void SCCP__param__Data::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_Data has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_Data");
  }
}

void SCCP__param__Data::encode_text(Text_Buf& text_buf) const
{
field_paramLength.encode_text(text_buf);
field_data.encode_text(text_buf);
}

void SCCP__param__Data::decode_text(Text_Buf& text_buf)
{
field_paramLength.decode_text(text_buf);
field_data.decode_text(text_buf);
}

void SCCP__param__Data::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__Data::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__Data::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__Data_paramLength_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(SCCP__param__Data_paramLength_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_paramLength.convert_to_Integer(SCCP__param__Data_paramLength_descr_);
  field_paramLength = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_data.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__Data::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__Data_paramLength_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCTN_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &SCCP__param__Data_paramLength_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_data.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__Data_template::single_value_struct {
INTEGER_template field_paramLength;
OCTETSTRING_template field_data;
};

void SCCP__param__Data_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramLength = ANY_VALUE;
single_value->field_data = ANY_VALUE;
}
}
}

void SCCP__param__Data_template::copy_value(const SCCP__param__Data& other_value)
{
single_value = new single_value_struct;
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.data().is_bound()) {
  single_value->field_data = other_value.data();
} else {
  single_value->field_data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__Data_template::copy_template(const SCCP__param__Data_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__Data_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__Data_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data.");
break;
}
set_selection(other_value);
}

SCCP__param__Data_template::SCCP__param__Data_template()
{
}

SCCP__param__Data_template::SCCP__param__Data_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__Data_template::SCCP__param__Data_template(const SCCP__param__Data& other_value)
{
copy_value(other_value);
}

SCCP__param__Data_template::SCCP__param__Data_template(const OPTIONAL<SCCP__param__Data>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_Data from an unbound optional field.");
}
}

SCCP__param__Data_template::SCCP__param__Data_template(SCCP__param__Data_template* p_precondition, SCCP__param__Data_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__Data_template::SCCP__param__Data_template(Dynamic_Match_Interface<SCCP__param__Data>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__Data>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__Data_template::SCCP__param__Data_template(const SCCP__param__Data_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__Data_template::~SCCP__param__Data_template()
{
clean_up();
}

SCCP__param__Data_template& SCCP__param__Data_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__Data_template& SCCP__param__Data_template::operator=(const SCCP__param__Data& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__Data_template& SCCP__param__Data_template::operator=(const OPTIONAL<SCCP__param__Data>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_Data.");
}
return *this;
}

SCCP__param__Data_template& SCCP__param__Data_template::operator=(const SCCP__param__Data_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__Data_template::match(const SCCP__param__Data& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if(!single_value->field_data.match(other_value.data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data.");
}
return FALSE;
}

boolean SCCP__param__Data_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramLength.is_bound()
 || single_value->field_data.is_bound();
}

boolean SCCP__param__Data_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramLength.is_value()
 && single_value->field_data.is_value();
}

void SCCP__param__Data_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__Data SCCP__param__Data_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_Data.");
SCCP__param__Data ret_val;
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
return ret_val;
}

void SCCP__param__Data_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_Data.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__Data_template[list_length];
}

SCCP__param__Data_template& SCCP__param__Data_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_Data.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_Data.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__Data_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__Data_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_Data.");
return single_value->field_paramLength;
}

OCTETSTRING_template& SCCP__param__Data_template::data()
{
set_specific();
return single_value->field_data;
}

const OCTETSTRING_template& SCCP__param__Data_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_param_Data.");
return single_value->field_data;
}

int SCCP__param__Data_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data.");
  }
  return 0;
}

void SCCP__param__Data_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__Data_template::log_match(const SCCP__param__Data& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__Data_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void SCCP__param__Data_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramLength.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data.");
}
}

void SCCP__param__Data_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramLength.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_Data.");
}
}

void SCCP__param__Data_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__Data_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_Data has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__Data_template* precondition = new SCCP__param__Data_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__Data_template* implied_template = new SCCP__param__Data_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__Data_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_Data");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__Data_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Data");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Data");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_Data");
}

boolean SCCP__param__Data_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__Data_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__Data__opt::SCCP__param__Data__opt()
{
}

SCCP__param__Data__opt::SCCP__param__Data__opt(const INTEGER& par_paramName,
    const INTEGER& par_paramLength,
    const OCTETSTRING& par_data)
  :   field_paramName(par_paramName),
  field_paramLength(par_paramLength),
  field_data(par_data)
{
}

SCCP__param__Data__opt::SCCP__param__Data__opt(const SCCP__param__Data__opt& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_Data_opt.");
if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
else field_paramName.clean_up();
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
}

void SCCP__param__Data__opt::clean_up()
{
field_paramName.clean_up();
field_paramLength.clean_up();
field_data.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__Data__opt::get_descriptor() const { return &SCCP__param__Data__opt_descr_; }
SCCP__param__Data__opt& SCCP__param__Data__opt::operator=(const SCCP__param__Data__opt& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_Data_opt.");
  if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
  else field_paramName.clean_up();
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
}
return *this;
}

boolean SCCP__param__Data__opt::operator==(const SCCP__param__Data__opt& other_value) const
{
return field_paramName==other_value.field_paramName
  && field_paramLength==other_value.field_paramLength
  && field_data==other_value.field_data;
}

boolean SCCP__param__Data__opt::is_bound() const
{
return (field_paramName.is_bound())
  || (field_paramLength.is_bound())
  || (field_data.is_bound());
}
boolean SCCP__param__Data__opt::is_value() const
{
return field_paramName.is_value()
  && field_paramLength.is_value()
  && field_data.is_value();
}
void SCCP__param__Data__opt::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramName := ");
field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__Data__opt::set_implicit_omit()
{
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void SCCP__param__Data__opt::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_Data_opt has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Data_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_Data_opt");
  }
}

void SCCP__param__Data__opt::encode_text(Text_Buf& text_buf) const
{
field_paramName.encode_text(text_buf);
field_paramLength.encode_text(text_buf);
field_data.encode_text(text_buf);
}

void SCCP__param__Data__opt::decode_text(Text_Buf& text_buf)
{
field_paramName.decode_text(text_buf);
field_paramLength.decode_text(text_buf);
field_data.decode_text(text_buf);
}

void SCCP__param__Data__opt::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__Data__opt::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__Data__opt::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__field__ParameterName_descr_.raw->forceomit);
  decoded_field_length = field_paramName.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__Data__opt_paramLength_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(SCCP__param__Data__opt_paramLength_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_paramLength.convert_to_Integer(SCCP__param__Data__opt_paramLength_descr_);
  field_paramLength = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_data.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__Data__opt::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__field__ParameterName_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__Data__opt_paramLength_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCTN_descr_.raw);
  encoded_length += field_paramName.RAW_encode(SCCP__field__ParameterName_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &SCCP__param__Data__opt_paramLength_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_data.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__Data__opt_template::single_value_struct {
INTEGER_template field_paramName;
INTEGER_template field_paramLength;
OCTETSTRING_template field_data;
};

void SCCP__param__Data__opt_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramName = ANY_VALUE;
single_value->field_paramLength = ANY_VALUE;
single_value->field_data = ANY_VALUE;
}
}
}

void SCCP__param__Data__opt_template::copy_value(const SCCP__param__Data__opt& other_value)
{
single_value = new single_value_struct;
if (other_value.paramName().is_bound()) {
  single_value->field_paramName = other_value.paramName();
} else {
  single_value->field_paramName.clean_up();
}
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.data().is_bound()) {
  single_value->field_data = other_value.data();
} else {
  single_value->field_data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__Data__opt_template::copy_template(const SCCP__param__Data__opt_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramName().get_selection()) {
single_value->field_paramName = other_value.paramName();
} else {
single_value->field_paramName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__Data__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__Data__opt_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__Data__opt_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data_opt.");
break;
}
set_selection(other_value);
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template()
{
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template(const SCCP__param__Data__opt& other_value)
{
copy_value(other_value);
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template(const OPTIONAL<SCCP__param__Data__opt>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Data__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_Data_opt from an unbound optional field.");
}
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template(SCCP__param__Data__opt_template* p_precondition, SCCP__param__Data__opt_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template(Dynamic_Match_Interface<SCCP__param__Data__opt>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__Data__opt>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__Data__opt_template::SCCP__param__Data__opt_template(const SCCP__param__Data__opt_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__Data__opt_template::~SCCP__param__Data__opt_template()
{
clean_up();
}

SCCP__param__Data__opt_template& SCCP__param__Data__opt_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__Data__opt_template& SCCP__param__Data__opt_template::operator=(const SCCP__param__Data__opt& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__Data__opt_template& SCCP__param__Data__opt_template::operator=(const OPTIONAL<SCCP__param__Data__opt>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Data__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_Data_opt.");
}
return *this;
}

SCCP__param__Data__opt_template& SCCP__param__Data__opt_template::operator=(const SCCP__param__Data__opt_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__Data__opt_template::match(const SCCP__param__Data__opt& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramName().is_bound()) return FALSE;
if(!single_value->field_paramName.match(other_value.paramName(), legacy))return FALSE;
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if(!single_value->field_data.match(other_value.data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data_opt.");
}
return FALSE;
}

boolean SCCP__param__Data__opt_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramName.is_bound()
 || single_value->field_paramLength.is_bound()
 || single_value->field_data.is_bound();
}

boolean SCCP__param__Data__opt_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramName.is_value()
 && single_value->field_paramLength.is_value()
 && single_value->field_data.is_value();
}

void SCCP__param__Data__opt_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__Data__opt SCCP__param__Data__opt_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_Data_opt.");
SCCP__param__Data__opt ret_val;
if (single_value->field_paramName.is_bound()) {
ret_val.paramName() = single_value->field_paramName.valueof();
}
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
return ret_val;
}

void SCCP__param__Data__opt_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_Data_opt.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__Data__opt_template[list_length];
}

SCCP__param__Data__opt_template& SCCP__param__Data__opt_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_Data_opt.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_Data_opt.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__Data__opt_template::paramName()
{
set_specific();
return single_value->field_paramName;
}

const INTEGER_template& SCCP__param__Data__opt_template::paramName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramName of a non-specific template of type @SCCP_Types.SCCP_param_Data_opt.");
return single_value->field_paramName;
}

INTEGER_template& SCCP__param__Data__opt_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__Data__opt_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_Data_opt.");
return single_value->field_paramLength;
}

OCTETSTRING_template& SCCP__param__Data__opt_template::data()
{
set_specific();
return single_value->field_data;
}

const OCTETSTRING_template& SCCP__param__Data__opt_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_param_Data_opt.");
return single_value->field_data;
}

int SCCP__param__Data__opt_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Data_opt containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data_opt.");
  }
  return 0;
}

void SCCP__param__Data__opt_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__Data__opt_template::log_match(const SCCP__param__Data__opt& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramName.match(match_value.paramName(), legacy)){
TTCN_Logger::log_logmatch_info(".paramName");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__Data__opt_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void SCCP__param__Data__opt_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramName.encode_text(text_buf);
single_value->field_paramLength.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Data_opt.");
}
}

void SCCP__param__Data__opt_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramName.decode_text(text_buf);
single_value->field_paramLength.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__Data__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_Data_opt.");
}
}

void SCCP__param__Data__opt_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__Data__opt_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_Data_opt has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Data_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__Data__opt_template* precondition = new SCCP__param__Data__opt_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__Data__opt_template* implied_template = new SCCP__param__Data__opt_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__Data__opt_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_Data_opt");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__Data__opt_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramName.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Data_opt");
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Data_opt");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Data_opt");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_Data_opt");
}

boolean SCCP__param__Data__opt_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__Data__opt_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__Segmentation__opt::SCCP__param__Segmentation__opt()
{
}

SCCP__param__Segmentation__opt::SCCP__param__Segmentation__opt(const INTEGER& par_paramName,
    const INTEGER& par_paramLength,
    const BITSTRING& par_remainingSegment,
    const BITSTRING& par_reserved,
    const BITSTRING& par_class_,
    const BITSTRING& par_firstSegm,
    const OCTETSTRING& par_segmLocalRef)
  :   field_paramName(par_paramName),
  field_paramLength(par_paramLength),
  field_remainingSegment(par_remainingSegment),
  field_reserved(par_reserved),
  field_class_(par_class_),
  field_firstSegm(par_firstSegm),
  field_segmLocalRef(par_segmLocalRef)
{
}

SCCP__param__Segmentation__opt::SCCP__param__Segmentation__opt(const SCCP__param__Segmentation__opt& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_Segmentation_opt.");
if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
else field_paramName.clean_up();
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.remainingSegment().is_bound()) field_remainingSegment = other_value.remainingSegment();
else field_remainingSegment.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.class_().is_bound()) field_class_ = other_value.class_();
else field_class_.clean_up();
if (other_value.firstSegm().is_bound()) field_firstSegm = other_value.firstSegm();
else field_firstSegm.clean_up();
if (other_value.segmLocalRef().is_bound()) field_segmLocalRef = other_value.segmLocalRef();
else field_segmLocalRef.clean_up();
}

void SCCP__param__Segmentation__opt::clean_up()
{
field_paramName.clean_up();
field_paramLength.clean_up();
field_remainingSegment.clean_up();
field_reserved.clean_up();
field_class_.clean_up();
field_firstSegm.clean_up();
field_segmLocalRef.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__Segmentation__opt::get_descriptor() const { return &SCCP__param__Segmentation__opt_descr_; }
SCCP__param__Segmentation__opt& SCCP__param__Segmentation__opt::operator=(const SCCP__param__Segmentation__opt& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_Segmentation_opt.");
  if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
  else field_paramName.clean_up();
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.remainingSegment().is_bound()) field_remainingSegment = other_value.remainingSegment();
  else field_remainingSegment.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.class_().is_bound()) field_class_ = other_value.class_();
  else field_class_.clean_up();
  if (other_value.firstSegm().is_bound()) field_firstSegm = other_value.firstSegm();
  else field_firstSegm.clean_up();
  if (other_value.segmLocalRef().is_bound()) field_segmLocalRef = other_value.segmLocalRef();
  else field_segmLocalRef.clean_up();
}
return *this;
}

boolean SCCP__param__Segmentation__opt::operator==(const SCCP__param__Segmentation__opt& other_value) const
{
return field_paramName==other_value.field_paramName
  && field_paramLength==other_value.field_paramLength
  && field_remainingSegment==other_value.field_remainingSegment
  && field_reserved==other_value.field_reserved
  && field_class_==other_value.field_class_
  && field_firstSegm==other_value.field_firstSegm
  && field_segmLocalRef==other_value.field_segmLocalRef;
}

boolean SCCP__param__Segmentation__opt::is_bound() const
{
return (field_paramName.is_bound())
  || (field_paramLength.is_bound())
  || (field_remainingSegment.is_bound())
  || (field_reserved.is_bound())
  || (field_class_.is_bound())
  || (field_firstSegm.is_bound())
  || (field_segmLocalRef.is_bound());
}
boolean SCCP__param__Segmentation__opt::is_value() const
{
return field_paramName.is_value()
  && field_paramLength.is_value()
  && field_remainingSegment.is_value()
  && field_reserved.is_value()
  && field_class_.is_value()
  && field_firstSegm.is_value()
  && field_segmLocalRef.is_value();
}
void SCCP__param__Segmentation__opt::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramName := ");
field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", remainingSegment := ");
field_remainingSegment.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", class := ");
field_class_.log();
TTCN_Logger::log_event_str(", firstSegm := ");
field_firstSegm.log();
TTCN_Logger::log_event_str(", segmLocalRef := ");
field_segmLocalRef.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__Segmentation__opt::set_implicit_omit()
{
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (remainingSegment().is_bound()) remainingSegment().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (class_().is_bound()) class_().set_implicit_omit();
if (firstSegm().is_bound()) firstSegm().set_implicit_omit();
if (segmLocalRef().is_bound()) segmLocalRef().set_implicit_omit();
}

void SCCP__param__Segmentation__opt::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_Segmentation_opt has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) remainingSegment().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) class_().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) firstSegm().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) segmLocalRef().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remainingSegment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remainingSegment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "class")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          class_().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "firstSegm")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          firstSegm().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmLocalRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmLocalRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Segmentation_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_Segmentation_opt");
  }
}

void SCCP__param__Segmentation__opt::encode_text(Text_Buf& text_buf) const
{
field_paramName.encode_text(text_buf);
field_paramLength.encode_text(text_buf);
field_remainingSegment.encode_text(text_buf);
field_reserved.encode_text(text_buf);
field_class_.encode_text(text_buf);
field_firstSegm.encode_text(text_buf);
field_segmLocalRef.encode_text(text_buf);
}

void SCCP__param__Segmentation__opt::decode_text(Text_Buf& text_buf)
{
field_paramName.decode_text(text_buf);
field_paramLength.decode_text(text_buf);
field_remainingSegment.decode_text(text_buf);
field_reserved.decode_text(text_buf);
field_class_.decode_text(text_buf);
field_firstSegm.decode_text(text_buf);
field_segmLocalRef.decode_text(text_buf);
}

void SCCP__param__Segmentation__opt::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__Segmentation__opt::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__Segmentation__opt::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__field__ParameterName_descr_.raw->forceomit);
  decoded_field_length = field_paramName.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::LIN1_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(General__Types::LIN1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_remainingSegment.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_class_.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_firstSegm.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_segmLocalRef.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__Segmentation__opt::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__field__ParameterName_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::LIN1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, General__Types::OCT3_descr_.raw);
  encoded_length += field_paramName.RAW_encode(SCCP__field__ParameterName_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_paramLength.RAW_encode(General__Types::LIN1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_remainingSegment.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_class_.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_firstSegm.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_segmLocalRef.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[6]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__Segmentation__opt_template::single_value_struct {
INTEGER_template field_paramName;
INTEGER_template field_paramLength;
BITSTRING_template field_remainingSegment;
BITSTRING_template field_reserved;
BITSTRING_template field_class_;
BITSTRING_template field_firstSegm;
OCTETSTRING_template field_segmLocalRef;
};

void SCCP__param__Segmentation__opt_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramName = ANY_VALUE;
single_value->field_paramLength = ANY_VALUE;
single_value->field_remainingSegment = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
single_value->field_class_ = ANY_VALUE;
single_value->field_firstSegm = ANY_VALUE;
single_value->field_segmLocalRef = ANY_VALUE;
}
}
}

void SCCP__param__Segmentation__opt_template::copy_value(const SCCP__param__Segmentation__opt& other_value)
{
single_value = new single_value_struct;
if (other_value.paramName().is_bound()) {
  single_value->field_paramName = other_value.paramName();
} else {
  single_value->field_paramName.clean_up();
}
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.remainingSegment().is_bound()) {
  single_value->field_remainingSegment = other_value.remainingSegment();
} else {
  single_value->field_remainingSegment.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.class_().is_bound()) {
  single_value->field_class_ = other_value.class_();
} else {
  single_value->field_class_.clean_up();
}
if (other_value.firstSegm().is_bound()) {
  single_value->field_firstSegm = other_value.firstSegm();
} else {
  single_value->field_firstSegm.clean_up();
}
if (other_value.segmLocalRef().is_bound()) {
  single_value->field_segmLocalRef = other_value.segmLocalRef();
} else {
  single_value->field_segmLocalRef.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__Segmentation__opt_template::copy_template(const SCCP__param__Segmentation__opt_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramName().get_selection()) {
single_value->field_paramName = other_value.paramName();
} else {
single_value->field_paramName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.remainingSegment().get_selection()) {
single_value->field_remainingSegment = other_value.remainingSegment();
} else {
single_value->field_remainingSegment.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.class_().get_selection()) {
single_value->field_class_ = other_value.class_();
} else {
single_value->field_class_.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.firstSegm().get_selection()) {
single_value->field_firstSegm = other_value.firstSegm();
} else {
single_value->field_firstSegm.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.segmLocalRef().get_selection()) {
single_value->field_segmLocalRef = other_value.segmLocalRef();
} else {
single_value->field_segmLocalRef.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__Segmentation__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__Segmentation__opt_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__Segmentation__opt_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
break;
}
set_selection(other_value);
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template()
{
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template(const SCCP__param__Segmentation__opt& other_value)
{
copy_value(other_value);
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template(const OPTIONAL<SCCP__param__Segmentation__opt>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Segmentation__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_Segmentation_opt from an unbound optional field.");
}
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template(SCCP__param__Segmentation__opt_template* p_precondition, SCCP__param__Segmentation__opt_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template(Dynamic_Match_Interface<SCCP__param__Segmentation__opt>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__Segmentation__opt>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__Segmentation__opt_template::SCCP__param__Segmentation__opt_template(const SCCP__param__Segmentation__opt_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__Segmentation__opt_template::~SCCP__param__Segmentation__opt_template()
{
clean_up();
}

SCCP__param__Segmentation__opt_template& SCCP__param__Segmentation__opt_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__Segmentation__opt_template& SCCP__param__Segmentation__opt_template::operator=(const SCCP__param__Segmentation__opt& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__Segmentation__opt_template& SCCP__param__Segmentation__opt_template::operator=(const OPTIONAL<SCCP__param__Segmentation__opt>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Segmentation__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
}
return *this;
}

SCCP__param__Segmentation__opt_template& SCCP__param__Segmentation__opt_template::operator=(const SCCP__param__Segmentation__opt_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__Segmentation__opt_template::match(const SCCP__param__Segmentation__opt& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramName().is_bound()) return FALSE;
if(!single_value->field_paramName.match(other_value.paramName(), legacy))return FALSE;
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.remainingSegment().is_bound()) return FALSE;
if(!single_value->field_remainingSegment.match(other_value.remainingSegment(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.class_().is_bound()) return FALSE;
if(!single_value->field_class_.match(other_value.class_(), legacy))return FALSE;
if(!other_value.firstSegm().is_bound()) return FALSE;
if(!single_value->field_firstSegm.match(other_value.firstSegm(), legacy))return FALSE;
if(!other_value.segmLocalRef().is_bound()) return FALSE;
if(!single_value->field_segmLocalRef.match(other_value.segmLocalRef(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
}
return FALSE;
}

boolean SCCP__param__Segmentation__opt_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramName.is_bound()
 || single_value->field_paramLength.is_bound()
 || single_value->field_remainingSegment.is_bound()
 || single_value->field_reserved.is_bound()
 || single_value->field_class_.is_bound()
 || single_value->field_firstSegm.is_bound()
 || single_value->field_segmLocalRef.is_bound();
}

boolean SCCP__param__Segmentation__opt_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramName.is_value()
 && single_value->field_paramLength.is_value()
 && single_value->field_remainingSegment.is_value()
 && single_value->field_reserved.is_value()
 && single_value->field_class_.is_value()
 && single_value->field_firstSegm.is_value()
 && single_value->field_segmLocalRef.is_value();
}

void SCCP__param__Segmentation__opt_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__Segmentation__opt SCCP__param__Segmentation__opt_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
SCCP__param__Segmentation__opt ret_val;
if (single_value->field_paramName.is_bound()) {
ret_val.paramName() = single_value->field_paramName.valueof();
}
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_remainingSegment.is_bound()) {
ret_val.remainingSegment() = single_value->field_remainingSegment.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_class_.is_bound()) {
ret_val.class_() = single_value->field_class_.valueof();
}
if (single_value->field_firstSegm.is_bound()) {
ret_val.firstSegm() = single_value->field_firstSegm.valueof();
}
if (single_value->field_segmLocalRef.is_bound()) {
ret_val.segmLocalRef() = single_value->field_segmLocalRef.valueof();
}
return ret_val;
}

void SCCP__param__Segmentation__opt_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__Segmentation__opt_template[list_length];
}

SCCP__param__Segmentation__opt_template& SCCP__param__Segmentation__opt_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__Segmentation__opt_template::paramName()
{
set_specific();
return single_value->field_paramName;
}

const INTEGER_template& SCCP__param__Segmentation__opt_template::paramName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramName of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_paramName;
}

INTEGER_template& SCCP__param__Segmentation__opt_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__Segmentation__opt_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_paramLength;
}

BITSTRING_template& SCCP__param__Segmentation__opt_template::remainingSegment()
{
set_specific();
return single_value->field_remainingSegment;
}

const BITSTRING_template& SCCP__param__Segmentation__opt_template::remainingSegment() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field remainingSegment of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_remainingSegment;
}

BITSTRING_template& SCCP__param__Segmentation__opt_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& SCCP__param__Segmentation__opt_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_reserved;
}

BITSTRING_template& SCCP__param__Segmentation__opt_template::class_()
{
set_specific();
return single_value->field_class_;
}

const BITSTRING_template& SCCP__param__Segmentation__opt_template::class_() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field class of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_class_;
}

BITSTRING_template& SCCP__param__Segmentation__opt_template::firstSegm()
{
set_specific();
return single_value->field_firstSegm;
}

const BITSTRING_template& SCCP__param__Segmentation__opt_template::firstSegm() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field firstSegm of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_firstSegm;
}

OCTETSTRING_template& SCCP__param__Segmentation__opt_template::segmLocalRef()
{
set_specific();
return single_value->field_segmLocalRef;
}

const OCTETSTRING_template& SCCP__param__Segmentation__opt_template::segmLocalRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field segmLocalRef of a non-specific template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
return single_value->field_segmLocalRef;
}

int SCCP__param__Segmentation__opt_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 7;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Segmentation_opt containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
  }
  return 0;
}

void SCCP__param__Segmentation__opt_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", remainingSegment := ");
single_value->field_remainingSegment.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", class := ");
single_value->field_class_.log();
TTCN_Logger::log_event_str(", firstSegm := ");
single_value->field_firstSegm.log();
TTCN_Logger::log_event_str(", segmLocalRef := ");
single_value->field_segmLocalRef.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__Segmentation__opt_template::log_match(const SCCP__param__Segmentation__opt& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramName.match(match_value.paramName(), legacy)){
TTCN_Logger::log_logmatch_info(".paramName");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_remainingSegment.match(match_value.remainingSegment(), legacy)){
TTCN_Logger::log_logmatch_info(".remainingSegment");
single_value->field_remainingSegment.log_match(match_value.remainingSegment(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_class_.match(match_value.class_(), legacy)){
TTCN_Logger::log_logmatch_info(".class");
single_value->field_class_.log_match(match_value.class_(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_firstSegm.match(match_value.firstSegm(), legacy)){
TTCN_Logger::log_logmatch_info(".firstSegm");
single_value->field_firstSegm.log_match(match_value.firstSegm(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_segmLocalRef.match(match_value.segmLocalRef(), legacy)){
TTCN_Logger::log_logmatch_info(".segmLocalRef");
single_value->field_segmLocalRef.log_match(match_value.segmLocalRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", remainingSegment := ");
single_value->field_remainingSegment.log_match(match_value.remainingSegment(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", class := ");
single_value->field_class_.log_match(match_value.class_(), legacy);
TTCN_Logger::log_event_str(", firstSegm := ");
single_value->field_firstSegm.log_match(match_value.firstSegm(), legacy);
TTCN_Logger::log_event_str(", segmLocalRef := ");
single_value->field_segmLocalRef.log_match(match_value.segmLocalRef(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__Segmentation__opt_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (remainingSegment().is_bound()) remainingSegment().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
if (class_().is_bound()) class_().set_implicit_omit();
if (firstSegm().is_bound()) firstSegm().set_implicit_omit();
if (segmLocalRef().is_bound()) segmLocalRef().set_implicit_omit();
}

void SCCP__param__Segmentation__opt_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramName.encode_text(text_buf);
single_value->field_paramLength.encode_text(text_buf);
single_value->field_remainingSegment.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
single_value->field_class_.encode_text(text_buf);
single_value->field_firstSegm.encode_text(text_buf);
single_value->field_segmLocalRef.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
}
}

void SCCP__param__Segmentation__opt_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramName.decode_text(text_buf);
single_value->field_paramLength.decode_text(text_buf);
single_value->field_remainingSegment.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
single_value->field_class_.decode_text(text_buf);
single_value->field_firstSegm.decode_text(text_buf);
single_value->field_segmLocalRef.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__Segmentation__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_Segmentation_opt.");
}
}

void SCCP__param__Segmentation__opt_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__Segmentation__opt_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_Segmentation_opt has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) remainingSegment().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) class_().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) firstSegm().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) segmLocalRef().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "remainingSegment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          remainingSegment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "class")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          class_().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "firstSegm")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          firstSegm().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmLocalRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmLocalRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Segmentation_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__Segmentation__opt_template* precondition = new SCCP__param__Segmentation__opt_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__Segmentation__opt_template* implied_template = new SCCP__param__Segmentation__opt_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__Segmentation__opt_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_Segmentation_opt");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__Segmentation__opt_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramName.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
single_value->field_remainingSegment.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
single_value->field_class_.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
single_value->field_firstSegm.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
single_value->field_segmLocalRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_Segmentation_opt");
}

boolean SCCP__param__Segmentation__opt_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__Segmentation__opt_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__HopCounter__opt::SCCP__param__HopCounter__opt()
{
}

SCCP__param__HopCounter__opt::SCCP__param__HopCounter__opt(const INTEGER& par_paramName,
    const INTEGER& par_paramLength,
    const INTEGER& par_counter)
  :   field_paramName(par_paramName),
  field_paramLength(par_paramLength),
  field_counter(par_counter)
{
}

SCCP__param__HopCounter__opt::SCCP__param__HopCounter__opt(const SCCP__param__HopCounter__opt& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_HopCounter_opt.");
if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
else field_paramName.clean_up();
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.counter().is_bound()) field_counter = other_value.counter();
else field_counter.clean_up();
}

void SCCP__param__HopCounter__opt::clean_up()
{
field_paramName.clean_up();
field_paramLength.clean_up();
field_counter.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__HopCounter__opt::get_descriptor() const { return &SCCP__param__HopCounter__opt_descr_; }
SCCP__param__HopCounter__opt& SCCP__param__HopCounter__opt::operator=(const SCCP__param__HopCounter__opt& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_HopCounter_opt.");
  if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
  else field_paramName.clean_up();
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.counter().is_bound()) field_counter = other_value.counter();
  else field_counter.clean_up();
}
return *this;
}

boolean SCCP__param__HopCounter__opt::operator==(const SCCP__param__HopCounter__opt& other_value) const
{
return field_paramName==other_value.field_paramName
  && field_paramLength==other_value.field_paramLength
  && field_counter==other_value.field_counter;
}

boolean SCCP__param__HopCounter__opt::is_bound() const
{
return (field_paramName.is_bound())
  || (field_paramLength.is_bound())
  || (field_counter.is_bound());
}
boolean SCCP__param__HopCounter__opt::is_value() const
{
return field_paramName.is_value()
  && field_paramLength.is_value()
  && field_counter.is_value();
}
void SCCP__param__HopCounter__opt::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramName := ");
field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", counter := ");
field_counter.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__HopCounter__opt::set_implicit_omit()
{
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (counter().is_bound()) counter().set_implicit_omit();
}

void SCCP__param__HopCounter__opt::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_HopCounter_opt has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) counter().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "counter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          counter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_HopCounter_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_HopCounter_opt");
  }
}

void SCCP__param__HopCounter__opt::encode_text(Text_Buf& text_buf) const
{
field_paramName.encode_text(text_buf);
field_paramLength.encode_text(text_buf);
field_counter.encode_text(text_buf);
}

void SCCP__param__HopCounter__opt::decode_text(Text_Buf& text_buf)
{
field_paramName.decode_text(text_buf);
field_paramLength.decode_text(text_buf);
field_counter.decode_text(text_buf);
}

void SCCP__param__HopCounter__opt::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__HopCounter__opt::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__HopCounter__opt::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__field__ParameterName_descr_.raw->forceomit);
  decoded_field_length = field_paramName.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__HopCounter__opt_paramLength_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(SCCP__param__HopCounter__opt_paramLength_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_paramLength.convert_to_Integer(SCCP__param__HopCounter__opt_paramLength_descr_);
  field_paramLength = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__HopCounter_descr_.raw->forceomit);
  decoded_field_length = field_counter.RAW_decode(SCCP__param__HopCounter_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__HopCounter__opt::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__field__ParameterName_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__HopCounter__opt_paramLength_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__HopCounter_descr_.raw);
  encoded_length += field_paramName.RAW_encode(SCCP__field__ParameterName_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &SCCP__param__HopCounter__opt_paramLength_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_counter.RAW_encode(SCCP__param__HopCounter_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__HopCounter__opt_template::single_value_struct {
INTEGER_template field_paramName;
INTEGER_template field_paramLength;
INTEGER_template field_counter;
};

void SCCP__param__HopCounter__opt_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramName = ANY_VALUE;
single_value->field_paramLength = ANY_VALUE;
single_value->field_counter = ANY_VALUE;
}
}
}

void SCCP__param__HopCounter__opt_template::copy_value(const SCCP__param__HopCounter__opt& other_value)
{
single_value = new single_value_struct;
if (other_value.paramName().is_bound()) {
  single_value->field_paramName = other_value.paramName();
} else {
  single_value->field_paramName.clean_up();
}
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.counter().is_bound()) {
  single_value->field_counter = other_value.counter();
} else {
  single_value->field_counter.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__HopCounter__opt_template::copy_template(const SCCP__param__HopCounter__opt_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramName().get_selection()) {
single_value->field_paramName = other_value.paramName();
} else {
single_value->field_paramName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.counter().get_selection()) {
single_value->field_counter = other_value.counter();
} else {
single_value->field_counter.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__HopCounter__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__HopCounter__opt_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__HopCounter__opt_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
break;
}
set_selection(other_value);
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template()
{
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template(const SCCP__param__HopCounter__opt& other_value)
{
copy_value(other_value);
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template(const OPTIONAL<SCCP__param__HopCounter__opt>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__HopCounter__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_HopCounter_opt from an unbound optional field.");
}
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template(SCCP__param__HopCounter__opt_template* p_precondition, SCCP__param__HopCounter__opt_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template(Dynamic_Match_Interface<SCCP__param__HopCounter__opt>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__HopCounter__opt>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__HopCounter__opt_template::SCCP__param__HopCounter__opt_template(const SCCP__param__HopCounter__opt_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__HopCounter__opt_template::~SCCP__param__HopCounter__opt_template()
{
clean_up();
}

SCCP__param__HopCounter__opt_template& SCCP__param__HopCounter__opt_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__HopCounter__opt_template& SCCP__param__HopCounter__opt_template::operator=(const SCCP__param__HopCounter__opt& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__HopCounter__opt_template& SCCP__param__HopCounter__opt_template::operator=(const OPTIONAL<SCCP__param__HopCounter__opt>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__HopCounter__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
}
return *this;
}

SCCP__param__HopCounter__opt_template& SCCP__param__HopCounter__opt_template::operator=(const SCCP__param__HopCounter__opt_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__HopCounter__opt_template::match(const SCCP__param__HopCounter__opt& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramName().is_bound()) return FALSE;
if(!single_value->field_paramName.match(other_value.paramName(), legacy))return FALSE;
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.counter().is_bound()) return FALSE;
if(!single_value->field_counter.match(other_value.counter(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
}
return FALSE;
}

boolean SCCP__param__HopCounter__opt_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramName.is_bound()
 || single_value->field_paramLength.is_bound()
 || single_value->field_counter.is_bound();
}

boolean SCCP__param__HopCounter__opt_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramName.is_value()
 && single_value->field_paramLength.is_value()
 && single_value->field_counter.is_value();
}

void SCCP__param__HopCounter__opt_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__HopCounter__opt SCCP__param__HopCounter__opt_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
SCCP__param__HopCounter__opt ret_val;
if (single_value->field_paramName.is_bound()) {
ret_val.paramName() = single_value->field_paramName.valueof();
}
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_counter.is_bound()) {
ret_val.counter() = single_value->field_counter.valueof();
}
return ret_val;
}

void SCCP__param__HopCounter__opt_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__HopCounter__opt_template[list_length];
}

SCCP__param__HopCounter__opt_template& SCCP__param__HopCounter__opt_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__HopCounter__opt_template::paramName()
{
set_specific();
return single_value->field_paramName;
}

const INTEGER_template& SCCP__param__HopCounter__opt_template::paramName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramName of a non-specific template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
return single_value->field_paramName;
}

INTEGER_template& SCCP__param__HopCounter__opt_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__HopCounter__opt_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
return single_value->field_paramLength;
}

INTEGER_template& SCCP__param__HopCounter__opt_template::counter()
{
set_specific();
return single_value->field_counter;
}

const INTEGER_template& SCCP__param__HopCounter__opt_template::counter() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field counter of a non-specific template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
return single_value->field_counter;
}

int SCCP__param__HopCounter__opt_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_HopCounter_opt containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
  }
  return 0;
}

void SCCP__param__HopCounter__opt_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", counter := ");
single_value->field_counter.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__HopCounter__opt_template::log_match(const SCCP__param__HopCounter__opt& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramName.match(match_value.paramName(), legacy)){
TTCN_Logger::log_logmatch_info(".paramName");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_counter.match(match_value.counter(), legacy)){
TTCN_Logger::log_logmatch_info(".counter");
single_value->field_counter.log_match(match_value.counter(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", counter := ");
single_value->field_counter.log_match(match_value.counter(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__HopCounter__opt_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (counter().is_bound()) counter().set_implicit_omit();
}

void SCCP__param__HopCounter__opt_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramName.encode_text(text_buf);
single_value->field_paramLength.encode_text(text_buf);
single_value->field_counter.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
}
}

void SCCP__param__HopCounter__opt_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramName.decode_text(text_buf);
single_value->field_paramLength.decode_text(text_buf);
single_value->field_counter.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__HopCounter__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_HopCounter_opt.");
}
}

void SCCP__param__HopCounter__opt_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__HopCounter__opt_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_HopCounter_opt has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) counter().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "counter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          counter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_HopCounter_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__HopCounter__opt_template* precondition = new SCCP__param__HopCounter__opt_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__HopCounter__opt_template* implied_template = new SCCP__param__HopCounter__opt_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__HopCounter__opt_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_HopCounter_opt");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__HopCounter__opt_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramName.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_HopCounter_opt");
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_HopCounter_opt");
single_value->field_counter.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_HopCounter_opt");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_HopCounter_opt");
}

boolean SCCP__param__HopCounter__opt_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__HopCounter__opt_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__Importance__opt::SCCP__param__Importance__opt()
{
}

SCCP__param__Importance__opt::SCCP__param__Importance__opt(const INTEGER& par_paramName,
    const INTEGER& par_paramLength,
    const INTEGER& par_importance,
    const BITSTRING& par_reserved)
  :   field_paramName(par_paramName),
  field_paramLength(par_paramLength),
  field_importance(par_importance),
  field_reserved(par_reserved)
{
}

SCCP__param__Importance__opt::SCCP__param__Importance__opt(const SCCP__param__Importance__opt& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_Importance_opt.");
if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
else field_paramName.clean_up();
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.importance().is_bound()) field_importance = other_value.importance();
else field_importance.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
}

void SCCP__param__Importance__opt::clean_up()
{
field_paramName.clean_up();
field_paramLength.clean_up();
field_importance.clean_up();
field_reserved.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__Importance__opt::get_descriptor() const { return &SCCP__param__Importance__opt_descr_; }
SCCP__param__Importance__opt& SCCP__param__Importance__opt::operator=(const SCCP__param__Importance__opt& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_Importance_opt.");
  if (other_value.paramName().is_bound()) field_paramName = other_value.paramName();
  else field_paramName.clean_up();
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.importance().is_bound()) field_importance = other_value.importance();
  else field_importance.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
}
return *this;
}

boolean SCCP__param__Importance__opt::operator==(const SCCP__param__Importance__opt& other_value) const
{
return field_paramName==other_value.field_paramName
  && field_paramLength==other_value.field_paramLength
  && field_importance==other_value.field_importance
  && field_reserved==other_value.field_reserved;
}

boolean SCCP__param__Importance__opt::is_bound() const
{
return (field_paramName.is_bound())
  || (field_paramLength.is_bound())
  || (field_importance.is_bound())
  || (field_reserved.is_bound());
}
boolean SCCP__param__Importance__opt::is_value() const
{
return field_paramName.is_value()
  && field_paramLength.is_value()
  && field_importance.is_value()
  && field_reserved.is_value();
}
void SCCP__param__Importance__opt::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramName := ");
field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", importance := ");
field_importance.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__Importance__opt::set_implicit_omit()
{
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (importance().is_bound()) importance().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void SCCP__param__Importance__opt::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_Importance_opt has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Importance_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_Importance_opt");
  }
}

void SCCP__param__Importance__opt::encode_text(Text_Buf& text_buf) const
{
field_paramName.encode_text(text_buf);
field_paramLength.encode_text(text_buf);
field_importance.encode_text(text_buf);
field_reserved.encode_text(text_buf);
}

void SCCP__param__Importance__opt::decode_text(Text_Buf& text_buf)
{
field_paramName.decode_text(text_buf);
field_paramLength.decode_text(text_buf);
field_importance.decode_text(text_buf);
field_reserved.decode_text(text_buf);
}

void SCCP__param__Importance__opt::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__Importance__opt::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__Importance__opt::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__field__ParameterName_descr_.raw->forceomit);
  decoded_field_length = field_paramName.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::LIN1_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(General__Types::LIN1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__field__Importance_descr_.raw->forceomit);
  decoded_field_length = field_importance.RAW_decode(SCCP__field__Importance_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT5_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__Importance__opt::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__field__ParameterName_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::LIN1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__field__Importance_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT5_descr_.raw);
  encoded_length += field_paramName.RAW_encode(SCCP__field__ParameterName_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_paramLength.RAW_encode(General__Types::LIN1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_importance.RAW_encode(SCCP__field__Importance_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__Importance__opt_template::single_value_struct {
INTEGER_template field_paramName;
INTEGER_template field_paramLength;
INTEGER_template field_importance;
BITSTRING_template field_reserved;
};

void SCCP__param__Importance__opt_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramName = ANY_VALUE;
single_value->field_paramLength = ANY_VALUE;
single_value->field_importance = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
}
}
}

void SCCP__param__Importance__opt_template::copy_value(const SCCP__param__Importance__opt& other_value)
{
single_value = new single_value_struct;
if (other_value.paramName().is_bound()) {
  single_value->field_paramName = other_value.paramName();
} else {
  single_value->field_paramName.clean_up();
}
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.importance().is_bound()) {
  single_value->field_importance = other_value.importance();
} else {
  single_value->field_importance.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__Importance__opt_template::copy_template(const SCCP__param__Importance__opt_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramName().get_selection()) {
single_value->field_paramName = other_value.paramName();
} else {
single_value->field_paramName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.importance().get_selection()) {
single_value->field_importance = other_value.importance();
} else {
single_value->field_importance.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__Importance__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__Importance__opt_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__Importance__opt_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Importance_opt.");
break;
}
set_selection(other_value);
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template()
{
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template(const SCCP__param__Importance__opt& other_value)
{
copy_value(other_value);
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template(const OPTIONAL<SCCP__param__Importance__opt>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Importance__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_Importance_opt from an unbound optional field.");
}
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template(SCCP__param__Importance__opt_template* p_precondition, SCCP__param__Importance__opt_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template(Dynamic_Match_Interface<SCCP__param__Importance__opt>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__Importance__opt>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__Importance__opt_template::SCCP__param__Importance__opt_template(const SCCP__param__Importance__opt_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__Importance__opt_template::~SCCP__param__Importance__opt_template()
{
clean_up();
}

SCCP__param__Importance__opt_template& SCCP__param__Importance__opt_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__Importance__opt_template& SCCP__param__Importance__opt_template::operator=(const SCCP__param__Importance__opt& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__Importance__opt_template& SCCP__param__Importance__opt_template::operator=(const OPTIONAL<SCCP__param__Importance__opt>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__Importance__opt&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_Importance_opt.");
}
return *this;
}

SCCP__param__Importance__opt_template& SCCP__param__Importance__opt_template::operator=(const SCCP__param__Importance__opt_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__Importance__opt_template::match(const SCCP__param__Importance__opt& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramName().is_bound()) return FALSE;
if(!single_value->field_paramName.match(other_value.paramName(), legacy))return FALSE;
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.importance().is_bound()) return FALSE;
if(!single_value->field_importance.match(other_value.importance(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Importance_opt.");
}
return FALSE;
}

boolean SCCP__param__Importance__opt_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramName.is_bound()
 || single_value->field_paramLength.is_bound()
 || single_value->field_importance.is_bound()
 || single_value->field_reserved.is_bound();
}

boolean SCCP__param__Importance__opt_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramName.is_value()
 && single_value->field_paramLength.is_value()
 && single_value->field_importance.is_value()
 && single_value->field_reserved.is_value();
}

void SCCP__param__Importance__opt_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__Importance__opt SCCP__param__Importance__opt_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_Importance_opt.");
SCCP__param__Importance__opt ret_val;
if (single_value->field_paramName.is_bound()) {
ret_val.paramName() = single_value->field_paramName.valueof();
}
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_importance.is_bound()) {
ret_val.importance() = single_value->field_importance.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
return ret_val;
}

void SCCP__param__Importance__opt_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_Importance_opt.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__Importance__opt_template[list_length];
}

SCCP__param__Importance__opt_template& SCCP__param__Importance__opt_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_Importance_opt.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_Importance_opt.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__Importance__opt_template::paramName()
{
set_specific();
return single_value->field_paramName;
}

const INTEGER_template& SCCP__param__Importance__opt_template::paramName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramName of a non-specific template of type @SCCP_Types.SCCP_param_Importance_opt.");
return single_value->field_paramName;
}

INTEGER_template& SCCP__param__Importance__opt_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__Importance__opt_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_Importance_opt.");
return single_value->field_paramLength;
}

INTEGER_template& SCCP__param__Importance__opt_template::importance()
{
set_specific();
return single_value->field_importance;
}

const INTEGER_template& SCCP__param__Importance__opt_template::importance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field importance of a non-specific template of type @SCCP_Types.SCCP_param_Importance_opt.");
return single_value->field_importance;
}

BITSTRING_template& SCCP__param__Importance__opt_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& SCCP__param__Importance__opt_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @SCCP_Types.SCCP_param_Importance_opt.");
return single_value->field_reserved;
}

int SCCP__param__Importance__opt_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_Importance_opt containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Importance_opt.");
  }
  return 0;
}

void SCCP__param__Importance__opt_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log();
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", importance := ");
single_value->field_importance.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__Importance__opt_template::log_match(const SCCP__param__Importance__opt& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramName.match(match_value.paramName(), legacy)){
TTCN_Logger::log_logmatch_info(".paramName");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_importance.match(match_value.importance(), legacy)){
TTCN_Logger::log_logmatch_info(".importance");
single_value->field_importance.log_match(match_value.importance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramName := ");
single_value->field_paramName.log_match(match_value.paramName(), legacy);
TTCN_Logger::log_event_str(", paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", importance := ");
single_value->field_importance.log_match(match_value.importance(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__Importance__opt_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramName().is_bound()) paramName().set_implicit_omit();
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (importance().is_bound()) importance().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void SCCP__param__Importance__opt_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramName.encode_text(text_buf);
single_value->field_paramLength.encode_text(text_buf);
single_value->field_importance.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_Importance_opt.");
}
}

void SCCP__param__Importance__opt_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramName.decode_text(text_buf);
single_value->field_paramLength.decode_text(text_buf);
single_value->field_importance.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__Importance__opt_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_Importance_opt.");
}
}

void SCCP__param__Importance__opt_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__Importance__opt_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_Importance_opt has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramName().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_Importance_opt: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__Importance__opt_template* precondition = new SCCP__param__Importance__opt_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__Importance__opt_template* implied_template = new SCCP__param__Importance__opt_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__Importance__opt_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_Importance_opt");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__Importance__opt_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramName.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Importance_opt");
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Importance_opt");
single_value->field_importance.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Importance_opt");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_Importance_opt");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_Importance_opt");
}

boolean SCCP__param__Importance__opt_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__Importance__opt_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__param__LongData::SCCP__param__LongData()
{
}

SCCP__param__LongData::SCCP__param__LongData(const INTEGER& par_paramLength,
    const OCTETSTRING& par_data)
  :   field_paramLength(par_paramLength),
  field_data(par_data)
{
}

SCCP__param__LongData::SCCP__param__LongData(const SCCP__param__LongData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_param_LongData.");
if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
else field_paramLength.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
}

void SCCP__param__LongData::clean_up()
{
field_paramLength.clean_up();
field_data.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__param__LongData::get_descriptor() const { return &SCCP__param__LongData_descr_; }
SCCP__param__LongData& SCCP__param__LongData::operator=(const SCCP__param__LongData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_param_LongData.");
  if (other_value.paramLength().is_bound()) field_paramLength = other_value.paramLength();
  else field_paramLength.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
}
return *this;
}

boolean SCCP__param__LongData::operator==(const SCCP__param__LongData& other_value) const
{
return field_paramLength==other_value.field_paramLength
  && field_data==other_value.field_data;
}

boolean SCCP__param__LongData::is_bound() const
{
return (field_paramLength.is_bound())
  || (field_data.is_bound());
}
boolean SCCP__param__LongData::is_value() const
{
return field_paramLength.is_value()
  && field_data.is_value();
}
void SCCP__param__LongData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ paramLength := ");
field_paramLength.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__param__LongData::set_implicit_omit()
{
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void SCCP__param__LongData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCCP_param_LongData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_LongData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCCP_param_LongData");
  }
}

void SCCP__param__LongData::encode_text(Text_Buf& text_buf) const
{
field_paramLength.encode_text(text_buf);
field_data.encode_text(text_buf);
}

void SCCP__param__LongData::decode_text(Text_Buf& text_buf)
{
field_paramLength.decode_text(text_buf);
field_data.decode_text(text_buf);
}

void SCCP__param__LongData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__param__LongData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__param__LongData::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__LongData_paramLength_descr_.raw->forceomit);
  decoded_field_length = field_paramLength.RAW_decode(SCCP__param__LongData_paramLength_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_paramLength.convert_to_Integer(SCCP__param__LongData_paramLength_descr_);
  field_paramLength = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_data.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__param__LongData::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__LongData_paramLength_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCTN_descr_.raw);
  encoded_length += 16;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &SCCP__param__LongData_paramLength_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 16;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_data.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SCCP__param__LongData_template::single_value_struct {
INTEGER_template field_paramLength;
OCTETSTRING_template field_data;
};

void SCCP__param__LongData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_paramLength = ANY_VALUE;
single_value->field_data = ANY_VALUE;
}
}
}

void SCCP__param__LongData_template::copy_value(const SCCP__param__LongData& other_value)
{
single_value = new single_value_struct;
if (other_value.paramLength().is_bound()) {
  single_value->field_paramLength = other_value.paramLength();
} else {
  single_value->field_paramLength.clean_up();
}
if (other_value.data().is_bound()) {
  single_value->field_data = other_value.data();
} else {
  single_value->field_data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__param__LongData_template::copy_template(const SCCP__param__LongData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.paramLength().get_selection()) {
single_value->field_paramLength = other_value.paramLength();
} else {
single_value->field_paramLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__param__LongData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__param__LongData_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__param__LongData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_LongData.");
break;
}
set_selection(other_value);
}

SCCP__param__LongData_template::SCCP__param__LongData_template()
{
}

SCCP__param__LongData_template::SCCP__param__LongData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__param__LongData_template::SCCP__param__LongData_template(const SCCP__param__LongData& other_value)
{
copy_value(other_value);
}

SCCP__param__LongData_template::SCCP__param__LongData_template(const OPTIONAL<SCCP__param__LongData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__LongData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_param_LongData from an unbound optional field.");
}
}

SCCP__param__LongData_template::SCCP__param__LongData_template(SCCP__param__LongData_template* p_precondition, SCCP__param__LongData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__param__LongData_template::SCCP__param__LongData_template(Dynamic_Match_Interface<SCCP__param__LongData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__param__LongData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__param__LongData_template::SCCP__param__LongData_template(const SCCP__param__LongData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__param__LongData_template::~SCCP__param__LongData_template()
{
clean_up();
}

SCCP__param__LongData_template& SCCP__param__LongData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__param__LongData_template& SCCP__param__LongData_template::operator=(const SCCP__param__LongData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__param__LongData_template& SCCP__param__LongData_template::operator=(const OPTIONAL<SCCP__param__LongData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__param__LongData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_param_LongData.");
}
return *this;
}

SCCP__param__LongData_template& SCCP__param__LongData_template::operator=(const SCCP__param__LongData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__param__LongData_template::match(const SCCP__param__LongData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.paramLength().is_bound()) return FALSE;
if(!single_value->field_paramLength.match(other_value.paramLength(), legacy))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if(!single_value->field_data.match(other_value.data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_LongData.");
}
return FALSE;
}

boolean SCCP__param__LongData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_paramLength.is_bound()
 || single_value->field_data.is_bound();
}

boolean SCCP__param__LongData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_paramLength.is_value()
 && single_value->field_data.is_value();
}

void SCCP__param__LongData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__param__LongData SCCP__param__LongData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_param_LongData.");
SCCP__param__LongData ret_val;
if (single_value->field_paramLength.is_bound()) {
ret_val.paramLength() = single_value->field_paramLength.valueof();
}
if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
return ret_val;
}

void SCCP__param__LongData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_param_LongData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__param__LongData_template[list_length];
}

SCCP__param__LongData_template& SCCP__param__LongData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_param_LongData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_param_LongData.");
return value_list.list_value[list_index];
}

INTEGER_template& SCCP__param__LongData_template::paramLength()
{
set_specific();
return single_value->field_paramLength;
}

const INTEGER_template& SCCP__param__LongData_template::paramLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field paramLength of a non-specific template of type @SCCP_Types.SCCP_param_LongData.");
return single_value->field_paramLength;
}

OCTETSTRING_template& SCCP__param__LongData_template::data()
{
set_specific();
return single_value->field_data;
}

const OCTETSTRING_template& SCCP__param__LongData_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_param_LongData.");
return single_value->field_data;
}

int SCCP__param__LongData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_param_LongData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_LongData.");
  }
  return 0;
}

void SCCP__param__LongData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ paramLength := ");
single_value->field_paramLength.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__param__LongData_template::log_match(const SCCP__param__LongData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_paramLength.match(match_value.paramLength(), legacy)){
TTCN_Logger::log_logmatch_info(".paramLength");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ paramLength := ");
single_value->field_paramLength.log_match(match_value.paramLength(), legacy);
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__param__LongData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (paramLength().is_bound()) paramLength().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void SCCP__param__LongData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_paramLength.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_param_LongData.");
}
}

void SCCP__param__LongData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_paramLength.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__param__LongData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_param_LongData.");
}
}

void SCCP__param__LongData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__param__LongData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCCP_param_LongData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) paramLength().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "paramLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          paramLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_param_LongData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__param__LongData_template* precondition = new SCCP__param__LongData_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__param__LongData_template* implied_template = new SCCP__param__LongData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__param__LongData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCCP_param_LongData");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__param__LongData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_paramLength.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_LongData");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_param_LongData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_param_LongData");
}

boolean SCCP__param__LongData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__param__LongData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCMG__param__FormatId::SCMG__param__FormatId()
{
enum_value = UNBOUND_VALUE;
}

SCMG__param__FormatId::SCMG__param__FormatId(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @SCCP_Types.SCMG_param_FormatId with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

SCMG__param__FormatId::SCMG__param__FormatId(enum_type other_value)
{
enum_value = other_value;
}

SCMG__param__FormatId::SCMG__param__FormatId(const SCMG__param__FormatId& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
enum_value = other_value.enum_value;
}

SCMG__param__FormatId& SCMG__param__FormatId::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @SCCP_Types.SCMG_param_FormatId.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

SCMG__param__FormatId& SCMG__param__FormatId::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

SCMG__param__FormatId& SCMG__param__FormatId::operator=(const SCMG__param__FormatId& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
enum_value = other_value.enum_value;
return *this;
}

boolean SCMG__param__FormatId::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @SCCP_Types.SCMG_param_FormatId comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean SCMG__param__FormatId::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value == other_value;
}

boolean SCMG__param__FormatId::operator==(const SCMG__param__FormatId& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value == other_value.enum_value;
}

boolean SCMG__param__FormatId::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @SCCP_Types.SCMG_param_FormatId comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean SCMG__param__FormatId::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value < other_value;
}

boolean SCMG__param__FormatId::operator<(const SCMG__param__FormatId& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value < other_value.enum_value;
}

boolean SCMG__param__FormatId::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @SCCP_Types.SCMG_param_FormatId comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean SCMG__param__FormatId::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value > other_value;
}

boolean SCMG__param__FormatId::operator>(const SCMG__param__FormatId& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value > other_value.enum_value;
}

const char *SCMG__param__FormatId::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case sSAallowed: return "sSAallowed";
case sSPprohib: return "sSPprohib";
case sSTstaTest: return "sSTstaTest";
case sORoutReq: return "sORoutReq";
case sORoutGrant: return "sORoutGrant";
case sSCcongest: return "sSCcongest";
default:
return "<unknown>";
}
}

SCMG__param__FormatId::enum_type SCMG__param__FormatId::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "sSAallowed")) return sSAallowed;
if (!strcmp(str_par, "sSPprohib")) return sSPprohib;
if (!strcmp(str_par, "sSTstaTest")) return sSTstaTest;
if (!strcmp(str_par, "sORoutReq")) return sORoutReq;
if (!strcmp(str_par, "sORoutGrant")) return sORoutGrant;
if (!strcmp(str_par, "sSCcongest")) return sSCcongest;
}
return UNKNOWN_VALUE;
}

boolean SCMG__param__FormatId::is_valid_enum(int int_par)
{
switch (int_par) {
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
return TRUE;
default:
return FALSE;
}
}

int SCMG__param__FormatId::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @SCCP_Types.SCMG_param_FormatId.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int SCMG__param__FormatId::enum2int(const SCMG__param__FormatId& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @SCCP_Types.SCMG_param_FormatId.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void SCMG__param__FormatId::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @SCCP_Types.SCMG_param_FormatId.", int_val);
enum_value = (enum_type)int_val;
}

SCMG__param__FormatId::operator SCMG__param__FormatId::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return enum_value;
}

void SCMG__param__FormatId::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void SCMG__param__FormatId::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@SCCP_Types.SCMG_param_FormatId");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @SCCP_Types.SCMG_param_FormatId.");
  }
}

void SCMG__param__FormatId::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
text_buf.push_int(enum_value);
}

void SCMG__param__FormatId::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @SCCP_Types.SCMG_param_FormatId.", enum_value);
}

void SCMG__param__FormatId::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCMG__param__FormatId::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCMG__param__FormatId::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int SCMG__param__FormatId::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void SCMG__param__FormatId_template::copy_template(const SCMG__param__FormatId_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCMG__param__FormatId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCMG__param__FormatId_template(*other_value.implication_.precondition);
implication_.implied_template = new SCMG__param__FormatId_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
}
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template()
{
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!SCMG__param__FormatId::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @SCCP_Types.SCMG_param_FormatId with unknown numeric value %d.", other_value);
single_value = (SCMG__param__FormatId::enum_type)other_value;
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(SCMG__param__FormatId::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(const SCMG__param__FormatId& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == SCMG__param__FormatId::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId.");
single_value = other_value.enum_value;
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(const OPTIONAL<SCMG__param__FormatId>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (SCMG__param__FormatId::enum_type)(const SCMG__param__FormatId&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @SCCP_Types.SCMG_param_FormatId from an unbound optional field.");
}
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(SCMG__param__FormatId_template* p_precondition, SCMG__param__FormatId_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(Dynamic_Match_Interface<SCMG__param__FormatId>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCMG__param__FormatId>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCMG__param__FormatId_template::SCMG__param__FormatId_template(const SCMG__param__FormatId_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

SCMG__param__FormatId_template::~SCMG__param__FormatId_template()
{
clean_up();
}

boolean SCMG__param__FormatId_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean SCMG__param__FormatId_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != SCMG__param__FormatId::UNBOUND_VALUE;
}

void SCMG__param__FormatId_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::operator=(int other_value)
{
if (!SCMG__param__FormatId::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @SCCP_Types.SCMG_param_FormatId.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (SCMG__param__FormatId::enum_type)other_value;
return *this;
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::operator=(SCMG__param__FormatId::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::operator=(const SCMG__param__FormatId& other_value)
{
if (other_value.enum_value == SCMG__param__FormatId::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @SCCP_Types.SCMG_param_FormatId to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::operator=(const OPTIONAL<SCMG__param__FormatId>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (SCMG__param__FormatId::enum_type)(const SCMG__param__FormatId&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
}
return *this;
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::operator=(const SCMG__param__FormatId_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCMG__param__FormatId_template::match(SCMG__param__FormatId::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
}
return FALSE;
}

boolean SCMG__param__FormatId_template::match(const SCMG__param__FormatId& other_value, boolean) const
{
if (other_value.enum_value == SCMG__param__FormatId::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @SCCP_Types.SCMG_param_FormatId with an unbound value.");
return match(other_value.enum_value);
}

SCMG__param__FormatId::enum_type SCMG__param__FormatId_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return single_value;
}

void SCMG__param__FormatId_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCMG__param__FormatId_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
}
}

SCMG__param__FormatId_template& SCMG__param__FormatId_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
return value_list.list_value[list_index];
}

void SCMG__param__FormatId_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(SCMG__param__FormatId::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCMG__param__FormatId_template::log_match(const SCMG__param__FormatId& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void SCMG__param__FormatId_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
}
}

void SCMG__param__FormatId_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (SCMG__param__FormatId::enum_type)text_buf.pull_int().get_val();
if (!SCMG__param__FormatId::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @SCCP_Types.SCMG_param_FormatId.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCMG__param__FormatId_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @SCCP_Types.SCMG_param_FormatId.");
}
}

boolean SCMG__param__FormatId_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCMG__param__FormatId_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void SCMG__param__FormatId_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCMG__param__FormatId_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    SCMG__param__FormatId::enum_type enum_val = SCMG__param__FormatId::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!SCMG__param__FormatId::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @SCCP_Types.SCMG_param_FormatId.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    SCMG__param__FormatId_template* precondition = new SCMG__param__FormatId_template;
    precondition->set_param(*m_p->get_elem(0));
    SCMG__param__FormatId_template* implied_template = new SCMG__param__FormatId_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = SCMG__param__FormatId_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@SCCP_Types.SCMG_param_FormatId");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCMG__param__FormatId_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCMG_param_FormatId");
}

SCMG__param__MultiplIndicator::SCMG__param__MultiplIndicator()
{
}

SCMG__param__MultiplIndicator::SCMG__param__MultiplIndicator(const BITSTRING& par_smi,
    const BITSTRING& par_reserved)
  :   field_smi(par_smi),
  field_reserved(par_reserved)
{
}

SCMG__param__MultiplIndicator::SCMG__param__MultiplIndicator(const SCMG__param__MultiplIndicator& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCMG_param_MultiplIndicator.");
if (other_value.smi().is_bound()) field_smi = other_value.smi();
else field_smi.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
}

void SCMG__param__MultiplIndicator::clean_up()
{
field_smi.clean_up();
field_reserved.clean_up();
}

const TTCN_Typedescriptor_t* SCMG__param__MultiplIndicator::get_descriptor() const { return &SCMG__param__MultiplIndicator_descr_; }
SCMG__param__MultiplIndicator& SCMG__param__MultiplIndicator::operator=(const SCMG__param__MultiplIndicator& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCMG_param_MultiplIndicator.");
  if (other_value.smi().is_bound()) field_smi = other_value.smi();
  else field_smi.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
}
return *this;
}

boolean SCMG__param__MultiplIndicator::operator==(const SCMG__param__MultiplIndicator& other_value) const
{
return field_smi==other_value.field_smi
  && field_reserved==other_value.field_reserved;
}

boolean SCMG__param__MultiplIndicator::is_bound() const
{
return (field_smi.is_bound())
  || (field_reserved.is_bound());
}
boolean SCMG__param__MultiplIndicator::is_value() const
{
return field_smi.is_value()
  && field_reserved.is_value();
}
void SCMG__param__MultiplIndicator::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ smi := ");
field_smi.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(" }");
}

void SCMG__param__MultiplIndicator::set_implicit_omit()
{
if (smi().is_bound()) smi().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void SCMG__param__MultiplIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCMG_param_MultiplIndicator has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) smi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCMG_param_MultiplIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCMG_param_MultiplIndicator");
  }
}

void SCMG__param__MultiplIndicator::encode_text(Text_Buf& text_buf) const
{
field_smi.encode_text(text_buf);
field_reserved.encode_text(text_buf);
}

void SCMG__param__MultiplIndicator::decode_text(Text_Buf& text_buf)
{
field_smi.decode_text(text_buf);
field_reserved.decode_text(text_buf);
}

void SCMG__param__MultiplIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCMG__param__MultiplIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCMG__param__MultiplIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_smi.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCMG__param__MultiplIndicator::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT6_descr_.raw);
  encoded_length += field_smi.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SCMG__param__MultiplIndicator_template::single_value_struct {
BITSTRING_template field_smi;
BITSTRING_template field_reserved;
};

void SCMG__param__MultiplIndicator_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_smi = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
}
}
}

void SCMG__param__MultiplIndicator_template::copy_value(const SCMG__param__MultiplIndicator& other_value)
{
single_value = new single_value_struct;
if (other_value.smi().is_bound()) {
  single_value->field_smi = other_value.smi();
} else {
  single_value->field_smi.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCMG__param__MultiplIndicator_template::copy_template(const SCMG__param__MultiplIndicator_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.smi().get_selection()) {
single_value->field_smi = other_value.smi();
} else {
single_value->field_smi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCMG__param__MultiplIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCMG__param__MultiplIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new SCMG__param__MultiplIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
break;
}
set_selection(other_value);
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template()
{
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template(const SCMG__param__MultiplIndicator& other_value)
{
copy_value(other_value);
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template(const OPTIONAL<SCMG__param__MultiplIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCMG__param__MultiplIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCMG_param_MultiplIndicator from an unbound optional field.");
}
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template(SCMG__param__MultiplIndicator_template* p_precondition, SCMG__param__MultiplIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template(Dynamic_Match_Interface<SCMG__param__MultiplIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCMG__param__MultiplIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCMG__param__MultiplIndicator_template::SCMG__param__MultiplIndicator_template(const SCMG__param__MultiplIndicator_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCMG__param__MultiplIndicator_template::~SCMG__param__MultiplIndicator_template()
{
clean_up();
}

SCMG__param__MultiplIndicator_template& SCMG__param__MultiplIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCMG__param__MultiplIndicator_template& SCMG__param__MultiplIndicator_template::operator=(const SCMG__param__MultiplIndicator& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCMG__param__MultiplIndicator_template& SCMG__param__MultiplIndicator_template::operator=(const OPTIONAL<SCMG__param__MultiplIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCMG__param__MultiplIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
}
return *this;
}

SCMG__param__MultiplIndicator_template& SCMG__param__MultiplIndicator_template::operator=(const SCMG__param__MultiplIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCMG__param__MultiplIndicator_template::match(const SCMG__param__MultiplIndicator& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.smi().is_bound()) return FALSE;
if(!single_value->field_smi.match(other_value.smi(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
}
return FALSE;
}

boolean SCMG__param__MultiplIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_smi.is_bound()
 || single_value->field_reserved.is_bound();
}

boolean SCMG__param__MultiplIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_smi.is_value()
 && single_value->field_reserved.is_value();
}

void SCMG__param__MultiplIndicator_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCMG__param__MultiplIndicator SCMG__param__MultiplIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
SCMG__param__MultiplIndicator ret_val;
if (single_value->field_smi.is_bound()) {
ret_val.smi() = single_value->field_smi.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
return ret_val;
}

void SCMG__param__MultiplIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCMG__param__MultiplIndicator_template[list_length];
}

SCMG__param__MultiplIndicator_template& SCMG__param__MultiplIndicator_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
return value_list.list_value[list_index];
}

BITSTRING_template& SCMG__param__MultiplIndicator_template::smi()
{
set_specific();
return single_value->field_smi;
}

const BITSTRING_template& SCMG__param__MultiplIndicator_template::smi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field smi of a non-specific template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
return single_value->field_smi;
}

BITSTRING_template& SCMG__param__MultiplIndicator_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& SCMG__param__MultiplIndicator_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
return single_value->field_reserved;
}

int SCMG__param__MultiplIndicator_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_MultiplIndicator containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
  }
  return 0;
}

void SCMG__param__MultiplIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ smi := ");
single_value->field_smi.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCMG__param__MultiplIndicator_template::log_match(const SCMG__param__MultiplIndicator& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_smi.match(match_value.smi(), legacy)){
TTCN_Logger::log_logmatch_info(".smi");
single_value->field_smi.log_match(match_value.smi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ smi := ");
single_value->field_smi.log_match(match_value.smi(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCMG__param__MultiplIndicator_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (smi().is_bound()) smi().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void SCMG__param__MultiplIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_smi.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
}
}

void SCMG__param__MultiplIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_smi.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCMG__param__MultiplIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCMG_param_MultiplIndicator.");
}
}

void SCMG__param__MultiplIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCMG__param__MultiplIndicator_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCMG_param_MultiplIndicator has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) smi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCMG_param_MultiplIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCMG__param__MultiplIndicator_template* precondition = new SCMG__param__MultiplIndicator_template;
    precondition->set_param(*param.get_elem(0));
    SCMG__param__MultiplIndicator_template* implied_template = new SCMG__param__MultiplIndicator_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCMG__param__MultiplIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCMG_param_MultiplIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCMG__param__MultiplIndicator_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_smi.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCMG_param_MultiplIndicator");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCMG_param_MultiplIndicator");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCMG_param_MultiplIndicator");
}

boolean SCMG__param__MultiplIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCMG__param__MultiplIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCMG__param__CongestionLevel::SCMG__param__CongestionLevel()
{
}

SCMG__param__CongestionLevel::SCMG__param__CongestionLevel(const BITSTRING& par_congLevel,
    const BITSTRING& par_reserved)
  :   field_congLevel(par_congLevel),
  field_reserved(par_reserved)
{
}

SCMG__param__CongestionLevel::SCMG__param__CongestionLevel(const SCMG__param__CongestionLevel& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCMG_param_CongestionLevel.");
if (other_value.congLevel().is_bound()) field_congLevel = other_value.congLevel();
else field_congLevel.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
}

void SCMG__param__CongestionLevel::clean_up()
{
field_congLevel.clean_up();
field_reserved.clean_up();
}

const TTCN_Typedescriptor_t* SCMG__param__CongestionLevel::get_descriptor() const { return &SCMG__param__CongestionLevel_descr_; }
SCMG__param__CongestionLevel& SCMG__param__CongestionLevel::operator=(const SCMG__param__CongestionLevel& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCMG_param_CongestionLevel.");
  if (other_value.congLevel().is_bound()) field_congLevel = other_value.congLevel();
  else field_congLevel.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
}
return *this;
}

boolean SCMG__param__CongestionLevel::operator==(const SCMG__param__CongestionLevel& other_value) const
{
return field_congLevel==other_value.field_congLevel
  && field_reserved==other_value.field_reserved;
}

boolean SCMG__param__CongestionLevel::is_bound() const
{
return (field_congLevel.is_bound())
  || (field_reserved.is_bound());
}
boolean SCMG__param__CongestionLevel::is_value() const
{
return field_congLevel.is_value()
  && field_reserved.is_value();
}
void SCMG__param__CongestionLevel::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ congLevel := ");
field_congLevel.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(" }");
}

void SCMG__param__CongestionLevel::set_implicit_omit()
{
if (congLevel().is_bound()) congLevel().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void SCMG__param__CongestionLevel::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @SCCP_Types.SCMG_param_CongestionLevel has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) congLevel().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "congLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          congLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCMG_param_CongestionLevel: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.SCMG_param_CongestionLevel");
  }
}

void SCMG__param__CongestionLevel::encode_text(Text_Buf& text_buf) const
{
field_congLevel.encode_text(text_buf);
field_reserved.encode_text(text_buf);
}

void SCMG__param__CongestionLevel::decode_text(Text_Buf& text_buf)
{
field_congLevel.decode_text(text_buf);
field_reserved.decode_text(text_buf);
}

void SCMG__param__CongestionLevel::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCMG__param__CongestionLevel::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCMG__param__CongestionLevel::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_congLevel.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCMG__param__CongestionLevel::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_congLevel.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SCMG__param__CongestionLevel_template::single_value_struct {
BITSTRING_template field_congLevel;
BITSTRING_template field_reserved;
};

void SCMG__param__CongestionLevel_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_congLevel = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
}
}
}

void SCMG__param__CongestionLevel_template::copy_value(const SCMG__param__CongestionLevel& other_value)
{
single_value = new single_value_struct;
if (other_value.congLevel().is_bound()) {
  single_value->field_congLevel = other_value.congLevel();
} else {
  single_value->field_congLevel.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCMG__param__CongestionLevel_template::copy_template(const SCMG__param__CongestionLevel_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.congLevel().get_selection()) {
single_value->field_congLevel = other_value.congLevel();
} else {
single_value->field_congLevel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCMG__param__CongestionLevel_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCMG__param__CongestionLevel_template(*other_value.implication_.precondition);
implication_.implied_template = new SCMG__param__CongestionLevel_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_CongestionLevel.");
break;
}
set_selection(other_value);
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template()
{
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template(const SCMG__param__CongestionLevel& other_value)
{
copy_value(other_value);
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template(const OPTIONAL<SCMG__param__CongestionLevel>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCMG__param__CongestionLevel&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCMG_param_CongestionLevel from an unbound optional field.");
}
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template(SCMG__param__CongestionLevel_template* p_precondition, SCMG__param__CongestionLevel_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template(Dynamic_Match_Interface<SCMG__param__CongestionLevel>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCMG__param__CongestionLevel>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCMG__param__CongestionLevel_template::SCMG__param__CongestionLevel_template(const SCMG__param__CongestionLevel_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCMG__param__CongestionLevel_template::~SCMG__param__CongestionLevel_template()
{
clean_up();
}

SCMG__param__CongestionLevel_template& SCMG__param__CongestionLevel_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCMG__param__CongestionLevel_template& SCMG__param__CongestionLevel_template::operator=(const SCMG__param__CongestionLevel& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCMG__param__CongestionLevel_template& SCMG__param__CongestionLevel_template::operator=(const OPTIONAL<SCMG__param__CongestionLevel>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCMG__param__CongestionLevel&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCMG_param_CongestionLevel.");
}
return *this;
}

SCMG__param__CongestionLevel_template& SCMG__param__CongestionLevel_template::operator=(const SCMG__param__CongestionLevel_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCMG__param__CongestionLevel_template::match(const SCMG__param__CongestionLevel& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.congLevel().is_bound()) return FALSE;
if(!single_value->field_congLevel.match(other_value.congLevel(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_CongestionLevel.");
}
return FALSE;
}

boolean SCMG__param__CongestionLevel_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_congLevel.is_bound()
 || single_value->field_reserved.is_bound();
}

boolean SCMG__param__CongestionLevel_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_congLevel.is_value()
 && single_value->field_reserved.is_value();
}

void SCMG__param__CongestionLevel_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCMG__param__CongestionLevel SCMG__param__CongestionLevel_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCMG_param_CongestionLevel.");
SCMG__param__CongestionLevel ret_val;
if (single_value->field_congLevel.is_bound()) {
ret_val.congLevel() = single_value->field_congLevel.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
return ret_val;
}

void SCMG__param__CongestionLevel_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCMG_param_CongestionLevel.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCMG__param__CongestionLevel_template[list_length];
}

SCMG__param__CongestionLevel_template& SCMG__param__CongestionLevel_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCMG_param_CongestionLevel.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCMG_param_CongestionLevel.");
return value_list.list_value[list_index];
}

BITSTRING_template& SCMG__param__CongestionLevel_template::congLevel()
{
set_specific();
return single_value->field_congLevel;
}

const BITSTRING_template& SCMG__param__CongestionLevel_template::congLevel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field congLevel of a non-specific template of type @SCCP_Types.SCMG_param_CongestionLevel.");
return single_value->field_congLevel;
}

BITSTRING_template& SCMG__param__CongestionLevel_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& SCMG__param__CongestionLevel_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @SCCP_Types.SCMG_param_CongestionLevel.");
return single_value->field_reserved;
}

int SCMG__param__CongestionLevel_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCMG_param_CongestionLevel containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_CongestionLevel.");
  }
  return 0;
}

void SCMG__param__CongestionLevel_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ congLevel := ");
single_value->field_congLevel.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCMG__param__CongestionLevel_template::log_match(const SCMG__param__CongestionLevel& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_congLevel.match(match_value.congLevel(), legacy)){
TTCN_Logger::log_logmatch_info(".congLevel");
single_value->field_congLevel.log_match(match_value.congLevel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ congLevel := ");
single_value->field_congLevel.log_match(match_value.congLevel(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCMG__param__CongestionLevel_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (congLevel().is_bound()) congLevel().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void SCMG__param__CongestionLevel_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_congLevel.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCMG_param_CongestionLevel.");
}
}

void SCMG__param__CongestionLevel_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_congLevel.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCMG__param__CongestionLevel_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCMG_param_CongestionLevel.");
}
}

void SCMG__param__CongestionLevel_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCMG__param__CongestionLevel_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @SCCP_Types.SCMG_param_CongestionLevel has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) congLevel().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "congLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          congLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCMG_param_CongestionLevel: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCMG__param__CongestionLevel_template* precondition = new SCMG__param__CongestionLevel_template;
    precondition->set_param(*param.get_elem(0));
    SCMG__param__CongestionLevel_template* implied_template = new SCMG__param__CongestionLevel_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCMG__param__CongestionLevel_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.SCMG_param_CongestionLevel");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCMG__param__CongestionLevel_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_congLevel.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCMG_param_CongestionLevel");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCMG_param_CongestionLevel");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCMG_param_CongestionLevel");
}

boolean SCMG__param__CongestionLevel_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCMG__param__CongestionLevel_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__ConnReq__optionalPart::SCCP__ConnReq__optionalPart()
{
}

SCCP__ConnReq__optionalPart::SCCP__ConnReq__optionalPart(const OPTIONAL< SCCP__param__Credit__opt >& par_credit,
    const OPTIONAL< SCCP__param__CPartyAddressEnc__opt >& par_callingPAddress,
    const OPTIONAL< SCCP__param__Data__opt >& par_data,
    const OPTIONAL< SCCP__param__HopCounter__opt >& par_hopCounter,
    const OPTIONAL< SCCP__param__Importance__opt >& par_importance)
  :   field_credit(par_credit),
  field_callingPAddress(par_callingPAddress),
  field_data(par_data),
  field_hopCounter(par_hopCounter),
  field_importance(par_importance)
{
}

SCCP__ConnReq__optionalPart::SCCP__ConnReq__optionalPart(const SCCP__ConnReq__optionalPart& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
if (other_value.credit().is_bound()) field_credit = other_value.credit();
else field_credit.clean_up();
if (other_value.callingPAddress().is_bound()) field_callingPAddress = other_value.callingPAddress();
else field_callingPAddress.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
if (other_value.hopCounter().is_bound()) field_hopCounter = other_value.hopCounter();
else field_hopCounter.clean_up();
if (other_value.importance().is_bound()) field_importance = other_value.importance();
else field_importance.clean_up();
}

void SCCP__ConnReq__optionalPart::clean_up()
{
field_credit.clean_up();
field_callingPAddress.clean_up();
field_data.clean_up();
field_hopCounter.clean_up();
field_importance.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__ConnReq__optionalPart::get_descriptor() const { return &SCCP__ConnReq__optionalPart_descr_; }
SCCP__ConnReq__optionalPart& SCCP__ConnReq__optionalPart::operator=(const SCCP__ConnReq__optionalPart& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
  if (other_value.credit().is_bound()) field_credit = other_value.credit();
  else field_credit.clean_up();
  if (other_value.callingPAddress().is_bound()) field_callingPAddress = other_value.callingPAddress();
  else field_callingPAddress.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
  if (other_value.hopCounter().is_bound()) field_hopCounter = other_value.hopCounter();
  else field_hopCounter.clean_up();
  if (other_value.importance().is_bound()) field_importance = other_value.importance();
  else field_importance.clean_up();
}
return *this;
}

boolean SCCP__ConnReq__optionalPart::operator==(const SCCP__ConnReq__optionalPart& other_value) const
{
return field_credit==other_value.field_credit
  && field_callingPAddress==other_value.field_callingPAddress
  && field_data==other_value.field_data
  && field_hopCounter==other_value.field_hopCounter
  && field_importance==other_value.field_importance;
}

boolean SCCP__ConnReq__optionalPart::is_bound() const
{
return (OPTIONAL_OMIT == field_credit.get_selection() || field_credit.is_bound())
  || (OPTIONAL_OMIT == field_callingPAddress.get_selection() || field_callingPAddress.is_bound())
  || (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_bound())
  || (OPTIONAL_OMIT == field_hopCounter.get_selection() || field_hopCounter.is_bound())
  || (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_bound());
}
boolean SCCP__ConnReq__optionalPart::is_value() const
{
return (OPTIONAL_OMIT == field_credit.get_selection() || field_credit.is_value())
  && (OPTIONAL_OMIT == field_callingPAddress.get_selection() || field_callingPAddress.is_value())
  && (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_value())
  && (OPTIONAL_OMIT == field_hopCounter.get_selection() || field_hopCounter.is_value())
  && (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_value());
}
int SCCP__ConnReq__optionalPart::size_of() const
{
  int ret_val = 0;
  if (field_credit.ispresent()) ret_val++;
  if (field_callingPAddress.ispresent()) ret_val++;
  if (field_data.ispresent()) ret_val++;
  if (field_hopCounter.ispresent()) ret_val++;
  if (field_importance.ispresent()) ret_val++;
  return ret_val;
}

void SCCP__ConnReq__optionalPart::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ credit := ");
field_credit.log();
TTCN_Logger::log_event_str(", callingPAddress := ");
field_callingPAddress.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(", hopCounter := ");
field_hopCounter.log();
TTCN_Logger::log_event_str(", importance := ");
field_importance.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__ConnReq__optionalPart::set_implicit_omit()
{
if (!credit().is_bound()) credit() = OMIT_VALUE;
else credit().set_implicit_omit();
if (!callingPAddress().is_bound()) callingPAddress() = OMIT_VALUE;
else callingPAddress().set_implicit_omit();
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!hopCounter().is_bound()) hopCounter() = OMIT_VALUE;
else hopCounter().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__ConnReq__optionalPart::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("set value of type @SCCP_Types.SCCP_ConnReq_optionalPart has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) callingPAddress().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) hopCounter().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callingPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callingPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hopCounter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hopCounter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_ConnReq_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@SCCP_Types.SCCP_ConnReq_optionalPart");
  }
}

void SCCP__ConnReq__optionalPart::encode_text(Text_Buf& text_buf) const
{
field_credit.encode_text(text_buf);
field_callingPAddress.encode_text(text_buf);
field_data.encode_text(text_buf);
field_hopCounter.encode_text(text_buf);
field_importance.encode_text(text_buf);
}

void SCCP__ConnReq__optionalPart::decode_text(Text_Buf& text_buf)
{
field_credit.decode_text(text_buf);
field_callingPAddress.decode_text(text_buf);
field_data.decode_text(text_buf);
field_hopCounter.decode_text(text_buf);
field_importance.decode_text(text_buf);
}

void SCCP__ConnReq__optionalPart::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__ConnReq__optionalPart::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__ConnReq__optionalPart::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[5];
memset(field_map, 0, sizeof(field_map));
field_credit = OMIT_VALUE;
field_callingPAddress = OMIT_VALUE;
field_data = OMIT_VALUE;
field_hopCounter = OMIT_VALUE;
field_importance = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0 && (force_omit == NULL || !(*force_omit)(0))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Credit__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Credit__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 9) {
RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__Credit__opt_descr_.raw->forceomit);
int decoded_field_length = field_credit().RAW_decode(SCCP__param__Credit__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length > 0 && (field_credit.ispresent() && field_credit().paramName() == 9)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_credit = OMIT_VALUE;
}
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__CPartyAddressEnc__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__CPartyAddressEnc__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 4) {
RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__CPartyAddressEnc__opt_descr_.raw->forceomit);
int decoded_field_length = field_callingPAddress().RAW_decode(SCCP__param__CPartyAddressEnc__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0 && (field_callingPAddress.ispresent() && field_callingPAddress().paramName() == 4)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_callingPAddress = OMIT_VALUE;
}
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 15) {
RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__Data__opt_descr_.raw->forceomit);
int decoded_field_length = field_data().RAW_decode(SCCP__param__Data__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0 && (field_data.ispresent() && field_data().paramName() == 15)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_data = OMIT_VALUE;
}
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__HopCounter__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__HopCounter__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 17) {
RAW_Force_Omit field_3_force_omit(3, force_omit, SCCP__param__HopCounter__opt_descr_.raw->forceomit);
int decoded_field_length = field_hopCounter().RAW_decode(SCCP__param__HopCounter__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0 && (field_hopCounter.ispresent() && field_hopCounter().paramName() == 17)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_hopCounter = OMIT_VALUE;
}
}
}
if (field_map[4] == 0 && (force_omit == NULL || !(*force_omit)(4))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 18) {
RAW_Force_Omit field_4_force_omit(4, force_omit, SCCP__param__Importance__opt_descr_.raw->forceomit);
int decoded_field_length = field_importance().RAW_decode(SCCP__param__Importance__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
if (decoded_field_length > 0 && (field_importance.ispresent() && field_importance().paramName() == 18)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[4] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_importance = OMIT_VALUE;
}
}
}
break;
}
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__ConnReq__optionalPart::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  if (field_credit.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__Credit__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_callingPAddress.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__CPartyAddressEnc__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_data.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__Data__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_hopCounter.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, SCCP__param__HopCounter__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_importance.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, SCCP__param__Importance__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_credit.ispresent()) {
  encoded_length += field_credit().RAW_encode(SCCP__param__Credit__opt_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_callingPAddress.ispresent()) {
  encoded_length += field_callingPAddress().RAW_encode(SCCP__param__CPartyAddressEnc__opt_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_data.ispresent()) {
  encoded_length += field_data().RAW_encode(SCCP__param__Data__opt_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_hopCounter.ispresent()) {
  encoded_length += field_hopCounter().RAW_encode(SCCP__param__HopCounter__opt_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_importance.ispresent()) {
  encoded_length += field_importance().RAW_encode(SCCP__param__Importance__opt_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_credit.ispresent() && (!field_credit.ispresent() || field_credit().paramName() != 9)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 9;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_callingPAddress.ispresent() && (!field_callingPAddress.ispresent() || field_callingPAddress().paramName() != 4)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 4;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_data.ispresent() && (!field_data.ispresent() || field_data().paramName() != 15)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 15;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_hopCounter.ispresent() && (!field_hopCounter.ispresent() || field_hopCounter().paramName() != 17)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 17;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_importance.ispresent() && (!field_importance.ispresent() || field_importance().paramName() != 18)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 18;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct SCCP__ConnReq__optionalPart_template::single_value_struct {
SCCP__param__Credit__opt_template field_credit;
SCCP__param__CPartyAddressEnc__opt_template field_callingPAddress;
SCCP__param__Data__opt_template field_data;
SCCP__param__HopCounter__opt_template field_hopCounter;
SCCP__param__Importance__opt_template field_importance;
};

void SCCP__ConnReq__optionalPart_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_credit = ANY_OR_OMIT;
single_value->field_callingPAddress = ANY_OR_OMIT;
single_value->field_data = ANY_OR_OMIT;
single_value->field_hopCounter = ANY_OR_OMIT;
single_value->field_importance = ANY_OR_OMIT;
}
}
}

void SCCP__ConnReq__optionalPart_template::copy_value(const SCCP__ConnReq__optionalPart& other_value)
{
single_value = new single_value_struct;
if (other_value.credit().is_bound()) {
  if (other_value.credit().ispresent()) single_value->field_credit = other_value.credit()();
  else single_value->field_credit = OMIT_VALUE;
} else {
  single_value->field_credit.clean_up();
}
if (other_value.callingPAddress().is_bound()) {
  if (other_value.callingPAddress().ispresent()) single_value->field_callingPAddress = other_value.callingPAddress()();
  else single_value->field_callingPAddress = OMIT_VALUE;
} else {
  single_value->field_callingPAddress.clean_up();
}
if (other_value.data().is_bound()) {
  if (other_value.data().ispresent()) single_value->field_data = other_value.data()();
  else single_value->field_data = OMIT_VALUE;
} else {
  single_value->field_data.clean_up();
}
if (other_value.hopCounter().is_bound()) {
  if (other_value.hopCounter().ispresent()) single_value->field_hopCounter = other_value.hopCounter()();
  else single_value->field_hopCounter = OMIT_VALUE;
} else {
  single_value->field_hopCounter.clean_up();
}
if (other_value.importance().is_bound()) {
  if (other_value.importance().ispresent()) single_value->field_importance = other_value.importance()();
  else single_value->field_importance = OMIT_VALUE;
} else {
  single_value->field_importance.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__ConnReq__optionalPart_template::copy_template(const SCCP__ConnReq__optionalPart_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.credit().get_selection()) {
single_value->field_credit = other_value.credit();
} else {
single_value->field_credit.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callingPAddress().get_selection()) {
single_value->field_callingPAddress = other_value.callingPAddress();
} else {
single_value->field_callingPAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.hopCounter().get_selection()) {
single_value->field_hopCounter = other_value.hopCounter();
} else {
single_value->field_hopCounter.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.importance().get_selection()) {
single_value->field_importance = other_value.importance();
} else {
single_value->field_importance.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__ConnReq__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__ConnReq__optionalPart_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__ConnReq__optionalPart_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
break;
}
set_selection(other_value);
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template()
{
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template(const SCCP__ConnReq__optionalPart& other_value)
{
copy_value(other_value);
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template(const OPTIONAL<SCCP__ConnReq__optionalPart>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__ConnReq__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_ConnReq_optionalPart from an unbound optional field.");
}
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template(SCCP__ConnReq__optionalPart_template* p_precondition, SCCP__ConnReq__optionalPart_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template(Dynamic_Match_Interface<SCCP__ConnReq__optionalPart>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__ConnReq__optionalPart>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__ConnReq__optionalPart_template::SCCP__ConnReq__optionalPart_template(const SCCP__ConnReq__optionalPart_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__ConnReq__optionalPart_template::~SCCP__ConnReq__optionalPart_template()
{
clean_up();
}

SCCP__ConnReq__optionalPart_template& SCCP__ConnReq__optionalPart_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__ConnReq__optionalPart_template& SCCP__ConnReq__optionalPart_template::operator=(const SCCP__ConnReq__optionalPart& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__ConnReq__optionalPart_template& SCCP__ConnReq__optionalPart_template::operator=(const OPTIONAL<SCCP__ConnReq__optionalPart>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__ConnReq__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
}
return *this;
}

SCCP__ConnReq__optionalPart_template& SCCP__ConnReq__optionalPart_template::operator=(const SCCP__ConnReq__optionalPart_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__ConnReq__optionalPart_template::match(const SCCP__ConnReq__optionalPart& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.credit().is_bound()) return FALSE;
if((other_value.credit().ispresent() ? !single_value->field_credit.match((const SCCP__param__Credit__opt&)other_value.credit(), legacy) : !single_value->field_credit.match_omit(legacy)))return FALSE;
if(!other_value.callingPAddress().is_bound()) return FALSE;
if((other_value.callingPAddress().ispresent() ? !single_value->field_callingPAddress.match((const SCCP__param__CPartyAddressEnc__opt&)other_value.callingPAddress(), legacy) : !single_value->field_callingPAddress.match_omit(legacy)))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if((other_value.data().ispresent() ? !single_value->field_data.match((const SCCP__param__Data__opt&)other_value.data(), legacy) : !single_value->field_data.match_omit(legacy)))return FALSE;
if(!other_value.hopCounter().is_bound()) return FALSE;
if((other_value.hopCounter().ispresent() ? !single_value->field_hopCounter.match((const SCCP__param__HopCounter__opt&)other_value.hopCounter(), legacy) : !single_value->field_hopCounter.match_omit(legacy)))return FALSE;
if(!other_value.importance().is_bound()) return FALSE;
if((other_value.importance().ispresent() ? !single_value->field_importance.match((const SCCP__param__Importance__opt&)other_value.importance(), legacy) : !single_value->field_importance.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
}
return FALSE;
}

boolean SCCP__ConnReq__optionalPart_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_credit.is_omit() || single_value->field_credit.is_bound())
 || (single_value->field_callingPAddress.is_omit() || single_value->field_callingPAddress.is_bound())
 || (single_value->field_data.is_omit() || single_value->field_data.is_bound())
 || (single_value->field_hopCounter.is_omit() || single_value->field_hopCounter.is_bound())
 || (single_value->field_importance.is_omit() || single_value->field_importance.is_bound());
}

boolean SCCP__ConnReq__optionalPart_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_credit.is_omit() || single_value->field_credit.is_value())
 && (single_value->field_callingPAddress.is_omit() || single_value->field_callingPAddress.is_value())
 && (single_value->field_data.is_omit() || single_value->field_data.is_value())
 && (single_value->field_hopCounter.is_omit() || single_value->field_hopCounter.is_value())
 && (single_value->field_importance.is_omit() || single_value->field_importance.is_value());
}

void SCCP__ConnReq__optionalPart_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__ConnReq__optionalPart SCCP__ConnReq__optionalPart_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
SCCP__ConnReq__optionalPart ret_val;
if (single_value->field_credit.is_omit()) ret_val.credit() = OMIT_VALUE;
else if (single_value->field_credit.is_bound()) {
ret_val.credit() = single_value->field_credit.valueof();
}
if (single_value->field_callingPAddress.is_omit()) ret_val.callingPAddress() = OMIT_VALUE;
else if (single_value->field_callingPAddress.is_bound()) {
ret_val.callingPAddress() = single_value->field_callingPAddress.valueof();
}
if (single_value->field_data.is_omit()) ret_val.data() = OMIT_VALUE;
else if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
if (single_value->field_hopCounter.is_omit()) ret_val.hopCounter() = OMIT_VALUE;
else if (single_value->field_hopCounter.is_bound()) {
ret_val.hopCounter() = single_value->field_hopCounter.valueof();
}
if (single_value->field_importance.is_omit()) ret_val.importance() = OMIT_VALUE;
else if (single_value->field_importance.is_bound()) {
ret_val.importance() = single_value->field_importance.valueof();
}
return ret_val;
}

void SCCP__ConnReq__optionalPart_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__ConnReq__optionalPart_template[list_length];
}

SCCP__ConnReq__optionalPart_template& SCCP__ConnReq__optionalPart_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
return value_list.list_value[list_index];
}

SCCP__param__Credit__opt_template& SCCP__ConnReq__optionalPart_template::credit()
{
set_specific();
return single_value->field_credit;
}

const SCCP__param__Credit__opt_template& SCCP__ConnReq__optionalPart_template::credit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field credit of a non-specific template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
return single_value->field_credit;
}

SCCP__param__CPartyAddressEnc__opt_template& SCCP__ConnReq__optionalPart_template::callingPAddress()
{
set_specific();
return single_value->field_callingPAddress;
}

const SCCP__param__CPartyAddressEnc__opt_template& SCCP__ConnReq__optionalPart_template::callingPAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callingPAddress of a non-specific template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
return single_value->field_callingPAddress;
}

SCCP__param__Data__opt_template& SCCP__ConnReq__optionalPart_template::data()
{
set_specific();
return single_value->field_data;
}

const SCCP__param__Data__opt_template& SCCP__ConnReq__optionalPart_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
return single_value->field_data;
}

SCCP__param__HopCounter__opt_template& SCCP__ConnReq__optionalPart_template::hopCounter()
{
set_specific();
return single_value->field_hopCounter;
}

const SCCP__param__HopCounter__opt_template& SCCP__ConnReq__optionalPart_template::hopCounter() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field hopCounter of a non-specific template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
return single_value->field_hopCounter;
}

SCCP__param__Importance__opt_template& SCCP__ConnReq__optionalPart_template::importance()
{
set_specific();
return single_value->field_importance;
}

const SCCP__param__Importance__opt_template& SCCP__ConnReq__optionalPart_template::importance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field importance of a non-specific template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
return single_value->field_importance;
}

int SCCP__ConnReq__optionalPart_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_credit.is_present()) ret_val++;
      if (single_value->field_callingPAddress.is_present()) ret_val++;
      if (single_value->field_data.is_present()) ret_val++;
      if (single_value->field_hopCounter.is_present()) ret_val++;
      if (single_value->field_importance.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnReq_optionalPart containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
  }
  return 0;
}

void SCCP__ConnReq__optionalPart_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ credit := ");
single_value->field_credit.log();
TTCN_Logger::log_event_str(", callingPAddress := ");
single_value->field_callingPAddress.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(", hopCounter := ");
single_value->field_hopCounter.log();
TTCN_Logger::log_event_str(", importance := ");
single_value->field_importance.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__ConnReq__optionalPart_template::log_match(const SCCP__ConnReq__optionalPart& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.credit().ispresent()){
if(!single_value->field_credit.match(match_value.credit(), legacy)){
TTCN_Logger::log_logmatch_info(".credit");
single_value->field_credit.log_match(match_value.credit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_credit.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".credit := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_credit.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.callingPAddress().ispresent()){
if(!single_value->field_callingPAddress.match(match_value.callingPAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".callingPAddress");
single_value->field_callingPAddress.log_match(match_value.callingPAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_callingPAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".callingPAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_callingPAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.data().ispresent()){
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.hopCounter().ispresent()){
if(!single_value->field_hopCounter.match(match_value.hopCounter(), legacy)){
TTCN_Logger::log_logmatch_info(".hopCounter");
single_value->field_hopCounter.log_match(match_value.hopCounter(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_hopCounter.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".hopCounter := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_hopCounter.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.importance().ispresent()){
if(!single_value->field_importance.match(match_value.importance(), legacy)){
TTCN_Logger::log_logmatch_info(".importance");
single_value->field_importance.log_match(match_value.importance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_importance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".importance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_importance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ credit := ");
if (match_value.credit().ispresent()) {
single_value->field_credit.log_match(match_value.credit(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_credit.log();
if (single_value->field_credit.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", callingPAddress := ");
if (match_value.callingPAddress().ispresent()) {
single_value->field_callingPAddress.log_match(match_value.callingPAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_callingPAddress.log();
if (single_value->field_callingPAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", data := ");
if (match_value.data().ispresent()) {
single_value->field_data.log_match(match_value.data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_data.log();
if (single_value->field_data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", hopCounter := ");
if (match_value.hopCounter().ispresent()) {
single_value->field_hopCounter.log_match(match_value.hopCounter(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_hopCounter.log();
if (single_value->field_hopCounter.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", importance := ");
if (match_value.importance().ispresent()) {
single_value->field_importance.log_match(match_value.importance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_importance.log();
if (single_value->field_importance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__ConnReq__optionalPart_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!credit().is_bound()) credit() = OMIT_VALUE;
else credit().set_implicit_omit();
if (!callingPAddress().is_bound()) callingPAddress() = OMIT_VALUE;
else callingPAddress().set_implicit_omit();
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!hopCounter().is_bound()) hopCounter() = OMIT_VALUE;
else hopCounter().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__ConnReq__optionalPart_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_credit.encode_text(text_buf);
single_value->field_callingPAddress.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
single_value->field_hopCounter.encode_text(text_buf);
single_value->field_importance.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
}
}

void SCCP__ConnReq__optionalPart_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_credit.decode_text(text_buf);
single_value->field_callingPAddress.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
single_value->field_hopCounter.decode_text(text_buf);
single_value->field_importance.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__ConnReq__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_ConnReq_optionalPart.");
}
}

void SCCP__ConnReq__optionalPart_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__ConnReq__optionalPart_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("set template of type @SCCP_Types.SCCP_ConnReq_optionalPart has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) callingPAddress().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) hopCounter().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callingPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callingPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hopCounter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hopCounter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_ConnReq_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__ConnReq__optionalPart_template* precondition = new SCCP__ConnReq__optionalPart_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__ConnReq__optionalPart_template* implied_template = new SCCP__ConnReq__optionalPart_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__ConnReq__optionalPart_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@SCCP_Types.SCCP_ConnReq_optionalPart");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__ConnReq__optionalPart_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_credit.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnReq_optionalPart");
single_value->field_callingPAddress.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnReq_optionalPart");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnReq_optionalPart");
single_value->field_hopCounter.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnReq_optionalPart");
single_value->field_importance.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnReq_optionalPart");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_ConnReq_optionalPart");
}

boolean SCCP__ConnReq__optionalPart_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__ConnReq__optionalPart_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__ConnectionRequest::PDU__SCCP__ConnectionRequest()
{
}

PDU__SCCP__ConnectionRequest::PDU__SCCP__ConnectionRequest(const INTEGER& par_messageType,
    const OCTETSTRING& par_sourceLocRef,
    const SCCP__param__ProtocolClass& par_protClass,
    const INTEGER& par_pointer1,
    const INTEGER& par_pointer2,
    const SCCP__param__CPartyAddressEnc& par_calledPAddress,
    const OPTIONAL< SCCP__ConnReq__optionalPart >& par_optionalPart,
    const OPTIONAL< SCCP__param__EndOfOptionalParams >& par_eop)
  :   field_messageType(par_messageType),
  field_sourceLocRef(par_sourceLocRef),
  field_protClass(par_protClass),
  field_pointer1(par_pointer1),
  field_pointer2(par_pointer2),
  field_calledPAddress(par_calledPAddress),
  field_optionalPart(par_optionalPart),
  field_eop(par_eop)
{
}

PDU__SCCP__ConnectionRequest::PDU__SCCP__ConnectionRequest(const PDU__SCCP__ConnectionRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
else field_sourceLocRef.clean_up();
if (other_value.protClass().is_bound()) field_protClass = other_value.protClass();
else field_protClass.clean_up();
if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
else field_pointer1.clean_up();
if (other_value.pointer2().is_bound()) field_pointer2 = other_value.pointer2();
else field_pointer2.clean_up();
if (other_value.calledPAddress().is_bound()) field_calledPAddress = other_value.calledPAddress();
else field_calledPAddress.clean_up();
if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
else field_optionalPart.clean_up();
if (other_value.eop().is_bound()) field_eop = other_value.eop();
else field_eop.clean_up();
}

void PDU__SCCP__ConnectionRequest::clean_up()
{
field_messageType.clean_up();
field_sourceLocRef.clean_up();
field_protClass.clean_up();
field_pointer1.clean_up();
field_pointer2.clean_up();
field_calledPAddress.clean_up();
field_optionalPart.clean_up();
field_eop.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__ConnectionRequest::get_descriptor() const { return &PDU__SCCP__ConnectionRequest_descr_; }
PDU__SCCP__ConnectionRequest& PDU__SCCP__ConnectionRequest::operator=(const PDU__SCCP__ConnectionRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
  else field_sourceLocRef.clean_up();
  if (other_value.protClass().is_bound()) field_protClass = other_value.protClass();
  else field_protClass.clean_up();
  if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
  else field_pointer1.clean_up();
  if (other_value.pointer2().is_bound()) field_pointer2 = other_value.pointer2();
  else field_pointer2.clean_up();
  if (other_value.calledPAddress().is_bound()) field_calledPAddress = other_value.calledPAddress();
  else field_calledPAddress.clean_up();
  if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
  else field_optionalPart.clean_up();
  if (other_value.eop().is_bound()) field_eop = other_value.eop();
  else field_eop.clean_up();
}
return *this;
}

boolean PDU__SCCP__ConnectionRequest::operator==(const PDU__SCCP__ConnectionRequest& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_sourceLocRef==other_value.field_sourceLocRef
  && field_protClass==other_value.field_protClass
  && field_pointer1==other_value.field_pointer1
  && field_pointer2==other_value.field_pointer2
  && field_calledPAddress==other_value.field_calledPAddress
  && field_optionalPart==other_value.field_optionalPart
  && field_eop==other_value.field_eop;
}

boolean PDU__SCCP__ConnectionRequest::is_bound() const
{
return (field_messageType.is_bound())
  || (field_sourceLocRef.is_bound())
  || (field_protClass.is_bound())
  || (field_pointer1.is_bound())
  || (field_pointer2.is_bound())
  || (field_calledPAddress.is_bound())
  || (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_bound())
  || (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_bound());
}
boolean PDU__SCCP__ConnectionRequest::is_value() const
{
return field_messageType.is_value()
  && field_sourceLocRef.is_value()
  && field_protClass.is_value()
  && field_pointer1.is_value()
  && field_pointer2.is_value()
  && field_calledPAddress.is_value()
  && (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_value())
  && (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_value());
}
int PDU__SCCP__ConnectionRequest::size_of() const
{
  int ret_val = 6;
  if (field_optionalPart.ispresent()) ret_val++;
  if (field_eop.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SCCP__ConnectionRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
field_sourceLocRef.log();
TTCN_Logger::log_event_str(", protClass := ");
field_protClass.log();
TTCN_Logger::log_event_str(", pointer1 := ");
field_pointer1.log();
TTCN_Logger::log_event_str(", pointer2 := ");
field_pointer2.log();
TTCN_Logger::log_event_str(", calledPAddress := ");
field_calledPAddress.log();
TTCN_Logger::log_event_str(", optionalPart := ");
field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
field_eop.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__ConnectionRequest::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
if (protClass().is_bound()) protClass().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (pointer2().is_bound()) pointer2().set_implicit_omit();
if (calledPAddress().is_bound()) calledPAddress().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__ConnectionRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_ConnectionRequest has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protClass().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pointer2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) calledPAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "calledPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          calledPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ConnectionRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_ConnectionRequest");
  }
}

void PDU__SCCP__ConnectionRequest::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_sourceLocRef.encode_text(text_buf);
field_protClass.encode_text(text_buf);
field_pointer1.encode_text(text_buf);
field_pointer2.encode_text(text_buf);
field_calledPAddress.encode_text(text_buf);
field_optionalPart.encode_text(text_buf);
field_eop.encode_text(text_buf);
}

void PDU__SCCP__ConnectionRequest::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_sourceLocRef.decode_text(text_buf);
field_protClass.decode_text(text_buf);
field_pointer1.decode_text(text_buf);
field_pointer2.decode_text(text_buf);
field_calledPAddress.decode_text(text_buf);
field_optionalPart.decode_text(text_buf);
field_eop.decode_text(text_buf);
}

void PDU__SCCP__ConnectionRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__ConnectionRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__ConnectionRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int end_of_available_data=last_decoded_pos+limit;
  int start_pos_of_field3=-1;
  int start_pos_of_field4=-1;
  int start_of_field5=-1;
  int start_of_field6=-1;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__SourceLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_sourceLocRef.RAW_decode(SCCP__param__SourceLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__ProtocolClass_descr_.raw->forceomit);
  decoded_field_length = field_protClass.RAW_decode(SCCP__param__ProtocolClass_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_pos_of_field3=p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, PDU__SCCP__ConnectionRequest_pointer1_descr_.raw->forceomit);
  decoded_field_length = field_pointer1.RAW_decode(PDU__SCCP__ConnectionRequest_pointer1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field5=(int)field_pointer1+0?1:-1;
  start_pos_of_field4=p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PDU__SCCP__ConnectionRequest_pointer2_descr_.raw->forceomit);
  decoded_field_length = field_pointer2.RAW_decode(PDU__SCCP__ConnectionRequest_pointer2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field6=(int)field_pointer2+0?1:-1;
  start_of_field5=start_pos_of_field3+(int)field_pointer1*8+0;
  p_buf.set_pos_bit(start_of_field5);
  limit=end_of_available_data-start_of_field5;
  RAW_Force_Omit field_5_force_omit(5, force_omit, SCCP__param__CPartyAddressEnc_descr_.raw->forceomit);
  decoded_field_length = field_calledPAddress.RAW_decode(SCCP__param__CPartyAddressEnc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && start_of_field6!=-1 && start_pos_of_field4!=-1){
  start_of_field6=start_pos_of_field4+(int)field_pointer2*8+0;
  p_buf.set_pos_bit(start_of_field6);
  limit=end_of_available_data-start_of_field6;
  if (force_omit != NULL && (*force_omit)(6)) {
    field_optionalPart = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, SCCP__ConnReq__optionalPart_descr_.raw->forceomit);
  decoded_field_length = field_optionalPart().RAW_decode(SCCP__ConnReq__optionalPart_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_optionalPart = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_optionalPart=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_eop = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, SCCP__param__EndOfOptionalParams_descr_.raw->forceomit);
  decoded_field_length = field_eop().RAW_decode(SCCP__param__EndOfOptionalParams_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_eop = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_eop.ispresent() || field_eop().paramName() != 0){
  field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__ConnectionRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__SourceLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__ProtocolClass_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PDU__SCCP__ConnectionRequest_pointer1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PDU__SCCP__ConnectionRequest_pointer2_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, SCCP__param__CPartyAddressEnc_descr_.raw);
  if (field_optionalPart.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, SCCP__ConnReq__optionalPart_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_eop.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, SCCP__param__EndOfOptionalParams_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_sourceLocRef.RAW_encode(SCCP__param__SourceLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_protClass.RAW_encode(SCCP__param__ProtocolClass_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += 8;
  myleaf.body.node.nodes[3]->calc = CALC_POINTER;
  myleaf.body.node.nodes[3]->coding_descr = &PDU__SCCP__ConnectionRequest_pointer1_descr_;
  myleaf.body.node.nodes[3]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_base = 3;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[3]->length = 8;
  if (field_optionalPart.ispresent()) {
  encoded_length += 8;
  myleaf.body.node.nodes[4]->calc = CALC_POINTER;
  myleaf.body.node.nodes[4]->coding_descr = &PDU__SCCP__ConnectionRequest_pointer2_descr_;
  myleaf.body.node.nodes[4]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[4]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[4]->calcof.pointerto.ptr_base = 4;
  myleaf.body.node.nodes[4]->calcof.pointerto.target.level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.pointerto.target.pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[4]->length = 8;
  } else {
    INTEGER atm;
    atm = 0;
    encoded_length += atm.RAW_encode(PDU__SCCP__ConnectionRequest_pointer2_descr_, *myleaf.body.node.nodes[4]);
  }
  encoded_length += field_calledPAddress.RAW_encode(SCCP__param__CPartyAddressEnc_descr_, *myleaf.body.node.nodes[5]);
  if (field_optionalPart.ispresent()) {
  encoded_length += field_optionalPart().RAW_encode(SCCP__ConnReq__optionalPart_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_eop.ispresent()) {
  encoded_length += field_eop().RAW_encode(SCCP__param__EndOfOptionalParams_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_eop.ispresent() && (!field_eop.ispresent() || field_eop().paramName() != 0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 0;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__ConnectionRequest_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_sourceLocRef;
SCCP__param__ProtocolClass_template field_protClass;
INTEGER_template field_pointer1;
INTEGER_template field_pointer2;
SCCP__param__CPartyAddressEnc_template field_calledPAddress;
SCCP__ConnReq__optionalPart_template field_optionalPart;
SCCP__param__EndOfOptionalParams_template field_eop;
};

void PDU__SCCP__ConnectionRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_sourceLocRef = ANY_VALUE;
single_value->field_protClass = ANY_VALUE;
single_value->field_pointer1 = ANY_VALUE;
single_value->field_pointer2 = ANY_VALUE;
single_value->field_calledPAddress = ANY_VALUE;
single_value->field_optionalPart = ANY_OR_OMIT;
single_value->field_eop = ANY_OR_OMIT;
}
}
}

void PDU__SCCP__ConnectionRequest_template::copy_value(const PDU__SCCP__ConnectionRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.sourceLocRef().is_bound()) {
  single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
  single_value->field_sourceLocRef.clean_up();
}
if (other_value.protClass().is_bound()) {
  single_value->field_protClass = other_value.protClass();
} else {
  single_value->field_protClass.clean_up();
}
if (other_value.pointer1().is_bound()) {
  single_value->field_pointer1 = other_value.pointer1();
} else {
  single_value->field_pointer1.clean_up();
}
if (other_value.pointer2().is_bound()) {
  single_value->field_pointer2 = other_value.pointer2();
} else {
  single_value->field_pointer2.clean_up();
}
if (other_value.calledPAddress().is_bound()) {
  single_value->field_calledPAddress = other_value.calledPAddress();
} else {
  single_value->field_calledPAddress.clean_up();
}
if (other_value.optionalPart().is_bound()) {
  if (other_value.optionalPart().ispresent()) single_value->field_optionalPart = other_value.optionalPart()();
  else single_value->field_optionalPart = OMIT_VALUE;
} else {
  single_value->field_optionalPart.clean_up();
}
if (other_value.eop().is_bound()) {
  if (other_value.eop().ispresent()) single_value->field_eop = other_value.eop()();
  else single_value->field_eop = OMIT_VALUE;
} else {
  single_value->field_eop.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__ConnectionRequest_template::copy_template(const PDU__SCCP__ConnectionRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sourceLocRef().get_selection()) {
single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
single_value->field_sourceLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protClass().get_selection()) {
single_value->field_protClass = other_value.protClass();
} else {
single_value->field_protClass.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer1().get_selection()) {
single_value->field_pointer1 = other_value.pointer1();
} else {
single_value->field_pointer1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer2().get_selection()) {
single_value->field_pointer2 = other_value.pointer2();
} else {
single_value->field_pointer2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.calledPAddress().get_selection()) {
single_value->field_calledPAddress = other_value.calledPAddress();
} else {
single_value->field_calledPAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.optionalPart().get_selection()) {
single_value->field_optionalPart = other_value.optionalPart();
} else {
single_value->field_optionalPart.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eop().get_selection()) {
single_value->field_eop = other_value.eop();
} else {
single_value->field_eop.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__ConnectionRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__ConnectionRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__ConnectionRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
break;
}
set_selection(other_value);
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template()
{
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template(const PDU__SCCP__ConnectionRequest& other_value)
{
copy_value(other_value);
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template(const OPTIONAL<PDU__SCCP__ConnectionRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ConnectionRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest from an unbound optional field.");
}
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template(PDU__SCCP__ConnectionRequest_template* p_precondition, PDU__SCCP__ConnectionRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template(Dynamic_Match_Interface<PDU__SCCP__ConnectionRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__ConnectionRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__ConnectionRequest_template::PDU__SCCP__ConnectionRequest_template(const PDU__SCCP__ConnectionRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__ConnectionRequest_template::~PDU__SCCP__ConnectionRequest_template()
{
clean_up();
}

PDU__SCCP__ConnectionRequest_template& PDU__SCCP__ConnectionRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__ConnectionRequest_template& PDU__SCCP__ConnectionRequest_template::operator=(const PDU__SCCP__ConnectionRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__ConnectionRequest_template& PDU__SCCP__ConnectionRequest_template::operator=(const OPTIONAL<PDU__SCCP__ConnectionRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ConnectionRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
}
return *this;
}

PDU__SCCP__ConnectionRequest_template& PDU__SCCP__ConnectionRequest_template::operator=(const PDU__SCCP__ConnectionRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__ConnectionRequest_template::match(const PDU__SCCP__ConnectionRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.sourceLocRef().is_bound()) return FALSE;
if(!single_value->field_sourceLocRef.match(other_value.sourceLocRef(), legacy))return FALSE;
if(!other_value.protClass().is_bound()) return FALSE;
if(!single_value->field_protClass.match(other_value.protClass(), legacy))return FALSE;
if(!other_value.pointer1().is_bound()) return FALSE;
if(!single_value->field_pointer1.match(other_value.pointer1(), legacy))return FALSE;
if(!other_value.pointer2().is_bound()) return FALSE;
if(!single_value->field_pointer2.match(other_value.pointer2(), legacy))return FALSE;
if(!other_value.calledPAddress().is_bound()) return FALSE;
if(!single_value->field_calledPAddress.match(other_value.calledPAddress(), legacy))return FALSE;
if(!other_value.optionalPart().is_bound()) return FALSE;
if((other_value.optionalPart().ispresent() ? !single_value->field_optionalPart.match((const SCCP__ConnReq__optionalPart&)other_value.optionalPart(), legacy) : !single_value->field_optionalPart.match_omit(legacy)))return FALSE;
if(!other_value.eop().is_bound()) return FALSE;
if((other_value.eop().ispresent() ? !single_value->field_eop.match((const SCCP__param__EndOfOptionalParams&)other_value.eop(), legacy) : !single_value->field_eop.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
}
return FALSE;
}

boolean PDU__SCCP__ConnectionRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_sourceLocRef.is_bound()
 || single_value->field_protClass.is_bound()
 || single_value->field_pointer1.is_bound()
 || single_value->field_pointer2.is_bound()
 || single_value->field_calledPAddress.is_bound()
 || (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_bound())
 || (single_value->field_eop.is_omit() || single_value->field_eop.is_bound());
}

boolean PDU__SCCP__ConnectionRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_sourceLocRef.is_value()
 && single_value->field_protClass.is_value()
 && single_value->field_pointer1.is_value()
 && single_value->field_pointer2.is_value()
 && single_value->field_calledPAddress.is_value()
 && (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_value())
 && (single_value->field_eop.is_omit() || single_value->field_eop.is_value());
}

void PDU__SCCP__ConnectionRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__ConnectionRequest PDU__SCCP__ConnectionRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
PDU__SCCP__ConnectionRequest ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_sourceLocRef.is_bound()) {
ret_val.sourceLocRef() = single_value->field_sourceLocRef.valueof();
}
if (single_value->field_protClass.is_bound()) {
ret_val.protClass() = single_value->field_protClass.valueof();
}
if (single_value->field_pointer1.is_bound()) {
ret_val.pointer1() = single_value->field_pointer1.valueof();
}
if (single_value->field_pointer2.is_bound()) {
ret_val.pointer2() = single_value->field_pointer2.valueof();
}
if (single_value->field_calledPAddress.is_bound()) {
ret_val.calledPAddress() = single_value->field_calledPAddress.valueof();
}
if (single_value->field_optionalPart.is_omit()) ret_val.optionalPart() = OMIT_VALUE;
else if (single_value->field_optionalPart.is_bound()) {
ret_val.optionalPart() = single_value->field_optionalPart.valueof();
}
if (single_value->field_eop.is_omit()) ret_val.eop() = OMIT_VALUE;
else if (single_value->field_eop.is_bound()) {
ret_val.eop() = single_value->field_eop.valueof();
}
return ret_val;
}

void PDU__SCCP__ConnectionRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__ConnectionRequest_template[list_length];
}

PDU__SCCP__ConnectionRequest_template& PDU__SCCP__ConnectionRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__ConnectionRequest_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__ConnectionRequest_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__ConnectionRequest_template::sourceLocRef()
{
set_specific();
return single_value->field_sourceLocRef;
}

const OCTETSTRING_template& PDU__SCCP__ConnectionRequest_template::sourceLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sourceLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_sourceLocRef;
}

SCCP__param__ProtocolClass_template& PDU__SCCP__ConnectionRequest_template::protClass()
{
set_specific();
return single_value->field_protClass;
}

const SCCP__param__ProtocolClass_template& PDU__SCCP__ConnectionRequest_template::protClass() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protClass of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_protClass;
}

INTEGER_template& PDU__SCCP__ConnectionRequest_template::pointer1()
{
set_specific();
return single_value->field_pointer1;
}

const INTEGER_template& PDU__SCCP__ConnectionRequest_template::pointer1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer1 of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_pointer1;
}

INTEGER_template& PDU__SCCP__ConnectionRequest_template::pointer2()
{
set_specific();
return single_value->field_pointer2;
}

const INTEGER_template& PDU__SCCP__ConnectionRequest_template::pointer2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer2 of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_pointer2;
}

SCCP__param__CPartyAddressEnc_template& PDU__SCCP__ConnectionRequest_template::calledPAddress()
{
set_specific();
return single_value->field_calledPAddress;
}

const SCCP__param__CPartyAddressEnc_template& PDU__SCCP__ConnectionRequest_template::calledPAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field calledPAddress of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_calledPAddress;
}

SCCP__ConnReq__optionalPart_template& PDU__SCCP__ConnectionRequest_template::optionalPart()
{
set_specific();
return single_value->field_optionalPart;
}

const SCCP__ConnReq__optionalPart_template& PDU__SCCP__ConnectionRequest_template::optionalPart() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field optionalPart of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_optionalPart;
}

SCCP__param__EndOfOptionalParams_template& PDU__SCCP__ConnectionRequest_template::eop()
{
set_specific();
return single_value->field_eop;
}

const SCCP__param__EndOfOptionalParams_template& PDU__SCCP__ConnectionRequest_template::eop() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eop of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
return single_value->field_eop;
}

int PDU__SCCP__ConnectionRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 6;
      if (single_value->field_optionalPart.is_present()) ret_val++;
      if (single_value->field_eop.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
  }
  return 0;
}

void PDU__SCCP__ConnectionRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log();
TTCN_Logger::log_event_str(", protClass := ");
single_value->field_protClass.log();
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log();
TTCN_Logger::log_event_str(", pointer2 := ");
single_value->field_pointer2.log();
TTCN_Logger::log_event_str(", calledPAddress := ");
single_value->field_calledPAddress.log();
TTCN_Logger::log_event_str(", optionalPart := ");
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
single_value->field_eop.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__ConnectionRequest_template::log_match(const PDU__SCCP__ConnectionRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sourceLocRef.match(match_value.sourceLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".sourceLocRef");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_protClass.match(match_value.protClass(), legacy)){
TTCN_Logger::log_logmatch_info(".protClass");
single_value->field_protClass.log_match(match_value.protClass(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer1.match(match_value.pointer1(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer1");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer2.match(match_value.pointer2(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer2");
single_value->field_pointer2.log_match(match_value.pointer2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_calledPAddress.match(match_value.calledPAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".calledPAddress");
single_value->field_calledPAddress.log_match(match_value.calledPAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.optionalPart().ispresent()){
if(!single_value->field_optionalPart.match(match_value.optionalPart(), legacy)){
TTCN_Logger::log_logmatch_info(".optionalPart");
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_optionalPart.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".optionalPart := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.eop().ispresent()){
if(!single_value->field_eop.match(match_value.eop(), legacy)){
TTCN_Logger::log_logmatch_info(".eop");
single_value->field_eop.log_match(match_value.eop(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_eop.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".eop := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_eop.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::log_event_str(", protClass := ");
single_value->field_protClass.log_match(match_value.protClass(), legacy);
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::log_event_str(", pointer2 := ");
single_value->field_pointer2.log_match(match_value.pointer2(), legacy);
TTCN_Logger::log_event_str(", calledPAddress := ");
single_value->field_calledPAddress.log_match(match_value.calledPAddress(), legacy);
TTCN_Logger::log_event_str(", optionalPart := ");
if (match_value.optionalPart().ispresent()) {
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_optionalPart.log();
if (single_value->field_optionalPart.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", eop := ");
if (match_value.eop().ispresent()) {
single_value->field_eop.log_match(match_value.eop(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_eop.log();
if (single_value->field_eop.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__ConnectionRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
if (protClass().is_bound()) protClass().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (pointer2().is_bound()) pointer2().set_implicit_omit();
if (calledPAddress().is_bound()) calledPAddress().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__ConnectionRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_sourceLocRef.encode_text(text_buf);
single_value->field_protClass.encode_text(text_buf);
single_value->field_pointer1.encode_text(text_buf);
single_value->field_pointer2.encode_text(text_buf);
single_value->field_calledPAddress.encode_text(text_buf);
single_value->field_optionalPart.encode_text(text_buf);
single_value->field_eop.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
}
}

void PDU__SCCP__ConnectionRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_sourceLocRef.decode_text(text_buf);
single_value->field_protClass.decode_text(text_buf);
single_value->field_pointer1.decode_text(text_buf);
single_value->field_pointer2.decode_text(text_buf);
single_value->field_calledPAddress.decode_text(text_buf);
single_value->field_optionalPart.decode_text(text_buf);
single_value->field_eop.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__ConnectionRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_ConnectionRequest.");
}
}

void PDU__SCCP__ConnectionRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__ConnectionRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_ConnectionRequest has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protClass().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pointer2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) calledPAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "calledPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          calledPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ConnectionRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__ConnectionRequest_template* precondition = new PDU__SCCP__ConnectionRequest_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__ConnectionRequest_template* implied_template = new PDU__SCCP__ConnectionRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__ConnectionRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_ConnectionRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__ConnectionRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_sourceLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_protClass.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_pointer1.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_pointer2.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_calledPAddress.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_optionalPart.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
single_value->field_eop.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRequest");
}

boolean PDU__SCCP__ConnectionRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__ConnectionRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
