// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "SCCP_Types.hh"

namespace SCCP__Types {

/* Member functions of C++ classes */

SCCP__ConnConfirm__optionalPart::SCCP__ConnConfirm__optionalPart()
{
}

SCCP__ConnConfirm__optionalPart::SCCP__ConnConfirm__optionalPart(const OPTIONAL< SCCP__param__Credit__opt >& par_credit,
    const OPTIONAL< SCCP__param__CPartyAddressEnc__opt >& par_calledPAddress,
    const OPTIONAL< SCCP__param__Data__opt >& par_data,
    const OPTIONAL< SCCP__param__Importance__opt >& par_importance)
  :   field_credit(par_credit),
  field_calledPAddress(par_calledPAddress),
  field_data(par_data),
  field_importance(par_importance)
{
}

SCCP__ConnConfirm__optionalPart::SCCP__ConnConfirm__optionalPart(const SCCP__ConnConfirm__optionalPart& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
if (other_value.credit().is_bound()) field_credit = other_value.credit();
else field_credit.clean_up();
if (other_value.calledPAddress().is_bound()) field_calledPAddress = other_value.calledPAddress();
else field_calledPAddress.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
if (other_value.importance().is_bound()) field_importance = other_value.importance();
else field_importance.clean_up();
}

void SCCP__ConnConfirm__optionalPart::clean_up()
{
field_credit.clean_up();
field_calledPAddress.clean_up();
field_data.clean_up();
field_importance.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__ConnConfirm__optionalPart::get_descriptor() const { return &SCCP__ConnConfirm__optionalPart_descr_; }
SCCP__ConnConfirm__optionalPart& SCCP__ConnConfirm__optionalPart::operator=(const SCCP__ConnConfirm__optionalPart& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
  if (other_value.credit().is_bound()) field_credit = other_value.credit();
  else field_credit.clean_up();
  if (other_value.calledPAddress().is_bound()) field_calledPAddress = other_value.calledPAddress();
  else field_calledPAddress.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
  if (other_value.importance().is_bound()) field_importance = other_value.importance();
  else field_importance.clean_up();
}
return *this;
}

boolean SCCP__ConnConfirm__optionalPart::operator==(const SCCP__ConnConfirm__optionalPart& other_value) const
{
return field_credit==other_value.field_credit
  && field_calledPAddress==other_value.field_calledPAddress
  && field_data==other_value.field_data
  && field_importance==other_value.field_importance;
}

boolean SCCP__ConnConfirm__optionalPart::is_bound() const
{
return (OPTIONAL_OMIT == field_credit.get_selection() || field_credit.is_bound())
  || (OPTIONAL_OMIT == field_calledPAddress.get_selection() || field_calledPAddress.is_bound())
  || (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_bound())
  || (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_bound());
}
boolean SCCP__ConnConfirm__optionalPart::is_value() const
{
return (OPTIONAL_OMIT == field_credit.get_selection() || field_credit.is_value())
  && (OPTIONAL_OMIT == field_calledPAddress.get_selection() || field_calledPAddress.is_value())
  && (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_value())
  && (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_value());
}
int SCCP__ConnConfirm__optionalPart::size_of() const
{
  int ret_val = 0;
  if (field_credit.ispresent()) ret_val++;
  if (field_calledPAddress.ispresent()) ret_val++;
  if (field_data.ispresent()) ret_val++;
  if (field_importance.ispresent()) ret_val++;
  return ret_val;
}

void SCCP__ConnConfirm__optionalPart::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ credit := ");
field_credit.log();
TTCN_Logger::log_event_str(", calledPAddress := ");
field_calledPAddress.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(", importance := ");
field_importance.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__ConnConfirm__optionalPart::set_implicit_omit()
{
if (!credit().is_bound()) credit() = OMIT_VALUE;
else credit().set_implicit_omit();
if (!calledPAddress().is_bound()) calledPAddress() = OMIT_VALUE;
else calledPAddress().set_implicit_omit();
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__ConnConfirm__optionalPart::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("set value of type @SCCP_Types.SCCP_ConnConfirm_optionalPart has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) calledPAddress().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "calledPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          calledPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_ConnConfirm_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
  }
}

void SCCP__ConnConfirm__optionalPart::encode_text(Text_Buf& text_buf) const
{
field_credit.encode_text(text_buf);
field_calledPAddress.encode_text(text_buf);
field_data.encode_text(text_buf);
field_importance.encode_text(text_buf);
}

void SCCP__ConnConfirm__optionalPart::decode_text(Text_Buf& text_buf)
{
field_credit.decode_text(text_buf);
field_calledPAddress.decode_text(text_buf);
field_data.decode_text(text_buf);
field_importance.decode_text(text_buf);
}

void SCCP__ConnConfirm__optionalPart::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__ConnConfirm__optionalPart::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__ConnConfirm__optionalPart::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[4];
memset(field_map, 0, sizeof(field_map));
field_credit = OMIT_VALUE;
field_calledPAddress = OMIT_VALUE;
field_data = OMIT_VALUE;
field_importance = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0 && (force_omit == NULL || !(*force_omit)(0))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Credit__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Credit__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 9) {
RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__Credit__opt_descr_.raw->forceomit);
int decoded_field_length = field_credit().RAW_decode(SCCP__param__Credit__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length > 0 && (field_credit.ispresent() && field_credit().paramName() == 9)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_credit = OMIT_VALUE;
}
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__CPartyAddressEnc__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__CPartyAddressEnc__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 3) {
RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__CPartyAddressEnc__opt_descr_.raw->forceomit);
int decoded_field_length = field_calledPAddress().RAW_decode(SCCP__param__CPartyAddressEnc__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0 && (field_calledPAddress.ispresent() && field_calledPAddress().paramName() == 3)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_calledPAddress = OMIT_VALUE;
}
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 15) {
RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__Data__opt_descr_.raw->forceomit);
int decoded_field_length = field_data().RAW_decode(SCCP__param__Data__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0 && (field_data.ispresent() && field_data().paramName() == 15)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_data = OMIT_VALUE;
}
}
}
if (field_map[3] == 0 && (force_omit == NULL || !(*force_omit)(3))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 18) {
RAW_Force_Omit field_3_force_omit(3, force_omit, SCCP__param__Importance__opt_descr_.raw->forceomit);
int decoded_field_length = field_importance().RAW_decode(SCCP__param__Importance__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
if (decoded_field_length > 0 && (field_importance.ispresent() && field_importance().paramName() == 18)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[3] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_importance = OMIT_VALUE;
}
}
}
break;
}
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__ConnConfirm__optionalPart::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  if (field_credit.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__Credit__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_calledPAddress.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__CPartyAddressEnc__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_data.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__Data__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_importance.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, SCCP__param__Importance__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_credit.ispresent()) {
  encoded_length += field_credit().RAW_encode(SCCP__param__Credit__opt_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_calledPAddress.ispresent()) {
  encoded_length += field_calledPAddress().RAW_encode(SCCP__param__CPartyAddressEnc__opt_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_data.ispresent()) {
  encoded_length += field_data().RAW_encode(SCCP__param__Data__opt_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_importance.ispresent()) {
  encoded_length += field_importance().RAW_encode(SCCP__param__Importance__opt_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_credit.ispresent() && (!field_credit.ispresent() || field_credit().paramName() != 9)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 9;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_calledPAddress.ispresent() && (!field_calledPAddress.ispresent() || field_calledPAddress().paramName() != 3)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 3;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_data.ispresent() && (!field_data.ispresent() || field_data().paramName() != 15)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 15;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_importance.ispresent() && (!field_importance.ispresent() || field_importance().paramName() != 18)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 18;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct SCCP__ConnConfirm__optionalPart_template::single_value_struct {
SCCP__param__Credit__opt_template field_credit;
SCCP__param__CPartyAddressEnc__opt_template field_calledPAddress;
SCCP__param__Data__opt_template field_data;
SCCP__param__Importance__opt_template field_importance;
};

void SCCP__ConnConfirm__optionalPart_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_credit = ANY_OR_OMIT;
single_value->field_calledPAddress = ANY_OR_OMIT;
single_value->field_data = ANY_OR_OMIT;
single_value->field_importance = ANY_OR_OMIT;
}
}
}

void SCCP__ConnConfirm__optionalPart_template::copy_value(const SCCP__ConnConfirm__optionalPart& other_value)
{
single_value = new single_value_struct;
if (other_value.credit().is_bound()) {
  if (other_value.credit().ispresent()) single_value->field_credit = other_value.credit()();
  else single_value->field_credit = OMIT_VALUE;
} else {
  single_value->field_credit.clean_up();
}
if (other_value.calledPAddress().is_bound()) {
  if (other_value.calledPAddress().ispresent()) single_value->field_calledPAddress = other_value.calledPAddress()();
  else single_value->field_calledPAddress = OMIT_VALUE;
} else {
  single_value->field_calledPAddress.clean_up();
}
if (other_value.data().is_bound()) {
  if (other_value.data().ispresent()) single_value->field_data = other_value.data()();
  else single_value->field_data = OMIT_VALUE;
} else {
  single_value->field_data.clean_up();
}
if (other_value.importance().is_bound()) {
  if (other_value.importance().ispresent()) single_value->field_importance = other_value.importance()();
  else single_value->field_importance = OMIT_VALUE;
} else {
  single_value->field_importance.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__ConnConfirm__optionalPart_template::copy_template(const SCCP__ConnConfirm__optionalPart_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.credit().get_selection()) {
single_value->field_credit = other_value.credit();
} else {
single_value->field_credit.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.calledPAddress().get_selection()) {
single_value->field_calledPAddress = other_value.calledPAddress();
} else {
single_value->field_calledPAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.importance().get_selection()) {
single_value->field_importance = other_value.importance();
} else {
single_value->field_importance.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__ConnConfirm__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__ConnConfirm__optionalPart_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__ConnConfirm__optionalPart_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
break;
}
set_selection(other_value);
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template()
{
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template(const SCCP__ConnConfirm__optionalPart& other_value)
{
copy_value(other_value);
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template(const OPTIONAL<SCCP__ConnConfirm__optionalPart>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__ConnConfirm__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart from an unbound optional field.");
}
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template(SCCP__ConnConfirm__optionalPart_template* p_precondition, SCCP__ConnConfirm__optionalPart_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template(Dynamic_Match_Interface<SCCP__ConnConfirm__optionalPart>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__ConnConfirm__optionalPart>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__ConnConfirm__optionalPart_template::SCCP__ConnConfirm__optionalPart_template(const SCCP__ConnConfirm__optionalPart_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__ConnConfirm__optionalPart_template::~SCCP__ConnConfirm__optionalPart_template()
{
clean_up();
}

SCCP__ConnConfirm__optionalPart_template& SCCP__ConnConfirm__optionalPart_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__ConnConfirm__optionalPart_template& SCCP__ConnConfirm__optionalPart_template::operator=(const SCCP__ConnConfirm__optionalPart& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__ConnConfirm__optionalPart_template& SCCP__ConnConfirm__optionalPart_template::operator=(const OPTIONAL<SCCP__ConnConfirm__optionalPart>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__ConnConfirm__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
}
return *this;
}

SCCP__ConnConfirm__optionalPart_template& SCCP__ConnConfirm__optionalPart_template::operator=(const SCCP__ConnConfirm__optionalPart_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__ConnConfirm__optionalPart_template::match(const SCCP__ConnConfirm__optionalPart& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.credit().is_bound()) return FALSE;
if((other_value.credit().ispresent() ? !single_value->field_credit.match((const SCCP__param__Credit__opt&)other_value.credit(), legacy) : !single_value->field_credit.match_omit(legacy)))return FALSE;
if(!other_value.calledPAddress().is_bound()) return FALSE;
if((other_value.calledPAddress().ispresent() ? !single_value->field_calledPAddress.match((const SCCP__param__CPartyAddressEnc__opt&)other_value.calledPAddress(), legacy) : !single_value->field_calledPAddress.match_omit(legacy)))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if((other_value.data().ispresent() ? !single_value->field_data.match((const SCCP__param__Data__opt&)other_value.data(), legacy) : !single_value->field_data.match_omit(legacy)))return FALSE;
if(!other_value.importance().is_bound()) return FALSE;
if((other_value.importance().ispresent() ? !single_value->field_importance.match((const SCCP__param__Importance__opt&)other_value.importance(), legacy) : !single_value->field_importance.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
}
return FALSE;
}

boolean SCCP__ConnConfirm__optionalPart_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_credit.is_omit() || single_value->field_credit.is_bound())
 || (single_value->field_calledPAddress.is_omit() || single_value->field_calledPAddress.is_bound())
 || (single_value->field_data.is_omit() || single_value->field_data.is_bound())
 || (single_value->field_importance.is_omit() || single_value->field_importance.is_bound());
}

boolean SCCP__ConnConfirm__optionalPart_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_credit.is_omit() || single_value->field_credit.is_value())
 && (single_value->field_calledPAddress.is_omit() || single_value->field_calledPAddress.is_value())
 && (single_value->field_data.is_omit() || single_value->field_data.is_value())
 && (single_value->field_importance.is_omit() || single_value->field_importance.is_value());
}

void SCCP__ConnConfirm__optionalPart_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__ConnConfirm__optionalPart SCCP__ConnConfirm__optionalPart_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
SCCP__ConnConfirm__optionalPart ret_val;
if (single_value->field_credit.is_omit()) ret_val.credit() = OMIT_VALUE;
else if (single_value->field_credit.is_bound()) {
ret_val.credit() = single_value->field_credit.valueof();
}
if (single_value->field_calledPAddress.is_omit()) ret_val.calledPAddress() = OMIT_VALUE;
else if (single_value->field_calledPAddress.is_bound()) {
ret_val.calledPAddress() = single_value->field_calledPAddress.valueof();
}
if (single_value->field_data.is_omit()) ret_val.data() = OMIT_VALUE;
else if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
if (single_value->field_importance.is_omit()) ret_val.importance() = OMIT_VALUE;
else if (single_value->field_importance.is_bound()) {
ret_val.importance() = single_value->field_importance.valueof();
}
return ret_val;
}

void SCCP__ConnConfirm__optionalPart_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__ConnConfirm__optionalPart_template[list_length];
}

SCCP__ConnConfirm__optionalPart_template& SCCP__ConnConfirm__optionalPart_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
return value_list.list_value[list_index];
}

SCCP__param__Credit__opt_template& SCCP__ConnConfirm__optionalPart_template::credit()
{
set_specific();
return single_value->field_credit;
}

const SCCP__param__Credit__opt_template& SCCP__ConnConfirm__optionalPart_template::credit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field credit of a non-specific template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
return single_value->field_credit;
}

SCCP__param__CPartyAddressEnc__opt_template& SCCP__ConnConfirm__optionalPart_template::calledPAddress()
{
set_specific();
return single_value->field_calledPAddress;
}

const SCCP__param__CPartyAddressEnc__opt_template& SCCP__ConnConfirm__optionalPart_template::calledPAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field calledPAddress of a non-specific template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
return single_value->field_calledPAddress;
}

SCCP__param__Data__opt_template& SCCP__ConnConfirm__optionalPart_template::data()
{
set_specific();
return single_value->field_data;
}

const SCCP__param__Data__opt_template& SCCP__ConnConfirm__optionalPart_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
return single_value->field_data;
}

SCCP__param__Importance__opt_template& SCCP__ConnConfirm__optionalPart_template::importance()
{
set_specific();
return single_value->field_importance;
}

const SCCP__param__Importance__opt_template& SCCP__ConnConfirm__optionalPart_template::importance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field importance of a non-specific template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
return single_value->field_importance;
}

int SCCP__ConnConfirm__optionalPart_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_credit.is_present()) ret_val++;
      if (single_value->field_calledPAddress.is_present()) ret_val++;
      if (single_value->field_data.is_present()) ret_val++;
      if (single_value->field_importance.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
  }
  return 0;
}

void SCCP__ConnConfirm__optionalPart_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ credit := ");
single_value->field_credit.log();
TTCN_Logger::log_event_str(", calledPAddress := ");
single_value->field_calledPAddress.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(", importance := ");
single_value->field_importance.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__ConnConfirm__optionalPart_template::log_match(const SCCP__ConnConfirm__optionalPart& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.credit().ispresent()){
if(!single_value->field_credit.match(match_value.credit(), legacy)){
TTCN_Logger::log_logmatch_info(".credit");
single_value->field_credit.log_match(match_value.credit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_credit.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".credit := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_credit.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.calledPAddress().ispresent()){
if(!single_value->field_calledPAddress.match(match_value.calledPAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".calledPAddress");
single_value->field_calledPAddress.log_match(match_value.calledPAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_calledPAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".calledPAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_calledPAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.data().ispresent()){
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.importance().ispresent()){
if(!single_value->field_importance.match(match_value.importance(), legacy)){
TTCN_Logger::log_logmatch_info(".importance");
single_value->field_importance.log_match(match_value.importance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_importance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".importance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_importance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ credit := ");
if (match_value.credit().ispresent()) {
single_value->field_credit.log_match(match_value.credit(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_credit.log();
if (single_value->field_credit.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", calledPAddress := ");
if (match_value.calledPAddress().ispresent()) {
single_value->field_calledPAddress.log_match(match_value.calledPAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_calledPAddress.log();
if (single_value->field_calledPAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", data := ");
if (match_value.data().ispresent()) {
single_value->field_data.log_match(match_value.data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_data.log();
if (single_value->field_data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", importance := ");
if (match_value.importance().ispresent()) {
single_value->field_importance.log_match(match_value.importance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_importance.log();
if (single_value->field_importance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__ConnConfirm__optionalPart_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!credit().is_bound()) credit() = OMIT_VALUE;
else credit().set_implicit_omit();
if (!calledPAddress().is_bound()) calledPAddress() = OMIT_VALUE;
else calledPAddress().set_implicit_omit();
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__ConnConfirm__optionalPart_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_credit.encode_text(text_buf);
single_value->field_calledPAddress.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
single_value->field_importance.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
}
}

void SCCP__ConnConfirm__optionalPart_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_credit.decode_text(text_buf);
single_value->field_calledPAddress.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
single_value->field_importance.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__ConnConfirm__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart.");
}
}

void SCCP__ConnConfirm__optionalPart_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__ConnConfirm__optionalPart_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("set template of type @SCCP_Types.SCCP_ConnConfirm_optionalPart has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) calledPAddress().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "calledPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          calledPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_ConnConfirm_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__ConnConfirm__optionalPart_template* precondition = new SCCP__ConnConfirm__optionalPart_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__ConnConfirm__optionalPart_template* implied_template = new SCCP__ConnConfirm__optionalPart_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__ConnConfirm__optionalPart_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__ConnConfirm__optionalPart_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_credit.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
single_value->field_calledPAddress.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
single_value->field_importance.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_ConnConfirm_optionalPart");
}

boolean SCCP__ConnConfirm__optionalPart_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__ConnConfirm__optionalPart_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__ConnectionConfirm::PDU__SCCP__ConnectionConfirm()
{
}

PDU__SCCP__ConnectionConfirm::PDU__SCCP__ConnectionConfirm(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const OCTETSTRING& par_sourceLocRef,
    const SCCP__param__ProtocolClass& par_protClass,
    const INTEGER& par_pointer1,
    const OPTIONAL< SCCP__ConnConfirm__optionalPart >& par_optionalPart,
    const OPTIONAL< SCCP__param__EndOfOptionalParams >& par_eop)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_sourceLocRef(par_sourceLocRef),
  field_protClass(par_protClass),
  field_pointer1(par_pointer1),
  field_optionalPart(par_optionalPart),
  field_eop(par_eop)
{
}

PDU__SCCP__ConnectionConfirm::PDU__SCCP__ConnectionConfirm(const PDU__SCCP__ConnectionConfirm& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
else field_sourceLocRef.clean_up();
if (other_value.protClass().is_bound()) field_protClass = other_value.protClass();
else field_protClass.clean_up();
if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
else field_pointer1.clean_up();
if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
else field_optionalPart.clean_up();
if (other_value.eop().is_bound()) field_eop = other_value.eop();
else field_eop.clean_up();
}

void PDU__SCCP__ConnectionConfirm::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_sourceLocRef.clean_up();
field_protClass.clean_up();
field_pointer1.clean_up();
field_optionalPart.clean_up();
field_eop.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__ConnectionConfirm::get_descriptor() const { return &PDU__SCCP__ConnectionConfirm_descr_; }
PDU__SCCP__ConnectionConfirm& PDU__SCCP__ConnectionConfirm::operator=(const PDU__SCCP__ConnectionConfirm& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
  else field_sourceLocRef.clean_up();
  if (other_value.protClass().is_bound()) field_protClass = other_value.protClass();
  else field_protClass.clean_up();
  if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
  else field_pointer1.clean_up();
  if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
  else field_optionalPart.clean_up();
  if (other_value.eop().is_bound()) field_eop = other_value.eop();
  else field_eop.clean_up();
}
return *this;
}

boolean PDU__SCCP__ConnectionConfirm::operator==(const PDU__SCCP__ConnectionConfirm& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_sourceLocRef==other_value.field_sourceLocRef
  && field_protClass==other_value.field_protClass
  && field_pointer1==other_value.field_pointer1
  && field_optionalPart==other_value.field_optionalPart
  && field_eop==other_value.field_eop;
}

boolean PDU__SCCP__ConnectionConfirm::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_sourceLocRef.is_bound())
  || (field_protClass.is_bound())
  || (field_pointer1.is_bound())
  || (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_bound())
  || (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_bound());
}
boolean PDU__SCCP__ConnectionConfirm::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_sourceLocRef.is_value()
  && field_protClass.is_value()
  && field_pointer1.is_value()
  && (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_value())
  && (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_value());
}
int PDU__SCCP__ConnectionConfirm::size_of() const
{
  int ret_val = 5;
  if (field_optionalPart.ispresent()) ret_val++;
  if (field_eop.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SCCP__ConnectionConfirm::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
field_sourceLocRef.log();
TTCN_Logger::log_event_str(", protClass := ");
field_protClass.log();
TTCN_Logger::log_event_str(", pointer1 := ");
field_pointer1.log();
TTCN_Logger::log_event_str(", optionalPart := ");
field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
field_eop.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__ConnectionConfirm::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
if (protClass().is_bound()) protClass().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__ConnectionConfirm::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_ConnectionConfirm has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) protClass().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ConnectionConfirm: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
  }
}

void PDU__SCCP__ConnectionConfirm::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_sourceLocRef.encode_text(text_buf);
field_protClass.encode_text(text_buf);
field_pointer1.encode_text(text_buf);
field_optionalPart.encode_text(text_buf);
field_eop.encode_text(text_buf);
}

void PDU__SCCP__ConnectionConfirm::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_sourceLocRef.decode_text(text_buf);
field_protClass.decode_text(text_buf);
field_pointer1.decode_text(text_buf);
field_optionalPart.decode_text(text_buf);
field_eop.decode_text(text_buf);
}

void PDU__SCCP__ConnectionConfirm::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__ConnectionConfirm::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__ConnectionConfirm::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int end_of_available_data=last_decoded_pos+limit;
  int start_pos_of_field4=-1;
  int start_of_field5=-1;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__SourceLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_sourceLocRef.RAW_decode(SCCP__param__SourceLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, SCCP__param__ProtocolClass_descr_.raw->forceomit);
  decoded_field_length = field_protClass.RAW_decode(SCCP__param__ProtocolClass_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_pos_of_field4=p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PDU__SCCP__ConnectionConfirm_pointer1_descr_.raw->forceomit);
  decoded_field_length = field_pointer1.RAW_decode(PDU__SCCP__ConnectionConfirm_pointer1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field5=(int)field_pointer1+0?1:-1;
  if (limit > 0 && start_of_field5!=-1 && start_pos_of_field4!=-1){
  start_of_field5=start_pos_of_field4+(int)field_pointer1*8+0;
  p_buf.set_pos_bit(start_of_field5);
  limit=end_of_available_data-start_of_field5;
  if (force_omit != NULL && (*force_omit)(5)) {
    field_optionalPart = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, SCCP__ConnConfirm__optionalPart_descr_.raw->forceomit);
  decoded_field_length = field_optionalPart().RAW_decode(SCCP__ConnConfirm__optionalPart_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_optionalPart = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_optionalPart=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_eop = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, SCCP__param__EndOfOptionalParams_descr_.raw->forceomit);
  decoded_field_length = field_eop().RAW_decode(SCCP__param__EndOfOptionalParams_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_eop = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_eop.ispresent() || field_eop().paramName() != 0){
  field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__ConnectionConfirm::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__SourceLocalReference_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, SCCP__param__ProtocolClass_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PDU__SCCP__ConnectionConfirm_pointer1_descr_.raw);
  if (field_optionalPart.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, SCCP__ConnConfirm__optionalPart_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_eop.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, SCCP__param__EndOfOptionalParams_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_sourceLocRef.RAW_encode(SCCP__param__SourceLocalReference_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_protClass.RAW_encode(SCCP__param__ProtocolClass_descr_, *myleaf.body.node.nodes[3]);
  if (field_optionalPart.ispresent()) {
  encoded_length += 8;
  myleaf.body.node.nodes[4]->calc = CALC_POINTER;
  myleaf.body.node.nodes[4]->coding_descr = &PDU__SCCP__ConnectionConfirm_pointer1_descr_;
  myleaf.body.node.nodes[4]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[4]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[4]->calcof.pointerto.ptr_base = 4;
  myleaf.body.node.nodes[4]->calcof.pointerto.target.level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.pointerto.target.pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[4]->length = 8;
  } else {
    INTEGER atm;
    atm = 0;
    encoded_length += atm.RAW_encode(PDU__SCCP__ConnectionConfirm_pointer1_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_optionalPart.ispresent()) {
  encoded_length += field_optionalPart().RAW_encode(SCCP__ConnConfirm__optionalPart_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_eop.ispresent()) {
  encoded_length += field_eop().RAW_encode(SCCP__param__EndOfOptionalParams_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_eop.ispresent() && (!field_eop.ispresent() || field_eop().paramName() != 0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 0;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__ConnectionConfirm_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
OCTETSTRING_template field_sourceLocRef;
SCCP__param__ProtocolClass_template field_protClass;
INTEGER_template field_pointer1;
SCCP__ConnConfirm__optionalPart_template field_optionalPart;
SCCP__param__EndOfOptionalParams_template field_eop;
};

void PDU__SCCP__ConnectionConfirm_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_sourceLocRef = ANY_VALUE;
single_value->field_protClass = ANY_VALUE;
single_value->field_pointer1 = ANY_VALUE;
single_value->field_optionalPart = ANY_OR_OMIT;
single_value->field_eop = ANY_OR_OMIT;
}
}
}

void PDU__SCCP__ConnectionConfirm_template::copy_value(const PDU__SCCP__ConnectionConfirm& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.sourceLocRef().is_bound()) {
  single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
  single_value->field_sourceLocRef.clean_up();
}
if (other_value.protClass().is_bound()) {
  single_value->field_protClass = other_value.protClass();
} else {
  single_value->field_protClass.clean_up();
}
if (other_value.pointer1().is_bound()) {
  single_value->field_pointer1 = other_value.pointer1();
} else {
  single_value->field_pointer1.clean_up();
}
if (other_value.optionalPart().is_bound()) {
  if (other_value.optionalPart().ispresent()) single_value->field_optionalPart = other_value.optionalPart()();
  else single_value->field_optionalPart = OMIT_VALUE;
} else {
  single_value->field_optionalPart.clean_up();
}
if (other_value.eop().is_bound()) {
  if (other_value.eop().ispresent()) single_value->field_eop = other_value.eop()();
  else single_value->field_eop = OMIT_VALUE;
} else {
  single_value->field_eop.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__ConnectionConfirm_template::copy_template(const PDU__SCCP__ConnectionConfirm_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sourceLocRef().get_selection()) {
single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
single_value->field_sourceLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protClass().get_selection()) {
single_value->field_protClass = other_value.protClass();
} else {
single_value->field_protClass.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer1().get_selection()) {
single_value->field_pointer1 = other_value.pointer1();
} else {
single_value->field_pointer1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.optionalPart().get_selection()) {
single_value->field_optionalPart = other_value.optionalPart();
} else {
single_value->field_optionalPart.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eop().get_selection()) {
single_value->field_eop = other_value.eop();
} else {
single_value->field_eop.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__ConnectionConfirm_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__ConnectionConfirm_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__ConnectionConfirm_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
break;
}
set_selection(other_value);
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template()
{
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template(const PDU__SCCP__ConnectionConfirm& other_value)
{
copy_value(other_value);
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template(const OPTIONAL<PDU__SCCP__ConnectionConfirm>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ConnectionConfirm&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm from an unbound optional field.");
}
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template(PDU__SCCP__ConnectionConfirm_template* p_precondition, PDU__SCCP__ConnectionConfirm_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template(Dynamic_Match_Interface<PDU__SCCP__ConnectionConfirm>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__ConnectionConfirm>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__ConnectionConfirm_template::PDU__SCCP__ConnectionConfirm_template(const PDU__SCCP__ConnectionConfirm_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__ConnectionConfirm_template::~PDU__SCCP__ConnectionConfirm_template()
{
clean_up();
}

PDU__SCCP__ConnectionConfirm_template& PDU__SCCP__ConnectionConfirm_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__ConnectionConfirm_template& PDU__SCCP__ConnectionConfirm_template::operator=(const PDU__SCCP__ConnectionConfirm& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__ConnectionConfirm_template& PDU__SCCP__ConnectionConfirm_template::operator=(const OPTIONAL<PDU__SCCP__ConnectionConfirm>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ConnectionConfirm&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
}
return *this;
}

PDU__SCCP__ConnectionConfirm_template& PDU__SCCP__ConnectionConfirm_template::operator=(const PDU__SCCP__ConnectionConfirm_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__ConnectionConfirm_template::match(const PDU__SCCP__ConnectionConfirm& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.sourceLocRef().is_bound()) return FALSE;
if(!single_value->field_sourceLocRef.match(other_value.sourceLocRef(), legacy))return FALSE;
if(!other_value.protClass().is_bound()) return FALSE;
if(!single_value->field_protClass.match(other_value.protClass(), legacy))return FALSE;
if(!other_value.pointer1().is_bound()) return FALSE;
if(!single_value->field_pointer1.match(other_value.pointer1(), legacy))return FALSE;
if(!other_value.optionalPart().is_bound()) return FALSE;
if((other_value.optionalPart().ispresent() ? !single_value->field_optionalPart.match((const SCCP__ConnConfirm__optionalPart&)other_value.optionalPart(), legacy) : !single_value->field_optionalPart.match_omit(legacy)))return FALSE;
if(!other_value.eop().is_bound()) return FALSE;
if((other_value.eop().ispresent() ? !single_value->field_eop.match((const SCCP__param__EndOfOptionalParams&)other_value.eop(), legacy) : !single_value->field_eop.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
}
return FALSE;
}

boolean PDU__SCCP__ConnectionConfirm_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_sourceLocRef.is_bound()
 || single_value->field_protClass.is_bound()
 || single_value->field_pointer1.is_bound()
 || (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_bound())
 || (single_value->field_eop.is_omit() || single_value->field_eop.is_bound());
}

boolean PDU__SCCP__ConnectionConfirm_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_sourceLocRef.is_value()
 && single_value->field_protClass.is_value()
 && single_value->field_pointer1.is_value()
 && (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_value())
 && (single_value->field_eop.is_omit() || single_value->field_eop.is_value());
}

void PDU__SCCP__ConnectionConfirm_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__ConnectionConfirm PDU__SCCP__ConnectionConfirm_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
PDU__SCCP__ConnectionConfirm ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_sourceLocRef.is_bound()) {
ret_val.sourceLocRef() = single_value->field_sourceLocRef.valueof();
}
if (single_value->field_protClass.is_bound()) {
ret_val.protClass() = single_value->field_protClass.valueof();
}
if (single_value->field_pointer1.is_bound()) {
ret_val.pointer1() = single_value->field_pointer1.valueof();
}
if (single_value->field_optionalPart.is_omit()) ret_val.optionalPart() = OMIT_VALUE;
else if (single_value->field_optionalPart.is_bound()) {
ret_val.optionalPart() = single_value->field_optionalPart.valueof();
}
if (single_value->field_eop.is_omit()) ret_val.eop() = OMIT_VALUE;
else if (single_value->field_eop.is_bound()) {
ret_val.eop() = single_value->field_eop.valueof();
}
return ret_val;
}

void PDU__SCCP__ConnectionConfirm_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__ConnectionConfirm_template[list_length];
}

PDU__SCCP__ConnectionConfirm_template& PDU__SCCP__ConnectionConfirm_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__ConnectionConfirm_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__ConnectionConfirm_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__ConnectionConfirm_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__ConnectionConfirm_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_destLocRef;
}

OCTETSTRING_template& PDU__SCCP__ConnectionConfirm_template::sourceLocRef()
{
set_specific();
return single_value->field_sourceLocRef;
}

const OCTETSTRING_template& PDU__SCCP__ConnectionConfirm_template::sourceLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sourceLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_sourceLocRef;
}

SCCP__param__ProtocolClass_template& PDU__SCCP__ConnectionConfirm_template::protClass()
{
set_specific();
return single_value->field_protClass;
}

const SCCP__param__ProtocolClass_template& PDU__SCCP__ConnectionConfirm_template::protClass() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protClass of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_protClass;
}

INTEGER_template& PDU__SCCP__ConnectionConfirm_template::pointer1()
{
set_specific();
return single_value->field_pointer1;
}

const INTEGER_template& PDU__SCCP__ConnectionConfirm_template::pointer1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer1 of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_pointer1;
}

SCCP__ConnConfirm__optionalPart_template& PDU__SCCP__ConnectionConfirm_template::optionalPart()
{
set_specific();
return single_value->field_optionalPart;
}

const SCCP__ConnConfirm__optionalPart_template& PDU__SCCP__ConnectionConfirm_template::optionalPart() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field optionalPart of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_optionalPart;
}

SCCP__param__EndOfOptionalParams_template& PDU__SCCP__ConnectionConfirm_template::eop()
{
set_specific();
return single_value->field_eop;
}

const SCCP__param__EndOfOptionalParams_template& PDU__SCCP__ConnectionConfirm_template::eop() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eop of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
return single_value->field_eop;
}

int PDU__SCCP__ConnectionConfirm_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_optionalPart.is_present()) ret_val++;
      if (single_value->field_eop.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
  }
  return 0;
}

void PDU__SCCP__ConnectionConfirm_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log();
TTCN_Logger::log_event_str(", protClass := ");
single_value->field_protClass.log();
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log();
TTCN_Logger::log_event_str(", optionalPart := ");
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
single_value->field_eop.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__ConnectionConfirm_template::log_match(const PDU__SCCP__ConnectionConfirm& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sourceLocRef.match(match_value.sourceLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".sourceLocRef");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_protClass.match(match_value.protClass(), legacy)){
TTCN_Logger::log_logmatch_info(".protClass");
single_value->field_protClass.log_match(match_value.protClass(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer1.match(match_value.pointer1(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer1");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.optionalPart().ispresent()){
if(!single_value->field_optionalPart.match(match_value.optionalPart(), legacy)){
TTCN_Logger::log_logmatch_info(".optionalPart");
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_optionalPart.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".optionalPart := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.eop().ispresent()){
if(!single_value->field_eop.match(match_value.eop(), legacy)){
TTCN_Logger::log_logmatch_info(".eop");
single_value->field_eop.log_match(match_value.eop(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_eop.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".eop := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_eop.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::log_event_str(", protClass := ");
single_value->field_protClass.log_match(match_value.protClass(), legacy);
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::log_event_str(", optionalPart := ");
if (match_value.optionalPart().ispresent()) {
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_optionalPart.log();
if (single_value->field_optionalPart.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", eop := ");
if (match_value.eop().ispresent()) {
single_value->field_eop.log_match(match_value.eop(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_eop.log();
if (single_value->field_eop.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__ConnectionConfirm_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
if (protClass().is_bound()) protClass().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__ConnectionConfirm_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_sourceLocRef.encode_text(text_buf);
single_value->field_protClass.encode_text(text_buf);
single_value->field_pointer1.encode_text(text_buf);
single_value->field_optionalPart.encode_text(text_buf);
single_value->field_eop.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
}
}

void PDU__SCCP__ConnectionConfirm_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_sourceLocRef.decode_text(text_buf);
single_value->field_protClass.decode_text(text_buf);
single_value->field_pointer1.decode_text(text_buf);
single_value->field_optionalPart.decode_text(text_buf);
single_value->field_eop.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__ConnectionConfirm_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm.");
}
}

void PDU__SCCP__ConnectionConfirm_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__ConnectionConfirm_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_ConnectionConfirm has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) protClass().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ConnectionConfirm: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__ConnectionConfirm_template* precondition = new PDU__SCCP__ConnectionConfirm_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__ConnectionConfirm_template* implied_template = new PDU__SCCP__ConnectionConfirm_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__ConnectionConfirm_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__ConnectionConfirm_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
single_value->field_sourceLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
single_value->field_protClass.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
single_value->field_pointer1.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
single_value->field_optionalPart.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
single_value->field_eop.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionConfirm");
}

boolean PDU__SCCP__ConnectionConfirm_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__ConnectionConfirm_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__ConnRefused__optionalPart::SCCP__ConnRefused__optionalPart()
{
}

SCCP__ConnRefused__optionalPart::SCCP__ConnRefused__optionalPart(const OPTIONAL< SCCP__param__CPartyAddressEnc__opt >& par_calledPAddress,
    const OPTIONAL< SCCP__param__Data__opt >& par_data,
    const OPTIONAL< SCCP__param__Importance__opt >& par_importance)
  :   field_calledPAddress(par_calledPAddress),
  field_data(par_data),
  field_importance(par_importance)
{
}

SCCP__ConnRefused__optionalPart::SCCP__ConnRefused__optionalPart(const SCCP__ConnRefused__optionalPart& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
if (other_value.calledPAddress().is_bound()) field_calledPAddress = other_value.calledPAddress();
else field_calledPAddress.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
if (other_value.importance().is_bound()) field_importance = other_value.importance();
else field_importance.clean_up();
}

void SCCP__ConnRefused__optionalPart::clean_up()
{
field_calledPAddress.clean_up();
field_data.clean_up();
field_importance.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__ConnRefused__optionalPart::get_descriptor() const { return &SCCP__ConnRefused__optionalPart_descr_; }
SCCP__ConnRefused__optionalPart& SCCP__ConnRefused__optionalPart::operator=(const SCCP__ConnRefused__optionalPart& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
  if (other_value.calledPAddress().is_bound()) field_calledPAddress = other_value.calledPAddress();
  else field_calledPAddress.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
  if (other_value.importance().is_bound()) field_importance = other_value.importance();
  else field_importance.clean_up();
}
return *this;
}

boolean SCCP__ConnRefused__optionalPart::operator==(const SCCP__ConnRefused__optionalPart& other_value) const
{
return field_calledPAddress==other_value.field_calledPAddress
  && field_data==other_value.field_data
  && field_importance==other_value.field_importance;
}

boolean SCCP__ConnRefused__optionalPart::is_bound() const
{
return (OPTIONAL_OMIT == field_calledPAddress.get_selection() || field_calledPAddress.is_bound())
  || (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_bound())
  || (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_bound());
}
boolean SCCP__ConnRefused__optionalPart::is_value() const
{
return (OPTIONAL_OMIT == field_calledPAddress.get_selection() || field_calledPAddress.is_value())
  && (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_value())
  && (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_value());
}
int SCCP__ConnRefused__optionalPart::size_of() const
{
  int ret_val = 0;
  if (field_calledPAddress.ispresent()) ret_val++;
  if (field_data.ispresent()) ret_val++;
  if (field_importance.ispresent()) ret_val++;
  return ret_val;
}

void SCCP__ConnRefused__optionalPart::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ calledPAddress := ");
field_calledPAddress.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(", importance := ");
field_importance.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__ConnRefused__optionalPart::set_implicit_omit()
{
if (!calledPAddress().is_bound()) calledPAddress() = OMIT_VALUE;
else calledPAddress().set_implicit_omit();
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__ConnRefused__optionalPart::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("set value of type @SCCP_Types.SCCP_ConnRefused_optionalPart has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) calledPAddress().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "calledPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          calledPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_ConnRefused_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@SCCP_Types.SCCP_ConnRefused_optionalPart");
  }
}

void SCCP__ConnRefused__optionalPart::encode_text(Text_Buf& text_buf) const
{
field_calledPAddress.encode_text(text_buf);
field_data.encode_text(text_buf);
field_importance.encode_text(text_buf);
}

void SCCP__ConnRefused__optionalPart::decode_text(Text_Buf& text_buf)
{
field_calledPAddress.decode_text(text_buf);
field_data.decode_text(text_buf);
field_importance.decode_text(text_buf);
}

void SCCP__ConnRefused__optionalPart::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__ConnRefused__optionalPart::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__ConnRefused__optionalPart::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[3];
memset(field_map, 0, sizeof(field_map));
field_calledPAddress = OMIT_VALUE;
field_data = OMIT_VALUE;
field_importance = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0 && (force_omit == NULL || !(*force_omit)(0))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__CPartyAddressEnc__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__CPartyAddressEnc__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 3) {
RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__CPartyAddressEnc__opt_descr_.raw->forceomit);
int decoded_field_length = field_calledPAddress().RAW_decode(SCCP__param__CPartyAddressEnc__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length > 0 && (field_calledPAddress.ispresent() && field_calledPAddress().paramName() == 3)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_calledPAddress = OMIT_VALUE;
}
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 15) {
RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__Data__opt_descr_.raw->forceomit);
int decoded_field_length = field_data().RAW_decode(SCCP__param__Data__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0 && (field_data.ispresent() && field_data().paramName() == 15)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_data = OMIT_VALUE;
}
}
}
if (field_map[2] == 0 && (force_omit == NULL || !(*force_omit)(2))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 18) {
RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__Importance__opt_descr_.raw->forceomit);
int decoded_field_length = field_importance().RAW_decode(SCCP__param__Importance__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
if (decoded_field_length > 0 && (field_importance.ispresent() && field_importance().paramName() == 18)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[2] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_importance = OMIT_VALUE;
}
}
}
break;
}
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__ConnRefused__optionalPart::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  if (field_calledPAddress.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__CPartyAddressEnc__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_data.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__Data__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_importance.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__Importance__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_calledPAddress.ispresent()) {
  encoded_length += field_calledPAddress().RAW_encode(SCCP__param__CPartyAddressEnc__opt_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_data.ispresent()) {
  encoded_length += field_data().RAW_encode(SCCP__param__Data__opt_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_importance.ispresent()) {
  encoded_length += field_importance().RAW_encode(SCCP__param__Importance__opt_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_calledPAddress.ispresent() && (!field_calledPAddress.ispresent() || field_calledPAddress().paramName() != 3)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 3;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_data.ispresent() && (!field_data.ispresent() || field_data().paramName() != 15)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 15;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_importance.ispresent() && (!field_importance.ispresent() || field_importance().paramName() != 18)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 18;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct SCCP__ConnRefused__optionalPart_template::single_value_struct {
SCCP__param__CPartyAddressEnc__opt_template field_calledPAddress;
SCCP__param__Data__opt_template field_data;
SCCP__param__Importance__opt_template field_importance;
};

void SCCP__ConnRefused__optionalPart_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_calledPAddress = ANY_OR_OMIT;
single_value->field_data = ANY_OR_OMIT;
single_value->field_importance = ANY_OR_OMIT;
}
}
}

void SCCP__ConnRefused__optionalPart_template::copy_value(const SCCP__ConnRefused__optionalPart& other_value)
{
single_value = new single_value_struct;
if (other_value.calledPAddress().is_bound()) {
  if (other_value.calledPAddress().ispresent()) single_value->field_calledPAddress = other_value.calledPAddress()();
  else single_value->field_calledPAddress = OMIT_VALUE;
} else {
  single_value->field_calledPAddress.clean_up();
}
if (other_value.data().is_bound()) {
  if (other_value.data().ispresent()) single_value->field_data = other_value.data()();
  else single_value->field_data = OMIT_VALUE;
} else {
  single_value->field_data.clean_up();
}
if (other_value.importance().is_bound()) {
  if (other_value.importance().ispresent()) single_value->field_importance = other_value.importance()();
  else single_value->field_importance = OMIT_VALUE;
} else {
  single_value->field_importance.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__ConnRefused__optionalPart_template::copy_template(const SCCP__ConnRefused__optionalPart_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.calledPAddress().get_selection()) {
single_value->field_calledPAddress = other_value.calledPAddress();
} else {
single_value->field_calledPAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.importance().get_selection()) {
single_value->field_importance = other_value.importance();
} else {
single_value->field_importance.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__ConnRefused__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__ConnRefused__optionalPart_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__ConnRefused__optionalPart_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
break;
}
set_selection(other_value);
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template()
{
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template(const SCCP__ConnRefused__optionalPart& other_value)
{
copy_value(other_value);
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template(const OPTIONAL<SCCP__ConnRefused__optionalPart>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__ConnRefused__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart from an unbound optional field.");
}
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template(SCCP__ConnRefused__optionalPart_template* p_precondition, SCCP__ConnRefused__optionalPart_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template(Dynamic_Match_Interface<SCCP__ConnRefused__optionalPart>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__ConnRefused__optionalPart>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__ConnRefused__optionalPart_template::SCCP__ConnRefused__optionalPart_template(const SCCP__ConnRefused__optionalPart_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__ConnRefused__optionalPart_template::~SCCP__ConnRefused__optionalPart_template()
{
clean_up();
}

SCCP__ConnRefused__optionalPart_template& SCCP__ConnRefused__optionalPart_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__ConnRefused__optionalPart_template& SCCP__ConnRefused__optionalPart_template::operator=(const SCCP__ConnRefused__optionalPart& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__ConnRefused__optionalPart_template& SCCP__ConnRefused__optionalPart_template::operator=(const OPTIONAL<SCCP__ConnRefused__optionalPart>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__ConnRefused__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
}
return *this;
}

SCCP__ConnRefused__optionalPart_template& SCCP__ConnRefused__optionalPart_template::operator=(const SCCP__ConnRefused__optionalPart_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__ConnRefused__optionalPart_template::match(const SCCP__ConnRefused__optionalPart& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.calledPAddress().is_bound()) return FALSE;
if((other_value.calledPAddress().ispresent() ? !single_value->field_calledPAddress.match((const SCCP__param__CPartyAddressEnc__opt&)other_value.calledPAddress(), legacy) : !single_value->field_calledPAddress.match_omit(legacy)))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if((other_value.data().ispresent() ? !single_value->field_data.match((const SCCP__param__Data__opt&)other_value.data(), legacy) : !single_value->field_data.match_omit(legacy)))return FALSE;
if(!other_value.importance().is_bound()) return FALSE;
if((other_value.importance().ispresent() ? !single_value->field_importance.match((const SCCP__param__Importance__opt&)other_value.importance(), legacy) : !single_value->field_importance.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
}
return FALSE;
}

boolean SCCP__ConnRefused__optionalPart_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_calledPAddress.is_omit() || single_value->field_calledPAddress.is_bound())
 || (single_value->field_data.is_omit() || single_value->field_data.is_bound())
 || (single_value->field_importance.is_omit() || single_value->field_importance.is_bound());
}

boolean SCCP__ConnRefused__optionalPart_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_calledPAddress.is_omit() || single_value->field_calledPAddress.is_value())
 && (single_value->field_data.is_omit() || single_value->field_data.is_value())
 && (single_value->field_importance.is_omit() || single_value->field_importance.is_value());
}

void SCCP__ConnRefused__optionalPart_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__ConnRefused__optionalPart SCCP__ConnRefused__optionalPart_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
SCCP__ConnRefused__optionalPart ret_val;
if (single_value->field_calledPAddress.is_omit()) ret_val.calledPAddress() = OMIT_VALUE;
else if (single_value->field_calledPAddress.is_bound()) {
ret_val.calledPAddress() = single_value->field_calledPAddress.valueof();
}
if (single_value->field_data.is_omit()) ret_val.data() = OMIT_VALUE;
else if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
if (single_value->field_importance.is_omit()) ret_val.importance() = OMIT_VALUE;
else if (single_value->field_importance.is_bound()) {
ret_val.importance() = single_value->field_importance.valueof();
}
return ret_val;
}

void SCCP__ConnRefused__optionalPart_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__ConnRefused__optionalPart_template[list_length];
}

SCCP__ConnRefused__optionalPart_template& SCCP__ConnRefused__optionalPart_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
return value_list.list_value[list_index];
}

SCCP__param__CPartyAddressEnc__opt_template& SCCP__ConnRefused__optionalPart_template::calledPAddress()
{
set_specific();
return single_value->field_calledPAddress;
}

const SCCP__param__CPartyAddressEnc__opt_template& SCCP__ConnRefused__optionalPart_template::calledPAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field calledPAddress of a non-specific template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
return single_value->field_calledPAddress;
}

SCCP__param__Data__opt_template& SCCP__ConnRefused__optionalPart_template::data()
{
set_specific();
return single_value->field_data;
}

const SCCP__param__Data__opt_template& SCCP__ConnRefused__optionalPart_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
return single_value->field_data;
}

SCCP__param__Importance__opt_template& SCCP__ConnRefused__optionalPart_template::importance()
{
set_specific();
return single_value->field_importance;
}

const SCCP__param__Importance__opt_template& SCCP__ConnRefused__optionalPart_template::importance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field importance of a non-specific template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
return single_value->field_importance;
}

int SCCP__ConnRefused__optionalPart_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_calledPAddress.is_present()) ret_val++;
      if (single_value->field_data.is_present()) ret_val++;
      if (single_value->field_importance.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
  }
  return 0;
}

void SCCP__ConnRefused__optionalPart_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ calledPAddress := ");
single_value->field_calledPAddress.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(", importance := ");
single_value->field_importance.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__ConnRefused__optionalPart_template::log_match(const SCCP__ConnRefused__optionalPart& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.calledPAddress().ispresent()){
if(!single_value->field_calledPAddress.match(match_value.calledPAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".calledPAddress");
single_value->field_calledPAddress.log_match(match_value.calledPAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_calledPAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".calledPAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_calledPAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.data().ispresent()){
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.importance().ispresent()){
if(!single_value->field_importance.match(match_value.importance(), legacy)){
TTCN_Logger::log_logmatch_info(".importance");
single_value->field_importance.log_match(match_value.importance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_importance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".importance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_importance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ calledPAddress := ");
if (match_value.calledPAddress().ispresent()) {
single_value->field_calledPAddress.log_match(match_value.calledPAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_calledPAddress.log();
if (single_value->field_calledPAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", data := ");
if (match_value.data().ispresent()) {
single_value->field_data.log_match(match_value.data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_data.log();
if (single_value->field_data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", importance := ");
if (match_value.importance().ispresent()) {
single_value->field_importance.log_match(match_value.importance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_importance.log();
if (single_value->field_importance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__ConnRefused__optionalPart_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!calledPAddress().is_bound()) calledPAddress() = OMIT_VALUE;
else calledPAddress().set_implicit_omit();
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__ConnRefused__optionalPart_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_calledPAddress.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
single_value->field_importance.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
}
}

void SCCP__ConnRefused__optionalPart_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_calledPAddress.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
single_value->field_importance.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__ConnRefused__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_ConnRefused_optionalPart.");
}
}

void SCCP__ConnRefused__optionalPart_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__ConnRefused__optionalPart_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("set template of type @SCCP_Types.SCCP_ConnRefused_optionalPart has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) calledPAddress().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "calledPAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          calledPAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_ConnRefused_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__ConnRefused__optionalPart_template* precondition = new SCCP__ConnRefused__optionalPart_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__ConnRefused__optionalPart_template* implied_template = new SCCP__ConnRefused__optionalPart_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__ConnRefused__optionalPart_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@SCCP_Types.SCCP_ConnRefused_optionalPart");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__ConnRefused__optionalPart_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_calledPAddress.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnRefused_optionalPart");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnRefused_optionalPart");
single_value->field_importance.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_ConnRefused_optionalPart");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_ConnRefused_optionalPart");
}

boolean SCCP__ConnRefused__optionalPart_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__ConnRefused__optionalPart_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__ConnectionRefused::PDU__SCCP__ConnectionRefused()
{
}

PDU__SCCP__ConnectionRefused::PDU__SCCP__ConnectionRefused(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const INTEGER& par_refusalCause,
    const INTEGER& par_pointer1,
    const OPTIONAL< SCCP__ConnRefused__optionalPart >& par_optionalPart,
    const OPTIONAL< SCCP__param__EndOfOptionalParams >& par_eop)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_refusalCause(par_refusalCause),
  field_pointer1(par_pointer1),
  field_optionalPart(par_optionalPart),
  field_eop(par_eop)
{
}

PDU__SCCP__ConnectionRefused::PDU__SCCP__ConnectionRefused(const PDU__SCCP__ConnectionRefused& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.refusalCause().is_bound()) field_refusalCause = other_value.refusalCause();
else field_refusalCause.clean_up();
if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
else field_pointer1.clean_up();
if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
else field_optionalPart.clean_up();
if (other_value.eop().is_bound()) field_eop = other_value.eop();
else field_eop.clean_up();
}

void PDU__SCCP__ConnectionRefused::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_refusalCause.clean_up();
field_pointer1.clean_up();
field_optionalPart.clean_up();
field_eop.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__ConnectionRefused::get_descriptor() const { return &PDU__SCCP__ConnectionRefused_descr_; }
PDU__SCCP__ConnectionRefused& PDU__SCCP__ConnectionRefused::operator=(const PDU__SCCP__ConnectionRefused& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.refusalCause().is_bound()) field_refusalCause = other_value.refusalCause();
  else field_refusalCause.clean_up();
  if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
  else field_pointer1.clean_up();
  if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
  else field_optionalPart.clean_up();
  if (other_value.eop().is_bound()) field_eop = other_value.eop();
  else field_eop.clean_up();
}
return *this;
}

boolean PDU__SCCP__ConnectionRefused::operator==(const PDU__SCCP__ConnectionRefused& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_refusalCause==other_value.field_refusalCause
  && field_pointer1==other_value.field_pointer1
  && field_optionalPart==other_value.field_optionalPart
  && field_eop==other_value.field_eop;
}

boolean PDU__SCCP__ConnectionRefused::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_refusalCause.is_bound())
  || (field_pointer1.is_bound())
  || (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_bound())
  || (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_bound());
}
boolean PDU__SCCP__ConnectionRefused::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_refusalCause.is_value()
  && field_pointer1.is_value()
  && (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_value())
  && (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_value());
}
int PDU__SCCP__ConnectionRefused::size_of() const
{
  int ret_val = 4;
  if (field_optionalPart.ispresent()) ret_val++;
  if (field_eop.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SCCP__ConnectionRefused::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", refusalCause := ");
field_refusalCause.log();
TTCN_Logger::log_event_str(", pointer1 := ");
field_pointer1.log();
TTCN_Logger::log_event_str(", optionalPart := ");
field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
field_eop.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__ConnectionRefused::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (refusalCause().is_bound()) refusalCause().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__ConnectionRefused::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_ConnectionRefused has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) refusalCause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "refusalCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          refusalCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ConnectionRefused: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_ConnectionRefused");
  }
}

void PDU__SCCP__ConnectionRefused::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_refusalCause.encode_text(text_buf);
field_pointer1.encode_text(text_buf);
field_optionalPart.encode_text(text_buf);
field_eop.encode_text(text_buf);
}

void PDU__SCCP__ConnectionRefused::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_refusalCause.decode_text(text_buf);
field_pointer1.decode_text(text_buf);
field_optionalPart.decode_text(text_buf);
field_eop.decode_text(text_buf);
}

void PDU__SCCP__ConnectionRefused::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__ConnectionRefused::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__ConnectionRefused::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int end_of_available_data=last_decoded_pos+limit;
  int start_pos_of_field3=-1;
  int start_of_field4=-1;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__RefusalCause_descr_.raw->forceomit);
  decoded_field_length = field_refusalCause.RAW_decode(SCCP__param__RefusalCause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_pos_of_field3=p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, PDU__SCCP__ConnectionRefused_pointer1_descr_.raw->forceomit);
  decoded_field_length = field_pointer1.RAW_decode(PDU__SCCP__ConnectionRefused_pointer1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field4=(int)field_pointer1+0?1:-1;
  if (limit > 0 && start_of_field4!=-1 && start_pos_of_field3!=-1){
  start_of_field4=start_pos_of_field3+(int)field_pointer1*8+0;
  p_buf.set_pos_bit(start_of_field4);
  limit=end_of_available_data-start_of_field4;
  if (force_omit != NULL && (*force_omit)(4)) {
    field_optionalPart = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, SCCP__ConnRefused__optionalPart_descr_.raw->forceomit);
  decoded_field_length = field_optionalPart().RAW_decode(SCCP__ConnRefused__optionalPart_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_optionalPart = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_optionalPart=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_eop = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, SCCP__param__EndOfOptionalParams_descr_.raw->forceomit);
  decoded_field_length = field_eop().RAW_decode(SCCP__param__EndOfOptionalParams_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_eop = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_eop.ispresent() || field_eop().paramName() != 0){
  field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__ConnectionRefused::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__RefusalCause_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PDU__SCCP__ConnectionRefused_pointer1_descr_.raw);
  if (field_optionalPart.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, SCCP__ConnRefused__optionalPart_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_eop.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, SCCP__param__EndOfOptionalParams_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_refusalCause.RAW_encode(SCCP__param__RefusalCause_descr_, *myleaf.body.node.nodes[2]);
  if (field_optionalPart.ispresent()) {
  encoded_length += 8;
  myleaf.body.node.nodes[3]->calc = CALC_POINTER;
  myleaf.body.node.nodes[3]->coding_descr = &PDU__SCCP__ConnectionRefused_pointer1_descr_;
  myleaf.body.node.nodes[3]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_base = 3;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[3]->length = 8;
  } else {
    INTEGER atm;
    atm = 0;
    encoded_length += atm.RAW_encode(PDU__SCCP__ConnectionRefused_pointer1_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_optionalPart.ispresent()) {
  encoded_length += field_optionalPart().RAW_encode(SCCP__ConnRefused__optionalPart_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_eop.ispresent()) {
  encoded_length += field_eop().RAW_encode(SCCP__param__EndOfOptionalParams_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_eop.ispresent() && (!field_eop.ispresent() || field_eop().paramName() != 0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 0;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__ConnectionRefused_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
INTEGER_template field_refusalCause;
INTEGER_template field_pointer1;
SCCP__ConnRefused__optionalPart_template field_optionalPart;
SCCP__param__EndOfOptionalParams_template field_eop;
};

void PDU__SCCP__ConnectionRefused_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_refusalCause = ANY_VALUE;
single_value->field_pointer1 = ANY_VALUE;
single_value->field_optionalPart = ANY_OR_OMIT;
single_value->field_eop = ANY_OR_OMIT;
}
}
}

void PDU__SCCP__ConnectionRefused_template::copy_value(const PDU__SCCP__ConnectionRefused& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.refusalCause().is_bound()) {
  single_value->field_refusalCause = other_value.refusalCause();
} else {
  single_value->field_refusalCause.clean_up();
}
if (other_value.pointer1().is_bound()) {
  single_value->field_pointer1 = other_value.pointer1();
} else {
  single_value->field_pointer1.clean_up();
}
if (other_value.optionalPart().is_bound()) {
  if (other_value.optionalPart().ispresent()) single_value->field_optionalPart = other_value.optionalPart()();
  else single_value->field_optionalPart = OMIT_VALUE;
} else {
  single_value->field_optionalPart.clean_up();
}
if (other_value.eop().is_bound()) {
  if (other_value.eop().ispresent()) single_value->field_eop = other_value.eop()();
  else single_value->field_eop = OMIT_VALUE;
} else {
  single_value->field_eop.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__ConnectionRefused_template::copy_template(const PDU__SCCP__ConnectionRefused_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.refusalCause().get_selection()) {
single_value->field_refusalCause = other_value.refusalCause();
} else {
single_value->field_refusalCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer1().get_selection()) {
single_value->field_pointer1 = other_value.pointer1();
} else {
single_value->field_pointer1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.optionalPart().get_selection()) {
single_value->field_optionalPart = other_value.optionalPart();
} else {
single_value->field_optionalPart.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eop().get_selection()) {
single_value->field_eop = other_value.eop();
} else {
single_value->field_eop.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__ConnectionRefused_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__ConnectionRefused_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__ConnectionRefused_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
break;
}
set_selection(other_value);
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template()
{
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template(const PDU__SCCP__ConnectionRefused& other_value)
{
copy_value(other_value);
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template(const OPTIONAL<PDU__SCCP__ConnectionRefused>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ConnectionRefused&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused from an unbound optional field.");
}
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template(PDU__SCCP__ConnectionRefused_template* p_precondition, PDU__SCCP__ConnectionRefused_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template(Dynamic_Match_Interface<PDU__SCCP__ConnectionRefused>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__ConnectionRefused>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__ConnectionRefused_template::PDU__SCCP__ConnectionRefused_template(const PDU__SCCP__ConnectionRefused_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__ConnectionRefused_template::~PDU__SCCP__ConnectionRefused_template()
{
clean_up();
}

PDU__SCCP__ConnectionRefused_template& PDU__SCCP__ConnectionRefused_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__ConnectionRefused_template& PDU__SCCP__ConnectionRefused_template::operator=(const PDU__SCCP__ConnectionRefused& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__ConnectionRefused_template& PDU__SCCP__ConnectionRefused_template::operator=(const OPTIONAL<PDU__SCCP__ConnectionRefused>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ConnectionRefused&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
}
return *this;
}

PDU__SCCP__ConnectionRefused_template& PDU__SCCP__ConnectionRefused_template::operator=(const PDU__SCCP__ConnectionRefused_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__ConnectionRefused_template::match(const PDU__SCCP__ConnectionRefused& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.refusalCause().is_bound()) return FALSE;
if(!single_value->field_refusalCause.match(other_value.refusalCause(), legacy))return FALSE;
if(!other_value.pointer1().is_bound()) return FALSE;
if(!single_value->field_pointer1.match(other_value.pointer1(), legacy))return FALSE;
if(!other_value.optionalPart().is_bound()) return FALSE;
if((other_value.optionalPart().ispresent() ? !single_value->field_optionalPart.match((const SCCP__ConnRefused__optionalPart&)other_value.optionalPart(), legacy) : !single_value->field_optionalPart.match_omit(legacy)))return FALSE;
if(!other_value.eop().is_bound()) return FALSE;
if((other_value.eop().ispresent() ? !single_value->field_eop.match((const SCCP__param__EndOfOptionalParams&)other_value.eop(), legacy) : !single_value->field_eop.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
}
return FALSE;
}

boolean PDU__SCCP__ConnectionRefused_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_refusalCause.is_bound()
 || single_value->field_pointer1.is_bound()
 || (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_bound())
 || (single_value->field_eop.is_omit() || single_value->field_eop.is_bound());
}

boolean PDU__SCCP__ConnectionRefused_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_refusalCause.is_value()
 && single_value->field_pointer1.is_value()
 && (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_value())
 && (single_value->field_eop.is_omit() || single_value->field_eop.is_value());
}

void PDU__SCCP__ConnectionRefused_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__ConnectionRefused PDU__SCCP__ConnectionRefused_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
PDU__SCCP__ConnectionRefused ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_refusalCause.is_bound()) {
ret_val.refusalCause() = single_value->field_refusalCause.valueof();
}
if (single_value->field_pointer1.is_bound()) {
ret_val.pointer1() = single_value->field_pointer1.valueof();
}
if (single_value->field_optionalPart.is_omit()) ret_val.optionalPart() = OMIT_VALUE;
else if (single_value->field_optionalPart.is_bound()) {
ret_val.optionalPart() = single_value->field_optionalPart.valueof();
}
if (single_value->field_eop.is_omit()) ret_val.eop() = OMIT_VALUE;
else if (single_value->field_eop.is_bound()) {
ret_val.eop() = single_value->field_eop.valueof();
}
return ret_val;
}

void PDU__SCCP__ConnectionRefused_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__ConnectionRefused_template[list_length];
}

PDU__SCCP__ConnectionRefused_template& PDU__SCCP__ConnectionRefused_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__ConnectionRefused_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__ConnectionRefused_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__ConnectionRefused_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__ConnectionRefused_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return single_value->field_destLocRef;
}

INTEGER_template& PDU__SCCP__ConnectionRefused_template::refusalCause()
{
set_specific();
return single_value->field_refusalCause;
}

const INTEGER_template& PDU__SCCP__ConnectionRefused_template::refusalCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field refusalCause of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return single_value->field_refusalCause;
}

INTEGER_template& PDU__SCCP__ConnectionRefused_template::pointer1()
{
set_specific();
return single_value->field_pointer1;
}

const INTEGER_template& PDU__SCCP__ConnectionRefused_template::pointer1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer1 of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return single_value->field_pointer1;
}

SCCP__ConnRefused__optionalPart_template& PDU__SCCP__ConnectionRefused_template::optionalPart()
{
set_specific();
return single_value->field_optionalPart;
}

const SCCP__ConnRefused__optionalPart_template& PDU__SCCP__ConnectionRefused_template::optionalPart() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field optionalPart of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return single_value->field_optionalPart;
}

SCCP__param__EndOfOptionalParams_template& PDU__SCCP__ConnectionRefused_template::eop()
{
set_specific();
return single_value->field_eop;
}

const SCCP__param__EndOfOptionalParams_template& PDU__SCCP__ConnectionRefused_template::eop() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eop of a non-specific template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
return single_value->field_eop;
}

int PDU__SCCP__ConnectionRefused_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_optionalPart.is_present()) ret_val++;
      if (single_value->field_eop.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
  }
  return 0;
}

void PDU__SCCP__ConnectionRefused_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", refusalCause := ");
single_value->field_refusalCause.log();
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log();
TTCN_Logger::log_event_str(", optionalPart := ");
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
single_value->field_eop.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__ConnectionRefused_template::log_match(const PDU__SCCP__ConnectionRefused& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_refusalCause.match(match_value.refusalCause(), legacy)){
TTCN_Logger::log_logmatch_info(".refusalCause");
single_value->field_refusalCause.log_match(match_value.refusalCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer1.match(match_value.pointer1(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer1");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.optionalPart().ispresent()){
if(!single_value->field_optionalPart.match(match_value.optionalPart(), legacy)){
TTCN_Logger::log_logmatch_info(".optionalPart");
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_optionalPart.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".optionalPart := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.eop().ispresent()){
if(!single_value->field_eop.match(match_value.eop(), legacy)){
TTCN_Logger::log_logmatch_info(".eop");
single_value->field_eop.log_match(match_value.eop(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_eop.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".eop := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_eop.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", refusalCause := ");
single_value->field_refusalCause.log_match(match_value.refusalCause(), legacy);
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::log_event_str(", optionalPart := ");
if (match_value.optionalPart().ispresent()) {
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_optionalPart.log();
if (single_value->field_optionalPart.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", eop := ");
if (match_value.eop().ispresent()) {
single_value->field_eop.log_match(match_value.eop(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_eop.log();
if (single_value->field_eop.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__ConnectionRefused_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (refusalCause().is_bound()) refusalCause().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__ConnectionRefused_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_refusalCause.encode_text(text_buf);
single_value->field_pointer1.encode_text(text_buf);
single_value->field_optionalPart.encode_text(text_buf);
single_value->field_eop.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
}
}

void PDU__SCCP__ConnectionRefused_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_refusalCause.decode_text(text_buf);
single_value->field_pointer1.decode_text(text_buf);
single_value->field_optionalPart.decode_text(text_buf);
single_value->field_eop.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__ConnectionRefused_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_ConnectionRefused.");
}
}

void PDU__SCCP__ConnectionRefused_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__ConnectionRefused_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_ConnectionRefused has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) refusalCause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "refusalCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          refusalCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ConnectionRefused: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__ConnectionRefused_template* precondition = new PDU__SCCP__ConnectionRefused_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__ConnectionRefused_template* implied_template = new PDU__SCCP__ConnectionRefused_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__ConnectionRefused_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_ConnectionRefused");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__ConnectionRefused_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
single_value->field_refusalCause.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
single_value->field_pointer1.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
single_value->field_optionalPart.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
single_value->field_eop.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_ConnectionRefused");
}

boolean PDU__SCCP__ConnectionRefused_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__ConnectionRefused_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SCCP__Released__optionalPart::SCCP__Released__optionalPart()
{
}

SCCP__Released__optionalPart::SCCP__Released__optionalPart(const OPTIONAL< SCCP__param__Data__opt >& par_data,
    const OPTIONAL< SCCP__param__Importance__opt >& par_importance)
  :   field_data(par_data),
  field_importance(par_importance)
{
}

SCCP__Released__optionalPart::SCCP__Released__optionalPart(const SCCP__Released__optionalPart& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.SCCP_Released_optionalPart.");
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
if (other_value.importance().is_bound()) field_importance = other_value.importance();
else field_importance.clean_up();
}

void SCCP__Released__optionalPart::clean_up()
{
field_data.clean_up();
field_importance.clean_up();
}

const TTCN_Typedescriptor_t* SCCP__Released__optionalPart::get_descriptor() const { return &SCCP__Released__optionalPart_descr_; }
SCCP__Released__optionalPart& SCCP__Released__optionalPart::operator=(const SCCP__Released__optionalPart& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.SCCP_Released_optionalPart.");
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
  if (other_value.importance().is_bound()) field_importance = other_value.importance();
  else field_importance.clean_up();
}
return *this;
}

boolean SCCP__Released__optionalPart::operator==(const SCCP__Released__optionalPart& other_value) const
{
return field_data==other_value.field_data
  && field_importance==other_value.field_importance;
}

boolean SCCP__Released__optionalPart::is_bound() const
{
return (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_bound())
  || (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_bound());
}
boolean SCCP__Released__optionalPart::is_value() const
{
return (OPTIONAL_OMIT == field_data.get_selection() || field_data.is_value())
  && (OPTIONAL_OMIT == field_importance.get_selection() || field_importance.is_value());
}
int SCCP__Released__optionalPart::size_of() const
{
  int ret_val = 0;
  if (field_data.ispresent()) ret_val++;
  if (field_importance.ispresent()) ret_val++;
  return ret_val;
}

void SCCP__Released__optionalPart::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ data := ");
field_data.log();
TTCN_Logger::log_event_str(", importance := ");
field_importance.log();
TTCN_Logger::log_event_str(" }");
}

void SCCP__Released__optionalPart::set_implicit_omit()
{
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__Released__optionalPart::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "set value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("set value of type @SCCP_Types.SCCP_Released_optionalPart has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_Released_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("set value", "@SCCP_Types.SCCP_Released_optionalPart");
  }
}

void SCCP__Released__optionalPart::encode_text(Text_Buf& text_buf) const
{
field_data.encode_text(text_buf);
field_importance.encode_text(text_buf);
}

void SCCP__Released__optionalPart::decode_text(Text_Buf& text_buf)
{
field_data.decode_text(text_buf);
field_importance.decode_text(text_buf);
}

void SCCP__Released__optionalPart::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SCCP__Released__optionalPart::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SCCP__Released__optionalPart::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean, int, boolean, const RAW_Force_Omit* force_omit)
{
int prepaddlength = p_buf.increase_pos_padd(p_td.raw->prepadding);
limit -= prepaddlength;
int decoded_length = 0;
int field_map[2];
memset(field_map, 0, sizeof(field_map));
field_data = OMIT_VALUE;
field_importance = OMIT_VALUE;
raw_order_t local_top_order;
if (p_td.raw->top_bit_order == TOP_BIT_INHERITED) local_top_order = top_bit_ord;
else if (p_td.raw->top_bit_order == TOP_BIT_RIGHT) local_top_order = ORDER_MSB;
else local_top_order = ORDER_LSB;
while (limit > 0) {
size_t fl_start_pos = p_buf.get_pos_bit();
if (field_map[0] == 0 && (force_omit == NULL || !(*force_omit)(0))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Data__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 15) {
RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__Data__opt_descr_.raw->forceomit);
int decoded_field_length = field_data().RAW_decode(SCCP__param__Data__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
if (decoded_field_length > 0 && (field_data.ispresent() && field_data().paramName() == 15)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[0] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_data = OMIT_VALUE;
}
}
}
if (field_map[1] == 0 && (force_omit == NULL || !(*force_omit)(1))) {
raw_order_t temporal_top_order;
int temporal_decoded_length;
if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_RIGHT) temporal_top_order = ORDER_MSB;
else if (SCCP__param__Importance__opt_descr_.raw->top_bit_order == TOP_BIT_LEFT) temporal_top_order = ORDER_LSB;
else temporal_top_order = top_bit_ord;
INTEGER temporal_0;
p_buf.set_pos_bit(fl_start_pos + 0);
temporal_decoded_length = temporal_0.RAW_decode(SCCP__field__ParameterName_descr_, p_buf, limit, temporal_top_order, TRUE);
p_buf.set_pos_bit(fl_start_pos);
if (temporal_decoded_length > 0 && temporal_0 == 18) {
RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__Importance__opt_descr_.raw->forceomit);
int decoded_field_length = field_importance().RAW_decode(SCCP__param__Importance__opt_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
if (decoded_field_length > 0 && (field_importance.ispresent() && field_importance().paramName() == 18)) {
decoded_length += decoded_field_length;
limit -= decoded_field_length;
field_map[1] = 1;
continue;
} else {
p_buf.set_pos_bit(fl_start_pos);
field_importance = OMIT_VALUE;
}
}
}
break;
}
return decoded_length + prepaddlength + p_buf.increase_pos_padd(p_td.raw->padding);
}

int SCCP__Released__optionalPart::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  if (field_data.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__Data__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_importance.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__Importance__opt_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_data.ispresent()) {
  encoded_length += field_data().RAW_encode(SCCP__param__Data__opt_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_importance.ispresent()) {
  encoded_length += field_importance().RAW_encode(SCCP__param__Importance__opt_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_data.ispresent() && (!field_data.ispresent() || field_data().paramName() != 15)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 15;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_importance.ispresent() && (!field_importance.ispresent() || field_importance().paramName() != 18)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 18;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct SCCP__Released__optionalPart_template::single_value_struct {
SCCP__param__Data__opt_template field_data;
SCCP__param__Importance__opt_template field_importance;
};

void SCCP__Released__optionalPart_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_data = ANY_OR_OMIT;
single_value->field_importance = ANY_OR_OMIT;
}
}
}

void SCCP__Released__optionalPart_template::copy_value(const SCCP__Released__optionalPart& other_value)
{
single_value = new single_value_struct;
if (other_value.data().is_bound()) {
  if (other_value.data().ispresent()) single_value->field_data = other_value.data()();
  else single_value->field_data = OMIT_VALUE;
} else {
  single_value->field_data.clean_up();
}
if (other_value.importance().is_bound()) {
  if (other_value.importance().ispresent()) single_value->field_importance = other_value.importance()();
  else single_value->field_importance = OMIT_VALUE;
} else {
  single_value->field_importance.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SCCP__Released__optionalPart_template::copy_template(const SCCP__Released__optionalPart_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.importance().get_selection()) {
single_value->field_importance = other_value.importance();
} else {
single_value->field_importance.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SCCP__Released__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SCCP__Released__optionalPart_template(*other_value.implication_.precondition);
implication_.implied_template = new SCCP__Released__optionalPart_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.SCCP_Released_optionalPart.");
break;
}
set_selection(other_value);
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template()
{
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template(const SCCP__Released__optionalPart& other_value)
{
copy_value(other_value);
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template(const OPTIONAL<SCCP__Released__optionalPart>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__Released__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.SCCP_Released_optionalPart from an unbound optional field.");
}
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template(SCCP__Released__optionalPart_template* p_precondition, SCCP__Released__optionalPart_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template(Dynamic_Match_Interface<SCCP__Released__optionalPart>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SCCP__Released__optionalPart>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SCCP__Released__optionalPart_template::SCCP__Released__optionalPart_template(const SCCP__Released__optionalPart_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SCCP__Released__optionalPart_template::~SCCP__Released__optionalPart_template()
{
clean_up();
}

SCCP__Released__optionalPart_template& SCCP__Released__optionalPart_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SCCP__Released__optionalPart_template& SCCP__Released__optionalPart_template::operator=(const SCCP__Released__optionalPart& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SCCP__Released__optionalPart_template& SCCP__Released__optionalPart_template::operator=(const OPTIONAL<SCCP__Released__optionalPart>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SCCP__Released__optionalPart&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.SCCP_Released_optionalPart.");
}
return *this;
}

SCCP__Released__optionalPart_template& SCCP__Released__optionalPart_template::operator=(const SCCP__Released__optionalPart_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SCCP__Released__optionalPart_template::match(const SCCP__Released__optionalPart& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.data().is_bound()) return FALSE;
if((other_value.data().ispresent() ? !single_value->field_data.match((const SCCP__param__Data__opt&)other_value.data(), legacy) : !single_value->field_data.match_omit(legacy)))return FALSE;
if(!other_value.importance().is_bound()) return FALSE;
if((other_value.importance().ispresent() ? !single_value->field_importance.match((const SCCP__param__Importance__opt&)other_value.importance(), legacy) : !single_value->field_importance.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.SCCP_Released_optionalPart.");
}
return FALSE;
}

boolean SCCP__Released__optionalPart_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_data.is_omit() || single_value->field_data.is_bound())
 || (single_value->field_importance.is_omit() || single_value->field_importance.is_bound());
}

boolean SCCP__Released__optionalPart_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_data.is_omit() || single_value->field_data.is_value())
 && (single_value->field_importance.is_omit() || single_value->field_importance.is_value());
}

void SCCP__Released__optionalPart_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SCCP__Released__optionalPart SCCP__Released__optionalPart_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.SCCP_Released_optionalPart.");
SCCP__Released__optionalPart ret_val;
if (single_value->field_data.is_omit()) ret_val.data() = OMIT_VALUE;
else if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
if (single_value->field_importance.is_omit()) ret_val.importance() = OMIT_VALUE;
else if (single_value->field_importance.is_bound()) {
ret_val.importance() = single_value->field_importance.valueof();
}
return ret_val;
}

void SCCP__Released__optionalPart_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.SCCP_Released_optionalPart.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SCCP__Released__optionalPart_template[list_length];
}

SCCP__Released__optionalPart_template& SCCP__Released__optionalPart_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.SCCP_Released_optionalPart.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.SCCP_Released_optionalPart.");
return value_list.list_value[list_index];
}

SCCP__param__Data__opt_template& SCCP__Released__optionalPart_template::data()
{
set_specific();
return single_value->field_data;
}

const SCCP__param__Data__opt_template& SCCP__Released__optionalPart_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.SCCP_Released_optionalPart.");
return single_value->field_data;
}

SCCP__param__Importance__opt_template& SCCP__Released__optionalPart_template::importance()
{
set_specific();
return single_value->field_importance;
}

const SCCP__param__Importance__opt_template& SCCP__Released__optionalPart_template::importance() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field importance of a non-specific template of type @SCCP_Types.SCCP_Released_optionalPart.");
return single_value->field_importance;
}

int SCCP__Released__optionalPart_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_data.is_present()) ret_val++;
      if (single_value->field_importance.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.SCCP_Released_optionalPart containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.SCCP_Released_optionalPart.");
  }
  return 0;
}

void SCCP__Released__optionalPart_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(", importance := ");
single_value->field_importance.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SCCP__Released__optionalPart_template::log_match(const SCCP__Released__optionalPart& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.data().ispresent()){
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_data.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".data := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_data.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.importance().ispresent()){
if(!single_value->field_importance.match(match_value.importance(), legacy)){
TTCN_Logger::log_logmatch_info(".importance");
single_value->field_importance.log_match(match_value.importance(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_importance.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".importance := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_importance.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ data := ");
if (match_value.data().ispresent()) {
single_value->field_data.log_match(match_value.data(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_data.log();
if (single_value->field_data.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", importance := ");
if (match_value.importance().ispresent()) {
single_value->field_importance.log_match(match_value.importance(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_importance.log();
if (single_value->field_importance.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SCCP__Released__optionalPart_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!data().is_bound()) data() = OMIT_VALUE;
else data().set_implicit_omit();
if (!importance().is_bound()) importance() = OMIT_VALUE;
else importance().set_implicit_omit();
}

void SCCP__Released__optionalPart_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_data.encode_text(text_buf);
single_value->field_importance.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.SCCP_Released_optionalPart.");
}
}

void SCCP__Released__optionalPart_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_data.decode_text(text_buf);
single_value->field_importance.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SCCP__Released__optionalPart_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.SCCP_Released_optionalPart.");
}
}

void SCCP__Released__optionalPart_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SCCP__Released__optionalPart_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("set template of type @SCCP_Types.SCCP_Released_optionalPart has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) importance().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "importance")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          importance().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.SCCP_Released_optionalPart: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SCCP__Released__optionalPart_template* precondition = new SCCP__Released__optionalPart_template;
    precondition->set_param(*param.get_elem(0));
    SCCP__Released__optionalPart_template* implied_template = new SCCP__Released__optionalPart_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SCCP__Released__optionalPart_template(precondition, implied_template);
  } break;
  default:
    param.type_error("set template", "@SCCP_Types.SCCP_Released_optionalPart");
  }
  is_ifpresent = param.get_ifpresent();
}

void SCCP__Released__optionalPart_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_Released_optionalPart");
single_value->field_importance.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.SCCP_Released_optionalPart");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.SCCP_Released_optionalPart");
}

boolean SCCP__Released__optionalPart_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SCCP__Released__optionalPart_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__Released::PDU__SCCP__Released()
{
}

PDU__SCCP__Released::PDU__SCCP__Released(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const OCTETSTRING& par_sourceLocRef,
    const INTEGER& par_releaseCause,
    const INTEGER& par_pointer1,
    const OPTIONAL< SCCP__Released__optionalPart >& par_optionalPart,
    const OPTIONAL< SCCP__param__EndOfOptionalParams >& par_eop)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_sourceLocRef(par_sourceLocRef),
  field_releaseCause(par_releaseCause),
  field_pointer1(par_pointer1),
  field_optionalPart(par_optionalPart),
  field_eop(par_eop)
{
}

PDU__SCCP__Released::PDU__SCCP__Released(const PDU__SCCP__Released& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_Released.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
else field_sourceLocRef.clean_up();
if (other_value.releaseCause().is_bound()) field_releaseCause = other_value.releaseCause();
else field_releaseCause.clean_up();
if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
else field_pointer1.clean_up();
if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
else field_optionalPart.clean_up();
if (other_value.eop().is_bound()) field_eop = other_value.eop();
else field_eop.clean_up();
}

void PDU__SCCP__Released::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_sourceLocRef.clean_up();
field_releaseCause.clean_up();
field_pointer1.clean_up();
field_optionalPart.clean_up();
field_eop.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__Released::get_descriptor() const { return &PDU__SCCP__Released_descr_; }
PDU__SCCP__Released& PDU__SCCP__Released::operator=(const PDU__SCCP__Released& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_Released.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
  else field_sourceLocRef.clean_up();
  if (other_value.releaseCause().is_bound()) field_releaseCause = other_value.releaseCause();
  else field_releaseCause.clean_up();
  if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
  else field_pointer1.clean_up();
  if (other_value.optionalPart().is_bound()) field_optionalPart = other_value.optionalPart();
  else field_optionalPart.clean_up();
  if (other_value.eop().is_bound()) field_eop = other_value.eop();
  else field_eop.clean_up();
}
return *this;
}

boolean PDU__SCCP__Released::operator==(const PDU__SCCP__Released& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_sourceLocRef==other_value.field_sourceLocRef
  && field_releaseCause==other_value.field_releaseCause
  && field_pointer1==other_value.field_pointer1
  && field_optionalPart==other_value.field_optionalPart
  && field_eop==other_value.field_eop;
}

boolean PDU__SCCP__Released::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_sourceLocRef.is_bound())
  || (field_releaseCause.is_bound())
  || (field_pointer1.is_bound())
  || (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_bound())
  || (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_bound());
}
boolean PDU__SCCP__Released::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_sourceLocRef.is_value()
  && field_releaseCause.is_value()
  && field_pointer1.is_value()
  && (OPTIONAL_OMIT == field_optionalPart.get_selection() || field_optionalPart.is_value())
  && (OPTIONAL_OMIT == field_eop.get_selection() || field_eop.is_value());
}
int PDU__SCCP__Released::size_of() const
{
  int ret_val = 5;
  if (field_optionalPart.ispresent()) ret_val++;
  if (field_eop.ispresent()) ret_val++;
  return ret_val;
}

void PDU__SCCP__Released::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
field_sourceLocRef.log();
TTCN_Logger::log_event_str(", releaseCause := ");
field_releaseCause.log();
TTCN_Logger::log_event_str(", pointer1 := ");
field_pointer1.log();
TTCN_Logger::log_event_str(", optionalPart := ");
field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
field_eop.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__Released::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
if (releaseCause().is_bound()) releaseCause().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__Released::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_Released has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) releaseCause().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "releaseCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          releaseCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_Released: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_Released");
  }
}

void PDU__SCCP__Released::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_sourceLocRef.encode_text(text_buf);
field_releaseCause.encode_text(text_buf);
field_pointer1.encode_text(text_buf);
field_optionalPart.encode_text(text_buf);
field_eop.encode_text(text_buf);
}

void PDU__SCCP__Released::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_sourceLocRef.decode_text(text_buf);
field_releaseCause.decode_text(text_buf);
field_pointer1.decode_text(text_buf);
field_optionalPart.decode_text(text_buf);
field_eop.decode_text(text_buf);
}

void PDU__SCCP__Released::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__Released::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__Released::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int end_of_available_data=last_decoded_pos+limit;
  int start_pos_of_field4=-1;
  int start_of_field5=-1;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__SourceLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_sourceLocRef.RAW_decode(SCCP__param__SourceLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, SCCP__param__ReleaseCause_descr_.raw->forceomit);
  decoded_field_length = field_releaseCause.RAW_decode(SCCP__param__ReleaseCause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_pos_of_field4=p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PDU__SCCP__Released_pointer1_descr_.raw->forceomit);
  decoded_field_length = field_pointer1.RAW_decode(PDU__SCCP__Released_pointer1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field5=(int)field_pointer1+0?1:-1;
  if (limit > 0 && start_of_field5!=-1 && start_pos_of_field4!=-1){
  start_of_field5=start_pos_of_field4+(int)field_pointer1*8+0;
  p_buf.set_pos_bit(start_of_field5);
  limit=end_of_available_data-start_of_field5;
  if (force_omit != NULL && (*force_omit)(5)) {
    field_optionalPart = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, SCCP__Released__optionalPart_descr_.raw->forceomit);
  decoded_field_length = field_optionalPart().RAW_decode(SCCP__Released__optionalPart_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_optionalPart = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_optionalPart=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_eop = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, SCCP__param__EndOfOptionalParams_descr_.raw->forceomit);
  decoded_field_length = field_eop().RAW_decode(SCCP__param__EndOfOptionalParams_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_eop = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_eop.ispresent() || field_eop().paramName() != 0){
  field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_eop=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__Released::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__SourceLocalReference_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, SCCP__param__ReleaseCause_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PDU__SCCP__Released_pointer1_descr_.raw);
  if (field_optionalPart.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, SCCP__Released__optionalPart_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_eop.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, SCCP__param__EndOfOptionalParams_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_sourceLocRef.RAW_encode(SCCP__param__SourceLocalReference_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_releaseCause.RAW_encode(SCCP__param__ReleaseCause_descr_, *myleaf.body.node.nodes[3]);
  if (field_optionalPart.ispresent()) {
  encoded_length += 8;
  myleaf.body.node.nodes[4]->calc = CALC_POINTER;
  myleaf.body.node.nodes[4]->coding_descr = &PDU__SCCP__Released_pointer1_descr_;
  myleaf.body.node.nodes[4]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[4]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[4]->calcof.pointerto.ptr_base = 4;
  myleaf.body.node.nodes[4]->calcof.pointerto.target.level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[4]->calcof.pointerto.target.pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[4]->length = 8;
  } else {
    INTEGER atm;
    atm = 0;
    encoded_length += atm.RAW_encode(PDU__SCCP__Released_pointer1_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_optionalPart.ispresent()) {
  encoded_length += field_optionalPart().RAW_encode(SCCP__Released__optionalPart_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_eop.ispresent()) {
  encoded_length += field_eop().RAW_encode(SCCP__param__EndOfOptionalParams_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_eop.ispresent() && (!field_eop.ispresent() || field_eop().paramName() != 0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
  INTEGER new_val = 0;
  new_val.RAW_encode(SCCP__field__ParameterName_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__Released_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
OCTETSTRING_template field_sourceLocRef;
INTEGER_template field_releaseCause;
INTEGER_template field_pointer1;
SCCP__Released__optionalPart_template field_optionalPart;
SCCP__param__EndOfOptionalParams_template field_eop;
};

void PDU__SCCP__Released_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_sourceLocRef = ANY_VALUE;
single_value->field_releaseCause = ANY_VALUE;
single_value->field_pointer1 = ANY_VALUE;
single_value->field_optionalPart = ANY_OR_OMIT;
single_value->field_eop = ANY_OR_OMIT;
}
}
}

void PDU__SCCP__Released_template::copy_value(const PDU__SCCP__Released& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.sourceLocRef().is_bound()) {
  single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
  single_value->field_sourceLocRef.clean_up();
}
if (other_value.releaseCause().is_bound()) {
  single_value->field_releaseCause = other_value.releaseCause();
} else {
  single_value->field_releaseCause.clean_up();
}
if (other_value.pointer1().is_bound()) {
  single_value->field_pointer1 = other_value.pointer1();
} else {
  single_value->field_pointer1.clean_up();
}
if (other_value.optionalPart().is_bound()) {
  if (other_value.optionalPart().ispresent()) single_value->field_optionalPart = other_value.optionalPart()();
  else single_value->field_optionalPart = OMIT_VALUE;
} else {
  single_value->field_optionalPart.clean_up();
}
if (other_value.eop().is_bound()) {
  if (other_value.eop().ispresent()) single_value->field_eop = other_value.eop()();
  else single_value->field_eop = OMIT_VALUE;
} else {
  single_value->field_eop.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__Released_template::copy_template(const PDU__SCCP__Released_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sourceLocRef().get_selection()) {
single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
single_value->field_sourceLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.releaseCause().get_selection()) {
single_value->field_releaseCause = other_value.releaseCause();
} else {
single_value->field_releaseCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer1().get_selection()) {
single_value->field_pointer1 = other_value.pointer1();
} else {
single_value->field_pointer1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.optionalPart().get_selection()) {
single_value->field_optionalPart = other_value.optionalPart();
} else {
single_value->field_optionalPart.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eop().get_selection()) {
single_value->field_eop = other_value.eop();
} else {
single_value->field_eop.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__Released_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__Released_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__Released_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_Released.");
break;
}
set_selection(other_value);
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template()
{
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template(const PDU__SCCP__Released& other_value)
{
copy_value(other_value);
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template(const OPTIONAL<PDU__SCCP__Released>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__Released&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_Released from an unbound optional field.");
}
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template(PDU__SCCP__Released_template* p_precondition, PDU__SCCP__Released_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template(Dynamic_Match_Interface<PDU__SCCP__Released>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__Released>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__Released_template::PDU__SCCP__Released_template(const PDU__SCCP__Released_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__Released_template::~PDU__SCCP__Released_template()
{
clean_up();
}

PDU__SCCP__Released_template& PDU__SCCP__Released_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__Released_template& PDU__SCCP__Released_template::operator=(const PDU__SCCP__Released& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__Released_template& PDU__SCCP__Released_template::operator=(const OPTIONAL<PDU__SCCP__Released>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__Released&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_Released.");
}
return *this;
}

PDU__SCCP__Released_template& PDU__SCCP__Released_template::operator=(const PDU__SCCP__Released_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__Released_template::match(const PDU__SCCP__Released& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.sourceLocRef().is_bound()) return FALSE;
if(!single_value->field_sourceLocRef.match(other_value.sourceLocRef(), legacy))return FALSE;
if(!other_value.releaseCause().is_bound()) return FALSE;
if(!single_value->field_releaseCause.match(other_value.releaseCause(), legacy))return FALSE;
if(!other_value.pointer1().is_bound()) return FALSE;
if(!single_value->field_pointer1.match(other_value.pointer1(), legacy))return FALSE;
if(!other_value.optionalPart().is_bound()) return FALSE;
if((other_value.optionalPart().ispresent() ? !single_value->field_optionalPart.match((const SCCP__Released__optionalPart&)other_value.optionalPart(), legacy) : !single_value->field_optionalPart.match_omit(legacy)))return FALSE;
if(!other_value.eop().is_bound()) return FALSE;
if((other_value.eop().ispresent() ? !single_value->field_eop.match((const SCCP__param__EndOfOptionalParams&)other_value.eop(), legacy) : !single_value->field_eop.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_Released.");
}
return FALSE;
}

boolean PDU__SCCP__Released_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_sourceLocRef.is_bound()
 || single_value->field_releaseCause.is_bound()
 || single_value->field_pointer1.is_bound()
 || (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_bound())
 || (single_value->field_eop.is_omit() || single_value->field_eop.is_bound());
}

boolean PDU__SCCP__Released_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_sourceLocRef.is_value()
 && single_value->field_releaseCause.is_value()
 && single_value->field_pointer1.is_value()
 && (single_value->field_optionalPart.is_omit() || single_value->field_optionalPart.is_value())
 && (single_value->field_eop.is_omit() || single_value->field_eop.is_value());
}

void PDU__SCCP__Released_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__Released PDU__SCCP__Released_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
PDU__SCCP__Released ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_sourceLocRef.is_bound()) {
ret_val.sourceLocRef() = single_value->field_sourceLocRef.valueof();
}
if (single_value->field_releaseCause.is_bound()) {
ret_val.releaseCause() = single_value->field_releaseCause.valueof();
}
if (single_value->field_pointer1.is_bound()) {
ret_val.pointer1() = single_value->field_pointer1.valueof();
}
if (single_value->field_optionalPart.is_omit()) ret_val.optionalPart() = OMIT_VALUE;
else if (single_value->field_optionalPart.is_bound()) {
ret_val.optionalPart() = single_value->field_optionalPart.valueof();
}
if (single_value->field_eop.is_omit()) ret_val.eop() = OMIT_VALUE;
else if (single_value->field_eop.is_bound()) {
ret_val.eop() = single_value->field_eop.valueof();
}
return ret_val;
}

void PDU__SCCP__Released_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_Released.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__Released_template[list_length];
}

PDU__SCCP__Released_template& PDU__SCCP__Released_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_Released.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_Released.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__Released_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__Released_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__Released_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__Released_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_destLocRef;
}

OCTETSTRING_template& PDU__SCCP__Released_template::sourceLocRef()
{
set_specific();
return single_value->field_sourceLocRef;
}

const OCTETSTRING_template& PDU__SCCP__Released_template::sourceLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sourceLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_sourceLocRef;
}

INTEGER_template& PDU__SCCP__Released_template::releaseCause()
{
set_specific();
return single_value->field_releaseCause;
}

const INTEGER_template& PDU__SCCP__Released_template::releaseCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field releaseCause of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_releaseCause;
}

INTEGER_template& PDU__SCCP__Released_template::pointer1()
{
set_specific();
return single_value->field_pointer1;
}

const INTEGER_template& PDU__SCCP__Released_template::pointer1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer1 of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_pointer1;
}

SCCP__Released__optionalPart_template& PDU__SCCP__Released_template::optionalPart()
{
set_specific();
return single_value->field_optionalPart;
}

const SCCP__Released__optionalPart_template& PDU__SCCP__Released_template::optionalPart() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field optionalPart of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_optionalPart;
}

SCCP__param__EndOfOptionalParams_template& PDU__SCCP__Released_template::eop()
{
set_specific();
return single_value->field_eop;
}

const SCCP__param__EndOfOptionalParams_template& PDU__SCCP__Released_template::eop() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eop of a non-specific template of type @SCCP_Types.PDU_SCCP_Released.");
return single_value->field_eop;
}

int PDU__SCCP__Released_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_optionalPart.is_present()) ret_val++;
      if (single_value->field_eop.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_Released containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_Released.");
  }
  return 0;
}

void PDU__SCCP__Released_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log();
TTCN_Logger::log_event_str(", releaseCause := ");
single_value->field_releaseCause.log();
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log();
TTCN_Logger::log_event_str(", optionalPart := ");
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(", eop := ");
single_value->field_eop.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__Released_template::log_match(const PDU__SCCP__Released& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sourceLocRef.match(match_value.sourceLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".sourceLocRef");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_releaseCause.match(match_value.releaseCause(), legacy)){
TTCN_Logger::log_logmatch_info(".releaseCause");
single_value->field_releaseCause.log_match(match_value.releaseCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer1.match(match_value.pointer1(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer1");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.optionalPart().ispresent()){
if(!single_value->field_optionalPart.match(match_value.optionalPart(), legacy)){
TTCN_Logger::log_logmatch_info(".optionalPart");
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_optionalPart.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".optionalPart := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_optionalPart.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.eop().ispresent()){
if(!single_value->field_eop.match(match_value.eop(), legacy)){
TTCN_Logger::log_logmatch_info(".eop");
single_value->field_eop.log_match(match_value.eop(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_eop.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".eop := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_eop.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::log_event_str(", releaseCause := ");
single_value->field_releaseCause.log_match(match_value.releaseCause(), legacy);
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::log_event_str(", optionalPart := ");
if (match_value.optionalPart().ispresent()) {
single_value->field_optionalPart.log_match(match_value.optionalPart(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_optionalPart.log();
if (single_value->field_optionalPart.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", eop := ");
if (match_value.eop().ispresent()) {
single_value->field_eop.log_match(match_value.eop(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_eop.log();
if (single_value->field_eop.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__Released_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
if (releaseCause().is_bound()) releaseCause().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (!optionalPart().is_bound()) optionalPart() = OMIT_VALUE;
else optionalPart().set_implicit_omit();
if (!eop().is_bound()) eop() = OMIT_VALUE;
else eop().set_implicit_omit();
}

void PDU__SCCP__Released_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_sourceLocRef.encode_text(text_buf);
single_value->field_releaseCause.encode_text(text_buf);
single_value->field_pointer1.encode_text(text_buf);
single_value->field_optionalPart.encode_text(text_buf);
single_value->field_eop.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_Released.");
}
}

void PDU__SCCP__Released_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_sourceLocRef.decode_text(text_buf);
single_value->field_releaseCause.decode_text(text_buf);
single_value->field_pointer1.decode_text(text_buf);
single_value->field_optionalPart.decode_text(text_buf);
single_value->field_eop.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__Released_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_Released.");
}
}

void PDU__SCCP__Released_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__Released_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_Released has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) releaseCause().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) optionalPart().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) eop().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "releaseCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          releaseCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "optionalPart")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          optionalPart().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eop")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eop().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_Released: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__Released_template* precondition = new PDU__SCCP__Released_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__Released_template* implied_template = new PDU__SCCP__Released_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__Released_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_Released");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__Released_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
single_value->field_sourceLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
single_value->field_releaseCause.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
single_value->field_pointer1.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
single_value->field_optionalPart.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
single_value->field_eop.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_Released");
}

boolean PDU__SCCP__Released_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__Released_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__ReleaseComplete::PDU__SCCP__ReleaseComplete()
{
}

PDU__SCCP__ReleaseComplete::PDU__SCCP__ReleaseComplete(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const OCTETSTRING& par_sourceLocRef)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_sourceLocRef(par_sourceLocRef)
{
}

PDU__SCCP__ReleaseComplete::PDU__SCCP__ReleaseComplete(const PDU__SCCP__ReleaseComplete& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
else field_sourceLocRef.clean_up();
}

void PDU__SCCP__ReleaseComplete::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_sourceLocRef.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__ReleaseComplete::get_descriptor() const { return &PDU__SCCP__ReleaseComplete_descr_; }
PDU__SCCP__ReleaseComplete& PDU__SCCP__ReleaseComplete::operator=(const PDU__SCCP__ReleaseComplete& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.sourceLocRef().is_bound()) field_sourceLocRef = other_value.sourceLocRef();
  else field_sourceLocRef.clean_up();
}
return *this;
}

boolean PDU__SCCP__ReleaseComplete::operator==(const PDU__SCCP__ReleaseComplete& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_sourceLocRef==other_value.field_sourceLocRef;
}

boolean PDU__SCCP__ReleaseComplete::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_sourceLocRef.is_bound());
}
boolean PDU__SCCP__ReleaseComplete::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_sourceLocRef.is_value();
}
void PDU__SCCP__ReleaseComplete::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
field_sourceLocRef.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__ReleaseComplete::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
}

void PDU__SCCP__ReleaseComplete::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_ReleaseComplete has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ReleaseComplete: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_ReleaseComplete");
  }
}

void PDU__SCCP__ReleaseComplete::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_sourceLocRef.encode_text(text_buf);
}

void PDU__SCCP__ReleaseComplete::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_sourceLocRef.decode_text(text_buf);
}

void PDU__SCCP__ReleaseComplete::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__ReleaseComplete::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__ReleaseComplete::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__SourceLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_sourceLocRef.RAW_decode(SCCP__param__SourceLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__ReleaseComplete::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__SourceLocalReference_descr_.raw);
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_sourceLocRef.RAW_encode(SCCP__param__SourceLocalReference_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__ReleaseComplete_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
OCTETSTRING_template field_sourceLocRef;
};

void PDU__SCCP__ReleaseComplete_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_sourceLocRef = ANY_VALUE;
}
}
}

void PDU__SCCP__ReleaseComplete_template::copy_value(const PDU__SCCP__ReleaseComplete& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.sourceLocRef().is_bound()) {
  single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
  single_value->field_sourceLocRef.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__ReleaseComplete_template::copy_template(const PDU__SCCP__ReleaseComplete_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sourceLocRef().get_selection()) {
single_value->field_sourceLocRef = other_value.sourceLocRef();
} else {
single_value->field_sourceLocRef.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__ReleaseComplete_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__ReleaseComplete_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__ReleaseComplete_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
break;
}
set_selection(other_value);
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template()
{
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template(const PDU__SCCP__ReleaseComplete& other_value)
{
copy_value(other_value);
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template(const OPTIONAL<PDU__SCCP__ReleaseComplete>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ReleaseComplete&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete from an unbound optional field.");
}
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template(PDU__SCCP__ReleaseComplete_template* p_precondition, PDU__SCCP__ReleaseComplete_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template(Dynamic_Match_Interface<PDU__SCCP__ReleaseComplete>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__ReleaseComplete>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__ReleaseComplete_template::PDU__SCCP__ReleaseComplete_template(const PDU__SCCP__ReleaseComplete_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__ReleaseComplete_template::~PDU__SCCP__ReleaseComplete_template()
{
clean_up();
}

PDU__SCCP__ReleaseComplete_template& PDU__SCCP__ReleaseComplete_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__ReleaseComplete_template& PDU__SCCP__ReleaseComplete_template::operator=(const PDU__SCCP__ReleaseComplete& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__ReleaseComplete_template& PDU__SCCP__ReleaseComplete_template::operator=(const OPTIONAL<PDU__SCCP__ReleaseComplete>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__ReleaseComplete&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
}
return *this;
}

PDU__SCCP__ReleaseComplete_template& PDU__SCCP__ReleaseComplete_template::operator=(const PDU__SCCP__ReleaseComplete_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__ReleaseComplete_template::match(const PDU__SCCP__ReleaseComplete& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.sourceLocRef().is_bound()) return FALSE;
if(!single_value->field_sourceLocRef.match(other_value.sourceLocRef(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
}
return FALSE;
}

boolean PDU__SCCP__ReleaseComplete_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_sourceLocRef.is_bound();
}

boolean PDU__SCCP__ReleaseComplete_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_sourceLocRef.is_value();
}

void PDU__SCCP__ReleaseComplete_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__ReleaseComplete PDU__SCCP__ReleaseComplete_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
PDU__SCCP__ReleaseComplete ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_sourceLocRef.is_bound()) {
ret_val.sourceLocRef() = single_value->field_sourceLocRef.valueof();
}
return ret_val;
}

void PDU__SCCP__ReleaseComplete_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__ReleaseComplete_template[list_length];
}

PDU__SCCP__ReleaseComplete_template& PDU__SCCP__ReleaseComplete_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__ReleaseComplete_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__ReleaseComplete_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__ReleaseComplete_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__ReleaseComplete_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
return single_value->field_destLocRef;
}

OCTETSTRING_template& PDU__SCCP__ReleaseComplete_template::sourceLocRef()
{
set_specific();
return single_value->field_sourceLocRef;
}

const OCTETSTRING_template& PDU__SCCP__ReleaseComplete_template::sourceLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sourceLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
return single_value->field_sourceLocRef;
}

int PDU__SCCP__ReleaseComplete_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
  }
  return 0;
}

void PDU__SCCP__ReleaseComplete_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__ReleaseComplete_template::log_match(const PDU__SCCP__ReleaseComplete& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sourceLocRef.match(match_value.sourceLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".sourceLocRef");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", sourceLocRef := ");
single_value->field_sourceLocRef.log_match(match_value.sourceLocRef(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__ReleaseComplete_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sourceLocRef().is_bound()) sourceLocRef().set_implicit_omit();
}

void PDU__SCCP__ReleaseComplete_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_sourceLocRef.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
}
}

void PDU__SCCP__ReleaseComplete_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_sourceLocRef.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__ReleaseComplete_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_ReleaseComplete.");
}
}

void PDU__SCCP__ReleaseComplete_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__ReleaseComplete_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_ReleaseComplete has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sourceLocRef().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_ReleaseComplete: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__ReleaseComplete_template* precondition = new PDU__SCCP__ReleaseComplete_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__ReleaseComplete_template* implied_template = new PDU__SCCP__ReleaseComplete_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__ReleaseComplete_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_ReleaseComplete");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__ReleaseComplete_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ReleaseComplete");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ReleaseComplete");
single_value->field_sourceLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_ReleaseComplete");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_ReleaseComplete");
}

boolean PDU__SCCP__ReleaseComplete_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__ReleaseComplete_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__DataForm1::PDU__SCCP__DataForm1()
{
}

PDU__SCCP__DataForm1::PDU__SCCP__DataForm1(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const SCCP__param__SegmentingReassembl& par_segmentingReassembl,
    const INTEGER& par_pointer1,
    const SCCP__param__Data& par_data)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_segmentingReassembl(par_segmentingReassembl),
  field_pointer1(par_pointer1),
  field_data(par_data)
{
}

PDU__SCCP__DataForm1::PDU__SCCP__DataForm1(const PDU__SCCP__DataForm1& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_DataForm1.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.segmentingReassembl().is_bound()) field_segmentingReassembl = other_value.segmentingReassembl();
else field_segmentingReassembl.clean_up();
if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
else field_pointer1.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
}

void PDU__SCCP__DataForm1::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_segmentingReassembl.clean_up();
field_pointer1.clean_up();
field_data.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__DataForm1::get_descriptor() const { return &PDU__SCCP__DataForm1_descr_; }
PDU__SCCP__DataForm1& PDU__SCCP__DataForm1::operator=(const PDU__SCCP__DataForm1& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_DataForm1.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.segmentingReassembl().is_bound()) field_segmentingReassembl = other_value.segmentingReassembl();
  else field_segmentingReassembl.clean_up();
  if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
  else field_pointer1.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
}
return *this;
}

boolean PDU__SCCP__DataForm1::operator==(const PDU__SCCP__DataForm1& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_segmentingReassembl==other_value.field_segmentingReassembl
  && field_pointer1==other_value.field_pointer1
  && field_data==other_value.field_data;
}

boolean PDU__SCCP__DataForm1::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_segmentingReassembl.is_bound())
  || (field_pointer1.is_bound())
  || (field_data.is_bound());
}
boolean PDU__SCCP__DataForm1::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_segmentingReassembl.is_value()
  && field_pointer1.is_value()
  && field_data.is_value();
}
void PDU__SCCP__DataForm1::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", segmentingReassembl := ");
field_segmentingReassembl.log();
TTCN_Logger::log_event_str(", pointer1 := ");
field_pointer1.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__DataForm1::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (segmentingReassembl().is_bound()) segmentingReassembl().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void PDU__SCCP__DataForm1::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_DataForm1 has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) segmentingReassembl().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmentingReassembl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmentingReassembl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_DataForm1: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_DataForm1");
  }
}

void PDU__SCCP__DataForm1::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_segmentingReassembl.encode_text(text_buf);
field_pointer1.encode_text(text_buf);
field_data.encode_text(text_buf);
}

void PDU__SCCP__DataForm1::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_segmentingReassembl.decode_text(text_buf);
field_pointer1.decode_text(text_buf);
field_data.decode_text(text_buf);
}

void PDU__SCCP__DataForm1::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__DataForm1::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__DataForm1::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int end_of_available_data=last_decoded_pos+limit;
  int start_pos_of_field3=-1;
  int start_of_field4=-1;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__SegmentingReassembl_descr_.raw->forceomit);
  decoded_field_length = field_segmentingReassembl.RAW_decode(SCCP__param__SegmentingReassembl_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_pos_of_field3=p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, PDU__SCCP__DataForm1_pointer1_descr_.raw->forceomit);
  decoded_field_length = field_pointer1.RAW_decode(PDU__SCCP__DataForm1_pointer1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field4=(int)field_pointer1+0?1:-1;
  start_of_field4=start_pos_of_field3+(int)field_pointer1*8+0;
  p_buf.set_pos_bit(start_of_field4);
  limit=end_of_available_data-start_of_field4;
  RAW_Force_Omit field_4_force_omit(4, force_omit, SCCP__param__Data_descr_.raw->forceomit);
  decoded_field_length = field_data.RAW_decode(SCCP__param__Data_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__DataForm1::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__SegmentingReassembl_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PDU__SCCP__DataForm1_pointer1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, SCCP__param__Data_descr_.raw);
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_segmentingReassembl.RAW_encode(SCCP__param__SegmentingReassembl_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += 8;
  myleaf.body.node.nodes[3]->calc = CALC_POINTER;
  myleaf.body.node.nodes[3]->coding_descr = &PDU__SCCP__DataForm1_pointer1_descr_;
  myleaf.body.node.nodes[3]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_base = 3;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[3]->length = 8;
  encoded_length += field_data.RAW_encode(SCCP__param__Data_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__DataForm1_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
SCCP__param__SegmentingReassembl_template field_segmentingReassembl;
INTEGER_template field_pointer1;
SCCP__param__Data_template field_data;
};

void PDU__SCCP__DataForm1_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_segmentingReassembl = ANY_VALUE;
single_value->field_pointer1 = ANY_VALUE;
single_value->field_data = ANY_VALUE;
}
}
}

void PDU__SCCP__DataForm1_template::copy_value(const PDU__SCCP__DataForm1& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.segmentingReassembl().is_bound()) {
  single_value->field_segmentingReassembl = other_value.segmentingReassembl();
} else {
  single_value->field_segmentingReassembl.clean_up();
}
if (other_value.pointer1().is_bound()) {
  single_value->field_pointer1 = other_value.pointer1();
} else {
  single_value->field_pointer1.clean_up();
}
if (other_value.data().is_bound()) {
  single_value->field_data = other_value.data();
} else {
  single_value->field_data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__DataForm1_template::copy_template(const PDU__SCCP__DataForm1_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.segmentingReassembl().get_selection()) {
single_value->field_segmentingReassembl = other_value.segmentingReassembl();
} else {
single_value->field_segmentingReassembl.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer1().get_selection()) {
single_value->field_pointer1 = other_value.pointer1();
} else {
single_value->field_pointer1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__DataForm1_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__DataForm1_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__DataForm1_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm1.");
break;
}
set_selection(other_value);
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template()
{
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template(const PDU__SCCP__DataForm1& other_value)
{
copy_value(other_value);
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template(const OPTIONAL<PDU__SCCP__DataForm1>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__DataForm1&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_DataForm1 from an unbound optional field.");
}
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template(PDU__SCCP__DataForm1_template* p_precondition, PDU__SCCP__DataForm1_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template(Dynamic_Match_Interface<PDU__SCCP__DataForm1>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__DataForm1>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__DataForm1_template::PDU__SCCP__DataForm1_template(const PDU__SCCP__DataForm1_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__DataForm1_template::~PDU__SCCP__DataForm1_template()
{
clean_up();
}

PDU__SCCP__DataForm1_template& PDU__SCCP__DataForm1_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__DataForm1_template& PDU__SCCP__DataForm1_template::operator=(const PDU__SCCP__DataForm1& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__DataForm1_template& PDU__SCCP__DataForm1_template::operator=(const OPTIONAL<PDU__SCCP__DataForm1>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__DataForm1&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_DataForm1.");
}
return *this;
}

PDU__SCCP__DataForm1_template& PDU__SCCP__DataForm1_template::operator=(const PDU__SCCP__DataForm1_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__DataForm1_template::match(const PDU__SCCP__DataForm1& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.segmentingReassembl().is_bound()) return FALSE;
if(!single_value->field_segmentingReassembl.match(other_value.segmentingReassembl(), legacy))return FALSE;
if(!other_value.pointer1().is_bound()) return FALSE;
if(!single_value->field_pointer1.match(other_value.pointer1(), legacy))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if(!single_value->field_data.match(other_value.data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm1.");
}
return FALSE;
}

boolean PDU__SCCP__DataForm1_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_segmentingReassembl.is_bound()
 || single_value->field_pointer1.is_bound()
 || single_value->field_data.is_bound();
}

boolean PDU__SCCP__DataForm1_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_segmentingReassembl.is_value()
 && single_value->field_pointer1.is_value()
 && single_value->field_data.is_value();
}

void PDU__SCCP__DataForm1_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__DataForm1 PDU__SCCP__DataForm1_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm1.");
PDU__SCCP__DataForm1 ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_segmentingReassembl.is_bound()) {
ret_val.segmentingReassembl() = single_value->field_segmentingReassembl.valueof();
}
if (single_value->field_pointer1.is_bound()) {
ret_val.pointer1() = single_value->field_pointer1.valueof();
}
if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
return ret_val;
}

void PDU__SCCP__DataForm1_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_DataForm1.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__DataForm1_template[list_length];
}

PDU__SCCP__DataForm1_template& PDU__SCCP__DataForm1_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_DataForm1.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_DataForm1.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__DataForm1_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__DataForm1_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm1.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__DataForm1_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__DataForm1_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm1.");
return single_value->field_destLocRef;
}

SCCP__param__SegmentingReassembl_template& PDU__SCCP__DataForm1_template::segmentingReassembl()
{
set_specific();
return single_value->field_segmentingReassembl;
}

const SCCP__param__SegmentingReassembl_template& PDU__SCCP__DataForm1_template::segmentingReassembl() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field segmentingReassembl of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm1.");
return single_value->field_segmentingReassembl;
}

INTEGER_template& PDU__SCCP__DataForm1_template::pointer1()
{
set_specific();
return single_value->field_pointer1;
}

const INTEGER_template& PDU__SCCP__DataForm1_template::pointer1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer1 of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm1.");
return single_value->field_pointer1;
}

SCCP__param__Data_template& PDU__SCCP__DataForm1_template::data()
{
set_specific();
return single_value->field_data;
}

const SCCP__param__Data_template& PDU__SCCP__DataForm1_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm1.");
return single_value->field_data;
}

int PDU__SCCP__DataForm1_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm1 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm1.");
  }
  return 0;
}

void PDU__SCCP__DataForm1_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", segmentingReassembl := ");
single_value->field_segmentingReassembl.log();
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__DataForm1_template::log_match(const PDU__SCCP__DataForm1& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_segmentingReassembl.match(match_value.segmentingReassembl(), legacy)){
TTCN_Logger::log_logmatch_info(".segmentingReassembl");
single_value->field_segmentingReassembl.log_match(match_value.segmentingReassembl(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer1.match(match_value.pointer1(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer1");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", segmentingReassembl := ");
single_value->field_segmentingReassembl.log_match(match_value.segmentingReassembl(), legacy);
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__DataForm1_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (segmentingReassembl().is_bound()) segmentingReassembl().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void PDU__SCCP__DataForm1_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_segmentingReassembl.encode_text(text_buf);
single_value->field_pointer1.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm1.");
}
}

void PDU__SCCP__DataForm1_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_segmentingReassembl.decode_text(text_buf);
single_value->field_pointer1.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__DataForm1_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_DataForm1.");
}
}

void PDU__SCCP__DataForm1_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__DataForm1_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_DataForm1 has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) segmentingReassembl().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmentingReassembl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmentingReassembl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_DataForm1: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__DataForm1_template* precondition = new PDU__SCCP__DataForm1_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__DataForm1_template* implied_template = new PDU__SCCP__DataForm1_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__DataForm1_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_DataForm1");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__DataForm1_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm1");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm1");
single_value->field_segmentingReassembl.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm1");
single_value->field_pointer1.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm1");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm1");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm1");
}

boolean PDU__SCCP__DataForm1_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__DataForm1_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__DataForm2::PDU__SCCP__DataForm2()
{
}

PDU__SCCP__DataForm2::PDU__SCCP__DataForm2(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const SCCP__param__SequencingSegmenting& par_sequencingSegmenting,
    const INTEGER& par_pointer1,
    const SCCP__param__Data& par_data)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_sequencingSegmenting(par_sequencingSegmenting),
  field_pointer1(par_pointer1),
  field_data(par_data)
{
}

PDU__SCCP__DataForm2::PDU__SCCP__DataForm2(const PDU__SCCP__DataForm2& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_DataForm2.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.sequencingSegmenting().is_bound()) field_sequencingSegmenting = other_value.sequencingSegmenting();
else field_sequencingSegmenting.clean_up();
if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
else field_pointer1.clean_up();
if (other_value.data().is_bound()) field_data = other_value.data();
else field_data.clean_up();
}

void PDU__SCCP__DataForm2::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_sequencingSegmenting.clean_up();
field_pointer1.clean_up();
field_data.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__DataForm2::get_descriptor() const { return &PDU__SCCP__DataForm2_descr_; }
PDU__SCCP__DataForm2& PDU__SCCP__DataForm2::operator=(const PDU__SCCP__DataForm2& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_DataForm2.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.sequencingSegmenting().is_bound()) field_sequencingSegmenting = other_value.sequencingSegmenting();
  else field_sequencingSegmenting.clean_up();
  if (other_value.pointer1().is_bound()) field_pointer1 = other_value.pointer1();
  else field_pointer1.clean_up();
  if (other_value.data().is_bound()) field_data = other_value.data();
  else field_data.clean_up();
}
return *this;
}

boolean PDU__SCCP__DataForm2::operator==(const PDU__SCCP__DataForm2& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_sequencingSegmenting==other_value.field_sequencingSegmenting
  && field_pointer1==other_value.field_pointer1
  && field_data==other_value.field_data;
}

boolean PDU__SCCP__DataForm2::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_sequencingSegmenting.is_bound())
  || (field_pointer1.is_bound())
  || (field_data.is_bound());
}
boolean PDU__SCCP__DataForm2::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_sequencingSegmenting.is_value()
  && field_pointer1.is_value()
  && field_data.is_value();
}
void PDU__SCCP__DataForm2::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", sequencingSegmenting := ");
field_sequencingSegmenting.log();
TTCN_Logger::log_event_str(", pointer1 := ");
field_pointer1.log();
TTCN_Logger::log_event_str(", data := ");
field_data.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__DataForm2::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sequencingSegmenting().is_bound()) sequencingSegmenting().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void PDU__SCCP__DataForm2::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_DataForm2 has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sequencingSegmenting().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sequencingSegmenting")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sequencingSegmenting().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_DataForm2: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_DataForm2");
  }
}

void PDU__SCCP__DataForm2::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_sequencingSegmenting.encode_text(text_buf);
field_pointer1.encode_text(text_buf);
field_data.encode_text(text_buf);
}

void PDU__SCCP__DataForm2::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_sequencingSegmenting.decode_text(text_buf);
field_pointer1.decode_text(text_buf);
field_data.decode_text(text_buf);
}

void PDU__SCCP__DataForm2::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__DataForm2::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__DataForm2::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int end_of_available_data=last_decoded_pos+limit;
  int start_pos_of_field3=-1;
  int start_of_field4=-1;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__SequencingSegmenting_descr_.raw->forceomit);
  decoded_field_length = field_sequencingSegmenting.RAW_decode(SCCP__param__SequencingSegmenting_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_pos_of_field3=p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, PDU__SCCP__DataForm2_pointer1_descr_.raw->forceomit);
  decoded_field_length = field_pointer1.RAW_decode(PDU__SCCP__DataForm2_pointer1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  start_of_field4=(int)field_pointer1+0?1:-1;
  start_of_field4=start_pos_of_field3+(int)field_pointer1*8+0;
  p_buf.set_pos_bit(start_of_field4);
  limit=end_of_available_data-start_of_field4;
  RAW_Force_Omit field_4_force_omit(4, force_omit, SCCP__param__Data_descr_.raw->forceomit);
  decoded_field_length = field_data.RAW_decode(SCCP__param__Data_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__DataForm2::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__SequencingSegmenting_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PDU__SCCP__DataForm2_pointer1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, SCCP__param__Data_descr_.raw);
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_sequencingSegmenting.RAW_encode(SCCP__param__SequencingSegmenting_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += 8;
  myleaf.body.node.nodes[3]->calc = CALC_POINTER;
  myleaf.body.node.nodes[3]->coding_descr = &PDU__SCCP__DataForm2_pointer1_descr_;
  myleaf.body.node.nodes[3]->calcof.pointerto.unit = 8;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_offset = 0;
  myleaf.body.node.nodes[3]->calcof.pointerto.ptr_base = 3;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.pointerto.target.pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[3]->length = 8;
  encoded_length += field_data.RAW_encode(SCCP__param__Data_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__DataForm2_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
SCCP__param__SequencingSegmenting_template field_sequencingSegmenting;
INTEGER_template field_pointer1;
SCCP__param__Data_template field_data;
};

void PDU__SCCP__DataForm2_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_sequencingSegmenting = ANY_VALUE;
single_value->field_pointer1 = ANY_VALUE;
single_value->field_data = ANY_VALUE;
}
}
}

void PDU__SCCP__DataForm2_template::copy_value(const PDU__SCCP__DataForm2& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.sequencingSegmenting().is_bound()) {
  single_value->field_sequencingSegmenting = other_value.sequencingSegmenting();
} else {
  single_value->field_sequencingSegmenting.clean_up();
}
if (other_value.pointer1().is_bound()) {
  single_value->field_pointer1 = other_value.pointer1();
} else {
  single_value->field_pointer1.clean_up();
}
if (other_value.data().is_bound()) {
  single_value->field_data = other_value.data();
} else {
  single_value->field_data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__DataForm2_template::copy_template(const PDU__SCCP__DataForm2_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sequencingSegmenting().get_selection()) {
single_value->field_sequencingSegmenting = other_value.sequencingSegmenting();
} else {
single_value->field_sequencingSegmenting.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pointer1().get_selection()) {
single_value->field_pointer1 = other_value.pointer1();
} else {
single_value->field_pointer1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.data().get_selection()) {
single_value->field_data = other_value.data();
} else {
single_value->field_data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__DataForm2_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__DataForm2_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__DataForm2_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm2.");
break;
}
set_selection(other_value);
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template()
{
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template(const PDU__SCCP__DataForm2& other_value)
{
copy_value(other_value);
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template(const OPTIONAL<PDU__SCCP__DataForm2>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__DataForm2&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_DataForm2 from an unbound optional field.");
}
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template(PDU__SCCP__DataForm2_template* p_precondition, PDU__SCCP__DataForm2_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template(Dynamic_Match_Interface<PDU__SCCP__DataForm2>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__DataForm2>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__DataForm2_template::PDU__SCCP__DataForm2_template(const PDU__SCCP__DataForm2_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__DataForm2_template::~PDU__SCCP__DataForm2_template()
{
clean_up();
}

PDU__SCCP__DataForm2_template& PDU__SCCP__DataForm2_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__DataForm2_template& PDU__SCCP__DataForm2_template::operator=(const PDU__SCCP__DataForm2& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__DataForm2_template& PDU__SCCP__DataForm2_template::operator=(const OPTIONAL<PDU__SCCP__DataForm2>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__DataForm2&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_DataForm2.");
}
return *this;
}

PDU__SCCP__DataForm2_template& PDU__SCCP__DataForm2_template::operator=(const PDU__SCCP__DataForm2_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__DataForm2_template::match(const PDU__SCCP__DataForm2& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.sequencingSegmenting().is_bound()) return FALSE;
if(!single_value->field_sequencingSegmenting.match(other_value.sequencingSegmenting(), legacy))return FALSE;
if(!other_value.pointer1().is_bound()) return FALSE;
if(!single_value->field_pointer1.match(other_value.pointer1(), legacy))return FALSE;
if(!other_value.data().is_bound()) return FALSE;
if(!single_value->field_data.match(other_value.data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm2.");
}
return FALSE;
}

boolean PDU__SCCP__DataForm2_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_sequencingSegmenting.is_bound()
 || single_value->field_pointer1.is_bound()
 || single_value->field_data.is_bound();
}

boolean PDU__SCCP__DataForm2_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_sequencingSegmenting.is_value()
 && single_value->field_pointer1.is_value()
 && single_value->field_data.is_value();
}

void PDU__SCCP__DataForm2_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__DataForm2 PDU__SCCP__DataForm2_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm2.");
PDU__SCCP__DataForm2 ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_sequencingSegmenting.is_bound()) {
ret_val.sequencingSegmenting() = single_value->field_sequencingSegmenting.valueof();
}
if (single_value->field_pointer1.is_bound()) {
ret_val.pointer1() = single_value->field_pointer1.valueof();
}
if (single_value->field_data.is_bound()) {
ret_val.data() = single_value->field_data.valueof();
}
return ret_val;
}

void PDU__SCCP__DataForm2_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_DataForm2.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__DataForm2_template[list_length];
}

PDU__SCCP__DataForm2_template& PDU__SCCP__DataForm2_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_DataForm2.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_DataForm2.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__DataForm2_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__DataForm2_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm2.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__DataForm2_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__DataForm2_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm2.");
return single_value->field_destLocRef;
}

SCCP__param__SequencingSegmenting_template& PDU__SCCP__DataForm2_template::sequencingSegmenting()
{
set_specific();
return single_value->field_sequencingSegmenting;
}

const SCCP__param__SequencingSegmenting_template& PDU__SCCP__DataForm2_template::sequencingSegmenting() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sequencingSegmenting of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm2.");
return single_value->field_sequencingSegmenting;
}

INTEGER_template& PDU__SCCP__DataForm2_template::pointer1()
{
set_specific();
return single_value->field_pointer1;
}

const INTEGER_template& PDU__SCCP__DataForm2_template::pointer1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pointer1 of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm2.");
return single_value->field_pointer1;
}

SCCP__param__Data_template& PDU__SCCP__DataForm2_template::data()
{
set_specific();
return single_value->field_data;
}

const SCCP__param__Data_template& PDU__SCCP__DataForm2_template::data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field data of a non-specific template of type @SCCP_Types.PDU_SCCP_DataForm2.");
return single_value->field_data;
}

int PDU__SCCP__DataForm2_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataForm2 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm2.");
  }
  return 0;
}

void PDU__SCCP__DataForm2_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", sequencingSegmenting := ");
single_value->field_sequencingSegmenting.log();
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log();
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__DataForm2_template::log_match(const PDU__SCCP__DataForm2& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sequencingSegmenting.match(match_value.sequencingSegmenting(), legacy)){
TTCN_Logger::log_logmatch_info(".sequencingSegmenting");
single_value->field_sequencingSegmenting.log_match(match_value.sequencingSegmenting(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pointer1.match(match_value.pointer1(), legacy)){
TTCN_Logger::log_logmatch_info(".pointer1");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_data.match(match_value.data(), legacy)){
TTCN_Logger::log_logmatch_info(".data");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", sequencingSegmenting := ");
single_value->field_sequencingSegmenting.log_match(match_value.sequencingSegmenting(), legacy);
TTCN_Logger::log_event_str(", pointer1 := ");
single_value->field_pointer1.log_match(match_value.pointer1(), legacy);
TTCN_Logger::log_event_str(", data := ");
single_value->field_data.log_match(match_value.data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__DataForm2_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (sequencingSegmenting().is_bound()) sequencingSegmenting().set_implicit_omit();
if (pointer1().is_bound()) pointer1().set_implicit_omit();
if (data().is_bound()) data().set_implicit_omit();
}

void PDU__SCCP__DataForm2_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_sequencingSegmenting.encode_text(text_buf);
single_value->field_pointer1.encode_text(text_buf);
single_value->field_data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataForm2.");
}
}

void PDU__SCCP__DataForm2_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_sequencingSegmenting.decode_text(text_buf);
single_value->field_pointer1.decode_text(text_buf);
single_value->field_data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__DataForm2_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_DataForm2.");
}
}

void PDU__SCCP__DataForm2_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__DataForm2_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_DataForm2 has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sequencingSegmenting().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pointer1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) data().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sequencingSegmenting")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sequencingSegmenting().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pointer1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pointer1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_DataForm2: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__DataForm2_template* precondition = new PDU__SCCP__DataForm2_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__DataForm2_template* implied_template = new PDU__SCCP__DataForm2_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__DataForm2_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_DataForm2");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__DataForm2_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm2");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm2");
single_value->field_sequencingSegmenting.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm2");
single_value->field_pointer1.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm2");
single_value->field_data.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm2");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataForm2");
}

boolean PDU__SCCP__DataForm2_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__DataForm2_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__SCCP__DataAcknowledgement::PDU__SCCP__DataAcknowledgement()
{
}

PDU__SCCP__DataAcknowledgement::PDU__SCCP__DataAcknowledgement(const INTEGER& par_messageType,
    const OCTETSTRING& par_destLocRef,
    const SCCP__param__RecSeqNumber& par_recSeqNumber,
    const OCTETSTRING& par_credit)
  :   field_messageType(par_messageType),
  field_destLocRef(par_destLocRef),
  field_recSeqNumber(par_recSeqNumber),
  field_credit(par_credit)
{
}

PDU__SCCP__DataAcknowledgement::PDU__SCCP__DataAcknowledgement(const PDU__SCCP__DataAcknowledgement& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
else field_destLocRef.clean_up();
if (other_value.recSeqNumber().is_bound()) field_recSeqNumber = other_value.recSeqNumber();
else field_recSeqNumber.clean_up();
if (other_value.credit().is_bound()) field_credit = other_value.credit();
else field_credit.clean_up();
}

void PDU__SCCP__DataAcknowledgement::clean_up()
{
field_messageType.clean_up();
field_destLocRef.clean_up();
field_recSeqNumber.clean_up();
field_credit.clean_up();
}

const TTCN_Typedescriptor_t* PDU__SCCP__DataAcknowledgement::get_descriptor() const { return &PDU__SCCP__DataAcknowledgement_descr_; }
PDU__SCCP__DataAcknowledgement& PDU__SCCP__DataAcknowledgement::operator=(const PDU__SCCP__DataAcknowledgement& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.destLocRef().is_bound()) field_destLocRef = other_value.destLocRef();
  else field_destLocRef.clean_up();
  if (other_value.recSeqNumber().is_bound()) field_recSeqNumber = other_value.recSeqNumber();
  else field_recSeqNumber.clean_up();
  if (other_value.credit().is_bound()) field_credit = other_value.credit();
  else field_credit.clean_up();
}
return *this;
}

boolean PDU__SCCP__DataAcknowledgement::operator==(const PDU__SCCP__DataAcknowledgement& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_destLocRef==other_value.field_destLocRef
  && field_recSeqNumber==other_value.field_recSeqNumber
  && field_credit==other_value.field_credit;
}

boolean PDU__SCCP__DataAcknowledgement::is_bound() const
{
return (field_messageType.is_bound())
  || (field_destLocRef.is_bound())
  || (field_recSeqNumber.is_bound())
  || (field_credit.is_bound());
}
boolean PDU__SCCP__DataAcknowledgement::is_value() const
{
return field_messageType.is_value()
  && field_destLocRef.is_value()
  && field_recSeqNumber.is_value()
  && field_credit.is_value();
}
void PDU__SCCP__DataAcknowledgement::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
field_destLocRef.log();
TTCN_Logger::log_event_str(", recSeqNumber := ");
field_recSeqNumber.log();
TTCN_Logger::log_event_str(", credit := ");
field_credit.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__SCCP__DataAcknowledgement::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (recSeqNumber().is_bound()) recSeqNumber().set_implicit_omit();
if (credit().is_bound()) credit().set_implicit_omit();
}

void PDU__SCCP__DataAcknowledgement::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @SCCP_Types.PDU_SCCP_DataAcknowledgement has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recSeqNumber().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recSeqNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recSeqNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_DataAcknowledgement: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
  }
}

void PDU__SCCP__DataAcknowledgement::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_destLocRef.encode_text(text_buf);
field_recSeqNumber.encode_text(text_buf);
field_credit.encode_text(text_buf);
}

void PDU__SCCP__DataAcknowledgement::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_destLocRef.decode_text(text_buf);
field_recSeqNumber.decode_text(text_buf);
field_credit.decode_text(text_buf);
}

void PDU__SCCP__DataAcknowledgement::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__SCCP__DataAcknowledgement::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__SCCP__DataAcknowledgement::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SCCP__param__MessageType_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(SCCP__param__MessageType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SCCP__param__DestLocalReference_descr_.raw->forceomit);
  decoded_field_length = field_destLocRef.RAW_decode(SCCP__param__DestLocalReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, SCCP__param__RecSeqNumber_descr_.raw->forceomit);
  decoded_field_length = field_recSeqNumber.RAW_decode(SCCP__param__RecSeqNumber_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, SCCP__param__Credit_descr_.raw->forceomit);
  decoded_field_length = field_credit.RAW_decode(SCCP__param__Credit_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__SCCP__DataAcknowledgement::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SCCP__param__MessageType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SCCP__param__DestLocalReference_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, SCCP__param__RecSeqNumber_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, SCCP__param__Credit_descr_.raw);
  encoded_length += field_messageType.RAW_encode(SCCP__param__MessageType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_destLocRef.RAW_encode(SCCP__param__DestLocalReference_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_recSeqNumber.RAW_encode(SCCP__param__RecSeqNumber_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_credit.RAW_encode(SCCP__param__Credit_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct PDU__SCCP__DataAcknowledgement_template::single_value_struct {
INTEGER_template field_messageType;
OCTETSTRING_template field_destLocRef;
SCCP__param__RecSeqNumber_template field_recSeqNumber;
OCTETSTRING_template field_credit;
};

void PDU__SCCP__DataAcknowledgement_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_destLocRef = ANY_VALUE;
single_value->field_recSeqNumber = ANY_VALUE;
single_value->field_credit = ANY_VALUE;
}
}
}

void PDU__SCCP__DataAcknowledgement_template::copy_value(const PDU__SCCP__DataAcknowledgement& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.destLocRef().is_bound()) {
  single_value->field_destLocRef = other_value.destLocRef();
} else {
  single_value->field_destLocRef.clean_up();
}
if (other_value.recSeqNumber().is_bound()) {
  single_value->field_recSeqNumber = other_value.recSeqNumber();
} else {
  single_value->field_recSeqNumber.clean_up();
}
if (other_value.credit().is_bound()) {
  single_value->field_credit = other_value.credit();
} else {
  single_value->field_credit.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__SCCP__DataAcknowledgement_template::copy_template(const PDU__SCCP__DataAcknowledgement_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.destLocRef().get_selection()) {
single_value->field_destLocRef = other_value.destLocRef();
} else {
single_value->field_destLocRef.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.recSeqNumber().get_selection()) {
single_value->field_recSeqNumber = other_value.recSeqNumber();
} else {
single_value->field_recSeqNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.credit().get_selection()) {
single_value->field_credit = other_value.credit();
} else {
single_value->field_credit.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__SCCP__DataAcknowledgement_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__SCCP__DataAcknowledgement_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__SCCP__DataAcknowledgement_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
break;
}
set_selection(other_value);
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template()
{
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template(const PDU__SCCP__DataAcknowledgement& other_value)
{
copy_value(other_value);
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template(const OPTIONAL<PDU__SCCP__DataAcknowledgement>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__DataAcknowledgement&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement from an unbound optional field.");
}
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template(PDU__SCCP__DataAcknowledgement_template* p_precondition, PDU__SCCP__DataAcknowledgement_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template(Dynamic_Match_Interface<PDU__SCCP__DataAcknowledgement>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__SCCP__DataAcknowledgement>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__SCCP__DataAcknowledgement_template::PDU__SCCP__DataAcknowledgement_template(const PDU__SCCP__DataAcknowledgement_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__SCCP__DataAcknowledgement_template::~PDU__SCCP__DataAcknowledgement_template()
{
clean_up();
}

PDU__SCCP__DataAcknowledgement_template& PDU__SCCP__DataAcknowledgement_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__SCCP__DataAcknowledgement_template& PDU__SCCP__DataAcknowledgement_template::operator=(const PDU__SCCP__DataAcknowledgement& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__SCCP__DataAcknowledgement_template& PDU__SCCP__DataAcknowledgement_template::operator=(const OPTIONAL<PDU__SCCP__DataAcknowledgement>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__SCCP__DataAcknowledgement&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
}
return *this;
}

PDU__SCCP__DataAcknowledgement_template& PDU__SCCP__DataAcknowledgement_template::operator=(const PDU__SCCP__DataAcknowledgement_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__SCCP__DataAcknowledgement_template::match(const PDU__SCCP__DataAcknowledgement& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.destLocRef().is_bound()) return FALSE;
if(!single_value->field_destLocRef.match(other_value.destLocRef(), legacy))return FALSE;
if(!other_value.recSeqNumber().is_bound()) return FALSE;
if(!single_value->field_recSeqNumber.match(other_value.recSeqNumber(), legacy))return FALSE;
if(!other_value.credit().is_bound()) return FALSE;
if(!single_value->field_credit.match(other_value.credit(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
}
return FALSE;
}

boolean PDU__SCCP__DataAcknowledgement_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_destLocRef.is_bound()
 || single_value->field_recSeqNumber.is_bound()
 || single_value->field_credit.is_bound();
}

boolean PDU__SCCP__DataAcknowledgement_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_destLocRef.is_value()
 && single_value->field_recSeqNumber.is_value()
 && single_value->field_credit.is_value();
}

void PDU__SCCP__DataAcknowledgement_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__SCCP__DataAcknowledgement PDU__SCCP__DataAcknowledgement_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
PDU__SCCP__DataAcknowledgement ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_destLocRef.is_bound()) {
ret_val.destLocRef() = single_value->field_destLocRef.valueof();
}
if (single_value->field_recSeqNumber.is_bound()) {
ret_val.recSeqNumber() = single_value->field_recSeqNumber.valueof();
}
if (single_value->field_credit.is_bound()) {
ret_val.credit() = single_value->field_credit.valueof();
}
return ret_val;
}

void PDU__SCCP__DataAcknowledgement_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__SCCP__DataAcknowledgement_template[list_length];
}

PDU__SCCP__DataAcknowledgement_template& PDU__SCCP__DataAcknowledgement_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
return value_list.list_value[list_index];
}

INTEGER_template& PDU__SCCP__DataAcknowledgement_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const INTEGER_template& PDU__SCCP__DataAcknowledgement_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
return single_value->field_messageType;
}

OCTETSTRING_template& PDU__SCCP__DataAcknowledgement_template::destLocRef()
{
set_specific();
return single_value->field_destLocRef;
}

const OCTETSTRING_template& PDU__SCCP__DataAcknowledgement_template::destLocRef() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field destLocRef of a non-specific template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
return single_value->field_destLocRef;
}

SCCP__param__RecSeqNumber_template& PDU__SCCP__DataAcknowledgement_template::recSeqNumber()
{
set_specific();
return single_value->field_recSeqNumber;
}

const SCCP__param__RecSeqNumber_template& PDU__SCCP__DataAcknowledgement_template::recSeqNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field recSeqNumber of a non-specific template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
return single_value->field_recSeqNumber;
}

OCTETSTRING_template& PDU__SCCP__DataAcknowledgement_template::credit()
{
set_specific();
return single_value->field_credit;
}

const OCTETSTRING_template& PDU__SCCP__DataAcknowledgement_template::credit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field credit of a non-specific template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
return single_value->field_credit;
}

int PDU__SCCP__DataAcknowledgement_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
  }
  return 0;
}

void PDU__SCCP__DataAcknowledgement_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log();
TTCN_Logger::log_event_str(", recSeqNumber := ");
single_value->field_recSeqNumber.log();
TTCN_Logger::log_event_str(", credit := ");
single_value->field_credit.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__SCCP__DataAcknowledgement_template::log_match(const PDU__SCCP__DataAcknowledgement& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_destLocRef.match(match_value.destLocRef(), legacy)){
TTCN_Logger::log_logmatch_info(".destLocRef");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_recSeqNumber.match(match_value.recSeqNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".recSeqNumber");
single_value->field_recSeqNumber.log_match(match_value.recSeqNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_credit.match(match_value.credit(), legacy)){
TTCN_Logger::log_logmatch_info(".credit");
single_value->field_credit.log_match(match_value.credit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", destLocRef := ");
single_value->field_destLocRef.log_match(match_value.destLocRef(), legacy);
TTCN_Logger::log_event_str(", recSeqNumber := ");
single_value->field_recSeqNumber.log_match(match_value.recSeqNumber(), legacy);
TTCN_Logger::log_event_str(", credit := ");
single_value->field_credit.log_match(match_value.credit(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__SCCP__DataAcknowledgement_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (destLocRef().is_bound()) destLocRef().set_implicit_omit();
if (recSeqNumber().is_bound()) recSeqNumber().set_implicit_omit();
if (credit().is_bound()) credit().set_implicit_omit();
}

void PDU__SCCP__DataAcknowledgement_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_destLocRef.encode_text(text_buf);
single_value->field_recSeqNumber.encode_text(text_buf);
single_value->field_credit.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
}
}

void PDU__SCCP__DataAcknowledgement_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_destLocRef.decode_text(text_buf);
single_value->field_recSeqNumber.decode_text(text_buf);
single_value->field_credit.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__SCCP__DataAcknowledgement_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement.");
}
}

void PDU__SCCP__DataAcknowledgement_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__SCCP__DataAcknowledgement_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @SCCP_Types.PDU_SCCP_DataAcknowledgement has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) destLocRef().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recSeqNumber().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) credit().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "destLocRef")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          destLocRef().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recSeqNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recSeqNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "credit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          credit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @SCCP_Types.PDU_SCCP_DataAcknowledgement: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__SCCP__DataAcknowledgement_template* precondition = new PDU__SCCP__DataAcknowledgement_template;
    precondition->set_param(*param.get_elem(0));
    PDU__SCCP__DataAcknowledgement_template* implied_template = new PDU__SCCP__DataAcknowledgement_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__SCCP__DataAcknowledgement_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__SCCP__DataAcknowledgement_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
single_value->field_destLocRef.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
single_value->field_recSeqNumber.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
single_value->field_credit.check_restriction(t_res, t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@SCCP_Types.PDU_SCCP_DataAcknowledgement");
}

boolean PDU__SCCP__DataAcknowledgement_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__SCCP__DataAcknowledgement_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


} /* end of namespace */
