// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "TCAPMessages.hh"

namespace TCAPMessages {

/* Member functions of C++ classes */

void Reject_invokeIDRej::copy_value(const Reject_invokeIDRej& other_value)
{
switch (other_value.union_selection) {
case ALT_derivable:
field_derivable = new INTEGER(*other_value.field_derivable);
break;
case ALT_not__derivable:
field_not__derivable = new ASN_NULL(*other_value.field_not__derivable);
break;
default:
TTCN_error("Assignment of an unbound union value of type @TCAPMessages.Reject.invokeIDRej.");
}
union_selection = other_value.union_selection;
}

Reject_invokeIDRej::Reject_invokeIDRej()
{
union_selection = UNBOUND_VALUE;
}

Reject_invokeIDRej::Reject_invokeIDRej(const Reject_invokeIDRej& other_value)
: Base_Type(){
copy_value(other_value);
}

Reject_invokeIDRej::~Reject_invokeIDRej()
{
clean_up();
}

Reject_invokeIDRej& Reject_invokeIDRej::operator=(const Reject_invokeIDRej& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean Reject_invokeIDRej::operator==(const Reject_invokeIDRej& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @TCAPMessages.Reject.invokeIDRej.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @TCAPMessages.Reject.invokeIDRej.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_derivable:
return *field_derivable == *other_value.field_derivable;
case ALT_not__derivable:
return *field_not__derivable == *other_value.field_not__derivable;
default:
return FALSE;
}
}

INTEGER& Reject_invokeIDRej::derivable()
{
if (union_selection != ALT_derivable) {
clean_up();
field_derivable = new INTEGER;
union_selection = ALT_derivable;
}
return *field_derivable;
}

const INTEGER& Reject_invokeIDRej::derivable() const
{
if (union_selection != ALT_derivable) TTCN_error("Using non-selected field derivable in a value of union type @TCAPMessages.Reject.invokeIDRej.");
return *field_derivable;
}

ASN_NULL& Reject_invokeIDRej::not__derivable()
{
if (union_selection != ALT_not__derivable) {
clean_up();
field_not__derivable = new ASN_NULL;
union_selection = ALT_not__derivable;
}
return *field_not__derivable;
}

const ASN_NULL& Reject_invokeIDRej::not__derivable() const
{
if (union_selection != ALT_not__derivable) TTCN_error("Using non-selected field not_derivable in a value of union type @TCAPMessages.Reject.invokeIDRej.");
return *field_not__derivable;
}

boolean Reject_invokeIDRej::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.Reject.invokeIDRej.");
return union_selection == checked_selection;
}

boolean Reject_invokeIDRej::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean Reject_invokeIDRej::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_derivable: return field_derivable->is_value();
case ALT_not__derivable: return field_not__derivable->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void Reject_invokeIDRej::clean_up()
{
switch (union_selection) {
case ALT_derivable:
  delete field_derivable;
  break;
case ALT_not__derivable:
  delete field_not__derivable;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void Reject_invokeIDRej::log() const
{
switch (union_selection) {
case ALT_derivable:
TTCN_Logger::log_event_str("{ derivable := ");
field_derivable->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_not__derivable:
TTCN_Logger::log_event_str("{ not_derivable := ");
field_not__derivable->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void Reject_invokeIDRej::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "derivable")) {
    derivable().set_param(*mp_last);
    if (!derivable().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "not_derivable")) {
    not__derivable().set_param(*mp_last);
    if (!not__derivable().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @TCAPMessages.Reject.invokeIDRej.", last_name);
}

void Reject_invokeIDRej::set_implicit_omit()
{
switch (union_selection) {
case ALT_derivable:
field_derivable->set_implicit_omit(); break;
case ALT_not__derivable:
field_not__derivable->set_implicit_omit(); break;
default: break;
}
}

void Reject_invokeIDRej::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_derivable:
field_derivable->encode_text(text_buf);
break;
case ALT_not__derivable:
field_not__derivable->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @TCAPMessages.Reject.invokeIDRej.");
}
}

void Reject_invokeIDRej::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_derivable:
derivable().decode_text(text_buf);
break;
case ALT_not__derivable:
not__derivable().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @TCAPMessages.Reject.invokeIDRej.");
}
}

void Reject_invokeIDRej::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Reject_invokeIDRej::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *Reject_invokeIDRej::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_derivable:
    ec_1.set_msg("derivable': ");
    new_tlv = field_derivable->BER_encode_TLV(Reject_invokeIDRej_derivable_descr_, p_coding);
    break;
  case ALT_not__derivable:
    ec_1.set_msg("not_derivable': ");
    new_tlv = field_not__derivable->BER_encode_TLV(ASN_NULL_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean Reject_invokeIDRej::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_derivable = new INTEGER;
  union_selection = ALT_derivable;
  if (field_derivable->BER_decode_isMyMsg(Reject_invokeIDRej_derivable_descr_, p_tlv)) return TRUE;
  delete field_derivable;
  field_not__derivable = new ASN_NULL;
  union_selection = ALT_not__derivable;
  if (field_not__derivable->BER_decode_isMyMsg(ASN_NULL_descr_, p_tlv)) return TRUE;
  delete field_not__derivable;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean Reject_invokeIDRej::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    Reject_invokeIDRej tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean Reject_invokeIDRej::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Reject.invokeIDRej' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_derivable:
    ec_2.set_msg("derivable': ");
    field_derivable->BER_decode_TLV(Reject_invokeIDRej_derivable_descr_, tmp_tlv, L_form);
    break;
  case ALT_not__derivable:
    ec_2.set_msg("not_derivable': ");
    field_not__derivable->BER_decode_TLV(ASN_NULL_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int Reject_invokeIDRej::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  boolean as_value = p_td.json->as_value;
  int enc_len = as_value ? 0 : p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
  switch(union_selection) {
  case ALT_derivable:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "derivable");
    }
    enc_len += field_derivable->JSON_encode(Reject_invokeIDRej_derivable_descr_, p_tok, FALSE);
    break;
  case ALT_not__derivable:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "not_derivable");
    }
    enc_len += field_not__derivable->JSON_encode(ASN_NULL_descr_, p_tok, FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.Reject.invokeIDRej.");
    return -1;
  }

  if (!as_value) {
    enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  }
  return enc_len;
}

int Reject_invokeIDRej::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  if (0 <= p_chosen_field && 2 > p_chosen_field) {
    switch (p_chosen_field) {
    case 0:
      return derivable().JSON_decode(Reject_invokeIDRej_derivable_descr_, p_tok, TRUE, FALSE);
    case 1:
      return not__derivable().JSON_decode(ASN_NULL_descr_, p_tok, TRUE, FALSE);
    }
  }
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const Reject_invokeIDRej*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
 if (p_td.json->as_value) {
  size_t buf_pos = p_tok.get_buf_pos();
  p_tok.get_next_token(&j_token, NULL, NULL);
  int ret_val = 0;
  switch(j_token) {
  case JSON_TOKEN_NUMBER: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = derivable().JSON_decode(Reject_invokeIDRej_derivable_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "number '@TCAPMessages.Reject.invokeIDRej'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_STRING: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "string '@TCAPMessages.Reject.invokeIDRej'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_TRUE:
  case JSON_TOKEN_LITERAL_FALSE: {
    char* literal_str = mprintf("literal (%s)",
      (JSON_TOKEN_LITERAL_TRUE == j_token) ? "true" : "false");
    try {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, literal_str);
    }
    catch (const TC_Error&) {
      Free(literal_str);
      throw;
    }
    Free(literal_str);
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_ARRAY_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "array '@TCAPMessages.Reject.invokeIDRej'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_OBJECT_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "object '@TCAPMessages.Reject.invokeIDRej'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_NULL: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = not__derivable().JSON_decode(ASN_NULL_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    clean_up();
    return JSON_ERROR_INVALID_TOKEN;
  }
  case JSON_TOKEN_ERROR:
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  default:
    return JSON_ERROR_INVALID_TOKEN;
  }
  return ret_val;
 }
 else {
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  char* fld_name = 0;
  size_t name_len = 0;
  dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
  if (JSON_TOKEN_NAME != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
    return JSON_ERROR_FATAL;
  } else {
if (9 == name_len && 0 == strncmp(fld_name, "derivable", name_len)) {
      int ret_val = derivable().JSON_decode(Reject_invokeIDRej_derivable_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "derivable");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (13 == name_len && 0 == strncmp(fld_name, "not_derivable", name_len)) {
      int ret_val = not__derivable().JSON_decode(ASN_NULL_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "not_derivable");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
      return JSON_ERROR_FATAL;
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
 }
}

int Reject_invokeIDRej::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_derivable:
    {TTCN_Buffer buf;
    encode_oer_tag(*Reject_invokeIDRej_derivable_descr_.ber, p_buf);
    field_derivable->OER_encode(Reject_invokeIDRej_derivable_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_not__derivable:
    {TTCN_Buffer buf;
    encode_oer_tag(*ASN_NULL_descr_.ber, p_buf);
    field_not__derivable->OER_encode(ASN_NULL_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.Reject.invokeIDRej.");
    return -1;
  }

  return 0;
}
int Reject_invokeIDRej::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (Reject_invokeIDRej_derivable_descr_.ber->tags[Reject_invokeIDRej_derivable_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      Reject_invokeIDRej_derivable_descr_.ber->tags[Reject_invokeIDRej_derivable_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    derivable().OER_decode(Reject_invokeIDRej_derivable_descr_, p_buf, p_oer);
  } else 
  if (ASN_NULL_descr_.ber->tags[ASN_NULL_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      ASN_NULL_descr_.ber->tags[ASN_NULL_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    not__derivable().OER_decode(ASN_NULL_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type Reject_invokeIDRej");
}
  return 0;
}
void Reject_invokeIDRej::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
switch (union_selection) {
case ALT_derivable: {
INTEGER::PER_encode_int(p_buf, 0, 1);
field_derivable->PER_encode(Reject_invokeIDRej_derivable_descr_, p_buf, p_options);
break; }
case ALT_not__derivable: {
INTEGER::PER_encode_int(p_buf, 1, 1);
field_not__derivable->PER_encode(ASN_NULL_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void Reject_invokeIDRej::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
int sel_int;
INTEGER::PER_decode_int(p_buf, 1, FALSE, sel_int);
switch (sel_int) {
case 0:
derivable().PER_decode(Reject_invokeIDRej_derivable_descr_, p_buf, p_options);
break;
case 1:
not__derivable().PER_decode(ASN_NULL_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}

void Reject_invokeIDRej_template::copy_value(const Reject_invokeIDRej& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
single_value.field_derivable = new INTEGER_template(other_value.derivable());
break;
case Reject_invokeIDRej::ALT_not__derivable:
single_value.field_not__derivable = new ASN_NULL_template(other_value.not__derivable());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @TCAPMessages.Reject.invokeIDRej.");
}
set_selection(SPECIFIC_VALUE);
}

void Reject_invokeIDRej_template::copy_template(const Reject_invokeIDRej_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
single_value.field_derivable = new INTEGER_template(*other_value.single_value.field_derivable);
break;
case Reject_invokeIDRej::ALT_not__derivable:
single_value.field_not__derivable = new ASN_NULL_template(*other_value.single_value.field_not__derivable);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @TCAPMessages.Reject.invokeIDRej.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Reject_invokeIDRej_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Reject_invokeIDRej_template(*other_value.implication_.precondition);
implication_.implied_template = new Reject_invokeIDRej_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @TCAPMessages.Reject.invokeIDRej.");
}
set_selection(other_value);
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template()
{
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template(const Reject_invokeIDRej& other_value)
{
copy_value(other_value);
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template(const OPTIONAL<Reject_invokeIDRej>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reject_invokeIDRej&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @TCAPMessages.Reject.invokeIDRej from an unbound optional field.");
}
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template(Reject_invokeIDRej_template* p_precondition, Reject_invokeIDRej_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template(Dynamic_Match_Interface<Reject_invokeIDRej>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Reject_invokeIDRej>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Reject_invokeIDRej_template::Reject_invokeIDRej_template(const Reject_invokeIDRej_template& other_value)
: Base_Template(){
copy_template(other_value);
}

Reject_invokeIDRej_template::~Reject_invokeIDRej_template()
{
clean_up();
}

void Reject_invokeIDRej_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
delete single_value.field_derivable;
break;
case Reject_invokeIDRej::ALT_not__derivable:
delete single_value.field_not__derivable;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Reject_invokeIDRej_template& Reject_invokeIDRej_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Reject_invokeIDRej_template& Reject_invokeIDRej_template::operator=(const Reject_invokeIDRej& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Reject_invokeIDRej_template& Reject_invokeIDRej_template::operator=(const OPTIONAL<Reject_invokeIDRej>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reject_invokeIDRej&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @TCAPMessages.Reject.invokeIDRej.");
}
return *this;
}

Reject_invokeIDRej_template& Reject_invokeIDRej_template::operator=(const Reject_invokeIDRej_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Reject_invokeIDRej_template::match(const Reject_invokeIDRej& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
Reject_invokeIDRej::union_selection_type value_selection = other_value.get_selection();
if (value_selection == Reject_invokeIDRej::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case Reject_invokeIDRej::ALT_derivable:
return single_value.field_derivable->match(other_value.derivable(), legacy);
case Reject_invokeIDRej::ALT_not__derivable:
return single_value.field_not__derivable->match(other_value.not__derivable(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @TCAPMessages.Reject.invokeIDRej.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @TCAPMessages.Reject.invokeIDRej.");
}
return FALSE;
}

boolean Reject_invokeIDRej_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
return single_value.field_derivable->is_value();
case Reject_invokeIDRej::ALT_not__derivable:
return single_value.field_not__derivable->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @TCAPMessages.Reject.invokeIDRej.");
}
}

Reject_invokeIDRej Reject_invokeIDRej_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @TCAPMessages.Reject.invokeIDRej.");
Reject_invokeIDRej ret_val;
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
ret_val.derivable() = single_value.field_derivable->valueof();
break;
case Reject_invokeIDRej::ALT_not__derivable:
ret_val.not__derivable() = single_value.field_not__derivable->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @TCAPMessages.Reject.invokeIDRej.");
}
return ret_val;
}

Reject_invokeIDRej_template& Reject_invokeIDRej_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @TCAPMessages.Reject.invokeIDRej.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @TCAPMessages.Reject.invokeIDRej.");
return value_list.list_value[list_index];
}
void Reject_invokeIDRej_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @TCAPMessages.Reject.invokeIDRej.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Reject_invokeIDRej_template[list_length];
}

INTEGER_template& Reject_invokeIDRej_template::derivable()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reject_invokeIDRej::ALT_derivable) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_derivable = new INTEGER_template(ANY_VALUE);
else single_value.field_derivable = new INTEGER_template;
single_value.union_selection = Reject_invokeIDRej::ALT_derivable;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_derivable;
}

const INTEGER_template& Reject_invokeIDRej_template::derivable() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field derivable in a non-specific template of union type @TCAPMessages.Reject.invokeIDRej.");
if (single_value.union_selection != Reject_invokeIDRej::ALT_derivable) TTCN_error("Accessing non-selected field derivable in a template of union type @TCAPMessages.Reject.invokeIDRej.");
return *single_value.field_derivable;
}

ASN_NULL_template& Reject_invokeIDRej_template::not__derivable()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reject_invokeIDRej::ALT_not__derivable) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_not__derivable = new ASN_NULL_template(ANY_VALUE);
else single_value.field_not__derivable = new ASN_NULL_template;
single_value.union_selection = Reject_invokeIDRej::ALT_not__derivable;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_not__derivable;
}

const ASN_NULL_template& Reject_invokeIDRej_template::not__derivable() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field not_derivable in a non-specific template of union type @TCAPMessages.Reject.invokeIDRej.");
if (single_value.union_selection != Reject_invokeIDRej::ALT_not__derivable) TTCN_error("Accessing non-selected field not_derivable in a template of union type @TCAPMessages.Reject.invokeIDRej.");
return *single_value.field_not__derivable;
}

boolean Reject_invokeIDRej_template::ischosen(Reject_invokeIDRej::union_selection_type checked_selection) const
{
if (checked_selection == Reject_invokeIDRej::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.Reject.invokeIDRej.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == Reject_invokeIDRej::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @TCAPMessages.Reject.invokeIDRej.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @TCAPMessages.Reject.invokeIDRej containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void Reject_invokeIDRej_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
TTCN_Logger::log_event_str("{ derivable := ");
single_value.field_derivable->log();
TTCN_Logger::log_event_str(" }");
break;
case Reject_invokeIDRej::ALT_not__derivable:
TTCN_Logger::log_event_str("{ not_derivable := ");
single_value.field_not__derivable->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Reject_invokeIDRej_template::log_match(const Reject_invokeIDRej& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".derivable");
single_value.field_derivable->log_match(match_value.derivable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ derivable := ");
single_value.field_derivable->log_match(match_value.derivable(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case Reject_invokeIDRej::ALT_not__derivable:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".not_derivable");
single_value.field_not__derivable->log_match(match_value.not__derivable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ not_derivable := ");
single_value.field_not__derivable->log_match(match_value.not__derivable(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Reject_invokeIDRej_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
single_value.field_derivable->set_implicit_omit(); break;
case Reject_invokeIDRej::ALT_not__derivable:
single_value.field_not__derivable->set_implicit_omit(); break;
default: break;
}
}

void Reject_invokeIDRej_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
single_value.field_derivable->encode_text(text_buf);
break;
case Reject_invokeIDRej::ALT_not__derivable:
single_value.field_not__derivable->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @TCAPMessages.Reject.invokeIDRej.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @TCAPMessages.Reject.invokeIDRej.");
}
}

void Reject_invokeIDRej_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = Reject_invokeIDRej::UNBOUND_VALUE;
Reject_invokeIDRej::union_selection_type new_selection = (Reject_invokeIDRej::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case Reject_invokeIDRej::ALT_derivable:
single_value.field_derivable = new INTEGER_template;
single_value.field_derivable->decode_text(text_buf);
break;
case Reject_invokeIDRej::ALT_not__derivable:
single_value.field_not__derivable = new ASN_NULL_template;
single_value.field_not__derivable->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @TCAPMessages.Reject.invokeIDRej.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Reject_invokeIDRej_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @TCAPMessages.Reject.invokeIDRej.");
}
}

boolean Reject_invokeIDRej_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Reject_invokeIDRej_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Reject_invokeIDRej_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@TCAPMessages.Reject.invokeIDRej'");
    }
    if (strcmp("derivable", param_field) == 0) {
      derivable().set_param(param);
      return;
    } else if (strcmp("not_derivable", param_field) == 0) {
      not__derivable().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@TCAPMessages.Reject.invokeIDRej'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Reject_invokeIDRej_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@TCAPMessages.Reject.invokeIDRej");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "derivable")) {
      derivable().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "not_derivable")) {
      not__derivable().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @TCAPMessages.Reject.invokeIDRej.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    Reject_invokeIDRej_template* precondition = new Reject_invokeIDRej_template;
    precondition->set_param(*m_p->get_elem(0));
    Reject_invokeIDRej_template* implied_template = new Reject_invokeIDRej_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = Reject_invokeIDRej_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@TCAPMessages.Reject.invokeIDRej");
  }
  is_ifpresent = param.get_ifpresent();
}

void Reject_invokeIDRej_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case Reject_invokeIDRej::ALT_derivable:
single_value.field_derivable->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject.invokeIDRej");
return;
case Reject_invokeIDRej::ALT_not__derivable:
single_value.field_not__derivable->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject.invokeIDRej");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @TCAPMessages.Reject.invokeIDRej.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Reject.invokeIDRej");
}

void Reject_problem::copy_value(const Reject_problem& other_value)
{
switch (other_value.union_selection) {
case ALT_generalProblem:
field_generalProblem = new INTEGER(*other_value.field_generalProblem);
break;
case ALT_invokeProblem:
field_invokeProblem = new INTEGER(*other_value.field_invokeProblem);
break;
case ALT_returnResultProblem:
field_returnResultProblem = new INTEGER(*other_value.field_returnResultProblem);
break;
case ALT_returnErrorProblem:
field_returnErrorProblem = new INTEGER(*other_value.field_returnErrorProblem);
break;
default:
TTCN_error("Assignment of an unbound union value of type @TCAPMessages.Reject.problem.");
}
union_selection = other_value.union_selection;
}

Reject_problem::Reject_problem()
{
union_selection = UNBOUND_VALUE;
}

Reject_problem::Reject_problem(const Reject_problem& other_value)
: Base_Type(){
copy_value(other_value);
}

Reject_problem::~Reject_problem()
{
clean_up();
}

Reject_problem& Reject_problem::operator=(const Reject_problem& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean Reject_problem::operator==(const Reject_problem& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @TCAPMessages.Reject.problem.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @TCAPMessages.Reject.problem.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_generalProblem:
return *field_generalProblem == *other_value.field_generalProblem;
case ALT_invokeProblem:
return *field_invokeProblem == *other_value.field_invokeProblem;
case ALT_returnResultProblem:
return *field_returnResultProblem == *other_value.field_returnResultProblem;
case ALT_returnErrorProblem:
return *field_returnErrorProblem == *other_value.field_returnErrorProblem;
default:
return FALSE;
}
}

INTEGER& Reject_problem::generalProblem()
{
if (union_selection != ALT_generalProblem) {
clean_up();
field_generalProblem = new INTEGER;
union_selection = ALT_generalProblem;
}
return *field_generalProblem;
}

const INTEGER& Reject_problem::generalProblem() const
{
if (union_selection != ALT_generalProblem) TTCN_error("Using non-selected field generalProblem in a value of union type @TCAPMessages.Reject.problem.");
return *field_generalProblem;
}

INTEGER& Reject_problem::invokeProblem()
{
if (union_selection != ALT_invokeProblem) {
clean_up();
field_invokeProblem = new INTEGER;
union_selection = ALT_invokeProblem;
}
return *field_invokeProblem;
}

const INTEGER& Reject_problem::invokeProblem() const
{
if (union_selection != ALT_invokeProblem) TTCN_error("Using non-selected field invokeProblem in a value of union type @TCAPMessages.Reject.problem.");
return *field_invokeProblem;
}

INTEGER& Reject_problem::returnResultProblem()
{
if (union_selection != ALT_returnResultProblem) {
clean_up();
field_returnResultProblem = new INTEGER;
union_selection = ALT_returnResultProblem;
}
return *field_returnResultProblem;
}

const INTEGER& Reject_problem::returnResultProblem() const
{
if (union_selection != ALT_returnResultProblem) TTCN_error("Using non-selected field returnResultProblem in a value of union type @TCAPMessages.Reject.problem.");
return *field_returnResultProblem;
}

INTEGER& Reject_problem::returnErrorProblem()
{
if (union_selection != ALT_returnErrorProblem) {
clean_up();
field_returnErrorProblem = new INTEGER;
union_selection = ALT_returnErrorProblem;
}
return *field_returnErrorProblem;
}

const INTEGER& Reject_problem::returnErrorProblem() const
{
if (union_selection != ALT_returnErrorProblem) TTCN_error("Using non-selected field returnErrorProblem in a value of union type @TCAPMessages.Reject.problem.");
return *field_returnErrorProblem;
}

boolean Reject_problem::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.Reject.problem.");
return union_selection == checked_selection;
}

boolean Reject_problem::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean Reject_problem::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_generalProblem: return field_generalProblem->is_value();
case ALT_invokeProblem: return field_invokeProblem->is_value();
case ALT_returnResultProblem: return field_returnResultProblem->is_value();
case ALT_returnErrorProblem: return field_returnErrorProblem->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void Reject_problem::clean_up()
{
switch (union_selection) {
case ALT_generalProblem:
  delete field_generalProblem;
  break;
case ALT_invokeProblem:
  delete field_invokeProblem;
  break;
case ALT_returnResultProblem:
  delete field_returnResultProblem;
  break;
case ALT_returnErrorProblem:
  delete field_returnErrorProblem;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void Reject_problem::log() const
{
switch (union_selection) {
case ALT_generalProblem:
TTCN_Logger::log_event_str("{ generalProblem := ");
field_generalProblem->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_invokeProblem:
TTCN_Logger::log_event_str("{ invokeProblem := ");
field_invokeProblem->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_returnResultProblem:
TTCN_Logger::log_event_str("{ returnResultProblem := ");
field_returnResultProblem->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_returnErrorProblem:
TTCN_Logger::log_event_str("{ returnErrorProblem := ");
field_returnErrorProblem->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void Reject_problem::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "generalProblem")) {
    generalProblem().set_param(*mp_last);
    if (!generalProblem().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "invokeProblem")) {
    invokeProblem().set_param(*mp_last);
    if (!invokeProblem().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "returnResultProblem")) {
    returnResultProblem().set_param(*mp_last);
    if (!returnResultProblem().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "returnErrorProblem")) {
    returnErrorProblem().set_param(*mp_last);
    if (!returnErrorProblem().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @TCAPMessages.Reject.problem.", last_name);
}

void Reject_problem::set_implicit_omit()
{
switch (union_selection) {
case ALT_generalProblem:
field_generalProblem->set_implicit_omit(); break;
case ALT_invokeProblem:
field_invokeProblem->set_implicit_omit(); break;
case ALT_returnResultProblem:
field_returnResultProblem->set_implicit_omit(); break;
case ALT_returnErrorProblem:
field_returnErrorProblem->set_implicit_omit(); break;
default: break;
}
}

void Reject_problem::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_generalProblem:
field_generalProblem->encode_text(text_buf);
break;
case ALT_invokeProblem:
field_invokeProblem->encode_text(text_buf);
break;
case ALT_returnResultProblem:
field_returnResultProblem->encode_text(text_buf);
break;
case ALT_returnErrorProblem:
field_returnErrorProblem->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @TCAPMessages.Reject.problem.");
}
}

void Reject_problem::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_generalProblem:
generalProblem().decode_text(text_buf);
break;
case ALT_invokeProblem:
invokeProblem().decode_text(text_buf);
break;
case ALT_returnResultProblem:
returnResultProblem().decode_text(text_buf);
break;
case ALT_returnErrorProblem:
returnErrorProblem().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @TCAPMessages.Reject.problem.");
}
}

void Reject_problem::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Reject_problem::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *Reject_problem::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_generalProblem:
    ec_1.set_msg("generalProblem': ");
    new_tlv = field_generalProblem->BER_encode_TLV(Reject_problem_generalProblem_descr_, p_coding);
    break;
  case ALT_invokeProblem:
    ec_1.set_msg("invokeProblem': ");
    new_tlv = field_invokeProblem->BER_encode_TLV(Reject_problem_invokeProblem_descr_, p_coding);
    break;
  case ALT_returnResultProblem:
    ec_1.set_msg("returnResultProblem': ");
    new_tlv = field_returnResultProblem->BER_encode_TLV(Reject_problem_returnResultProblem_descr_, p_coding);
    break;
  case ALT_returnErrorProblem:
    ec_1.set_msg("returnErrorProblem': ");
    new_tlv = field_returnErrorProblem->BER_encode_TLV(Reject_problem_returnErrorProblem_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean Reject_problem::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_generalProblem = new INTEGER;
  union_selection = ALT_generalProblem;
  if (field_generalProblem->BER_decode_isMyMsg(Reject_problem_generalProblem_descr_, p_tlv)) return TRUE;
  delete field_generalProblem;
  field_invokeProblem = new INTEGER;
  union_selection = ALT_invokeProblem;
  if (field_invokeProblem->BER_decode_isMyMsg(Reject_problem_invokeProblem_descr_, p_tlv)) return TRUE;
  delete field_invokeProblem;
  field_returnResultProblem = new INTEGER;
  union_selection = ALT_returnResultProblem;
  if (field_returnResultProblem->BER_decode_isMyMsg(Reject_problem_returnResultProblem_descr_, p_tlv)) return TRUE;
  delete field_returnResultProblem;
  field_returnErrorProblem = new INTEGER;
  union_selection = ALT_returnErrorProblem;
  if (field_returnErrorProblem->BER_decode_isMyMsg(Reject_problem_returnErrorProblem_descr_, p_tlv)) return TRUE;
  delete field_returnErrorProblem;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean Reject_problem::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    Reject_problem tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean Reject_problem::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Reject.problem' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_generalProblem:
    ec_2.set_msg("generalProblem': ");
    field_generalProblem->BER_decode_TLV(Reject_problem_generalProblem_descr_, tmp_tlv, L_form);
    break;
  case ALT_invokeProblem:
    ec_2.set_msg("invokeProblem': ");
    field_invokeProblem->BER_decode_TLV(Reject_problem_invokeProblem_descr_, tmp_tlv, L_form);
    break;
  case ALT_returnResultProblem:
    ec_2.set_msg("returnResultProblem': ");
    field_returnResultProblem->BER_decode_TLV(Reject_problem_returnResultProblem_descr_, tmp_tlv, L_form);
    break;
  case ALT_returnErrorProblem:
    ec_2.set_msg("returnErrorProblem': ");
    field_returnErrorProblem->BER_decode_TLV(Reject_problem_returnErrorProblem_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int Reject_problem::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  boolean as_value = p_td.json->as_value;
  int enc_len = as_value ? 0 : p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
  switch(union_selection) {
  case ALT_generalProblem:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "generalProblem");
    }
    enc_len += field_generalProblem->JSON_encode(Reject_problem_generalProblem_descr_, p_tok, FALSE);
    break;
  case ALT_invokeProblem:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "invokeProblem");
    }
    enc_len += field_invokeProblem->JSON_encode(Reject_problem_invokeProblem_descr_, p_tok, FALSE);
    break;
  case ALT_returnResultProblem:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "returnResultProblem");
    }
    enc_len += field_returnResultProblem->JSON_encode(Reject_problem_returnResultProblem_descr_, p_tok, FALSE);
    break;
  case ALT_returnErrorProblem:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "returnErrorProblem");
    }
    enc_len += field_returnErrorProblem->JSON_encode(Reject_problem_returnErrorProblem_descr_, p_tok, FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.Reject.problem.");
    return -1;
  }

  if (!as_value) {
    enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  }
  return enc_len;
}

int Reject_problem::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  if (0 <= p_chosen_field && 4 > p_chosen_field) {
    switch (p_chosen_field) {
    case 0:
      return generalProblem().JSON_decode(Reject_problem_generalProblem_descr_, p_tok, TRUE, FALSE);
    case 1:
      return invokeProblem().JSON_decode(Reject_problem_invokeProblem_descr_, p_tok, TRUE, FALSE);
    case 2:
      return returnResultProblem().JSON_decode(Reject_problem_returnResultProblem_descr_, p_tok, TRUE, FALSE);
    case 3:
      return returnErrorProblem().JSON_decode(Reject_problem_returnErrorProblem_descr_, p_tok, TRUE, FALSE);
    }
  }
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const Reject_problem*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
 if (p_td.json->as_value) {
  size_t buf_pos = p_tok.get_buf_pos();
  p_tok.get_next_token(&j_token, NULL, NULL);
  int ret_val = 0;
  switch(j_token) {
  case JSON_TOKEN_NUMBER: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = generalProblem().JSON_decode(Reject_problem_generalProblem_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = invokeProblem().JSON_decode(Reject_problem_invokeProblem_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = returnResultProblem().JSON_decode(Reject_problem_returnResultProblem_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = returnErrorProblem().JSON_decode(Reject_problem_returnErrorProblem_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "number '@TCAPMessages.Reject.problem'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_STRING: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "string '@TCAPMessages.Reject.problem'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_TRUE:
  case JSON_TOKEN_LITERAL_FALSE: {
    char* literal_str = mprintf("literal (%s)",
      (JSON_TOKEN_LITERAL_TRUE == j_token) ? "true" : "false");
    try {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, literal_str);
    }
    catch (const TC_Error&) {
      Free(literal_str);
      throw;
    }
    Free(literal_str);
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_ARRAY_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "array '@TCAPMessages.Reject.problem'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_OBJECT_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "object '@TCAPMessages.Reject.problem'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_NULL: {
    clean_up();
    return JSON_ERROR_INVALID_TOKEN;
  }
  case JSON_TOKEN_ERROR:
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  default:
    return JSON_ERROR_INVALID_TOKEN;
  }
  return ret_val;
 }
 else {
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  char* fld_name = 0;
  size_t name_len = 0;
  dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
  if (JSON_TOKEN_NAME != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
    return JSON_ERROR_FATAL;
  } else {
if (14 == name_len && 0 == strncmp(fld_name, "generalProblem", name_len)) {
      int ret_val = generalProblem().JSON_decode(Reject_problem_generalProblem_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "generalProblem");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (13 == name_len && 0 == strncmp(fld_name, "invokeProblem", name_len)) {
      int ret_val = invokeProblem().JSON_decode(Reject_problem_invokeProblem_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "invokeProblem");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (19 == name_len && 0 == strncmp(fld_name, "returnResultProblem", name_len)) {
      int ret_val = returnResultProblem().JSON_decode(Reject_problem_returnResultProblem_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "returnResultProblem");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (18 == name_len && 0 == strncmp(fld_name, "returnErrorProblem", name_len)) {
      int ret_val = returnErrorProblem().JSON_decode(Reject_problem_returnErrorProblem_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "returnErrorProblem");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
      return JSON_ERROR_FATAL;
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
 }
}

int Reject_problem::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_generalProblem:
    {TTCN_Buffer buf;
    encode_oer_tag(*Reject_problem_generalProblem_descr_.ber, p_buf);
    field_generalProblem->OER_encode(Reject_problem_generalProblem_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_invokeProblem:
    {TTCN_Buffer buf;
    encode_oer_tag(*Reject_problem_invokeProblem_descr_.ber, p_buf);
    field_invokeProblem->OER_encode(Reject_problem_invokeProblem_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_returnResultProblem:
    {TTCN_Buffer buf;
    encode_oer_tag(*Reject_problem_returnResultProblem_descr_.ber, p_buf);
    field_returnResultProblem->OER_encode(Reject_problem_returnResultProblem_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_returnErrorProblem:
    {TTCN_Buffer buf;
    encode_oer_tag(*Reject_problem_returnErrorProblem_descr_.ber, p_buf);
    field_returnErrorProblem->OER_encode(Reject_problem_returnErrorProblem_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.Reject.problem.");
    return -1;
  }

  return 0;
}
int Reject_problem::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (Reject_problem_generalProblem_descr_.ber->tags[Reject_problem_generalProblem_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      Reject_problem_generalProblem_descr_.ber->tags[Reject_problem_generalProblem_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    generalProblem().OER_decode(Reject_problem_generalProblem_descr_, p_buf, p_oer);
  } else 
  if (Reject_problem_invokeProblem_descr_.ber->tags[Reject_problem_invokeProblem_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      Reject_problem_invokeProblem_descr_.ber->tags[Reject_problem_invokeProblem_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    invokeProblem().OER_decode(Reject_problem_invokeProblem_descr_, p_buf, p_oer);
  } else 
  if (Reject_problem_returnResultProblem_descr_.ber->tags[Reject_problem_returnResultProblem_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      Reject_problem_returnResultProblem_descr_.ber->tags[Reject_problem_returnResultProblem_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    returnResultProblem().OER_decode(Reject_problem_returnResultProblem_descr_, p_buf, p_oer);
  } else 
  if (Reject_problem_returnErrorProblem_descr_.ber->tags[Reject_problem_returnErrorProblem_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      Reject_problem_returnErrorProblem_descr_.ber->tags[Reject_problem_returnErrorProblem_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    returnErrorProblem().OER_decode(Reject_problem_returnErrorProblem_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type Reject_problem");
}
  return 0;
}
void Reject_problem::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
switch (union_selection) {
case ALT_generalProblem: {
INTEGER::PER_encode_int(p_buf, 0, 2);
field_generalProblem->PER_encode(Reject_problem_generalProblem_descr_, p_buf, p_options);
break; }
case ALT_invokeProblem: {
INTEGER::PER_encode_int(p_buf, 1, 2);
field_invokeProblem->PER_encode(Reject_problem_invokeProblem_descr_, p_buf, p_options);
break; }
case ALT_returnResultProblem: {
INTEGER::PER_encode_int(p_buf, 2, 2);
field_returnResultProblem->PER_encode(Reject_problem_returnResultProblem_descr_, p_buf, p_options);
break; }
case ALT_returnErrorProblem: {
INTEGER::PER_encode_int(p_buf, 3, 2);
field_returnErrorProblem->PER_encode(Reject_problem_returnErrorProblem_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void Reject_problem::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
int sel_int;
INTEGER::PER_decode_int(p_buf, 2, FALSE, sel_int);
switch (sel_int) {
case 0:
generalProblem().PER_decode(Reject_problem_generalProblem_descr_, p_buf, p_options);
break;
case 1:
invokeProblem().PER_decode(Reject_problem_invokeProblem_descr_, p_buf, p_options);
break;
case 2:
returnResultProblem().PER_decode(Reject_problem_returnResultProblem_descr_, p_buf, p_options);
break;
case 3:
returnErrorProblem().PER_decode(Reject_problem_returnErrorProblem_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}

void Reject_problem_template::copy_value(const Reject_problem& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
single_value.field_generalProblem = new INTEGER_template(other_value.generalProblem());
break;
case Reject_problem::ALT_invokeProblem:
single_value.field_invokeProblem = new INTEGER_template(other_value.invokeProblem());
break;
case Reject_problem::ALT_returnResultProblem:
single_value.field_returnResultProblem = new INTEGER_template(other_value.returnResultProblem());
break;
case Reject_problem::ALT_returnErrorProblem:
single_value.field_returnErrorProblem = new INTEGER_template(other_value.returnErrorProblem());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @TCAPMessages.Reject.problem.");
}
set_selection(SPECIFIC_VALUE);
}

void Reject_problem_template::copy_template(const Reject_problem_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
single_value.field_generalProblem = new INTEGER_template(*other_value.single_value.field_generalProblem);
break;
case Reject_problem::ALT_invokeProblem:
single_value.field_invokeProblem = new INTEGER_template(*other_value.single_value.field_invokeProblem);
break;
case Reject_problem::ALT_returnResultProblem:
single_value.field_returnResultProblem = new INTEGER_template(*other_value.single_value.field_returnResultProblem);
break;
case Reject_problem::ALT_returnErrorProblem:
single_value.field_returnErrorProblem = new INTEGER_template(*other_value.single_value.field_returnErrorProblem);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @TCAPMessages.Reject.problem.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Reject_problem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Reject_problem_template(*other_value.implication_.precondition);
implication_.implied_template = new Reject_problem_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @TCAPMessages.Reject.problem.");
}
set_selection(other_value);
}

Reject_problem_template::Reject_problem_template()
{
}

Reject_problem_template::Reject_problem_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Reject_problem_template::Reject_problem_template(const Reject_problem& other_value)
{
copy_value(other_value);
}

Reject_problem_template::Reject_problem_template(const OPTIONAL<Reject_problem>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reject_problem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @TCAPMessages.Reject.problem from an unbound optional field.");
}
}

Reject_problem_template::Reject_problem_template(Reject_problem_template* p_precondition, Reject_problem_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Reject_problem_template::Reject_problem_template(Dynamic_Match_Interface<Reject_problem>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Reject_problem>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Reject_problem_template::Reject_problem_template(const Reject_problem_template& other_value)
: Base_Template(){
copy_template(other_value);
}

Reject_problem_template::~Reject_problem_template()
{
clean_up();
}

void Reject_problem_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
delete single_value.field_generalProblem;
break;
case Reject_problem::ALT_invokeProblem:
delete single_value.field_invokeProblem;
break;
case Reject_problem::ALT_returnResultProblem:
delete single_value.field_returnResultProblem;
break;
case Reject_problem::ALT_returnErrorProblem:
delete single_value.field_returnErrorProblem;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Reject_problem_template& Reject_problem_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Reject_problem_template& Reject_problem_template::operator=(const Reject_problem& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Reject_problem_template& Reject_problem_template::operator=(const OPTIONAL<Reject_problem>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reject_problem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @TCAPMessages.Reject.problem.");
}
return *this;
}

Reject_problem_template& Reject_problem_template::operator=(const Reject_problem_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Reject_problem_template::match(const Reject_problem& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
Reject_problem::union_selection_type value_selection = other_value.get_selection();
if (value_selection == Reject_problem::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case Reject_problem::ALT_generalProblem:
return single_value.field_generalProblem->match(other_value.generalProblem(), legacy);
case Reject_problem::ALT_invokeProblem:
return single_value.field_invokeProblem->match(other_value.invokeProblem(), legacy);
case Reject_problem::ALT_returnResultProblem:
return single_value.field_returnResultProblem->match(other_value.returnResultProblem(), legacy);
case Reject_problem::ALT_returnErrorProblem:
return single_value.field_returnErrorProblem->match(other_value.returnErrorProblem(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @TCAPMessages.Reject.problem.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @TCAPMessages.Reject.problem.");
}
return FALSE;
}

boolean Reject_problem_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
return single_value.field_generalProblem->is_value();
case Reject_problem::ALT_invokeProblem:
return single_value.field_invokeProblem->is_value();
case Reject_problem::ALT_returnResultProblem:
return single_value.field_returnResultProblem->is_value();
case Reject_problem::ALT_returnErrorProblem:
return single_value.field_returnErrorProblem->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @TCAPMessages.Reject.problem.");
}
}

Reject_problem Reject_problem_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @TCAPMessages.Reject.problem.");
Reject_problem ret_val;
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
ret_val.generalProblem() = single_value.field_generalProblem->valueof();
break;
case Reject_problem::ALT_invokeProblem:
ret_val.invokeProblem() = single_value.field_invokeProblem->valueof();
break;
case Reject_problem::ALT_returnResultProblem:
ret_val.returnResultProblem() = single_value.field_returnResultProblem->valueof();
break;
case Reject_problem::ALT_returnErrorProblem:
ret_val.returnErrorProblem() = single_value.field_returnErrorProblem->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @TCAPMessages.Reject.problem.");
}
return ret_val;
}

Reject_problem_template& Reject_problem_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @TCAPMessages.Reject.problem.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @TCAPMessages.Reject.problem.");
return value_list.list_value[list_index];
}
void Reject_problem_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @TCAPMessages.Reject.problem.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Reject_problem_template[list_length];
}

INTEGER_template& Reject_problem_template::generalProblem()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reject_problem::ALT_generalProblem) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_generalProblem = new INTEGER_template(ANY_VALUE);
else single_value.field_generalProblem = new INTEGER_template;
single_value.union_selection = Reject_problem::ALT_generalProblem;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_generalProblem;
}

const INTEGER_template& Reject_problem_template::generalProblem() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field generalProblem in a non-specific template of union type @TCAPMessages.Reject.problem.");
if (single_value.union_selection != Reject_problem::ALT_generalProblem) TTCN_error("Accessing non-selected field generalProblem in a template of union type @TCAPMessages.Reject.problem.");
return *single_value.field_generalProblem;
}

INTEGER_template& Reject_problem_template::invokeProblem()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reject_problem::ALT_invokeProblem) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_invokeProblem = new INTEGER_template(ANY_VALUE);
else single_value.field_invokeProblem = new INTEGER_template;
single_value.union_selection = Reject_problem::ALT_invokeProblem;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_invokeProblem;
}

const INTEGER_template& Reject_problem_template::invokeProblem() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field invokeProblem in a non-specific template of union type @TCAPMessages.Reject.problem.");
if (single_value.union_selection != Reject_problem::ALT_invokeProblem) TTCN_error("Accessing non-selected field invokeProblem in a template of union type @TCAPMessages.Reject.problem.");
return *single_value.field_invokeProblem;
}

INTEGER_template& Reject_problem_template::returnResultProblem()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reject_problem::ALT_returnResultProblem) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_returnResultProblem = new INTEGER_template(ANY_VALUE);
else single_value.field_returnResultProblem = new INTEGER_template;
single_value.union_selection = Reject_problem::ALT_returnResultProblem;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_returnResultProblem;
}

const INTEGER_template& Reject_problem_template::returnResultProblem() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field returnResultProblem in a non-specific template of union type @TCAPMessages.Reject.problem.");
if (single_value.union_selection != Reject_problem::ALT_returnResultProblem) TTCN_error("Accessing non-selected field returnResultProblem in a template of union type @TCAPMessages.Reject.problem.");
return *single_value.field_returnResultProblem;
}

INTEGER_template& Reject_problem_template::returnErrorProblem()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reject_problem::ALT_returnErrorProblem) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_returnErrorProblem = new INTEGER_template(ANY_VALUE);
else single_value.field_returnErrorProblem = new INTEGER_template;
single_value.union_selection = Reject_problem::ALT_returnErrorProblem;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_returnErrorProblem;
}

const INTEGER_template& Reject_problem_template::returnErrorProblem() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field returnErrorProblem in a non-specific template of union type @TCAPMessages.Reject.problem.");
if (single_value.union_selection != Reject_problem::ALT_returnErrorProblem) TTCN_error("Accessing non-selected field returnErrorProblem in a template of union type @TCAPMessages.Reject.problem.");
return *single_value.field_returnErrorProblem;
}

boolean Reject_problem_template::ischosen(Reject_problem::union_selection_type checked_selection) const
{
if (checked_selection == Reject_problem::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.Reject.problem.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == Reject_problem::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @TCAPMessages.Reject.problem.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @TCAPMessages.Reject.problem containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void Reject_problem_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
TTCN_Logger::log_event_str("{ generalProblem := ");
single_value.field_generalProblem->log();
TTCN_Logger::log_event_str(" }");
break;
case Reject_problem::ALT_invokeProblem:
TTCN_Logger::log_event_str("{ invokeProblem := ");
single_value.field_invokeProblem->log();
TTCN_Logger::log_event_str(" }");
break;
case Reject_problem::ALT_returnResultProblem:
TTCN_Logger::log_event_str("{ returnResultProblem := ");
single_value.field_returnResultProblem->log();
TTCN_Logger::log_event_str(" }");
break;
case Reject_problem::ALT_returnErrorProblem:
TTCN_Logger::log_event_str("{ returnErrorProblem := ");
single_value.field_returnErrorProblem->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Reject_problem_template::log_match(const Reject_problem& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".generalProblem");
single_value.field_generalProblem->log_match(match_value.generalProblem(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ generalProblem := ");
single_value.field_generalProblem->log_match(match_value.generalProblem(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case Reject_problem::ALT_invokeProblem:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".invokeProblem");
single_value.field_invokeProblem->log_match(match_value.invokeProblem(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ invokeProblem := ");
single_value.field_invokeProblem->log_match(match_value.invokeProblem(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case Reject_problem::ALT_returnResultProblem:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".returnResultProblem");
single_value.field_returnResultProblem->log_match(match_value.returnResultProblem(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ returnResultProblem := ");
single_value.field_returnResultProblem->log_match(match_value.returnResultProblem(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case Reject_problem::ALT_returnErrorProblem:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".returnErrorProblem");
single_value.field_returnErrorProblem->log_match(match_value.returnErrorProblem(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ returnErrorProblem := ");
single_value.field_returnErrorProblem->log_match(match_value.returnErrorProblem(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Reject_problem_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
single_value.field_generalProblem->set_implicit_omit(); break;
case Reject_problem::ALT_invokeProblem:
single_value.field_invokeProblem->set_implicit_omit(); break;
case Reject_problem::ALT_returnResultProblem:
single_value.field_returnResultProblem->set_implicit_omit(); break;
case Reject_problem::ALT_returnErrorProblem:
single_value.field_returnErrorProblem->set_implicit_omit(); break;
default: break;
}
}

void Reject_problem_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
single_value.field_generalProblem->encode_text(text_buf);
break;
case Reject_problem::ALT_invokeProblem:
single_value.field_invokeProblem->encode_text(text_buf);
break;
case Reject_problem::ALT_returnResultProblem:
single_value.field_returnResultProblem->encode_text(text_buf);
break;
case Reject_problem::ALT_returnErrorProblem:
single_value.field_returnErrorProblem->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @TCAPMessages.Reject.problem.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @TCAPMessages.Reject.problem.");
}
}

void Reject_problem_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = Reject_problem::UNBOUND_VALUE;
Reject_problem::union_selection_type new_selection = (Reject_problem::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case Reject_problem::ALT_generalProblem:
single_value.field_generalProblem = new INTEGER_template;
single_value.field_generalProblem->decode_text(text_buf);
break;
case Reject_problem::ALT_invokeProblem:
single_value.field_invokeProblem = new INTEGER_template;
single_value.field_invokeProblem->decode_text(text_buf);
break;
case Reject_problem::ALT_returnResultProblem:
single_value.field_returnResultProblem = new INTEGER_template;
single_value.field_returnResultProblem->decode_text(text_buf);
break;
case Reject_problem::ALT_returnErrorProblem:
single_value.field_returnErrorProblem = new INTEGER_template;
single_value.field_returnErrorProblem->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @TCAPMessages.Reject.problem.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Reject_problem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @TCAPMessages.Reject.problem.");
}
}

boolean Reject_problem_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Reject_problem_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Reject_problem_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@TCAPMessages.Reject.problem'");
    }
    if (strcmp("generalProblem", param_field) == 0) {
      generalProblem().set_param(param);
      return;
    } else if (strcmp("invokeProblem", param_field) == 0) {
      invokeProblem().set_param(param);
      return;
    } else if (strcmp("returnResultProblem", param_field) == 0) {
      returnResultProblem().set_param(param);
      return;
    } else if (strcmp("returnErrorProblem", param_field) == 0) {
      returnErrorProblem().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@TCAPMessages.Reject.problem'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Reject_problem_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@TCAPMessages.Reject.problem");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "generalProblem")) {
      generalProblem().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "invokeProblem")) {
      invokeProblem().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "returnResultProblem")) {
      returnResultProblem().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "returnErrorProblem")) {
      returnErrorProblem().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @TCAPMessages.Reject.problem.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    Reject_problem_template* precondition = new Reject_problem_template;
    precondition->set_param(*m_p->get_elem(0));
    Reject_problem_template* implied_template = new Reject_problem_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = Reject_problem_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@TCAPMessages.Reject.problem");
  }
  is_ifpresent = param.get_ifpresent();
}

void Reject_problem_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case Reject_problem::ALT_generalProblem:
single_value.field_generalProblem->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject.problem");
return;
case Reject_problem::ALT_invokeProblem:
single_value.field_invokeProblem->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject.problem");
return;
case Reject_problem::ALT_returnResultProblem:
single_value.field_returnResultProblem->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject.problem");
return;
case Reject_problem::ALT_returnErrorProblem:
single_value.field_returnErrorProblem->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject.problem");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @TCAPMessages.Reject.problem.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Reject.problem");
}

Reject::Reject()
{
}

Reject::Reject(const Reject_invokeIDRej& par_invokeIDRej,
    const Reject_problem& par_problem)
  :   field_invokeIDRej(par_invokeIDRej),
  field_problem(par_problem)
{
}

Reject::Reject(const Reject& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @TCAPMessages.Reject.");
if (other_value.invokeIDRej().is_bound()) field_invokeIDRej = other_value.invokeIDRej();
else field_invokeIDRej.clean_up();
if (other_value.problem().is_bound()) field_problem = other_value.problem();
else field_problem.clean_up();
}

void Reject::clean_up()
{
field_invokeIDRej.clean_up();
field_problem.clean_up();
}

const TTCN_Typedescriptor_t* Reject::get_descriptor() const { return &Reject_descr_; }
Reject& Reject::operator=(const Reject& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @TCAPMessages.Reject.");
  if (other_value.invokeIDRej().is_bound()) field_invokeIDRej = other_value.invokeIDRej();
  else field_invokeIDRej.clean_up();
  if (other_value.problem().is_bound()) field_problem = other_value.problem();
  else field_problem.clean_up();
}
return *this;
}

boolean Reject::operator==(const Reject& other_value) const
{
return field_invokeIDRej==other_value.field_invokeIDRej
  && field_problem==other_value.field_problem;
}

boolean Reject::is_bound() const
{
return (field_invokeIDRej.is_bound())
  || (field_problem.is_bound());
}
boolean Reject::is_value() const
{
return field_invokeIDRej.is_value()
  && field_problem.is_value();
}
void Reject::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ invokeIDRej := ");
field_invokeIDRej.log();
TTCN_Logger::log_event_str(", problem := ");
field_problem.log();
TTCN_Logger::log_event_str(" }");
}

void Reject::set_implicit_omit()
{
if (invokeIDRej().is_bound()) invokeIDRej().set_implicit_omit();
if (problem().is_bound()) problem().set_implicit_omit();
}

void Reject::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @TCAPMessages.Reject has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) invokeIDRej().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) problem().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "invokeIDRej")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          invokeIDRej().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "problem")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          problem().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Reject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@TCAPMessages.Reject");
  }
}

void Reject::encode_text(Text_Buf& text_buf) const
{
field_invokeIDRej.encode_text(text_buf);
field_problem.encode_text(text_buf);
}

void Reject::decode_text(Text_Buf& text_buf)
{
field_invokeIDRej.decode_text(text_buf);
field_problem.decode_text(text_buf);
}

void Reject::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Reject::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Reject::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("invokeIDRej': ");
  new_tlv->add_TLV(field_invokeIDRej.BER_encode_TLV(Reject_invokeIDRej_descr_, p_coding));
  ec_1.set_msg("problem': ");
  new_tlv->add_TLV(field_problem.BER_encode_TLV(Reject_problem_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Reject::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Reject' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("invokeIDRej': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_invokeIDRej.BER_decode_TLV(Reject_invokeIDRej_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("problem': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_problem.BER_decode_TLV(Reject_problem_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int Reject::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @TCAPMessages.Reject.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "invokeIDRej");
    enc_len += field_invokeIDRej.JSON_encode(Reject_invokeIDRej_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "problem");
    enc_len += field_problem.JSON_encode(Reject_problem_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int Reject::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const Reject*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean invokeIDRej_found = FALSE;
  boolean problem_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (11 == name_len && 0 == strncmp(fld_name, "invokeIDRej", name_len)) {
        invokeIDRej_found = TRUE;
         int ret_val = field_invokeIDRej.JSON_decode(Reject_invokeIDRej_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "invokeIDRej");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (7 == name_len && 0 == strncmp(fld_name, "problem", name_len)) {
        problem_found = TRUE;
         int ret_val = field_problem.JSON_decode(Reject_problem_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 7, "problem");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!invokeIDRej_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "invokeIDRej");
    return JSON_ERROR_FATAL;
  }
  if (!problem_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "problem");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int Reject::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  field_invokeIDRej.OER_encode(Reject_invokeIDRej_descr_, p_buf);
  field_problem.OER_encode(Reject_problem_descr_, p_buf);
  return 0;
}

int Reject::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  field_invokeIDRej.OER_decode(Reject_invokeIDRej_descr_, p_buf, p_oer);
  field_problem.OER_decode(Reject_problem_descr_, p_buf, p_oer);
  return 0;
}

void Reject::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
field_invokeIDRej.PER_encode(Reject_invokeIDRej_descr_, p_buf, p_options);
field_problem.PER_encode(Reject_problem_descr_, p_buf, p_options);
}

void Reject::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
field_invokeIDRej.PER_decode(Reject_invokeIDRej_descr_, p_buf, p_options);
field_problem.PER_decode(Reject_problem_descr_, p_buf, p_options);
}

struct Reject_template::single_value_struct {
Reject_invokeIDRej_template field_invokeIDRej;
Reject_problem_template field_problem;
};

void Reject_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_invokeIDRej = ANY_VALUE;
single_value->field_problem = ANY_VALUE;
}
}
}

void Reject_template::copy_value(const Reject& other_value)
{
single_value = new single_value_struct;
if (other_value.invokeIDRej().is_bound()) {
  single_value->field_invokeIDRej = other_value.invokeIDRej();
} else {
  single_value->field_invokeIDRej.clean_up();
}
if (other_value.problem().is_bound()) {
  single_value->field_problem = other_value.problem();
} else {
  single_value->field_problem.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Reject_template::copy_template(const Reject_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.invokeIDRej().get_selection()) {
single_value->field_invokeIDRej = other_value.invokeIDRej();
} else {
single_value->field_invokeIDRej.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.problem().get_selection()) {
single_value->field_problem = other_value.problem();
} else {
single_value->field_problem.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Reject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Reject_template(*other_value.implication_.precondition);
implication_.implied_template = new Reject_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @TCAPMessages.Reject.");
break;
}
set_selection(other_value);
}

Reject_template::Reject_template()
{
}

Reject_template::Reject_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Reject_template::Reject_template(const Reject& other_value)
{
copy_value(other_value);
}

Reject_template::Reject_template(const OPTIONAL<Reject>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @TCAPMessages.Reject from an unbound optional field.");
}
}

Reject_template::Reject_template(Reject_template* p_precondition, Reject_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Reject_template::Reject_template(Dynamic_Match_Interface<Reject>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Reject>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Reject_template::Reject_template(const Reject_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Reject_template::~Reject_template()
{
clean_up();
}

Reject_template& Reject_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Reject_template& Reject_template::operator=(const Reject& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Reject_template& Reject_template::operator=(const OPTIONAL<Reject>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @TCAPMessages.Reject.");
}
return *this;
}

Reject_template& Reject_template::operator=(const Reject_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Reject_template::match(const Reject& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.invokeIDRej().is_bound()) return FALSE;
if(!single_value->field_invokeIDRej.match(other_value.invokeIDRej(), legacy))return FALSE;
if(!other_value.problem().is_bound()) return FALSE;
if(!single_value->field_problem.match(other_value.problem(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @TCAPMessages.Reject.");
}
return FALSE;
}

boolean Reject_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_invokeIDRej.is_bound()
 || single_value->field_problem.is_bound();
}

boolean Reject_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_invokeIDRej.is_value()
 && single_value->field_problem.is_value();
}

void Reject_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Reject Reject_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @TCAPMessages.Reject.");
Reject ret_val;
if (single_value->field_invokeIDRej.is_bound()) {
ret_val.invokeIDRej() = single_value->field_invokeIDRej.valueof();
}
if (single_value->field_problem.is_bound()) {
ret_val.problem() = single_value->field_problem.valueof();
}
return ret_val;
}

void Reject_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @TCAPMessages.Reject.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Reject_template[list_length];
}

Reject_template& Reject_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @TCAPMessages.Reject.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @TCAPMessages.Reject.");
return value_list.list_value[list_index];
}

Reject_invokeIDRej_template& Reject_template::invokeIDRej()
{
set_specific();
return single_value->field_invokeIDRej;
}

const Reject_invokeIDRej_template& Reject_template::invokeIDRej() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field invokeIDRej of a non-specific template of type @TCAPMessages.Reject.");
return single_value->field_invokeIDRej;
}

Reject_problem_template& Reject_template::problem()
{
set_specific();
return single_value->field_problem;
}

const Reject_problem_template& Reject_template::problem() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field problem of a non-specific template of type @TCAPMessages.Reject.");
return single_value->field_problem;
}

int Reject_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @TCAPMessages.Reject containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Reject containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @TCAPMessages.Reject.");
  }
  return 0;
}

void Reject_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ invokeIDRej := ");
single_value->field_invokeIDRej.log();
TTCN_Logger::log_event_str(", problem := ");
single_value->field_problem.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Reject_template::log_match(const Reject& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_invokeIDRej.match(match_value.invokeIDRej(), legacy)){
TTCN_Logger::log_logmatch_info(".invokeIDRej");
single_value->field_invokeIDRej.log_match(match_value.invokeIDRej(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_problem.match(match_value.problem(), legacy)){
TTCN_Logger::log_logmatch_info(".problem");
single_value->field_problem.log_match(match_value.problem(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ invokeIDRej := ");
single_value->field_invokeIDRej.log_match(match_value.invokeIDRej(), legacy);
TTCN_Logger::log_event_str(", problem := ");
single_value->field_problem.log_match(match_value.problem(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Reject_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (invokeIDRej().is_bound()) invokeIDRej().set_implicit_omit();
if (problem().is_bound()) problem().set_implicit_omit();
}

void Reject_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_invokeIDRej.encode_text(text_buf);
single_value->field_problem.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @TCAPMessages.Reject.");
}
}

void Reject_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_invokeIDRej.decode_text(text_buf);
single_value->field_problem.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Reject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @TCAPMessages.Reject.");
}
}

void Reject_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Reject_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @TCAPMessages.Reject has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) invokeIDRej().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) problem().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "invokeIDRej")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          invokeIDRej().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "problem")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          problem().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Reject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Reject_template* precondition = new Reject_template;
    precondition->set_param(*param.get_elem(0));
    Reject_template* implied_template = new Reject_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Reject_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@TCAPMessages.Reject");
  }
  is_ifpresent = param.get_ifpresent();
}

void Reject_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_invokeIDRej.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject");
single_value->field_problem.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reject");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Reject");
}

boolean Reject_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Reject_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Unidirectional::Unidirectional()
{
}

Unidirectional::Unidirectional(const OPTIONAL< EXTERNAL >& par_dialoguePortion,
    const ComponentPortion& par_components)
  :   field_dialoguePortion(par_dialoguePortion),
  field_components(par_components)
{
}

Unidirectional::Unidirectional(const Unidirectional& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @TCAPMessages.Unidirectional.");
if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
else field_dialoguePortion.clean_up();
if (other_value.components().is_bound()) field_components = other_value.components();
else field_components.clean_up();
}

void Unidirectional::clean_up()
{
field_dialoguePortion.clean_up();
field_components.clean_up();
}

const TTCN_Typedescriptor_t* Unidirectional::get_descriptor() const { return &Unidirectional_descr_; }
Unidirectional& Unidirectional::operator=(const Unidirectional& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @TCAPMessages.Unidirectional.");
  if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
  else field_dialoguePortion.clean_up();
  if (other_value.components().is_bound()) field_components = other_value.components();
  else field_components.clean_up();
}
return *this;
}

boolean Unidirectional::operator==(const Unidirectional& other_value) const
{
return field_dialoguePortion==other_value.field_dialoguePortion
  && field_components==other_value.field_components;
}

boolean Unidirectional::is_bound() const
{
return (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_bound())
  || (field_components.is_bound());
}
boolean Unidirectional::is_value() const
{
return (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_value())
  && field_components.is_value();
}
int Unidirectional::size_of() const
{
  int ret_val = 1;
  if (field_dialoguePortion.ispresent()) ret_val++;
  return ret_val;
}

void Unidirectional::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ dialoguePortion := ");
field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
field_components.log();
TTCN_Logger::log_event_str(" }");
}

void Unidirectional::set_implicit_omit()
{
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (components().is_bound()) components().set_implicit_omit();
}

void Unidirectional::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @TCAPMessages.Unidirectional has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Unidirectional: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@TCAPMessages.Unidirectional");
  }
}

void Unidirectional::encode_text(Text_Buf& text_buf) const
{
field_dialoguePortion.encode_text(text_buf);
field_components.encode_text(text_buf);
}

void Unidirectional::decode_text(Text_Buf& text_buf)
{
field_dialoguePortion.decode_text(text_buf);
field_components.decode_text(text_buf);
}

void Unidirectional::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Unidirectional::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Unidirectional::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("dialoguePortion': ");
  new_tlv->add_TLV(field_dialoguePortion.BER_encode_TLV(DialoguePortion_descr_, p_coding));
  ec_1.set_msg("components': ");
  new_tlv->add_TLV(field_components.BER_encode_TLV(ComponentPortion_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Unidirectional::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Unidirectional' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("dialoguePortion': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_dialoguePortion=OMIT_VALUE;
    else {
      field_dialoguePortion.BER_decode_TLV(DialoguePortion_descr_, tmp_tlv, L_form);
      if(field_dialoguePortion.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("components': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_components.BER_decode_TLV(ComponentPortion_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int Unidirectional::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_dialoguePortion.is_present()) {
    c |= 128;
  }
  p_buf.put_c(c);
  if (field_dialoguePortion.is_present())
    field_dialoguePortion.OER_encode(DialoguePortion_descr_, p_buf);
  field_components.OER_encode(ComponentPortion_descr_, p_buf);
  return 0;
}

int Unidirectional::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  if (uc[0] & 128)
    field_dialoguePortion.OER_decode(DialoguePortion_descr_, p_buf, p_oer);
 else
    field_dialoguePortion = OMIT_VALUE;
  field_components.OER_decode(ComponentPortion_descr_, p_buf, p_oer);
  return 0;
}

void Unidirectional::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_dialoguePortion_present = field_dialoguePortion.is_present();
p_buf.PER_put_bit(field_dialoguePortion_present);
if (field_dialoguePortion_present) field_dialoguePortion.PER_encode(DialoguePortion_descr_, p_buf, p_options);
field_components.PER_encode(ComponentPortion_descr_, p_buf, p_options);
}

void Unidirectional::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_dialoguePortion_present = p_buf.PER_get_bit();
if (field_dialoguePortion_present) field_dialoguePortion.PER_decode(DialoguePortion_descr_, p_buf, p_options);
else field_dialoguePortion = OMIT_VALUE;
field_components.PER_decode(ComponentPortion_descr_, p_buf, p_options);
}

struct Unidirectional_template::single_value_struct {
EXTERNAL_template field_dialoguePortion;
ComponentPortion_template field_components;
};

void Unidirectional_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_dialoguePortion = ANY_OR_OMIT;
single_value->field_components = ANY_VALUE;
}
}
}

void Unidirectional_template::copy_value(const Unidirectional& other_value)
{
single_value = new single_value_struct;
if (other_value.dialoguePortion().is_bound()) {
  if (other_value.dialoguePortion().ispresent()) single_value->field_dialoguePortion = other_value.dialoguePortion()();
  else single_value->field_dialoguePortion = OMIT_VALUE;
} else {
  single_value->field_dialoguePortion.clean_up();
}
if (other_value.components().is_bound()) {
  single_value->field_components = other_value.components();
} else {
  single_value->field_components.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Unidirectional_template::copy_template(const Unidirectional_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.dialoguePortion().get_selection()) {
single_value->field_dialoguePortion = other_value.dialoguePortion();
} else {
single_value->field_dialoguePortion.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.components().get_selection()) {
single_value->field_components = other_value.components();
} else {
single_value->field_components.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Unidirectional_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Unidirectional_template(*other_value.implication_.precondition);
implication_.implied_template = new Unidirectional_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @TCAPMessages.Unidirectional.");
break;
}
set_selection(other_value);
}

Unidirectional_template::Unidirectional_template()
{
}

Unidirectional_template::Unidirectional_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Unidirectional_template::Unidirectional_template(const Unidirectional& other_value)
{
copy_value(other_value);
}

Unidirectional_template::Unidirectional_template(const OPTIONAL<Unidirectional>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Unidirectional&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @TCAPMessages.Unidirectional from an unbound optional field.");
}
}

Unidirectional_template::Unidirectional_template(Unidirectional_template* p_precondition, Unidirectional_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Unidirectional_template::Unidirectional_template(Dynamic_Match_Interface<Unidirectional>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Unidirectional>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Unidirectional_template::Unidirectional_template(const Unidirectional_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Unidirectional_template::~Unidirectional_template()
{
clean_up();
}

Unidirectional_template& Unidirectional_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Unidirectional_template& Unidirectional_template::operator=(const Unidirectional& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Unidirectional_template& Unidirectional_template::operator=(const OPTIONAL<Unidirectional>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Unidirectional&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @TCAPMessages.Unidirectional.");
}
return *this;
}

Unidirectional_template& Unidirectional_template::operator=(const Unidirectional_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Unidirectional_template::match(const Unidirectional& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.dialoguePortion().is_bound()) return FALSE;
if((other_value.dialoguePortion().ispresent() ? !single_value->field_dialoguePortion.match((const EXTERNAL&)other_value.dialoguePortion(), legacy) : !single_value->field_dialoguePortion.match_omit(legacy)))return FALSE;
if(!other_value.components().is_bound()) return FALSE;
if(!single_value->field_components.match(other_value.components(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @TCAPMessages.Unidirectional.");
}
return FALSE;
}

boolean Unidirectional_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_bound())
 || single_value->field_components.is_bound();
}

boolean Unidirectional_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_value())
 && single_value->field_components.is_value();
}

void Unidirectional_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Unidirectional Unidirectional_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @TCAPMessages.Unidirectional.");
Unidirectional ret_val;
if (single_value->field_dialoguePortion.is_omit()) ret_val.dialoguePortion() = OMIT_VALUE;
else if (single_value->field_dialoguePortion.is_bound()) {
ret_val.dialoguePortion() = single_value->field_dialoguePortion.valueof();
}
if (single_value->field_components.is_bound()) {
ret_val.components() = single_value->field_components.valueof();
}
return ret_val;
}

void Unidirectional_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @TCAPMessages.Unidirectional.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Unidirectional_template[list_length];
}

Unidirectional_template& Unidirectional_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @TCAPMessages.Unidirectional.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @TCAPMessages.Unidirectional.");
return value_list.list_value[list_index];
}

EXTERNAL_template& Unidirectional_template::dialoguePortion()
{
set_specific();
return single_value->field_dialoguePortion;
}

const EXTERNAL_template& Unidirectional_template::dialoguePortion() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dialoguePortion of a non-specific template of type @TCAPMessages.Unidirectional.");
return single_value->field_dialoguePortion;
}

ComponentPortion_template& Unidirectional_template::components()
{
set_specific();
return single_value->field_components;
}

const ComponentPortion_template& Unidirectional_template::components() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field components of a non-specific template of type @TCAPMessages.Unidirectional.");
return single_value->field_components;
}

int Unidirectional_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_dialoguePortion.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Unidirectional containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @TCAPMessages.Unidirectional.");
  }
  return 0;
}

void Unidirectional_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ dialoguePortion := ");
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
single_value->field_components.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Unidirectional_template::log_match(const Unidirectional& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.dialoguePortion().ispresent()){
if(!single_value->field_dialoguePortion.match(match_value.dialoguePortion(), legacy)){
TTCN_Logger::log_logmatch_info(".dialoguePortion");
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dialoguePortion.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dialoguePortion := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_components.match(match_value.components(), legacy)){
TTCN_Logger::log_logmatch_info(".components");
single_value->field_components.log_match(match_value.components(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ dialoguePortion := ");
if (match_value.dialoguePortion().ispresent()) {
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dialoguePortion.log();
if (single_value->field_dialoguePortion.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", components := ");
single_value->field_components.log_match(match_value.components(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Unidirectional_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (components().is_bound()) components().set_implicit_omit();
}

void Unidirectional_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_dialoguePortion.encode_text(text_buf);
single_value->field_components.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @TCAPMessages.Unidirectional.");
}
}

void Unidirectional_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_dialoguePortion.decode_text(text_buf);
single_value->field_components.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Unidirectional_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @TCAPMessages.Unidirectional.");
}
}

void Unidirectional_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Unidirectional_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @TCAPMessages.Unidirectional has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Unidirectional: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Unidirectional_template* precondition = new Unidirectional_template;
    precondition->set_param(*param.get_elem(0));
    Unidirectional_template* implied_template = new Unidirectional_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Unidirectional_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@TCAPMessages.Unidirectional");
  }
  is_ifpresent = param.get_ifpresent();
}

void Unidirectional_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_dialoguePortion.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Unidirectional");
single_value->field_components.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Unidirectional");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Unidirectional");
}

boolean Unidirectional_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Unidirectional_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Begin::Begin()
{
}

Begin::Begin(const OCTETSTRING& par_otid,
    const OPTIONAL< EXTERNAL >& par_dialoguePortion,
    const OPTIONAL< ComponentPortion >& par_components)
  :   field_otid(par_otid),
  field_dialoguePortion(par_dialoguePortion),
  field_components(par_components)
{
}

Begin::Begin(const Begin& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @TCAPMessages.Begin.");
if (other_value.otid().is_bound()) field_otid = other_value.otid();
else field_otid.clean_up();
if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
else field_dialoguePortion.clean_up();
if (other_value.components().is_bound()) field_components = other_value.components();
else field_components.clean_up();
}

void Begin::clean_up()
{
field_otid.clean_up();
field_dialoguePortion.clean_up();
field_components.clean_up();
}

const TTCN_Typedescriptor_t* Begin::get_descriptor() const { return &Begin_descr_; }
Begin& Begin::operator=(const Begin& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @TCAPMessages.Begin.");
  if (other_value.otid().is_bound()) field_otid = other_value.otid();
  else field_otid.clean_up();
  if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
  else field_dialoguePortion.clean_up();
  if (other_value.components().is_bound()) field_components = other_value.components();
  else field_components.clean_up();
}
return *this;
}

boolean Begin::operator==(const Begin& other_value) const
{
return field_otid==other_value.field_otid
  && field_dialoguePortion==other_value.field_dialoguePortion
  && field_components==other_value.field_components;
}

boolean Begin::is_bound() const
{
return (field_otid.is_bound())
  || (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_bound())
  || (OPTIONAL_OMIT == field_components.get_selection() || field_components.is_bound());
}
boolean Begin::is_value() const
{
return field_otid.is_value()
  && (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_value())
  && (OPTIONAL_OMIT == field_components.get_selection() || field_components.is_value());
}
int Begin::size_of() const
{
  int ret_val = 1;
  if (field_dialoguePortion.ispresent()) ret_val++;
  if (field_components.ispresent()) ret_val++;
  return ret_val;
}

void Begin::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ otid := ");
field_otid.log();
TTCN_Logger::log_event_str(", dialoguePortion := ");
field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
field_components.log();
TTCN_Logger::log_event_str(" }");
}

void Begin::set_implicit_omit()
{
if (otid().is_bound()) otid().set_implicit_omit();
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (!components().is_bound()) components() = OMIT_VALUE;
else components().set_implicit_omit();
}

void Begin::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @TCAPMessages.Begin has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) otid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "otid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          otid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Begin: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@TCAPMessages.Begin");
  }
}

void Begin::encode_text(Text_Buf& text_buf) const
{
field_otid.encode_text(text_buf);
field_dialoguePortion.encode_text(text_buf);
field_components.encode_text(text_buf);
}

void Begin::decode_text(Text_Buf& text_buf)
{
field_otid.decode_text(text_buf);
field_dialoguePortion.decode_text(text_buf);
field_components.decode_text(text_buf);
}

void Begin::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Begin::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Begin::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("otid': ");
  new_tlv->add_TLV(field_otid.BER_encode_TLV(OrigTransactionID_descr_, p_coding));
  ec_1.set_msg("dialoguePortion': ");
  new_tlv->add_TLV(field_dialoguePortion.BER_encode_TLV(DialoguePortion_descr_, p_coding));
  ec_1.set_msg("components': ");
  new_tlv->add_TLV(field_components.BER_encode_TLV(ComponentPortion_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Begin::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Begin' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("otid': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_otid.BER_decode_TLV(OrigTransactionID_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("dialoguePortion': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_dialoguePortion=OMIT_VALUE;
    else {
      field_dialoguePortion.BER_decode_TLV(DialoguePortion_descr_, tmp_tlv, L_form);
      if(field_dialoguePortion.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("components': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_components=OMIT_VALUE;
    else {
      field_components.BER_decode_TLV(ComponentPortion_descr_, tmp_tlv, L_form);
      if(field_components.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int Begin::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_dialoguePortion.is_present()) {
    c |= 128;
  }
  if (field_components.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_otid.OER_encode(OrigTransactionID_descr_, p_buf);
  if (field_dialoguePortion.is_present())
    field_dialoguePortion.OER_encode(DialoguePortion_descr_, p_buf);
  if (field_components.is_present())
    field_components.OER_encode(ComponentPortion_descr_, p_buf);
  return 0;
}

int Begin::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  field_otid.OER_decode(OrigTransactionID_descr_, p_buf, p_oer);
  if (uc[0] & 128)
    field_dialoguePortion.OER_decode(DialoguePortion_descr_, p_buf, p_oer);
 else
    field_dialoguePortion = OMIT_VALUE;
  if (uc[0] & 64)
    field_components.OER_decode(ComponentPortion_descr_, p_buf, p_oer);
 else
    field_components = OMIT_VALUE;
  return 0;
}

void Begin::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_dialoguePortion_present = field_dialoguePortion.is_present();
p_buf.PER_put_bit(field_dialoguePortion_present);
boolean field_components_present = field_components.is_present();
p_buf.PER_put_bit(field_components_present);
field_otid.PER_encode(OrigTransactionID_descr_, p_buf, p_options);
if (field_dialoguePortion_present) field_dialoguePortion.PER_encode(DialoguePortion_descr_, p_buf, p_options);
if (field_components_present) field_components.PER_encode(ComponentPortion_descr_, p_buf, p_options);
}

void Begin::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_dialoguePortion_present = p_buf.PER_get_bit();
boolean field_components_present = p_buf.PER_get_bit();
field_otid.PER_decode(OrigTransactionID_descr_, p_buf, p_options);
if (field_dialoguePortion_present) field_dialoguePortion.PER_decode(DialoguePortion_descr_, p_buf, p_options);
else field_dialoguePortion = OMIT_VALUE;
if (field_components_present) field_components.PER_decode(ComponentPortion_descr_, p_buf, p_options);
else field_components = OMIT_VALUE;
}

struct Begin_template::single_value_struct {
OCTETSTRING_template field_otid;
EXTERNAL_template field_dialoguePortion;
ComponentPortion_template field_components;
};

void Begin_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_otid = ANY_VALUE;
single_value->field_dialoguePortion = ANY_OR_OMIT;
single_value->field_components = ANY_OR_OMIT;
}
}
}

void Begin_template::copy_value(const Begin& other_value)
{
single_value = new single_value_struct;
if (other_value.otid().is_bound()) {
  single_value->field_otid = other_value.otid();
} else {
  single_value->field_otid.clean_up();
}
if (other_value.dialoguePortion().is_bound()) {
  if (other_value.dialoguePortion().ispresent()) single_value->field_dialoguePortion = other_value.dialoguePortion()();
  else single_value->field_dialoguePortion = OMIT_VALUE;
} else {
  single_value->field_dialoguePortion.clean_up();
}
if (other_value.components().is_bound()) {
  if (other_value.components().ispresent()) single_value->field_components = other_value.components()();
  else single_value->field_components = OMIT_VALUE;
} else {
  single_value->field_components.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Begin_template::copy_template(const Begin_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.otid().get_selection()) {
single_value->field_otid = other_value.otid();
} else {
single_value->field_otid.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dialoguePortion().get_selection()) {
single_value->field_dialoguePortion = other_value.dialoguePortion();
} else {
single_value->field_dialoguePortion.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.components().get_selection()) {
single_value->field_components = other_value.components();
} else {
single_value->field_components.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Begin_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Begin_template(*other_value.implication_.precondition);
implication_.implied_template = new Begin_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @TCAPMessages.Begin.");
break;
}
set_selection(other_value);
}

Begin_template::Begin_template()
{
}

Begin_template::Begin_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Begin_template::Begin_template(const Begin& other_value)
{
copy_value(other_value);
}

Begin_template::Begin_template(const OPTIONAL<Begin>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Begin&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @TCAPMessages.Begin from an unbound optional field.");
}
}

Begin_template::Begin_template(Begin_template* p_precondition, Begin_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Begin_template::Begin_template(Dynamic_Match_Interface<Begin>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Begin>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Begin_template::Begin_template(const Begin_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Begin_template::~Begin_template()
{
clean_up();
}

Begin_template& Begin_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Begin_template& Begin_template::operator=(const Begin& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Begin_template& Begin_template::operator=(const OPTIONAL<Begin>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Begin&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @TCAPMessages.Begin.");
}
return *this;
}

Begin_template& Begin_template::operator=(const Begin_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Begin_template::match(const Begin& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.otid().is_bound()) return FALSE;
if(!single_value->field_otid.match(other_value.otid(), legacy))return FALSE;
if(!other_value.dialoguePortion().is_bound()) return FALSE;
if((other_value.dialoguePortion().ispresent() ? !single_value->field_dialoguePortion.match((const EXTERNAL&)other_value.dialoguePortion(), legacy) : !single_value->field_dialoguePortion.match_omit(legacy)))return FALSE;
if(!other_value.components().is_bound()) return FALSE;
if((other_value.components().ispresent() ? !single_value->field_components.match((const ComponentPortion&)other_value.components(), legacy) : !single_value->field_components.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @TCAPMessages.Begin.");
}
return FALSE;
}

boolean Begin_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_otid.is_bound()
 || (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_bound())
 || (single_value->field_components.is_omit() || single_value->field_components.is_bound());
}

boolean Begin_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_otid.is_value()
 && (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_value())
 && (single_value->field_components.is_omit() || single_value->field_components.is_value());
}

void Begin_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Begin Begin_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @TCAPMessages.Begin.");
Begin ret_val;
if (single_value->field_otid.is_bound()) {
ret_val.otid() = single_value->field_otid.valueof();
}
if (single_value->field_dialoguePortion.is_omit()) ret_val.dialoguePortion() = OMIT_VALUE;
else if (single_value->field_dialoguePortion.is_bound()) {
ret_val.dialoguePortion() = single_value->field_dialoguePortion.valueof();
}
if (single_value->field_components.is_omit()) ret_val.components() = OMIT_VALUE;
else if (single_value->field_components.is_bound()) {
ret_val.components() = single_value->field_components.valueof();
}
return ret_val;
}

void Begin_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @TCAPMessages.Begin.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Begin_template[list_length];
}

Begin_template& Begin_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @TCAPMessages.Begin.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @TCAPMessages.Begin.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Begin_template::otid()
{
set_specific();
return single_value->field_otid;
}

const OCTETSTRING_template& Begin_template::otid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field otid of a non-specific template of type @TCAPMessages.Begin.");
return single_value->field_otid;
}

EXTERNAL_template& Begin_template::dialoguePortion()
{
set_specific();
return single_value->field_dialoguePortion;
}

const EXTERNAL_template& Begin_template::dialoguePortion() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dialoguePortion of a non-specific template of type @TCAPMessages.Begin.");
return single_value->field_dialoguePortion;
}

ComponentPortion_template& Begin_template::components()
{
set_specific();
return single_value->field_components;
}

const ComponentPortion_template& Begin_template::components() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field components of a non-specific template of type @TCAPMessages.Begin.");
return single_value->field_components;
}

int Begin_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_dialoguePortion.is_present()) ret_val++;
      if (single_value->field_components.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @TCAPMessages.Begin containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Begin containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @TCAPMessages.Begin.");
  }
  return 0;
}

void Begin_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ otid := ");
single_value->field_otid.log();
TTCN_Logger::log_event_str(", dialoguePortion := ");
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
single_value->field_components.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Begin_template::log_match(const Begin& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_otid.match(match_value.otid(), legacy)){
TTCN_Logger::log_logmatch_info(".otid");
single_value->field_otid.log_match(match_value.otid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.dialoguePortion().ispresent()){
if(!single_value->field_dialoguePortion.match(match_value.dialoguePortion(), legacy)){
TTCN_Logger::log_logmatch_info(".dialoguePortion");
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dialoguePortion.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dialoguePortion := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.components().ispresent()){
if(!single_value->field_components.match(match_value.components(), legacy)){
TTCN_Logger::log_logmatch_info(".components");
single_value->field_components.log_match(match_value.components(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_components.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".components := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_components.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ otid := ");
single_value->field_otid.log_match(match_value.otid(), legacy);
TTCN_Logger::log_event_str(", dialoguePortion := ");
if (match_value.dialoguePortion().ispresent()) {
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dialoguePortion.log();
if (single_value->field_dialoguePortion.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", components := ");
if (match_value.components().ispresent()) {
single_value->field_components.log_match(match_value.components(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_components.log();
if (single_value->field_components.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Begin_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (otid().is_bound()) otid().set_implicit_omit();
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (!components().is_bound()) components() = OMIT_VALUE;
else components().set_implicit_omit();
}

void Begin_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_otid.encode_text(text_buf);
single_value->field_dialoguePortion.encode_text(text_buf);
single_value->field_components.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @TCAPMessages.Begin.");
}
}

void Begin_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_otid.decode_text(text_buf);
single_value->field_dialoguePortion.decode_text(text_buf);
single_value->field_components.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Begin_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @TCAPMessages.Begin.");
}
}

void Begin_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Begin_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @TCAPMessages.Begin has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) otid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "otid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          otid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Begin: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Begin_template* precondition = new Begin_template;
    precondition->set_param(*param.get_elem(0));
    Begin_template* implied_template = new Begin_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Begin_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@TCAPMessages.Begin");
  }
  is_ifpresent = param.get_ifpresent();
}

void Begin_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_otid.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Begin");
single_value->field_dialoguePortion.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Begin");
single_value->field_components.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Begin");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Begin");
}

boolean Begin_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Begin_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

End::End()
{
}

End::End(const OCTETSTRING& par_dtid,
    const OPTIONAL< EXTERNAL >& par_dialoguePortion,
    const OPTIONAL< ComponentPortion >& par_components)
  :   field_dtid(par_dtid),
  field_dialoguePortion(par_dialoguePortion),
  field_components(par_components)
{
}

End::End(const End& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @TCAPMessages.End.");
if (other_value.dtid().is_bound()) field_dtid = other_value.dtid();
else field_dtid.clean_up();
if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
else field_dialoguePortion.clean_up();
if (other_value.components().is_bound()) field_components = other_value.components();
else field_components.clean_up();
}

void End::clean_up()
{
field_dtid.clean_up();
field_dialoguePortion.clean_up();
field_components.clean_up();
}

const TTCN_Typedescriptor_t* End::get_descriptor() const { return &End_descr_; }
End& End::operator=(const End& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @TCAPMessages.End.");
  if (other_value.dtid().is_bound()) field_dtid = other_value.dtid();
  else field_dtid.clean_up();
  if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
  else field_dialoguePortion.clean_up();
  if (other_value.components().is_bound()) field_components = other_value.components();
  else field_components.clean_up();
}
return *this;
}

boolean End::operator==(const End& other_value) const
{
return field_dtid==other_value.field_dtid
  && field_dialoguePortion==other_value.field_dialoguePortion
  && field_components==other_value.field_components;
}

boolean End::is_bound() const
{
return (field_dtid.is_bound())
  || (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_bound())
  || (OPTIONAL_OMIT == field_components.get_selection() || field_components.is_bound());
}
boolean End::is_value() const
{
return field_dtid.is_value()
  && (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_value())
  && (OPTIONAL_OMIT == field_components.get_selection() || field_components.is_value());
}
int End::size_of() const
{
  int ret_val = 1;
  if (field_dialoguePortion.ispresent()) ret_val++;
  if (field_components.ispresent()) ret_val++;
  return ret_val;
}

void End::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ dtid := ");
field_dtid.log();
TTCN_Logger::log_event_str(", dialoguePortion := ");
field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
field_components.log();
TTCN_Logger::log_event_str(" }");
}

void End::set_implicit_omit()
{
if (dtid().is_bound()) dtid().set_implicit_omit();
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (!components().is_bound()) components() = OMIT_VALUE;
else components().set_implicit_omit();
}

void End::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @TCAPMessages.End has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dtid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dtid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dtid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.End: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@TCAPMessages.End");
  }
}

void End::encode_text(Text_Buf& text_buf) const
{
field_dtid.encode_text(text_buf);
field_dialoguePortion.encode_text(text_buf);
field_components.encode_text(text_buf);
}

void End::decode_text(Text_Buf& text_buf)
{
field_dtid.decode_text(text_buf);
field_dialoguePortion.decode_text(text_buf);
field_components.decode_text(text_buf);
}

void End::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void End::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* End::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("dtid': ");
  new_tlv->add_TLV(field_dtid.BER_encode_TLV(DestTransactionID_descr_, p_coding));
  ec_1.set_msg("dialoguePortion': ");
  new_tlv->add_TLV(field_dialoguePortion.BER_encode_TLV(DialoguePortion_descr_, p_coding));
  ec_1.set_msg("components': ");
  new_tlv->add_TLV(field_components.BER_encode_TLV(ComponentPortion_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean End::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.End' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("dtid': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_dtid.BER_decode_TLV(DestTransactionID_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("dialoguePortion': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_dialoguePortion=OMIT_VALUE;
    else {
      field_dialoguePortion.BER_decode_TLV(DialoguePortion_descr_, tmp_tlv, L_form);
      if(field_dialoguePortion.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("components': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_components=OMIT_VALUE;
    else {
      field_components.BER_decode_TLV(ComponentPortion_descr_, tmp_tlv, L_form);
      if(field_components.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int End::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_dialoguePortion.is_present()) {
    c |= 128;
  }
  if (field_components.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_dtid.OER_encode(DestTransactionID_descr_, p_buf);
  if (field_dialoguePortion.is_present())
    field_dialoguePortion.OER_encode(DialoguePortion_descr_, p_buf);
  if (field_components.is_present())
    field_components.OER_encode(ComponentPortion_descr_, p_buf);
  return 0;
}

int End::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  field_dtid.OER_decode(DestTransactionID_descr_, p_buf, p_oer);
  if (uc[0] & 128)
    field_dialoguePortion.OER_decode(DialoguePortion_descr_, p_buf, p_oer);
 else
    field_dialoguePortion = OMIT_VALUE;
  if (uc[0] & 64)
    field_components.OER_decode(ComponentPortion_descr_, p_buf, p_oer);
 else
    field_components = OMIT_VALUE;
  return 0;
}

void End::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_dialoguePortion_present = field_dialoguePortion.is_present();
p_buf.PER_put_bit(field_dialoguePortion_present);
boolean field_components_present = field_components.is_present();
p_buf.PER_put_bit(field_components_present);
field_dtid.PER_encode(DestTransactionID_descr_, p_buf, p_options);
if (field_dialoguePortion_present) field_dialoguePortion.PER_encode(DialoguePortion_descr_, p_buf, p_options);
if (field_components_present) field_components.PER_encode(ComponentPortion_descr_, p_buf, p_options);
}

void End::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_dialoguePortion_present = p_buf.PER_get_bit();
boolean field_components_present = p_buf.PER_get_bit();
field_dtid.PER_decode(DestTransactionID_descr_, p_buf, p_options);
if (field_dialoguePortion_present) field_dialoguePortion.PER_decode(DialoguePortion_descr_, p_buf, p_options);
else field_dialoguePortion = OMIT_VALUE;
if (field_components_present) field_components.PER_decode(ComponentPortion_descr_, p_buf, p_options);
else field_components = OMIT_VALUE;
}

struct End_template::single_value_struct {
OCTETSTRING_template field_dtid;
EXTERNAL_template field_dialoguePortion;
ComponentPortion_template field_components;
};

void End_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_dtid = ANY_VALUE;
single_value->field_dialoguePortion = ANY_OR_OMIT;
single_value->field_components = ANY_OR_OMIT;
}
}
}

void End_template::copy_value(const End& other_value)
{
single_value = new single_value_struct;
if (other_value.dtid().is_bound()) {
  single_value->field_dtid = other_value.dtid();
} else {
  single_value->field_dtid.clean_up();
}
if (other_value.dialoguePortion().is_bound()) {
  if (other_value.dialoguePortion().ispresent()) single_value->field_dialoguePortion = other_value.dialoguePortion()();
  else single_value->field_dialoguePortion = OMIT_VALUE;
} else {
  single_value->field_dialoguePortion.clean_up();
}
if (other_value.components().is_bound()) {
  if (other_value.components().ispresent()) single_value->field_components = other_value.components()();
  else single_value->field_components = OMIT_VALUE;
} else {
  single_value->field_components.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void End_template::copy_template(const End_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.dtid().get_selection()) {
single_value->field_dtid = other_value.dtid();
} else {
single_value->field_dtid.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dialoguePortion().get_selection()) {
single_value->field_dialoguePortion = other_value.dialoguePortion();
} else {
single_value->field_dialoguePortion.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.components().get_selection()) {
single_value->field_components = other_value.components();
} else {
single_value->field_components.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new End_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new End_template(*other_value.implication_.precondition);
implication_.implied_template = new End_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @TCAPMessages.End.");
break;
}
set_selection(other_value);
}

End_template::End_template()
{
}

End_template::End_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

End_template::End_template(const End& other_value)
{
copy_value(other_value);
}

End_template::End_template(const OPTIONAL<End>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const End&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @TCAPMessages.End from an unbound optional field.");
}
}

End_template::End_template(End_template* p_precondition, End_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

End_template::End_template(Dynamic_Match_Interface<End>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<End>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

End_template::End_template(const End_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

End_template::~End_template()
{
clean_up();
}

End_template& End_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

End_template& End_template::operator=(const End& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

End_template& End_template::operator=(const OPTIONAL<End>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const End&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @TCAPMessages.End.");
}
return *this;
}

End_template& End_template::operator=(const End_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean End_template::match(const End& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.dtid().is_bound()) return FALSE;
if(!single_value->field_dtid.match(other_value.dtid(), legacy))return FALSE;
if(!other_value.dialoguePortion().is_bound()) return FALSE;
if((other_value.dialoguePortion().ispresent() ? !single_value->field_dialoguePortion.match((const EXTERNAL&)other_value.dialoguePortion(), legacy) : !single_value->field_dialoguePortion.match_omit(legacy)))return FALSE;
if(!other_value.components().is_bound()) return FALSE;
if((other_value.components().ispresent() ? !single_value->field_components.match((const ComponentPortion&)other_value.components(), legacy) : !single_value->field_components.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @TCAPMessages.End.");
}
return FALSE;
}

boolean End_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_dtid.is_bound()
 || (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_bound())
 || (single_value->field_components.is_omit() || single_value->field_components.is_bound());
}

boolean End_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_dtid.is_value()
 && (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_value())
 && (single_value->field_components.is_omit() || single_value->field_components.is_value());
}

void End_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

End End_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @TCAPMessages.End.");
End ret_val;
if (single_value->field_dtid.is_bound()) {
ret_val.dtid() = single_value->field_dtid.valueof();
}
if (single_value->field_dialoguePortion.is_omit()) ret_val.dialoguePortion() = OMIT_VALUE;
else if (single_value->field_dialoguePortion.is_bound()) {
ret_val.dialoguePortion() = single_value->field_dialoguePortion.valueof();
}
if (single_value->field_components.is_omit()) ret_val.components() = OMIT_VALUE;
else if (single_value->field_components.is_bound()) {
ret_val.components() = single_value->field_components.valueof();
}
return ret_val;
}

void End_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @TCAPMessages.End.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new End_template[list_length];
}

End_template& End_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @TCAPMessages.End.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @TCAPMessages.End.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& End_template::dtid()
{
set_specific();
return single_value->field_dtid;
}

const OCTETSTRING_template& End_template::dtid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dtid of a non-specific template of type @TCAPMessages.End.");
return single_value->field_dtid;
}

EXTERNAL_template& End_template::dialoguePortion()
{
set_specific();
return single_value->field_dialoguePortion;
}

const EXTERNAL_template& End_template::dialoguePortion() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dialoguePortion of a non-specific template of type @TCAPMessages.End.");
return single_value->field_dialoguePortion;
}

ComponentPortion_template& End_template::components()
{
set_specific();
return single_value->field_components;
}

const ComponentPortion_template& End_template::components() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field components of a non-specific template of type @TCAPMessages.End.");
return single_value->field_components;
}

int End_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_dialoguePortion.is_present()) ret_val++;
      if (single_value->field_components.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @TCAPMessages.End containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.End containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @TCAPMessages.End.");
  }
  return 0;
}

void End_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ dtid := ");
single_value->field_dtid.log();
TTCN_Logger::log_event_str(", dialoguePortion := ");
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
single_value->field_components.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void End_template::log_match(const End& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_dtid.match(match_value.dtid(), legacy)){
TTCN_Logger::log_logmatch_info(".dtid");
single_value->field_dtid.log_match(match_value.dtid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.dialoguePortion().ispresent()){
if(!single_value->field_dialoguePortion.match(match_value.dialoguePortion(), legacy)){
TTCN_Logger::log_logmatch_info(".dialoguePortion");
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dialoguePortion.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dialoguePortion := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.components().ispresent()){
if(!single_value->field_components.match(match_value.components(), legacy)){
TTCN_Logger::log_logmatch_info(".components");
single_value->field_components.log_match(match_value.components(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_components.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".components := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_components.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ dtid := ");
single_value->field_dtid.log_match(match_value.dtid(), legacy);
TTCN_Logger::log_event_str(", dialoguePortion := ");
if (match_value.dialoguePortion().ispresent()) {
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dialoguePortion.log();
if (single_value->field_dialoguePortion.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", components := ");
if (match_value.components().ispresent()) {
single_value->field_components.log_match(match_value.components(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_components.log();
if (single_value->field_components.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void End_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (dtid().is_bound()) dtid().set_implicit_omit();
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (!components().is_bound()) components() = OMIT_VALUE;
else components().set_implicit_omit();
}

void End_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_dtid.encode_text(text_buf);
single_value->field_dialoguePortion.encode_text(text_buf);
single_value->field_components.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @TCAPMessages.End.");
}
}

void End_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_dtid.decode_text(text_buf);
single_value->field_dialoguePortion.decode_text(text_buf);
single_value->field_components.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new End_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @TCAPMessages.End.");
}
}

void End_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    End_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @TCAPMessages.End has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dtid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dtid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dtid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.End: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    End_template* precondition = new End_template;
    precondition->set_param(*param.get_elem(0));
    End_template* implied_template = new End_template;
    implied_template->set_param(*param.get_elem(1));
    *this = End_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@TCAPMessages.End");
  }
  is_ifpresent = param.get_ifpresent();
}

void End_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_dtid.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.End");
single_value->field_dialoguePortion.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.End");
single_value->field_components.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.End");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.End");
}

boolean End_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean End_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Continue::Continue()
{
}

Continue::Continue(const OCTETSTRING& par_otid,
    const OCTETSTRING& par_dtid,
    const OPTIONAL< EXTERNAL >& par_dialoguePortion,
    const OPTIONAL< ComponentPortion >& par_components)
  :   field_otid(par_otid),
  field_dtid(par_dtid),
  field_dialoguePortion(par_dialoguePortion),
  field_components(par_components)
{
}

Continue::Continue(const Continue& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @TCAPMessages.Continue.");
if (other_value.otid().is_bound()) field_otid = other_value.otid();
else field_otid.clean_up();
if (other_value.dtid().is_bound()) field_dtid = other_value.dtid();
else field_dtid.clean_up();
if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
else field_dialoguePortion.clean_up();
if (other_value.components().is_bound()) field_components = other_value.components();
else field_components.clean_up();
}

void Continue::clean_up()
{
field_otid.clean_up();
field_dtid.clean_up();
field_dialoguePortion.clean_up();
field_components.clean_up();
}

const TTCN_Typedescriptor_t* Continue::get_descriptor() const { return &Continue_descr_; }
Continue& Continue::operator=(const Continue& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @TCAPMessages.Continue.");
  if (other_value.otid().is_bound()) field_otid = other_value.otid();
  else field_otid.clean_up();
  if (other_value.dtid().is_bound()) field_dtid = other_value.dtid();
  else field_dtid.clean_up();
  if (other_value.dialoguePortion().is_bound()) field_dialoguePortion = other_value.dialoguePortion();
  else field_dialoguePortion.clean_up();
  if (other_value.components().is_bound()) field_components = other_value.components();
  else field_components.clean_up();
}
return *this;
}

boolean Continue::operator==(const Continue& other_value) const
{
return field_otid==other_value.field_otid
  && field_dtid==other_value.field_dtid
  && field_dialoguePortion==other_value.field_dialoguePortion
  && field_components==other_value.field_components;
}

boolean Continue::is_bound() const
{
return (field_otid.is_bound())
  || (field_dtid.is_bound())
  || (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_bound())
  || (OPTIONAL_OMIT == field_components.get_selection() || field_components.is_bound());
}
boolean Continue::is_value() const
{
return field_otid.is_value()
  && field_dtid.is_value()
  && (OPTIONAL_OMIT == field_dialoguePortion.get_selection() || field_dialoguePortion.is_value())
  && (OPTIONAL_OMIT == field_components.get_selection() || field_components.is_value());
}
int Continue::size_of() const
{
  int ret_val = 2;
  if (field_dialoguePortion.ispresent()) ret_val++;
  if (field_components.ispresent()) ret_val++;
  return ret_val;
}

void Continue::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ otid := ");
field_otid.log();
TTCN_Logger::log_event_str(", dtid := ");
field_dtid.log();
TTCN_Logger::log_event_str(", dialoguePortion := ");
field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
field_components.log();
TTCN_Logger::log_event_str(" }");
}

void Continue::set_implicit_omit()
{
if (otid().is_bound()) otid().set_implicit_omit();
if (dtid().is_bound()) dtid().set_implicit_omit();
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (!components().is_bound()) components() = OMIT_VALUE;
else components().set_implicit_omit();
}

void Continue::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @TCAPMessages.Continue has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) otid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dtid().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "otid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          otid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dtid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dtid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Continue: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@TCAPMessages.Continue");
  }
}

void Continue::encode_text(Text_Buf& text_buf) const
{
field_otid.encode_text(text_buf);
field_dtid.encode_text(text_buf);
field_dialoguePortion.encode_text(text_buf);
field_components.encode_text(text_buf);
}

void Continue::decode_text(Text_Buf& text_buf)
{
field_otid.decode_text(text_buf);
field_dtid.decode_text(text_buf);
field_dialoguePortion.decode_text(text_buf);
field_components.decode_text(text_buf);
}

void Continue::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Continue::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Continue::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("otid': ");
  new_tlv->add_TLV(field_otid.BER_encode_TLV(OrigTransactionID_descr_, p_coding));
  ec_1.set_msg("dtid': ");
  new_tlv->add_TLV(field_dtid.BER_encode_TLV(DestTransactionID_descr_, p_coding));
  ec_1.set_msg("dialoguePortion': ");
  new_tlv->add_TLV(field_dialoguePortion.BER_encode_TLV(DialoguePortion_descr_, p_coding));
  ec_1.set_msg("components': ");
  new_tlv->add_TLV(field_components.BER_encode_TLV(ComponentPortion_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Continue::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Continue' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("otid': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_otid.BER_decode_TLV(OrigTransactionID_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("dtid': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_dtid.BER_decode_TLV(DestTransactionID_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("dialoguePortion': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_dialoguePortion=OMIT_VALUE;
    else {
      field_dialoguePortion.BER_decode_TLV(DialoguePortion_descr_, tmp_tlv, L_form);
      if(field_dialoguePortion.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("components': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_components=OMIT_VALUE;
    else {
      field_components.BER_decode_TLV(ComponentPortion_descr_, tmp_tlv, L_form);
      if(field_components.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int Continue::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_dialoguePortion.is_present()) {
    c |= 128;
  }
  if (field_components.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_otid.OER_encode(OrigTransactionID_descr_, p_buf);
  field_dtid.OER_encode(DestTransactionID_descr_, p_buf);
  if (field_dialoguePortion.is_present())
    field_dialoguePortion.OER_encode(DialoguePortion_descr_, p_buf);
  if (field_components.is_present())
    field_components.OER_encode(ComponentPortion_descr_, p_buf);
  return 0;
}

int Continue::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  field_otid.OER_decode(OrigTransactionID_descr_, p_buf, p_oer);
  field_dtid.OER_decode(DestTransactionID_descr_, p_buf, p_oer);
  if (uc[0] & 128)
    field_dialoguePortion.OER_decode(DialoguePortion_descr_, p_buf, p_oer);
 else
    field_dialoguePortion = OMIT_VALUE;
  if (uc[0] & 64)
    field_components.OER_decode(ComponentPortion_descr_, p_buf, p_oer);
 else
    field_components = OMIT_VALUE;
  return 0;
}

void Continue::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_dialoguePortion_present = field_dialoguePortion.is_present();
p_buf.PER_put_bit(field_dialoguePortion_present);
boolean field_components_present = field_components.is_present();
p_buf.PER_put_bit(field_components_present);
field_otid.PER_encode(OrigTransactionID_descr_, p_buf, p_options);
field_dtid.PER_encode(DestTransactionID_descr_, p_buf, p_options);
if (field_dialoguePortion_present) field_dialoguePortion.PER_encode(DialoguePortion_descr_, p_buf, p_options);
if (field_components_present) field_components.PER_encode(ComponentPortion_descr_, p_buf, p_options);
}

void Continue::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_dialoguePortion_present = p_buf.PER_get_bit();
boolean field_components_present = p_buf.PER_get_bit();
field_otid.PER_decode(OrigTransactionID_descr_, p_buf, p_options);
field_dtid.PER_decode(DestTransactionID_descr_, p_buf, p_options);
if (field_dialoguePortion_present) field_dialoguePortion.PER_decode(DialoguePortion_descr_, p_buf, p_options);
else field_dialoguePortion = OMIT_VALUE;
if (field_components_present) field_components.PER_decode(ComponentPortion_descr_, p_buf, p_options);
else field_components = OMIT_VALUE;
}

struct Continue_template::single_value_struct {
OCTETSTRING_template field_otid;
OCTETSTRING_template field_dtid;
EXTERNAL_template field_dialoguePortion;
ComponentPortion_template field_components;
};

void Continue_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_otid = ANY_VALUE;
single_value->field_dtid = ANY_VALUE;
single_value->field_dialoguePortion = ANY_OR_OMIT;
single_value->field_components = ANY_OR_OMIT;
}
}
}

void Continue_template::copy_value(const Continue& other_value)
{
single_value = new single_value_struct;
if (other_value.otid().is_bound()) {
  single_value->field_otid = other_value.otid();
} else {
  single_value->field_otid.clean_up();
}
if (other_value.dtid().is_bound()) {
  single_value->field_dtid = other_value.dtid();
} else {
  single_value->field_dtid.clean_up();
}
if (other_value.dialoguePortion().is_bound()) {
  if (other_value.dialoguePortion().ispresent()) single_value->field_dialoguePortion = other_value.dialoguePortion()();
  else single_value->field_dialoguePortion = OMIT_VALUE;
} else {
  single_value->field_dialoguePortion.clean_up();
}
if (other_value.components().is_bound()) {
  if (other_value.components().ispresent()) single_value->field_components = other_value.components()();
  else single_value->field_components = OMIT_VALUE;
} else {
  single_value->field_components.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Continue_template::copy_template(const Continue_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.otid().get_selection()) {
single_value->field_otid = other_value.otid();
} else {
single_value->field_otid.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dtid().get_selection()) {
single_value->field_dtid = other_value.dtid();
} else {
single_value->field_dtid.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dialoguePortion().get_selection()) {
single_value->field_dialoguePortion = other_value.dialoguePortion();
} else {
single_value->field_dialoguePortion.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.components().get_selection()) {
single_value->field_components = other_value.components();
} else {
single_value->field_components.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Continue_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Continue_template(*other_value.implication_.precondition);
implication_.implied_template = new Continue_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @TCAPMessages.Continue.");
break;
}
set_selection(other_value);
}

Continue_template::Continue_template()
{
}

Continue_template::Continue_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Continue_template::Continue_template(const Continue& other_value)
{
copy_value(other_value);
}

Continue_template::Continue_template(const OPTIONAL<Continue>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Continue&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @TCAPMessages.Continue from an unbound optional field.");
}
}

Continue_template::Continue_template(Continue_template* p_precondition, Continue_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Continue_template::Continue_template(Dynamic_Match_Interface<Continue>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Continue>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Continue_template::Continue_template(const Continue_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Continue_template::~Continue_template()
{
clean_up();
}

Continue_template& Continue_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Continue_template& Continue_template::operator=(const Continue& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Continue_template& Continue_template::operator=(const OPTIONAL<Continue>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Continue&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @TCAPMessages.Continue.");
}
return *this;
}

Continue_template& Continue_template::operator=(const Continue_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Continue_template::match(const Continue& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.otid().is_bound()) return FALSE;
if(!single_value->field_otid.match(other_value.otid(), legacy))return FALSE;
if(!other_value.dtid().is_bound()) return FALSE;
if(!single_value->field_dtid.match(other_value.dtid(), legacy))return FALSE;
if(!other_value.dialoguePortion().is_bound()) return FALSE;
if((other_value.dialoguePortion().ispresent() ? !single_value->field_dialoguePortion.match((const EXTERNAL&)other_value.dialoguePortion(), legacy) : !single_value->field_dialoguePortion.match_omit(legacy)))return FALSE;
if(!other_value.components().is_bound()) return FALSE;
if((other_value.components().ispresent() ? !single_value->field_components.match((const ComponentPortion&)other_value.components(), legacy) : !single_value->field_components.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @TCAPMessages.Continue.");
}
return FALSE;
}

boolean Continue_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_otid.is_bound()
 || single_value->field_dtid.is_bound()
 || (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_bound())
 || (single_value->field_components.is_omit() || single_value->field_components.is_bound());
}

boolean Continue_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_otid.is_value()
 && single_value->field_dtid.is_value()
 && (single_value->field_dialoguePortion.is_omit() || single_value->field_dialoguePortion.is_value())
 && (single_value->field_components.is_omit() || single_value->field_components.is_value());
}

void Continue_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Continue Continue_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @TCAPMessages.Continue.");
Continue ret_val;
if (single_value->field_otid.is_bound()) {
ret_val.otid() = single_value->field_otid.valueof();
}
if (single_value->field_dtid.is_bound()) {
ret_val.dtid() = single_value->field_dtid.valueof();
}
if (single_value->field_dialoguePortion.is_omit()) ret_val.dialoguePortion() = OMIT_VALUE;
else if (single_value->field_dialoguePortion.is_bound()) {
ret_val.dialoguePortion() = single_value->field_dialoguePortion.valueof();
}
if (single_value->field_components.is_omit()) ret_val.components() = OMIT_VALUE;
else if (single_value->field_components.is_bound()) {
ret_val.components() = single_value->field_components.valueof();
}
return ret_val;
}

void Continue_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @TCAPMessages.Continue.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Continue_template[list_length];
}

Continue_template& Continue_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @TCAPMessages.Continue.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @TCAPMessages.Continue.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Continue_template::otid()
{
set_specific();
return single_value->field_otid;
}

const OCTETSTRING_template& Continue_template::otid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field otid of a non-specific template of type @TCAPMessages.Continue.");
return single_value->field_otid;
}

OCTETSTRING_template& Continue_template::dtid()
{
set_specific();
return single_value->field_dtid;
}

const OCTETSTRING_template& Continue_template::dtid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dtid of a non-specific template of type @TCAPMessages.Continue.");
return single_value->field_dtid;
}

EXTERNAL_template& Continue_template::dialoguePortion()
{
set_specific();
return single_value->field_dialoguePortion;
}

const EXTERNAL_template& Continue_template::dialoguePortion() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dialoguePortion of a non-specific template of type @TCAPMessages.Continue.");
return single_value->field_dialoguePortion;
}

ComponentPortion_template& Continue_template::components()
{
set_specific();
return single_value->field_components;
}

const ComponentPortion_template& Continue_template::components() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field components of a non-specific template of type @TCAPMessages.Continue.");
return single_value->field_components;
}

int Continue_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_dialoguePortion.is_present()) ret_val++;
      if (single_value->field_components.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @TCAPMessages.Continue containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Continue containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @TCAPMessages.Continue.");
  }
  return 0;
}

void Continue_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ otid := ");
single_value->field_otid.log();
TTCN_Logger::log_event_str(", dtid := ");
single_value->field_dtid.log();
TTCN_Logger::log_event_str(", dialoguePortion := ");
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(", components := ");
single_value->field_components.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Continue_template::log_match(const Continue& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_otid.match(match_value.otid(), legacy)){
TTCN_Logger::log_logmatch_info(".otid");
single_value->field_otid.log_match(match_value.otid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dtid.match(match_value.dtid(), legacy)){
TTCN_Logger::log_logmatch_info(".dtid");
single_value->field_dtid.log_match(match_value.dtid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.dialoguePortion().ispresent()){
if(!single_value->field_dialoguePortion.match(match_value.dialoguePortion(), legacy)){
TTCN_Logger::log_logmatch_info(".dialoguePortion");
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dialoguePortion.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dialoguePortion := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dialoguePortion.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.components().ispresent()){
if(!single_value->field_components.match(match_value.components(), legacy)){
TTCN_Logger::log_logmatch_info(".components");
single_value->field_components.log_match(match_value.components(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_components.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".components := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_components.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ otid := ");
single_value->field_otid.log_match(match_value.otid(), legacy);
TTCN_Logger::log_event_str(", dtid := ");
single_value->field_dtid.log_match(match_value.dtid(), legacy);
TTCN_Logger::log_event_str(", dialoguePortion := ");
if (match_value.dialoguePortion().ispresent()) {
single_value->field_dialoguePortion.log_match(match_value.dialoguePortion(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dialoguePortion.log();
if (single_value->field_dialoguePortion.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", components := ");
if (match_value.components().ispresent()) {
single_value->field_components.log_match(match_value.components(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_components.log();
if (single_value->field_components.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Continue_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (otid().is_bound()) otid().set_implicit_omit();
if (dtid().is_bound()) dtid().set_implicit_omit();
if (!dialoguePortion().is_bound()) dialoguePortion() = OMIT_VALUE;
else dialoguePortion().set_implicit_omit();
if (!components().is_bound()) components() = OMIT_VALUE;
else components().set_implicit_omit();
}

void Continue_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_otid.encode_text(text_buf);
single_value->field_dtid.encode_text(text_buf);
single_value->field_dialoguePortion.encode_text(text_buf);
single_value->field_components.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @TCAPMessages.Continue.");
}
}

void Continue_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_otid.decode_text(text_buf);
single_value->field_dtid.decode_text(text_buf);
single_value->field_dialoguePortion.decode_text(text_buf);
single_value->field_components.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Continue_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @TCAPMessages.Continue.");
}
}

void Continue_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Continue_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @TCAPMessages.Continue has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) otid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dtid().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dialoguePortion().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) components().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "otid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          otid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dtid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dtid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dialoguePortion")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dialoguePortion().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "components")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          components().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Continue: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Continue_template* precondition = new Continue_template;
    precondition->set_param(*param.get_elem(0));
    Continue_template* implied_template = new Continue_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Continue_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@TCAPMessages.Continue");
  }
  is_ifpresent = param.get_ifpresent();
}

void Continue_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_otid.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Continue");
single_value->field_dtid.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Continue");
single_value->field_dialoguePortion.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Continue");
single_value->field_components.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Continue");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Continue");
}

boolean Continue_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Continue_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Abort::Abort()
{
}

Abort::Abort(const OCTETSTRING& par_dtid,
    const OPTIONAL< Reason >& par_reason)
  :   field_dtid(par_dtid),
  field_reason(par_reason)
{
}

Abort::Abort(const Abort& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @TCAPMessages.Abort.");
if (other_value.dtid().is_bound()) field_dtid = other_value.dtid();
else field_dtid.clean_up();
if (other_value.reason().is_bound()) field_reason = other_value.reason();
else field_reason.clean_up();
}

void Abort::clean_up()
{
field_dtid.clean_up();
field_reason.clean_up();
}

const TTCN_Typedescriptor_t* Abort::get_descriptor() const { return &Abort_descr_; }
Abort& Abort::operator=(const Abort& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @TCAPMessages.Abort.");
  if (other_value.dtid().is_bound()) field_dtid = other_value.dtid();
  else field_dtid.clean_up();
  if (other_value.reason().is_bound()) field_reason = other_value.reason();
  else field_reason.clean_up();
}
return *this;
}

boolean Abort::operator==(const Abort& other_value) const
{
return field_dtid==other_value.field_dtid
  && field_reason==other_value.field_reason;
}

boolean Abort::is_bound() const
{
return (field_dtid.is_bound())
  || (OPTIONAL_OMIT == field_reason.get_selection() || field_reason.is_bound());
}
boolean Abort::is_value() const
{
return field_dtid.is_value()
  && (OPTIONAL_OMIT == field_reason.get_selection() || field_reason.is_value());
}
int Abort::size_of() const
{
  int ret_val = 1;
  if (field_reason.ispresent()) ret_val++;
  return ret_val;
}

void Abort::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ dtid := ");
field_dtid.log();
TTCN_Logger::log_event_str(", reason := ");
field_reason.log();
TTCN_Logger::log_event_str(" }");
}

void Abort::set_implicit_omit()
{
if (dtid().is_bound()) dtid().set_implicit_omit();
if (!reason().is_bound()) reason() = OMIT_VALUE;
else reason().set_implicit_omit();
}

void Abort::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @TCAPMessages.Abort has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dtid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reason().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dtid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dtid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Abort: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@TCAPMessages.Abort");
  }
}

void Abort::encode_text(Text_Buf& text_buf) const
{
field_dtid.encode_text(text_buf);
field_reason.encode_text(text_buf);
}

void Abort::decode_text(Text_Buf& text_buf)
{
field_dtid.decode_text(text_buf);
field_reason.decode_text(text_buf);
}

void Abort::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Abort::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Abort::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("dtid': ");
  new_tlv->add_TLV(field_dtid.BER_encode_TLV(DestTransactionID_descr_, p_coding));
  ec_1.set_msg("reason': ");
  new_tlv->add_TLV(field_reason.BER_encode_TLV(Reason_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Abort::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Abort' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("dtid': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_dtid.BER_decode_TLV(DestTransactionID_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("reason': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_reason=OMIT_VALUE;
    else {
      field_reason.BER_decode_TLV(Reason_descr_, tmp_tlv, L_form);
      if(field_reason.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int Abort::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_reason.is_present()) {
    c |= 128;
  }
  p_buf.put_c(c);
  field_dtid.OER_encode(DestTransactionID_descr_, p_buf);
  if (field_reason.is_present())
    field_reason.OER_encode(Reason_descr_, p_buf);
  return 0;
}

int Abort::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  field_dtid.OER_decode(DestTransactionID_descr_, p_buf, p_oer);
  if (uc[0] & 128)
    field_reason.OER_decode(Reason_descr_, p_buf, p_oer);
 else
    field_reason = OMIT_VALUE;
  return 0;
}

void Abort::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean field_reason_present = field_reason.is_present();
p_buf.PER_put_bit(field_reason_present);
field_dtid.PER_encode(DestTransactionID_descr_, p_buf, p_options);
if (field_reason_present) field_reason.PER_encode(Reason_descr_, p_buf, p_options);
}

void Abort::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean field_reason_present = p_buf.PER_get_bit();
field_dtid.PER_decode(DestTransactionID_descr_, p_buf, p_options);
if (field_reason_present) field_reason.PER_decode(Reason_descr_, p_buf, p_options);
else field_reason = OMIT_VALUE;
}

struct Abort_template::single_value_struct {
OCTETSTRING_template field_dtid;
Reason_template field_reason;
};

void Abort_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_dtid = ANY_VALUE;
single_value->field_reason = ANY_OR_OMIT;
}
}
}

void Abort_template::copy_value(const Abort& other_value)
{
single_value = new single_value_struct;
if (other_value.dtid().is_bound()) {
  single_value->field_dtid = other_value.dtid();
} else {
  single_value->field_dtid.clean_up();
}
if (other_value.reason().is_bound()) {
  if (other_value.reason().ispresent()) single_value->field_reason = other_value.reason()();
  else single_value->field_reason = OMIT_VALUE;
} else {
  single_value->field_reason.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Abort_template::copy_template(const Abort_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.dtid().get_selection()) {
single_value->field_dtid = other_value.dtid();
} else {
single_value->field_dtid.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reason().get_selection()) {
single_value->field_reason = other_value.reason();
} else {
single_value->field_reason.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Abort_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Abort_template(*other_value.implication_.precondition);
implication_.implied_template = new Abort_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @TCAPMessages.Abort.");
break;
}
set_selection(other_value);
}

Abort_template::Abort_template()
{
}

Abort_template::Abort_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Abort_template::Abort_template(const Abort& other_value)
{
copy_value(other_value);
}

Abort_template::Abort_template(const OPTIONAL<Abort>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Abort&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @TCAPMessages.Abort from an unbound optional field.");
}
}

Abort_template::Abort_template(Abort_template* p_precondition, Abort_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Abort_template::Abort_template(Dynamic_Match_Interface<Abort>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Abort>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Abort_template::Abort_template(const Abort_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Abort_template::~Abort_template()
{
clean_up();
}

Abort_template& Abort_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Abort_template& Abort_template::operator=(const Abort& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Abort_template& Abort_template::operator=(const OPTIONAL<Abort>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Abort&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @TCAPMessages.Abort.");
}
return *this;
}

Abort_template& Abort_template::operator=(const Abort_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Abort_template::match(const Abort& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.dtid().is_bound()) return FALSE;
if(!single_value->field_dtid.match(other_value.dtid(), legacy))return FALSE;
if(!other_value.reason().is_bound()) return FALSE;
if((other_value.reason().ispresent() ? !single_value->field_reason.match((const Reason&)other_value.reason(), legacy) : !single_value->field_reason.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @TCAPMessages.Abort.");
}
return FALSE;
}

boolean Abort_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_dtid.is_bound()
 || (single_value->field_reason.is_omit() || single_value->field_reason.is_bound());
}

boolean Abort_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_dtid.is_value()
 && (single_value->field_reason.is_omit() || single_value->field_reason.is_value());
}

void Abort_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Abort Abort_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @TCAPMessages.Abort.");
Abort ret_val;
if (single_value->field_dtid.is_bound()) {
ret_val.dtid() = single_value->field_dtid.valueof();
}
if (single_value->field_reason.is_omit()) ret_val.reason() = OMIT_VALUE;
else if (single_value->field_reason.is_bound()) {
ret_val.reason() = single_value->field_reason.valueof();
}
return ret_val;
}

void Abort_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @TCAPMessages.Abort.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Abort_template[list_length];
}

Abort_template& Abort_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @TCAPMessages.Abort.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @TCAPMessages.Abort.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Abort_template::dtid()
{
set_specific();
return single_value->field_dtid;
}

const OCTETSTRING_template& Abort_template::dtid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dtid of a non-specific template of type @TCAPMessages.Abort.");
return single_value->field_dtid;
}

Reason_template& Abort_template::reason()
{
set_specific();
return single_value->field_reason;
}

const Reason_template& Abort_template::reason() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reason of a non-specific template of type @TCAPMessages.Abort.");
return single_value->field_reason;
}

int Abort_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_reason.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @TCAPMessages.Abort containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @TCAPMessages.Abort containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @TCAPMessages.Abort.");
  }
  return 0;
}

void Abort_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ dtid := ");
single_value->field_dtid.log();
TTCN_Logger::log_event_str(", reason := ");
single_value->field_reason.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Abort_template::log_match(const Abort& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_dtid.match(match_value.dtid(), legacy)){
TTCN_Logger::log_logmatch_info(".dtid");
single_value->field_dtid.log_match(match_value.dtid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.reason().ispresent()){
if(!single_value->field_reason.match(match_value.reason(), legacy)){
TTCN_Logger::log_logmatch_info(".reason");
single_value->field_reason.log_match(match_value.reason(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_reason.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".reason := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_reason.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ dtid := ");
single_value->field_dtid.log_match(match_value.dtid(), legacy);
TTCN_Logger::log_event_str(", reason := ");
if (match_value.reason().ispresent()) {
single_value->field_reason.log_match(match_value.reason(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_reason.log();
if (single_value->field_reason.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Abort_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (dtid().is_bound()) dtid().set_implicit_omit();
if (!reason().is_bound()) reason() = OMIT_VALUE;
else reason().set_implicit_omit();
}

void Abort_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_dtid.encode_text(text_buf);
single_value->field_reason.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @TCAPMessages.Abort.");
}
}

void Abort_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_dtid.decode_text(text_buf);
single_value->field_reason.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Abort_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @TCAPMessages.Abort.");
}
}

void Abort_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Abort_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @TCAPMessages.Abort has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) dtid().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reason().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dtid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dtid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reason")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reason().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @TCAPMessages.Abort: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Abort_template* precondition = new Abort_template;
    precondition->set_param(*param.get_elem(0));
    Abort_template* implied_template = new Abort_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Abort_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@TCAPMessages.Abort");
  }
  is_ifpresent = param.get_ifpresent();
}

void Abort_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_dtid.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Abort");
single_value->field_reason.check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Abort");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Abort");
}

boolean Abort_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Abort_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Reason::copy_value(const Reason& other_value)
{
switch (other_value.union_selection) {
case ALT_p__abortCause:
field_p__abortCause = new INTEGER(*other_value.field_p__abortCause);
break;
case ALT_u__abortCause:
field_u__abortCause = new EXTERNAL(*other_value.field_u__abortCause);
break;
default:
TTCN_error("Assignment of an unbound union value of type @TCAPMessages.Reason.");
}
union_selection = other_value.union_selection;
}

Reason::Reason()
{
union_selection = UNBOUND_VALUE;
}

Reason::Reason(const Reason& other_value)
: Base_Type(){
copy_value(other_value);
}

Reason::~Reason()
{
clean_up();
}

Reason& Reason::operator=(const Reason& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean Reason::operator==(const Reason& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @TCAPMessages.Reason.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @TCAPMessages.Reason.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_p__abortCause:
return *field_p__abortCause == *other_value.field_p__abortCause;
case ALT_u__abortCause:
return *field_u__abortCause == *other_value.field_u__abortCause;
default:
return FALSE;
}
}

INTEGER& Reason::p__abortCause()
{
if (union_selection != ALT_p__abortCause) {
clean_up();
field_p__abortCause = new INTEGER;
union_selection = ALT_p__abortCause;
}
return *field_p__abortCause;
}

const INTEGER& Reason::p__abortCause() const
{
if (union_selection != ALT_p__abortCause) TTCN_error("Using non-selected field p_abortCause in a value of union type @TCAPMessages.Reason.");
return *field_p__abortCause;
}

EXTERNAL& Reason::u__abortCause()
{
if (union_selection != ALT_u__abortCause) {
clean_up();
field_u__abortCause = new EXTERNAL;
union_selection = ALT_u__abortCause;
}
return *field_u__abortCause;
}

const EXTERNAL& Reason::u__abortCause() const
{
if (union_selection != ALT_u__abortCause) TTCN_error("Using non-selected field u_abortCause in a value of union type @TCAPMessages.Reason.");
return *field_u__abortCause;
}

boolean Reason::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.Reason.");
return union_selection == checked_selection;
}

boolean Reason::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean Reason::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_p__abortCause: return field_p__abortCause->is_value();
case ALT_u__abortCause: return field_u__abortCause->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void Reason::clean_up()
{
switch (union_selection) {
case ALT_p__abortCause:
  delete field_p__abortCause;
  break;
case ALT_u__abortCause:
  delete field_u__abortCause;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void Reason::log() const
{
switch (union_selection) {
case ALT_p__abortCause:
TTCN_Logger::log_event_str("{ p_abortCause := ");
field_p__abortCause->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_u__abortCause:
TTCN_Logger::log_event_str("{ u_abortCause := ");
field_u__abortCause->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void Reason::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "p_abortCause")) {
    p__abortCause().set_param(*mp_last);
    if (!p__abortCause().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "u_abortCause")) {
    u__abortCause().set_param(*mp_last);
    if (!u__abortCause().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @TCAPMessages.Reason.", last_name);
}

void Reason::set_implicit_omit()
{
switch (union_selection) {
case ALT_p__abortCause:
field_p__abortCause->set_implicit_omit(); break;
case ALT_u__abortCause:
field_u__abortCause->set_implicit_omit(); break;
default: break;
}
}

void Reason::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_p__abortCause:
field_p__abortCause->encode_text(text_buf);
break;
case ALT_u__abortCause:
field_u__abortCause->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @TCAPMessages.Reason.");
}
}

void Reason::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_p__abortCause:
p__abortCause().decode_text(text_buf);
break;
case ALT_u__abortCause:
u__abortCause().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @TCAPMessages.Reason.");
}
}

void Reason::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Reason::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *Reason::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_p__abortCause:
    ec_1.set_msg("p_abortCause': ");
    new_tlv = field_p__abortCause->BER_encode_TLV(Reason_p__abortCause_descr_, p_coding);
    break;
  case ALT_u__abortCause:
    ec_1.set_msg("u_abortCause': ");
    new_tlv = field_u__abortCause->BER_encode_TLV(DialoguePortion_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean Reason::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_p__abortCause = new INTEGER;
  union_selection = ALT_p__abortCause;
  if (field_p__abortCause->BER_decode_isMyMsg(Reason_p__abortCause_descr_, p_tlv)) return TRUE;
  delete field_p__abortCause;
  field_u__abortCause = new EXTERNAL;
  union_selection = ALT_u__abortCause;
  if (field_u__abortCause->BER_decode_isMyMsg(DialoguePortion_descr_, p_tlv)) return TRUE;
  delete field_u__abortCause;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean Reason::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    Reason tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean Reason::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.Reason' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_p__abortCause:
    ec_2.set_msg("p_abortCause': ");
    field_p__abortCause->BER_decode_TLV(Reason_p__abortCause_descr_, tmp_tlv, L_form);
    break;
  case ALT_u__abortCause:
    ec_2.set_msg("u_abortCause': ");
    field_u__abortCause->BER_decode_TLV(DialoguePortion_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int Reason::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_p__abortCause:
    {TTCN_Buffer buf;
    encode_oer_tag(*Reason_p__abortCause_descr_.ber, p_buf);
    field_p__abortCause->OER_encode(Reason_p__abortCause_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_u__abortCause:
    {TTCN_Buffer buf;
    encode_oer_tag(*DialoguePortion_descr_.ber, p_buf);
    field_u__abortCause->OER_encode(DialoguePortion_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.Reason.");
    return -1;
  }

  return 0;
}
int Reason::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (Reason_p__abortCause_descr_.ber->tags[Reason_p__abortCause_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      Reason_p__abortCause_descr_.ber->tags[Reason_p__abortCause_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    p__abortCause().OER_decode(Reason_p__abortCause_descr_, p_buf, p_oer);
  } else 
  if (DialoguePortion_descr_.ber->tags[DialoguePortion_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      DialoguePortion_descr_.ber->tags[DialoguePortion_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    u__abortCause().OER_decode(DialoguePortion_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type Reason");
}
  return 0;
}
void Reason::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
switch (union_selection) {
case ALT_p__abortCause: {
INTEGER::PER_encode_int(p_buf, 0, 1);
field_p__abortCause->PER_encode(Reason_p__abortCause_descr_, p_buf, p_options);
break; }
case ALT_u__abortCause: {
INTEGER::PER_encode_int(p_buf, 1, 1);
field_u__abortCause->PER_encode(DialoguePortion_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void Reason::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
int sel_int;
INTEGER::PER_decode_int(p_buf, 1, FALSE, sel_int);
switch (sel_int) {
case 0:
p__abortCause().PER_decode(Reason_p__abortCause_descr_, p_buf, p_options);
break;
case 1:
u__abortCause().PER_decode(DialoguePortion_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}

void Reason_template::copy_value(const Reason& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
single_value.field_p__abortCause = new INTEGER_template(other_value.p__abortCause());
break;
case Reason::ALT_u__abortCause:
single_value.field_u__abortCause = new EXTERNAL_template(other_value.u__abortCause());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @TCAPMessages.Reason.");
}
set_selection(SPECIFIC_VALUE);
}

void Reason_template::copy_template(const Reason_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
single_value.field_p__abortCause = new INTEGER_template(*other_value.single_value.field_p__abortCause);
break;
case Reason::ALT_u__abortCause:
single_value.field_u__abortCause = new EXTERNAL_template(*other_value.single_value.field_u__abortCause);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @TCAPMessages.Reason.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Reason_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Reason_template(*other_value.implication_.precondition);
implication_.implied_template = new Reason_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @TCAPMessages.Reason.");
}
set_selection(other_value);
}

Reason_template::Reason_template()
{
}

Reason_template::Reason_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Reason_template::Reason_template(const Reason& other_value)
{
copy_value(other_value);
}

Reason_template::Reason_template(const OPTIONAL<Reason>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reason&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @TCAPMessages.Reason from an unbound optional field.");
}
}

Reason_template::Reason_template(Reason_template* p_precondition, Reason_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Reason_template::Reason_template(Dynamic_Match_Interface<Reason>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Reason>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Reason_template::Reason_template(const Reason_template& other_value)
: Base_Template(){
copy_template(other_value);
}

Reason_template::~Reason_template()
{
clean_up();
}

void Reason_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
delete single_value.field_p__abortCause;
break;
case Reason::ALT_u__abortCause:
delete single_value.field_u__abortCause;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Reason_template& Reason_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Reason_template& Reason_template::operator=(const Reason& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Reason_template& Reason_template::operator=(const OPTIONAL<Reason>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reason&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @TCAPMessages.Reason.");
}
return *this;
}

Reason_template& Reason_template::operator=(const Reason_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Reason_template::match(const Reason& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
Reason::union_selection_type value_selection = other_value.get_selection();
if (value_selection == Reason::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case Reason::ALT_p__abortCause:
return single_value.field_p__abortCause->match(other_value.p__abortCause(), legacy);
case Reason::ALT_u__abortCause:
return single_value.field_u__abortCause->match(other_value.u__abortCause(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @TCAPMessages.Reason.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @TCAPMessages.Reason.");
}
return FALSE;
}

boolean Reason_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
return single_value.field_p__abortCause->is_value();
case Reason::ALT_u__abortCause:
return single_value.field_u__abortCause->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @TCAPMessages.Reason.");
}
}

Reason Reason_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @TCAPMessages.Reason.");
Reason ret_val;
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
ret_val.p__abortCause() = single_value.field_p__abortCause->valueof();
break;
case Reason::ALT_u__abortCause:
ret_val.u__abortCause() = single_value.field_u__abortCause->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @TCAPMessages.Reason.");
}
return ret_val;
}

Reason_template& Reason_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @TCAPMessages.Reason.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @TCAPMessages.Reason.");
return value_list.list_value[list_index];
}
void Reason_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @TCAPMessages.Reason.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Reason_template[list_length];
}

INTEGER_template& Reason_template::p__abortCause()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reason::ALT_p__abortCause) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_p__abortCause = new INTEGER_template(ANY_VALUE);
else single_value.field_p__abortCause = new INTEGER_template;
single_value.union_selection = Reason::ALT_p__abortCause;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_p__abortCause;
}

const INTEGER_template& Reason_template::p__abortCause() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field p_abortCause in a non-specific template of union type @TCAPMessages.Reason.");
if (single_value.union_selection != Reason::ALT_p__abortCause) TTCN_error("Accessing non-selected field p_abortCause in a template of union type @TCAPMessages.Reason.");
return *single_value.field_p__abortCause;
}

EXTERNAL_template& Reason_template::u__abortCause()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Reason::ALT_u__abortCause) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_u__abortCause = new EXTERNAL_template(ANY_VALUE);
else single_value.field_u__abortCause = new EXTERNAL_template;
single_value.union_selection = Reason::ALT_u__abortCause;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_u__abortCause;
}

const EXTERNAL_template& Reason_template::u__abortCause() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field u_abortCause in a non-specific template of union type @TCAPMessages.Reason.");
if (single_value.union_selection != Reason::ALT_u__abortCause) TTCN_error("Accessing non-selected field u_abortCause in a template of union type @TCAPMessages.Reason.");
return *single_value.field_u__abortCause;
}

boolean Reason_template::ischosen(Reason::union_selection_type checked_selection) const
{
if (checked_selection == Reason::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.Reason.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == Reason::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @TCAPMessages.Reason.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @TCAPMessages.Reason containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void Reason_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
TTCN_Logger::log_event_str("{ p_abortCause := ");
single_value.field_p__abortCause->log();
TTCN_Logger::log_event_str(" }");
break;
case Reason::ALT_u__abortCause:
TTCN_Logger::log_event_str("{ u_abortCause := ");
single_value.field_u__abortCause->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Reason_template::log_match(const Reason& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".p_abortCause");
single_value.field_p__abortCause->log_match(match_value.p__abortCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ p_abortCause := ");
single_value.field_p__abortCause->log_match(match_value.p__abortCause(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case Reason::ALT_u__abortCause:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".u_abortCause");
single_value.field_u__abortCause->log_match(match_value.u__abortCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ u_abortCause := ");
single_value.field_u__abortCause->log_match(match_value.u__abortCause(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Reason_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
single_value.field_p__abortCause->set_implicit_omit(); break;
case Reason::ALT_u__abortCause:
single_value.field_u__abortCause->set_implicit_omit(); break;
default: break;
}
}

void Reason_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
single_value.field_p__abortCause->encode_text(text_buf);
break;
case Reason::ALT_u__abortCause:
single_value.field_u__abortCause->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @TCAPMessages.Reason.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @TCAPMessages.Reason.");
}
}

void Reason_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = Reason::UNBOUND_VALUE;
Reason::union_selection_type new_selection = (Reason::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case Reason::ALT_p__abortCause:
single_value.field_p__abortCause = new INTEGER_template;
single_value.field_p__abortCause->decode_text(text_buf);
break;
case Reason::ALT_u__abortCause:
single_value.field_u__abortCause = new EXTERNAL_template;
single_value.field_u__abortCause->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @TCAPMessages.Reason.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Reason_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @TCAPMessages.Reason.");
}
}

boolean Reason_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Reason_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Reason_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@TCAPMessages.Reason'");
    }
    if (strcmp("p_abortCause", param_field) == 0) {
      p__abortCause().set_param(param);
      return;
    } else if (strcmp("u_abortCause", param_field) == 0) {
      u__abortCause().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@TCAPMessages.Reason'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Reason_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@TCAPMessages.Reason");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "p_abortCause")) {
      p__abortCause().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "u_abortCause")) {
      u__abortCause().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @TCAPMessages.Reason.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    Reason_template* precondition = new Reason_template;
    precondition->set_param(*m_p->get_elem(0));
    Reason_template* implied_template = new Reason_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = Reason_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@TCAPMessages.Reason");
  }
  is_ifpresent = param.get_ifpresent();
}

void Reason_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case Reason::ALT_p__abortCause:
single_value.field_p__abortCause->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reason");
return;
case Reason::ALT_u__abortCause:
single_value.field_u__abortCause->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.Reason");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @TCAPMessages.Reason.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.Reason");
}

void ERROR_::copy_value(const ERROR_& other_value)
{
switch (other_value.union_selection) {
case ALT_localValue:
field_localValue = new INTEGER(*other_value.field_localValue);
break;
case ALT_globalValue:
field_globalValue = new OBJID(*other_value.field_globalValue);
break;
default:
TTCN_error("Assignment of an unbound union value of type @TCAPMessages.ERROR.");
}
union_selection = other_value.union_selection;
}

ERROR_::ERROR_()
{
union_selection = UNBOUND_VALUE;
}

ERROR_::ERROR_(const ERROR_& other_value)
: Base_Type(){
copy_value(other_value);
}

ERROR_::~ERROR_()
{
clean_up();
}

ERROR_& ERROR_::operator=(const ERROR_& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean ERROR_::operator==(const ERROR_& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @TCAPMessages.ERROR.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @TCAPMessages.ERROR.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_localValue:
return *field_localValue == *other_value.field_localValue;
case ALT_globalValue:
return *field_globalValue == *other_value.field_globalValue;
default:
return FALSE;
}
}

INTEGER& ERROR_::localValue()
{
if (union_selection != ALT_localValue) {
clean_up();
field_localValue = new INTEGER;
union_selection = ALT_localValue;
}
return *field_localValue;
}

const INTEGER& ERROR_::localValue() const
{
if (union_selection != ALT_localValue) TTCN_error("Using non-selected field localValue in a value of union type @TCAPMessages.ERROR.");
return *field_localValue;
}

OBJID& ERROR_::globalValue()
{
if (union_selection != ALT_globalValue) {
clean_up();
field_globalValue = new OBJID;
union_selection = ALT_globalValue;
}
return *field_globalValue;
}

const OBJID& ERROR_::globalValue() const
{
if (union_selection != ALT_globalValue) TTCN_error("Using non-selected field globalValue in a value of union type @TCAPMessages.ERROR.");
return *field_globalValue;
}

boolean ERROR_::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.ERROR.");
return union_selection == checked_selection;
}

boolean ERROR_::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean ERROR_::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_localValue: return field_localValue->is_value();
case ALT_globalValue: return field_globalValue->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void ERROR_::clean_up()
{
switch (union_selection) {
case ALT_localValue:
  delete field_localValue;
  break;
case ALT_globalValue:
  delete field_globalValue;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void ERROR_::log() const
{
switch (union_selection) {
case ALT_localValue:
TTCN_Logger::log_event_str("{ localValue := ");
field_localValue->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_globalValue:
TTCN_Logger::log_event_str("{ globalValue := ");
field_globalValue->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void ERROR_::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "localValue")) {
    localValue().set_param(*mp_last);
    if (!localValue().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "globalValue")) {
    globalValue().set_param(*mp_last);
    if (!globalValue().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @TCAPMessages.ERROR.", last_name);
}

void ERROR_::set_implicit_omit()
{
switch (union_selection) {
case ALT_localValue:
field_localValue->set_implicit_omit(); break;
case ALT_globalValue:
field_globalValue->set_implicit_omit(); break;
default: break;
}
}

void ERROR_::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_localValue:
field_localValue->encode_text(text_buf);
break;
case ALT_globalValue:
field_globalValue->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @TCAPMessages.ERROR.");
}
}

void ERROR_::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_localValue:
localValue().decode_text(text_buf);
break;
case ALT_globalValue:
globalValue().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @TCAPMessages.ERROR.");
}
}

void ERROR_::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ERROR_::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *ERROR_::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_localValue:
    ec_1.set_msg("localValue': ");
    new_tlv = field_localValue->BER_encode_TLV(INTEGER_descr_, p_coding);
    break;
  case ALT_globalValue:
    ec_1.set_msg("globalValue': ");
    new_tlv = field_globalValue->BER_encode_TLV(OBJID_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean ERROR_::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_localValue = new INTEGER;
  union_selection = ALT_localValue;
  if (field_localValue->BER_decode_isMyMsg(INTEGER_descr_, p_tlv)) return TRUE;
  delete field_localValue;
  field_globalValue = new OBJID;
  union_selection = ALT_globalValue;
  if (field_globalValue->BER_decode_isMyMsg(OBJID_descr_, p_tlv)) return TRUE;
  delete field_globalValue;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean ERROR_::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    ERROR_ tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean ERROR_::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@TCAPMessages.ERROR' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_localValue:
    ec_2.set_msg("localValue': ");
    field_localValue->BER_decode_TLV(INTEGER_descr_, tmp_tlv, L_form);
    break;
  case ALT_globalValue:
    ec_2.set_msg("globalValue': ");
    field_globalValue->BER_decode_TLV(OBJID_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int ERROR_::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  boolean as_value = p_td.json->as_value;
  int enc_len = as_value ? 0 : p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
  switch(union_selection) {
  case ALT_localValue:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "localValue");
    }
    enc_len += field_localValue->JSON_encode(INTEGER_descr_, p_tok, FALSE);
    break;
  case ALT_globalValue:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "globalValue");
    }
    enc_len += field_globalValue->JSON_encode(OBJID_descr_, p_tok, FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.ERROR.");
    return -1;
  }

  if (!as_value) {
    enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  }
  return enc_len;
}

int ERROR_::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  if (0 <= p_chosen_field && 2 > p_chosen_field) {
    switch (p_chosen_field) {
    case 0:
      return localValue().JSON_decode(INTEGER_descr_, p_tok, TRUE, FALSE);
    case 1:
      return globalValue().JSON_decode(OBJID_descr_, p_tok, TRUE, FALSE);
    }
  }
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const ERROR_*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
 if (p_td.json->as_value) {
  size_t buf_pos = p_tok.get_buf_pos();
  p_tok.get_next_token(&j_token, NULL, NULL);
  int ret_val = 0;
  switch(j_token) {
  case JSON_TOKEN_NUMBER: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = localValue().JSON_decode(INTEGER_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "number '@TCAPMessages.ERROR'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_STRING: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = globalValue().JSON_decode(OBJID_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "string '@TCAPMessages.ERROR'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_TRUE:
  case JSON_TOKEN_LITERAL_FALSE: {
    char* literal_str = mprintf("literal (%s)",
      (JSON_TOKEN_LITERAL_TRUE == j_token) ? "true" : "false");
    try {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, literal_str);
    }
    catch (const TC_Error&) {
      Free(literal_str);
      throw;
    }
    Free(literal_str);
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_ARRAY_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "array '@TCAPMessages.ERROR'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_OBJECT_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "object '@TCAPMessages.ERROR'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_NULL: {
    clean_up();
    return JSON_ERROR_INVALID_TOKEN;
  }
  case JSON_TOKEN_ERROR:
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  default:
    return JSON_ERROR_INVALID_TOKEN;
  }
  return ret_val;
 }
 else {
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  char* fld_name = 0;
  size_t name_len = 0;
  dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
  if (JSON_TOKEN_NAME != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
    return JSON_ERROR_FATAL;
  } else {
if (10 == name_len && 0 == strncmp(fld_name, "localValue", name_len)) {
      int ret_val = localValue().JSON_decode(INTEGER_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "localValue");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (11 == name_len && 0 == strncmp(fld_name, "globalValue", name_len)) {
      int ret_val = globalValue().JSON_decode(OBJID_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "globalValue");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
      return JSON_ERROR_FATAL;
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
 }
}

int ERROR_::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_localValue:
    {TTCN_Buffer buf;
    encode_oer_tag(*INTEGER_descr_.ber, p_buf);
    field_localValue->OER_encode(INTEGER_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_globalValue:
    {TTCN_Buffer buf;
    encode_oer_tag(*OBJID_descr_.ber, p_buf);
    field_globalValue->OER_encode(OBJID_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @TCAPMessages.ERROR.");
    return -1;
  }

  return 0;
}
int ERROR_::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (INTEGER_descr_.ber->tags[INTEGER_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      INTEGER_descr_.ber->tags[INTEGER_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    localValue().OER_decode(INTEGER_descr_, p_buf, p_oer);
  } else 
  if (OBJID_descr_.ber->tags[OBJID_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      OBJID_descr_.ber->tags[OBJID_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    globalValue().OER_decode(OBJID_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type ERROR_");
}
  return 0;
}
void ERROR_::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
switch (union_selection) {
case ALT_localValue: {
INTEGER::PER_encode_int(p_buf, 0, 1);
field_localValue->PER_encode(INTEGER_descr_, p_buf, p_options);
break; }
case ALT_globalValue: {
INTEGER::PER_encode_int(p_buf, 1, 1);
field_globalValue->PER_encode(OBJID_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void ERROR_::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
int sel_int;
INTEGER::PER_decode_int(p_buf, 1, FALSE, sel_int);
switch (sel_int) {
case 0:
localValue().PER_decode(INTEGER_descr_, p_buf, p_options);
break;
case 1:
globalValue().PER_decode(OBJID_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}

void ERROR__template::copy_value(const ERROR_& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
single_value.field_localValue = new INTEGER_template(other_value.localValue());
break;
case ERROR_::ALT_globalValue:
single_value.field_globalValue = new OBJID_template(other_value.globalValue());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @TCAPMessages.ERROR.");
}
set_selection(SPECIFIC_VALUE);
}

void ERROR__template::copy_template(const ERROR__template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
single_value.field_localValue = new INTEGER_template(*other_value.single_value.field_localValue);
break;
case ERROR_::ALT_globalValue:
single_value.field_globalValue = new OBJID_template(*other_value.single_value.field_globalValue);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @TCAPMessages.ERROR.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ERROR__template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ERROR__template(*other_value.implication_.precondition);
implication_.implied_template = new ERROR__template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @TCAPMessages.ERROR.");
}
set_selection(other_value);
}

ERROR__template::ERROR__template()
{
}

ERROR__template::ERROR__template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ERROR__template::ERROR__template(const ERROR_& other_value)
{
copy_value(other_value);
}

ERROR__template::ERROR__template(const OPTIONAL<ERROR_>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ERROR_&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @TCAPMessages.ERROR from an unbound optional field.");
}
}

ERROR__template::ERROR__template(ERROR__template* p_precondition, ERROR__template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ERROR__template::ERROR__template(Dynamic_Match_Interface<ERROR_>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ERROR_>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ERROR__template::ERROR__template(const ERROR__template& other_value)
: Base_Template(){
copy_template(other_value);
}

ERROR__template::~ERROR__template()
{
clean_up();
}

void ERROR__template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
delete single_value.field_localValue;
break;
case ERROR_::ALT_globalValue:
delete single_value.field_globalValue;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ERROR__template& ERROR__template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ERROR__template& ERROR__template::operator=(const ERROR_& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ERROR__template& ERROR__template::operator=(const OPTIONAL<ERROR_>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ERROR_&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @TCAPMessages.ERROR.");
}
return *this;
}

ERROR__template& ERROR__template::operator=(const ERROR__template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ERROR__template::match(const ERROR_& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
ERROR_::union_selection_type value_selection = other_value.get_selection();
if (value_selection == ERROR_::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case ERROR_::ALT_localValue:
return single_value.field_localValue->match(other_value.localValue(), legacy);
case ERROR_::ALT_globalValue:
return single_value.field_globalValue->match(other_value.globalValue(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @TCAPMessages.ERROR.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @TCAPMessages.ERROR.");
}
return FALSE;
}

boolean ERROR__template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
return single_value.field_localValue->is_value();
case ERROR_::ALT_globalValue:
return single_value.field_globalValue->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @TCAPMessages.ERROR.");
}
}

ERROR_ ERROR__template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @TCAPMessages.ERROR.");
ERROR_ ret_val;
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
ret_val.localValue() = single_value.field_localValue->valueof();
break;
case ERROR_::ALT_globalValue:
ret_val.globalValue() = single_value.field_globalValue->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @TCAPMessages.ERROR.");
}
return ret_val;
}

ERROR__template& ERROR__template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @TCAPMessages.ERROR.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @TCAPMessages.ERROR.");
return value_list.list_value[list_index];
}
void ERROR__template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @TCAPMessages.ERROR.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ERROR__template[list_length];
}

INTEGER_template& ERROR__template::localValue()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ERROR_::ALT_localValue) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_localValue = new INTEGER_template(ANY_VALUE);
else single_value.field_localValue = new INTEGER_template;
single_value.union_selection = ERROR_::ALT_localValue;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_localValue;
}

const INTEGER_template& ERROR__template::localValue() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field localValue in a non-specific template of union type @TCAPMessages.ERROR.");
if (single_value.union_selection != ERROR_::ALT_localValue) TTCN_error("Accessing non-selected field localValue in a template of union type @TCAPMessages.ERROR.");
return *single_value.field_localValue;
}

OBJID_template& ERROR__template::globalValue()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ERROR_::ALT_globalValue) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_globalValue = new OBJID_template(ANY_VALUE);
else single_value.field_globalValue = new OBJID_template;
single_value.union_selection = ERROR_::ALT_globalValue;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_globalValue;
}

const OBJID_template& ERROR__template::globalValue() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field globalValue in a non-specific template of union type @TCAPMessages.ERROR.");
if (single_value.union_selection != ERROR_::ALT_globalValue) TTCN_error("Accessing non-selected field globalValue in a template of union type @TCAPMessages.ERROR.");
return *single_value.field_globalValue;
}

boolean ERROR__template::ischosen(ERROR_::union_selection_type checked_selection) const
{
if (checked_selection == ERROR_::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @TCAPMessages.ERROR.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == ERROR_::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @TCAPMessages.ERROR.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @TCAPMessages.ERROR containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void ERROR__template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
TTCN_Logger::log_event_str("{ localValue := ");
single_value.field_localValue->log();
TTCN_Logger::log_event_str(" }");
break;
case ERROR_::ALT_globalValue:
TTCN_Logger::log_event_str("{ globalValue := ");
single_value.field_globalValue->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ERROR__template::log_match(const ERROR_& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".localValue");
single_value.field_localValue->log_match(match_value.localValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ localValue := ");
single_value.field_localValue->log_match(match_value.localValue(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case ERROR_::ALT_globalValue:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".globalValue");
single_value.field_globalValue->log_match(match_value.globalValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ globalValue := ");
single_value.field_globalValue->log_match(match_value.globalValue(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ERROR__template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
single_value.field_localValue->set_implicit_omit(); break;
case ERROR_::ALT_globalValue:
single_value.field_globalValue->set_implicit_omit(); break;
default: break;
}
}

void ERROR__template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
single_value.field_localValue->encode_text(text_buf);
break;
case ERROR_::ALT_globalValue:
single_value.field_globalValue->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @TCAPMessages.ERROR.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @TCAPMessages.ERROR.");
}
}

void ERROR__template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = ERROR_::UNBOUND_VALUE;
ERROR_::union_selection_type new_selection = (ERROR_::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case ERROR_::ALT_localValue:
single_value.field_localValue = new INTEGER_template;
single_value.field_localValue->decode_text(text_buf);
break;
case ERROR_::ALT_globalValue:
single_value.field_globalValue = new OBJID_template;
single_value.field_globalValue->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @TCAPMessages.ERROR.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ERROR__template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @TCAPMessages.ERROR.");
}
}

boolean ERROR__template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ERROR__template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void ERROR__template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@TCAPMessages.ERROR'");
    }
    if (strcmp("localValue", param_field) == 0) {
      localValue().set_param(param);
      return;
    } else if (strcmp("globalValue", param_field) == 0) {
      globalValue().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@TCAPMessages.ERROR'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ERROR__template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@TCAPMessages.ERROR");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "localValue")) {
      localValue().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "globalValue")) {
      globalValue().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @TCAPMessages.ERROR.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    ERROR__template* precondition = new ERROR__template;
    precondition->set_param(*m_p->get_elem(0));
    ERROR__template* implied_template = new ERROR__template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = ERROR__template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@TCAPMessages.ERROR");
  }
  is_ifpresent = param.get_ifpresent();
}

void ERROR__template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case ERROR_::ALT_localValue:
single_value.field_localValue->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.ERROR");
return;
case ERROR_::ALT_globalValue:
single_value.field_globalValue->check_restriction(t_res, t_name ? t_name : "@TCAPMessages.ERROR");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @TCAPMessages.ERROR.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@TCAPMessages.ERROR");
}


/* Bodies of functions, altsteps and testcases */

void ExternalPDU_oid_encoder(const OBJID& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `objid' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OBJID_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExternalPDU_oid_decoder(OCTETSTRING& input_stream, OBJID& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `objid' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OBJID_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Dialog1_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Dialog1_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OCTETSTRING_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExternalPDU_dialog_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExternalPDU_dialog_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExternalPDU_dialog_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExternalPDU_dialog_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExternalPDU_encoder(const ExternalPDU& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ExternalPDU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExternalPDU_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExternalPDU_decoder(OCTETSTRING& input_stream, ExternalPDU& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ExternalPDU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExternalPDU_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const ComponentPortion& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @TCAPMessages.ComponentPortion.");
return other_value.val_ptr->n_elements == 0;
}

void InvokeIdType_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(InvokeIdType_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER InvokeIdType_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(InvokeIdType_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Invoke_invokeID_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Invoke_invokeID_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Invoke_invokeID_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Invoke_invokeID_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OPERATION_localValue_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OPERATION_localValue_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OPERATION_globalValue_encoder(const OBJID& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `objid' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OBJID_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OPERATION_globalValue_decoder(OCTETSTRING& input_stream, OBJID& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `objid' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OBJID_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OPERATION_encoder(const OPERATION& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.OPERATION' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OPERATION_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OPERATION_decoder(OCTETSTRING& input_stream, OPERATION& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.OPERATION' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OPERATION_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Invoke_opCode_encoder(const OPERATION& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.OPERATION' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OPERATION_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Invoke_opCode_decoder(OCTETSTRING& input_stream, OPERATION& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.OPERATION' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OPERATION_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Invoke_linkedID_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Invoke_linkedID_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Invoke_linkedID_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Invoke_linkedID_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Parameter_encoder(const ASN_ANY& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Parameter_decoder(OCTETSTRING& input_stream, ASN_ANY& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Invoke_parameter_encoder(const ASN_ANY& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Invoke_parameter_decoder(OCTETSTRING& input_stream, ASN_ANY& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Invoke_encoder(const Invoke& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Invoke' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Invoke_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Invoke_decoder(OCTETSTRING& input_stream, Invoke& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Invoke' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Invoke_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Component_invoke_encoder(const Invoke& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Invoke' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_invoke_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Component_invoke_decoder(OCTETSTRING& input_stream, Invoke& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Invoke' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_invoke_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnResult_invokeID_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ReturnResult_invokeID_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnResult_invokeID_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ReturnResult_invokeID_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnResult_resultretres_opCode_encoder(const OPERATION& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.OPERATION' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OPERATION_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnResult_resultretres_opCode_decoder(OCTETSTRING& input_stream, OPERATION& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.OPERATION' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OPERATION_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnResult_resultretres_parameter_encoder(const ASN_ANY& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnResult_resultretres_parameter_decoder(OCTETSTRING& input_stream, ASN_ANY& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnResult_resultretres_encoder(const ReturnResult_resultretres& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult.resultretres' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ReturnResult_resultretres_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnResult_resultretres_decoder(OCTETSTRING& input_stream, ReturnResult_resultretres& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult.resultretres' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ReturnResult_resultretres_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnResult_encoder(const ReturnResult& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ReturnResult_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnResult_decoder(OCTETSTRING& input_stream, ReturnResult& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ReturnResult_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Component_returnResultLast_encoder(const ReturnResult& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_returnResultLast_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Component_returnResultLast_decoder(OCTETSTRING& input_stream, ReturnResult& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_returnResultLast_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnError_invokeID_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ReturnError_invokeID_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnError_invokeID_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ReturnError_invokeID_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ErrorCode_nationaler_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ErrorCode_nationaler_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ErrorCode_nationaler_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ErrorCode_nationaler_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ErrorCode_privateer_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ErrorCode_privateer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ErrorCode_privateer_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ErrorCode_privateer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ErrorCode_encoder(const ErrorCode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ErrorCode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ErrorCode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ErrorCode_decoder(OCTETSTRING& input_stream, ErrorCode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ErrorCode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ErrorCode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnError_errorCode_encoder(const ErrorCode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ErrorCode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ErrorCode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnError_errorCode_decoder(OCTETSTRING& input_stream, ErrorCode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ErrorCode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ErrorCode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnError_parameter_encoder(const ASN_ANY& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnError_parameter_decoder(OCTETSTRING& input_stream, ASN_ANY& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `ANY' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ASN_ANY_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnError_encoder(const ReturnError& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnError' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ReturnError_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnError_decoder(OCTETSTRING& input_stream, ReturnError& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnError' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ReturnError_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Component_returnError_encoder(const ReturnError& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnError' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_returnError_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Component_returnError_decoder(OCTETSTRING& input_stream, ReturnError& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnError' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_returnError_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_invokeIDRej_derivable_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_invokeIDRej_derivable_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_invokeIDRej_derivable_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_invokeIDRej_derivable_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_invokeIDRej_not__derivable_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ASN_NULL_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_invokeIDRej_not__derivable_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ASN_NULL_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_invokeIDRej_encoder(const Reject_invokeIDRej& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject.invokeIDRej' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_invokeIDRej_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_invokeIDRej_decoder(OCTETSTRING& input_stream, Reject_invokeIDRej& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject.invokeIDRej' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_invokeIDRej_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void GeneralProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER GeneralProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_problem_generalProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_problem_generalProblem_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_problem_generalProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_problem_generalProblem_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void InvokeProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER InvokeProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_problem_invokeProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_problem_invokeProblem_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_problem_invokeProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_problem_invokeProblem_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnResultProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnResultProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_problem_returnResultProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_problem_returnResultProblem_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_problem_returnResultProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_problem_returnResultProblem_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ReturnErrorProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ReturnErrorProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(INTEGER_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_problem_returnErrorProblem_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_problem_returnErrorProblem_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_problem_returnErrorProblem_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_problem_returnErrorProblem_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_problem_encoder(const Reject_problem& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject.problem' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_problem_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_problem_decoder(OCTETSTRING& input_stream, Reject_problem& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject.problem' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_problem_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Reject_encoder(const Reject& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Reject_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Reject_decoder(OCTETSTRING& input_stream, Reject& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Reject_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Component_reject_encoder(const Reject& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_reject_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Component_reject_decoder(OCTETSTRING& input_stream, Reject& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Reject' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_reject_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Component_returnResultNotLast_encoder(const ReturnResult& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_returnResultNotLast_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Component_returnResultNotLast_decoder(OCTETSTRING& input_stream, ReturnResult& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.ReturnResult' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_returnResultNotLast_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void Component_encoder(const Component& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Component' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER Component_decoder(OCTETSTRING& input_stream, Component& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Component' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ComponentPortion_0_encoder(const Component& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Component' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(Component_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ComponentPortion_0_decoder(OCTETSTRING& input_stream, Component& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@TCAPMessages.Component' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(Component_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}


} /* end of namespace */
